// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `ApproveSkill` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ApproveSkillError {
    /// Kind of error that occurred.
    pub kind: ApproveSkillErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ApproveSkill` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ApproveSkillErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ApproveSkillError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ApproveSkillErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            ApproveSkillErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ApproveSkillErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ApproveSkillErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ApproveSkillError {
    fn code(&self) -> Option<&str> {
        ApproveSkillError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ApproveSkillError {
    /// Creates a new `ApproveSkillError`.
    pub fn new(kind: ApproveSkillErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ApproveSkillError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ApproveSkillErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ApproveSkillError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ApproveSkillErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ApproveSkillErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            ApproveSkillErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `ApproveSkillErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ApproveSkillErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `ApproveSkillErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ApproveSkillErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ApproveSkillError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ApproveSkillErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            ApproveSkillErrorKind::LimitExceededException(_inner) => Some(_inner),
            ApproveSkillErrorKind::NotFoundException(_inner) => Some(_inner),
            ApproveSkillErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateContactWithAddressBook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateContactWithAddressBookError {
    /// Kind of error that occurred.
    pub kind: AssociateContactWithAddressBookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateContactWithAddressBook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateContactWithAddressBookErrorKind {
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateContactWithAddressBookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateContactWithAddressBookErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            AssociateContactWithAddressBookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateContactWithAddressBookError {
    fn code(&self) -> Option<&str> {
        AssociateContactWithAddressBookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateContactWithAddressBookError {
    /// Creates a new `AssociateContactWithAddressBookError`.
    pub fn new(
        kind: AssociateContactWithAddressBookErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateContactWithAddressBookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateContactWithAddressBookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateContactWithAddressBookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateContactWithAddressBookErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateContactWithAddressBookErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateContactWithAddressBookErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for AssociateContactWithAddressBookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateContactWithAddressBookErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            AssociateContactWithAddressBookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateDeviceWithNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateDeviceWithNetworkProfileError {
    /// Kind of error that occurred.
    pub kind: AssociateDeviceWithNetworkProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateDeviceWithNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateDeviceWithNetworkProfileErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request failed because this device is no longer registered and therefore no longer managed by this account.</p>
    DeviceNotRegisteredException(crate::error::DeviceNotRegisteredException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateDeviceWithNetworkProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateDeviceWithNetworkProfileErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateDeviceWithNetworkProfileErrorKind::DeviceNotRegisteredException(_inner) => {
                _inner.fmt(f)
            }
            AssociateDeviceWithNetworkProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AssociateDeviceWithNetworkProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateDeviceWithNetworkProfileError {
    fn code(&self) -> Option<&str> {
        AssociateDeviceWithNetworkProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateDeviceWithNetworkProfileError {
    /// Creates a new `AssociateDeviceWithNetworkProfileError`.
    pub fn new(
        kind: AssociateDeviceWithNetworkProfileErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateDeviceWithNetworkProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateDeviceWithNetworkProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateDeviceWithNetworkProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateDeviceWithNetworkProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateDeviceWithNetworkProfileErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDeviceWithNetworkProfileErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `AssociateDeviceWithNetworkProfileErrorKind::DeviceNotRegisteredException`.
    pub fn is_device_not_registered_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDeviceWithNetworkProfileErrorKind::DeviceNotRegisteredException(_)
        )
    }
    /// Returns true if the error kind is `AssociateDeviceWithNetworkProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDeviceWithNetworkProfileErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateDeviceWithNetworkProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateDeviceWithNetworkProfileErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            AssociateDeviceWithNetworkProfileErrorKind::DeviceNotRegisteredException(_inner) => {
                Some(_inner)
            }
            AssociateDeviceWithNetworkProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            AssociateDeviceWithNetworkProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateDeviceWithRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateDeviceWithRoomError {
    /// Kind of error that occurred.
    pub kind: AssociateDeviceWithRoomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateDeviceWithRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateDeviceWithRoomErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request failed because this device is no longer registered and therefore no longer managed by this account.</p>
    DeviceNotRegisteredException(crate::error::DeviceNotRegisteredException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateDeviceWithRoomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateDeviceWithRoomErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateDeviceWithRoomErrorKind::DeviceNotRegisteredException(_inner) => _inner.fmt(f),
            AssociateDeviceWithRoomErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AssociateDeviceWithRoomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateDeviceWithRoomError {
    fn code(&self) -> Option<&str> {
        AssociateDeviceWithRoomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateDeviceWithRoomError {
    /// Creates a new `AssociateDeviceWithRoomError`.
    pub fn new(kind: AssociateDeviceWithRoomErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateDeviceWithRoomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateDeviceWithRoomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateDeviceWithRoomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateDeviceWithRoomErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateDeviceWithRoomErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDeviceWithRoomErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `AssociateDeviceWithRoomErrorKind::DeviceNotRegisteredException`.
    pub fn is_device_not_registered_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDeviceWithRoomErrorKind::DeviceNotRegisteredException(_)
        )
    }
    /// Returns true if the error kind is `AssociateDeviceWithRoomErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDeviceWithRoomErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for AssociateDeviceWithRoomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateDeviceWithRoomErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            AssociateDeviceWithRoomErrorKind::DeviceNotRegisteredException(_inner) => Some(_inner),
            AssociateDeviceWithRoomErrorKind::LimitExceededException(_inner) => Some(_inner),
            AssociateDeviceWithRoomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateSkillGroupWithRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateSkillGroupWithRoomError {
    /// Kind of error that occurred.
    pub kind: AssociateSkillGroupWithRoomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateSkillGroupWithRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateSkillGroupWithRoomErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateSkillGroupWithRoomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateSkillGroupWithRoomErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateSkillGroupWithRoomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateSkillGroupWithRoomError {
    fn code(&self) -> Option<&str> {
        AssociateSkillGroupWithRoomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateSkillGroupWithRoomError {
    /// Creates a new `AssociateSkillGroupWithRoomError`.
    pub fn new(kind: AssociateSkillGroupWithRoomErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateSkillGroupWithRoomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateSkillGroupWithRoomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateSkillGroupWithRoomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateSkillGroupWithRoomErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateSkillGroupWithRoomErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSkillGroupWithRoomErrorKind::ConcurrentModificationException(_)
        )
    }
}
impl std::error::Error for AssociateSkillGroupWithRoomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateSkillGroupWithRoomErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            AssociateSkillGroupWithRoomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateSkillWithSkillGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateSkillWithSkillGroupError {
    /// Kind of error that occurred.
    pub kind: AssociateSkillWithSkillGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateSkillWithSkillGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateSkillWithSkillGroupErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The skill must be linked to a third-party account.</p>
    SkillNotLinkedException(crate::error::SkillNotLinkedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateSkillWithSkillGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateSkillWithSkillGroupErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateSkillWithSkillGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AssociateSkillWithSkillGroupErrorKind::SkillNotLinkedException(_inner) => _inner.fmt(f),
            AssociateSkillWithSkillGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateSkillWithSkillGroupError {
    fn code(&self) -> Option<&str> {
        AssociateSkillWithSkillGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateSkillWithSkillGroupError {
    /// Creates a new `AssociateSkillWithSkillGroupError`.
    pub fn new(kind: AssociateSkillWithSkillGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateSkillWithSkillGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateSkillWithSkillGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateSkillWithSkillGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateSkillWithSkillGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateSkillWithSkillGroupErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSkillWithSkillGroupErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `AssociateSkillWithSkillGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSkillWithSkillGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AssociateSkillWithSkillGroupErrorKind::SkillNotLinkedException`.
    pub fn is_skill_not_linked_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSkillWithSkillGroupErrorKind::SkillNotLinkedException(_)
        )
    }
}
impl std::error::Error for AssociateSkillWithSkillGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateSkillWithSkillGroupErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            AssociateSkillWithSkillGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            AssociateSkillWithSkillGroupErrorKind::SkillNotLinkedException(_inner) => Some(_inner),
            AssociateSkillWithSkillGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateSkillWithUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateSkillWithUsersError {
    /// Kind of error that occurred.
    pub kind: AssociateSkillWithUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateSkillWithUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateSkillWithUsersErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateSkillWithUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateSkillWithUsersErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateSkillWithUsersErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AssociateSkillWithUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateSkillWithUsersError {
    fn code(&self) -> Option<&str> {
        AssociateSkillWithUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateSkillWithUsersError {
    /// Creates a new `AssociateSkillWithUsersError`.
    pub fn new(kind: AssociateSkillWithUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateSkillWithUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateSkillWithUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateSkillWithUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateSkillWithUsersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateSkillWithUsersErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSkillWithUsersErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `AssociateSkillWithUsersErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSkillWithUsersErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateSkillWithUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateSkillWithUsersErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            AssociateSkillWithUsersErrorKind::NotFoundException(_inner) => Some(_inner),
            AssociateSkillWithUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAddressBook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAddressBookError {
    /// Kind of error that occurred.
    pub kind: CreateAddressBookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAddressBook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAddressBookErrorKind {
    /// <p>The resource being created already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAddressBookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAddressBookErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateAddressBookErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAddressBookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAddressBookError {
    fn code(&self) -> Option<&str> {
        CreateAddressBookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAddressBookError {
    /// Creates a new `CreateAddressBookError`.
    pub fn new(kind: CreateAddressBookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAddressBookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAddressBookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAddressBookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAddressBookErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateAddressBookErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAddressBookErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateAddressBookErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAddressBookErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateAddressBookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAddressBookErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateAddressBookErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAddressBookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBusinessReportSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBusinessReportScheduleError {
    /// Kind of error that occurred.
    pub kind: CreateBusinessReportScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBusinessReportSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBusinessReportScheduleErrorKind {
    /// <p>The resource being created already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBusinessReportScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBusinessReportScheduleErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateBusinessReportScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBusinessReportScheduleError {
    fn code(&self) -> Option<&str> {
        CreateBusinessReportScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBusinessReportScheduleError {
    /// Creates a new `CreateBusinessReportScheduleError`.
    pub fn new(kind: CreateBusinessReportScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBusinessReportScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBusinessReportScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBusinessReportScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBusinessReportScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateBusinessReportScheduleErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBusinessReportScheduleErrorKind::AlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateBusinessReportScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBusinessReportScheduleErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateBusinessReportScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConferenceProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConferenceProviderError {
    /// Kind of error that occurred.
    pub kind: CreateConferenceProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConferenceProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConferenceProviderErrorKind {
    /// <p>The resource being created already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConferenceProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConferenceProviderErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateConferenceProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConferenceProviderError {
    fn code(&self) -> Option<&str> {
        CreateConferenceProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConferenceProviderError {
    /// Creates a new `CreateConferenceProviderError`.
    pub fn new(kind: CreateConferenceProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConferenceProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConferenceProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConferenceProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConferenceProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateConferenceProviderErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConferenceProviderErrorKind::AlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateConferenceProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConferenceProviderErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateConferenceProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateContactError {
    /// Kind of error that occurred.
    pub kind: CreateContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateContactErrorKind {
    /// <p>The resource being created already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateContactErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateContactErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateContactError {
    fn code(&self) -> Option<&str> {
        CreateContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateContactError {
    /// Creates a new `CreateContactError`.
    pub fn new(kind: CreateContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateContactErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateContactErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateContactErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateContactErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGatewayGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGatewayGroupError {
    /// Kind of error that occurred.
    pub kind: CreateGatewayGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGatewayGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGatewayGroupErrorKind {
    /// <p>The resource being created already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGatewayGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGatewayGroupErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateGatewayGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateGatewayGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGatewayGroupError {
    fn code(&self) -> Option<&str> {
        CreateGatewayGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGatewayGroupError {
    /// Creates a new `CreateGatewayGroupError`.
    pub fn new(kind: CreateGatewayGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGatewayGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGatewayGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGatewayGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGatewayGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateGatewayGroupErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayGroupErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateGatewayGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayGroupErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateGatewayGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGatewayGroupErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateGatewayGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateGatewayGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateNetworkProfileError {
    /// Kind of error that occurred.
    pub kind: CreateNetworkProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateNetworkProfileErrorKind {
    /// <p>The resource being created already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The Certificate Authority can't issue or revoke a certificate.</p>
    InvalidCertificateAuthorityException(crate::error::InvalidCertificateAuthorityException),
    /// <p>The service linked role is locked for deletion. </p>
    InvalidServiceLinkedRoleStateException(crate::error::InvalidServiceLinkedRoleStateException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateNetworkProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateNetworkProfileErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateNetworkProfileErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateNetworkProfileErrorKind::InvalidCertificateAuthorityException(_inner) => {
                _inner.fmt(f)
            }
            CreateNetworkProfileErrorKind::InvalidServiceLinkedRoleStateException(_inner) => {
                _inner.fmt(f)
            }
            CreateNetworkProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateNetworkProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateNetworkProfileError {
    fn code(&self) -> Option<&str> {
        CreateNetworkProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateNetworkProfileError {
    /// Creates a new `CreateNetworkProfileError`.
    pub fn new(kind: CreateNetworkProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateNetworkProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateNetworkProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateNetworkProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateNetworkProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateNetworkProfileErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkProfileErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateNetworkProfileErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkProfileErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `CreateNetworkProfileErrorKind::InvalidCertificateAuthorityException`.
    pub fn is_invalid_certificate_authority_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkProfileErrorKind::InvalidCertificateAuthorityException(_)
        )
    }
    /// Returns true if the error kind is `CreateNetworkProfileErrorKind::InvalidServiceLinkedRoleStateException`.
    pub fn is_invalid_service_linked_role_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkProfileErrorKind::InvalidServiceLinkedRoleStateException(_)
        )
    }
    /// Returns true if the error kind is `CreateNetworkProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkProfileErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateNetworkProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateNetworkProfileErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateNetworkProfileErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateNetworkProfileErrorKind::InvalidCertificateAuthorityException(_inner) => {
                Some(_inner)
            }
            CreateNetworkProfileErrorKind::InvalidServiceLinkedRoleStateException(_inner) => {
                Some(_inner)
            }
            CreateNetworkProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateNetworkProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProfileError {
    /// Kind of error that occurred.
    pub kind: CreateProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProfileErrorKind {
    /// <p>The resource being created already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProfileErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateProfileErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProfileError {
    fn code(&self) -> Option<&str> {
        CreateProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProfileError {
    /// Creates a new `CreateProfileError`.
    pub fn new(kind: CreateProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateProfileErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProfileErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateProfileErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProfileErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `CreateProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProfileErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProfileErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateProfileErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRoomError {
    /// Kind of error that occurred.
    pub kind: CreateRoomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRoomErrorKind {
    /// <p>The resource being created already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRoomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRoomErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateRoomErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateRoomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRoomError {
    fn code(&self) -> Option<&str> {
        CreateRoomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRoomError {
    /// Creates a new `CreateRoomError`.
    pub fn new(kind: CreateRoomErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRoomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRoomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRoomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRoomErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateRoomErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(&self.kind, CreateRoomErrorKind::AlreadyExistsException(_))
    }
    /// Returns true if the error kind is `CreateRoomErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateRoomErrorKind::LimitExceededException(_))
    }
}
impl std::error::Error for CreateRoomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRoomErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateRoomErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateRoomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSkillGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSkillGroupError {
    /// Kind of error that occurred.
    pub kind: CreateSkillGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSkillGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSkillGroupErrorKind {
    /// <p>The resource being created already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSkillGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSkillGroupErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateSkillGroupErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateSkillGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateSkillGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSkillGroupError {
    fn code(&self) -> Option<&str> {
        CreateSkillGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSkillGroupError {
    /// Creates a new `CreateSkillGroupError`.
    pub fn new(kind: CreateSkillGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSkillGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSkillGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSkillGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSkillGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateSkillGroupErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSkillGroupErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateSkillGroupErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSkillGroupErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `CreateSkillGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSkillGroupErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateSkillGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSkillGroupErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateSkillGroupErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateSkillGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateSkillGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserError {
    /// Kind of error that occurred.
    pub kind: CreateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource in the request is already in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserError {
    fn code(&self) -> Option<&str> {
        CreateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserError {
    /// Creates a new `CreateUserError`.
    pub fn new(kind: CreateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateUserErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `CreateUserErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateUserErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ResourceInUseException(_))
    }
}
impl std::error::Error for CreateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateUserErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUserErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAddressBook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAddressBookError {
    /// Kind of error that occurred.
    pub kind: DeleteAddressBookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAddressBook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAddressBookErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAddressBookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAddressBookErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteAddressBookErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAddressBookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAddressBookError {
    fn code(&self) -> Option<&str> {
        DeleteAddressBookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAddressBookError {
    /// Creates a new `DeleteAddressBookError`.
    pub fn new(kind: DeleteAddressBookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAddressBookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAddressBookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAddressBookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAddressBookErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAddressBookErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAddressBookErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAddressBookErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAddressBookErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteAddressBookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAddressBookErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteAddressBookErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAddressBookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBusinessReportSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBusinessReportScheduleError {
    /// Kind of error that occurred.
    pub kind: DeleteBusinessReportScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBusinessReportSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBusinessReportScheduleErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBusinessReportScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBusinessReportScheduleErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBusinessReportScheduleErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBusinessReportScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBusinessReportScheduleError {
    fn code(&self) -> Option<&str> {
        DeleteBusinessReportScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBusinessReportScheduleError {
    /// Creates a new `DeleteBusinessReportScheduleError`.
    pub fn new(kind: DeleteBusinessReportScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBusinessReportScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBusinessReportScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBusinessReportScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBusinessReportScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteBusinessReportScheduleErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBusinessReportScheduleErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteBusinessReportScheduleErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBusinessReportScheduleErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteBusinessReportScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBusinessReportScheduleErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DeleteBusinessReportScheduleErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBusinessReportScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConferenceProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConferenceProviderError {
    /// Kind of error that occurred.
    pub kind: DeleteConferenceProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConferenceProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConferenceProviderErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConferenceProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConferenceProviderErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteConferenceProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConferenceProviderError {
    fn code(&self) -> Option<&str> {
        DeleteConferenceProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConferenceProviderError {
    /// Creates a new `DeleteConferenceProviderError`.
    pub fn new(kind: DeleteConferenceProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConferenceProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConferenceProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConferenceProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConferenceProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteConferenceProviderErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConferenceProviderErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteConferenceProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConferenceProviderErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteConferenceProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteContactError {
    /// Kind of error that occurred.
    pub kind: DeleteContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteContactErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteContactErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteContactErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteContactError {
    fn code(&self) -> Option<&str> {
        DeleteContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteContactError {
    /// Creates a new `DeleteContactError`.
    pub fn new(kind: DeleteContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteContactErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteContactErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteContactErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteContactErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteContactErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDeviceError {
    /// Kind of error that occurred.
    pub kind: DeleteDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDeviceErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The Certificate Authority can't issue or revoke a certificate.</p>
    InvalidCertificateAuthorityException(crate::error::InvalidCertificateAuthorityException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDeviceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::InvalidCertificateAuthorityException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDeviceError {
    fn code(&self) -> Option<&str> {
        DeleteDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDeviceError {
    /// Creates a new `DeleteDeviceError`.
    pub fn new(kind: DeleteDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDeviceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDeviceErrorKind::InvalidCertificateAuthorityException`.
    pub fn is_invalid_certificate_authority_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceErrorKind::InvalidCertificateAuthorityException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDeviceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteDeviceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDeviceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::InvalidCertificateAuthorityException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDeviceUsageData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDeviceUsageDataError {
    /// Kind of error that occurred.
    pub kind: DeleteDeviceUsageDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDeviceUsageData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDeviceUsageDataErrorKind {
    /// <p>The request failed because this device is no longer registered and therefore no longer managed by this account.</p>
    DeviceNotRegisteredException(crate::error::DeviceNotRegisteredException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDeviceUsageDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDeviceUsageDataErrorKind::DeviceNotRegisteredException(_inner) => _inner.fmt(f),
            DeleteDeviceUsageDataErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteDeviceUsageDataErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDeviceUsageDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDeviceUsageDataError {
    fn code(&self) -> Option<&str> {
        DeleteDeviceUsageDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDeviceUsageDataError {
    /// Creates a new `DeleteDeviceUsageDataError`.
    pub fn new(kind: DeleteDeviceUsageDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDeviceUsageDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDeviceUsageDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDeviceUsageDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDeviceUsageDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDeviceUsageDataErrorKind::DeviceNotRegisteredException`.
    pub fn is_device_not_registered_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceUsageDataErrorKind::DeviceNotRegisteredException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDeviceUsageDataErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceUsageDataErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDeviceUsageDataErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceUsageDataErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteDeviceUsageDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDeviceUsageDataErrorKind::DeviceNotRegisteredException(_inner) => Some(_inner),
            DeleteDeviceUsageDataErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteDeviceUsageDataErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDeviceUsageDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGatewayGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGatewayGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteGatewayGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGatewayGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGatewayGroupErrorKind {
    /// <p>Another resource is associated with the resource in the request.</p>
    ResourceAssociatedException(crate::error::ResourceAssociatedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGatewayGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGatewayGroupErrorKind::ResourceAssociatedException(_inner) => _inner.fmt(f),
            DeleteGatewayGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGatewayGroupError {
    fn code(&self) -> Option<&str> {
        DeleteGatewayGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGatewayGroupError {
    /// Creates a new `DeleteGatewayGroupError`.
    pub fn new(kind: DeleteGatewayGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGatewayGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGatewayGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGatewayGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGatewayGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteGatewayGroupErrorKind::ResourceAssociatedException`.
    pub fn is_resource_associated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayGroupErrorKind::ResourceAssociatedException(_)
        )
    }
}
impl std::error::Error for DeleteGatewayGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGatewayGroupErrorKind::ResourceAssociatedException(_inner) => Some(_inner),
            DeleteGatewayGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteNetworkProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteNetworkProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteNetworkProfileErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The resource in the request is already in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteNetworkProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteNetworkProfileErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteNetworkProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteNetworkProfileErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteNetworkProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteNetworkProfileError {
    fn code(&self) -> Option<&str> {
        DeleteNetworkProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteNetworkProfileError {
    /// Creates a new `DeleteNetworkProfileError`.
    pub fn new(kind: DeleteNetworkProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteNetworkProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteNetworkProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteNetworkProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteNetworkProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteNetworkProfileErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkProfileErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteNetworkProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkProfileErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteNetworkProfileErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkProfileErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteNetworkProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteNetworkProfileErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteNetworkProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteNetworkProfileErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteNetworkProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProfileErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProfileErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProfileError {
    fn code(&self) -> Option<&str> {
        DeleteProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProfileError {
    /// Creates a new `DeleteProfileError`.
    pub fn new(kind: DeleteProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteProfileErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteProfileErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProfileErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRoomError {
    /// Kind of error that occurred.
    pub kind: DeleteRoomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRoomErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRoomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRoomErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteRoomErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRoomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRoomError {
    fn code(&self) -> Option<&str> {
        DeleteRoomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRoomError {
    /// Creates a new `DeleteRoomError`.
    pub fn new(kind: DeleteRoomErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRoomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRoomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRoomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRoomErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRoomErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoomErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRoomErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteRoomErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteRoomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRoomErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteRoomErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRoomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRoomSkillParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRoomSkillParameterError {
    /// Kind of error that occurred.
    pub kind: DeleteRoomSkillParameterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRoomSkillParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRoomSkillParameterErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRoomSkillParameterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRoomSkillParameterErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRoomSkillParameterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRoomSkillParameterError {
    fn code(&self) -> Option<&str> {
        DeleteRoomSkillParameterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRoomSkillParameterError {
    /// Creates a new `DeleteRoomSkillParameterError`.
    pub fn new(kind: DeleteRoomSkillParameterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRoomSkillParameterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRoomSkillParameterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRoomSkillParameterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRoomSkillParameterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRoomSkillParameterErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoomSkillParameterErrorKind::ConcurrentModificationException(_)
        )
    }
}
impl std::error::Error for DeleteRoomSkillParameterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRoomSkillParameterErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DeleteRoomSkillParameterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSkillAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSkillAuthorizationError {
    /// Kind of error that occurred.
    pub kind: DeleteSkillAuthorizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSkillAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSkillAuthorizationErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSkillAuthorizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSkillAuthorizationErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteSkillAuthorizationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSkillAuthorizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSkillAuthorizationError {
    fn code(&self) -> Option<&str> {
        DeleteSkillAuthorizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSkillAuthorizationError {
    /// Creates a new `DeleteSkillAuthorizationError`.
    pub fn new(kind: DeleteSkillAuthorizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSkillAuthorizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSkillAuthorizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSkillAuthorizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSkillAuthorizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteSkillAuthorizationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSkillAuthorizationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSkillAuthorizationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSkillAuthorizationErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteSkillAuthorizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSkillAuthorizationErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DeleteSkillAuthorizationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSkillAuthorizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSkillGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSkillGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteSkillGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSkillGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSkillGroupErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSkillGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSkillGroupErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteSkillGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSkillGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSkillGroupError {
    fn code(&self) -> Option<&str> {
        DeleteSkillGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSkillGroupError {
    /// Creates a new `DeleteSkillGroupError`.
    pub fn new(kind: DeleteSkillGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSkillGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSkillGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSkillGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSkillGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteSkillGroupErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSkillGroupErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSkillGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteSkillGroupErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteSkillGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSkillGroupErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteSkillGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSkillGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserError {
    /// Kind of error that occurred.
    pub kind: DeleteUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserError {
    fn code(&self) -> Option<&str> {
        DeleteUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserError {
    /// Creates a new `DeleteUserError`.
    pub fn new(kind: DeleteUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteUserErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteUserErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteUserErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateContactFromAddressBook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateContactFromAddressBookError {
    /// Kind of error that occurred.
    pub kind: DisassociateContactFromAddressBookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateContactFromAddressBook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateContactFromAddressBookErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateContactFromAddressBookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateContactFromAddressBookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateContactFromAddressBookError {
    fn code(&self) -> Option<&str> {
        DisassociateContactFromAddressBookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateContactFromAddressBookError {
    /// Creates a new `DisassociateContactFromAddressBookError`.
    pub fn new(
        kind: DisassociateContactFromAddressBookErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateContactFromAddressBookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateContactFromAddressBookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateContactFromAddressBookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateContactFromAddressBookErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DisassociateContactFromAddressBookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateContactFromAddressBookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateDeviceFromRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateDeviceFromRoomError {
    /// Kind of error that occurred.
    pub kind: DisassociateDeviceFromRoomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateDeviceFromRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateDeviceFromRoomErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request failed because this device is no longer registered and therefore no longer managed by this account.</p>
    DeviceNotRegisteredException(crate::error::DeviceNotRegisteredException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateDeviceFromRoomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateDeviceFromRoomErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateDeviceFromRoomErrorKind::DeviceNotRegisteredException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateDeviceFromRoomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateDeviceFromRoomError {
    fn code(&self) -> Option<&str> {
        DisassociateDeviceFromRoomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateDeviceFromRoomError {
    /// Creates a new `DisassociateDeviceFromRoomError`.
    pub fn new(kind: DisassociateDeviceFromRoomErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateDeviceFromRoomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateDeviceFromRoomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateDeviceFromRoomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateDeviceFromRoomErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateDeviceFromRoomErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDeviceFromRoomErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateDeviceFromRoomErrorKind::DeviceNotRegisteredException`.
    pub fn is_device_not_registered_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDeviceFromRoomErrorKind::DeviceNotRegisteredException(_)
        )
    }
}
impl std::error::Error for DisassociateDeviceFromRoomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateDeviceFromRoomErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DisassociateDeviceFromRoomErrorKind::DeviceNotRegisteredException(_inner) => {
                Some(_inner)
            }
            DisassociateDeviceFromRoomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateSkillFromSkillGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateSkillFromSkillGroupError {
    /// Kind of error that occurred.
    pub kind: DisassociateSkillFromSkillGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateSkillFromSkillGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateSkillFromSkillGroupErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateSkillFromSkillGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateSkillFromSkillGroupErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateSkillFromSkillGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DisassociateSkillFromSkillGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateSkillFromSkillGroupError {
    fn code(&self) -> Option<&str> {
        DisassociateSkillFromSkillGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateSkillFromSkillGroupError {
    /// Creates a new `DisassociateSkillFromSkillGroupError`.
    pub fn new(
        kind: DisassociateSkillFromSkillGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateSkillFromSkillGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateSkillFromSkillGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateSkillFromSkillGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateSkillFromSkillGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateSkillFromSkillGroupErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSkillFromSkillGroupErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateSkillFromSkillGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSkillFromSkillGroupErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociateSkillFromSkillGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateSkillFromSkillGroupErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DisassociateSkillFromSkillGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            DisassociateSkillFromSkillGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateSkillFromUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateSkillFromUsersError {
    /// Kind of error that occurred.
    pub kind: DisassociateSkillFromUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateSkillFromUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateSkillFromUsersErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateSkillFromUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateSkillFromUsersErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateSkillFromUsersErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DisassociateSkillFromUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateSkillFromUsersError {
    fn code(&self) -> Option<&str> {
        DisassociateSkillFromUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateSkillFromUsersError {
    /// Creates a new `DisassociateSkillFromUsersError`.
    pub fn new(kind: DisassociateSkillFromUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateSkillFromUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateSkillFromUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateSkillFromUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateSkillFromUsersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateSkillFromUsersErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSkillFromUsersErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateSkillFromUsersErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSkillFromUsersErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociateSkillFromUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateSkillFromUsersErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DisassociateSkillFromUsersErrorKind::NotFoundException(_inner) => Some(_inner),
            DisassociateSkillFromUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateSkillGroupFromRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateSkillGroupFromRoomError {
    /// Kind of error that occurred.
    pub kind: DisassociateSkillGroupFromRoomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateSkillGroupFromRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateSkillGroupFromRoomErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateSkillGroupFromRoomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateSkillGroupFromRoomErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateSkillGroupFromRoomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateSkillGroupFromRoomError {
    fn code(&self) -> Option<&str> {
        DisassociateSkillGroupFromRoomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateSkillGroupFromRoomError {
    /// Creates a new `DisassociateSkillGroupFromRoomError`.
    pub fn new(
        kind: DisassociateSkillGroupFromRoomErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateSkillGroupFromRoomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateSkillGroupFromRoomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateSkillGroupFromRoomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateSkillGroupFromRoomErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateSkillGroupFromRoomErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSkillGroupFromRoomErrorKind::ConcurrentModificationException(_)
        )
    }
}
impl std::error::Error for DisassociateSkillGroupFromRoomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateSkillGroupFromRoomErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DisassociateSkillGroupFromRoomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ForgetSmartHomeAppliances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ForgetSmartHomeAppliancesError {
    /// Kind of error that occurred.
    pub kind: ForgetSmartHomeAppliancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ForgetSmartHomeAppliances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ForgetSmartHomeAppliancesErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ForgetSmartHomeAppliancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ForgetSmartHomeAppliancesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ForgetSmartHomeAppliancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ForgetSmartHomeAppliancesError {
    fn code(&self) -> Option<&str> {
        ForgetSmartHomeAppliancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ForgetSmartHomeAppliancesError {
    /// Creates a new `ForgetSmartHomeAppliancesError`.
    pub fn new(kind: ForgetSmartHomeAppliancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ForgetSmartHomeAppliancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ForgetSmartHomeAppliancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ForgetSmartHomeAppliancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ForgetSmartHomeAppliancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ForgetSmartHomeAppliancesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ForgetSmartHomeAppliancesErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ForgetSmartHomeAppliancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ForgetSmartHomeAppliancesErrorKind::NotFoundException(_inner) => Some(_inner),
            ForgetSmartHomeAppliancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAddressBook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAddressBookError {
    /// Kind of error that occurred.
    pub kind: GetAddressBookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAddressBook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAddressBookErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAddressBookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAddressBookErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAddressBookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAddressBookError {
    fn code(&self) -> Option<&str> {
        GetAddressBookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAddressBookError {
    /// Creates a new `GetAddressBookError`.
    pub fn new(kind: GetAddressBookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAddressBookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAddressBookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAddressBookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAddressBookErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAddressBookErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAddressBookErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetAddressBookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAddressBookErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAddressBookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConferencePreference` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConferencePreferenceError {
    /// Kind of error that occurred.
    pub kind: GetConferencePreferenceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConferencePreference` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConferencePreferenceErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConferencePreferenceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConferencePreferenceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetConferencePreferenceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConferencePreferenceError {
    fn code(&self) -> Option<&str> {
        GetConferencePreferenceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConferencePreferenceError {
    /// Creates a new `GetConferencePreferenceError`.
    pub fn new(kind: GetConferencePreferenceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConferencePreferenceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConferencePreferenceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConferencePreferenceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConferencePreferenceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetConferencePreferenceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConferencePreferenceErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GetConferencePreferenceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConferencePreferenceErrorKind::NotFoundException(_inner) => Some(_inner),
            GetConferencePreferenceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConferenceProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConferenceProviderError {
    /// Kind of error that occurred.
    pub kind: GetConferenceProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConferenceProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConferenceProviderErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConferenceProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConferenceProviderErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetConferenceProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConferenceProviderError {
    fn code(&self) -> Option<&str> {
        GetConferenceProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConferenceProviderError {
    /// Creates a new `GetConferenceProviderError`.
    pub fn new(kind: GetConferenceProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConferenceProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConferenceProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConferenceProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConferenceProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetConferenceProviderErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConferenceProviderErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GetConferenceProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConferenceProviderErrorKind::NotFoundException(_inner) => Some(_inner),
            GetConferenceProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContactError {
    /// Kind of error that occurred.
    pub kind: GetContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContactErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContactErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContactError {
    fn code(&self) -> Option<&str> {
        GetContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContactError {
    /// Creates a new `GetContactError`.
    pub fn new(kind: GetContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetContactErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetContactErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContactErrorKind::NotFoundException(_inner) => Some(_inner),
            GetContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeviceError {
    /// Kind of error that occurred.
    pub kind: GetDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeviceErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeviceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeviceError {
    fn code(&self) -> Option<&str> {
        GetDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeviceError {
    /// Creates a new `GetDeviceError`.
    pub fn new(kind: GetDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDeviceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDeviceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeviceErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGatewayError {
    /// Kind of error that occurred.
    pub kind: GetGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGatewayErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGatewayErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGatewayError {
    fn code(&self) -> Option<&str> {
        GetGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGatewayError {
    /// Creates a new `GetGatewayError`.
    pub fn new(kind: GetGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetGatewayErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetGatewayErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGatewayErrorKind::NotFoundException(_inner) => Some(_inner),
            GetGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGatewayGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGatewayGroupError {
    /// Kind of error that occurred.
    pub kind: GetGatewayGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGatewayGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGatewayGroupErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGatewayGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGatewayGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetGatewayGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGatewayGroupError {
    fn code(&self) -> Option<&str> {
        GetGatewayGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGatewayGroupError {
    /// Creates a new `GetGatewayGroupError`.
    pub fn new(kind: GetGatewayGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGatewayGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGatewayGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGatewayGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGatewayGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetGatewayGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetGatewayGroupErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetGatewayGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGatewayGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            GetGatewayGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInvitationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInvitationConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetInvitationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInvitationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInvitationConfigurationErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInvitationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInvitationConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInvitationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInvitationConfigurationError {
    fn code(&self) -> Option<&str> {
        GetInvitationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInvitationConfigurationError {
    /// Creates a new `GetInvitationConfigurationError`.
    pub fn new(kind: GetInvitationConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInvitationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInvitationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInvitationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInvitationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetInvitationConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInvitationConfigurationErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GetInvitationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInvitationConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInvitationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNetworkProfileError {
    /// Kind of error that occurred.
    pub kind: GetNetworkProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNetworkProfileErrorKind {
    /// <p>A password in SecretsManager is in an invalid state.</p>
    InvalidSecretsManagerResourceException(crate::error::InvalidSecretsManagerResourceException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNetworkProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNetworkProfileErrorKind::InvalidSecretsManagerResourceException(_inner) => {
                _inner.fmt(f)
            }
            GetNetworkProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetNetworkProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNetworkProfileError {
    fn code(&self) -> Option<&str> {
        GetNetworkProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNetworkProfileError {
    /// Creates a new `GetNetworkProfileError`.
    pub fn new(kind: GetNetworkProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNetworkProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNetworkProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNetworkProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNetworkProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetNetworkProfileErrorKind::InvalidSecretsManagerResourceException`.
    pub fn is_invalid_secrets_manager_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkProfileErrorKind::InvalidSecretsManagerResourceException(_)
        )
    }
    /// Returns true if the error kind is `GetNetworkProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetNetworkProfileErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetNetworkProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNetworkProfileErrorKind::InvalidSecretsManagerResourceException(_inner) => {
                Some(_inner)
            }
            GetNetworkProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            GetNetworkProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProfileError {
    /// Kind of error that occurred.
    pub kind: GetProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProfileErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProfileError {
    fn code(&self) -> Option<&str> {
        GetProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetProfileError {
    /// Creates a new `GetProfileError`.
    pub fn new(kind: GetProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetProfileErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            GetProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRoomError {
    /// Kind of error that occurred.
    pub kind: GetRoomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRoomErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRoomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRoomErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRoomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRoomError {
    fn code(&self) -> Option<&str> {
        GetRoomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRoomError {
    /// Creates a new `GetRoomError`.
    pub fn new(kind: GetRoomErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRoomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRoomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRoomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRoomErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRoomErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRoomErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetRoomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRoomErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRoomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRoomSkillParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRoomSkillParameterError {
    /// Kind of error that occurred.
    pub kind: GetRoomSkillParameterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRoomSkillParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRoomSkillParameterErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRoomSkillParameterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRoomSkillParameterErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRoomSkillParameterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRoomSkillParameterError {
    fn code(&self) -> Option<&str> {
        GetRoomSkillParameterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRoomSkillParameterError {
    /// Creates a new `GetRoomSkillParameterError`.
    pub fn new(kind: GetRoomSkillParameterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRoomSkillParameterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRoomSkillParameterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRoomSkillParameterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRoomSkillParameterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRoomSkillParameterErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRoomSkillParameterErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GetRoomSkillParameterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRoomSkillParameterErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRoomSkillParameterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSkillGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSkillGroupError {
    /// Kind of error that occurred.
    pub kind: GetSkillGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSkillGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSkillGroupErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSkillGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSkillGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSkillGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSkillGroupError {
    fn code(&self) -> Option<&str> {
        GetSkillGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSkillGroupError {
    /// Creates a new `GetSkillGroupError`.
    pub fn new(kind: GetSkillGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSkillGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSkillGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSkillGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSkillGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetSkillGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSkillGroupErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetSkillGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSkillGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSkillGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBusinessReportSchedules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBusinessReportSchedulesError {
    /// Kind of error that occurred.
    pub kind: ListBusinessReportSchedulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBusinessReportSchedules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBusinessReportSchedulesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBusinessReportSchedulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBusinessReportSchedulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBusinessReportSchedulesError {
    fn code(&self) -> Option<&str> {
        ListBusinessReportSchedulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBusinessReportSchedulesError {
    /// Creates a new `ListBusinessReportSchedulesError`.
    pub fn new(kind: ListBusinessReportSchedulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBusinessReportSchedulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBusinessReportSchedulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBusinessReportSchedulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBusinessReportSchedulesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListBusinessReportSchedulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBusinessReportSchedulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConferenceProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConferenceProvidersError {
    /// Kind of error that occurred.
    pub kind: ListConferenceProvidersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConferenceProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConferenceProvidersErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConferenceProvidersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConferenceProvidersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConferenceProvidersError {
    fn code(&self) -> Option<&str> {
        ListConferenceProvidersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConferenceProvidersError {
    /// Creates a new `ListConferenceProvidersError`.
    pub fn new(kind: ListConferenceProvidersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConferenceProvidersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConferenceProvidersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConferenceProvidersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConferenceProvidersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListConferenceProvidersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConferenceProvidersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDeviceEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDeviceEventsError {
    /// Kind of error that occurred.
    pub kind: ListDeviceEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDeviceEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDeviceEventsErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDeviceEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDeviceEventsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListDeviceEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDeviceEventsError {
    fn code(&self) -> Option<&str> {
        ListDeviceEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDeviceEventsError {
    /// Creates a new `ListDeviceEventsError`.
    pub fn new(kind: ListDeviceEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDeviceEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDeviceEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDeviceEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDeviceEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDeviceEventsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListDeviceEventsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ListDeviceEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDeviceEventsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListDeviceEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGatewayGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGatewayGroupsError {
    /// Kind of error that occurred.
    pub kind: ListGatewayGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGatewayGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGatewayGroupsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGatewayGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGatewayGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGatewayGroupsError {
    fn code(&self) -> Option<&str> {
        ListGatewayGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGatewayGroupsError {
    /// Creates a new `ListGatewayGroupsError`.
    pub fn new(kind: ListGatewayGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGatewayGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGatewayGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGatewayGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGatewayGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListGatewayGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGatewayGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGatewaysError {
    /// Kind of error that occurred.
    pub kind: ListGatewaysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGatewaysErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGatewaysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGatewaysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGatewaysError {
    fn code(&self) -> Option<&str> {
        ListGatewaysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGatewaysError {
    /// Creates a new `ListGatewaysError`.
    pub fn new(kind: ListGatewaysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGatewaysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGatewaysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGatewaysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGatewaysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListGatewaysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGatewaysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSkills` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSkillsError {
    /// Kind of error that occurred.
    pub kind: ListSkillsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSkills` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSkillsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSkillsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSkillsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSkillsError {
    fn code(&self) -> Option<&str> {
        ListSkillsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSkillsError {
    /// Creates a new `ListSkillsError`.
    pub fn new(kind: ListSkillsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSkillsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSkillsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSkillsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSkillsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListSkillsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSkillsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSkillsStoreCategories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSkillsStoreCategoriesError {
    /// Kind of error that occurred.
    pub kind: ListSkillsStoreCategoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSkillsStoreCategories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSkillsStoreCategoriesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSkillsStoreCategoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSkillsStoreCategoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSkillsStoreCategoriesError {
    fn code(&self) -> Option<&str> {
        ListSkillsStoreCategoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSkillsStoreCategoriesError {
    /// Creates a new `ListSkillsStoreCategoriesError`.
    pub fn new(kind: ListSkillsStoreCategoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSkillsStoreCategoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSkillsStoreCategoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSkillsStoreCategoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSkillsStoreCategoriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListSkillsStoreCategoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSkillsStoreCategoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSkillsStoreSkillsByCategory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSkillsStoreSkillsByCategoryError {
    /// Kind of error that occurred.
    pub kind: ListSkillsStoreSkillsByCategoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSkillsStoreSkillsByCategory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSkillsStoreSkillsByCategoryErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSkillsStoreSkillsByCategoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSkillsStoreSkillsByCategoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSkillsStoreSkillsByCategoryError {
    fn code(&self) -> Option<&str> {
        ListSkillsStoreSkillsByCategoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSkillsStoreSkillsByCategoryError {
    /// Creates a new `ListSkillsStoreSkillsByCategoryError`.
    pub fn new(
        kind: ListSkillsStoreSkillsByCategoryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSkillsStoreSkillsByCategoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSkillsStoreSkillsByCategoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSkillsStoreSkillsByCategoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSkillsStoreSkillsByCategoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListSkillsStoreSkillsByCategoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSkillsStoreSkillsByCategoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSmartHomeAppliances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSmartHomeAppliancesError {
    /// Kind of error that occurred.
    pub kind: ListSmartHomeAppliancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSmartHomeAppliances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSmartHomeAppliancesErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSmartHomeAppliancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSmartHomeAppliancesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListSmartHomeAppliancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSmartHomeAppliancesError {
    fn code(&self) -> Option<&str> {
        ListSmartHomeAppliancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSmartHomeAppliancesError {
    /// Creates a new `ListSmartHomeAppliancesError`.
    pub fn new(kind: ListSmartHomeAppliancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSmartHomeAppliancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSmartHomeAppliancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSmartHomeAppliancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSmartHomeAppliancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListSmartHomeAppliancesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSmartHomeAppliancesErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListSmartHomeAppliancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSmartHomeAppliancesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListSmartHomeAppliancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsError {
    /// Kind of error that occurred.
    pub kind: ListTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsError {
    fn code(&self) -> Option<&str> {
        ListTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsError {
    /// Creates a new `ListTagsError`.
    pub fn new(kind: ListTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ListTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutConferencePreference` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutConferencePreferenceError {
    /// Kind of error that occurred.
    pub kind: PutConferencePreferenceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutConferencePreference` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutConferencePreferenceErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutConferencePreferenceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutConferencePreferenceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutConferencePreferenceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutConferencePreferenceError {
    fn code(&self) -> Option<&str> {
        PutConferencePreferenceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutConferencePreferenceError {
    /// Creates a new `PutConferencePreferenceError`.
    pub fn new(kind: PutConferencePreferenceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutConferencePreferenceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutConferencePreferenceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutConferencePreferenceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutConferencePreferenceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutConferencePreferenceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConferencePreferenceErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for PutConferencePreferenceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutConferencePreferenceErrorKind::NotFoundException(_inner) => Some(_inner),
            PutConferencePreferenceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutInvitationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutInvitationConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutInvitationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutInvitationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutInvitationConfigurationErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutInvitationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutInvitationConfigurationErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            PutInvitationConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutInvitationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutInvitationConfigurationError {
    fn code(&self) -> Option<&str> {
        PutInvitationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutInvitationConfigurationError {
    /// Creates a new `PutInvitationConfigurationError`.
    pub fn new(kind: PutInvitationConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutInvitationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutInvitationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutInvitationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutInvitationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutInvitationConfigurationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInvitationConfigurationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `PutInvitationConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInvitationConfigurationErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for PutInvitationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutInvitationConfigurationErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            PutInvitationConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            PutInvitationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRoomSkillParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRoomSkillParameterError {
    /// Kind of error that occurred.
    pub kind: PutRoomSkillParameterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRoomSkillParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRoomSkillParameterErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRoomSkillParameterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRoomSkillParameterErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            PutRoomSkillParameterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRoomSkillParameterError {
    fn code(&self) -> Option<&str> {
        PutRoomSkillParameterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRoomSkillParameterError {
    /// Creates a new `PutRoomSkillParameterError`.
    pub fn new(kind: PutRoomSkillParameterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRoomSkillParameterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRoomSkillParameterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRoomSkillParameterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRoomSkillParameterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutRoomSkillParameterErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRoomSkillParameterErrorKind::ConcurrentModificationException(_)
        )
    }
}
impl std::error::Error for PutRoomSkillParameterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRoomSkillParameterErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            PutRoomSkillParameterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutSkillAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutSkillAuthorizationError {
    /// Kind of error that occurred.
    pub kind: PutSkillAuthorizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutSkillAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutSkillAuthorizationErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The caller has no permissions to operate on the resource involved in the API call.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutSkillAuthorizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutSkillAuthorizationErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            PutSkillAuthorizationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            PutSkillAuthorizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutSkillAuthorizationError {
    fn code(&self) -> Option<&str> {
        PutSkillAuthorizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutSkillAuthorizationError {
    /// Creates a new `PutSkillAuthorizationError`.
    pub fn new(kind: PutSkillAuthorizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutSkillAuthorizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutSkillAuthorizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutSkillAuthorizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutSkillAuthorizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutSkillAuthorizationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSkillAuthorizationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `PutSkillAuthorizationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSkillAuthorizationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for PutSkillAuthorizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutSkillAuthorizationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            PutSkillAuthorizationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            PutSkillAuthorizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterAVSDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterAVSDeviceError {
    /// Kind of error that occurred.
    pub kind: RegisterAVSDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterAVSDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterAVSDeviceErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The device is in an invalid state.</p>
    InvalidDeviceException(crate::error::InvalidDeviceException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterAVSDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterAVSDeviceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            RegisterAVSDeviceErrorKind::InvalidDeviceException(_inner) => _inner.fmt(f),
            RegisterAVSDeviceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RegisterAVSDeviceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RegisterAVSDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterAVSDeviceError {
    fn code(&self) -> Option<&str> {
        RegisterAVSDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterAVSDeviceError {
    /// Creates a new `RegisterAVSDeviceError`.
    pub fn new(kind: RegisterAVSDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterAVSDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterAVSDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterAVSDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterAVSDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RegisterAVSDeviceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterAVSDeviceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `RegisterAVSDeviceErrorKind::InvalidDeviceException`.
    pub fn is_invalid_device_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterAVSDeviceErrorKind::InvalidDeviceException(_)
        )
    }
    /// Returns true if the error kind is `RegisterAVSDeviceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterAVSDeviceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `RegisterAVSDeviceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RegisterAVSDeviceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for RegisterAVSDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterAVSDeviceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            RegisterAVSDeviceErrorKind::InvalidDeviceException(_inner) => Some(_inner),
            RegisterAVSDeviceErrorKind::LimitExceededException(_inner) => Some(_inner),
            RegisterAVSDeviceErrorKind::NotFoundException(_inner) => Some(_inner),
            RegisterAVSDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RejectSkill` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectSkillError {
    /// Kind of error that occurred.
    pub kind: RejectSkillErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectSkill` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectSkillErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectSkillError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectSkillErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            RejectSkillErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RejectSkillErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectSkillError {
    fn code(&self) -> Option<&str> {
        RejectSkillError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectSkillError {
    /// Creates a new `RejectSkillError`.
    pub fn new(kind: RejectSkillErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectSkillError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectSkillErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectSkillError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectSkillErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RejectSkillErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectSkillErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `RejectSkillErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RejectSkillErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for RejectSkillError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectSkillErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            RejectSkillErrorKind::NotFoundException(_inner) => Some(_inner),
            RejectSkillErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResolveRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResolveRoomError {
    /// Kind of error that occurred.
    pub kind: ResolveRoomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResolveRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResolveRoomErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResolveRoomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResolveRoomErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ResolveRoomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResolveRoomError {
    fn code(&self) -> Option<&str> {
        ResolveRoomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResolveRoomError {
    /// Creates a new `ResolveRoomError`.
    pub fn new(kind: ResolveRoomErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResolveRoomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResolveRoomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResolveRoomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResolveRoomErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ResolveRoomErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ResolveRoomErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ResolveRoomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResolveRoomErrorKind::NotFoundException(_inner) => Some(_inner),
            ResolveRoomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RevokeInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RevokeInvitationError {
    /// Kind of error that occurred.
    pub kind: RevokeInvitationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RevokeInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RevokeInvitationErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RevokeInvitationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RevokeInvitationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            RevokeInvitationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RevokeInvitationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RevokeInvitationError {
    fn code(&self) -> Option<&str> {
        RevokeInvitationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RevokeInvitationError {
    /// Creates a new `RevokeInvitationError`.
    pub fn new(kind: RevokeInvitationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RevokeInvitationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RevokeInvitationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RevokeInvitationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RevokeInvitationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RevokeInvitationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeInvitationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `RevokeInvitationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RevokeInvitationErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for RevokeInvitationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RevokeInvitationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            RevokeInvitationErrorKind::NotFoundException(_inner) => Some(_inner),
            RevokeInvitationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchAddressBooks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchAddressBooksError {
    /// Kind of error that occurred.
    pub kind: SearchAddressBooksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchAddressBooks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchAddressBooksErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchAddressBooksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchAddressBooksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchAddressBooksError {
    fn code(&self) -> Option<&str> {
        SearchAddressBooksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchAddressBooksError {
    /// Creates a new `SearchAddressBooksError`.
    pub fn new(kind: SearchAddressBooksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchAddressBooksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchAddressBooksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchAddressBooksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchAddressBooksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SearchAddressBooksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchAddressBooksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchContacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchContactsError {
    /// Kind of error that occurred.
    pub kind: SearchContactsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchContacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchContactsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchContactsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchContactsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchContactsError {
    fn code(&self) -> Option<&str> {
        SearchContactsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchContactsError {
    /// Creates a new `SearchContactsError`.
    pub fn new(kind: SearchContactsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchContactsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchContactsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchContactsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchContactsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SearchContactsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchContactsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchDevicesError {
    /// Kind of error that occurred.
    pub kind: SearchDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchDevicesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchDevicesError {
    fn code(&self) -> Option<&str> {
        SearchDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchDevicesError {
    /// Creates a new `SearchDevicesError`.
    pub fn new(kind: SearchDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchDevicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SearchDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchNetworkProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchNetworkProfilesError {
    /// Kind of error that occurred.
    pub kind: SearchNetworkProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchNetworkProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchNetworkProfilesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchNetworkProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchNetworkProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchNetworkProfilesError {
    fn code(&self) -> Option<&str> {
        SearchNetworkProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchNetworkProfilesError {
    /// Creates a new `SearchNetworkProfilesError`.
    pub fn new(kind: SearchNetworkProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchNetworkProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchNetworkProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchNetworkProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchNetworkProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SearchNetworkProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchNetworkProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchProfilesError {
    /// Kind of error that occurred.
    pub kind: SearchProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchProfilesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchProfilesError {
    fn code(&self) -> Option<&str> {
        SearchProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchProfilesError {
    /// Creates a new `SearchProfilesError`.
    pub fn new(kind: SearchProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SearchProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchRooms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchRoomsError {
    /// Kind of error that occurred.
    pub kind: SearchRoomsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchRooms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchRoomsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchRoomsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchRoomsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchRoomsError {
    fn code(&self) -> Option<&str> {
        SearchRoomsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchRoomsError {
    /// Creates a new `SearchRoomsError`.
    pub fn new(kind: SearchRoomsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchRoomsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchRoomsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchRoomsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchRoomsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SearchRoomsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchRoomsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchSkillGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchSkillGroupsError {
    /// Kind of error that occurred.
    pub kind: SearchSkillGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchSkillGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchSkillGroupsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchSkillGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchSkillGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchSkillGroupsError {
    fn code(&self) -> Option<&str> {
        SearchSkillGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchSkillGroupsError {
    /// Creates a new `SearchSkillGroupsError`.
    pub fn new(kind: SearchSkillGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchSkillGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchSkillGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchSkillGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchSkillGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SearchSkillGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchSkillGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchUsersError {
    /// Kind of error that occurred.
    pub kind: SearchUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchUsersErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchUsersError {
    fn code(&self) -> Option<&str> {
        SearchUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchUsersError {
    /// Creates a new `SearchUsersError`.
    pub fn new(kind: SearchUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchUsersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SearchUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendAnnouncement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendAnnouncementError {
    /// Kind of error that occurred.
    pub kind: SendAnnouncementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendAnnouncement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendAnnouncementErrorKind {
    /// <p>The resource being created already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>You are performing an action that would put you beyond your account's limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendAnnouncementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendAnnouncementErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            SendAnnouncementErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            SendAnnouncementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendAnnouncementError {
    fn code(&self) -> Option<&str> {
        SendAnnouncementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendAnnouncementError {
    /// Creates a new `SendAnnouncementError`.
    pub fn new(kind: SendAnnouncementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendAnnouncementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendAnnouncementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendAnnouncementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendAnnouncementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendAnnouncementErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendAnnouncementErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `SendAnnouncementErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendAnnouncementErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for SendAnnouncementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendAnnouncementErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            SendAnnouncementErrorKind::LimitExceededException(_inner) => Some(_inner),
            SendAnnouncementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendInvitationError {
    /// Kind of error that occurred.
    pub kind: SendInvitationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendInvitationErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The attempt to update a user is invalid due to the user's current status.</p>
    InvalidUserStatusException(crate::error::InvalidUserStatusException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendInvitationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendInvitationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            SendInvitationErrorKind::InvalidUserStatusException(_inner) => _inner.fmt(f),
            SendInvitationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SendInvitationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendInvitationError {
    fn code(&self) -> Option<&str> {
        SendInvitationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendInvitationError {
    /// Creates a new `SendInvitationError`.
    pub fn new(kind: SendInvitationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendInvitationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendInvitationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendInvitationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendInvitationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendInvitationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendInvitationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `SendInvitationErrorKind::InvalidUserStatusException`.
    pub fn is_invalid_user_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendInvitationErrorKind::InvalidUserStatusException(_)
        )
    }
    /// Returns true if the error kind is `SendInvitationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, SendInvitationErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for SendInvitationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendInvitationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            SendInvitationErrorKind::InvalidUserStatusException(_inner) => Some(_inner),
            SendInvitationErrorKind::NotFoundException(_inner) => Some(_inner),
            SendInvitationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDeviceSync` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDeviceSyncError {
    /// Kind of error that occurred.
    pub kind: StartDeviceSyncErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDeviceSync` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDeviceSyncErrorKind {
    /// <p>The request failed because this device is no longer registered and therefore no longer managed by this account.</p>
    DeviceNotRegisteredException(crate::error::DeviceNotRegisteredException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDeviceSyncError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDeviceSyncErrorKind::DeviceNotRegisteredException(_inner) => _inner.fmt(f),
            StartDeviceSyncErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDeviceSyncError {
    fn code(&self) -> Option<&str> {
        StartDeviceSyncError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDeviceSyncError {
    /// Creates a new `StartDeviceSyncError`.
    pub fn new(kind: StartDeviceSyncErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDeviceSyncError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDeviceSyncErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDeviceSyncError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDeviceSyncErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartDeviceSyncErrorKind::DeviceNotRegisteredException`.
    pub fn is_device_not_registered_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeviceSyncErrorKind::DeviceNotRegisteredException(_)
        )
    }
}
impl std::error::Error for StartDeviceSyncError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDeviceSyncErrorKind::DeviceNotRegisteredException(_inner) => Some(_inner),
            StartDeviceSyncErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartSmartHomeApplianceDiscovery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartSmartHomeApplianceDiscoveryError {
    /// Kind of error that occurred.
    pub kind: StartSmartHomeApplianceDiscoveryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartSmartHomeApplianceDiscovery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartSmartHomeApplianceDiscoveryErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartSmartHomeApplianceDiscoveryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartSmartHomeApplianceDiscoveryErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartSmartHomeApplianceDiscoveryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartSmartHomeApplianceDiscoveryError {
    fn code(&self) -> Option<&str> {
        StartSmartHomeApplianceDiscoveryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartSmartHomeApplianceDiscoveryError {
    /// Creates a new `StartSmartHomeApplianceDiscoveryError`.
    pub fn new(
        kind: StartSmartHomeApplianceDiscoveryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartSmartHomeApplianceDiscoveryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartSmartHomeApplianceDiscoveryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartSmartHomeApplianceDiscoveryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartSmartHomeApplianceDiscoveryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartSmartHomeApplianceDiscoveryErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSmartHomeApplianceDiscoveryErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for StartSmartHomeApplianceDiscoveryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartSmartHomeApplianceDiscoveryErrorKind::NotFoundException(_inner) => Some(_inner),
            StartSmartHomeApplianceDiscoveryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAddressBook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAddressBookError {
    /// Kind of error that occurred.
    pub kind: UpdateAddressBookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAddressBook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAddressBookErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The name sent in the request is already in use.</p>
    NameInUseException(crate::error::NameInUseException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAddressBookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAddressBookErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateAddressBookErrorKind::NameInUseException(_inner) => _inner.fmt(f),
            UpdateAddressBookErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateAddressBookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAddressBookError {
    fn code(&self) -> Option<&str> {
        UpdateAddressBookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAddressBookError {
    /// Creates a new `UpdateAddressBookError`.
    pub fn new(kind: UpdateAddressBookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAddressBookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAddressBookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAddressBookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAddressBookErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAddressBookErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAddressBookErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAddressBookErrorKind::NameInUseException`.
    pub fn is_name_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAddressBookErrorKind::NameInUseException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAddressBookErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateAddressBookErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateAddressBookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAddressBookErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateAddressBookErrorKind::NameInUseException(_inner) => Some(_inner),
            UpdateAddressBookErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateAddressBookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBusinessReportSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBusinessReportScheduleError {
    /// Kind of error that occurred.
    pub kind: UpdateBusinessReportScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBusinessReportSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBusinessReportScheduleErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBusinessReportScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBusinessReportScheduleErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateBusinessReportScheduleErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateBusinessReportScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBusinessReportScheduleError {
    fn code(&self) -> Option<&str> {
        UpdateBusinessReportScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBusinessReportScheduleError {
    /// Creates a new `UpdateBusinessReportScheduleError`.
    pub fn new(kind: UpdateBusinessReportScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBusinessReportScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBusinessReportScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBusinessReportScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBusinessReportScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateBusinessReportScheduleErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBusinessReportScheduleErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateBusinessReportScheduleErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBusinessReportScheduleErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateBusinessReportScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBusinessReportScheduleErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            UpdateBusinessReportScheduleErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateBusinessReportScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConferenceProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConferenceProviderError {
    /// Kind of error that occurred.
    pub kind: UpdateConferenceProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConferenceProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConferenceProviderErrorKind {
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConferenceProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConferenceProviderErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateConferenceProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConferenceProviderError {
    fn code(&self) -> Option<&str> {
        UpdateConferenceProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConferenceProviderError {
    /// Creates a new `UpdateConferenceProviderError`.
    pub fn new(kind: UpdateConferenceProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConferenceProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConferenceProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConferenceProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConferenceProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateConferenceProviderErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConferenceProviderErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateConferenceProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConferenceProviderErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateConferenceProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateContactError {
    /// Kind of error that occurred.
    pub kind: UpdateContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateContactErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateContactErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateContactError {
    fn code(&self) -> Option<&str> {
        UpdateContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateContactError {
    /// Creates a new `UpdateContactError`.
    pub fn new(kind: UpdateContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateContactErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateContactErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateContactErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateContactErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateContactErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDeviceError {
    /// Kind of error that occurred.
    pub kind: UpdateDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDeviceErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request failed because this device is no longer registered and therefore no longer managed by this account.</p>
    DeviceNotRegisteredException(crate::error::DeviceNotRegisteredException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDeviceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateDeviceErrorKind::DeviceNotRegisteredException(_inner) => _inner.fmt(f),
            UpdateDeviceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDeviceError {
    fn code(&self) -> Option<&str> {
        UpdateDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDeviceError {
    /// Creates a new `UpdateDeviceError`.
    pub fn new(kind: UpdateDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDeviceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDeviceErrorKind::DeviceNotRegisteredException`.
    pub fn is_device_not_registered_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceErrorKind::DeviceNotRegisteredException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDeviceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateDeviceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDeviceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateDeviceErrorKind::DeviceNotRegisteredException(_inner) => Some(_inner),
            UpdateDeviceErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGatewayError {
    /// Kind of error that occurred.
    pub kind: UpdateGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGatewayErrorKind {
    /// <p>The name sent in the request is already in use.</p>
    NameInUseException(crate::error::NameInUseException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGatewayErrorKind::NameInUseException(_inner) => _inner.fmt(f),
            UpdateGatewayErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGatewayError {
    fn code(&self) -> Option<&str> {
        UpdateGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGatewayError {
    /// Creates a new `UpdateGatewayError`.
    pub fn new(kind: UpdateGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateGatewayErrorKind::NameInUseException`.
    pub fn is_name_in_use_exception(&self) -> bool {
        matches!(&self.kind, UpdateGatewayErrorKind::NameInUseException(_))
    }
    /// Returns true if the error kind is `UpdateGatewayErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateGatewayErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGatewayErrorKind::NameInUseException(_inner) => Some(_inner),
            UpdateGatewayErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGatewayGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGatewayGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateGatewayGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGatewayGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGatewayGroupErrorKind {
    /// <p>The name sent in the request is already in use.</p>
    NameInUseException(crate::error::NameInUseException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGatewayGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGatewayGroupErrorKind::NameInUseException(_inner) => _inner.fmt(f),
            UpdateGatewayGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateGatewayGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGatewayGroupError {
    fn code(&self) -> Option<&str> {
        UpdateGatewayGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGatewayGroupError {
    /// Creates a new `UpdateGatewayGroupError`.
    pub fn new(kind: UpdateGatewayGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGatewayGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGatewayGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGatewayGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGatewayGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateGatewayGroupErrorKind::NameInUseException`.
    pub fn is_name_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayGroupErrorKind::NameInUseException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayGroupErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateGatewayGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGatewayGroupErrorKind::NameInUseException(_inner) => Some(_inner),
            UpdateGatewayGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateGatewayGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateNetworkProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateNetworkProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateNetworkProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateNetworkProfileErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The Certificate Authority can't issue or revoke a certificate.</p>
    InvalidCertificateAuthorityException(crate::error::InvalidCertificateAuthorityException),
    /// <p>A password in SecretsManager is in an invalid state.</p>
    InvalidSecretsManagerResourceException(crate::error::InvalidSecretsManagerResourceException),
    /// <p>The name sent in the request is already in use.</p>
    NameInUseException(crate::error::NameInUseException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateNetworkProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateNetworkProfileErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateNetworkProfileErrorKind::InvalidCertificateAuthorityException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNetworkProfileErrorKind::InvalidSecretsManagerResourceException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNetworkProfileErrorKind::NameInUseException(_inner) => _inner.fmt(f),
            UpdateNetworkProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateNetworkProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateNetworkProfileError {
    fn code(&self) -> Option<&str> {
        UpdateNetworkProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateNetworkProfileError {
    /// Creates a new `UpdateNetworkProfileError`.
    pub fn new(kind: UpdateNetworkProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateNetworkProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateNetworkProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateNetworkProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateNetworkProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateNetworkProfileErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkProfileErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateNetworkProfileErrorKind::InvalidCertificateAuthorityException`.
    pub fn is_invalid_certificate_authority_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkProfileErrorKind::InvalidCertificateAuthorityException(_)
        )
    }
    /// Returns true if the error kind is `UpdateNetworkProfileErrorKind::InvalidSecretsManagerResourceException`.
    pub fn is_invalid_secrets_manager_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkProfileErrorKind::InvalidSecretsManagerResourceException(_)
        )
    }
    /// Returns true if the error kind is `UpdateNetworkProfileErrorKind::NameInUseException`.
    pub fn is_name_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkProfileErrorKind::NameInUseException(_)
        )
    }
    /// Returns true if the error kind is `UpdateNetworkProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkProfileErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateNetworkProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateNetworkProfileErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateNetworkProfileErrorKind::InvalidCertificateAuthorityException(_inner) => {
                Some(_inner)
            }
            UpdateNetworkProfileErrorKind::InvalidSecretsManagerResourceException(_inner) => {
                Some(_inner)
            }
            UpdateNetworkProfileErrorKind::NameInUseException(_inner) => Some(_inner),
            UpdateNetworkProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateNetworkProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProfileErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The name sent in the request is already in use.</p>
    NameInUseException(crate::error::NameInUseException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProfileErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateProfileErrorKind::NameInUseException(_inner) => _inner.fmt(f),
            UpdateProfileErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProfileError {
    fn code(&self) -> Option<&str> {
        UpdateProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProfileError {
    /// Creates a new `UpdateProfileError`.
    pub fn new(kind: UpdateProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateProfileErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProfileErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProfileErrorKind::NameInUseException`.
    pub fn is_name_in_use_exception(&self) -> bool {
        matches!(&self.kind, UpdateProfileErrorKind::NameInUseException(_))
    }
    /// Returns true if the error kind is `UpdateProfileErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateProfileErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProfileErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateProfileErrorKind::NameInUseException(_inner) => Some(_inner),
            UpdateProfileErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRoomError {
    /// Kind of error that occurred.
    pub kind: UpdateRoomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRoom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRoomErrorKind {
    /// <p>The name sent in the request is already in use.</p>
    NameInUseException(crate::error::NameInUseException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRoomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRoomErrorKind::NameInUseException(_inner) => _inner.fmt(f),
            UpdateRoomErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateRoomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRoomError {
    fn code(&self) -> Option<&str> {
        UpdateRoomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRoomError {
    /// Creates a new `UpdateRoomError`.
    pub fn new(kind: UpdateRoomErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRoomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRoomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRoomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRoomErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateRoomErrorKind::NameInUseException`.
    pub fn is_name_in_use_exception(&self) -> bool {
        matches!(&self.kind, UpdateRoomErrorKind::NameInUseException(_))
    }
    /// Returns true if the error kind is `UpdateRoomErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateRoomErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateRoomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRoomErrorKind::NameInUseException(_inner) => Some(_inner),
            UpdateRoomErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateRoomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSkillGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSkillGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateSkillGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSkillGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSkillGroupErrorKind {
    /// <p>There is a concurrent modification of resources.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The name sent in the request is already in use.</p>
    NameInUseException(crate::error::NameInUseException),
    /// <p>The resource is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSkillGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSkillGroupErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateSkillGroupErrorKind::NameInUseException(_inner) => _inner.fmt(f),
            UpdateSkillGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateSkillGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSkillGroupError {
    fn code(&self) -> Option<&str> {
        UpdateSkillGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSkillGroupError {
    /// Creates a new `UpdateSkillGroupError`.
    pub fn new(kind: UpdateSkillGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSkillGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSkillGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSkillGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSkillGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateSkillGroupErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSkillGroupErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateSkillGroupErrorKind::NameInUseException`.
    pub fn is_name_in_use_exception(&self) -> bool {
        matches!(&self.kind, UpdateSkillGroupErrorKind::NameInUseException(_))
    }
    /// Returns true if the error kind is `UpdateSkillGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateSkillGroupErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateSkillGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSkillGroupErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateSkillGroupErrorKind::NameInUseException(_inner) => Some(_inner),
            UpdateSkillGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateSkillGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The resource is not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The name sent in the request is already in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NameInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NameInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NameInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NameInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NameInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NameInUseException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NameInUseException {}
/// See [`NameInUseException`](crate::error::NameInUseException)
pub mod name_in_use_exception {
    /// A builder for [`NameInUseException`](crate::error::NameInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NameInUseException`](crate::error::NameInUseException)
        pub fn build(self) -> crate::error::NameInUseException {
            crate::error::NameInUseException {
                message: self.message,
            }
        }
    }
}
impl NameInUseException {
    /// Creates a new builder-style object to manufacture [`NameInUseException`](crate::error::NameInUseException)
    pub fn builder() -> crate::error::name_in_use_exception::Builder {
        crate::error::name_in_use_exception::Builder::default()
    }
}

/// <p>There is a concurrent modification of resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>A password in SecretsManager is in an invalid state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSecretsManagerResourceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSecretsManagerResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSecretsManagerResourceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSecretsManagerResourceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSecretsManagerResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSecretsManagerResourceException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSecretsManagerResourceException {}
/// See [`InvalidSecretsManagerResourceException`](crate::error::InvalidSecretsManagerResourceException)
pub mod invalid_secrets_manager_resource_exception {
    /// A builder for [`InvalidSecretsManagerResourceException`](crate::error::InvalidSecretsManagerResourceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSecretsManagerResourceException`](crate::error::InvalidSecretsManagerResourceException)
        pub fn build(self) -> crate::error::InvalidSecretsManagerResourceException {
            crate::error::InvalidSecretsManagerResourceException {
                message: self.message,
            }
        }
    }
}
impl InvalidSecretsManagerResourceException {
    /// Creates a new builder-style object to manufacture [`InvalidSecretsManagerResourceException`](crate::error::InvalidSecretsManagerResourceException)
    pub fn builder() -> crate::error::invalid_secrets_manager_resource_exception::Builder {
        crate::error::invalid_secrets_manager_resource_exception::Builder::default()
    }
}

/// <p>The Certificate Authority can't issue or revoke a certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCertificateAuthorityException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidCertificateAuthorityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCertificateAuthorityException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidCertificateAuthorityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCertificateAuthorityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCertificateAuthorityException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCertificateAuthorityException {}
/// See [`InvalidCertificateAuthorityException`](crate::error::InvalidCertificateAuthorityException)
pub mod invalid_certificate_authority_exception {
    /// A builder for [`InvalidCertificateAuthorityException`](crate::error::InvalidCertificateAuthorityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCertificateAuthorityException`](crate::error::InvalidCertificateAuthorityException)
        pub fn build(self) -> crate::error::InvalidCertificateAuthorityException {
            crate::error::InvalidCertificateAuthorityException {
                message: self.message,
            }
        }
    }
}
impl InvalidCertificateAuthorityException {
    /// Creates a new builder-style object to manufacture [`InvalidCertificateAuthorityException`](crate::error::InvalidCertificateAuthorityException)
    pub fn builder() -> crate::error::invalid_certificate_authority_exception::Builder {
        crate::error::invalid_certificate_authority_exception::Builder::default()
    }
}

/// <p>The request failed because this device is no longer registered and therefore no longer managed by this account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceNotRegisteredException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeviceNotRegisteredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceNotRegisteredException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DeviceNotRegisteredException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DeviceNotRegisteredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DeviceNotRegisteredException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for DeviceNotRegisteredException {}
/// See [`DeviceNotRegisteredException`](crate::error::DeviceNotRegisteredException)
pub mod device_not_registered_exception {
    /// A builder for [`DeviceNotRegisteredException`](crate::error::DeviceNotRegisteredException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceNotRegisteredException`](crate::error::DeviceNotRegisteredException)
        pub fn build(self) -> crate::error::DeviceNotRegisteredException {
            crate::error::DeviceNotRegisteredException {
                message: self.message,
            }
        }
    }
}
impl DeviceNotRegisteredException {
    /// Creates a new builder-style object to manufacture [`DeviceNotRegisteredException`](crate::error::DeviceNotRegisteredException)
    pub fn builder() -> crate::error::device_not_registered_exception::Builder {
        crate::error::device_not_registered_exception::Builder::default()
    }
}

/// <p>The attempt to update a user is invalid due to the user's current status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidUserStatusException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidUserStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidUserStatusException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidUserStatusException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidUserStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidUserStatusException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidUserStatusException {}
/// See [`InvalidUserStatusException`](crate::error::InvalidUserStatusException)
pub mod invalid_user_status_exception {
    /// A builder for [`InvalidUserStatusException`](crate::error::InvalidUserStatusException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidUserStatusException`](crate::error::InvalidUserStatusException)
        pub fn build(self) -> crate::error::InvalidUserStatusException {
            crate::error::InvalidUserStatusException {
                message: self.message,
            }
        }
    }
}
impl InvalidUserStatusException {
    /// Creates a new builder-style object to manufacture [`InvalidUserStatusException`](crate::error::InvalidUserStatusException)
    pub fn builder() -> crate::error::invalid_user_status_exception::Builder {
        crate::error::invalid_user_status_exception::Builder::default()
    }
}

/// <p>You are performing an action that would put you beyond your account's limits.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The resource being created already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyExistsException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyExistsException {}
/// See [`AlreadyExistsException`](crate::error::AlreadyExistsException)
pub mod already_exists_exception {
    /// A builder for [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyExistsException`](crate::error::AlreadyExistsException)
        pub fn build(self) -> crate::error::AlreadyExistsException {
            crate::error::AlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl AlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    pub fn builder() -> crate::error::already_exists_exception::Builder {
        crate::error::already_exists_exception::Builder::default()
    }
}

/// <p>The device is in an invalid state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDeviceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDeviceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDeviceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDeviceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDeviceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDeviceException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDeviceException {}
/// See [`InvalidDeviceException`](crate::error::InvalidDeviceException)
pub mod invalid_device_exception {
    /// A builder for [`InvalidDeviceException`](crate::error::InvalidDeviceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDeviceException`](crate::error::InvalidDeviceException)
        pub fn build(self) -> crate::error::InvalidDeviceException {
            crate::error::InvalidDeviceException {
                message: self.message,
            }
        }
    }
}
impl InvalidDeviceException {
    /// Creates a new builder-style object to manufacture [`InvalidDeviceException`](crate::error::InvalidDeviceException)
    pub fn builder() -> crate::error::invalid_device_exception::Builder {
        crate::error::invalid_device_exception::Builder::default()
    }
}

/// <p>The caller has no permissions to operate on the resource involved in the API call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

/// <p>The resource in the request is already in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>A unique, user-specified identifier for the request that ensures idempotency.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>A unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
                client_request_token: self.client_request_token,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>Another resource is associated with the resource in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAssociatedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAssociatedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAssociatedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAssociatedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAssociatedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAssociatedException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAssociatedException {}
/// See [`ResourceAssociatedException`](crate::error::ResourceAssociatedException)
pub mod resource_associated_exception {
    /// A builder for [`ResourceAssociatedException`](crate::error::ResourceAssociatedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAssociatedException`](crate::error::ResourceAssociatedException)
        pub fn build(self) -> crate::error::ResourceAssociatedException {
            crate::error::ResourceAssociatedException {
                message: self.message,
            }
        }
    }
}
impl ResourceAssociatedException {
    /// Creates a new builder-style object to manufacture [`ResourceAssociatedException`](crate::error::ResourceAssociatedException)
    pub fn builder() -> crate::error::resource_associated_exception::Builder {
        crate::error::resource_associated_exception::Builder::default()
    }
}

/// <p>The service linked role is locked for deletion. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidServiceLinkedRoleStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidServiceLinkedRoleStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidServiceLinkedRoleStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidServiceLinkedRoleStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidServiceLinkedRoleStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidServiceLinkedRoleStateException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidServiceLinkedRoleStateException {}
/// See [`InvalidServiceLinkedRoleStateException`](crate::error::InvalidServiceLinkedRoleStateException)
pub mod invalid_service_linked_role_state_exception {
    /// A builder for [`InvalidServiceLinkedRoleStateException`](crate::error::InvalidServiceLinkedRoleStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidServiceLinkedRoleStateException`](crate::error::InvalidServiceLinkedRoleStateException)
        pub fn build(self) -> crate::error::InvalidServiceLinkedRoleStateException {
            crate::error::InvalidServiceLinkedRoleStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidServiceLinkedRoleStateException {
    /// Creates a new builder-style object to manufacture [`InvalidServiceLinkedRoleStateException`](crate::error::InvalidServiceLinkedRoleStateException)
    pub fn builder() -> crate::error::invalid_service_linked_role_state_exception::Builder {
        crate::error::invalid_service_linked_role_state_exception::Builder::default()
    }
}

/// <p>The skill must be linked to a third-party account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SkillNotLinkedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SkillNotLinkedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SkillNotLinkedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SkillNotLinkedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SkillNotLinkedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SkillNotLinkedException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for SkillNotLinkedException {}
/// See [`SkillNotLinkedException`](crate::error::SkillNotLinkedException)
pub mod skill_not_linked_exception {
    /// A builder for [`SkillNotLinkedException`](crate::error::SkillNotLinkedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SkillNotLinkedException`](crate::error::SkillNotLinkedException)
        pub fn build(self) -> crate::error::SkillNotLinkedException {
            crate::error::SkillNotLinkedException {
                message: self.message,
            }
        }
    }
}
impl SkillNotLinkedException {
    /// Creates a new builder-style object to manufacture [`SkillNotLinkedException`](crate::error::SkillNotLinkedException)
    pub fn builder() -> crate::error::skill_not_linked_exception::Builder {
        crate::error::skill_not_linked_exception::Builder::default()
    }
}
