// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AlexaForBusiness`.
///
/// This client allows ergonomic access to a `AlexaForBusiness`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `ApproveSkill` operation.
    ///
    /// See [`ApproveSkill`](crate::client::fluent_builders::ApproveSkill) for more information about the
    /// operation and its arguments.
    pub fn approve_skill(&self) -> fluent_builders::ApproveSkill<C, M, R> {
        fluent_builders::ApproveSkill::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateContactWithAddressBook` operation.
    ///
    /// See [`AssociateContactWithAddressBook`](crate::client::fluent_builders::AssociateContactWithAddressBook) for more information about the
    /// operation and its arguments.
    pub fn associate_contact_with_address_book(
        &self,
    ) -> fluent_builders::AssociateContactWithAddressBook<C, M, R> {
        fluent_builders::AssociateContactWithAddressBook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateDeviceWithNetworkProfile` operation.
    ///
    /// See [`AssociateDeviceWithNetworkProfile`](crate::client::fluent_builders::AssociateDeviceWithNetworkProfile) for more information about the
    /// operation and its arguments.
    pub fn associate_device_with_network_profile(
        &self,
    ) -> fluent_builders::AssociateDeviceWithNetworkProfile<C, M, R> {
        fluent_builders::AssociateDeviceWithNetworkProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateDeviceWithRoom` operation.
    ///
    /// See [`AssociateDeviceWithRoom`](crate::client::fluent_builders::AssociateDeviceWithRoom) for more information about the
    /// operation and its arguments.
    pub fn associate_device_with_room(&self) -> fluent_builders::AssociateDeviceWithRoom<C, M, R> {
        fluent_builders::AssociateDeviceWithRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateSkillGroupWithRoom` operation.
    ///
    /// See [`AssociateSkillGroupWithRoom`](crate::client::fluent_builders::AssociateSkillGroupWithRoom) for more information about the
    /// operation and its arguments.
    pub fn associate_skill_group_with_room(
        &self,
    ) -> fluent_builders::AssociateSkillGroupWithRoom<C, M, R> {
        fluent_builders::AssociateSkillGroupWithRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateSkillWithSkillGroup` operation.
    ///
    /// See [`AssociateSkillWithSkillGroup`](crate::client::fluent_builders::AssociateSkillWithSkillGroup) for more information about the
    /// operation and its arguments.
    pub fn associate_skill_with_skill_group(
        &self,
    ) -> fluent_builders::AssociateSkillWithSkillGroup<C, M, R> {
        fluent_builders::AssociateSkillWithSkillGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateSkillWithUsers` operation.
    ///
    /// See [`AssociateSkillWithUsers`](crate::client::fluent_builders::AssociateSkillWithUsers) for more information about the
    /// operation and its arguments.
    pub fn associate_skill_with_users(&self) -> fluent_builders::AssociateSkillWithUsers<C, M, R> {
        fluent_builders::AssociateSkillWithUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAddressBook` operation.
    ///
    /// See [`CreateAddressBook`](crate::client::fluent_builders::CreateAddressBook) for more information about the
    /// operation and its arguments.
    pub fn create_address_book(&self) -> fluent_builders::CreateAddressBook<C, M, R> {
        fluent_builders::CreateAddressBook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBusinessReportSchedule` operation.
    ///
    /// See [`CreateBusinessReportSchedule`](crate::client::fluent_builders::CreateBusinessReportSchedule) for more information about the
    /// operation and its arguments.
    pub fn create_business_report_schedule(
        &self,
    ) -> fluent_builders::CreateBusinessReportSchedule<C, M, R> {
        fluent_builders::CreateBusinessReportSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConferenceProvider` operation.
    ///
    /// See [`CreateConferenceProvider`](crate::client::fluent_builders::CreateConferenceProvider) for more information about the
    /// operation and its arguments.
    pub fn create_conference_provider(&self) -> fluent_builders::CreateConferenceProvider<C, M, R> {
        fluent_builders::CreateConferenceProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContact` operation.
    ///
    /// See [`CreateContact`](crate::client::fluent_builders::CreateContact) for more information about the
    /// operation and its arguments.
    pub fn create_contact(&self) -> fluent_builders::CreateContact<C, M, R> {
        fluent_builders::CreateContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGatewayGroup` operation.
    ///
    /// See [`CreateGatewayGroup`](crate::client::fluent_builders::CreateGatewayGroup) for more information about the
    /// operation and its arguments.
    pub fn create_gateway_group(&self) -> fluent_builders::CreateGatewayGroup<C, M, R> {
        fluent_builders::CreateGatewayGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNetworkProfile` operation.
    ///
    /// See [`CreateNetworkProfile`](crate::client::fluent_builders::CreateNetworkProfile) for more information about the
    /// operation and its arguments.
    pub fn create_network_profile(&self) -> fluent_builders::CreateNetworkProfile<C, M, R> {
        fluent_builders::CreateNetworkProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProfile` operation.
    ///
    /// See [`CreateProfile`](crate::client::fluent_builders::CreateProfile) for more information about the
    /// operation and its arguments.
    pub fn create_profile(&self) -> fluent_builders::CreateProfile<C, M, R> {
        fluent_builders::CreateProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRoom` operation.
    ///
    /// See [`CreateRoom`](crate::client::fluent_builders::CreateRoom) for more information about the
    /// operation and its arguments.
    pub fn create_room(&self) -> fluent_builders::CreateRoom<C, M, R> {
        fluent_builders::CreateRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSkillGroup` operation.
    ///
    /// See [`CreateSkillGroup`](crate::client::fluent_builders::CreateSkillGroup) for more information about the
    /// operation and its arguments.
    pub fn create_skill_group(&self) -> fluent_builders::CreateSkillGroup<C, M, R> {
        fluent_builders::CreateSkillGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUser` operation.
    ///
    /// See [`CreateUser`](crate::client::fluent_builders::CreateUser) for more information about the
    /// operation and its arguments.
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAddressBook` operation.
    ///
    /// See [`DeleteAddressBook`](crate::client::fluent_builders::DeleteAddressBook) for more information about the
    /// operation and its arguments.
    pub fn delete_address_book(&self) -> fluent_builders::DeleteAddressBook<C, M, R> {
        fluent_builders::DeleteAddressBook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBusinessReportSchedule` operation.
    ///
    /// See [`DeleteBusinessReportSchedule`](crate::client::fluent_builders::DeleteBusinessReportSchedule) for more information about the
    /// operation and its arguments.
    pub fn delete_business_report_schedule(
        &self,
    ) -> fluent_builders::DeleteBusinessReportSchedule<C, M, R> {
        fluent_builders::DeleteBusinessReportSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConferenceProvider` operation.
    ///
    /// See [`DeleteConferenceProvider`](crate::client::fluent_builders::DeleteConferenceProvider) for more information about the
    /// operation and its arguments.
    pub fn delete_conference_provider(&self) -> fluent_builders::DeleteConferenceProvider<C, M, R> {
        fluent_builders::DeleteConferenceProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteContact` operation.
    ///
    /// See [`DeleteContact`](crate::client::fluent_builders::DeleteContact) for more information about the
    /// operation and its arguments.
    pub fn delete_contact(&self) -> fluent_builders::DeleteContact<C, M, R> {
        fluent_builders::DeleteContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDevice` operation.
    ///
    /// See [`DeleteDevice`](crate::client::fluent_builders::DeleteDevice) for more information about the
    /// operation and its arguments.
    pub fn delete_device(&self) -> fluent_builders::DeleteDevice<C, M, R> {
        fluent_builders::DeleteDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDeviceUsageData` operation.
    ///
    /// See [`DeleteDeviceUsageData`](crate::client::fluent_builders::DeleteDeviceUsageData) for more information about the
    /// operation and its arguments.
    pub fn delete_device_usage_data(&self) -> fluent_builders::DeleteDeviceUsageData<C, M, R> {
        fluent_builders::DeleteDeviceUsageData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGatewayGroup` operation.
    ///
    /// See [`DeleteGatewayGroup`](crate::client::fluent_builders::DeleteGatewayGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_gateway_group(&self) -> fluent_builders::DeleteGatewayGroup<C, M, R> {
        fluent_builders::DeleteGatewayGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNetworkProfile` operation.
    ///
    /// See [`DeleteNetworkProfile`](crate::client::fluent_builders::DeleteNetworkProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_network_profile(&self) -> fluent_builders::DeleteNetworkProfile<C, M, R> {
        fluent_builders::DeleteNetworkProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProfile` operation.
    ///
    /// See [`DeleteProfile`](crate::client::fluent_builders::DeleteProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_profile(&self) -> fluent_builders::DeleteProfile<C, M, R> {
        fluent_builders::DeleteProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRoom` operation.
    ///
    /// See [`DeleteRoom`](crate::client::fluent_builders::DeleteRoom) for more information about the
    /// operation and its arguments.
    pub fn delete_room(&self) -> fluent_builders::DeleteRoom<C, M, R> {
        fluent_builders::DeleteRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRoomSkillParameter` operation.
    ///
    /// See [`DeleteRoomSkillParameter`](crate::client::fluent_builders::DeleteRoomSkillParameter) for more information about the
    /// operation and its arguments.
    pub fn delete_room_skill_parameter(
        &self,
    ) -> fluent_builders::DeleteRoomSkillParameter<C, M, R> {
        fluent_builders::DeleteRoomSkillParameter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSkillAuthorization` operation.
    ///
    /// See [`DeleteSkillAuthorization`](crate::client::fluent_builders::DeleteSkillAuthorization) for more information about the
    /// operation and its arguments.
    pub fn delete_skill_authorization(&self) -> fluent_builders::DeleteSkillAuthorization<C, M, R> {
        fluent_builders::DeleteSkillAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSkillGroup` operation.
    ///
    /// See [`DeleteSkillGroup`](crate::client::fluent_builders::DeleteSkillGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_skill_group(&self) -> fluent_builders::DeleteSkillGroup<C, M, R> {
        fluent_builders::DeleteSkillGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUser` operation.
    ///
    /// See [`DeleteUser`](crate::client::fluent_builders::DeleteUser) for more information about the
    /// operation and its arguments.
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateContactFromAddressBook` operation.
    ///
    /// See [`DisassociateContactFromAddressBook`](crate::client::fluent_builders::DisassociateContactFromAddressBook) for more information about the
    /// operation and its arguments.
    pub fn disassociate_contact_from_address_book(
        &self,
    ) -> fluent_builders::DisassociateContactFromAddressBook<C, M, R> {
        fluent_builders::DisassociateContactFromAddressBook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateDeviceFromRoom` operation.
    ///
    /// See [`DisassociateDeviceFromRoom`](crate::client::fluent_builders::DisassociateDeviceFromRoom) for more information about the
    /// operation and its arguments.
    pub fn disassociate_device_from_room(
        &self,
    ) -> fluent_builders::DisassociateDeviceFromRoom<C, M, R> {
        fluent_builders::DisassociateDeviceFromRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateSkillFromSkillGroup` operation.
    ///
    /// See [`DisassociateSkillFromSkillGroup`](crate::client::fluent_builders::DisassociateSkillFromSkillGroup) for more information about the
    /// operation and its arguments.
    pub fn disassociate_skill_from_skill_group(
        &self,
    ) -> fluent_builders::DisassociateSkillFromSkillGroup<C, M, R> {
        fluent_builders::DisassociateSkillFromSkillGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateSkillFromUsers` operation.
    ///
    /// See [`DisassociateSkillFromUsers`](crate::client::fluent_builders::DisassociateSkillFromUsers) for more information about the
    /// operation and its arguments.
    pub fn disassociate_skill_from_users(
        &self,
    ) -> fluent_builders::DisassociateSkillFromUsers<C, M, R> {
        fluent_builders::DisassociateSkillFromUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateSkillGroupFromRoom` operation.
    ///
    /// See [`DisassociateSkillGroupFromRoom`](crate::client::fluent_builders::DisassociateSkillGroupFromRoom) for more information about the
    /// operation and its arguments.
    pub fn disassociate_skill_group_from_room(
        &self,
    ) -> fluent_builders::DisassociateSkillGroupFromRoom<C, M, R> {
        fluent_builders::DisassociateSkillGroupFromRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ForgetSmartHomeAppliances` operation.
    ///
    /// See [`ForgetSmartHomeAppliances`](crate::client::fluent_builders::ForgetSmartHomeAppliances) for more information about the
    /// operation and its arguments.
    pub fn forget_smart_home_appliances(
        &self,
    ) -> fluent_builders::ForgetSmartHomeAppliances<C, M, R> {
        fluent_builders::ForgetSmartHomeAppliances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAddressBook` operation.
    ///
    /// See [`GetAddressBook`](crate::client::fluent_builders::GetAddressBook) for more information about the
    /// operation and its arguments.
    pub fn get_address_book(&self) -> fluent_builders::GetAddressBook<C, M, R> {
        fluent_builders::GetAddressBook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConferencePreference` operation.
    ///
    /// See [`GetConferencePreference`](crate::client::fluent_builders::GetConferencePreference) for more information about the
    /// operation and its arguments.
    pub fn get_conference_preference(&self) -> fluent_builders::GetConferencePreference<C, M, R> {
        fluent_builders::GetConferencePreference::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConferenceProvider` operation.
    ///
    /// See [`GetConferenceProvider`](crate::client::fluent_builders::GetConferenceProvider) for more information about the
    /// operation and its arguments.
    pub fn get_conference_provider(&self) -> fluent_builders::GetConferenceProvider<C, M, R> {
        fluent_builders::GetConferenceProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContact` operation.
    ///
    /// See [`GetContact`](crate::client::fluent_builders::GetContact) for more information about the
    /// operation and its arguments.
    pub fn get_contact(&self) -> fluent_builders::GetContact<C, M, R> {
        fluent_builders::GetContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDevice` operation.
    ///
    /// See [`GetDevice`](crate::client::fluent_builders::GetDevice) for more information about the
    /// operation and its arguments.
    pub fn get_device(&self) -> fluent_builders::GetDevice<C, M, R> {
        fluent_builders::GetDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGateway` operation.
    ///
    /// See [`GetGateway`](crate::client::fluent_builders::GetGateway) for more information about the
    /// operation and its arguments.
    pub fn get_gateway(&self) -> fluent_builders::GetGateway<C, M, R> {
        fluent_builders::GetGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGatewayGroup` operation.
    ///
    /// See [`GetGatewayGroup`](crate::client::fluent_builders::GetGatewayGroup) for more information about the
    /// operation and its arguments.
    pub fn get_gateway_group(&self) -> fluent_builders::GetGatewayGroup<C, M, R> {
        fluent_builders::GetGatewayGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInvitationConfiguration` operation.
    ///
    /// See [`GetInvitationConfiguration`](crate::client::fluent_builders::GetInvitationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_invitation_configuration(
        &self,
    ) -> fluent_builders::GetInvitationConfiguration<C, M, R> {
        fluent_builders::GetInvitationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNetworkProfile` operation.
    ///
    /// See [`GetNetworkProfile`](crate::client::fluent_builders::GetNetworkProfile) for more information about the
    /// operation and its arguments.
    pub fn get_network_profile(&self) -> fluent_builders::GetNetworkProfile<C, M, R> {
        fluent_builders::GetNetworkProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetProfile` operation.
    ///
    /// See [`GetProfile`](crate::client::fluent_builders::GetProfile) for more information about the
    /// operation and its arguments.
    pub fn get_profile(&self) -> fluent_builders::GetProfile<C, M, R> {
        fluent_builders::GetProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRoom` operation.
    ///
    /// See [`GetRoom`](crate::client::fluent_builders::GetRoom) for more information about the
    /// operation and its arguments.
    pub fn get_room(&self) -> fluent_builders::GetRoom<C, M, R> {
        fluent_builders::GetRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRoomSkillParameter` operation.
    ///
    /// See [`GetRoomSkillParameter`](crate::client::fluent_builders::GetRoomSkillParameter) for more information about the
    /// operation and its arguments.
    pub fn get_room_skill_parameter(&self) -> fluent_builders::GetRoomSkillParameter<C, M, R> {
        fluent_builders::GetRoomSkillParameter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSkillGroup` operation.
    ///
    /// See [`GetSkillGroup`](crate::client::fluent_builders::GetSkillGroup) for more information about the
    /// operation and its arguments.
    pub fn get_skill_group(&self) -> fluent_builders::GetSkillGroup<C, M, R> {
        fluent_builders::GetSkillGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBusinessReportSchedules` operation.
    ///
    /// See [`ListBusinessReportSchedules`](crate::client::fluent_builders::ListBusinessReportSchedules) for more information about the
    /// operation and its arguments.
    pub fn list_business_report_schedules(
        &self,
    ) -> fluent_builders::ListBusinessReportSchedules<C, M, R> {
        fluent_builders::ListBusinessReportSchedules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConferenceProviders` operation.
    ///
    /// See [`ListConferenceProviders`](crate::client::fluent_builders::ListConferenceProviders) for more information about the
    /// operation and its arguments.
    pub fn list_conference_providers(&self) -> fluent_builders::ListConferenceProviders<C, M, R> {
        fluent_builders::ListConferenceProviders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeviceEvents` operation.
    ///
    /// See [`ListDeviceEvents`](crate::client::fluent_builders::ListDeviceEvents) for more information about the
    /// operation and its arguments.
    pub fn list_device_events(&self) -> fluent_builders::ListDeviceEvents<C, M, R> {
        fluent_builders::ListDeviceEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGatewayGroups` operation.
    ///
    /// See [`ListGatewayGroups`](crate::client::fluent_builders::ListGatewayGroups) for more information about the
    /// operation and its arguments.
    pub fn list_gateway_groups(&self) -> fluent_builders::ListGatewayGroups<C, M, R> {
        fluent_builders::ListGatewayGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGateways` operation.
    ///
    /// See [`ListGateways`](crate::client::fluent_builders::ListGateways) for more information about the
    /// operation and its arguments.
    pub fn list_gateways(&self) -> fluent_builders::ListGateways<C, M, R> {
        fluent_builders::ListGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSkills` operation.
    ///
    /// See [`ListSkills`](crate::client::fluent_builders::ListSkills) for more information about the
    /// operation and its arguments.
    pub fn list_skills(&self) -> fluent_builders::ListSkills<C, M, R> {
        fluent_builders::ListSkills::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSkillsStoreCategories` operation.
    ///
    /// See [`ListSkillsStoreCategories`](crate::client::fluent_builders::ListSkillsStoreCategories) for more information about the
    /// operation and its arguments.
    pub fn list_skills_store_categories(
        &self,
    ) -> fluent_builders::ListSkillsStoreCategories<C, M, R> {
        fluent_builders::ListSkillsStoreCategories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSkillsStoreSkillsByCategory` operation.
    ///
    /// See [`ListSkillsStoreSkillsByCategory`](crate::client::fluent_builders::ListSkillsStoreSkillsByCategory) for more information about the
    /// operation and its arguments.
    pub fn list_skills_store_skills_by_category(
        &self,
    ) -> fluent_builders::ListSkillsStoreSkillsByCategory<C, M, R> {
        fluent_builders::ListSkillsStoreSkillsByCategory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSmartHomeAppliances` operation.
    ///
    /// See [`ListSmartHomeAppliances`](crate::client::fluent_builders::ListSmartHomeAppliances) for more information about the
    /// operation and its arguments.
    pub fn list_smart_home_appliances(&self) -> fluent_builders::ListSmartHomeAppliances<C, M, R> {
        fluent_builders::ListSmartHomeAppliances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTags` operation.
    ///
    /// See [`ListTags`](crate::client::fluent_builders::ListTags) for more information about the
    /// operation and its arguments.
    pub fn list_tags(&self) -> fluent_builders::ListTags<C, M, R> {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutConferencePreference` operation.
    ///
    /// See [`PutConferencePreference`](crate::client::fluent_builders::PutConferencePreference) for more information about the
    /// operation and its arguments.
    pub fn put_conference_preference(&self) -> fluent_builders::PutConferencePreference<C, M, R> {
        fluent_builders::PutConferencePreference::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutInvitationConfiguration` operation.
    ///
    /// See [`PutInvitationConfiguration`](crate::client::fluent_builders::PutInvitationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_invitation_configuration(
        &self,
    ) -> fluent_builders::PutInvitationConfiguration<C, M, R> {
        fluent_builders::PutInvitationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRoomSkillParameter` operation.
    ///
    /// See [`PutRoomSkillParameter`](crate::client::fluent_builders::PutRoomSkillParameter) for more information about the
    /// operation and its arguments.
    pub fn put_room_skill_parameter(&self) -> fluent_builders::PutRoomSkillParameter<C, M, R> {
        fluent_builders::PutRoomSkillParameter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutSkillAuthorization` operation.
    ///
    /// See [`PutSkillAuthorization`](crate::client::fluent_builders::PutSkillAuthorization) for more information about the
    /// operation and its arguments.
    pub fn put_skill_authorization(&self) -> fluent_builders::PutSkillAuthorization<C, M, R> {
        fluent_builders::PutSkillAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterAVSDevice` operation.
    ///
    /// See [`RegisterAVSDevice`](crate::client::fluent_builders::RegisterAVSDevice) for more information about the
    /// operation and its arguments.
    pub fn register_avs_device(&self) -> fluent_builders::RegisterAVSDevice<C, M, R> {
        fluent_builders::RegisterAVSDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectSkill` operation.
    ///
    /// See [`RejectSkill`](crate::client::fluent_builders::RejectSkill) for more information about the
    /// operation and its arguments.
    pub fn reject_skill(&self) -> fluent_builders::RejectSkill<C, M, R> {
        fluent_builders::RejectSkill::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResolveRoom` operation.
    ///
    /// See [`ResolveRoom`](crate::client::fluent_builders::ResolveRoom) for more information about the
    /// operation and its arguments.
    pub fn resolve_room(&self) -> fluent_builders::ResolveRoom<C, M, R> {
        fluent_builders::ResolveRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeInvitation` operation.
    ///
    /// See [`RevokeInvitation`](crate::client::fluent_builders::RevokeInvitation) for more information about the
    /// operation and its arguments.
    pub fn revoke_invitation(&self) -> fluent_builders::RevokeInvitation<C, M, R> {
        fluent_builders::RevokeInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchAddressBooks` operation.
    ///
    /// See [`SearchAddressBooks`](crate::client::fluent_builders::SearchAddressBooks) for more information about the
    /// operation and its arguments.
    pub fn search_address_books(&self) -> fluent_builders::SearchAddressBooks<C, M, R> {
        fluent_builders::SearchAddressBooks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchContacts` operation.
    ///
    /// See [`SearchContacts`](crate::client::fluent_builders::SearchContacts) for more information about the
    /// operation and its arguments.
    pub fn search_contacts(&self) -> fluent_builders::SearchContacts<C, M, R> {
        fluent_builders::SearchContacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchDevices` operation.
    ///
    /// See [`SearchDevices`](crate::client::fluent_builders::SearchDevices) for more information about the
    /// operation and its arguments.
    pub fn search_devices(&self) -> fluent_builders::SearchDevices<C, M, R> {
        fluent_builders::SearchDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchNetworkProfiles` operation.
    ///
    /// See [`SearchNetworkProfiles`](crate::client::fluent_builders::SearchNetworkProfiles) for more information about the
    /// operation and its arguments.
    pub fn search_network_profiles(&self) -> fluent_builders::SearchNetworkProfiles<C, M, R> {
        fluent_builders::SearchNetworkProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchProfiles` operation.
    ///
    /// See [`SearchProfiles`](crate::client::fluent_builders::SearchProfiles) for more information about the
    /// operation and its arguments.
    pub fn search_profiles(&self) -> fluent_builders::SearchProfiles<C, M, R> {
        fluent_builders::SearchProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchRooms` operation.
    ///
    /// See [`SearchRooms`](crate::client::fluent_builders::SearchRooms) for more information about the
    /// operation and its arguments.
    pub fn search_rooms(&self) -> fluent_builders::SearchRooms<C, M, R> {
        fluent_builders::SearchRooms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchSkillGroups` operation.
    ///
    /// See [`SearchSkillGroups`](crate::client::fluent_builders::SearchSkillGroups) for more information about the
    /// operation and its arguments.
    pub fn search_skill_groups(&self) -> fluent_builders::SearchSkillGroups<C, M, R> {
        fluent_builders::SearchSkillGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchUsers` operation.
    ///
    /// See [`SearchUsers`](crate::client::fluent_builders::SearchUsers) for more information about the
    /// operation and its arguments.
    pub fn search_users(&self) -> fluent_builders::SearchUsers<C, M, R> {
        fluent_builders::SearchUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendAnnouncement` operation.
    ///
    /// See [`SendAnnouncement`](crate::client::fluent_builders::SendAnnouncement) for more information about the
    /// operation and its arguments.
    pub fn send_announcement(&self) -> fluent_builders::SendAnnouncement<C, M, R> {
        fluent_builders::SendAnnouncement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendInvitation` operation.
    ///
    /// See [`SendInvitation`](crate::client::fluent_builders::SendInvitation) for more information about the
    /// operation and its arguments.
    pub fn send_invitation(&self) -> fluent_builders::SendInvitation<C, M, R> {
        fluent_builders::SendInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDeviceSync` operation.
    ///
    /// See [`StartDeviceSync`](crate::client::fluent_builders::StartDeviceSync) for more information about the
    /// operation and its arguments.
    pub fn start_device_sync(&self) -> fluent_builders::StartDeviceSync<C, M, R> {
        fluent_builders::StartDeviceSync::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartSmartHomeApplianceDiscovery` operation.
    ///
    /// See [`StartSmartHomeApplianceDiscovery`](crate::client::fluent_builders::StartSmartHomeApplianceDiscovery) for more information about the
    /// operation and its arguments.
    pub fn start_smart_home_appliance_discovery(
        &self,
    ) -> fluent_builders::StartSmartHomeApplianceDiscovery<C, M, R> {
        fluent_builders::StartSmartHomeApplianceDiscovery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAddressBook` operation.
    ///
    /// See [`UpdateAddressBook`](crate::client::fluent_builders::UpdateAddressBook) for more information about the
    /// operation and its arguments.
    pub fn update_address_book(&self) -> fluent_builders::UpdateAddressBook<C, M, R> {
        fluent_builders::UpdateAddressBook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBusinessReportSchedule` operation.
    ///
    /// See [`UpdateBusinessReportSchedule`](crate::client::fluent_builders::UpdateBusinessReportSchedule) for more information about the
    /// operation and its arguments.
    pub fn update_business_report_schedule(
        &self,
    ) -> fluent_builders::UpdateBusinessReportSchedule<C, M, R> {
        fluent_builders::UpdateBusinessReportSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConferenceProvider` operation.
    ///
    /// See [`UpdateConferenceProvider`](crate::client::fluent_builders::UpdateConferenceProvider) for more information about the
    /// operation and its arguments.
    pub fn update_conference_provider(&self) -> fluent_builders::UpdateConferenceProvider<C, M, R> {
        fluent_builders::UpdateConferenceProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContact` operation.
    ///
    /// See [`UpdateContact`](crate::client::fluent_builders::UpdateContact) for more information about the
    /// operation and its arguments.
    pub fn update_contact(&self) -> fluent_builders::UpdateContact<C, M, R> {
        fluent_builders::UpdateContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDevice` operation.
    ///
    /// See [`UpdateDevice`](crate::client::fluent_builders::UpdateDevice) for more information about the
    /// operation and its arguments.
    pub fn update_device(&self) -> fluent_builders::UpdateDevice<C, M, R> {
        fluent_builders::UpdateDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGateway` operation.
    ///
    /// See [`UpdateGateway`](crate::client::fluent_builders::UpdateGateway) for more information about the
    /// operation and its arguments.
    pub fn update_gateway(&self) -> fluent_builders::UpdateGateway<C, M, R> {
        fluent_builders::UpdateGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGatewayGroup` operation.
    ///
    /// See [`UpdateGatewayGroup`](crate::client::fluent_builders::UpdateGatewayGroup) for more information about the
    /// operation and its arguments.
    pub fn update_gateway_group(&self) -> fluent_builders::UpdateGatewayGroup<C, M, R> {
        fluent_builders::UpdateGatewayGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateNetworkProfile` operation.
    ///
    /// See [`UpdateNetworkProfile`](crate::client::fluent_builders::UpdateNetworkProfile) for more information about the
    /// operation and its arguments.
    pub fn update_network_profile(&self) -> fluent_builders::UpdateNetworkProfile<C, M, R> {
        fluent_builders::UpdateNetworkProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProfile` operation.
    ///
    /// See [`UpdateProfile`](crate::client::fluent_builders::UpdateProfile) for more information about the
    /// operation and its arguments.
    pub fn update_profile(&self) -> fluent_builders::UpdateProfile<C, M, R> {
        fluent_builders::UpdateProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRoom` operation.
    ///
    /// See [`UpdateRoom`](crate::client::fluent_builders::UpdateRoom) for more information about the
    /// operation and its arguments.
    pub fn update_room(&self) -> fluent_builders::UpdateRoom<C, M, R> {
        fluent_builders::UpdateRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSkillGroup` operation.
    ///
    /// See [`UpdateSkillGroup`](crate::client::fluent_builders::UpdateSkillGroup) for more information about the
    /// operation and its arguments.
    pub fn update_skill_group(&self) -> fluent_builders::UpdateSkillGroup<C, M, R> {
        fluent_builders::UpdateSkillGroup::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ApproveSkill`.
    ///
    /// <p>Associates a skill with the organization under the customer's AWS account. If a skill
    /// is private, the user implicitly accepts access to this skill during enablement.</p>
    #[derive(std::fmt::Debug)]
    pub struct ApproveSkill<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::approve_skill_input::Builder,
    }
    impl<C, M, R> ApproveSkill<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ApproveSkill`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApproveSkillOutput,
            aws_smithy_http::result::SdkError<crate::error::ApproveSkillError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ApproveSkillInputOperationOutputAlias,
                crate::output::ApproveSkillOutput,
                crate::error::ApproveSkillError,
                crate::input::ApproveSkillInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the skill.</p>
        pub fn skill_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_id(inp);
            self
        }
        /// <p>The unique identifier of the skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_skill_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateContactWithAddressBook`.
    ///
    /// <p>Associates a contact with a given address book.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateContactWithAddressBook<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_contact_with_address_book_input::Builder,
    }
    impl<C, M, R> AssociateContactWithAddressBook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateContactWithAddressBook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateContactWithAddressBookOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateContactWithAddressBookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateContactWithAddressBookInputOperationOutputAlias,
                crate::output::AssociateContactWithAddressBookOutput,
                crate::error::AssociateContactWithAddressBookError,
                crate::input::AssociateContactWithAddressBookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the contact to associate with an address book.</p>
        pub fn contact_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_arn(inp);
            self
        }
        /// <p>The ARN of the contact to associate with an address book.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_arn(input);
            self
        }
        /// <p>The ARN of the address book with which to associate the contact.</p>
        pub fn address_book_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address_book_arn(inp);
            self
        }
        /// <p>The ARN of the address book with which to associate the contact.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_address_book_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateDeviceWithNetworkProfile`.
    ///
    /// <p>Associates a device with the specified network profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateDeviceWithNetworkProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_device_with_network_profile_input::Builder,
    }
    impl<C, M, R> AssociateDeviceWithNetworkProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateDeviceWithNetworkProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDeviceWithNetworkProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDeviceWithNetworkProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateDeviceWithNetworkProfileInputOperationOutputAlias,
                crate::output::AssociateDeviceWithNetworkProfileOutput,
                crate::error::AssociateDeviceWithNetworkProfileError,
                crate::input::AssociateDeviceWithNetworkProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The device ARN.</p>
        pub fn device_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_arn(inp);
            self
        }
        /// <p>The device ARN.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_arn(input);
            self
        }
        /// <p>The ARN of the network profile to associate with a device.</p>
        pub fn network_profile_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_profile_arn(inp);
            self
        }
        /// <p>The ARN of the network profile to associate with a device.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_profile_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateDeviceWithRoom`.
    ///
    /// <p>Associates a device with a given room. This applies all the settings from the room
    /// profile to the device, and all the skills in any skill groups added to that room. This
    /// operation requires the device to be online, or else a manual sync is required. </p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateDeviceWithRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_device_with_room_input::Builder,
    }
    impl<C, M, R> AssociateDeviceWithRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateDeviceWithRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDeviceWithRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDeviceWithRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateDeviceWithRoomInputOperationOutputAlias,
                crate::output::AssociateDeviceWithRoomOutput,
                crate::error::AssociateDeviceWithRoomError,
                crate::input::AssociateDeviceWithRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the device to associate to a room. Required.</p>
        pub fn device_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_arn(inp);
            self
        }
        /// <p>The ARN of the device to associate to a room. Required.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_arn(input);
            self
        }
        /// <p>The ARN of the room with which to associate the device. Required.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The ARN of the room with which to associate the device. Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateSkillGroupWithRoom`.
    ///
    /// <p>Associates a skill group with a given room. This enables all skills in the associated
    /// skill group on all devices in the room.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateSkillGroupWithRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_skill_group_with_room_input::Builder,
    }
    impl<C, M, R> AssociateSkillGroupWithRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateSkillGroupWithRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateSkillGroupWithRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateSkillGroupWithRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateSkillGroupWithRoomInputOperationOutputAlias,
                crate::output::AssociateSkillGroupWithRoomOutput,
                crate::error::AssociateSkillGroupWithRoomError,
                crate::input::AssociateSkillGroupWithRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the skill group to associate with a room. Required.</p>
        pub fn skill_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_group_arn(inp);
            self
        }
        /// <p>The ARN of the skill group to associate with a room. Required.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_skill_group_arn(input);
            self
        }
        /// <p>The ARN of the room with which to associate the skill group. Required.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The ARN of the room with which to associate the skill group. Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateSkillWithSkillGroup`.
    ///
    /// <p>Associates a skill with a skill group.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateSkillWithSkillGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_skill_with_skill_group_input::Builder,
    }
    impl<C, M, R> AssociateSkillWithSkillGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateSkillWithSkillGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateSkillWithSkillGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateSkillWithSkillGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateSkillWithSkillGroupInputOperationOutputAlias,
                crate::output::AssociateSkillWithSkillGroupOutput,
                crate::error::AssociateSkillWithSkillGroupError,
                crate::input::AssociateSkillWithSkillGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the skill group to associate the skill to. Required.</p>
        pub fn skill_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_group_arn(inp);
            self
        }
        /// <p>The ARN of the skill group to associate the skill to. Required.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_skill_group_arn(input);
            self
        }
        /// <p>The unique identifier of the skill.</p>
        pub fn skill_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_id(inp);
            self
        }
        /// <p>The unique identifier of the skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_skill_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateSkillWithUsers`.
    ///
    /// <p>Makes a private skill available for enrolled users to enable on their devices.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateSkillWithUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_skill_with_users_input::Builder,
    }
    impl<C, M, R> AssociateSkillWithUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateSkillWithUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateSkillWithUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateSkillWithUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateSkillWithUsersInputOperationOutputAlias,
                crate::output::AssociateSkillWithUsersOutput,
                crate::error::AssociateSkillWithUsersError,
                crate::input::AssociateSkillWithUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The private skill ID you want to make available to enrolled users.</p>
        pub fn skill_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_id(inp);
            self
        }
        /// <p>The private skill ID you want to make available to enrolled users.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_skill_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAddressBook`.
    ///
    /// <p>Creates an address book with the specified details.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAddressBook<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_address_book_input::Builder,
    }
    impl<C, M, R> CreateAddressBook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAddressBook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAddressBookOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAddressBookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAddressBookInputOperationOutputAlias,
                crate::output::CreateAddressBookOutput,
                crate::error::CreateAddressBookError,
                crate::input::CreateAddressBookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the address book.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the address book.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the address book.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the address book.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique, user-specified identifier for the request that ensures
        /// idempotency.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, user-specified identifier for the request that ensures
        /// idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBusinessReportSchedule`.
    ///
    /// <p>Creates a recurring schedule for usage reports to deliver to the specified S3
    /// location with a specified daily or weekly interval.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBusinessReportSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_business_report_schedule_input::Builder,
    }
    impl<C, M, R> CreateBusinessReportSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBusinessReportSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBusinessReportScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBusinessReportScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBusinessReportScheduleInputOperationOutputAlias,
                crate::output::CreateBusinessReportScheduleOutput,
                crate::error::CreateBusinessReportScheduleError,
                crate::input::CreateBusinessReportScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name identifier of the schedule.</p>
        pub fn schedule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_name(inp);
            self
        }
        /// <p>The name identifier of the schedule.</p>
        pub fn set_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_name(input);
            self
        }
        /// <p>The S3 bucket name of the output reports. If this isn't specified, the report can be
        /// retrieved from a download link by calling ListBusinessReportSchedule. </p>
        pub fn s3_bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_name(inp);
            self
        }
        /// <p>The S3 bucket name of the output reports. If this isn't specified, the report can be
        /// retrieved from a download link by calling ListBusinessReportSchedule. </p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_name(input);
            self
        }
        /// <p>The S3 key where the report is delivered.</p>
        pub fn s3_key_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_key_prefix(inp);
            self
        }
        /// <p>The S3 key where the report is delivered.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_key_prefix(input);
            self
        }
        /// <p>The format of the generated report (individual CSV files or zipped files of
        /// individual files).</p>
        pub fn format(mut self, inp: crate::model::BusinessReportFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>The format of the generated report (individual CSV files or zipped files of
        /// individual files).</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::BusinessReportFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>The content range of the reports.</p>
        pub fn content_range(mut self, inp: crate::model::BusinessReportContentRange) -> Self {
            self.inner = self.inner.content_range(inp);
            self
        }
        /// <p>The content range of the reports.</p>
        pub fn set_content_range(
            mut self,
            input: std::option::Option<crate::model::BusinessReportContentRange>,
        ) -> Self {
            self.inner = self.inner.set_content_range(input);
            self
        }
        /// <p>The recurrence of the reports. If this isn't specified, the report will only be
        /// delivered one time when the API is called. </p>
        pub fn recurrence(mut self, inp: crate::model::BusinessReportRecurrence) -> Self {
            self.inner = self.inner.recurrence(inp);
            self
        }
        /// <p>The recurrence of the reports. If this isn't specified, the report will only be
        /// delivered one time when the API is called. </p>
        pub fn set_recurrence(
            mut self,
            input: std::option::Option<crate::model::BusinessReportRecurrence>,
        ) -> Self {
            self.inner = self.inner.set_recurrence(input);
            self
        }
        /// <p>The client request token.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The client request token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the business report schedule.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags for the business report schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConferenceProvider`.
    ///
    /// <p>Adds a new conference provider under the user's AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConferenceProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_conference_provider_input::Builder,
    }
    impl<C, M, R> CreateConferenceProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConferenceProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConferenceProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConferenceProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConferenceProviderInputOperationOutputAlias,
                crate::output::CreateConferenceProviderOutput,
                crate::error::CreateConferenceProviderError,
                crate::input::CreateConferenceProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the conference provider.</p>
        pub fn conference_provider_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conference_provider_name(inp);
            self
        }
        /// <p>The name of the conference provider.</p>
        pub fn set_conference_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_conference_provider_name(input);
            self
        }
        /// <p>Represents a type within a list of predefined types.</p>
        pub fn conference_provider_type(
            mut self,
            inp: crate::model::ConferenceProviderType,
        ) -> Self {
            self.inner = self.inner.conference_provider_type(inp);
            self
        }
        /// <p>Represents a type within a list of predefined types.</p>
        pub fn set_conference_provider_type(
            mut self,
            input: std::option::Option<crate::model::ConferenceProviderType>,
        ) -> Self {
            self.inner = self.inner.set_conference_provider_type(input);
            self
        }
        /// <p>The IP endpoint and protocol for calling.</p>
        pub fn ip_dial_in(mut self, inp: crate::model::IpDialIn) -> Self {
            self.inner = self.inner.ip_dial_in(inp);
            self
        }
        /// <p>The IP endpoint and protocol for calling.</p>
        pub fn set_ip_dial_in(
            mut self,
            input: std::option::Option<crate::model::IpDialIn>,
        ) -> Self {
            self.inner = self.inner.set_ip_dial_in(input);
            self
        }
        /// <p>The information for PSTN conferencing.</p>
        pub fn pstn_dial_in(mut self, inp: crate::model::PstnDialIn) -> Self {
            self.inner = self.inner.pstn_dial_in(inp);
            self
        }
        /// <p>The information for PSTN conferencing.</p>
        pub fn set_pstn_dial_in(
            mut self,
            input: std::option::Option<crate::model::PstnDialIn>,
        ) -> Self {
            self.inner = self.inner.set_pstn_dial_in(input);
            self
        }
        /// <p>The meeting settings for the conference provider.</p>
        pub fn meeting_setting(mut self, inp: crate::model::MeetingSetting) -> Self {
            self.inner = self.inner.meeting_setting(inp);
            self
        }
        /// <p>The meeting settings for the conference provider.</p>
        pub fn set_meeting_setting(
            mut self,
            input: std::option::Option<crate::model::MeetingSetting>,
        ) -> Self {
            self.inner = self.inner.set_meeting_setting(input);
            self
        }
        /// <p>The request token of the client.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The request token of the client.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContact`.
    ///
    /// <p>Creates a contact with the specified details.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_contact_input::Builder,
    }
    impl<C, M, R> CreateContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContactInputOperationOutputAlias,
                crate::output::CreateContactOutput,
                crate::error::CreateContactError,
                crate::input::CreateContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact to display on the console.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The name of the contact to display on the console.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The first name of the contact that is used to call the contact on the
        /// device.</p>
        pub fn first_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.first_name(inp);
            self
        }
        /// <p>The first name of the contact that is used to call the contact on the
        /// device.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_first_name(input);
            self
        }
        /// <p>The last name of the contact that is used to call the contact on the
        /// device.</p>
        pub fn last_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.last_name(inp);
            self
        }
        /// <p>The last name of the contact that is used to call the contact on the
        /// device.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_last_name(input);
            self
        }
        /// <p>The phone number of the contact in E.164 format. The phone number type defaults to
        /// WORK. You can specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
        /// which lets you specify the phone number type and multiple numbers.</p>
        pub fn phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number(inp);
            self
        }
        /// <p>The phone number of the contact in E.164 format. The phone number type defaults to
        /// WORK. You can specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
        /// which lets you specify the phone number type and multiple numbers.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_phone_number(input);
            self
        }
        /// Appends an item to `PhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_phone_numbers`](Self::set_phone_numbers).
        ///
        /// <p>The list of phone numbers for the contact.</p>
        pub fn phone_numbers(mut self, inp: impl Into<crate::model::PhoneNumber>) -> Self {
            self.inner = self.inner.phone_numbers(inp);
            self
        }
        /// <p>The list of phone numbers for the contact.</p>
        pub fn set_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
        ) -> Self {
            self.inner = self.inner.set_phone_numbers(input);
            self
        }
        /// Appends an item to `SipAddresses`.
        ///
        /// To override the contents of this collection use [`set_sip_addresses`](Self::set_sip_addresses).
        ///
        /// <p>The list of SIP addresses for the contact.</p>
        pub fn sip_addresses(mut self, inp: impl Into<crate::model::SipAddress>) -> Self {
            self.inner = self.inner.sip_addresses(inp);
            self
        }
        /// <p>The list of SIP addresses for the contact.</p>
        pub fn set_sip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
        ) -> Self {
            self.inner = self.inner.set_sip_addresses(input);
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures
        /// idempotency.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures
        /// idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGatewayGroup`.
    ///
    /// <p>Creates a gateway group with the specified details.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGatewayGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_gateway_group_input::Builder,
    }
    impl<C, M, R> CreateGatewayGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGatewayGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGatewayGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGatewayGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGatewayGroupInputOperationOutputAlias,
                crate::output::CreateGatewayGroupOutput,
                crate::error::CreateGatewayGroupError,
                crate::input::CreateGatewayGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the gateway group.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the gateway group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the gateway group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the gateway group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> A unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p> A unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNetworkProfile`.
    ///
    /// <p>Creates a network profile with the specified details.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateNetworkProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_network_profile_input::Builder,
    }
    impl<C, M, R> CreateNetworkProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNetworkProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNetworkProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNetworkProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNetworkProfileInputOperationOutputAlias,
                crate::output::CreateNetworkProfileOutput,
                crate::error::CreateNetworkProfileError,
                crate::input::CreateNetworkProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn network_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_profile_name(inp);
            self
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn set_network_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_profile_name(input);
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The SSID of the Wi-Fi network.</p>
        pub fn ssid(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssid(inp);
            self
        }
        /// <p>The SSID of the Wi-Fi network.</p>
        pub fn set_ssid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ssid(input);
            self
        }
        /// <p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK,
        /// WEP, or OPEN.</p>
        pub fn security_type(mut self, inp: crate::model::NetworkSecurityType) -> Self {
            self.inner = self.inner.security_type(inp);
            self
        }
        /// <p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK,
        /// WEP, or OPEN.</p>
        pub fn set_security_type(
            mut self,
            input: std::option::Option<crate::model::NetworkSecurityType>,
        ) -> Self {
            self.inner = self.inner.set_security_type(input);
            self
        }
        /// <p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is
        /// supported.</p>
        pub fn eap_method(mut self, inp: crate::model::NetworkEapMethod) -> Self {
            self.inner = self.inner.eap_method(inp);
            self
        }
        /// <p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is
        /// supported.</p>
        pub fn set_eap_method(
            mut self,
            input: std::option::Option<crate::model::NetworkEapMethod>,
        ) -> Self {
            self.inner = self.inner.set_eap_method(input);
            self
        }
        /// <p>The current password of the Wi-Fi network.</p>
        pub fn current_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_password(inp);
            self
        }
        /// <p>The current password of the Wi-Fi network.</p>
        pub fn set_current_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_password(input);
            self
        }
        /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
        /// transmitted to the device and is used when the password of the network changes to
        /// NextPassword. </p>
        pub fn next_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_password(inp);
            self
        }
        /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
        /// transmitted to the device and is used when the password of the network changes to
        /// NextPassword. </p>
        pub fn set_next_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_password(input);
            self
        }
        /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
        /// (ACM). This is used to issue certificates to the devices. </p>
        pub fn certificate_authority_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(inp);
            self
        }
        /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
        /// (ACM). This is used to issue certificates to the devices. </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// Appends an item to `TrustAnchors`.
        ///
        /// To override the contents of this collection use [`set_trust_anchors`](Self::set_trust_anchors).
        ///
        /// <p>The root certificates of your authentication server that is installed on your devices
        /// and used to trust your authentication server during EAP negotiation. </p>
        pub fn trust_anchors(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_anchors(inp);
            self
        }
        /// <p>The root certificates of your authentication server that is installed on your devices
        /// and used to trust your authentication server during EAP negotiation. </p>
        pub fn set_trust_anchors(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_trust_anchors(input);
            self
        }
        /// <p>A unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProfile`.
    ///
    /// <p>Creates a new room profile with the specified details.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_profile_input::Builder,
    }
    impl<C, M, R> CreateProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProfileInputOperationOutputAlias,
                crate::output::CreateProfileOutput,
                crate::error::CreateProfileError,
                crate::input::CreateProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a room profile.</p>
        pub fn profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(inp);
            self
        }
        /// <p>The name of a room profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>The time zone used by a room profile.</p>
        pub fn timezone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.timezone(inp);
            self
        }
        /// <p>The time zone used by a room profile.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_timezone(input);
            self
        }
        /// <p>The valid address for the room.</p>
        pub fn address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address(inp);
            self
        }
        /// <p>The valid address for the room.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_address(input);
            self
        }
        /// <p>The distance unit to be used by devices in the profile.</p>
        pub fn distance_unit(mut self, inp: crate::model::DistanceUnit) -> Self {
            self.inner = self.inner.distance_unit(inp);
            self
        }
        /// <p>The distance unit to be used by devices in the profile.</p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.inner = self.inner.set_distance_unit(input);
            self
        }
        /// <p>The temperature unit to be used by devices in the profile.</p>
        pub fn temperature_unit(mut self, inp: crate::model::TemperatureUnit) -> Self {
            self.inner = self.inner.temperature_unit(inp);
            self
        }
        /// <p>The temperature unit to be used by devices in the profile.</p>
        pub fn set_temperature_unit(
            mut self,
            input: std::option::Option<crate::model::TemperatureUnit>,
        ) -> Self {
            self.inner = self.inner.set_temperature_unit(input);
            self
        }
        /// <p>A wake word for Alexa, Echo, Amazon, or a computer.</p>
        pub fn wake_word(mut self, inp: crate::model::WakeWord) -> Self {
            self.inner = self.inner.wake_word(inp);
            self
        }
        /// <p>A wake word for Alexa, Echo, Amazon, or a computer.</p>
        pub fn set_wake_word(mut self, input: std::option::Option<crate::model::WakeWord>) -> Self {
            self.inner = self.inner.set_wake_word(input);
            self
        }
        /// <p>The locale of the room profile. (This is currently only available to a limited preview audience.)</p>
        pub fn locale(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale(inp);
            self
        }
        /// <p>The locale of the room profile. (This is currently only available to a limited preview audience.)</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>The user-specified token that is used during the creation of a profile.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The user-specified token that is used during the creation of a profile.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Whether room profile setup is enabled.</p>
        pub fn setup_mode_disabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.setup_mode_disabled(inp);
            self
        }
        /// <p>Whether room profile setup is enabled.</p>
        pub fn set_setup_mode_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_setup_mode_disabled(input);
            self
        }
        /// <p>The maximum volume limit for a room profile.</p>
        pub fn max_volume_limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_volume_limit(inp);
            self
        }
        /// <p>The maximum volume limit for a room profile.</p>
        pub fn set_max_volume_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_volume_limit(input);
            self
        }
        /// <p>Whether PSTN calling is enabled.</p>
        pub fn pstn_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.pstn_enabled(inp);
            self
        }
        /// <p>Whether PSTN calling is enabled.</p>
        pub fn set_pstn_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_pstn_enabled(input);
            self
        }
        /// <p>Whether data retention of the profile is enabled.</p>
        pub fn data_retention_opt_in(mut self, inp: bool) -> Self {
            self.inner = self.inner.data_retention_opt_in(inp);
            self
        }
        /// <p>Whether data retention of the profile is enabled.</p>
        pub fn set_data_retention_opt_in(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_data_retention_opt_in(input);
            self
        }
        /// <p>The meeting room settings of a room profile.</p>
        pub fn meeting_room_configuration(
            mut self,
            inp: crate::model::CreateMeetingRoomConfiguration,
        ) -> Self {
            self.inner = self.inner.meeting_room_configuration(inp);
            self
        }
        /// <p>The meeting room settings of a room profile.</p>
        pub fn set_meeting_room_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateMeetingRoomConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_meeting_room_configuration(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the profile.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags for the profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoom`.
    ///
    /// <p>Creates a room with the specified details.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_room_input::Builder,
    }
    impl<C, M, R> CreateRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRoomInputOperationOutputAlias,
                crate::output::CreateRoomOutput,
                crate::error::CreateRoomError,
                crate::input::CreateRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the room.</p>
        pub fn room_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_name(inp);
            self
        }
        /// <p>The name for the room.</p>
        pub fn set_room_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_name(input);
            self
        }
        /// <p>The description for the room.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for the room.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The profile ARN for the room. This is required.</p>
        pub fn profile_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_arn(inp);
            self
        }
        /// <p>The profile ARN for the room. This is required.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_arn(input);
            self
        }
        /// <p>The calendar ARN for the room.</p>
        pub fn provider_calendar_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_calendar_id(inp);
            self
        }
        /// <p>The calendar ARN for the room.</p>
        pub fn set_provider_calendar_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_calendar_id(input);
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures idempotency.
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures idempotency.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the room.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags for the room.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSkillGroup`.
    ///
    /// <p>Creates a skill group with a specified name and description.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSkillGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_skill_group_input::Builder,
    }
    impl<C, M, R> CreateSkillGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSkillGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSkillGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSkillGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSkillGroupInputOperationOutputAlias,
                crate::output::CreateSkillGroupOutput,
                crate::error::CreateSkillGroupError,
                crate::input::CreateSkillGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the skill group.</p>
        pub fn skill_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_group_name(inp);
            self
        }
        /// <p>The name for the skill group.</p>
        pub fn set_skill_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_skill_group_name(input);
            self
        }
        /// <p>The description for the skill group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for the skill group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures idempotency.
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures idempotency.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the skill group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags for the skill group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a user.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN for the user.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The ARN for the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The first name for the user.</p>
        pub fn first_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.first_name(inp);
            self
        }
        /// <p>The first name for the user.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_first_name(input);
            self
        }
        /// <p>The last name for the user.</p>
        pub fn last_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.last_name(inp);
            self
        }
        /// <p>The last name for the user.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_last_name(input);
            self
        }
        /// <p>The email address for the user.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email address for the user.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures idempotency.
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, user-specified identifier for this request that ensures idempotency.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the user.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags for the user.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAddressBook`.
    ///
    /// <p>Deletes an address book by the address book ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAddressBook<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_address_book_input::Builder,
    }
    impl<C, M, R> DeleteAddressBook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAddressBook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAddressBookOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAddressBookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAddressBookInputOperationOutputAlias,
                crate::output::DeleteAddressBookOutput,
                crate::error::DeleteAddressBookError,
                crate::input::DeleteAddressBookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the address book to delete.</p>
        pub fn address_book_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address_book_arn(inp);
            self
        }
        /// <p>The ARN of the address book to delete.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_address_book_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBusinessReportSchedule`.
    ///
    /// <p>Deletes the recurring report delivery schedule with the specified schedule
    /// ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBusinessReportSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_business_report_schedule_input::Builder,
    }
    impl<C, M, R> DeleteBusinessReportSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBusinessReportSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBusinessReportScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBusinessReportScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBusinessReportScheduleInputOperationOutputAlias,
                crate::output::DeleteBusinessReportScheduleOutput,
                crate::error::DeleteBusinessReportScheduleError,
                crate::input::DeleteBusinessReportScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the business report schedule.</p>
        pub fn schedule_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_arn(inp);
            self
        }
        /// <p>The ARN of the business report schedule.</p>
        pub fn set_schedule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConferenceProvider`.
    ///
    /// <p>Deletes a conference provider.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConferenceProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_conference_provider_input::Builder,
    }
    impl<C, M, R> DeleteConferenceProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConferenceProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConferenceProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConferenceProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConferenceProviderInputOperationOutputAlias,
                crate::output::DeleteConferenceProviderOutput,
                crate::error::DeleteConferenceProviderError,
                crate::input::DeleteConferenceProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the conference provider.</p>
        pub fn conference_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conference_provider_arn(inp);
            self
        }
        /// <p>The ARN of the conference provider.</p>
        pub fn set_conference_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_conference_provider_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContact`.
    ///
    /// <p>Deletes a contact by the contact ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_contact_input::Builder,
    }
    impl<C, M, R> DeleteContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContactInputOperationOutputAlias,
                crate::output::DeleteContactOutput,
                crate::error::DeleteContactError,
                crate::input::DeleteContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the contact to delete.</p>
        pub fn contact_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_arn(inp);
            self
        }
        /// <p>The ARN of the contact to delete.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDevice`.
    ///
    /// <p>Removes a device from Alexa For Business.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_device_input::Builder,
    }
    impl<C, M, R> DeleteDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeviceInputOperationOutputAlias,
                crate::output::DeleteDeviceOutput,
                crate::error::DeleteDeviceError,
                crate::input::DeleteDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the device for which to request details.</p>
        pub fn device_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_arn(inp);
            self
        }
        /// <p>The ARN of the device for which to request details.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeviceUsageData`.
    ///
    /// <p>When this action is called for a specified shared device, it allows authorized users to
    /// delete the device's entire previous history of voice input data and associated response
    /// data. This action can be called once every 24 hours for a specific shared device.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDeviceUsageData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_device_usage_data_input::Builder,
    }
    impl<C, M, R> DeleteDeviceUsageData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDeviceUsageData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeviceUsageDataOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeviceUsageDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeviceUsageDataInputOperationOutputAlias,
                crate::output::DeleteDeviceUsageDataOutput,
                crate::error::DeleteDeviceUsageDataError,
                crate::input::DeleteDeviceUsageDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the device.</p>
        pub fn device_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_arn(inp);
            self
        }
        /// <p>The ARN of the device.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_arn(input);
            self
        }
        /// <p>The type of usage data to delete.</p>
        pub fn device_usage_type(mut self, inp: crate::model::DeviceUsageType) -> Self {
            self.inner = self.inner.device_usage_type(inp);
            self
        }
        /// <p>The type of usage data to delete.</p>
        pub fn set_device_usage_type(
            mut self,
            input: std::option::Option<crate::model::DeviceUsageType>,
        ) -> Self {
            self.inner = self.inner.set_device_usage_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGatewayGroup`.
    ///
    /// <p>Deletes a gateway group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGatewayGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_gateway_group_input::Builder,
    }
    impl<C, M, R> DeleteGatewayGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGatewayGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGatewayGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGatewayGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGatewayGroupInputOperationOutputAlias,
                crate::output::DeleteGatewayGroupOutput,
                crate::error::DeleteGatewayGroupError,
                crate::input::DeleteGatewayGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the gateway group to delete.</p>
        pub fn gateway_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_group_arn(inp);
            self
        }
        /// <p>The ARN of the gateway group to delete.</p>
        pub fn set_gateway_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNetworkProfile`.
    ///
    /// <p>Deletes a network profile by the network profile ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteNetworkProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_network_profile_input::Builder,
    }
    impl<C, M, R> DeleteNetworkProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNetworkProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNetworkProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNetworkProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNetworkProfileInputOperationOutputAlias,
                crate::output::DeleteNetworkProfileOutput,
                crate::error::DeleteNetworkProfileError,
                crate::input::DeleteNetworkProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn network_profile_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_profile_arn(inp);
            self
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_profile_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProfile`.
    ///
    /// <p>Deletes a room profile by the profile ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_profile_input::Builder,
    }
    impl<C, M, R> DeleteProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProfileInputOperationOutputAlias,
                crate::output::DeleteProfileOutput,
                crate::error::DeleteProfileError,
                crate::input::DeleteProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the room profile to delete. Required.</p>
        pub fn profile_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_arn(inp);
            self
        }
        /// <p>The ARN of the room profile to delete. Required.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoom`.
    ///
    /// <p>Deletes a room by the room ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_room_input::Builder,
    }
    impl<C, M, R> DeleteRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRoomInputOperationOutputAlias,
                crate::output::DeleteRoomOutput,
                crate::error::DeleteRoomError,
                crate::input::DeleteRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the room to delete. Required.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The ARN of the room to delete. Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoomSkillParameter`.
    ///
    /// <p>Deletes room skill parameter details by room, skill, and parameter key ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRoomSkillParameter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_room_skill_parameter_input::Builder,
    }
    impl<C, M, R> DeleteRoomSkillParameter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRoomSkillParameter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRoomSkillParameterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRoomSkillParameterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRoomSkillParameterInputOperationOutputAlias,
                crate::output::DeleteRoomSkillParameterOutput,
                crate::error::DeleteRoomSkillParameterError,
                crate::input::DeleteRoomSkillParameterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the room from which to remove the room skill parameter details.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The ARN of the room from which to remove the room skill parameter details.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
        /// <p>The ID of the skill from which to remove the room skill parameter details.</p>
        pub fn skill_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_id(inp);
            self
        }
        /// <p>The ID of the skill from which to remove the room skill parameter details.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_skill_id(input);
            self
        }
        /// <p>The room skill parameter key for which to remove details.</p>
        pub fn parameter_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_key(inp);
            self
        }
        /// <p>The room skill parameter key for which to remove details.</p>
        pub fn set_parameter_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSkillAuthorization`.
    ///
    /// <p>Unlinks a third-party account from a skill.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSkillAuthorization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_skill_authorization_input::Builder,
    }
    impl<C, M, R> DeleteSkillAuthorization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSkillAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSkillAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSkillAuthorizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSkillAuthorizationInputOperationOutputAlias,
                crate::output::DeleteSkillAuthorizationOutput,
                crate::error::DeleteSkillAuthorizationError,
                crate::input::DeleteSkillAuthorizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a skill.</p>
        pub fn skill_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_id(inp);
            self
        }
        /// <p>The unique identifier of a skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_skill_id(input);
            self
        }
        /// <p>The room that the skill is authorized for.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The room that the skill is authorized for.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSkillGroup`.
    ///
    /// <p>Deletes a skill group by skill group ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSkillGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_skill_group_input::Builder,
    }
    impl<C, M, R> DeleteSkillGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSkillGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSkillGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSkillGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSkillGroupInputOperationOutputAlias,
                crate::output::DeleteSkillGroupOutput,
                crate::error::DeleteSkillGroupError,
                crate::input::DeleteSkillGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the skill group to delete. Required.</p>
        pub fn skill_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_group_arn(inp);
            self
        }
        /// <p>The ARN of the skill group to delete. Required.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_skill_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes a specified user by user ARN and enrollment ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user to delete in the organization. Required.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The ARN of the user to delete in the organization. Required.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The ARN of the user's enrollment in the organization. Required.</p>
        pub fn enrollment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.enrollment_id(inp);
            self
        }
        /// <p>The ARN of the user's enrollment in the organization. Required.</p>
        pub fn set_enrollment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_enrollment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateContactFromAddressBook`.
    ///
    /// <p>Disassociates a contact from a given address book.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateContactFromAddressBook<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_contact_from_address_book_input::Builder,
    }
    impl<C, M, R> DisassociateContactFromAddressBook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateContactFromAddressBook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateContactFromAddressBookOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateContactFromAddressBookError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateContactFromAddressBookInputOperationOutputAlias,
                crate::output::DisassociateContactFromAddressBookOutput,
                crate::error::DisassociateContactFromAddressBookError,
                crate::input::DisassociateContactFromAddressBookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the contact to disassociate from an address book.</p>
        pub fn contact_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_arn(inp);
            self
        }
        /// <p>The ARN of the contact to disassociate from an address book.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_arn(input);
            self
        }
        /// <p>The ARN of the address from which to disassociate the contact.</p>
        pub fn address_book_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address_book_arn(inp);
            self
        }
        /// <p>The ARN of the address from which to disassociate the contact.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_address_book_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateDeviceFromRoom`.
    ///
    /// <p>Disassociates a device from its current room. The device continues to be connected to
    /// the Wi-Fi network and is still registered to the account. The device settings and skills
    /// are removed from the room.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateDeviceFromRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_device_from_room_input::Builder,
    }
    impl<C, M, R> DisassociateDeviceFromRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateDeviceFromRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateDeviceFromRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateDeviceFromRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateDeviceFromRoomInputOperationOutputAlias,
                crate::output::DisassociateDeviceFromRoomOutput,
                crate::error::DisassociateDeviceFromRoomError,
                crate::input::DisassociateDeviceFromRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the device to disassociate from a room. Required.</p>
        pub fn device_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_arn(inp);
            self
        }
        /// <p>The ARN of the device to disassociate from a room. Required.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateSkillFromSkillGroup`.
    ///
    /// <p>Disassociates a skill from a skill group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateSkillFromSkillGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_skill_from_skill_group_input::Builder,
    }
    impl<C, M, R> DisassociateSkillFromSkillGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateSkillFromSkillGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateSkillFromSkillGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateSkillFromSkillGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateSkillFromSkillGroupInputOperationOutputAlias,
                crate::output::DisassociateSkillFromSkillGroupOutput,
                crate::error::DisassociateSkillFromSkillGroupError,
                crate::input::DisassociateSkillFromSkillGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a skill. Required.</p>
        pub fn skill_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_group_arn(inp);
            self
        }
        /// <p>The unique identifier of a skill. Required.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_skill_group_arn(input);
            self
        }
        /// <p>The ARN of a skill group to associate to a skill.</p>
        pub fn skill_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_id(inp);
            self
        }
        /// <p>The ARN of a skill group to associate to a skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_skill_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateSkillFromUsers`.
    ///
    /// <p>Makes a private skill unavailable for enrolled users and prevents them from enabling it
    /// on their devices.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateSkillFromUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_skill_from_users_input::Builder,
    }
    impl<C, M, R> DisassociateSkillFromUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateSkillFromUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateSkillFromUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateSkillFromUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateSkillFromUsersInputOperationOutputAlias,
                crate::output::DisassociateSkillFromUsersOutput,
                crate::error::DisassociateSkillFromUsersError,
                crate::input::DisassociateSkillFromUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p> The private skill ID you want to make unavailable for enrolled users.</p>
        pub fn skill_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_id(inp);
            self
        }
        /// <p> The private skill ID you want to make unavailable for enrolled users.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_skill_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateSkillGroupFromRoom`.
    ///
    /// <p>Disassociates a skill group from a specified room. This disables all skills in the
    /// skill group on all devices in the room.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateSkillGroupFromRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_skill_group_from_room_input::Builder,
    }
    impl<C, M, R> DisassociateSkillGroupFromRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateSkillGroupFromRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateSkillGroupFromRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateSkillGroupFromRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateSkillGroupFromRoomInputOperationOutputAlias,
                crate::output::DisassociateSkillGroupFromRoomOutput,
                crate::error::DisassociateSkillGroupFromRoomError,
                crate::input::DisassociateSkillGroupFromRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the skill group to disassociate from a room. Required.</p>
        pub fn skill_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_group_arn(inp);
            self
        }
        /// <p>The ARN of the skill group to disassociate from a room. Required.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_skill_group_arn(input);
            self
        }
        /// <p>The ARN of the room from which the skill group is to be disassociated.
        /// Required.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The ARN of the room from which the skill group is to be disassociated.
        /// Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ForgetSmartHomeAppliances`.
    ///
    /// <p>Forgets smart home appliances associated to a room.</p>
    #[derive(std::fmt::Debug)]
    pub struct ForgetSmartHomeAppliances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::forget_smart_home_appliances_input::Builder,
    }
    impl<C, M, R> ForgetSmartHomeAppliances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ForgetSmartHomeAppliances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ForgetSmartHomeAppliancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ForgetSmartHomeAppliancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ForgetSmartHomeAppliancesInputOperationOutputAlias,
                crate::output::ForgetSmartHomeAppliancesOutput,
                crate::error::ForgetSmartHomeAppliancesError,
                crate::input::ForgetSmartHomeAppliancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The room that the appliances are associated with.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The room that the appliances are associated with.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAddressBook`.
    ///
    /// <p>Gets address the book details by the address book ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAddressBook<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_address_book_input::Builder,
    }
    impl<C, M, R> GetAddressBook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAddressBook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAddressBookOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAddressBookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAddressBookInputOperationOutputAlias,
                crate::output::GetAddressBookOutput,
                crate::error::GetAddressBookError,
                crate::input::GetAddressBookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the address book for which to request details.</p>
        pub fn address_book_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address_book_arn(inp);
            self
        }
        /// <p>The ARN of the address book for which to request details.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_address_book_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConferencePreference`.
    ///
    /// <p>Retrieves the existing conference preferences.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetConferencePreference<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_conference_preference_input::Builder,
    }
    impl<C, M, R> GetConferencePreference<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConferencePreference`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConferencePreferenceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConferencePreferenceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConferencePreferenceInputOperationOutputAlias,
                crate::output::GetConferencePreferenceOutput,
                crate::error::GetConferencePreferenceError,
                crate::input::GetConferencePreferenceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetConferenceProvider`.
    ///
    /// <p>Gets details about a specific conference provider.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetConferenceProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_conference_provider_input::Builder,
    }
    impl<C, M, R> GetConferenceProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConferenceProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConferenceProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConferenceProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConferenceProviderInputOperationOutputAlias,
                crate::output::GetConferenceProviderOutput,
                crate::error::GetConferenceProviderError,
                crate::input::GetConferenceProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the newly created conference provider.</p>
        pub fn conference_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conference_provider_arn(inp);
            self
        }
        /// <p>The ARN of the newly created conference provider.</p>
        pub fn set_conference_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_conference_provider_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContact`.
    ///
    /// <p>Gets the contact details by the contact ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_input::Builder,
    }
    impl<C, M, R> GetContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactInputOperationOutputAlias,
                crate::output::GetContactOutput,
                crate::error::GetContactError,
                crate::input::GetContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the contact for which to request details.</p>
        pub fn contact_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_arn(inp);
            self
        }
        /// <p>The ARN of the contact for which to request details.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevice`.
    ///
    /// <p>Gets the details of a device by device ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_input::Builder,
    }
    impl<C, M, R> GetDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeviceInputOperationOutputAlias,
                crate::output::GetDeviceOutput,
                crate::error::GetDeviceError,
                crate::input::GetDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the device for which to request details. Required.</p>
        pub fn device_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_arn(inp);
            self
        }
        /// <p>The ARN of the device for which to request details. Required.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGateway`.
    ///
    /// <p>Retrieves the details of a gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_gateway_input::Builder,
    }
    impl<C, M, R> GetGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGatewayInputOperationOutputAlias,
                crate::output::GetGatewayOutput,
                crate::error::GetGatewayError,
                crate::input::GetGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the gateway to get.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The ARN of the gateway to get.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGatewayGroup`.
    ///
    /// <p>Retrieves the details of a gateway group.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGatewayGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_gateway_group_input::Builder,
    }
    impl<C, M, R> GetGatewayGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGatewayGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGatewayGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGatewayGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGatewayGroupInputOperationOutputAlias,
                crate::output::GetGatewayGroupOutput,
                crate::error::GetGatewayGroupError,
                crate::input::GetGatewayGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the gateway group to get.</p>
        pub fn gateway_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_group_arn(inp);
            self
        }
        /// <p>The ARN of the gateway group to get.</p>
        pub fn set_gateway_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInvitationConfiguration`.
    ///
    /// <p>Retrieves the configured values for the user enrollment invitation email
    /// template.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInvitationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_invitation_configuration_input::Builder,
    }
    impl<C, M, R> GetInvitationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInvitationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInvitationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInvitationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInvitationConfigurationInputOperationOutputAlias,
                crate::output::GetInvitationConfigurationOutput,
                crate::error::GetInvitationConfigurationError,
                crate::input::GetInvitationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetNetworkProfile`.
    ///
    /// <p>Gets the network profile details by the network profile ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetNetworkProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_network_profile_input::Builder,
    }
    impl<C, M, R> GetNetworkProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNetworkProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNetworkProfileInputOperationOutputAlias,
                crate::output::GetNetworkProfileOutput,
                crate::error::GetNetworkProfileError,
                crate::input::GetNetworkProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn network_profile_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_profile_arn(inp);
            self
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_profile_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProfile`.
    ///
    /// <p>Gets the details of a room profile by profile ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_profile_input::Builder,
    }
    impl<C, M, R> GetProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProfileInputOperationOutputAlias,
                crate::output::GetProfileOutput,
                crate::error::GetProfileError,
                crate::input::GetProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the room profile for which to request details. Required.</p>
        pub fn profile_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_arn(inp);
            self
        }
        /// <p>The ARN of the room profile for which to request details. Required.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRoom`.
    ///
    /// <p>Gets room details by room ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_room_input::Builder,
    }
    impl<C, M, R> GetRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRoomInputOperationOutputAlias,
                crate::output::GetRoomOutput,
                crate::error::GetRoomError,
                crate::input::GetRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the room for which to request details. Required.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The ARN of the room for which to request details. Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRoomSkillParameter`.
    ///
    /// <p>Gets room skill parameter details by room, skill, and parameter key ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRoomSkillParameter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_room_skill_parameter_input::Builder,
    }
    impl<C, M, R> GetRoomSkillParameter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRoomSkillParameter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRoomSkillParameterOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRoomSkillParameterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRoomSkillParameterInputOperationOutputAlias,
                crate::output::GetRoomSkillParameterOutput,
                crate::error::GetRoomSkillParameterError,
                crate::input::GetRoomSkillParameterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the room from which to get the room skill parameter details. </p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The ARN of the room from which to get the room skill parameter details. </p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
        /// <p>The ARN of the skill from which to get the room skill parameter details.
        /// Required.</p>
        pub fn skill_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_id(inp);
            self
        }
        /// <p>The ARN of the skill from which to get the room skill parameter details.
        /// Required.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_skill_id(input);
            self
        }
        /// <p>The room skill parameter key for which to get details. Required.</p>
        pub fn parameter_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_key(inp);
            self
        }
        /// <p>The room skill parameter key for which to get details. Required.</p>
        pub fn set_parameter_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSkillGroup`.
    ///
    /// <p>Gets skill group details by skill group ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSkillGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_skill_group_input::Builder,
    }
    impl<C, M, R> GetSkillGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSkillGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSkillGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSkillGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSkillGroupInputOperationOutputAlias,
                crate::output::GetSkillGroupOutput,
                crate::error::GetSkillGroupError,
                crate::input::GetSkillGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the skill group for which to get details. Required.</p>
        pub fn skill_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_group_arn(inp);
            self
        }
        /// <p>The ARN of the skill group for which to get details. Required.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_skill_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBusinessReportSchedules`.
    ///
    /// <p>Lists the details of the schedules that a user configured. A download URL of the report associated with each schedule is returned every time this action is called. A new download URL is returned each time, and is valid for 24 hours.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBusinessReportSchedules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_business_report_schedules_input::Builder,
    }
    impl<C, M, R> ListBusinessReportSchedules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBusinessReportSchedules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBusinessReportSchedulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBusinessReportSchedulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBusinessReportSchedulesInputOperationOutputAlias,
                crate::output::ListBusinessReportSchedulesOutput,
                crate::error::ListBusinessReportSchedulesError,
                crate::input::ListBusinessReportSchedulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The token used to list the remaining schedules from the previous API call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token used to list the remaining schedules from the previous API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of schedules listed in the call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of schedules listed in the call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConferenceProviders`.
    ///
    /// <p>Lists conference providers under a specific AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListConferenceProviders<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_conference_providers_input::Builder,
    }
    impl<C, M, R> ListConferenceProviders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConferenceProviders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConferenceProvidersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConferenceProvidersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConferenceProvidersInputOperationOutputAlias,
                crate::output::ListConferenceProvidersOutput,
                crate::error::ListConferenceProvidersError,
                crate::input::ListConferenceProvidersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The tokens used for pagination.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The tokens used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of conference providers to be returned, per paginated
        /// calls.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of conference providers to be returned, per paginated
        /// calls.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeviceEvents`.
    ///
    /// <p>Lists the device event history, including device connection status, for up to 30
    /// days.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDeviceEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_device_events_input::Builder,
    }
    impl<C, M, R> ListDeviceEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeviceEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeviceEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeviceEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeviceEventsInputOperationOutputAlias,
                crate::output::ListDeviceEventsOutput,
                crate::error::ListDeviceEventsError,
                crate::input::ListDeviceEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of a device.</p>
        pub fn device_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_arn(inp);
            self
        }
        /// <p>The ARN of a device.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_arn(input);
            self
        }
        /// <p>The event type to filter device events. If EventType isn't specified, this returns a
        /// list of all device events in reverse chronological order. If EventType is specified, this
        /// returns a list of device events for that EventType in reverse chronological order.
        /// </p>
        pub fn event_type(mut self, inp: crate::model::DeviceEventType) -> Self {
            self.inner = self.inner.event_type(inp);
            self
        }
        /// <p>The event type to filter device events. If EventType isn't specified, this returns a
        /// list of all device events in reverse chronological order. If EventType is specified, this
        /// returns a list of device events for that EventType in reverse chronological order.
        /// </p>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::DeviceEventType>,
        ) -> Self {
            self.inner = self.inner.set_event_type(input);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response only includes
        /// results beyond the token, up to the value specified by MaxResults. When the end of results
        /// is reached, the response has a value of null.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response only includes
        /// results beyond the token, up to the value specified by MaxResults. When the end of results
        /// is reached, the response has a value of null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. The default value is 50. If
        /// more results exist than the specified MaxResults value, a token is included in the response
        /// so that the remaining results can be retrieved. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in the response. The default value is 50. If
        /// more results exist than the specified MaxResults value, a token is included in the response
        /// so that the remaining results can be retrieved. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGatewayGroups`.
    ///
    /// <p>Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of
    /// a specific gateway group.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGatewayGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_gateway_groups_input::Builder,
    }
    impl<C, M, R> ListGatewayGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGatewayGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGatewayGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGatewayGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGatewayGroupsInputOperationOutputAlias,
                crate::output::ListGatewayGroupsOutput,
                crate::error::ListGatewayGroupsError,
                crate::input::ListGatewayGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The token used to paginate though multiple pages of gateway group summaries.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token used to paginate though multiple pages of gateway group summaries.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of gateway group summaries to return. The default is 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of gateway group summaries to return. The default is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGateways`.
    ///
    /// <p>Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific
    /// gateway. An optional gateway group ARN can be provided to only retrieve gateway summaries
    /// of gateways that are associated with that gateway group ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGateways<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_gateways_input::Builder,
    }
    impl<C, M, R> ListGateways<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGatewaysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGatewaysInputOperationOutputAlias,
                crate::output::ListGatewaysOutput,
                crate::error::ListGatewaysError,
                crate::input::ListGatewaysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The gateway group ARN for which to list gateways.</p>
        pub fn gateway_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_group_arn(inp);
            self
        }
        /// <p>The gateway group ARN for which to list gateways.</p>
        pub fn set_gateway_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_group_arn(input);
            self
        }
        /// <p>The token used to paginate though multiple pages of gateway summaries.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token used to paginate though multiple pages of gateway summaries.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of gateway summaries to return. The default is 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of gateway summaries to return. The default is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSkills`.
    ///
    /// <p>Lists all enabled skills in a specific skill group.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSkills<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_skills_input::Builder,
    }
    impl<C, M, R> ListSkills<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSkills`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSkillsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSkillsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSkillsInputOperationOutputAlias,
                crate::output::ListSkillsOutput,
                crate::error::ListSkillsError,
                crate::input::ListSkillsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the skill group for which to list enabled skills.</p>
        pub fn skill_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_group_arn(inp);
            self
        }
        /// <p>The ARN of the skill group for which to list enabled skills.</p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_skill_group_arn(input);
            self
        }
        /// <p>Whether the skill is enabled under the user's account.</p>
        pub fn enablement_type(mut self, inp: crate::model::EnablementTypeFilter) -> Self {
            self.inner = self.inner.enablement_type(inp);
            self
        }
        /// <p>Whether the skill is enabled under the user's account.</p>
        pub fn set_enablement_type(
            mut self,
            input: std::option::Option<crate::model::EnablementTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_enablement_type(input);
            self
        }
        /// <p>Whether the skill is publicly available or is a private skill.</p>
        pub fn skill_type(mut self, inp: crate::model::SkillTypeFilter) -> Self {
            self.inner = self.inner.skill_type(inp);
            self
        }
        /// <p>Whether the skill is publicly available or is a private skill.</p>
        pub fn set_skill_type(
            mut self,
            input: std::option::Option<crate::model::SkillTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_skill_type(input);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSkillsStoreCategories`.
    ///
    /// <p>Lists all categories in the Alexa skill store.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSkillsStoreCategories<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_skills_store_categories_input::Builder,
    }
    impl<C, M, R> ListSkillsStoreCategories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSkillsStoreCategories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSkillsStoreCategoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSkillsStoreCategoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSkillsStoreCategoriesInputOperationOutputAlias,
                crate::output::ListSkillsStoreCategoriesOutput,
                crate::error::ListSkillsStoreCategoriesError,
                crate::input::ListSkillsStoreCategoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The tokens used for pagination.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The tokens used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of categories returned, per paginated calls.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of categories returned, per paginated calls.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSkillsStoreSkillsByCategory`.
    ///
    /// <p>Lists all skills in the Alexa skill store by category.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSkillsStoreSkillsByCategory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_skills_store_skills_by_category_input::Builder,
    }
    impl<C, M, R> ListSkillsStoreSkillsByCategory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSkillsStoreSkillsByCategory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSkillsStoreSkillsByCategoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSkillsStoreSkillsByCategoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSkillsStoreSkillsByCategoryInputOperationOutputAlias,
                crate::output::ListSkillsStoreSkillsByCategoryOutput,
                crate::error::ListSkillsStoreSkillsByCategoryError,
                crate::input::ListSkillsStoreSkillsByCategoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The category ID for which the skills are being retrieved from the skill
        /// store.</p>
        pub fn category_id(mut self, inp: i64) -> Self {
            self.inner = self.inner.category_id(inp);
            self
        }
        /// <p>The category ID for which the skills are being retrieved from the skill
        /// store.</p>
        pub fn set_category_id(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_category_id(input);
            self
        }
        /// <p>The tokens used for pagination.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The tokens used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of skills returned per paginated calls.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of skills returned per paginated calls.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSmartHomeAppliances`.
    ///
    /// <p>Lists all of the smart home appliances associated with a room.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSmartHomeAppliances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_smart_home_appliances_input::Builder,
    }
    impl<C, M, R> ListSmartHomeAppliances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSmartHomeAppliances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSmartHomeAppliancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSmartHomeAppliancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSmartHomeAppliancesInputOperationOutputAlias,
                crate::output::ListSmartHomeAppliancesOutput,
                crate::error::ListSmartHomeAppliancesError,
                crate::input::ListSmartHomeAppliancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The room that the appliances are associated with.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The room that the appliances are associated with.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
        /// <p>The maximum number of appliances to be returned, per paginated calls.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of appliances to be returned, per paginated calls.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The tokens used for pagination.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The tokens used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Lists all tags for the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl<C, M, R> ListTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsInputOperationOutputAlias,
                crate::output::ListTagsOutput,
                crate::error::ListTagsError,
                crate::input::ListTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the specified resource for which to list tags.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the specified resource for which to list tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConferencePreference`.
    ///
    /// <p>Sets the conference preferences on a specific conference provider at the account
    /// level.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutConferencePreference<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_conference_preference_input::Builder,
    }
    impl<C, M, R> PutConferencePreference<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutConferencePreference`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConferencePreferenceOutput,
            aws_smithy_http::result::SdkError<crate::error::PutConferencePreferenceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutConferencePreferenceInputOperationOutputAlias,
                crate::output::PutConferencePreferenceOutput,
                crate::error::PutConferencePreferenceError,
                crate::input::PutConferencePreferenceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The conference preference of a specific conference provider.</p>
        pub fn conference_preference(mut self, inp: crate::model::ConferencePreference) -> Self {
            self.inner = self.inner.conference_preference(inp);
            self
        }
        /// <p>The conference preference of a specific conference provider.</p>
        pub fn set_conference_preference(
            mut self,
            input: std::option::Option<crate::model::ConferencePreference>,
        ) -> Self {
            self.inner = self.inner.set_conference_preference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutInvitationConfiguration`.
    ///
    /// <p>Configures the email template for the user enrollment invitation with the specified
    /// attributes.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutInvitationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_invitation_configuration_input::Builder,
    }
    impl<C, M, R> PutInvitationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutInvitationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutInvitationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutInvitationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutInvitationConfigurationInputOperationOutputAlias,
                crate::output::PutInvitationConfigurationOutput,
                crate::error::PutInvitationConfigurationError,
                crate::input::PutInvitationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the organization sending the enrollment invite to a user.</p>
        pub fn organization_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_name(inp);
            self
        }
        /// <p>The name of the organization sending the enrollment invite to a user.</p>
        pub fn set_organization_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_name(input);
            self
        }
        /// <p>The email ID of the organization or individual contact that the enrolled user can use.
        /// </p>
        pub fn contact_email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_email(inp);
            self
        }
        /// <p>The email ID of the organization or individual contact that the enrolled user can use.
        /// </p>
        pub fn set_contact_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_email(input);
            self
        }
        /// Appends an item to `PrivateSkillIds`.
        ///
        /// To override the contents of this collection use [`set_private_skill_ids`](Self::set_private_skill_ids).
        ///
        /// <p>The list of private skill IDs that you want to recommend to the user to enable in the
        /// invitation.</p>
        pub fn private_skill_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.private_skill_ids(inp);
            self
        }
        /// <p>The list of private skill IDs that you want to recommend to the user to enable in the
        /// invitation.</p>
        pub fn set_private_skill_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_private_skill_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRoomSkillParameter`.
    ///
    /// <p>Updates room skill parameter details by room, skill, and parameter key ID. Not all
    /// skills have a room skill parameter.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutRoomSkillParameter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_room_skill_parameter_input::Builder,
    }
    impl<C, M, R> PutRoomSkillParameter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRoomSkillParameter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRoomSkillParameterOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRoomSkillParameterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRoomSkillParameterInputOperationOutputAlias,
                crate::output::PutRoomSkillParameterOutput,
                crate::error::PutRoomSkillParameterError,
                crate::input::PutRoomSkillParameterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the room associated with the room skill parameter. Required.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The ARN of the room associated with the room skill parameter. Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
        /// <p>The ARN of the skill associated with the room skill parameter. Required.</p>
        pub fn skill_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_id(inp);
            self
        }
        /// <p>The ARN of the skill associated with the room skill parameter. Required.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_skill_id(input);
            self
        }
        /// <p>The updated room skill parameter. Required.</p>
        pub fn room_skill_parameter(mut self, inp: crate::model::RoomSkillParameter) -> Self {
            self.inner = self.inner.room_skill_parameter(inp);
            self
        }
        /// <p>The updated room skill parameter. Required.</p>
        pub fn set_room_skill_parameter(
            mut self,
            input: std::option::Option<crate::model::RoomSkillParameter>,
        ) -> Self {
            self.inner = self.inner.set_room_skill_parameter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSkillAuthorization`.
    ///
    /// <p>Links a user's account to a third-party skill provider. If this API operation is
    /// called by an assumed IAM role, the skill being linked must be a private skill. Also, the
    /// skill must be owned by the AWS account that assumed the IAM role.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutSkillAuthorization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_skill_authorization_input::Builder,
    }
    impl<C, M, R> PutSkillAuthorization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutSkillAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSkillAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSkillAuthorizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutSkillAuthorizationInputOperationOutputAlias,
                crate::output::PutSkillAuthorizationOutput,
                crate::error::PutSkillAuthorizationError,
                crate::input::PutSkillAuthorizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `AuthorizationResult`.
        ///
        /// To override the contents of this collection use [`set_authorization_result`](Self::set_authorization_result).
        ///
        /// <p>The authorization result specific to OAUTH code grant output. "Code” must be
        /// populated in the AuthorizationResult map to establish the authorization.</p>
        pub fn authorization_result(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authorization_result(k, v);
            self
        }
        /// <p>The authorization result specific to OAUTH code grant output. "Code” must be
        /// populated in the AuthorizationResult map to establish the authorization.</p>
        pub fn set_authorization_result(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_authorization_result(input);
            self
        }
        /// <p>The unique identifier of a skill.</p>
        pub fn skill_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_id(inp);
            self
        }
        /// <p>The unique identifier of a skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_skill_id(input);
            self
        }
        /// <p>The room that the skill is authorized for.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The room that the skill is authorized for.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterAVSDevice`.
    ///
    /// <p>Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM)
    /// using Alexa Voice Service (AVS).</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterAVSDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_avs_device_input::Builder,
    }
    impl<C, M, R> RegisterAVSDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterAVSDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterAvsDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterAVSDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterAvsDeviceInputOperationOutputAlias,
                crate::output::RegisterAvsDeviceOutput,
                crate::error::RegisterAVSDeviceError,
                crate::input::RegisterAvsDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The client ID of the OEM used for code-based linking authorization on an AVS
        /// device.</p>
        pub fn client_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(inp);
            self
        }
        /// <p>The client ID of the OEM used for code-based linking authorization on an AVS
        /// device.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
        /// <p>The code that is obtained after your AVS device has made a POST request to LWA as a
        /// part of the Device Authorization Request component of the OAuth code-based linking
        /// specification.</p>
        pub fn user_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_code(inp);
            self
        }
        /// <p>The code that is obtained after your AVS device has made a POST request to LWA as a
        /// part of the Device Authorization Request component of the OAuth code-based linking
        /// specification.</p>
        pub fn set_user_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_code(input);
            self
        }
        /// <p>The product ID used to identify your AVS device during authorization.</p>
        pub fn product_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_id(inp);
            self
        }
        /// <p>The product ID used to identify your AVS device during authorization.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_id(input);
            self
        }
        /// <p>The key generated by the OEM that uniquely identifies a specified instance of your
        /// AVS device.</p>
        pub fn device_serial_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_serial_number(inp);
            self
        }
        /// <p>The key generated by the OEM that uniquely identifies a specified instance of your
        /// AVS device.</p>
        pub fn set_device_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_serial_number(input);
            self
        }
        /// <p>The device type ID for your AVS device generated by Amazon when the OEM creates a new
        /// product on Amazon's Developer Console.</p>
        pub fn amazon_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amazon_id(inp);
            self
        }
        /// <p>The device type ID for your AVS device generated by Amazon when the OEM creates a new
        /// product on Amazon's Developer Console.</p>
        pub fn set_amazon_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_amazon_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the room with which to associate your AVS device.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the room with which to associate your AVS device.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectSkill`.
    ///
    /// <p>Disassociates a skill from the organization under a user's AWS account. If the skill
    /// is a private skill, it moves to an AcceptStatus of PENDING. Any private or public skill
    /// that is rejected can be added later by calling the ApproveSkill API. </p>
    #[derive(std::fmt::Debug)]
    pub struct RejectSkill<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_skill_input::Builder,
    }
    impl<C, M, R> RejectSkill<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectSkill`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectSkillOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectSkillError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectSkillInputOperationOutputAlias,
                crate::output::RejectSkillOutput,
                crate::error::RejectSkillError,
                crate::input::RejectSkillInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the skill.</p>
        pub fn skill_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_id(inp);
            self
        }
        /// <p>The unique identifier of the skill.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_skill_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResolveRoom`.
    ///
    /// <p>Determines the details for the room from which a skill request was invoked. This
    /// operation is used by skill developers.</p>
    /// <p>To query ResolveRoom from an Alexa skill, the skill ID needs to be authorized. When
    /// the skill is using an AWS Lambda function, the skill is automatically authorized when you
    /// publish your skill as a private skill to your AWS account. Skills that are hosted using a
    /// custom web service must be manually authorized. To get your skill authorized, contact AWS
    /// Support with your AWS account ID that queries the ResolveRoom API and skill ID. </p>
    #[derive(std::fmt::Debug)]
    pub struct ResolveRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resolve_room_input::Builder,
    }
    impl<C, M, R> ResolveRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResolveRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResolveRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::ResolveRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResolveRoomInputOperationOutputAlias,
                crate::output::ResolveRoomOutput,
                crate::error::ResolveRoomError,
                crate::input::ResolveRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user. Required.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The ARN of the user. Required.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The ARN of the skill that was requested. Required.</p>
        pub fn skill_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_id(inp);
            self
        }
        /// <p>The ARN of the skill that was requested. Required.</p>
        pub fn set_skill_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_skill_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeInvitation`.
    ///
    /// <p>Revokes an invitation and invalidates the enrollment URL.</p>
    #[derive(std::fmt::Debug)]
    pub struct RevokeInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::revoke_invitation_input::Builder,
    }
    impl<C, M, R> RevokeInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RevokeInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RevokeInvitationInputOperationOutputAlias,
                crate::output::RevokeInvitationOutput,
                crate::error::RevokeInvitationError,
                crate::input::RevokeInvitationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user for whom to revoke an enrollment invitation. Required.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The ARN of the user for whom to revoke an enrollment invitation. Required.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The ARN of the enrollment invitation to revoke. Required.</p>
        pub fn enrollment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.enrollment_id(inp);
            self
        }
        /// <p>The ARN of the enrollment invitation to revoke. Required.</p>
        pub fn set_enrollment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_enrollment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchAddressBooks`.
    ///
    /// <p>Searches address books and lists the ones that meet a set of filter and sort
    /// criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchAddressBooks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_address_books_input::Builder,
    }
    impl<C, M, R> SearchAddressBooks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchAddressBooks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchAddressBooksOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchAddressBooksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchAddressBooksInputOperationOutputAlias,
                crate::output::SearchAddressBooksOutput,
                crate::error::SearchAddressBooksError,
                crate::input::SearchAddressBooksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of address books. The supported filter key
        /// is AddressBookName.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to use to list a specified set of address books. The supported filter key
        /// is AddressBookName.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `SortCriteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the specified set of address books. The supported
        /// sort key is AddressBookName.</p>
        pub fn sort_criteria(mut self, inp: impl Into<crate::model::Sort>) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The sort order to use in listing the specified set of address books. The supported
        /// sort key is AddressBookName.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response only includes
        /// results beyond the token, up to the value specified by MaxResults.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response only includes
        /// results beyond the token, up to the value specified by MaxResults.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified MaxResults value, a token is included in the response so that the remaining
        /// results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified MaxResults value, a token is included in the response so that the remaining
        /// results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchContacts`.
    ///
    /// <p>Searches contacts and lists the ones that meet a set of filter and sort
    /// criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchContacts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_contacts_input::Builder,
    }
    impl<C, M, R> SearchContacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchContacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchContactsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchContactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchContactsInputOperationOutputAlias,
                crate::output::SearchContactsOutput,
                crate::error::SearchContactsError,
                crate::input::SearchContactsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of address books. The supported filter
        /// keys are DisplayName, FirstName, LastName, and AddressBookArns.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to use to list a specified set of address books. The supported filter
        /// keys are DisplayName, FirstName, LastName, and AddressBookArns.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `SortCriteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the specified set of contacts. The supported sort
        /// keys are DisplayName, FirstName, and LastName.</p>
        pub fn sort_criteria(mut self, inp: impl Into<crate::model::Sort>) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The sort order to use in listing the specified set of contacts. The supported sort
        /// keys are DisplayName, FirstName, and LastName.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response only includes
        /// results beyond the token, up to the value specified by MaxResults.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response only includes
        /// results beyond the token, up to the value specified by MaxResults.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified MaxResults value, a token is included in the response so that the remaining
        /// results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified MaxResults value, a token is included in the response so that the remaining
        /// results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchDevices`.
    ///
    /// <p>Searches devices and lists the ones that meet a set of filter criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_devices_input::Builder,
    }
    impl<C, M, R> SearchDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchDevicesInputOperationOutputAlias,
                crate::output::SearchDevicesOutput,
                crate::error::SearchDevicesError,
                crate::input::SearchDevicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of devices. Supported filter keys are
        /// DeviceName, DeviceStatus, DeviceStatusDetailCode, RoomName, DeviceType, DeviceSerialNumber,
        /// UnassociatedOnly, ConnectionStatus (ONLINE and OFFLINE), NetworkProfileName,
        /// NetworkProfileArn, Feature, and FailureCode.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to use to list a specified set of devices. Supported filter keys are
        /// DeviceName, DeviceStatus, DeviceStatusDetailCode, RoomName, DeviceType, DeviceSerialNumber,
        /// UnassociatedOnly, ConnectionStatus (ONLINE and OFFLINE), NetworkProfileName,
        /// NetworkProfileArn, Feature, and FailureCode.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `SortCriteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the specified set of devices. Supported sort keys
        /// are DeviceName, DeviceStatus, RoomName, DeviceType, DeviceSerialNumber, ConnectionStatus,
        /// NetworkProfileName, NetworkProfileArn, Feature, and FailureCode.</p>
        pub fn sort_criteria(mut self, inp: impl Into<crate::model::Sort>) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The sort order to use in listing the specified set of devices. Supported sort keys
        /// are DeviceName, DeviceStatus, RoomName, DeviceType, DeviceSerialNumber, ConnectionStatus,
        /// NetworkProfileName, NetworkProfileArn, Feature, and FailureCode.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchNetworkProfiles`.
    ///
    /// <p>Searches network profiles and lists the ones that meet a set of filter and sort
    /// criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchNetworkProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_network_profiles_input::Builder,
    }
    impl<C, M, R> SearchNetworkProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchNetworkProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchNetworkProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchNetworkProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchNetworkProfilesInputOperationOutputAlias,
                crate::output::SearchNetworkProfilesOutput,
                crate::error::SearchNetworkProfilesError,
                crate::input::SearchNetworkProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by MaxResults. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by MaxResults. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the
        /// specified MaxResults value, a token is included in the response so that the remaining
        /// results can be retrieved. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the
        /// specified MaxResults value, a token is included in the response so that the remaining
        /// results can be retrieved. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of network profiles. Valid filters are
        /// NetworkProfileName, Ssid, and SecurityType.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to use to list a specified set of network profiles. Valid filters are
        /// NetworkProfileName, Ssid, and SecurityType.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `SortCriteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use to list the specified set of network profiles. Valid sort criteria
        /// includes NetworkProfileName, Ssid, and SecurityType.</p>
        pub fn sort_criteria(mut self, inp: impl Into<crate::model::Sort>) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The sort order to use to list the specified set of network profiles. Valid sort criteria
        /// includes NetworkProfileName, Ssid, and SecurityType.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchProfiles`.
    ///
    /// <p>Searches room profiles and lists the ones that meet a set of filter
    /// criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_profiles_input::Builder,
    }
    impl<C, M, R> SearchProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchProfilesInputOperationOutputAlias,
                crate::output::SearchProfilesOutput,
                crate::error::SearchProfilesError,
                crate::input::SearchProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of room profiles. Supported filter keys
        /// are ProfileName and Address. Required. </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to use to list a specified set of room profiles. Supported filter keys
        /// are ProfileName and Address. Required. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `SortCriteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the specified set of room profiles. Supported sort
        /// keys are ProfileName and Address.</p>
        pub fn sort_criteria(mut self, inp: impl Into<crate::model::Sort>) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The sort order to use in listing the specified set of room profiles. Supported sort
        /// keys are ProfileName and Address.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchRooms`.
    ///
    /// <p>Searches rooms and lists the ones that meet a set of filter and sort
    /// criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchRooms<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_rooms_input::Builder,
    }
    impl<C, M, R> SearchRooms<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchRooms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchRoomsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchRoomsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchRoomsInputOperationOutputAlias,
                crate::output::SearchRoomsOutput,
                crate::error::SearchRoomsError,
                crate::input::SearchRoomsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of rooms. The supported filter keys are
        /// RoomName and ProfileName.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to use to list a specified set of rooms. The supported filter keys are
        /// RoomName and ProfileName.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `SortCriteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the specified set of rooms. The supported sort keys
        /// are RoomName and ProfileName.</p>
        pub fn sort_criteria(mut self, inp: impl Into<crate::model::Sort>) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The sort order to use in listing the specified set of rooms. The supported sort keys
        /// are RoomName and ProfileName.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchSkillGroups`.
    ///
    /// <p>Searches skill groups and lists the ones that meet a set of filter and sort
    /// criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchSkillGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_skill_groups_input::Builder,
    }
    impl<C, M, R> SearchSkillGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchSkillGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchSkillGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchSkillGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchSkillGroupsInputOperationOutputAlias,
                crate::output::SearchSkillGroupsOutput,
                crate::error::SearchSkillGroupsError,
                crate::input::SearchSkillGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.
        /// Required.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.
        /// Required.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use to list a specified set of skill groups. The supported filter key
        /// is SkillGroupName. </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to use to list a specified set of skill groups. The supported filter key
        /// is SkillGroupName. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `SortCriteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the specified set of skill groups. The supported
        /// sort key is SkillGroupName. </p>
        pub fn sort_criteria(mut self, inp: impl Into<crate::model::Sort>) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The sort order to use in listing the specified set of skill groups. The supported
        /// sort key is SkillGroupName. </p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchUsers`.
    ///
    /// <p>Searches users and lists the ones that meet a set of filter and sort
    /// criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_users_input::Builder,
    }
    impl<C, M, R> SearchUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchUsersInputOperationOutputAlias,
                crate::output::SearchUsersOutput,
                crate::error::SearchUsersError,
                crate::input::SearchUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.
        /// Required.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional token returned from a prior request. Use this token for pagination of
        /// results from this action. If this parameter is specified, the response includes only
        /// results beyond the token, up to the value specified by <code>MaxResults</code>.
        /// Required.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved. Required.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than
        /// the specified <code>MaxResults</code> value, a token is included in the response so that
        /// the remaining results can be retrieved. Required.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to use for listing a specific set of users. Required. Supported filter
        /// keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to use for listing a specific set of users. Required. Supported filter
        /// keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `SortCriteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>The sort order to use in listing the filtered set of users. Required. Supported sort
        /// keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.</p>
        pub fn sort_criteria(mut self, inp: impl Into<crate::model::Sort>) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The sort order to use in listing the filtered set of users. Required. Supported sort
        /// keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sort>>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendAnnouncement`.
    ///
    /// <p>Triggers an asynchronous flow to send text, SSML, or audio announcements to rooms that
    /// are identified by a search or filter. </p>
    #[derive(std::fmt::Debug)]
    pub struct SendAnnouncement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_announcement_input::Builder,
    }
    impl<C, M, R> SendAnnouncement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendAnnouncement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendAnnouncementOutput,
            aws_smithy_http::result::SdkError<crate::error::SendAnnouncementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendAnnouncementInputOperationOutputAlias,
                crate::output::SendAnnouncementOutput,
                crate::error::SendAnnouncementError,
                crate::input::SendAnnouncementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `RoomFilters`.
        ///
        /// To override the contents of this collection use [`set_room_filters`](Self::set_room_filters).
        ///
        /// <p>The filters to use to send an announcement to a specified list of rooms. The supported filter keys are RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.</p>
        pub fn room_filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.room_filters(inp);
            self
        }
        /// <p>The filters to use to send an announcement to a specified list of rooms. The supported filter keys are RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.</p>
        pub fn set_room_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_room_filters(input);
            self
        }
        /// <p>The announcement content. This can contain only one of the three possible announcement types (text, SSML or audio).</p>
        pub fn content(mut self, inp: crate::model::Content) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The announcement content. This can contain only one of the three possible announcement types (text, SSML or audio).</p>
        pub fn set_content(mut self, input: std::option::Option<crate::model::Content>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>The time to live for an announcement. Default is 300. If delivery doesn't occur within this time, the
        /// announcement is not delivered.</p>
        pub fn time_to_live_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.time_to_live_in_seconds(inp);
            self
        }
        /// <p>The time to live for an announcement. Default is 300. If delivery doesn't occur within this time, the
        /// announcement is not delivered.</p>
        pub fn set_time_to_live_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_time_to_live_in_seconds(input);
            self
        }
        /// <p>The unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>The unique, user-specified identifier for the request that ensures idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendInvitation`.
    ///
    /// <p>Sends an enrollment invitation email with a URL to a user. The URL is valid for 30
    /// days or until you call this operation again, whichever comes first. </p>
    #[derive(std::fmt::Debug)]
    pub struct SendInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_invitation_input::Builder,
    }
    impl<C, M, R> SendInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::SendInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendInvitationInputOperationOutputAlias,
                crate::output::SendInvitationOutput,
                crate::error::SendInvitationError,
                crate::input::SendInvitationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the user to whom to send an invitation. Required.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The ARN of the user to whom to send an invitation. Required.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDeviceSync`.
    ///
    /// <p>Resets a device and its account to the known default settings. This clears all
    /// information and settings set by previous users in the following ways:</p>
    /// <ul>
    /// <li>
    /// <p>Bluetooth - This unpairs all bluetooth devices paired with your echo
    /// device.</p>
    /// </li>
    /// <li>
    /// <p>Volume - This resets the echo device's volume to the default value.</p>
    /// </li>
    /// <li>
    /// <p>Notifications - This clears all notifications from your echo device.</p>
    /// </li>
    /// <li>
    /// <p>Lists - This clears all to-do items from your echo device.</p>
    /// </li>
    /// <li>
    /// <p>Settings - This internally syncs the room's profile (if the device is assigned to
    /// a room), contacts, address books, delegation access for account linking, and
    /// communications (if enabled on the room profile).</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct StartDeviceSync<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_device_sync_input::Builder,
    }
    impl<C, M, R> StartDeviceSync<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDeviceSync`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDeviceSyncOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDeviceSyncError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDeviceSyncInputOperationOutputAlias,
                crate::output::StartDeviceSyncOutput,
                crate::error::StartDeviceSyncError,
                crate::input::StartDeviceSyncInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the room with which the device to sync is associated. Required.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The ARN of the room with which the device to sync is associated. Required.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
        /// <p>The ARN of the device to sync. Required.</p>
        pub fn device_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_arn(inp);
            self
        }
        /// <p>The ARN of the device to sync. Required.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_arn(input);
            self
        }
        /// Appends an item to `Features`.
        ///
        /// To override the contents of this collection use [`set_features`](Self::set_features).
        ///
        /// <p>Request structure to start the device sync. Required.</p>
        pub fn features(mut self, inp: impl Into<crate::model::Feature>) -> Self {
            self.inner = self.inner.features(inp);
            self
        }
        /// <p>Request structure to start the device sync. Required.</p>
        pub fn set_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Feature>>,
        ) -> Self {
            self.inner = self.inner.set_features(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSmartHomeApplianceDiscovery`.
    ///
    /// <p>Initiates the discovery of any smart home appliances associated with the
    /// room.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartSmartHomeApplianceDiscovery<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_smart_home_appliance_discovery_input::Builder,
    }
    impl<C, M, R> StartSmartHomeApplianceDiscovery<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSmartHomeApplianceDiscovery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSmartHomeApplianceDiscoveryOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSmartHomeApplianceDiscoveryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSmartHomeApplianceDiscoveryInputOperationOutputAlias,
                crate::output::StartSmartHomeApplianceDiscoveryOutput,
                crate::error::StartSmartHomeApplianceDiscoveryError,
                crate::input::StartSmartHomeApplianceDiscoveryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The room where smart home appliance discovery was initiated.</p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The room where smart home appliance discovery was initiated.</p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds metadata tags to a specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to which to add metadata tags. Required. </p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the resource to which to add metadata tags. Required. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified resource. Do not provide system tags. Required.
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be added to the specified resource. Do not provide system tags. Required.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes metadata tags from a specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource from which to remove metadata tags. Required. </p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the resource from which to remove metadata tags. Required. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tags to be removed from the specified resource. Do not provide system tags.
        /// Required. </p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tags to be removed from the specified resource. Do not provide system tags.
        /// Required. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAddressBook`.
    ///
    /// <p>Updates address book details by the address book ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAddressBook<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_address_book_input::Builder,
    }
    impl<C, M, R> UpdateAddressBook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAddressBook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAddressBookOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAddressBookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAddressBookInputOperationOutputAlias,
                crate::output::UpdateAddressBookOutput,
                crate::error::UpdateAddressBookError,
                crate::input::UpdateAddressBookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the room to update.</p>
        pub fn address_book_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address_book_arn(inp);
            self
        }
        /// <p>The ARN of the room to update.</p>
        pub fn set_address_book_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_address_book_arn(input);
            self
        }
        /// <p>The updated name of the room.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The updated name of the room.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated description of the room.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated description of the room.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBusinessReportSchedule`.
    ///
    /// <p>Updates the configuration of the report delivery schedule with the specified schedule
    /// ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBusinessReportSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_business_report_schedule_input::Builder,
    }
    impl<C, M, R> UpdateBusinessReportSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBusinessReportSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBusinessReportScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBusinessReportScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBusinessReportScheduleInputOperationOutputAlias,
                crate::output::UpdateBusinessReportScheduleOutput,
                crate::error::UpdateBusinessReportScheduleError,
                crate::input::UpdateBusinessReportScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the business report schedule.</p>
        pub fn schedule_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_arn(inp);
            self
        }
        /// <p>The ARN of the business report schedule.</p>
        pub fn set_schedule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule_arn(input);
            self
        }
        /// <p>The S3 location of the output reports.</p>
        pub fn s3_bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_name(inp);
            self
        }
        /// <p>The S3 location of the output reports.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_name(input);
            self
        }
        /// <p>The S3 key where the report is delivered.</p>
        pub fn s3_key_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_key_prefix(inp);
            self
        }
        /// <p>The S3 key where the report is delivered.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_key_prefix(input);
            self
        }
        /// <p>The format of the generated report (individual CSV files or zipped files of
        /// individual files).</p>
        pub fn format(mut self, inp: crate::model::BusinessReportFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>The format of the generated report (individual CSV files or zipped files of
        /// individual files).</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::BusinessReportFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>The name identifier of the schedule.</p>
        pub fn schedule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_name(inp);
            self
        }
        /// <p>The name identifier of the schedule.</p>
        pub fn set_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_name(input);
            self
        }
        /// <p>The recurrence of the reports.</p>
        pub fn recurrence(mut self, inp: crate::model::BusinessReportRecurrence) -> Self {
            self.inner = self.inner.recurrence(inp);
            self
        }
        /// <p>The recurrence of the reports.</p>
        pub fn set_recurrence(
            mut self,
            input: std::option::Option<crate::model::BusinessReportRecurrence>,
        ) -> Self {
            self.inner = self.inner.set_recurrence(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConferenceProvider`.
    ///
    /// <p>Updates an existing conference provider's settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConferenceProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_conference_provider_input::Builder,
    }
    impl<C, M, R> UpdateConferenceProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConferenceProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConferenceProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConferenceProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConferenceProviderInputOperationOutputAlias,
                crate::output::UpdateConferenceProviderOutput,
                crate::error::UpdateConferenceProviderError,
                crate::input::UpdateConferenceProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the conference provider.</p>
        pub fn conference_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conference_provider_arn(inp);
            self
        }
        /// <p>The ARN of the conference provider.</p>
        pub fn set_conference_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_conference_provider_arn(input);
            self
        }
        /// <p>The type of the conference provider.</p>
        pub fn conference_provider_type(
            mut self,
            inp: crate::model::ConferenceProviderType,
        ) -> Self {
            self.inner = self.inner.conference_provider_type(inp);
            self
        }
        /// <p>The type of the conference provider.</p>
        pub fn set_conference_provider_type(
            mut self,
            input: std::option::Option<crate::model::ConferenceProviderType>,
        ) -> Self {
            self.inner = self.inner.set_conference_provider_type(input);
            self
        }
        /// <p>The IP endpoint and protocol for calling.</p>
        pub fn ip_dial_in(mut self, inp: crate::model::IpDialIn) -> Self {
            self.inner = self.inner.ip_dial_in(inp);
            self
        }
        /// <p>The IP endpoint and protocol for calling.</p>
        pub fn set_ip_dial_in(
            mut self,
            input: std::option::Option<crate::model::IpDialIn>,
        ) -> Self {
            self.inner = self.inner.set_ip_dial_in(input);
            self
        }
        /// <p>The information for PSTN conferencing.</p>
        pub fn pstn_dial_in(mut self, inp: crate::model::PstnDialIn) -> Self {
            self.inner = self.inner.pstn_dial_in(inp);
            self
        }
        /// <p>The information for PSTN conferencing.</p>
        pub fn set_pstn_dial_in(
            mut self,
            input: std::option::Option<crate::model::PstnDialIn>,
        ) -> Self {
            self.inner = self.inner.set_pstn_dial_in(input);
            self
        }
        /// <p>The meeting settings for the conference provider.</p>
        pub fn meeting_setting(mut self, inp: crate::model::MeetingSetting) -> Self {
            self.inner = self.inner.meeting_setting(inp);
            self
        }
        /// <p>The meeting settings for the conference provider.</p>
        pub fn set_meeting_setting(
            mut self,
            input: std::option::Option<crate::model::MeetingSetting>,
        ) -> Self {
            self.inner = self.inner.set_meeting_setting(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContact`.
    ///
    /// <p>Updates the contact details by the contact ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_input::Builder,
    }
    impl<C, M, R> UpdateContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactInputOperationOutputAlias,
                crate::output::UpdateContactOutput,
                crate::error::UpdateContactError,
                crate::input::UpdateContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the contact to update.</p>
        pub fn contact_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_arn(inp);
            self
        }
        /// <p>The ARN of the contact to update.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_arn(input);
            self
        }
        /// <p>The updated display name of the contact.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The updated display name of the contact.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The updated first name of the contact.</p>
        pub fn first_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.first_name(inp);
            self
        }
        /// <p>The updated first name of the contact.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_first_name(input);
            self
        }
        /// <p>The updated last name of the contact.</p>
        pub fn last_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.last_name(inp);
            self
        }
        /// <p>The updated last name of the contact.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_last_name(input);
            self
        }
        /// <p>The updated phone number of the contact. The phone number type defaults to WORK. You
        /// can either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
        /// which lets you specify the phone number type and multiple numbers.</p>
        pub fn phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number(inp);
            self
        }
        /// <p>The updated phone number of the contact. The phone number type defaults to WORK. You
        /// can either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
        /// which lets you specify the phone number type and multiple numbers.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_phone_number(input);
            self
        }
        /// Appends an item to `PhoneNumbers`.
        ///
        /// To override the contents of this collection use [`set_phone_numbers`](Self::set_phone_numbers).
        ///
        /// <p>The list of phone numbers for the contact.</p>
        pub fn phone_numbers(mut self, inp: impl Into<crate::model::PhoneNumber>) -> Self {
            self.inner = self.inner.phone_numbers(inp);
            self
        }
        /// <p>The list of phone numbers for the contact.</p>
        pub fn set_phone_numbers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumber>>,
        ) -> Self {
            self.inner = self.inner.set_phone_numbers(input);
            self
        }
        /// Appends an item to `SipAddresses`.
        ///
        /// To override the contents of this collection use [`set_sip_addresses`](Self::set_sip_addresses).
        ///
        /// <p>The list of SIP addresses for the contact.</p>
        pub fn sip_addresses(mut self, inp: impl Into<crate::model::SipAddress>) -> Self {
            self.inner = self.inner.sip_addresses(inp);
            self
        }
        /// <p>The list of SIP addresses for the contact.</p>
        pub fn set_sip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SipAddress>>,
        ) -> Self {
            self.inner = self.inner.set_sip_addresses(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDevice`.
    ///
    /// <p>Updates the device name by device ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_device_input::Builder,
    }
    impl<C, M, R> UpdateDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDeviceInputOperationOutputAlias,
                crate::output::UpdateDeviceOutput,
                crate::error::UpdateDeviceError,
                crate::input::UpdateDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the device to update. Required.</p>
        pub fn device_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_arn(inp);
            self
        }
        /// <p>The ARN of the device to update. Required.</p>
        pub fn set_device_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_arn(input);
            self
        }
        /// <p>The updated device name. Required.</p>
        pub fn device_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_name(inp);
            self
        }
        /// <p>The updated device name. Required.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGateway`.
    ///
    /// <p>Updates the details of a gateway. If any optional field is not provided, the existing
    /// corresponding value is left unmodified.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_gateway_input::Builder,
    }
    impl<C, M, R> UpdateGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGatewayInputOperationOutputAlias,
                crate::output::UpdateGatewayOutput,
                crate::error::UpdateGatewayError,
                crate::input::UpdateGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the gateway to update.</p>
        pub fn gateway_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_arn(inp);
            self
        }
        /// <p>The ARN of the gateway to update.</p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_arn(input);
            self
        }
        /// <p>The updated name of the gateway.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The updated name of the gateway.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated description of the gateway.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated description of the gateway.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The updated software version of the gateway. The gateway automatically updates its
        /// software version during normal operation.</p>
        pub fn software_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.software_version(inp);
            self
        }
        /// <p>The updated software version of the gateway. The gateway automatically updates its
        /// software version during normal operation.</p>
        pub fn set_software_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_software_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGatewayGroup`.
    ///
    /// <p>Updates the details of a gateway group. If any optional field is not provided, the
    /// existing corresponding value is left unmodified.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGatewayGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_gateway_group_input::Builder,
    }
    impl<C, M, R> UpdateGatewayGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGatewayGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewayGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGatewayGroupInputOperationOutputAlias,
                crate::output::UpdateGatewayGroupOutput,
                crate::error::UpdateGatewayGroupError,
                crate::input::UpdateGatewayGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the gateway group to update.</p>
        pub fn gateway_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_group_arn(inp);
            self
        }
        /// <p>The ARN of the gateway group to update.</p>
        pub fn set_gateway_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_group_arn(input);
            self
        }
        /// <p>The updated name of the gateway group.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The updated name of the gateway group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated description of the gateway group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated description of the gateway group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNetworkProfile`.
    ///
    /// <p>Updates a network profile by the network profile ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateNetworkProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_network_profile_input::Builder,
    }
    impl<C, M, R> UpdateNetworkProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNetworkProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNetworkProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNetworkProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNetworkProfileInputOperationOutputAlias,
                crate::output::UpdateNetworkProfileOutput,
                crate::error::UpdateNetworkProfileError,
                crate::input::UpdateNetworkProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn network_profile_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_profile_arn(inp);
            self
        }
        /// <p>The ARN of the network profile associated with a device.</p>
        pub fn set_network_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_profile_arn(input);
            self
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn network_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_profile_name(inp);
            self
        }
        /// <p>The name of the network profile associated with a device.</p>
        pub fn set_network_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_profile_name(input);
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Detailed information about a device's network profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The current password of the Wi-Fi network.</p>
        pub fn current_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_password(inp);
            self
        }
        /// <p>The current password of the Wi-Fi network.</p>
        pub fn set_current_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_password(input);
            self
        }
        /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
        /// transmitted to the device and is used when the password of the network changes to
        /// NextPassword. </p>
        pub fn next_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_password(inp);
            self
        }
        /// <p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously
        /// transmitted to the device and is used when the password of the network changes to
        /// NextPassword. </p>
        pub fn set_next_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_password(input);
            self
        }
        /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
        /// (ACM). This is used to issue certificates to the devices. </p>
        pub fn certificate_authority_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(inp);
            self
        }
        /// <p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager
        /// (ACM). This is used to issue certificates to the devices. </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// Appends an item to `TrustAnchors`.
        ///
        /// To override the contents of this collection use [`set_trust_anchors`](Self::set_trust_anchors).
        ///
        /// <p>The root certificate(s) of your authentication server that will be installed on your
        /// devices and used to trust your authentication server during EAP negotiation. </p>
        pub fn trust_anchors(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_anchors(inp);
            self
        }
        /// <p>The root certificate(s) of your authentication server that will be installed on your
        /// devices and used to trust your authentication server during EAP negotiation. </p>
        pub fn set_trust_anchors(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_trust_anchors(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProfile`.
    ///
    /// <p>Updates an existing room profile by room profile ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_profile_input::Builder,
    }
    impl<C, M, R> UpdateProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProfileInputOperationOutputAlias,
                crate::output::UpdateProfileOutput,
                crate::error::UpdateProfileError,
                crate::input::UpdateProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the room profile to update. Required.</p>
        pub fn profile_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_arn(inp);
            self
        }
        /// <p>The ARN of the room profile to update. Required.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_arn(input);
            self
        }
        /// <p>The updated name for the room profile.</p>
        pub fn profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(inp);
            self
        }
        /// <p>The updated name for the room profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>Sets the profile as default if selected. If this is missing, no update is done to the
        /// default status.</p>
        pub fn is_default(mut self, inp: bool) -> Self {
            self.inner = self.inner.is_default(inp);
            self
        }
        /// <p>Sets the profile as default if selected. If this is missing, no update is done to the
        /// default status.</p>
        pub fn set_is_default(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_default(input);
            self
        }
        /// <p>The updated timezone for the room profile.</p>
        pub fn timezone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.timezone(inp);
            self
        }
        /// <p>The updated timezone for the room profile.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_timezone(input);
            self
        }
        /// <p>The updated address for the room profile.</p>
        pub fn address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address(inp);
            self
        }
        /// <p>The updated address for the room profile.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_address(input);
            self
        }
        /// <p>The updated distance unit for the room profile.</p>
        pub fn distance_unit(mut self, inp: crate::model::DistanceUnit) -> Self {
            self.inner = self.inner.distance_unit(inp);
            self
        }
        /// <p>The updated distance unit for the room profile.</p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.inner = self.inner.set_distance_unit(input);
            self
        }
        /// <p>The updated temperature unit for the room profile.</p>
        pub fn temperature_unit(mut self, inp: crate::model::TemperatureUnit) -> Self {
            self.inner = self.inner.temperature_unit(inp);
            self
        }
        /// <p>The updated temperature unit for the room profile.</p>
        pub fn set_temperature_unit(
            mut self,
            input: std::option::Option<crate::model::TemperatureUnit>,
        ) -> Self {
            self.inner = self.inner.set_temperature_unit(input);
            self
        }
        /// <p>The updated wake word for the room profile.</p>
        pub fn wake_word(mut self, inp: crate::model::WakeWord) -> Self {
            self.inner = self.inner.wake_word(inp);
            self
        }
        /// <p>The updated wake word for the room profile.</p>
        pub fn set_wake_word(mut self, input: std::option::Option<crate::model::WakeWord>) -> Self {
            self.inner = self.inner.set_wake_word(input);
            self
        }
        /// <p>The updated locale for the room profile. (This is currently only available to a limited preview audience.)</p>
        pub fn locale(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale(inp);
            self
        }
        /// <p>The updated locale for the room profile. (This is currently only available to a limited preview audience.)</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>Whether the setup mode of the profile is enabled.</p>
        pub fn setup_mode_disabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.setup_mode_disabled(inp);
            self
        }
        /// <p>Whether the setup mode of the profile is enabled.</p>
        pub fn set_setup_mode_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_setup_mode_disabled(input);
            self
        }
        /// <p>The updated maximum volume limit for the room profile.</p>
        pub fn max_volume_limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_volume_limit(inp);
            self
        }
        /// <p>The updated maximum volume limit for the room profile.</p>
        pub fn set_max_volume_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_volume_limit(input);
            self
        }
        /// <p>Whether the PSTN setting of the room profile is enabled.</p>
        pub fn pstn_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.pstn_enabled(inp);
            self
        }
        /// <p>Whether the PSTN setting of the room profile is enabled.</p>
        pub fn set_pstn_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_pstn_enabled(input);
            self
        }
        /// <p>Whether data retention of the profile is enabled.</p>
        pub fn data_retention_opt_in(mut self, inp: bool) -> Self {
            self.inner = self.inner.data_retention_opt_in(inp);
            self
        }
        /// <p>Whether data retention of the profile is enabled.</p>
        pub fn set_data_retention_opt_in(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_data_retention_opt_in(input);
            self
        }
        /// <p>The updated meeting room settings of a room profile.</p>
        pub fn meeting_room_configuration(
            mut self,
            inp: crate::model::UpdateMeetingRoomConfiguration,
        ) -> Self {
            self.inner = self.inner.meeting_room_configuration(inp);
            self
        }
        /// <p>The updated meeting room settings of a room profile.</p>
        pub fn set_meeting_room_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateMeetingRoomConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_meeting_room_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoom`.
    ///
    /// <p>Updates room details by room ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRoom<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_room_input::Builder,
    }
    impl<C, M, R> UpdateRoom<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRoomError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRoomInputOperationOutputAlias,
                crate::output::UpdateRoomOutput,
                crate::error::UpdateRoomError,
                crate::input::UpdateRoomInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the room to update. </p>
        pub fn room_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_arn(inp);
            self
        }
        /// <p>The ARN of the room to update. </p>
        pub fn set_room_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_arn(input);
            self
        }
        /// <p>The updated name for the room.</p>
        pub fn room_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_name(inp);
            self
        }
        /// <p>The updated name for the room.</p>
        pub fn set_room_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_room_name(input);
            self
        }
        /// <p>The updated description for the room.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated description for the room.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The updated provider calendar ARN for the room.</p>
        pub fn provider_calendar_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provider_calendar_id(inp);
            self
        }
        /// <p>The updated provider calendar ARN for the room.</p>
        pub fn set_provider_calendar_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provider_calendar_id(input);
            self
        }
        /// <p>The updated profile ARN for the room.</p>
        pub fn profile_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_arn(inp);
            self
        }
        /// <p>The updated profile ARN for the room.</p>
        pub fn set_profile_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSkillGroup`.
    ///
    /// <p>Updates skill group details by skill group ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSkillGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_skill_group_input::Builder,
    }
    impl<C, M, R> UpdateSkillGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSkillGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSkillGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSkillGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSkillGroupInputOperationOutputAlias,
                crate::output::UpdateSkillGroupOutput,
                crate::error::UpdateSkillGroupError,
                crate::input::UpdateSkillGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the skill group to update. </p>
        pub fn skill_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_group_arn(inp);
            self
        }
        /// <p>The ARN of the skill group to update. </p>
        pub fn set_skill_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_skill_group_arn(input);
            self
        }
        /// <p>The updated name for the skill group.</p>
        pub fn skill_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.skill_group_name(inp);
            self
        }
        /// <p>The updated name for the skill group.</p>
        pub fn set_skill_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_skill_group_name(input);
            self
        }
        /// <p>The updated description for the skill group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated description for the skill group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
