// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Certificate Manager Private Certificate Authority
///
/// Client for invoking operations on AWS Certificate Manager Private Certificate Authority. Each operation on AWS Certificate Manager Private Certificate Authority is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_acmpca::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_acmpca::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_acmpca::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateCertificateAuthority`](crate::client::fluent_builders::CreateCertificateAuthority) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_configuration(CertificateAuthorityConfiguration)`](crate::client::fluent_builders::CreateCertificateAuthority::certificate_authority_configuration) / [`set_certificate_authority_configuration(Option<CertificateAuthorityConfiguration>)`](crate::client::fluent_builders::CreateCertificateAuthority::set_certificate_authority_configuration): <p>Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500 certificate subject information.</p>
    ///   - [`revocation_configuration(RevocationConfiguration)`](crate::client::fluent_builders::CreateCertificateAuthority::revocation_configuration) / [`set_revocation_configuration(Option<RevocationConfiguration>)`](crate::client::fluent_builders::CreateCertificateAuthority::set_revocation_configuration): <p>Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate revocation list (CRL), to enable both, or to enable neither. The default is for both certificate validation mechanisms to be disabled. For more information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
    ///   - [`certificate_authority_type(CertificateAuthorityType)`](crate::client::fluent_builders::CreateCertificateAuthority::certificate_authority_type) / [`set_certificate_authority_type(Option<CertificateAuthorityType>)`](crate::client::fluent_builders::CreateCertificateAuthority::set_certificate_authority_type): <p>The type of the certificate authority.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateCertificateAuthority::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateCertificateAuthority::set_idempotency_token): <p>Custom string that can be used to distinguish between calls to the <b>CreateCertificateAuthority</b> action. Idempotency tokens for <b>CreateCertificateAuthority</b> time out after five minutes. Therefore, if you call <b>CreateCertificateAuthority</b> multiple times with the same idempotency token within five minutes, ACM Private CA recognizes that you are requesting only certificate authority and will issue only one. If you change the idempotency token for each call, PCA recognizes that you are requesting multiple certificate authorities.</p>
    ///   - [`key_storage_security_standard(KeyStorageSecurityStandard)`](crate::client::fluent_builders::CreateCertificateAuthority::key_storage_security_standard) / [`set_key_storage_security_standard(Option<KeyStorageSecurityStandard>)`](crate::client::fluent_builders::CreateCertificateAuthority::set_key_storage_security_standard): <p>Specifies a cryptographic key management compliance standard used for handling CA keys.</p>  <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p>  <p>Note: <code>FIPS_140_2_LEVEL_3_OR_HIGHER</code> is not supported in Region ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide <code>FIPS_140_2_LEVEL_2_OR_HIGHER</code> as the argument for <code>KeyStorageSecurityStandard</code>. Failure to do this results in an <code>InvalidArgsException</code> with the message, "A certificate authority cannot be created in this region with the specified security standard."</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCertificateAuthority::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCertificateAuthority::set_tags): <p>Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private CA. For information using tags with IAM to manage permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>
    /// - On success, responds with [`CreateCertificateAuthorityOutput`](crate::output::CreateCertificateAuthorityOutput) with field(s):
    ///   - [`certificate_authority_arn(Option<String>)`](crate::output::CreateCertificateAuthorityOutput::certificate_authority_arn): <p>If successful, the Amazon Resource Name (ARN) of the certificate authority (CA). This is of the form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
    /// - On failure, responds with [`SdkError<CreateCertificateAuthorityError>`](crate::error::CreateCertificateAuthorityError)
    pub fn create_certificate_authority(&self) -> fluent_builders::CreateCertificateAuthority {
        fluent_builders::CreateCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCertificateAuthorityAuditReport`](crate::client::fluent_builders::CreateCertificateAuthorityAuditReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCertificateAuthorityAuditReport::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::CreateCertificateAuthorityAuditReport::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:</p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>.</p>
    ///   - [`s3_bucket_name(impl Into<String>)`](crate::client::fluent_builders::CreateCertificateAuthorityAuditReport::s3_bucket_name) / [`set_s3_bucket_name(Option<String>)`](crate::client::fluent_builders::CreateCertificateAuthorityAuditReport::set_s3_bucket_name): <p>The name of the S3 bucket that will contain the audit report.</p>
    ///   - [`audit_report_response_format(AuditReportResponseFormat)`](crate::client::fluent_builders::CreateCertificateAuthorityAuditReport::audit_report_response_format) / [`set_audit_report_response_format(Option<AuditReportResponseFormat>)`](crate::client::fluent_builders::CreateCertificateAuthorityAuditReport::set_audit_report_response_format): <p>The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.</p>
    /// - On success, responds with [`CreateCertificateAuthorityAuditReportOutput`](crate::output::CreateCertificateAuthorityAuditReportOutput) with field(s):
    ///   - [`audit_report_id(Option<String>)`](crate::output::CreateCertificateAuthorityAuditReportOutput::audit_report_id): <p>An alphanumeric string that contains a report identifier.</p>
    ///   - [`s3_key(Option<String>)`](crate::output::CreateCertificateAuthorityAuditReportOutput::s3_key): <p>The <b>key</b> that uniquely identifies the report file in your S3 bucket.</p>
    /// - On failure, responds with [`SdkError<CreateCertificateAuthorityAuditReportError>`](crate::error::CreateCertificateAuthorityAuditReportError)
    pub fn create_certificate_authority_audit_report(
        &self,
    ) -> fluent_builders::CreateCertificateAuthorityAuditReport {
        fluent_builders::CreateCertificateAuthorityAuditReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePermission`](crate::client::fluent_builders::CreatePermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::CreatePermission::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::CreatePermission::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::CreatePermission::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::CreatePermission::set_principal): <p>The Amazon Web Services service or identity that receives the permission. At this time, the only valid principal is <code>acm.amazonaws.com</code>.</p>
    ///   - [`source_account(impl Into<String>)`](crate::client::fluent_builders::CreatePermission::source_account) / [`set_source_account(Option<String>)`](crate::client::fluent_builders::CreatePermission::set_source_account): <p>The ID of the calling account.</p>
    ///   - [`actions(Vec<ActionType>)`](crate::client::fluent_builders::CreatePermission::actions) / [`set_actions(Option<Vec<ActionType>>)`](crate::client::fluent_builders::CreatePermission::set_actions): <p>The actions that the specified Amazon Web Services service principal can use. These include <code>IssueCertificate</code>, <code>GetCertificate</code>, and <code>ListPermissions</code>.</p>
    /// - On success, responds with [`CreatePermissionOutput`](crate::output::CreatePermissionOutput)

    /// - On failure, responds with [`SdkError<CreatePermissionError>`](crate::error::CreatePermissionError)
    pub fn create_permission(&self) -> fluent_builders::CreatePermission {
        fluent_builders::CreatePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCertificateAuthority`](crate::client::fluent_builders::DeleteCertificateAuthority) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteCertificateAuthority::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::DeleteCertificateAuthority::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must have the following form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
    ///   - [`permanent_deletion_time_in_days(i32)`](crate::client::fluent_builders::DeleteCertificateAuthority::permanent_deletion_time_in_days) / [`set_permanent_deletion_time_in_days(Option<i32>)`](crate::client::fluent_builders::DeleteCertificateAuthority::set_permanent_deletion_time_in_days): <p>The number of days to make a CA restorable after it has been deleted. This can be anywhere from 7 to 30 days, with 30 being the default.</p>
    /// - On success, responds with [`DeleteCertificateAuthorityOutput`](crate::output::DeleteCertificateAuthorityOutput)

    /// - On failure, responds with [`SdkError<DeleteCertificateAuthorityError>`](crate::error::DeleteCertificateAuthorityError)
    pub fn delete_certificate_authority(&self) -> fluent_builders::DeleteCertificateAuthority {
        fluent_builders::DeleteCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePermission`](crate::client::fluent_builders::DeletePermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::DeletePermission::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::DeletePermission::set_certificate_authority_arn): <p>The Amazon Resource Number (ARN) of the private CA that issued the permissions. You can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::DeletePermission::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::DeletePermission::set_principal): <p>The Amazon Web Services service or identity that will have its CA permissions revoked. At this time, the only valid service principal is <code>acm.amazonaws.com</code> </p>
    ///   - [`source_account(impl Into<String>)`](crate::client::fluent_builders::DeletePermission::source_account) / [`set_source_account(Option<String>)`](crate::client::fluent_builders::DeletePermission::set_source_account): <p>The Amazon Web Services account that calls this action.</p>
    /// - On success, responds with [`DeletePermissionOutput`](crate::output::DeletePermissionOutput)

    /// - On failure, responds with [`SdkError<DeletePermissionError>`](crate::error::DeletePermissionError)
    pub fn delete_permission(&self) -> fluent_builders::DeletePermission {
        fluent_builders::DeletePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePolicy`](crate::client::fluent_builders::DeletePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeletePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeletePolicy::set_resource_arn): <p>The Amazon Resource Number (ARN) of the private CA that will have its policy deleted. You can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. The ARN value must have the form <code>arn:aws:acm-pca:region:account:certificate-authority/01234567-89ab-cdef-0123-0123456789ab</code>. </p>
    /// - On success, responds with [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)

    /// - On failure, responds with [`SdkError<DeletePolicyError>`](crate::error::DeletePolicyError)
    pub fn delete_policy(&self) -> fluent_builders::DeletePolicy {
        fluent_builders::DeletePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCertificateAuthority`](crate::client::fluent_builders::DescribeCertificateAuthority) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeCertificateAuthority::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::DescribeCertificateAuthority::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
    /// - On success, responds with [`DescribeCertificateAuthorityOutput`](crate::output::DescribeCertificateAuthorityOutput) with field(s):
    ///   - [`certificate_authority(Option<CertificateAuthority>)`](crate::output::DescribeCertificateAuthorityOutput::certificate_authority): <p>A <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CertificateAuthority.html">CertificateAuthority</a> structure that contains information about your private CA.</p>
    /// - On failure, responds with [`SdkError<DescribeCertificateAuthorityError>`](crate::error::DescribeCertificateAuthorityError)
    pub fn describe_certificate_authority(&self) -> fluent_builders::DescribeCertificateAuthority {
        fluent_builders::DescribeCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCertificateAuthorityAuditReport`](crate::client::fluent_builders::DescribeCertificateAuthorityAuditReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeCertificateAuthorityAuditReport::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::DescribeCertificateAuthorityAuditReport::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) of the private CA. This must be of the form:</p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
    ///   - [`audit_report_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCertificateAuthorityAuditReport::audit_report_id) / [`set_audit_report_id(Option<String>)`](crate::client::fluent_builders::DescribeCertificateAuthorityAuditReport::set_audit_report_id): <p>The report ID returned by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a> action.</p>
    /// - On success, responds with [`DescribeCertificateAuthorityAuditReportOutput`](crate::output::DescribeCertificateAuthorityAuditReportOutput) with field(s):
    ///   - [`audit_report_status(Option<AuditReportStatus>)`](crate::output::DescribeCertificateAuthorityAuditReportOutput::audit_report_status): <p>Specifies whether report creation is in progress, has succeeded, or has failed.</p>
    ///   - [`s3_bucket_name(Option<String>)`](crate::output::DescribeCertificateAuthorityAuditReportOutput::s3_bucket_name): <p>Name of the S3 bucket that contains the report.</p>
    ///   - [`s3_key(Option<String>)`](crate::output::DescribeCertificateAuthorityAuditReportOutput::s3_key): <p>S3 <b>key</b> that uniquely identifies the report file in your S3 bucket.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::DescribeCertificateAuthorityAuditReportOutput::created_at): <p>The date and time at which the report was created.</p>
    /// - On failure, responds with [`SdkError<DescribeCertificateAuthorityAuditReportError>`](crate::error::DescribeCertificateAuthorityAuditReportError)
    pub fn describe_certificate_authority_audit_report(
        &self,
    ) -> fluent_builders::DescribeCertificateAuthorityAuditReport {
        fluent_builders::DescribeCertificateAuthorityAuditReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCertificate`](crate::client::fluent_builders::GetCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::GetCertificate::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::GetCertificate::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
    ///   - [`certificate_arn(impl Into<String>)`](crate::client::fluent_builders::GetCertificate::certificate_arn) / [`set_certificate_arn(Option<String>)`](crate::client::fluent_builders::GetCertificate::set_certificate_arn): <p>The ARN of the issued certificate. The ARN contains the certificate serial number and must be in the following form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> </code> </p>
    /// - On success, responds with [`GetCertificateOutput`](crate::output::GetCertificateOutput) with field(s):
    ///   - [`certificate(Option<String>)`](crate::output::GetCertificateOutput::certificate): <p>The base64 PEM-encoded certificate specified by the <code>CertificateArn</code> parameter.</p>
    ///   - [`certificate_chain(Option<String>)`](crate::output::GetCertificateOutput::certificate_chain): <p>The base64 PEM-encoded certificate chain that chains up to the root CA certificate that you used to sign your private CA certificate. </p>
    /// - On failure, responds with [`SdkError<GetCertificateError>`](crate::error::GetCertificateError)
    pub fn get_certificate(&self) -> fluent_builders::GetCertificate {
        fluent_builders::GetCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCertificateAuthorityCertificate`](crate::client::fluent_builders::GetCertificateAuthorityCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::GetCertificateAuthorityCertificate::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::GetCertificateAuthorityCertificate::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) of your private CA. This is of the form:</p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
    /// - On success, responds with [`GetCertificateAuthorityCertificateOutput`](crate::output::GetCertificateAuthorityCertificateOutput) with field(s):
    ///   - [`certificate(Option<String>)`](crate::output::GetCertificateAuthorityCertificateOutput::certificate): <p>Base64-encoded certificate authority (CA) certificate.</p>
    ///   - [`certificate_chain(Option<String>)`](crate::output::GetCertificateAuthorityCertificateOutput::certificate_chain): <p>Base64-encoded certificate chain that includes any intermediate certificates and chains up to root certificate that you used to sign your private CA certificate. The chain does not include your private CA certificate. If this is a root CA, the value will be null.</p>
    /// - On failure, responds with [`SdkError<GetCertificateAuthorityCertificateError>`](crate::error::GetCertificateAuthorityCertificateError)
    pub fn get_certificate_authority_certificate(
        &self,
    ) -> fluent_builders::GetCertificateAuthorityCertificate {
        fluent_builders::GetCertificateAuthorityCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCertificateAuthorityCsr`](crate::client::fluent_builders::GetCertificateAuthorityCsr) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::GetCertificateAuthorityCsr::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::GetCertificateAuthorityCsr::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
    /// - On success, responds with [`GetCertificateAuthorityCsrOutput`](crate::output::GetCertificateAuthorityCsrOutput) with field(s):
    ///   - [`csr(Option<String>)`](crate::output::GetCertificateAuthorityCsrOutput::csr): <p>The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.</p>
    /// - On failure, responds with [`SdkError<GetCertificateAuthorityCsrError>`](crate::error::GetCertificateAuthorityCsrError)
    pub fn get_certificate_authority_csr(&self) -> fluent_builders::GetCertificateAuthorityCsr {
        fluent_builders::GetCertificateAuthorityCsr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPolicy`](crate::client::fluent_builders::GetPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetPolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetPolicy::set_resource_arn): <p>The Amazon Resource Number (ARN) of the private CA that will have its policy retrieved. You can find the CA's ARN by calling the ListCertificateAuthorities action. </p>
    /// - On success, responds with [`GetPolicyOutput`](crate::output::GetPolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetPolicyOutput::policy): <p>The policy attached to the private CA as a JSON document.</p>
    /// - On failure, responds with [`SdkError<GetPolicyError>`](crate::error::GetPolicyError)
    pub fn get_policy(&self) -> fluent_builders::GetPolicy {
        fluent_builders::GetPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportCertificateAuthorityCertificate`](crate::client::fluent_builders::ImportCertificateAuthorityCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::ImportCertificateAuthorityCertificate::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::ImportCertificateAuthorityCertificate::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
    ///   - [`certificate(Blob)`](crate::client::fluent_builders::ImportCertificateAuthorityCertificate::certificate) / [`set_certificate(Option<Blob>)`](crate::client::fluent_builders::ImportCertificateAuthorityCertificate::set_certificate): <p>The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a root CA, or it may be signed by another CA that you control.</p>
    ///   - [`certificate_chain(Blob)`](crate::client::fluent_builders::ImportCertificateAuthorityCertificate::certificate_chain) / [`set_certificate_chain(Option<Blob>)`](crate::client::fluent_builders::ImportCertificateAuthorityCertificate::set_certificate_chain): <p>A PEM-encoded file that contains all of your certificates, other than the certificate you're importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root certificate is the last in the chain, and each certificate in the chain signs the one preceding. </p>  <p>This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is no chain.</p>
    /// - On success, responds with [`ImportCertificateAuthorityCertificateOutput`](crate::output::ImportCertificateAuthorityCertificateOutput)

    /// - On failure, responds with [`SdkError<ImportCertificateAuthorityCertificateError>`](crate::error::ImportCertificateAuthorityCertificateError)
    pub fn import_certificate_authority_certificate(
        &self,
    ) -> fluent_builders::ImportCertificateAuthorityCertificate {
        fluent_builders::ImportCertificateAuthorityCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`IssueCertificate`](crate::client::fluent_builders::IssueCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_passthrough(ApiPassthrough)`](crate::client::fluent_builders::IssueCertificate::api_passthrough) / [`set_api_passthrough(Option<ApiPassthrough>)`](crate::client::fluent_builders::IssueCertificate::set_api_passthrough): <p>Specifies X.509 certificate information to be included in the issued certificate. An <code>APIPassthrough</code> or <code>APICSRPassthrough</code> template variant must be selected, or else this parameter is ignored. For more information about using these templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate Templates</a>.</p>  <p>If conflicting or duplicate certificate information is supplied during certificate issuance, ACM Private CA applies <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">order of operation rules</a> to determine what information is used.</p>
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::IssueCertificate::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::IssueCertificate::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form:</p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
    ///   - [`csr(Blob)`](crate::client::fluent_builders::IssueCertificate::csr) / [`set_csr(Option<Blob>)`](crate::client::fluent_builders::IssueCertificate::set_csr): <p>The certificate signing request (CSR) for the certificate you want to issue. As an example, you can use the following OpenSSL command to create the CSR and a 2048 bit RSA private key. </p>  <p> <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code> </p>  <p>If you have a configuration file, you can then use the following OpenSSL command. The <code>usr_cert</code> block in the configuration file contains your X509 version 3 extensions. </p>  <p> <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code> </p>  <p>Note: A CSR must provide either a <i>subject name</i> or a <i>subject alternative name</i> or the request will be rejected. </p>
    ///   - [`signing_algorithm(SigningAlgorithm)`](crate::client::fluent_builders::IssueCertificate::signing_algorithm) / [`set_signing_algorithm(Option<SigningAlgorithm>)`](crate::client::fluent_builders::IssueCertificate::set_signing_algorithm): <p>The name of the algorithm that will be used to sign the certificate to be issued. </p>  <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign a CSR in the <code>CreateCertificateAuthority</code> action.</p> <note>   <p>The specified signing algorithm family (RSA or ECDSA) much match the algorithm family of the CA's secret key.</p>  </note>
    ///   - [`template_arn(impl Into<String>)`](crate::client::fluent_builders::IssueCertificate::template_arn) / [`set_template_arn(Option<String>)`](crate::client::fluent_builders::IssueCertificate::set_template_arn): <p>Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template. For CA certificates, you should choose the shortest path length that meets your needs. The path length is indicated by the PathLen<i>N</i> portion of the ARN, where <i>N</i> is the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaTerms.html#terms-cadepth">CA depth</a>.</p>  <p>Note: The CA depth configured on a subordinate CA certificate must not exceed the limit set by its parents in the CA hierarchy.</p>  <p>For a list of <code>TemplateArn</code> values supported by ACM Private CA, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate Templates</a>.</p>
    ///   - [`validity(Validity)`](crate::client::fluent_builders::IssueCertificate::validity) / [`set_validity(Option<Validity>)`](crate::client::fluent_builders::IssueCertificate::set_validity): <p>Information describing the end of the validity period of the certificate. This parameter sets the “Not After” date for the certificate.</p>  <p>Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see <a href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280. </p>  <p>This value is unaffected when <code>ValidityNotBefore</code> is also specified. For example, if <code>Validity</code> is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the <code>ValidityNotBefore</code> value.</p>  <p>The end of the validity period configured on a certificate must not exceed the limit set on its parents in the CA hierarchy.</p>
    ///   - [`validity_not_before(Validity)`](crate::client::fluent_builders::IssueCertificate::validity_not_before) / [`set_validity_not_before(Option<Validity>)`](crate::client::fluent_builders::IssueCertificate::set_validity_not_before): <p>Information describing the start of the validity period of the certificate. This parameter sets the “Not Before" date for the certificate.</p>  <p>By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize the “Not Before” value. </p>  <p>Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code> parameter is optional.</p>  <p>The <code>ValidityNotBefore</code> value is expressed as an explicit date and time, using the <code>Validity</code> type value <code>ABSOLUTE</code>. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_Validity.html">Validity</a> in this API reference and <a href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::IssueCertificate::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::IssueCertificate::set_idempotency_token): <p>Alphanumeric string that can be used to distinguish between calls to the <b>IssueCertificate</b> action. Idempotency tokens for <b>IssueCertificate</b> time out after one minute. Therefore, if you call <b>IssueCertificate</b> multiple times with the same idempotency token within one minute, ACM Private CA recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, PCA recognizes that you are requesting multiple certificates.</p>
    /// - On success, responds with [`IssueCertificateOutput`](crate::output::IssueCertificateOutput) with field(s):
    ///   - [`certificate_arn(Option<String>)`](crate::output::IssueCertificateOutput::certificate_arn): <p>The Amazon Resource Name (ARN) of the issued certificate and the certificate serial number. This is of the form:</p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> </code> </p>
    /// - On failure, responds with [`SdkError<IssueCertificateError>`](crate::error::IssueCertificateError)
    pub fn issue_certificate(&self) -> fluent_builders::IssueCertificate {
        fluent_builders::IssueCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCertificateAuthorities`](crate::client::fluent_builders::ListCertificateAuthorities) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCertificateAuthorities::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCertificateAuthorities::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCertificateAuthorities::set_next_token): <p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCertificateAuthorities::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCertificateAuthorities::set_max_results): <p>Use this parameter when paginating results to specify the maximum number of items to return in the response on each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.</p>
    ///   - [`resource_owner(ResourceOwner)`](crate::client::fluent_builders::ListCertificateAuthorities::resource_owner) / [`set_resource_owner(Option<ResourceOwner>)`](crate::client::fluent_builders::ListCertificateAuthorities::set_resource_owner): <p>Use this parameter to filter the returned set of certificate authorities based on their owner. The default is SELF.</p>
    /// - On success, responds with [`ListCertificateAuthoritiesOutput`](crate::output::ListCertificateAuthoritiesOutput) with field(s):
    ///   - [`certificate_authorities(Option<Vec<CertificateAuthority>>)`](crate::output::ListCertificateAuthoritiesOutput::certificate_authorities): <p>Summary information about each certificate authority you have created.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCertificateAuthoritiesOutput::next_token): <p>When the list is truncated, this value is present and should be used for the <code>NextToken</code> parameter in a subsequent pagination request.</p>
    /// - On failure, responds with [`SdkError<ListCertificateAuthoritiesError>`](crate::error::ListCertificateAuthoritiesError)
    pub fn list_certificate_authorities(&self) -> fluent_builders::ListCertificateAuthorities {
        fluent_builders::ListCertificateAuthorities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPermissions`](crate::client::fluent_builders::ListPermissions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPermissions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::ListPermissions::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::ListPermissions::set_certificate_authority_arn): <p>The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must be of the form: <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> You can get a private CA's ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPermissions::set_next_token): <p>When paginating results, use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPermissions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPermissions::set_max_results): <p>When paginating results, use this parameter to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <b>NextToken</b> element is sent in the response. Use this <b>NextToken</b> value in a subsequent request to retrieve additional items.</p>
    /// - On success, responds with [`ListPermissionsOutput`](crate::output::ListPermissionsOutput) with field(s):
    ///   - [`permissions(Option<Vec<Permission>>)`](crate::output::ListPermissionsOutput::permissions): <p>Summary information about each permission assigned by the specified private CA, including the action enabled, the policy provided, and the time of creation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPermissionsOutput::next_token): <p>When the list is truncated, this value is present and should be used for the <b>NextToken</b> parameter in a subsequent pagination request. </p>
    /// - On failure, responds with [`SdkError<ListPermissionsError>`](crate::error::ListPermissionsError)
    pub fn list_permissions(&self) -> fluent_builders::ListPermissions {
        fluent_builders::ListPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTags`](crate::client::fluent_builders::ListTags) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTags::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::ListTags::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::ListTags::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTags::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTags::set_next_token): <p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTags::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTags::set_max_results): <p>Use this parameter when paginating results to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <b>NextToken</b> element is sent in the response. Use this <b>NextToken</b> value in a subsequent request to retrieve additional items.</p>
    /// - On success, responds with [`ListTagsOutput`](crate::output::ListTagsOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsOutput::tags): <p>The tags associated with your private CA.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsOutput::next_token): <p>When the list is truncated, this value is present and should be used for the <b>NextToken</b> parameter in a subsequent pagination request. </p>
    /// - On failure, responds with [`SdkError<ListTagsError>`](crate::error::ListTagsError)
    pub fn list_tags(&self) -> fluent_builders::ListTags {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutPolicy`](crate::client::fluent_builders::PutPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::PutPolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::PutPolicy::set_resource_arn): <p>The Amazon Resource Number (ARN) of the private CA to associate with the policy. The ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>  <p></p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutPolicy::set_policy): <p>The path and file name of a JSON-formatted IAM policy to attach to the specified private CA resource. If this policy does not contain all required statements or if it includes any statement that is not allowed, the <code>PutPolicy</code> action returns an <code>InvalidPolicyException</code>. For information about IAM policy and statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>
    /// - On success, responds with [`PutPolicyOutput`](crate::output::PutPolicyOutput)

    /// - On failure, responds with [`SdkError<PutPolicyError>`](crate::error::PutPolicyError)
    pub fn put_policy(&self) -> fluent_builders::PutPolicy {
        fluent_builders::PutPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreCertificateAuthority`](crate::client::fluent_builders::RestoreCertificateAuthority) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::RestoreCertificateAuthority::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::RestoreCertificateAuthority::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
    /// - On success, responds with [`RestoreCertificateAuthorityOutput`](crate::output::RestoreCertificateAuthorityOutput)

    /// - On failure, responds with [`SdkError<RestoreCertificateAuthorityError>`](crate::error::RestoreCertificateAuthorityError)
    pub fn restore_certificate_authority(&self) -> fluent_builders::RestoreCertificateAuthority {
        fluent_builders::RestoreCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeCertificate`](crate::client::fluent_builders::RevokeCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::RevokeCertificate::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::RevokeCertificate::set_certificate_authority_arn): <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:</p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
    ///   - [`certificate_serial(impl Into<String>)`](crate::client::fluent_builders::RevokeCertificate::certificate_serial) / [`set_certificate_serial(Option<String>)`](crate::client::fluent_builders::RevokeCertificate::set_certificate_serial): <p>Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve the serial number by calling <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate</a> with the Amazon Resource Name (ARN) of the certificate you want and the ARN of your private CA. The <b>GetCertificate</b> action retrieves the certificate in the PEM format. You can use the following OpenSSL command to list the certificate in text format and copy the hexadecimal serial number. </p>  <p> <code>openssl x509 -in <i>file_path</i> -text -noout</code> </p>  <p>You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate</a> action in the <i>Certificate Manager API Reference</i>. </p>
    ///   - [`revocation_reason(RevocationReason)`](crate::client::fluent_builders::RevokeCertificate::revocation_reason) / [`set_revocation_reason(Option<RevocationReason>)`](crate::client::fluent_builders::RevokeCertificate::set_revocation_reason): <p>Specifies why you revoked the certificate.</p>
    /// - On success, responds with [`RevokeCertificateOutput`](crate::output::RevokeCertificateOutput)

    /// - On failure, responds with [`SdkError<RevokeCertificateError>`](crate::error::RevokeCertificateError)
    pub fn revoke_certificate(&self) -> fluent_builders::RevokeCertificate {
        fluent_builders::RevokeCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagCertificateAuthority`](crate::client::fluent_builders::TagCertificateAuthority) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::TagCertificateAuthority::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::TagCertificateAuthority::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagCertificateAuthority::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagCertificateAuthority::set_tags): <p>List of tags to be associated with the CA.</p>
    /// - On success, responds with [`TagCertificateAuthorityOutput`](crate::output::TagCertificateAuthorityOutput)

    /// - On failure, responds with [`SdkError<TagCertificateAuthorityError>`](crate::error::TagCertificateAuthorityError)
    pub fn tag_certificate_authority(&self) -> fluent_builders::TagCertificateAuthority {
        fluent_builders::TagCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagCertificateAuthority`](crate::client::fluent_builders::UntagCertificateAuthority) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::UntagCertificateAuthority::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::UntagCertificateAuthority::set_certificate_authority_arn): <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::UntagCertificateAuthority::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::UntagCertificateAuthority::set_tags): <p>List of tags to be removed from the CA.</p>
    /// - On success, responds with [`UntagCertificateAuthorityOutput`](crate::output::UntagCertificateAuthorityOutput)

    /// - On failure, responds with [`SdkError<UntagCertificateAuthorityError>`](crate::error::UntagCertificateAuthorityError)
    pub fn untag_certificate_authority(&self) -> fluent_builders::UntagCertificateAuthority {
        fluent_builders::UntagCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCertificateAuthority`](crate::client::fluent_builders::UpdateCertificateAuthority) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_authority_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateCertificateAuthority::certificate_authority_arn) / [`set_certificate_authority_arn(Option<String>)`](crate::client::fluent_builders::UpdateCertificateAuthority::set_certificate_authority_arn): <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:</p>  <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
    ///   - [`revocation_configuration(RevocationConfiguration)`](crate::client::fluent_builders::UpdateCertificateAuthority::revocation_configuration) / [`set_revocation_configuration(Option<RevocationConfiguration>)`](crate::client::fluent_builders::UpdateCertificateAuthority::set_revocation_configuration): <p>Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate revocation list (CRL), to enable both, or to enable neither. If this parameter is not supplied, existing capibilites remain unchanged. For more information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
    ///   - [`status(CertificateAuthorityStatus)`](crate::client::fluent_builders::UpdateCertificateAuthority::status) / [`set_status(Option<CertificateAuthorityStatus>)`](crate::client::fluent_builders::UpdateCertificateAuthority::set_status): <p>Status of your private CA.</p>
    /// - On success, responds with [`UpdateCertificateAuthorityOutput`](crate::output::UpdateCertificateAuthorityOutput)

    /// - On failure, responds with [`SdkError<UpdateCertificateAuthorityError>`](crate::error::UpdateCertificateAuthorityError)
    pub fn update_certificate_authority(&self) -> fluent_builders::UpdateCertificateAuthority {
        fluent_builders::UpdateCertificateAuthority::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateCertificateAuthority`.
    ///
    /// <p>Creates a root or subordinate private certificate authority (CA). You must specify the CA configuration, an optional configuration for Online Certificate Status Protocol (OCSP) and/or a certificate revocation list (CRL), the CA type, and an optional idempotency token to avoid accidental creation of multiple CAs. The CA configuration specifies the name of the algorithm and key size to be used to create the CA private key, the type of signing algorithm that the CA uses, and X.500 subject information. The OCSP configuration can optionally specify a custom URL for the OCSP responder. The CRL configuration specifies the CRL expiration period in days (the validity period of the CRL), the Amazon S3 bucket that will contain the CRL, and a CNAME alias for the S3 bucket that is included in certificates issued by the CA. If successful, this action returns the Amazon Resource Name (ARN) of the CA.</p>
    /// <p>ACM Private CA assets that are stored in Amazon S3 can be protected with encryption. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption">Encrypting Your CRLs</a>.</p> <note>
    /// <p>Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies">Access policies for CRLs in Amazon S3</a>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCertificateAuthority {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_certificate_authority_input::Builder,
    }
    impl CreateCertificateAuthority {
        /// Creates a new `CreateCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCertificateAuthorityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500 certificate subject information.</p>
        pub fn certificate_authority_configuration(
            mut self,
            input: crate::model::CertificateAuthorityConfiguration,
        ) -> Self {
            self.inner = self.inner.certificate_authority_configuration(input);
            self
        }
        /// <p>Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500 certificate subject information.</p>
        pub fn set_certificate_authority_configuration(
            mut self,
            input: std::option::Option<crate::model::CertificateAuthorityConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_configuration(input);
            self
        }
        /// <p>Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate revocation list (CRL), to enable both, or to enable neither. The default is for both certificate validation mechanisms to be disabled. For more information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
        pub fn revocation_configuration(
            mut self,
            input: crate::model::RevocationConfiguration,
        ) -> Self {
            self.inner = self.inner.revocation_configuration(input);
            self
        }
        /// <p>Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate revocation list (CRL), to enable both, or to enable neither. The default is for both certificate validation mechanisms to be disabled. For more information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
        pub fn set_revocation_configuration(
            mut self,
            input: std::option::Option<crate::model::RevocationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_revocation_configuration(input);
            self
        }
        /// <p>The type of the certificate authority.</p>
        pub fn certificate_authority_type(
            mut self,
            input: crate::model::CertificateAuthorityType,
        ) -> Self {
            self.inner = self.inner.certificate_authority_type(input);
            self
        }
        /// <p>The type of the certificate authority.</p>
        pub fn set_certificate_authority_type(
            mut self,
            input: std::option::Option<crate::model::CertificateAuthorityType>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_type(input);
            self
        }
        /// <p>Custom string that can be used to distinguish between calls to the <b>CreateCertificateAuthority</b> action. Idempotency tokens for <b>CreateCertificateAuthority</b> time out after five minutes. Therefore, if you call <b>CreateCertificateAuthority</b> multiple times with the same idempotency token within five minutes, ACM Private CA recognizes that you are requesting only certificate authority and will issue only one. If you change the idempotency token for each call, PCA recognizes that you are requesting multiple certificate authorities.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>Custom string that can be used to distinguish between calls to the <b>CreateCertificateAuthority</b> action. Idempotency tokens for <b>CreateCertificateAuthority</b> time out after five minutes. Therefore, if you call <b>CreateCertificateAuthority</b> multiple times with the same idempotency token within five minutes, ACM Private CA recognizes that you are requesting only certificate authority and will issue only one. If you change the idempotency token for each call, PCA recognizes that you are requesting multiple certificate authorities.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// <p>Specifies a cryptographic key management compliance standard used for handling CA keys.</p>
        /// <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p>
        /// <p>Note: <code>FIPS_140_2_LEVEL_3_OR_HIGHER</code> is not supported in Region ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide <code>FIPS_140_2_LEVEL_2_OR_HIGHER</code> as the argument for <code>KeyStorageSecurityStandard</code>. Failure to do this results in an <code>InvalidArgsException</code> with the message, "A certificate authority cannot be created in this region with the specified security standard."</p>
        pub fn key_storage_security_standard(
            mut self,
            input: crate::model::KeyStorageSecurityStandard,
        ) -> Self {
            self.inner = self.inner.key_storage_security_standard(input);
            self
        }
        /// <p>Specifies a cryptographic key management compliance standard used for handling CA keys.</p>
        /// <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p>
        /// <p>Note: <code>FIPS_140_2_LEVEL_3_OR_HIGHER</code> is not supported in Region ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide <code>FIPS_140_2_LEVEL_2_OR_HIGHER</code> as the argument for <code>KeyStorageSecurityStandard</code>. Failure to do this results in an <code>InvalidArgsException</code> with the message, "A certificate authority cannot be created in this region with the specified security standard."</p>
        pub fn set_key_storage_security_standard(
            mut self,
            input: std::option::Option<crate::model::KeyStorageSecurityStandard>,
        ) -> Self {
            self.inner = self.inner.set_key_storage_security_standard(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private CA. For information using tags with IAM to manage permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private CA. For information using tags with IAM to manage permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCertificateAuthorityAuditReport`.
    ///
    /// <p>Creates an audit report that lists every time that your CA private key is used. The report is saved in the Amazon S3 bucket that you specify on input. The <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html">RevokeCertificate</a> actions use the private key. </p> <note>
    /// <p>Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies">Access policies for CRLs in Amazon S3</a>.</p>
    /// </note>
    /// <p>ACM Private CA assets that are stored in Amazon S3 can be protected with encryption. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuditReport.html#audit-report-encryption">Encrypting Your Audit Reports</a>.</p> <note>
    /// <p>You can generate a maximum of one report every 30 minutes.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCertificateAuthorityAuditReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_certificate_authority_audit_report_input::Builder,
    }
    impl CreateCertificateAuthorityAuditReport {
        /// Creates a new `CreateCertificateAuthorityAuditReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCertificateAuthorityAuditReportOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateCertificateAuthorityAuditReportError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:</p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>.</p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:</p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>.</p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// <p>The name of the S3 bucket that will contain the audit report.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_name(input.into());
            self
        }
        /// <p>The name of the S3 bucket that will contain the audit report.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_name(input);
            self
        }
        /// <p>The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.</p>
        pub fn audit_report_response_format(
            mut self,
            input: crate::model::AuditReportResponseFormat,
        ) -> Self {
            self.inner = self.inner.audit_report_response_format(input);
            self
        }
        /// <p>The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.</p>
        pub fn set_audit_report_response_format(
            mut self,
            input: std::option::Option<crate::model::AuditReportResponseFormat>,
        ) -> Self {
            self.inner = self.inner.set_audit_report_response_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePermission`.
    ///
    /// <p>Grants one or more permissions on a private CA to the Certificate Manager (ACM) service principal (<code>acm.amazonaws.com</code>). These permissions allow ACM to issue and renew ACM certificates that reside in the same Amazon Web Services account as the CA.</p>
    /// <p>You can list current permissions with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html">ListPermissions</a> action and revoke them with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html">DeletePermission</a> action.</p>
    /// <p class="title"> <b>About Permissions</b> </p>
    /// <ul>
    /// <li> <p>If the private CA and the certificates it issues reside in the same account, you can use <code>CreatePermission</code> to grant permissions for ACM to carry out automatic certificate renewals.</p> </li>
    /// <li> <p>For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.</p> </li>
    /// <li> <p>If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_permission_input::Builder,
    }
    impl CreatePermission {
        /// Creates a new `CreatePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// <p>The Amazon Web Services service or identity that receives the permission. At this time, the only valid principal is <code>acm.amazonaws.com</code>.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The Amazon Web Services service or identity that receives the permission. At this time, the only valid principal is <code>acm.amazonaws.com</code>.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>The ID of the calling account.</p>
        pub fn source_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_account(input.into());
            self
        }
        /// <p>The ID of the calling account.</p>
        pub fn set_source_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_account(input);
            self
        }
        /// Appends an item to `Actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions that the specified Amazon Web Services service principal can use. These include <code>IssueCertificate</code>, <code>GetCertificate</code>, and <code>ListPermissions</code>.</p>
        pub fn actions(mut self, input: crate::model::ActionType) -> Self {
            self.inner = self.inner.actions(input);
            self
        }
        /// <p>The actions that the specified Amazon Web Services service principal can use. These include <code>IssueCertificate</code>, <code>GetCertificate</code>, and <code>ListPermissions</code>.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionType>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCertificateAuthority`.
    ///
    /// <p>Deletes a private certificate authority (CA). You must provide the Amazon Resource Name (ARN) of the private CA that you want to delete. You can find the ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. </p> <note>
    /// <p>Deleting a CA will invalidate other CAs and certificates below it in your CA hierarchy.</p>
    /// </note>
    /// <p>Before you can delete a CA that you have created and activated, you must disable it. To do this, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> action and set the <b>CertificateAuthorityStatus</b> parameter to <code>DISABLED</code>. </p>
    /// <p>Additionally, you can delete a CA if you are waiting for it to be created (that is, the status of the CA is <code>CREATING</code>). You can also delete it if the CA has been created but you haven't yet imported the signed certificate into ACM Private CA (that is, the status of the CA is <code>PENDING_CERTIFICATE</code>). </p>
    /// <p>When you successfully call <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html">DeleteCertificateAuthority</a>, the CA's status changes to <code>DELETED</code>. However, the CA won't be permanently deleted until the restoration period has passed. By default, if you do not set the <code>PermanentDeletionTimeInDays</code> parameter, the CA remains restorable for 30 days. You can set the parameter from 7 to 30 days. The <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html">DescribeCertificateAuthority</a> action returns the time remaining in the restoration window of a private CA in the <code>DELETED</code> state. To restore an eligible CA, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RestoreCertificateAuthority.html">RestoreCertificateAuthority</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCertificateAuthority {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_certificate_authority_input::Builder,
    }
    impl DeleteCertificateAuthority {
        /// Creates a new `DeleteCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCertificateAuthorityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must have the following form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must have the following form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// <p>The number of days to make a CA restorable after it has been deleted. This can be anywhere from 7 to 30 days, with 30 being the default.</p>
        pub fn permanent_deletion_time_in_days(mut self, input: i32) -> Self {
            self.inner = self.inner.permanent_deletion_time_in_days(input);
            self
        }
        /// <p>The number of days to make a CA restorable after it has been deleted. This can be anywhere from 7 to 30 days, with 30 being the default.</p>
        pub fn set_permanent_deletion_time_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_permanent_deletion_time_in_days(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePermission`.
    ///
    /// <p>Revokes permissions on a private CA granted to the Certificate Manager (ACM) service principal (acm.amazonaws.com). </p>
    /// <p>These permissions allow ACM to issue and renew ACM certificates that reside in the same Amazon Web Services account as the CA. If you revoke these permissions, ACM will no longer renew the affected certificates automatically.</p>
    /// <p>Permissions can be granted with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html">CreatePermission</a> action and listed with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html">ListPermissions</a> action. </p>
    /// <p class="title"> <b>About Permissions</b> </p>
    /// <ul>
    /// <li> <p>If the private CA and the certificates it issues reside in the same account, you can use <code>CreatePermission</code> to grant permissions for ACM to carry out automatic certificate renewals.</p> </li>
    /// <li> <p>For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.</p> </li>
    /// <li> <p>If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_permission_input::Builder,
    }
    impl DeletePermission {
        /// Creates a new `DeletePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA that issued the permissions. You can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA that issued the permissions. You can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// <p>The Amazon Web Services service or identity that will have its CA permissions revoked. At this time, the only valid service principal is <code>acm.amazonaws.com</code> </p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The Amazon Web Services service or identity that will have its CA permissions revoked. At this time, the only valid service principal is <code>acm.amazonaws.com</code> </p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>The Amazon Web Services account that calls this action.</p>
        pub fn source_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_account(input.into());
            self
        }
        /// <p>The Amazon Web Services account that calls this action.</p>
        pub fn set_source_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_account(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePolicy`.
    ///
    /// <p>Deletes the resource-based policy attached to a private CA. Deletion will remove any access that the policy has granted. If there is no policy attached to the private CA, this action will return successful.</p>
    /// <p>If you delete a policy that was applied through Amazon Web Services Resource Access Manager (RAM), the CA will be removed from all shares in which it was included. </p>
    /// <p>The Certificate Manager Service Linked Role that the policy supports is not affected when you delete the policy. </p>
    /// <p>The current policy can be shown with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html">GetPolicy</a> and updated with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html">PutPolicy</a>.</p>
    /// <p class="title"> <b>About Policies</b> </p>
    /// <ul>
    /// <li> <p>A policy grants access on a private CA to an Amazon Web Services customer account, to Amazon Web Services Organizations, or to an Amazon Web Services Organizations unit. Policies are under the control of a CA administrator. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA</a>.</p> </li>
    /// <li> <p>A policy permits a user of Certificate Manager (ACM) to issue ACM certificates signed by a CA in another account.</p> </li>
    /// <li> <p>For ACM to manage automatic renewal of these certificates, the ACM user must configure a Service Linked Role (SLR). The SLR allows the ACM service to assume the identity of the user, subject to confirmation against the ACM Private CA policy. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html">Using a Service Linked Role with ACM</a>.</p> </li>
    /// <li> <p>Updates made in Amazon Web Services Resource Manager (RAM) are reflected in policies. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account Access</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_policy_input::Builder,
    }
    impl DeletePolicy {
        /// Creates a new `DeletePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA that will have its policy deleted. You can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. The ARN value must have the form <code>arn:aws:acm-pca:region:account:certificate-authority/01234567-89ab-cdef-0123-0123456789ab</code>. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA that will have its policy deleted. You can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. The ARN value must have the form <code>arn:aws:acm-pca:region:account:certificate-authority/01234567-89ab-cdef-0123-0123456789ab</code>. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCertificateAuthority`.
    ///
    /// <p>Lists information about your private certificate authority (CA) or one that has been shared with you. You specify the private CA on input by its ARN (Amazon Resource Name). The output contains the status of your CA. This can be any of the following: </p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - ACM Private CA is creating your private certificate authority.</p> </li>
    /// <li> <p> <code>PENDING_CERTIFICATE</code> - The certificate is pending. You must use your ACM Private CA-hosted or on-premises root or subordinate CA to sign your private CA CSR and then import it into PCA. </p> </li>
    /// <li> <p> <code>ACTIVE</code> - Your private CA is active.</p> </li>
    /// <li> <p> <code>DISABLED</code> - Your private CA has been disabled.</p> </li>
    /// <li> <p> <code>EXPIRED</code> - Your private CA certificate has expired.</p> </li>
    /// <li> <p> <code>FAILED</code> - Your private CA has failed. Your CA can fail because of problems such a network outage or back-end Amazon Web Services failure or other errors. A failed CA can never return to the pending state. You must create a new CA. </p> </li>
    /// <li> <p> <code>DELETED</code> - Your private CA is within the restoration period, after which it is permanently deleted. The length of time remaining in the CA's restoration period is also included in this action's output.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCertificateAuthority {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_certificate_authority_input::Builder,
    }
    impl DescribeCertificateAuthority {
        /// Creates a new `DescribeCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCertificateAuthorityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCertificateAuthorityAuditReport`.
    ///
    /// <p>Lists information about a specific audit report created by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a> action. Audit information is created every time the certificate authority (CA) private key is used. The private key is used when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate</a> action or the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html">RevokeCertificate</a> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCertificateAuthorityAuditReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_certificate_authority_audit_report_input::Builder,
    }
    impl DescribeCertificateAuthorityAuditReport {
        /// Creates a new `DescribeCertificateAuthorityAuditReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCertificateAuthorityAuditReportOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeCertificateAuthorityAuditReportError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the private CA. This must be of the form:</p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the private CA. This must be of the form:</p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// <p>The report ID returned by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a> action.</p>
        pub fn audit_report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_report_id(input.into());
            self
        }
        /// <p>The report ID returned by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a> action.</p>
        pub fn set_audit_report_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_report_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCertificate`.
    ///
    /// <p>Retrieves a certificate from your private CA or one that has been shared with you. The ARN of the certificate is returned when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate</a> action. You must specify both the ARN of your private CA and the ARN of the issued certificate when calling the <b>GetCertificate</b> action. You can retrieve the certificate if it is in the <b>ISSUED</b> state. You can call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a> action to create a report that contains information about all of the certificates issued and revoked by your private CA. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCertificate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_certificate_input::Builder,
    }
    impl GetCertificate {
        /// Creates a new `GetCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCertificateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// <p>The ARN of the issued certificate. The ARN contains the certificate serial number and must be in the following form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> </code> </p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(input.into());
            self
        }
        /// <p>The ARN of the issued certificate. The ARN contains the certificate serial number and must be in the following form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> </code> </p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCertificateAuthorityCertificate`.
    ///
    /// <p>Retrieves the certificate and certificate chain for your private certificate authority (CA) or one that has been shared with you. Both the certificate and the chain are base64 PEM-encoded. The chain does not include the CA certificate. Each certificate in the chain signs the one before it. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCertificateAuthorityCertificate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_certificate_authority_certificate_input::Builder,
    }
    impl GetCertificateAuthorityCertificate {
        /// Creates a new `GetCertificateAuthorityCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCertificateAuthorityCertificateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetCertificateAuthorityCertificateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of your private CA. This is of the form:</p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of your private CA. This is of the form:</p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCertificateAuthorityCsr`.
    ///
    /// <p>Retrieves the certificate signing request (CSR) for your private certificate authority (CA). The CSR is created when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. Sign the CSR with your ACM Private CA-hosted or on-premises root or subordinate CA. Then import the signed certificate back into ACM Private CA by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html">ImportCertificateAuthorityCertificate</a> action. The CSR is returned as a base64 PEM-encoded string. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCertificateAuthorityCsr {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_certificate_authority_csr_input::Builder,
    }
    impl GetCertificateAuthorityCsr {
        /// Creates a new `GetCertificateAuthorityCsr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCertificateAuthorityCsrOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCertificateAuthorityCsrError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPolicy`.
    ///
    /// <p>Retrieves the resource-based policy attached to a private CA. If either the private CA resource or the policy cannot be found, this action returns a <code>ResourceNotFoundException</code>. </p>
    /// <p>The policy can be attached or updated with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html">PutPolicy</a> and removed with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html">DeletePolicy</a>.</p>
    /// <p class="title"> <b>About Policies</b> </p>
    /// <ul>
    /// <li> <p>A policy grants access on a private CA to an Amazon Web Services customer account, to Amazon Web Services Organizations, or to an Amazon Web Services Organizations unit. Policies are under the control of a CA administrator. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA</a>.</p> </li>
    /// <li> <p>A policy permits a user of Certificate Manager (ACM) to issue ACM certificates signed by a CA in another account.</p> </li>
    /// <li> <p>For ACM to manage automatic renewal of these certificates, the ACM user must configure a Service Linked Role (SLR). The SLR allows the ACM service to assume the identity of the user, subject to confirmation against the ACM Private CA policy. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html">Using a Service Linked Role with ACM</a>.</p> </li>
    /// <li> <p>Updates made in Amazon Web Services Resource Manager (RAM) are reflected in policies. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account Access</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_policy_input::Builder,
    }
    impl GetPolicy {
        /// Creates a new `GetPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA that will have its policy retrieved. You can find the CA's ARN by calling the ListCertificateAuthorities action. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA that will have its policy retrieved. You can find the CA's ARN by calling the ListCertificateAuthorities action. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportCertificateAuthorityCertificate`.
    ///
    /// <p>Imports a signed private CA certificate into ACM Private CA. This action is used when you are using a chain of trust whose root is located outside ACM Private CA. Before you can call this action, the following preparations must in place:</p>
    /// <ol>
    /// <li> <p>In ACM Private CA, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action to create the private CA that you plan to back with the imported certificate.</p> </li>
    /// <li> <p>Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCsr.html">GetCertificateAuthorityCsr</a> action to generate a certificate signing request (CSR).</p> </li>
    /// <li> <p>Sign the CSR using a root or intermediate CA hosted by either an on-premises PKI hierarchy or by a commercial CA.</p> </li>
    /// <li> <p>Create a certificate chain and copy the signed certificate and the certificate chain to your working directory.</p> </li>
    /// </ol>
    /// <p>ACM Private CA supports three scenarios for installing a CA certificate:</p>
    /// <ul>
    /// <li> <p>Installing a certificate for a root CA hosted by ACM Private CA.</p> </li>
    /// <li> <p>Installing a subordinate CA certificate whose parent authority is hosted by ACM Private CA.</p> </li>
    /// <li> <p>Installing a subordinate CA certificate whose parent authority is externally hosted.</p> </li>
    /// </ul>
    /// <p>The following additional requirements apply when you import a CA certificate.</p>
    /// <ul>
    /// <li> <p>Only a self-signed certificate can be imported as a root CA.</p> </li>
    /// <li> <p>A self-signed certificate cannot be imported as a subordinate CA.</p> </li>
    /// <li> <p>Your certificate chain must not include the private CA certificate that you are importing.</p> </li>
    /// <li> <p>Your root CA must be the last certificate in your chain. The subordinate certificate, if any, that your root CA signed must be next to last. The subordinate certificate signed by the preceding subordinate CA must come next, and so on until your chain is built. </p> </li>
    /// <li> <p>The chain must be PEM-encoded.</p> </li>
    /// <li> <p>The maximum allowed size of a certificate is 32 KB.</p> </li>
    /// <li> <p>The maximum allowed size of a certificate chain is 2 MB.</p> </li>
    /// </ul>
    /// <p> <i>Enforcement of Critical Constraints</i> </p>
    /// <p>ACM Private CA allows the following extensions to be marked critical in the imported CA certificate or chain.</p>
    /// <ul>
    /// <li> <p>Basic constraints (<i>must</i> be marked critical)</p> </li>
    /// <li> <p>Subject alternative names</p> </li>
    /// <li> <p>Key usage</p> </li>
    /// <li> <p>Extended key usage</p> </li>
    /// <li> <p>Authority key identifier</p> </li>
    /// <li> <p>Subject key identifier</p> </li>
    /// <li> <p>Issuer alternative name</p> </li>
    /// <li> <p>Subject directory attributes</p> </li>
    /// <li> <p>Subject information access</p> </li>
    /// <li> <p>Certificate policies</p> </li>
    /// <li> <p>Policy mappings</p> </li>
    /// <li> <p>Inhibit anyPolicy</p> </li>
    /// </ul>
    /// <p>ACM Private CA rejects the following extensions when they are marked critical in an imported CA certificate or chain.</p>
    /// <ul>
    /// <li> <p>Name constraints</p> </li>
    /// <li> <p>Policy constraints</p> </li>
    /// <li> <p>CRL distribution points</p> </li>
    /// <li> <p>Authority information access</p> </li>
    /// <li> <p>Freshest CRL</p> </li>
    /// <li> <p>Any other extension</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportCertificateAuthorityCertificate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_certificate_authority_certificate_input::Builder,
    }
    impl ImportCertificateAuthorityCertificate {
        /// Creates a new `ImportCertificateAuthorityCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportCertificateAuthorityCertificateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ImportCertificateAuthorityCertificateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// <p>The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a root CA, or it may be signed by another CA that you control.</p>
        pub fn certificate(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.certificate(input);
            self
        }
        /// <p>The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a root CA, or it may be signed by another CA that you control.</p>
        pub fn set_certificate(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_certificate(input);
            self
        }
        /// <p>A PEM-encoded file that contains all of your certificates, other than the certificate you're importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root certificate is the last in the chain, and each certificate in the chain signs the one preceding. </p>
        /// <p>This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is no chain.</p>
        pub fn certificate_chain(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.certificate_chain(input);
            self
        }
        /// <p>A PEM-encoded file that contains all of your certificates, other than the certificate you're importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root certificate is the last in the chain, and each certificate in the chain signs the one preceding. </p>
        /// <p>This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is no chain.</p>
        pub fn set_certificate_chain(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_certificate_chain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `IssueCertificate`.
    ///
    /// <p>Uses your private certificate authority (CA), or one that has been shared with you, to issue a client certificate. This action returns the Amazon Resource Name (ARN) of the certificate. You can retrieve the certificate by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate</a> action and specifying the ARN. </p> <note>
    /// <p>You cannot use the ACM <b>ListCertificateAuthorities</b> action to retrieve the ARNs of the certificates that you issue by using ACM Private CA.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct IssueCertificate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::issue_certificate_input::Builder,
    }
    impl IssueCertificate {
        /// Creates a new `IssueCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::IssueCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::IssueCertificateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies X.509 certificate information to be included in the issued certificate. An <code>APIPassthrough</code> or <code>APICSRPassthrough</code> template variant must be selected, or else this parameter is ignored. For more information about using these templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate Templates</a>.</p>
        /// <p>If conflicting or duplicate certificate information is supplied during certificate issuance, ACM Private CA applies <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">order of operation rules</a> to determine what information is used.</p>
        pub fn api_passthrough(mut self, input: crate::model::ApiPassthrough) -> Self {
            self.inner = self.inner.api_passthrough(input);
            self
        }
        /// <p>Specifies X.509 certificate information to be included in the issued certificate. An <code>APIPassthrough</code> or <code>APICSRPassthrough</code> template variant must be selected, or else this parameter is ignored. For more information about using these templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate Templates</a>.</p>
        /// <p>If conflicting or duplicate certificate information is supplied during certificate issuance, ACM Private CA applies <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">order of operation rules</a> to determine what information is used.</p>
        pub fn set_api_passthrough(
            mut self,
            input: std::option::Option<crate::model::ApiPassthrough>,
        ) -> Self {
            self.inner = self.inner.set_api_passthrough(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form:</p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form:</p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// <p>The certificate signing request (CSR) for the certificate you want to issue. As an example, you can use the following OpenSSL command to create the CSR and a 2048 bit RSA private key. </p>
        /// <p> <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code> </p>
        /// <p>If you have a configuration file, you can then use the following OpenSSL command. The <code>usr_cert</code> block in the configuration file contains your X509 version 3 extensions. </p>
        /// <p> <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code> </p>
        /// <p>Note: A CSR must provide either a <i>subject name</i> or a <i>subject alternative name</i> or the request will be rejected. </p>
        pub fn csr(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.csr(input);
            self
        }
        /// <p>The certificate signing request (CSR) for the certificate you want to issue. As an example, you can use the following OpenSSL command to create the CSR and a 2048 bit RSA private key. </p>
        /// <p> <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code> </p>
        /// <p>If you have a configuration file, you can then use the following OpenSSL command. The <code>usr_cert</code> block in the configuration file contains your X509 version 3 extensions. </p>
        /// <p> <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code> </p>
        /// <p>Note: A CSR must provide either a <i>subject name</i> or a <i>subject alternative name</i> or the request will be rejected. </p>
        pub fn set_csr(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_csr(input);
            self
        }
        /// <p>The name of the algorithm that will be used to sign the certificate to be issued. </p>
        /// <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign a CSR in the <code>CreateCertificateAuthority</code> action.</p> <note>
        /// <p>The specified signing algorithm family (RSA or ECDSA) much match the algorithm family of the CA's secret key.</p>
        /// </note>
        pub fn signing_algorithm(mut self, input: crate::model::SigningAlgorithm) -> Self {
            self.inner = self.inner.signing_algorithm(input);
            self
        }
        /// <p>The name of the algorithm that will be used to sign the certificate to be issued. </p>
        /// <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign a CSR in the <code>CreateCertificateAuthority</code> action.</p> <note>
        /// <p>The specified signing algorithm family (RSA or ECDSA) much match the algorithm family of the CA's secret key.</p>
        /// </note>
        pub fn set_signing_algorithm(
            mut self,
            input: std::option::Option<crate::model::SigningAlgorithm>,
        ) -> Self {
            self.inner = self.inner.set_signing_algorithm(input);
            self
        }
        /// <p>Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template. For CA certificates, you should choose the shortest path length that meets your needs. The path length is indicated by the PathLen<i>N</i> portion of the ARN, where <i>N</i> is the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaTerms.html#terms-cadepth">CA depth</a>.</p>
        /// <p>Note: The CA depth configured on a subordinate CA certificate must not exceed the limit set by its parents in the CA hierarchy.</p>
        /// <p>For a list of <code>TemplateArn</code> values supported by ACM Private CA, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate Templates</a>.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_arn(input.into());
            self
        }
        /// <p>Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template. For CA certificates, you should choose the shortest path length that meets your needs. The path length is indicated by the PathLen<i>N</i> portion of the ARN, where <i>N</i> is the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaTerms.html#terms-cadepth">CA depth</a>.</p>
        /// <p>Note: The CA depth configured on a subordinate CA certificate must not exceed the limit set by its parents in the CA hierarchy.</p>
        /// <p>For a list of <code>TemplateArn</code> values supported by ACM Private CA, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate Templates</a>.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_arn(input);
            self
        }
        /// <p>Information describing the end of the validity period of the certificate. This parameter sets the “Not After” date for the certificate.</p>
        /// <p>Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see <a href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280. </p>
        /// <p>This value is unaffected when <code>ValidityNotBefore</code> is also specified. For example, if <code>Validity</code> is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the <code>ValidityNotBefore</code> value.</p>
        /// <p>The end of the validity period configured on a certificate must not exceed the limit set on its parents in the CA hierarchy.</p>
        pub fn validity(mut self, input: crate::model::Validity) -> Self {
            self.inner = self.inner.validity(input);
            self
        }
        /// <p>Information describing the end of the validity period of the certificate. This parameter sets the “Not After” date for the certificate.</p>
        /// <p>Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see <a href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280. </p>
        /// <p>This value is unaffected when <code>ValidityNotBefore</code> is also specified. For example, if <code>Validity</code> is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the <code>ValidityNotBefore</code> value.</p>
        /// <p>The end of the validity period configured on a certificate must not exceed the limit set on its parents in the CA hierarchy.</p>
        pub fn set_validity(mut self, input: std::option::Option<crate::model::Validity>) -> Self {
            self.inner = self.inner.set_validity(input);
            self
        }
        /// <p>Information describing the start of the validity period of the certificate. This parameter sets the “Not Before" date for the certificate.</p>
        /// <p>By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize the “Not Before” value. </p>
        /// <p>Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code> parameter is optional.</p>
        /// <p>The <code>ValidityNotBefore</code> value is expressed as an explicit date and time, using the <code>Validity</code> type value <code>ABSOLUTE</code>. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_Validity.html">Validity</a> in this API reference and <a href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280.</p>
        pub fn validity_not_before(mut self, input: crate::model::Validity) -> Self {
            self.inner = self.inner.validity_not_before(input);
            self
        }
        /// <p>Information describing the start of the validity period of the certificate. This parameter sets the “Not Before" date for the certificate.</p>
        /// <p>By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize the “Not Before” value. </p>
        /// <p>Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code> parameter is optional.</p>
        /// <p>The <code>ValidityNotBefore</code> value is expressed as an explicit date and time, using the <code>Validity</code> type value <code>ABSOLUTE</code>. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_Validity.html">Validity</a> in this API reference and <a href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280.</p>
        pub fn set_validity_not_before(
            mut self,
            input: std::option::Option<crate::model::Validity>,
        ) -> Self {
            self.inner = self.inner.set_validity_not_before(input);
            self
        }
        /// <p>Alphanumeric string that can be used to distinguish between calls to the <b>IssueCertificate</b> action. Idempotency tokens for <b>IssueCertificate</b> time out after one minute. Therefore, if you call <b>IssueCertificate</b> multiple times with the same idempotency token within one minute, ACM Private CA recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, PCA recognizes that you are requesting multiple certificates.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>Alphanumeric string that can be used to distinguish between calls to the <b>IssueCertificate</b> action. Idempotency tokens for <b>IssueCertificate</b> time out after one minute. Therefore, if you call <b>IssueCertificate</b> multiple times with the same idempotency token within one minute, ACM Private CA recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, PCA recognizes that you are requesting multiple certificates.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCertificateAuthorities`.
    ///
    /// <p>Lists the private certificate authorities that you created by using the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCertificateAuthorities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_certificate_authorities_input::Builder,
    }
    impl ListCertificateAuthorities {
        /// Creates a new `ListCertificateAuthorities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCertificateAuthoritiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCertificateAuthoritiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCertificateAuthoritiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCertificateAuthoritiesPaginator {
            crate::paginator::ListCertificateAuthoritiesPaginator::new(self.handle, self.inner)
        }
        /// <p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Use this parameter when paginating results to specify the maximum number of items to return in the response on each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Use this parameter when paginating results to specify the maximum number of items to return in the response on each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Use this parameter to filter the returned set of certificate authorities based on their owner. The default is SELF.</p>
        pub fn resource_owner(mut self, input: crate::model::ResourceOwner) -> Self {
            self.inner = self.inner.resource_owner(input);
            self
        }
        /// <p>Use this parameter to filter the returned set of certificate authorities based on their owner. The default is SELF.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<crate::model::ResourceOwner>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissions`.
    ///
    /// <p>List all permissions on a private CA, if any, granted to the Certificate Manager (ACM) service principal (acm.amazonaws.com). </p>
    /// <p>These permissions allow ACM to issue and renew ACM certificates that reside in the same Amazon Web Services account as the CA. </p>
    /// <p>Permissions can be granted with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html">CreatePermission</a> action and revoked with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html">DeletePermission</a> action.</p>
    /// <p class="title"> <b>About Permissions</b> </p>
    /// <ul>
    /// <li> <p>If the private CA and the certificates it issues reside in the same account, you can use <code>CreatePermission</code> to grant permissions for ACM to carry out automatic certificate renewals.</p> </li>
    /// <li> <p>For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.</p> </li>
    /// <li> <p>If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_permissions_input::Builder,
    }
    impl ListPermissions {
        /// Creates a new `ListPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPermissionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPermissionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPermissionsPaginator {
            crate::paginator::ListPermissionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must be of the form: <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> You can get a private CA's ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must be of the form: <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> You can get a private CA's ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// <p>When paginating results, use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When paginating results, use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>When paginating results, use this parameter to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <b>NextToken</b> element is sent in the response. Use this <b>NextToken</b> value in a subsequent request to retrieve additional items.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>When paginating results, use this parameter to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <b>NextToken</b> element is sent in the response. Use this <b>NextToken</b> value in a subsequent request to retrieve additional items.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Lists the tags, if any, that are associated with your private CA or one that has been shared with you. Tags are labels that you can use to identify and organize your CAs. Each tag consists of a key and an optional value. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html">TagCertificateAuthority</a> action to add one or more tags to your CA. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html">UntagCertificateAuthority</a> action to remove tags. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl ListTags {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsPaginator {
            crate::paginator::ListTagsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// <p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Use this parameter when paginating results to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <b>NextToken</b> element is sent in the response. Use this <b>NextToken</b> value in a subsequent request to retrieve additional items.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Use this parameter when paginating results to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <b>NextToken</b> element is sent in the response. Use this <b>NextToken</b> value in a subsequent request to retrieve additional items.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPolicy`.
    ///
    /// <p>Attaches a resource-based policy to a private CA. </p>
    /// <p>A policy can also be applied by sharing a private CA through Amazon Web Services Resource Access Manager (RAM). For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account Access</a>.</p>
    /// <p>The policy can be displayed with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html">GetPolicy</a> and removed with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html">DeletePolicy</a>.</p>
    /// <p class="title"> <b>About Policies</b> </p>
    /// <ul>
    /// <li> <p>A policy grants access on a private CA to an Amazon Web Services customer account, to Amazon Web Services Organizations, or to an Amazon Web Services Organizations unit. Policies are under the control of a CA administrator. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA</a>.</p> </li>
    /// <li> <p>A policy permits a user of Certificate Manager (ACM) to issue ACM certificates signed by a CA in another account.</p> </li>
    /// <li> <p>For ACM to manage automatic renewal of these certificates, the ACM user must configure a Service Linked Role (SLR). The SLR allows the ACM service to assume the identity of the user, subject to confirmation against the ACM Private CA policy. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html">Using a Service Linked Role with ACM</a>.</p> </li>
    /// <li> <p>Updates made in Amazon Web Services Resource Manager (RAM) are reflected in policies. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account Access</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_policy_input::Builder,
    }
    impl PutPolicy {
        /// Creates a new `PutPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA to associate with the policy. The ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
        /// <p></p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA to associate with the policy. The ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
        /// <p></p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The path and file name of a JSON-formatted IAM policy to attach to the specified private CA resource. If this policy does not contain all required statements or if it includes any statement that is not allowed, the <code>PutPolicy</code> action returns an <code>InvalidPolicyException</code>. For information about IAM policy and statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The path and file name of a JSON-formatted IAM policy to attach to the specified private CA resource. If this policy does not contain all required statements or if it includes any statement that is not allowed, the <code>PutPolicy</code> action returns an <code>InvalidPolicyException</code>. For information about IAM policy and statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreCertificateAuthority`.
    ///
    /// <p>Restores a certificate authority (CA) that is in the <code>DELETED</code> state. You can restore a CA during the period that you defined in the <b>PermanentDeletionTimeInDays</b> parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html">DeleteCertificateAuthority</a> action. Currently, you can specify 7 to 30 days. If you did not specify a <b>PermanentDeletionTimeInDays</b> value, by default you can restore the CA at any time in a 30 day period. You can check the time remaining in the restoration period of a private CA in the <code>DELETED</code> state by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html">DescribeCertificateAuthority</a> or <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> actions. The status of a restored CA is set to its pre-deletion status when the <b>RestoreCertificateAuthority</b> action returns. To change its status to <code>ACTIVE</code>, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> action. If the private CA was in the <code>PENDING_CERTIFICATE</code> state at deletion, you must use the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html">ImportCertificateAuthorityCertificate</a> action to import a certificate authority into the private CA before it can be activated. You cannot restore a CA after the restoration period has ended.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreCertificateAuthority {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restore_certificate_authority_input::Builder,
    }
    impl RestoreCertificateAuthority {
        /// Creates a new `RestoreCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreCertificateAuthorityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeCertificate`.
    ///
    /// <p>Revokes a certificate that was issued inside ACM Private CA. If you enable a certificate revocation list (CRL) when you create or update your private CA, information about the revoked certificates will be included in the CRL. ACM Private CA writes the CRL to an S3 bucket that you specify. A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason the CRL update fails, ACM Private CA attempts makes further attempts every 15 minutes. With Amazon CloudWatch, you can create alarms for the metrics <code>CRLGenerated</code> and <code>MisconfiguredCRLBucket</code>. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCloudWatch.html">Supported CloudWatch Metrics</a>.</p> <note>
    /// <p>Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies">Access policies for CRLs in Amazon S3</a>.</p>
    /// </note>
    /// <p>ACM Private CA also writes revocation information to the audit report. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a>.</p> <note>
    /// <p>You cannot revoke a root CA self-signed certificate.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RevokeCertificate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::revoke_certificate_input::Builder,
    }
    impl RevokeCertificate {
        /// Creates a new `RevokeCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeCertificateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:</p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:</p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// <p>Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve the serial number by calling <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate</a> with the Amazon Resource Name (ARN) of the certificate you want and the ARN of your private CA. The <b>GetCertificate</b> action retrieves the certificate in the PEM format. You can use the following OpenSSL command to list the certificate in text format and copy the hexadecimal serial number. </p>
        /// <p> <code>openssl x509 -in <i>file_path</i> -text -noout</code> </p>
        /// <p>You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate</a> action in the <i>Certificate Manager API Reference</i>. </p>
        pub fn certificate_serial(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_serial(input.into());
            self
        }
        /// <p>Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve the serial number by calling <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate</a> with the Amazon Resource Name (ARN) of the certificate you want and the ARN of your private CA. The <b>GetCertificate</b> action retrieves the certificate in the PEM format. You can use the following OpenSSL command to list the certificate in text format and copy the hexadecimal serial number. </p>
        /// <p> <code>openssl x509 -in <i>file_path</i> -text -noout</code> </p>
        /// <p>You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate</a> action in the <i>Certificate Manager API Reference</i>. </p>
        pub fn set_certificate_serial(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_serial(input);
            self
        }
        /// <p>Specifies why you revoked the certificate.</p>
        pub fn revocation_reason(mut self, input: crate::model::RevocationReason) -> Self {
            self.inner = self.inner.revocation_reason(input);
            self
        }
        /// <p>Specifies why you revoked the certificate.</p>
        pub fn set_revocation_reason(
            mut self,
            input: std::option::Option<crate::model::RevocationReason>,
        ) -> Self {
            self.inner = self.inner.set_revocation_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagCertificateAuthority`.
    ///
    /// <p>Adds one or more tags to your private CA. Tags are labels that you can use to identify and organize your Amazon Web Services resources. Each tag consists of a key and an optional value. You specify the private CA on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair. You can apply a tag to just one private CA if you want to identify a specific characteristic of that CA, or you can apply the same tag to multiple private CAs if you want to filter for a common relationship among those CAs. To remove one or more tags, use the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html">UntagCertificateAuthority</a> action. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html">ListTags</a> action to see what tags are associated with your CA. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagCertificateAuthority {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_certificate_authority_input::Builder,
    }
    impl TagCertificateAuthority {
        /// Creates a new `TagCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<crate::error::TagCertificateAuthorityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>List of tags to be associated with the CA.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>List of tags to be associated with the CA.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagCertificateAuthority`.
    ///
    /// <p>Remove one or more tags from your private CA. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this action, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value. To add tags to a private CA, use the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html">TagCertificateAuthority</a>. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html">ListTags</a> action to see what tags are associated with your CA. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagCertificateAuthority {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_certificate_authority_input::Builder,
    }
    impl UntagCertificateAuthority {
        /// Creates a new `UntagCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagCertificateAuthorityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>List of tags to be removed from the CA.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>List of tags to be removed from the CA.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCertificateAuthority`.
    ///
    /// <p>Updates the status or configuration of a private certificate authority (CA). Your private CA must be in the <code>ACTIVE</code> or <code>DISABLED</code> state before you can update it. You can disable a private CA that is in the <code>ACTIVE</code> state or make a CA that is in the <code>DISABLED</code> state active again.</p> <note>
    /// <p>Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies">Access policies for CRLs in Amazon S3</a>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCertificateAuthority {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_certificate_authority_input::Builder,
    }
    impl UpdateCertificateAuthority {
        /// Creates a new `UpdateCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCertificateAuthorityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:</p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:</p>
        /// <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_arn(input);
            self
        }
        /// <p>Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate revocation list (CRL), to enable both, or to enable neither. If this parameter is not supplied, existing capibilites remain unchanged. For more information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
        pub fn revocation_configuration(
            mut self,
            input: crate::model::RevocationConfiguration,
        ) -> Self {
            self.inner = self.inner.revocation_configuration(input);
            self
        }
        /// <p>Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate revocation list (CRL), to enable both, or to enable neither. If this parameter is not supplied, existing capibilites remain unchanged. For more information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
        pub fn set_revocation_configuration(
            mut self,
            input: std::option::Option<crate::model::RevocationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_revocation_configuration(input);
            self
        }
        /// <p>Status of your private CA.</p>
        pub fn status(mut self, input: crate::model::CertificateAuthorityStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Status of your private CA.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CertificateAuthorityStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
