// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCertificateAuthorityError {
    /// Kind of error that occurred.
    pub kind: CreateCertificateAuthorityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCertificateAuthorityErrorKind {
    /// <p>One or more of the specified arguments was not valid.</p>
    InvalidArgsException(crate::error::InvalidArgsException),
    /// <p>The resource policy is invalid or is missing a required statement. For general information about IAM policy and statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>
    InvalidPolicyException(crate::error::InvalidPolicyException),
    /// <p>The tag associated with the CA is not valid. The invalid argument is contained in the message field.</p>
    InvalidTagException(crate::error::InvalidTagException),
    /// <p>An ACM Private CA quota has been exceeded. See the exception message returned to determine the quota that was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCertificateAuthorityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCertificateAuthorityErrorKind::InvalidArgsException(_inner) => _inner.fmt(f),
            CreateCertificateAuthorityErrorKind::InvalidPolicyException(_inner) => _inner.fmt(f),
            CreateCertificateAuthorityErrorKind::InvalidTagException(_inner) => _inner.fmt(f),
            CreateCertificateAuthorityErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateCertificateAuthorityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCertificateAuthorityError {
    fn code(&self) -> Option<&str> {
        CreateCertificateAuthorityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCertificateAuthorityError {
    /// Creates a new `CreateCertificateAuthorityError`.
    pub fn new(kind: CreateCertificateAuthorityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCertificateAuthorityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCertificateAuthorityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCertificateAuthorityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCertificateAuthorityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCertificateAuthorityErrorKind::InvalidArgsException`.
    pub fn is_invalid_args_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateAuthorityErrorKind::InvalidArgsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateAuthorityErrorKind::InvalidPolicyException`.
    pub fn is_invalid_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateAuthorityErrorKind::InvalidPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateAuthorityErrorKind::InvalidTagException`.
    pub fn is_invalid_tag_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateAuthorityErrorKind::InvalidTagException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateAuthorityErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateAuthorityErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateCertificateAuthorityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCertificateAuthorityErrorKind::InvalidArgsException(_inner) => Some(_inner),
            CreateCertificateAuthorityErrorKind::InvalidPolicyException(_inner) => Some(_inner),
            CreateCertificateAuthorityErrorKind::InvalidTagException(_inner) => Some(_inner),
            CreateCertificateAuthorityErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateCertificateAuthorityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCertificateAuthorityAuditReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCertificateAuthorityAuditReportError {
    /// Kind of error that occurred.
    pub kind: CreateCertificateAuthorityAuditReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCertificateAuthorityAuditReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCertificateAuthorityAuditReportErrorKind {
    /// <p>One or more of the specified arguments was not valid.</p>
    InvalidArgsException(crate::error::InvalidArgsException),
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The request has failed for an unspecified reason.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>Your request is already in progress.</p>
    RequestInProgressException(crate::error::RequestInProgressException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCertificateAuthorityAuditReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCertificateAuthorityAuditReportErrorKind::InvalidArgsException(_inner) => {
                _inner.fmt(f)
            }
            CreateCertificateAuthorityAuditReportErrorKind::InvalidArnException(_inner) => {
                _inner.fmt(f)
            }
            CreateCertificateAuthorityAuditReportErrorKind::InvalidStateException(_inner) => {
                _inner.fmt(f)
            }
            CreateCertificateAuthorityAuditReportErrorKind::RequestFailedException(_inner) => {
                _inner.fmt(f)
            }
            CreateCertificateAuthorityAuditReportErrorKind::RequestInProgressException(_inner) => {
                _inner.fmt(f)
            }
            CreateCertificateAuthorityAuditReportErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateCertificateAuthorityAuditReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCertificateAuthorityAuditReportError {
    fn code(&self) -> Option<&str> {
        CreateCertificateAuthorityAuditReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCertificateAuthorityAuditReportError {
    /// Creates a new `CreateCertificateAuthorityAuditReportError`.
    pub fn new(
        kind: CreateCertificateAuthorityAuditReportErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCertificateAuthorityAuditReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCertificateAuthorityAuditReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCertificateAuthorityAuditReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCertificateAuthorityAuditReportErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCertificateAuthorityAuditReportErrorKind::InvalidArgsException`.
    pub fn is_invalid_args_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateAuthorityAuditReportErrorKind::InvalidArgsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateAuthorityAuditReportErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateAuthorityAuditReportErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateAuthorityAuditReportErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateAuthorityAuditReportErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateAuthorityAuditReportErrorKind::RequestFailedException`.
    pub fn is_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateAuthorityAuditReportErrorKind::RequestFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateAuthorityAuditReportErrorKind::RequestInProgressException`.
    pub fn is_request_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateAuthorityAuditReportErrorKind::RequestInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateAuthorityAuditReportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateAuthorityAuditReportErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateCertificateAuthorityAuditReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCertificateAuthorityAuditReportErrorKind::InvalidArgsException(_inner) => {
                Some(_inner)
            }
            CreateCertificateAuthorityAuditReportErrorKind::InvalidArnException(_inner) => {
                Some(_inner)
            }
            CreateCertificateAuthorityAuditReportErrorKind::InvalidStateException(_inner) => {
                Some(_inner)
            }
            CreateCertificateAuthorityAuditReportErrorKind::RequestFailedException(_inner) => {
                Some(_inner)
            }
            CreateCertificateAuthorityAuditReportErrorKind::RequestInProgressException(_inner) => {
                Some(_inner)
            }
            CreateCertificateAuthorityAuditReportErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateCertificateAuthorityAuditReportErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreatePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePermissionError {
    /// Kind of error that occurred.
    pub kind: CreatePermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePermissionErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>An ACM Private CA quota has been exceeded. See the exception message returned to determine the quota that was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The designated permission has already been given to the user.</p>
    PermissionAlreadyExistsException(crate::error::PermissionAlreadyExistsException),
    /// <p>The request has failed for an unspecified reason.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePermissionErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            CreatePermissionErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            CreatePermissionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePermissionErrorKind::PermissionAlreadyExistsException(_inner) => _inner.fmt(f),
            CreatePermissionErrorKind::RequestFailedException(_inner) => _inner.fmt(f),
            CreatePermissionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreatePermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePermissionError {
    fn code(&self) -> Option<&str> {
        CreatePermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePermissionError {
    /// Creates a new `CreatePermissionError`.
    pub fn new(kind: CreatePermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePermissionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePermissionErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionErrorKind::PermissionAlreadyExistsException`.
    pub fn is_permission_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionErrorKind::PermissionAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionErrorKind::RequestFailedException`.
    pub fn is_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionErrorKind::RequestFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePermissionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePermissionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreatePermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePermissionErrorKind::InvalidArnException(_inner) => Some(_inner),
            CreatePermissionErrorKind::InvalidStateException(_inner) => Some(_inner),
            CreatePermissionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePermissionErrorKind::PermissionAlreadyExistsException(_inner) => Some(_inner),
            CreatePermissionErrorKind::RequestFailedException(_inner) => Some(_inner),
            CreatePermissionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreatePermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCertificateAuthorityError {
    /// Kind of error that occurred.
    pub kind: DeleteCertificateAuthorityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCertificateAuthorityErrorKind {
    /// <p>A previous update to your private CA is still ongoing.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCertificateAuthorityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCertificateAuthorityErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCertificateAuthorityErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DeleteCertificateAuthorityErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            DeleteCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteCertificateAuthorityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCertificateAuthorityError {
    fn code(&self) -> Option<&str> {
        DeleteCertificateAuthorityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCertificateAuthorityError {
    /// Creates a new `DeleteCertificateAuthorityError`.
    pub fn new(kind: DeleteCertificateAuthorityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCertificateAuthorityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCertificateAuthorityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCertificateAuthorityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCertificateAuthorityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCertificateAuthorityErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateAuthorityErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateAuthorityErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateAuthorityErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateAuthorityErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateAuthorityErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateAuthorityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateAuthorityErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteCertificateAuthorityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCertificateAuthorityErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DeleteCertificateAuthorityErrorKind::InvalidArnException(_inner) => Some(_inner),
            DeleteCertificateAuthorityErrorKind::InvalidStateException(_inner) => Some(_inner),
            DeleteCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteCertificateAuthorityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePermissionError {
    /// Kind of error that occurred.
    pub kind: DeletePermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePermissionErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The request has failed for an unspecified reason.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePermissionErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DeletePermissionErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            DeletePermissionErrorKind::RequestFailedException(_inner) => _inner.fmt(f),
            DeletePermissionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePermissionError {
    fn code(&self) -> Option<&str> {
        DeletePermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePermissionError {
    /// Creates a new `DeletePermissionError`.
    pub fn new(kind: DeletePermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePermissionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePermissionErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionErrorKind::RequestFailedException`.
    pub fn is_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionErrorKind::RequestFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeletePermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePermissionErrorKind::InvalidArnException(_inner) => Some(_inner),
            DeletePermissionErrorKind::InvalidStateException(_inner) => Some(_inner),
            DeletePermissionErrorKind::RequestFailedException(_inner) => Some(_inner),
            DeletePermissionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePolicyError {
    /// Kind of error that occurred.
    pub kind: DeletePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePolicyErrorKind {
    /// <p>A previous update to your private CA is still ongoing.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The current action was prevented because it would lock the caller out from performing subsequent actions. Verify that the specified parameters would not result in the caller being denied access to the resource. </p>
    LockoutPreventedException(crate::error::LockoutPreventedException),
    /// <p>The request has failed for an unspecified reason.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePolicyErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::LockoutPreventedException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::RequestFailedException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePolicyError {
    fn code(&self) -> Option<&str> {
        DeletePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePolicyError {
    /// Creates a new `DeletePolicyError`.
    pub fn new(kind: DeletePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::LockoutPreventedException`.
    pub fn is_lockout_prevented_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::LockoutPreventedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::RequestFailedException`.
    pub fn is_request_failed_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::RequestFailedException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeletePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePolicyErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeletePolicyErrorKind::InvalidArnException(_inner) => Some(_inner),
            DeletePolicyErrorKind::InvalidStateException(_inner) => Some(_inner),
            DeletePolicyErrorKind::LockoutPreventedException(_inner) => Some(_inner),
            DeletePolicyErrorKind::RequestFailedException(_inner) => Some(_inner),
            DeletePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCertificateAuthorityError {
    /// Kind of error that occurred.
    pub kind: DescribeCertificateAuthorityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCertificateAuthorityErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCertificateAuthorityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCertificateAuthorityErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DescribeCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCertificateAuthorityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCertificateAuthorityError {
    fn code(&self) -> Option<&str> {
        DescribeCertificateAuthorityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCertificateAuthorityError {
    /// Creates a new `DescribeCertificateAuthorityError`.
    pub fn new(kind: DescribeCertificateAuthorityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCertificateAuthorityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCertificateAuthorityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCertificateAuthorityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCertificateAuthorityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCertificateAuthorityErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateAuthorityErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCertificateAuthorityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateAuthorityErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeCertificateAuthorityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCertificateAuthorityErrorKind::InvalidArnException(_inner) => Some(_inner),
            DescribeCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeCertificateAuthorityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCertificateAuthorityAuditReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCertificateAuthorityAuditReportError {
    /// Kind of error that occurred.
    pub kind: DescribeCertificateAuthorityAuditReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCertificateAuthorityAuditReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCertificateAuthorityAuditReportErrorKind {
    /// <p>One or more of the specified arguments was not valid.</p>
    InvalidArgsException(crate::error::InvalidArgsException),
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCertificateAuthorityAuditReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCertificateAuthorityAuditReportErrorKind::InvalidArgsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCertificateAuthorityAuditReportErrorKind::InvalidArnException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCertificateAuthorityAuditReportErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCertificateAuthorityAuditReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCertificateAuthorityAuditReportError {
    fn code(&self) -> Option<&str> {
        DescribeCertificateAuthorityAuditReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCertificateAuthorityAuditReportError {
    /// Creates a new `DescribeCertificateAuthorityAuditReportError`.
    pub fn new(
        kind: DescribeCertificateAuthorityAuditReportErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCertificateAuthorityAuditReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCertificateAuthorityAuditReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCertificateAuthorityAuditReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCertificateAuthorityAuditReportErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCertificateAuthorityAuditReportErrorKind::InvalidArgsException`.
    pub fn is_invalid_args_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateAuthorityAuditReportErrorKind::InvalidArgsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCertificateAuthorityAuditReportErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateAuthorityAuditReportErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCertificateAuthorityAuditReportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateAuthorityAuditReportErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeCertificateAuthorityAuditReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCertificateAuthorityAuditReportErrorKind::InvalidArgsException(_inner) => {
                Some(_inner)
            }
            DescribeCertificateAuthorityAuditReportErrorKind::InvalidArnException(_inner) => {
                Some(_inner)
            }
            DescribeCertificateAuthorityAuditReportErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeCertificateAuthorityAuditReportErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCertificateError {
    /// Kind of error that occurred.
    pub kind: GetCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCertificateErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The request has failed for an unspecified reason.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>Your request is already in progress.</p>
    RequestInProgressException(crate::error::RequestInProgressException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetCertificateErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            GetCertificateErrorKind::RequestFailedException(_inner) => _inner.fmt(f),
            GetCertificateErrorKind::RequestInProgressException(_inner) => _inner.fmt(f),
            GetCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCertificateError {
    fn code(&self) -> Option<&str> {
        GetCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCertificateError {
    /// Creates a new `GetCertificateError`.
    pub fn new(kind: GetCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, GetCertificateErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `GetCertificateErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCertificateErrorKind::RequestFailedException`.
    pub fn is_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateErrorKind::RequestFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCertificateErrorKind::RequestInProgressException`.
    pub fn is_request_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateErrorKind::RequestInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetCertificateErrorKind::InvalidStateException(_inner) => Some(_inner),
            GetCertificateErrorKind::RequestFailedException(_inner) => Some(_inner),
            GetCertificateErrorKind::RequestInProgressException(_inner) => Some(_inner),
            GetCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCertificateAuthorityCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCertificateAuthorityCertificateError {
    /// Kind of error that occurred.
    pub kind: GetCertificateAuthorityCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCertificateAuthorityCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCertificateAuthorityCertificateErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCertificateAuthorityCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCertificateAuthorityCertificateErrorKind::InvalidArnException(_inner) => {
                _inner.fmt(f)
            }
            GetCertificateAuthorityCertificateErrorKind::InvalidStateException(_inner) => {
                _inner.fmt(f)
            }
            GetCertificateAuthorityCertificateErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetCertificateAuthorityCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCertificateAuthorityCertificateError {
    fn code(&self) -> Option<&str> {
        GetCertificateAuthorityCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCertificateAuthorityCertificateError {
    /// Creates a new `GetCertificateAuthorityCertificateError`.
    pub fn new(
        kind: GetCertificateAuthorityCertificateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCertificateAuthorityCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCertificateAuthorityCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCertificateAuthorityCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCertificateAuthorityCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCertificateAuthorityCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateAuthorityCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCertificateAuthorityCertificateErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateAuthorityCertificateErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCertificateAuthorityCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateAuthorityCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetCertificateAuthorityCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCertificateAuthorityCertificateErrorKind::InvalidArnException(_inner) => {
                Some(_inner)
            }
            GetCertificateAuthorityCertificateErrorKind::InvalidStateException(_inner) => {
                Some(_inner)
            }
            GetCertificateAuthorityCertificateErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetCertificateAuthorityCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCertificateAuthorityCsr` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCertificateAuthorityCsrError {
    /// Kind of error that occurred.
    pub kind: GetCertificateAuthorityCsrErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCertificateAuthorityCsr` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCertificateAuthorityCsrErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The request has failed for an unspecified reason.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>Your request is already in progress.</p>
    RequestInProgressException(crate::error::RequestInProgressException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCertificateAuthorityCsrError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCertificateAuthorityCsrErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetCertificateAuthorityCsrErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            GetCertificateAuthorityCsrErrorKind::RequestFailedException(_inner) => _inner.fmt(f),
            GetCertificateAuthorityCsrErrorKind::RequestInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetCertificateAuthorityCsrErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCertificateAuthorityCsrErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCertificateAuthorityCsrError {
    fn code(&self) -> Option<&str> {
        GetCertificateAuthorityCsrError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCertificateAuthorityCsrError {
    /// Creates a new `GetCertificateAuthorityCsrError`.
    pub fn new(kind: GetCertificateAuthorityCsrErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCertificateAuthorityCsrError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCertificateAuthorityCsrErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCertificateAuthorityCsrError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCertificateAuthorityCsrErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCertificateAuthorityCsrErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateAuthorityCsrErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCertificateAuthorityCsrErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateAuthorityCsrErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCertificateAuthorityCsrErrorKind::RequestFailedException`.
    pub fn is_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateAuthorityCsrErrorKind::RequestFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCertificateAuthorityCsrErrorKind::RequestInProgressException`.
    pub fn is_request_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateAuthorityCsrErrorKind::RequestInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCertificateAuthorityCsrErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateAuthorityCsrErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetCertificateAuthorityCsrError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCertificateAuthorityCsrErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetCertificateAuthorityCsrErrorKind::InvalidStateException(_inner) => Some(_inner),
            GetCertificateAuthorityCsrErrorKind::RequestFailedException(_inner) => Some(_inner),
            GetCertificateAuthorityCsrErrorKind::RequestInProgressException(_inner) => Some(_inner),
            GetCertificateAuthorityCsrErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCertificateAuthorityCsrErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPolicyError {
    /// Kind of error that occurred.
    pub kind: GetPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPolicyErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The request has failed for an unspecified reason.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPolicyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::RequestFailedException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPolicyError {
    fn code(&self) -> Option<&str> {
        GetPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPolicyError {
    /// Creates a new `GetPolicyError`.
    pub fn new(kind: GetPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::RequestFailedException`.
    pub fn is_request_failed_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::RequestFailedException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for GetPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPolicyErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetPolicyErrorKind::InvalidStateException(_inner) => Some(_inner),
            GetPolicyErrorKind::RequestFailedException(_inner) => Some(_inner),
            GetPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportCertificateAuthorityCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportCertificateAuthorityCertificateError {
    /// Kind of error that occurred.
    pub kind: ImportCertificateAuthorityCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportCertificateAuthorityCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportCertificateAuthorityCertificateErrorKind {
    /// <p>The certificate authority certificate you are importing does not comply with conditions specified in the certificate that signed it.</p>
    CertificateMismatchException(crate::error::CertificateMismatchException),
    /// <p>A previous update to your private CA is still ongoing.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request action cannot be performed or is prohibited.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>One or more fields in the certificate are invalid.</p>
    MalformedCertificateException(crate::error::MalformedCertificateException),
    /// <p>The request has failed for an unspecified reason.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>Your request is already in progress.</p>
    RequestInProgressException(crate::error::RequestInProgressException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportCertificateAuthorityCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportCertificateAuthorityCertificateErrorKind::CertificateMismatchException(
                _inner,
            ) => _inner.fmt(f),
            ImportCertificateAuthorityCertificateErrorKind::ConcurrentModificationException(
                _inner,
            ) => _inner.fmt(f),
            ImportCertificateAuthorityCertificateErrorKind::InvalidArnException(_inner) => {
                _inner.fmt(f)
            }
            ImportCertificateAuthorityCertificateErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ImportCertificateAuthorityCertificateErrorKind::InvalidStateException(_inner) => {
                _inner.fmt(f)
            }
            ImportCertificateAuthorityCertificateErrorKind::MalformedCertificateException(
                _inner,
            ) => _inner.fmt(f),
            ImportCertificateAuthorityCertificateErrorKind::RequestFailedException(_inner) => {
                _inner.fmt(f)
            }
            ImportCertificateAuthorityCertificateErrorKind::RequestInProgressException(_inner) => {
                _inner.fmt(f)
            }
            ImportCertificateAuthorityCertificateErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ImportCertificateAuthorityCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportCertificateAuthorityCertificateError {
    fn code(&self) -> Option<&str> {
        ImportCertificateAuthorityCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportCertificateAuthorityCertificateError {
    /// Creates a new `ImportCertificateAuthorityCertificateError`.
    pub fn new(
        kind: ImportCertificateAuthorityCertificateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportCertificateAuthorityCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportCertificateAuthorityCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportCertificateAuthorityCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportCertificateAuthorityCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportCertificateAuthorityCertificateErrorKind::CertificateMismatchException`.
    pub fn is_certificate_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateAuthorityCertificateErrorKind::CertificateMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportCertificateAuthorityCertificateErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateAuthorityCertificateErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportCertificateAuthorityCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateAuthorityCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportCertificateAuthorityCertificateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateAuthorityCertificateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportCertificateAuthorityCertificateErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateAuthorityCertificateErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportCertificateAuthorityCertificateErrorKind::MalformedCertificateException`.
    pub fn is_malformed_certificate_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateAuthorityCertificateErrorKind::MalformedCertificateException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportCertificateAuthorityCertificateErrorKind::RequestFailedException`.
    pub fn is_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateAuthorityCertificateErrorKind::RequestFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportCertificateAuthorityCertificateErrorKind::RequestInProgressException`.
    pub fn is_request_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateAuthorityCertificateErrorKind::RequestInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportCertificateAuthorityCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateAuthorityCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ImportCertificateAuthorityCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportCertificateAuthorityCertificateErrorKind::CertificateMismatchException(
                _inner,
            ) => Some(_inner),
            ImportCertificateAuthorityCertificateErrorKind::ConcurrentModificationException(
                _inner,
            ) => Some(_inner),
            ImportCertificateAuthorityCertificateErrorKind::InvalidArnException(_inner) => {
                Some(_inner)
            }
            ImportCertificateAuthorityCertificateErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ImportCertificateAuthorityCertificateErrorKind::InvalidStateException(_inner) => {
                Some(_inner)
            }
            ImportCertificateAuthorityCertificateErrorKind::MalformedCertificateException(
                _inner,
            ) => Some(_inner),
            ImportCertificateAuthorityCertificateErrorKind::RequestFailedException(_inner) => {
                Some(_inner)
            }
            ImportCertificateAuthorityCertificateErrorKind::RequestInProgressException(_inner) => {
                Some(_inner)
            }
            ImportCertificateAuthorityCertificateErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ImportCertificateAuthorityCertificateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `IssueCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct IssueCertificateError {
    /// Kind of error that occurred.
    pub kind: IssueCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `IssueCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum IssueCertificateErrorKind {
    /// <p>One or more of the specified arguments was not valid.</p>
    InvalidArgsException(crate::error::InvalidArgsException),
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>An ACM Private CA quota has been exceeded. See the exception message returned to determine the quota that was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The certificate signing request is invalid.</p>
    MalformedCsrException(crate::error::MalformedCsrException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for IssueCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            IssueCertificateErrorKind::InvalidArgsException(_inner) => _inner.fmt(f),
            IssueCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            IssueCertificateErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            IssueCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            IssueCertificateErrorKind::MalformedCsrException(_inner) => _inner.fmt(f),
            IssueCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            IssueCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for IssueCertificateError {
    fn code(&self) -> Option<&str> {
        IssueCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl IssueCertificateError {
    /// Creates a new `IssueCertificateError`.
    pub fn new(kind: IssueCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `IssueCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: IssueCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `IssueCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: IssueCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `IssueCertificateErrorKind::InvalidArgsException`.
    pub fn is_invalid_args_exception(&self) -> bool {
        matches!(
            &self.kind,
            IssueCertificateErrorKind::InvalidArgsException(_)
        )
    }
    /// Returns `true` if the error kind is `IssueCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            IssueCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `IssueCertificateErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            IssueCertificateErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `IssueCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            IssueCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `IssueCertificateErrorKind::MalformedCsrException`.
    pub fn is_malformed_csr_exception(&self) -> bool {
        matches!(
            &self.kind,
            IssueCertificateErrorKind::MalformedCsrException(_)
        )
    }
    /// Returns `true` if the error kind is `IssueCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            IssueCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for IssueCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            IssueCertificateErrorKind::InvalidArgsException(_inner) => Some(_inner),
            IssueCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            IssueCertificateErrorKind::InvalidStateException(_inner) => Some(_inner),
            IssueCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            IssueCertificateErrorKind::MalformedCsrException(_inner) => Some(_inner),
            IssueCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            IssueCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCertificateAuthorities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCertificateAuthoritiesError {
    /// Kind of error that occurred.
    pub kind: ListCertificateAuthoritiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCertificateAuthorities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCertificateAuthoritiesErrorKind {
    /// <p>The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your previous call to <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a>.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCertificateAuthoritiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCertificateAuthoritiesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListCertificateAuthoritiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCertificateAuthoritiesError {
    fn code(&self) -> Option<&str> {
        ListCertificateAuthoritiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCertificateAuthoritiesError {
    /// Creates a new `ListCertificateAuthoritiesError`.
    pub fn new(kind: ListCertificateAuthoritiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCertificateAuthoritiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCertificateAuthoritiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCertificateAuthoritiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCertificateAuthoritiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCertificateAuthoritiesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificateAuthoritiesErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListCertificateAuthoritiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCertificateAuthoritiesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListCertificateAuthoritiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPermissionsError {
    /// Kind of error that occurred.
    pub kind: ListPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPermissionsErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your previous call to <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a>.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The request has failed for an unspecified reason.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPermissionsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::RequestFailedException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPermissionsError {
    fn code(&self) -> Option<&str> {
        ListPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPermissionsError {
    /// Creates a new `ListPermissionsError`.
    pub fn new(kind: ListPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, ListPermissionsErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::RequestFailedException`.
    pub fn is_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::RequestFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPermissionsErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListPermissionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListPermissionsErrorKind::InvalidStateException(_inner) => Some(_inner),
            ListPermissionsErrorKind::RequestFailedException(_inner) => Some(_inner),
            ListPermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsError {
    /// Kind of error that occurred.
    pub kind: ListTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsError {
    fn code(&self) -> Option<&str> {
        ListTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsError {
    /// Creates a new `ListTagsError`.
    pub fn new(kind: ListTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for ListTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListTagsErrorKind::InvalidStateException(_inner) => Some(_inner),
            ListTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutPolicyError {
    /// Kind of error that occurred.
    pub kind: PutPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutPolicyErrorKind {
    /// <p>A previous update to your private CA is still ongoing.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The resource policy is invalid or is missing a required statement. For general information about IAM policy and statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>
    InvalidPolicyException(crate::error::InvalidPolicyException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The current action was prevented because it would lock the caller out from performing subsequent actions. Verify that the specified parameters would not result in the caller being denied access to the resource. </p>
    LockoutPreventedException(crate::error::LockoutPreventedException),
    /// <p>The request has failed for an unspecified reason.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutPolicyErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::InvalidPolicyException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::LockoutPreventedException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::RequestFailedException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutPolicyError {
    fn code(&self) -> Option<&str> {
        PutPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutPolicyError {
    /// Creates a new `PutPolicyError`.
    pub fn new(kind: PutPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPolicyErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::InvalidPolicyException`.
    pub fn is_invalid_policy_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::InvalidPolicyException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::LockoutPreventedException`.
    pub fn is_lockout_prevented_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::LockoutPreventedException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::RequestFailedException`.
    pub fn is_request_failed_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::RequestFailedException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for PutPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutPolicyErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            PutPolicyErrorKind::InvalidArnException(_inner) => Some(_inner),
            PutPolicyErrorKind::InvalidPolicyException(_inner) => Some(_inner),
            PutPolicyErrorKind::InvalidStateException(_inner) => Some(_inner),
            PutPolicyErrorKind::LockoutPreventedException(_inner) => Some(_inner),
            PutPolicyErrorKind::RequestFailedException(_inner) => Some(_inner),
            PutPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreCertificateAuthorityError {
    /// Kind of error that occurred.
    pub kind: RestoreCertificateAuthorityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreCertificateAuthorityErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreCertificateAuthorityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreCertificateAuthorityErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            RestoreCertificateAuthorityErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            RestoreCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RestoreCertificateAuthorityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreCertificateAuthorityError {
    fn code(&self) -> Option<&str> {
        RestoreCertificateAuthorityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreCertificateAuthorityError {
    /// Creates a new `RestoreCertificateAuthorityError`.
    pub fn new(kind: RestoreCertificateAuthorityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreCertificateAuthorityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreCertificateAuthorityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreCertificateAuthorityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreCertificateAuthorityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreCertificateAuthorityErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreCertificateAuthorityErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreCertificateAuthorityErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreCertificateAuthorityErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreCertificateAuthorityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreCertificateAuthorityErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RestoreCertificateAuthorityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreCertificateAuthorityErrorKind::InvalidArnException(_inner) => Some(_inner),
            RestoreCertificateAuthorityErrorKind::InvalidStateException(_inner) => Some(_inner),
            RestoreCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RestoreCertificateAuthorityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RevokeCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RevokeCertificateError {
    /// Kind of error that occurred.
    pub kind: RevokeCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RevokeCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RevokeCertificateErrorKind {
    /// <p>A previous update to your private CA is still ongoing.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request action cannot be performed or is prohibited.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>An ACM Private CA quota has been exceeded. See the exception message returned to determine the quota that was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Your request has already been completed.</p>
    RequestAlreadyProcessedException(crate::error::RequestAlreadyProcessedException),
    /// <p>The request has failed for an unspecified reason.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>Your request is already in progress.</p>
    RequestInProgressException(crate::error::RequestInProgressException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RevokeCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RevokeCertificateErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            RevokeCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            RevokeCertificateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            RevokeCertificateErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            RevokeCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RevokeCertificateErrorKind::RequestAlreadyProcessedException(_inner) => _inner.fmt(f),
            RevokeCertificateErrorKind::RequestFailedException(_inner) => _inner.fmt(f),
            RevokeCertificateErrorKind::RequestInProgressException(_inner) => _inner.fmt(f),
            RevokeCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RevokeCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RevokeCertificateError {
    fn code(&self) -> Option<&str> {
        RevokeCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RevokeCertificateError {
    /// Creates a new `RevokeCertificateError`.
    pub fn new(kind: RevokeCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RevokeCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RevokeCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RevokeCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RevokeCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RevokeCertificateErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeCertificateErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeCertificateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeCertificateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeCertificateErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeCertificateErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeCertificateErrorKind::RequestAlreadyProcessedException`.
    pub fn is_request_already_processed_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeCertificateErrorKind::RequestAlreadyProcessedException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeCertificateErrorKind::RequestFailedException`.
    pub fn is_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeCertificateErrorKind::RequestFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeCertificateErrorKind::RequestInProgressException`.
    pub fn is_request_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeCertificateErrorKind::RequestInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RevokeCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RevokeCertificateErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            RevokeCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            RevokeCertificateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            RevokeCertificateErrorKind::InvalidStateException(_inner) => Some(_inner),
            RevokeCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            RevokeCertificateErrorKind::RequestAlreadyProcessedException(_inner) => Some(_inner),
            RevokeCertificateErrorKind::RequestFailedException(_inner) => Some(_inner),
            RevokeCertificateErrorKind::RequestInProgressException(_inner) => Some(_inner),
            RevokeCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RevokeCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagCertificateAuthorityError {
    /// Kind of error that occurred.
    pub kind: TagCertificateAuthorityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagCertificateAuthorityErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The tag associated with the CA is not valid. The invalid argument is contained in the message field.</p>
    InvalidTagException(crate::error::InvalidTagException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You can associate up to 50 tags with a private CA. Exception information is contained in the exception message field.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagCertificateAuthorityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagCertificateAuthorityErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            TagCertificateAuthorityErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            TagCertificateAuthorityErrorKind::InvalidTagException(_inner) => _inner.fmt(f),
            TagCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagCertificateAuthorityErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagCertificateAuthorityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagCertificateAuthorityError {
    fn code(&self) -> Option<&str> {
        TagCertificateAuthorityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagCertificateAuthorityError {
    /// Creates a new `TagCertificateAuthorityError`.
    pub fn new(kind: TagCertificateAuthorityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagCertificateAuthorityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagCertificateAuthorityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagCertificateAuthorityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagCertificateAuthorityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagCertificateAuthorityErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagCertificateAuthorityErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `TagCertificateAuthorityErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagCertificateAuthorityErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `TagCertificateAuthorityErrorKind::InvalidTagException`.
    pub fn is_invalid_tag_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagCertificateAuthorityErrorKind::InvalidTagException(_)
        )
    }
    /// Returns `true` if the error kind is `TagCertificateAuthorityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagCertificateAuthorityErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagCertificateAuthorityErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagCertificateAuthorityErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for TagCertificateAuthorityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagCertificateAuthorityErrorKind::InvalidArnException(_inner) => Some(_inner),
            TagCertificateAuthorityErrorKind::InvalidStateException(_inner) => Some(_inner),
            TagCertificateAuthorityErrorKind::InvalidTagException(_inner) => Some(_inner),
            TagCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagCertificateAuthorityErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagCertificateAuthorityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagCertificateAuthorityError {
    /// Kind of error that occurred.
    pub kind: UntagCertificateAuthorityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagCertificateAuthorityErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The tag associated with the CA is not valid. The invalid argument is contained in the message field.</p>
    InvalidTagException(crate::error::InvalidTagException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagCertificateAuthorityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagCertificateAuthorityErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UntagCertificateAuthorityErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            UntagCertificateAuthorityErrorKind::InvalidTagException(_inner) => _inner.fmt(f),
            UntagCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagCertificateAuthorityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagCertificateAuthorityError {
    fn code(&self) -> Option<&str> {
        UntagCertificateAuthorityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagCertificateAuthorityError {
    /// Creates a new `UntagCertificateAuthorityError`.
    pub fn new(kind: UntagCertificateAuthorityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagCertificateAuthorityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagCertificateAuthorityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagCertificateAuthorityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagCertificateAuthorityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagCertificateAuthorityErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagCertificateAuthorityErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagCertificateAuthorityErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagCertificateAuthorityErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagCertificateAuthorityErrorKind::InvalidTagException`.
    pub fn is_invalid_tag_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagCertificateAuthorityErrorKind::InvalidTagException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagCertificateAuthorityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagCertificateAuthorityErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagCertificateAuthorityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagCertificateAuthorityErrorKind::InvalidArnException(_inner) => Some(_inner),
            UntagCertificateAuthorityErrorKind::InvalidStateException(_inner) => Some(_inner),
            UntagCertificateAuthorityErrorKind::InvalidTagException(_inner) => Some(_inner),
            UntagCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagCertificateAuthorityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCertificateAuthorityError {
    /// Kind of error that occurred.
    pub kind: UpdateCertificateAuthorityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCertificateAuthority` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCertificateAuthorityErrorKind {
    /// <p>A previous update to your private CA is still ongoing.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>One or more of the specified arguments was not valid.</p>
    InvalidArgsException(crate::error::InvalidArgsException),
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The resource policy is invalid or is missing a required statement. For general information about IAM policy and statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>
    InvalidPolicyException(crate::error::InvalidPolicyException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCertificateAuthorityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCertificateAuthorityErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCertificateAuthorityErrorKind::InvalidArgsException(_inner) => _inner.fmt(f),
            UpdateCertificateAuthorityErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UpdateCertificateAuthorityErrorKind::InvalidPolicyException(_inner) => _inner.fmt(f),
            UpdateCertificateAuthorityErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            UpdateCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateCertificateAuthorityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCertificateAuthorityError {
    fn code(&self) -> Option<&str> {
        UpdateCertificateAuthorityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCertificateAuthorityError {
    /// Creates a new `UpdateCertificateAuthorityError`.
    pub fn new(kind: UpdateCertificateAuthorityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCertificateAuthorityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCertificateAuthorityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCertificateAuthorityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCertificateAuthorityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCertificateAuthorityErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCertificateAuthorityErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCertificateAuthorityErrorKind::InvalidArgsException`.
    pub fn is_invalid_args_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCertificateAuthorityErrorKind::InvalidArgsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCertificateAuthorityErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCertificateAuthorityErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCertificateAuthorityErrorKind::InvalidPolicyException`.
    pub fn is_invalid_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCertificateAuthorityErrorKind::InvalidPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCertificateAuthorityErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCertificateAuthorityErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCertificateAuthorityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCertificateAuthorityErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateCertificateAuthorityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCertificateAuthorityErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            UpdateCertificateAuthorityErrorKind::InvalidArgsException(_inner) => Some(_inner),
            UpdateCertificateAuthorityErrorKind::InvalidArnException(_inner) => Some(_inner),
            UpdateCertificateAuthorityErrorKind::InvalidPolicyException(_inner) => Some(_inner),
            UpdateCertificateAuthorityErrorKind::InvalidStateException(_inner) => Some(_inner),
            UpdateCertificateAuthorityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateCertificateAuthorityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The state of the private CA does not allow this action to occur.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidStateException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidStateException {}
/// See [`InvalidStateException`](crate::error::InvalidStateException)
pub mod invalid_state_exception {
    /// A builder for [`InvalidStateException`](crate::error::InvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidStateException`](crate::error::InvalidStateException)
        pub fn build(self) -> crate::error::InvalidStateException {
            crate::error::InvalidStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidStateException {
    /// Creates a new builder-style object to manufacture [`InvalidStateException`](crate::error::InvalidStateException)
    pub fn builder() -> crate::error::invalid_state_exception::Builder {
        crate::error::invalid_state_exception::Builder::default()
    }
}

/// <p>The resource policy is invalid or is missing a required statement. For general information about IAM policy and statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPolicyException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPolicyException {}
/// See [`InvalidPolicyException`](crate::error::InvalidPolicyException)
pub mod invalid_policy_exception {
    /// A builder for [`InvalidPolicyException`](crate::error::InvalidPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPolicyException`](crate::error::InvalidPolicyException)
        pub fn build(self) -> crate::error::InvalidPolicyException {
            crate::error::InvalidPolicyException {
                message: self.message,
            }
        }
    }
}
impl InvalidPolicyException {
    /// Creates a new builder-style object to manufacture [`InvalidPolicyException`](crate::error::InvalidPolicyException)
    pub fn builder() -> crate::error::invalid_policy_exception::Builder {
        crate::error::invalid_policy_exception::Builder::default()
    }
}

/// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArnException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArnException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArnException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArnException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArnException {}
/// See [`InvalidArnException`](crate::error::InvalidArnException)
pub mod invalid_arn_exception {
    /// A builder for [`InvalidArnException`](crate::error::InvalidArnException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArnException`](crate::error::InvalidArnException)
        pub fn build(self) -> crate::error::InvalidArnException {
            crate::error::InvalidArnException {
                message: self.message,
            }
        }
    }
}
impl InvalidArnException {
    /// Creates a new builder-style object to manufacture [`InvalidArnException`](crate::error::InvalidArnException)
    pub fn builder() -> crate::error::invalid_arn_exception::Builder {
        crate::error::invalid_arn_exception::Builder::default()
    }
}

/// <p>One or more of the specified arguments was not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArgsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArgsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArgsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArgsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArgsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArgsException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArgsException {}
/// See [`InvalidArgsException`](crate::error::InvalidArgsException)
pub mod invalid_args_exception {
    /// A builder for [`InvalidArgsException`](crate::error::InvalidArgsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArgsException`](crate::error::InvalidArgsException)
        pub fn build(self) -> crate::error::InvalidArgsException {
            crate::error::InvalidArgsException {
                message: self.message,
            }
        }
    }
}
impl InvalidArgsException {
    /// Creates a new builder-style object to manufacture [`InvalidArgsException`](crate::error::InvalidArgsException)
    pub fn builder() -> crate::error::invalid_args_exception::Builder {
        crate::error::invalid_args_exception::Builder::default()
    }
}

/// <p>A previous update to your private CA is still ongoing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>The tag associated with the CA is not valid. The invalid argument is contained in the message field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTagException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTagException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTagException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTagException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTagException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTagException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTagException {}
/// See [`InvalidTagException`](crate::error::InvalidTagException)
pub mod invalid_tag_exception {
    /// A builder for [`InvalidTagException`](crate::error::InvalidTagException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTagException`](crate::error::InvalidTagException)
        pub fn build(self) -> crate::error::InvalidTagException {
            crate::error::InvalidTagException {
                message: self.message,
            }
        }
    }
}
impl InvalidTagException {
    /// Creates a new builder-style object to manufacture [`InvalidTagException`](crate::error::InvalidTagException)
    pub fn builder() -> crate::error::invalid_tag_exception::Builder {
        crate::error::invalid_tag_exception::Builder::default()
    }
}

/// <p>You can associate up to 50 tags with a private CA. Exception information is contained in the exception message field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>Your request is already in progress.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestInProgressException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestInProgressException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestInProgressException {}
/// See [`RequestInProgressException`](crate::error::RequestInProgressException)
pub mod request_in_progress_exception {
    /// A builder for [`RequestInProgressException`](crate::error::RequestInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestInProgressException`](crate::error::RequestInProgressException)
        pub fn build(self) -> crate::error::RequestInProgressException {
            crate::error::RequestInProgressException {
                message: self.message,
            }
        }
    }
}
impl RequestInProgressException {
    /// Creates a new builder-style object to manufacture [`RequestInProgressException`](crate::error::RequestInProgressException)
    pub fn builder() -> crate::error::request_in_progress_exception::Builder {
        crate::error::request_in_progress_exception::Builder::default()
    }
}

/// <p>The request has failed for an unspecified reason.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestFailedException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestFailedException {}
/// See [`RequestFailedException`](crate::error::RequestFailedException)
pub mod request_failed_exception {
    /// A builder for [`RequestFailedException`](crate::error::RequestFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestFailedException`](crate::error::RequestFailedException)
        pub fn build(self) -> crate::error::RequestFailedException {
            crate::error::RequestFailedException {
                message: self.message,
            }
        }
    }
}
impl RequestFailedException {
    /// Creates a new builder-style object to manufacture [`RequestFailedException`](crate::error::RequestFailedException)
    pub fn builder() -> crate::error::request_failed_exception::Builder {
        crate::error::request_failed_exception::Builder::default()
    }
}

/// <p>Your request has already been completed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestAlreadyProcessedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestAlreadyProcessedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestAlreadyProcessedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestAlreadyProcessedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestAlreadyProcessedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestAlreadyProcessedException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestAlreadyProcessedException {}
/// See [`RequestAlreadyProcessedException`](crate::error::RequestAlreadyProcessedException)
pub mod request_already_processed_exception {
    /// A builder for [`RequestAlreadyProcessedException`](crate::error::RequestAlreadyProcessedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestAlreadyProcessedException`](crate::error::RequestAlreadyProcessedException)
        pub fn build(self) -> crate::error::RequestAlreadyProcessedException {
            crate::error::RequestAlreadyProcessedException {
                message: self.message,
            }
        }
    }
}
impl RequestAlreadyProcessedException {
    /// Creates a new builder-style object to manufacture [`RequestAlreadyProcessedException`](crate::error::RequestAlreadyProcessedException)
    pub fn builder() -> crate::error::request_already_processed_exception::Builder {
        crate::error::request_already_processed_exception::Builder::default()
    }
}

/// <p>An ACM Private CA quota has been exceeded. See the exception message returned to determine the quota that was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The request action cannot be performed or is prohibited.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>The current action was prevented because it would lock the caller out from performing subsequent actions. Verify that the specified parameters would not result in the caller being denied access to the resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LockoutPreventedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LockoutPreventedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LockoutPreventedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LockoutPreventedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LockoutPreventedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LockoutPreventedException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for LockoutPreventedException {}
/// See [`LockoutPreventedException`](crate::error::LockoutPreventedException)
pub mod lockout_prevented_exception {
    /// A builder for [`LockoutPreventedException`](crate::error::LockoutPreventedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LockoutPreventedException`](crate::error::LockoutPreventedException)
        pub fn build(self) -> crate::error::LockoutPreventedException {
            crate::error::LockoutPreventedException {
                message: self.message,
            }
        }
    }
}
impl LockoutPreventedException {
    /// Creates a new builder-style object to manufacture [`LockoutPreventedException`](crate::error::LockoutPreventedException)
    pub fn builder() -> crate::error::lockout_prevented_exception::Builder {
        crate::error::lockout_prevented_exception::Builder::default()
    }
}

/// <p>The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your previous call to <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>The certificate signing request is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MalformedCsrException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MalformedCsrException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MalformedCsrException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MalformedCsrException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MalformedCsrException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MalformedCsrException [MalformedCSRException]")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for MalformedCsrException {}
/// See [`MalformedCsrException`](crate::error::MalformedCsrException)
pub mod malformed_csr_exception {
    /// A builder for [`MalformedCsrException`](crate::error::MalformedCsrException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MalformedCsrException`](crate::error::MalformedCsrException)
        pub fn build(self) -> crate::error::MalformedCsrException {
            crate::error::MalformedCsrException {
                message: self.message,
            }
        }
    }
}
impl MalformedCsrException {
    /// Creates a new builder-style object to manufacture [`MalformedCsrException`](crate::error::MalformedCsrException)
    pub fn builder() -> crate::error::malformed_csr_exception::Builder {
        crate::error::malformed_csr_exception::Builder::default()
    }
}

/// <p>One or more fields in the certificate are invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MalformedCertificateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MalformedCertificateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MalformedCertificateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MalformedCertificateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MalformedCertificateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MalformedCertificateException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for MalformedCertificateException {}
/// See [`MalformedCertificateException`](crate::error::MalformedCertificateException)
pub mod malformed_certificate_exception {
    /// A builder for [`MalformedCertificateException`](crate::error::MalformedCertificateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MalformedCertificateException`](crate::error::MalformedCertificateException)
        pub fn build(self) -> crate::error::MalformedCertificateException {
            crate::error::MalformedCertificateException {
                message: self.message,
            }
        }
    }
}
impl MalformedCertificateException {
    /// Creates a new builder-style object to manufacture [`MalformedCertificateException`](crate::error::MalformedCertificateException)
    pub fn builder() -> crate::error::malformed_certificate_exception::Builder {
        crate::error::malformed_certificate_exception::Builder::default()
    }
}

/// <p>The certificate authority certificate you are importing does not comply with conditions specified in the certificate that signed it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CertificateMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateMismatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CertificateMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CertificateMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CertificateMismatchException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for CertificateMismatchException {}
/// See [`CertificateMismatchException`](crate::error::CertificateMismatchException)
pub mod certificate_mismatch_exception {
    /// A builder for [`CertificateMismatchException`](crate::error::CertificateMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateMismatchException`](crate::error::CertificateMismatchException)
        pub fn build(self) -> crate::error::CertificateMismatchException {
            crate::error::CertificateMismatchException {
                message: self.message,
            }
        }
    }
}
impl CertificateMismatchException {
    /// Creates a new builder-style object to manufacture [`CertificateMismatchException`](crate::error::CertificateMismatchException)
    pub fn builder() -> crate::error::certificate_mismatch_exception::Builder {
        crate::error::certificate_mismatch_exception::Builder::default()
    }
}

/// <p>The designated permission has already been given to the user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PermissionAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PermissionAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PermissionAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PermissionAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PermissionAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PermissionAlreadyExistsException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for PermissionAlreadyExistsException {}
/// See [`PermissionAlreadyExistsException`](crate::error::PermissionAlreadyExistsException)
pub mod permission_already_exists_exception {
    /// A builder for [`PermissionAlreadyExistsException`](crate::error::PermissionAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PermissionAlreadyExistsException`](crate::error::PermissionAlreadyExistsException)
        pub fn build(self) -> crate::error::PermissionAlreadyExistsException {
            crate::error::PermissionAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl PermissionAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`PermissionAlreadyExistsException`](crate::error::PermissionAlreadyExistsException)
    pub fn builder() -> crate::error::permission_already_exists_exception::Builder {
        crate::error::permission_already_exists_exception::Builder::default()
    }
}
