// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateAuthorityStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    PendingCertificate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateAuthorityStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => CertificateAuthorityStatus::Active,
            "CREATING" => CertificateAuthorityStatus::Creating,
            "DELETED" => CertificateAuthorityStatus::Deleted,
            "DISABLED" => CertificateAuthorityStatus::Disabled,
            "EXPIRED" => CertificateAuthorityStatus::Expired,
            "FAILED" => CertificateAuthorityStatus::Failed,
            "PENDING_CERTIFICATE" => CertificateAuthorityStatus::PendingCertificate,
            other => CertificateAuthorityStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateAuthorityStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateAuthorityStatus::from(s))
    }
}
impl CertificateAuthorityStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateAuthorityStatus::Active => "ACTIVE",
            CertificateAuthorityStatus::Creating => "CREATING",
            CertificateAuthorityStatus::Deleted => "DELETED",
            CertificateAuthorityStatus::Disabled => "DISABLED",
            CertificateAuthorityStatus::Expired => "EXPIRED",
            CertificateAuthorityStatus::Failed => "FAILED",
            CertificateAuthorityStatus::PendingCertificate => "PENDING_CERTIFICATE",
            CertificateAuthorityStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATING",
            "DELETED",
            "DISABLED",
            "EXPIRED",
            "FAILED",
            "PENDING_CERTIFICATE",
        ]
    }
}
impl AsRef<str> for CertificateAuthorityStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Certificate revocation information used by the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> actions. Your private certificate authority (CA)
/// can configure Online Certificate Status Protocol (OCSP) support and/or maintain a
/// certificate revocation list (CRL). OCSP returns validation information about
/// certificates as requested by clients, and a CRL contains an updated list of certificates
/// revoked by your CA. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html">RevokeCertificate</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/revocation-setup.html">Setting up a
/// certificate revocation method</a> in the <i>AWS Certificate Manager Private Certificate Authority (PCA) User
/// Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevocationConfiguration {
    /// <p>Configuration of the certificate revocation list (CRL), if any, maintained by your private
    /// CA. A CRL is typically updated approximately 30 minutes after a certificate
    /// is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts
    /// every 15 minutes.</p>
    pub crl_configuration: std::option::Option<crate::model::CrlConfiguration>,
    /// <p>Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by
    /// your private CA. When you revoke a certificate, OCSP responses may take up to 60 minutes
    /// to reflect the new status.</p>
    pub ocsp_configuration: std::option::Option<crate::model::OcspConfiguration>,
}
impl RevocationConfiguration {
    /// <p>Configuration of the certificate revocation list (CRL), if any, maintained by your private
    /// CA. A CRL is typically updated approximately 30 minutes after a certificate
    /// is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts
    /// every 15 minutes.</p>
    pub fn crl_configuration(&self) -> std::option::Option<&crate::model::CrlConfiguration> {
        self.crl_configuration.as_ref()
    }
    /// <p>Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by
    /// your private CA. When you revoke a certificate, OCSP responses may take up to 60 minutes
    /// to reflect the new status.</p>
    pub fn ocsp_configuration(&self) -> std::option::Option<&crate::model::OcspConfiguration> {
        self.ocsp_configuration.as_ref()
    }
}
impl std::fmt::Debug for RevocationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevocationConfiguration");
        formatter.field("crl_configuration", &self.crl_configuration);
        formatter.field("ocsp_configuration", &self.ocsp_configuration);
        formatter.finish()
    }
}
/// See [`RevocationConfiguration`](crate::model::RevocationConfiguration)
pub mod revocation_configuration {
    /// A builder for [`RevocationConfiguration`](crate::model::RevocationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crl_configuration: std::option::Option<crate::model::CrlConfiguration>,
        pub(crate) ocsp_configuration: std::option::Option<crate::model::OcspConfiguration>,
    }
    impl Builder {
        /// <p>Configuration of the certificate revocation list (CRL), if any, maintained by your private
        /// CA. A CRL is typically updated approximately 30 minutes after a certificate
        /// is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts
        /// every 15 minutes.</p>
        pub fn crl_configuration(mut self, input: crate::model::CrlConfiguration) -> Self {
            self.crl_configuration = Some(input);
            self
        }
        /// <p>Configuration of the certificate revocation list (CRL), if any, maintained by your private
        /// CA. A CRL is typically updated approximately 30 minutes after a certificate
        /// is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts
        /// every 15 minutes.</p>
        pub fn set_crl_configuration(
            mut self,
            input: std::option::Option<crate::model::CrlConfiguration>,
        ) -> Self {
            self.crl_configuration = input;
            self
        }
        /// <p>Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by
        /// your private CA. When you revoke a certificate, OCSP responses may take up to 60 minutes
        /// to reflect the new status.</p>
        pub fn ocsp_configuration(mut self, input: crate::model::OcspConfiguration) -> Self {
            self.ocsp_configuration = Some(input);
            self
        }
        /// <p>Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by
        /// your private CA. When you revoke a certificate, OCSP responses may take up to 60 minutes
        /// to reflect the new status.</p>
        pub fn set_ocsp_configuration(
            mut self,
            input: std::option::Option<crate::model::OcspConfiguration>,
        ) -> Self {
            self.ocsp_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`RevocationConfiguration`](crate::model::RevocationConfiguration)
        pub fn build(self) -> crate::model::RevocationConfiguration {
            crate::model::RevocationConfiguration {
                crl_configuration: self.crl_configuration,
                ocsp_configuration: self.ocsp_configuration,
            }
        }
    }
}
impl RevocationConfiguration {
    /// Creates a new builder-style object to manufacture [`RevocationConfiguration`](crate::model::RevocationConfiguration)
    pub fn builder() -> crate::model::revocation_configuration::Builder {
        crate::model::revocation_configuration::Builder::default()
    }
}

/// <p>Contains information to enable and configure Online Certificate Status Protocol (OCSP) for
/// validating certificate revocation status.</p>
/// <p>When you revoke a certificate, OCSP responses may take up to 60 minutes
/// to reflect the new status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OcspConfiguration {
    /// <p>Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating
    /// certificate revocation status.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>By default, ACM Private CA injects an AWS domain into certificates being validated by the
    /// Online Certificate Status Protocol (OCSP). A customer can alternatively use this object
    /// to define a CNAME specifying a customized OCSP domain.</p>
    /// <p>Note: The value of the CNAME must not include a protocol prefix such as "http://" or
    /// "https://".</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html">Customizing Online Certificate
    /// Status Protocol (OCSP) </a> in the <i>AWS Certificate Manager Private Certificate Authority (PCA) User
    /// Guide</i>.</p>
    pub ocsp_custom_cname: std::option::Option<std::string::String>,
}
impl OcspConfiguration {
    /// <p>Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating
    /// certificate revocation status.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>By default, ACM Private CA injects an AWS domain into certificates being validated by the
    /// Online Certificate Status Protocol (OCSP). A customer can alternatively use this object
    /// to define a CNAME specifying a customized OCSP domain.</p>
    /// <p>Note: The value of the CNAME must not include a protocol prefix such as "http://" or
    /// "https://".</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html">Customizing Online Certificate
    /// Status Protocol (OCSP) </a> in the <i>AWS Certificate Manager Private Certificate Authority (PCA) User
    /// Guide</i>.</p>
    pub fn ocsp_custom_cname(&self) -> std::option::Option<&str> {
        self.ocsp_custom_cname.as_deref()
    }
}
impl std::fmt::Debug for OcspConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OcspConfiguration");
        formatter.field("enabled", &self.enabled);
        formatter.field("ocsp_custom_cname", &self.ocsp_custom_cname);
        formatter.finish()
    }
}
/// See [`OcspConfiguration`](crate::model::OcspConfiguration)
pub mod ocsp_configuration {
    /// A builder for [`OcspConfiguration`](crate::model::OcspConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) ocsp_custom_cname: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating
        /// certificate revocation status.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating
        /// certificate revocation status.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>By default, ACM Private CA injects an AWS domain into certificates being validated by the
        /// Online Certificate Status Protocol (OCSP). A customer can alternatively use this object
        /// to define a CNAME specifying a customized OCSP domain.</p>
        /// <p>Note: The value of the CNAME must not include a protocol prefix such as "http://" or
        /// "https://".</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html">Customizing Online Certificate
        /// Status Protocol (OCSP) </a> in the <i>AWS Certificate Manager Private Certificate Authority (PCA) User
        /// Guide</i>.</p>
        pub fn ocsp_custom_cname(mut self, input: impl Into<std::string::String>) -> Self {
            self.ocsp_custom_cname = Some(input.into());
            self
        }
        /// <p>By default, ACM Private CA injects an AWS domain into certificates being validated by the
        /// Online Certificate Status Protocol (OCSP). A customer can alternatively use this object
        /// to define a CNAME specifying a customized OCSP domain.</p>
        /// <p>Note: The value of the CNAME must not include a protocol prefix such as "http://" or
        /// "https://".</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html">Customizing Online Certificate
        /// Status Protocol (OCSP) </a> in the <i>AWS Certificate Manager Private Certificate Authority (PCA) User
        /// Guide</i>.</p>
        pub fn set_ocsp_custom_cname(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ocsp_custom_cname = input;
            self
        }
        /// Consumes the builder and constructs a [`OcspConfiguration`](crate::model::OcspConfiguration)
        pub fn build(self) -> crate::model::OcspConfiguration {
            crate::model::OcspConfiguration {
                enabled: self.enabled,
                ocsp_custom_cname: self.ocsp_custom_cname,
            }
        }
    }
}
impl OcspConfiguration {
    /// Creates a new builder-style object to manufacture [`OcspConfiguration`](crate::model::OcspConfiguration)
    pub fn builder() -> crate::model::ocsp_configuration::Builder {
        crate::model::ocsp_configuration::Builder::default()
    }
}

/// <p>Contains configuration information for a certificate revocation list (CRL). Your
/// private certificate authority (CA) creates base CRLs. Delta CRLs are not supported. You
/// can enable CRLs for your new or an existing private CA by setting the <b>Enabled</b> parameter to <code>true</code>. Your private CA
/// writes CRLs to an S3 bucket that you specify in the <b>S3BucketName</b> parameter. You can hide the name of your bucket by
/// specifying a value for the <b>CustomCname</b> parameter. Your
/// private CA copies the CNAME or the S3 bucket name to the <b>CRL
/// Distribution Points</b> extension of each certificate it issues. Your S3
/// bucket policy must give write permission to ACM Private CA. </p>
/// <p>ACM Private CA assets that are stored in Amazon S3 can be protected with encryption.
/// For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption">Encrypting Your
/// CRLs</a>.</p>
/// <p>Your private CA uses the value in the <b>ExpirationInDays</b>
/// parameter to calculate the <b>nextUpdate</b> field in the CRL.
/// The CRL is refreshed at 1/2 the age of next update or when a certificate is revoked.
/// When a certificate is revoked, it is recorded in the next CRL that is generated and in
/// the next audit report. Only time valid certificates are listed in the CRL. Expired
/// certificates are not included.</p>
///
/// <p>A CRL is typically updated approximately 30 minutes after a certificate
/// is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts
/// every 15 minutes.</p>
///
/// <p>CRLs contain the following fields:</p>
/// <ul>
/// <li>
/// <p>
/// <b>Version</b>: The current version number defined
/// in RFC 5280 is V2. The integer value is 0x1. </p>
/// </li>
/// <li>
/// <p>
/// <b>Signature Algorithm</b>: The name of the
/// algorithm used to sign the CRL.</p>
/// </li>
/// <li>
/// <p>
/// <b>Issuer</b>: The X.500 distinguished name of your
/// private CA that issued the CRL.</p>
/// </li>
/// <li>
/// <p>
/// <b>Last Update</b>: The issue date and time of this
/// CRL.</p>
/// </li>
/// <li>
/// <p>
/// <b>Next Update</b>: The day and time by which the
/// next CRL will be issued.</p>
/// </li>
/// <li>
/// <p>
/// <b>Revoked Certificates</b>: List of revoked
/// certificates. Each list item contains the following information.</p>
/// <ul>
/// <li>
/// <p>
/// <b>Serial Number</b>: The serial number, in
/// hexadecimal format, of the revoked certificate.</p>
/// </li>
/// <li>
/// <p>
/// <b>Revocation Date</b>: Date and time the
/// certificate was revoked.</p>
/// </li>
/// <li>
/// <p>
/// <b>CRL Entry Extensions</b>: Optional
/// extensions for the CRL entry.</p>
/// <ul>
/// <li>
/// <p>
/// <b>X509v3 CRL Reason Code</b>:
/// Reason the certificate was revoked.</p>
/// </li>
/// </ul>
/// </li>
/// </ul>
/// </li>
/// <li>
/// <p>
/// <b>CRL Extensions</b>: Optional extensions for the
/// CRL.</p>
/// <ul>
/// <li>
/// <p>
/// <b>X509v3 Authority Key Identifier</b>:
/// Identifies the public key associated with the private key used to sign
/// the certificate.</p>
/// </li>
/// <li>
/// <p>
/// <b>X509v3 CRL Number:</b>: Decimal sequence
/// number for the CRL.</p>
/// </li>
/// </ul>
/// </li>
/// <li>
/// <p>
/// <b>Signature Algorithm</b>: Algorithm used by your
/// private CA to sign the CRL.</p>
/// </li>
/// <li>
/// <p>
/// <b>Signature Value</b>: Signature computed over the
/// CRL.</p>
/// </li>
/// </ul>
/// <p>Certificate revocation lists created by ACM Private CA are DER-encoded. You can use the
/// following OpenSSL command to list a CRL.</p>
/// <p>
/// <code>openssl crl -inform DER -text -in <i>crl_path</i>
/// -noout</code>
/// </p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html">Planning a certificate revocation list (CRL)</a>
/// in the <i>AWS Certificate Manager Private Certificate Authority (PCA) User Guide</i>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CrlConfiguration {
    /// <p>Boolean value that specifies whether certificate revocation lists (CRLs) are enabled.
    /// You can use this value to enable certificate revocation for a new CA when you call the
    /// <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action or for an existing CA when you call the
    /// <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> action. </p>
    pub enabled: std::option::Option<bool>,
    /// <p>Validity period of the CRL in days.</p>
    pub expiration_in_days: std::option::Option<i32>,
    /// <p>Name inserted into the certificate <b>CRL Distribution
    /// Points</b> extension that enables the use of an alias for the CRL
    /// distribution point. Use this value if you don't want the name of your S3 bucket to be
    /// public.</p>
    pub custom_cname: std::option::Option<std::string::String>,
    /// <p>Name of the S3 bucket that contains the CRL. If you do not provide a value for the
    /// <b>CustomCname</b> argument, the name of your S3 bucket
    /// is placed into the <b>CRL Distribution Points</b> extension of
    /// the issued certificate. You can change the name of your bucket by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> operation. You must specify a <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-policies">bucket
    /// policy</a> that allows ACM Private CA to write the CRL to your bucket.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>Determines whether the CRL will be publicly readable or privately held in the CRL
    /// Amazon S3 bucket. If you choose PUBLIC_READ, the CRL will be accessible over the public
    /// internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the owner of the CRL S3 bucket
    /// can access the CRL, and your PKI clients may need an alternative method of access. </p>
    /// <p>If no value is specified, the default is <code>PUBLIC_READ</code>.</p>
    /// <p>
    /// <i>Note:</i> This default can cause CA creation to fail in some
    /// circumstances. If you have have enabled the Block Public Access (BPA) feature in your S3
    /// account, then you must specify the value of this parameter as
    /// <code>BUCKET_OWNER_FULL_CONTROL</code>, and not doing so results in an error. If you
    /// have disabled BPA in S3, then you can specify either
    /// <code>BUCKET_OWNER_FULL_CONTROL</code> or <code>PUBLIC_READ</code> as the
    /// value.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-bpa">Blocking public access to the S3
    /// bucket</a>.</p>
    pub s3_object_acl: std::option::Option<crate::model::S3ObjectAcl>,
}
impl CrlConfiguration {
    /// <p>Boolean value that specifies whether certificate revocation lists (CRLs) are enabled.
    /// You can use this value to enable certificate revocation for a new CA when you call the
    /// <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action or for an existing CA when you call the
    /// <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> action. </p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>Validity period of the CRL in days.</p>
    pub fn expiration_in_days(&self) -> std::option::Option<i32> {
        self.expiration_in_days
    }
    /// <p>Name inserted into the certificate <b>CRL Distribution
    /// Points</b> extension that enables the use of an alias for the CRL
    /// distribution point. Use this value if you don't want the name of your S3 bucket to be
    /// public.</p>
    pub fn custom_cname(&self) -> std::option::Option<&str> {
        self.custom_cname.as_deref()
    }
    /// <p>Name of the S3 bucket that contains the CRL. If you do not provide a value for the
    /// <b>CustomCname</b> argument, the name of your S3 bucket
    /// is placed into the <b>CRL Distribution Points</b> extension of
    /// the issued certificate. You can change the name of your bucket by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> operation. You must specify a <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-policies">bucket
    /// policy</a> that allows ACM Private CA to write the CRL to your bucket.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>Determines whether the CRL will be publicly readable or privately held in the CRL
    /// Amazon S3 bucket. If you choose PUBLIC_READ, the CRL will be accessible over the public
    /// internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the owner of the CRL S3 bucket
    /// can access the CRL, and your PKI clients may need an alternative method of access. </p>
    /// <p>If no value is specified, the default is <code>PUBLIC_READ</code>.</p>
    /// <p>
    /// <i>Note:</i> This default can cause CA creation to fail in some
    /// circumstances. If you have have enabled the Block Public Access (BPA) feature in your S3
    /// account, then you must specify the value of this parameter as
    /// <code>BUCKET_OWNER_FULL_CONTROL</code>, and not doing so results in an error. If you
    /// have disabled BPA in S3, then you can specify either
    /// <code>BUCKET_OWNER_FULL_CONTROL</code> or <code>PUBLIC_READ</code> as the
    /// value.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-bpa">Blocking public access to the S3
    /// bucket</a>.</p>
    pub fn s3_object_acl(&self) -> std::option::Option<&crate::model::S3ObjectAcl> {
        self.s3_object_acl.as_ref()
    }
}
impl std::fmt::Debug for CrlConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CrlConfiguration");
        formatter.field("enabled", &self.enabled);
        formatter.field("expiration_in_days", &self.expiration_in_days);
        formatter.field("custom_cname", &self.custom_cname);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_object_acl", &self.s3_object_acl);
        formatter.finish()
    }
}
/// See [`CrlConfiguration`](crate::model::CrlConfiguration)
pub mod crl_configuration {
    /// A builder for [`CrlConfiguration`](crate::model::CrlConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) expiration_in_days: std::option::Option<i32>,
        pub(crate) custom_cname: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_object_acl: std::option::Option<crate::model::S3ObjectAcl>,
    }
    impl Builder {
        /// <p>Boolean value that specifies whether certificate revocation lists (CRLs) are enabled.
        /// You can use this value to enable certificate revocation for a new CA when you call the
        /// <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action or for an existing CA when you call the
        /// <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> action. </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Boolean value that specifies whether certificate revocation lists (CRLs) are enabled.
        /// You can use this value to enable certificate revocation for a new CA when you call the
        /// <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action or for an existing CA when you call the
        /// <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> action. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Validity period of the CRL in days.</p>
        pub fn expiration_in_days(mut self, input: i32) -> Self {
            self.expiration_in_days = Some(input);
            self
        }
        /// <p>Validity period of the CRL in days.</p>
        pub fn set_expiration_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.expiration_in_days = input;
            self
        }
        /// <p>Name inserted into the certificate <b>CRL Distribution
        /// Points</b> extension that enables the use of an alias for the CRL
        /// distribution point. Use this value if you don't want the name of your S3 bucket to be
        /// public.</p>
        pub fn custom_cname(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_cname = Some(input.into());
            self
        }
        /// <p>Name inserted into the certificate <b>CRL Distribution
        /// Points</b> extension that enables the use of an alias for the CRL
        /// distribution point. Use this value if you don't want the name of your S3 bucket to be
        /// public.</p>
        pub fn set_custom_cname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.custom_cname = input;
            self
        }
        /// <p>Name of the S3 bucket that contains the CRL. If you do not provide a value for the
        /// <b>CustomCname</b> argument, the name of your S3 bucket
        /// is placed into the <b>CRL Distribution Points</b> extension of
        /// the issued certificate. You can change the name of your bucket by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> operation. You must specify a <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-policies">bucket
        /// policy</a> that allows ACM Private CA to write the CRL to your bucket.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>Name of the S3 bucket that contains the CRL. If you do not provide a value for the
        /// <b>CustomCname</b> argument, the name of your S3 bucket
        /// is placed into the <b>CRL Distribution Points</b> extension of
        /// the issued certificate. You can change the name of your bucket by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> operation. You must specify a <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-policies">bucket
        /// policy</a> that allows ACM Private CA to write the CRL to your bucket.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>Determines whether the CRL will be publicly readable or privately held in the CRL
        /// Amazon S3 bucket. If you choose PUBLIC_READ, the CRL will be accessible over the public
        /// internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the owner of the CRL S3 bucket
        /// can access the CRL, and your PKI clients may need an alternative method of access. </p>
        /// <p>If no value is specified, the default is <code>PUBLIC_READ</code>.</p>
        /// <p>
        /// <i>Note:</i> This default can cause CA creation to fail in some
        /// circumstances. If you have have enabled the Block Public Access (BPA) feature in your S3
        /// account, then you must specify the value of this parameter as
        /// <code>BUCKET_OWNER_FULL_CONTROL</code>, and not doing so results in an error. If you
        /// have disabled BPA in S3, then you can specify either
        /// <code>BUCKET_OWNER_FULL_CONTROL</code> or <code>PUBLIC_READ</code> as the
        /// value.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-bpa">Blocking public access to the S3
        /// bucket</a>.</p>
        pub fn s3_object_acl(mut self, input: crate::model::S3ObjectAcl) -> Self {
            self.s3_object_acl = Some(input);
            self
        }
        /// <p>Determines whether the CRL will be publicly readable or privately held in the CRL
        /// Amazon S3 bucket. If you choose PUBLIC_READ, the CRL will be accessible over the public
        /// internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the owner of the CRL S3 bucket
        /// can access the CRL, and your PKI clients may need an alternative method of access. </p>
        /// <p>If no value is specified, the default is <code>PUBLIC_READ</code>.</p>
        /// <p>
        /// <i>Note:</i> This default can cause CA creation to fail in some
        /// circumstances. If you have have enabled the Block Public Access (BPA) feature in your S3
        /// account, then you must specify the value of this parameter as
        /// <code>BUCKET_OWNER_FULL_CONTROL</code>, and not doing so results in an error. If you
        /// have disabled BPA in S3, then you can specify either
        /// <code>BUCKET_OWNER_FULL_CONTROL</code> or <code>PUBLIC_READ</code> as the
        /// value.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-bpa">Blocking public access to the S3
        /// bucket</a>.</p>
        pub fn set_s3_object_acl(
            mut self,
            input: std::option::Option<crate::model::S3ObjectAcl>,
        ) -> Self {
            self.s3_object_acl = input;
            self
        }
        /// Consumes the builder and constructs a [`CrlConfiguration`](crate::model::CrlConfiguration)
        pub fn build(self) -> crate::model::CrlConfiguration {
            crate::model::CrlConfiguration {
                enabled: self.enabled,
                expiration_in_days: self.expiration_in_days,
                custom_cname: self.custom_cname,
                s3_bucket_name: self.s3_bucket_name,
                s3_object_acl: self.s3_object_acl,
            }
        }
    }
}
impl CrlConfiguration {
    /// Creates a new builder-style object to manufacture [`CrlConfiguration`](crate::model::CrlConfiguration)
    pub fn builder() -> crate::model::crl_configuration::Builder {
        crate::model::crl_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3ObjectAcl {
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerFullControl,
    #[allow(missing_docs)] // documentation missing in model
    PublicRead,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3ObjectAcl {
    fn from(s: &str) -> Self {
        match s {
            "BUCKET_OWNER_FULL_CONTROL" => S3ObjectAcl::BucketOwnerFullControl,
            "PUBLIC_READ" => S3ObjectAcl::PublicRead,
            other => S3ObjectAcl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3ObjectAcl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3ObjectAcl::from(s))
    }
}
impl S3ObjectAcl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3ObjectAcl::BucketOwnerFullControl => "BUCKET_OWNER_FULL_CONTROL",
            S3ObjectAcl::PublicRead => "PUBLIC_READ",
            S3ObjectAcl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BUCKET_OWNER_FULL_CONTROL", "PUBLIC_READ"]
    }
}
impl AsRef<str> for S3ObjectAcl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Tags are labels that you can use to identify and organize your private CAs. Each tag
/// consists of a key and an optional value. You can associate up to 50 tags with a private
/// CA. To add one or more tags to a private CA, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html">TagCertificateAuthority</a>
/// action. To remove a tag, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html">UntagCertificateAuthority</a> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>Key (name) of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>Key (name) of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Key (name) of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Key (name) of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RevocationReason {
    #[allow(missing_docs)] // documentation missing in model
    AffiliationChanged,
    #[allow(missing_docs)] // documentation missing in model
    AACompromise,
    #[allow(missing_docs)] // documentation missing in model
    CertificateAuthorityCompromise,
    #[allow(missing_docs)] // documentation missing in model
    CessationOfOperation,
    #[allow(missing_docs)] // documentation missing in model
    KeyCompromise,
    #[allow(missing_docs)] // documentation missing in model
    PrivilegeWithdrawn,
    #[allow(missing_docs)] // documentation missing in model
    Superseded,
    #[allow(missing_docs)] // documentation missing in model
    Unspecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RevocationReason {
    fn from(s: &str) -> Self {
        match s {
            "AFFILIATION_CHANGED" => RevocationReason::AffiliationChanged,
            "A_A_COMPROMISE" => RevocationReason::AACompromise,
            "CERTIFICATE_AUTHORITY_COMPROMISE" => RevocationReason::CertificateAuthorityCompromise,
            "CESSATION_OF_OPERATION" => RevocationReason::CessationOfOperation,
            "KEY_COMPROMISE" => RevocationReason::KeyCompromise,
            "PRIVILEGE_WITHDRAWN" => RevocationReason::PrivilegeWithdrawn,
            "SUPERSEDED" => RevocationReason::Superseded,
            "UNSPECIFIED" => RevocationReason::Unspecified,
            other => RevocationReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RevocationReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RevocationReason::from(s))
    }
}
impl RevocationReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RevocationReason::AffiliationChanged => "AFFILIATION_CHANGED",
            RevocationReason::AACompromise => "A_A_COMPROMISE",
            RevocationReason::CertificateAuthorityCompromise => "CERTIFICATE_AUTHORITY_COMPROMISE",
            RevocationReason::CessationOfOperation => "CESSATION_OF_OPERATION",
            RevocationReason::KeyCompromise => "KEY_COMPROMISE",
            RevocationReason::PrivilegeWithdrawn => "PRIVILEGE_WITHDRAWN",
            RevocationReason::Superseded => "SUPERSEDED",
            RevocationReason::Unspecified => "UNSPECIFIED",
            RevocationReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AFFILIATION_CHANGED",
            "A_A_COMPROMISE",
            "CERTIFICATE_AUTHORITY_COMPROMISE",
            "CESSATION_OF_OPERATION",
            "KEY_COMPROMISE",
            "PRIVILEGE_WITHDRAWN",
            "SUPERSEDED",
            "UNSPECIFIED",
        ]
    }
}
impl AsRef<str> for RevocationReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Permissions designate which private CA actions can be performed by an AWS service or
/// entity. In order for ACM to automatically renew private certificates, you must give
/// the ACM service principal all available permissions (<code>IssueCertificate</code>,
/// <code>GetCertificate</code>, and <code>ListPermissions</code>). Permissions can be
/// assigned with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html">CreatePermission</a> action,
/// removed with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html">DeletePermission</a> action, and
/// listed with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html">ListPermissions</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Permission {
    /// <p>The Amazon Resource Number (ARN) of the private CA from which the permission was
    /// issued.</p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the permission was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The AWS service or entity that holds the permission. At this time, the only valid
    /// principal is <code>acm.amazonaws.com</code>.</p>
    pub principal: std::option::Option<std::string::String>,
    /// <p>The ID of the account that assigned the permission.</p>
    pub source_account: std::option::Option<std::string::String>,
    /// <p>The private CA actions that can be performed by the designated AWS service.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::ActionType>>,
    /// <p>The name of the policy that is associated with the permission.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl Permission {
    /// <p>The Amazon Resource Number (ARN) of the private CA from which the permission was
    /// issued.</p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>The time at which the permission was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The AWS service or entity that holds the permission. At this time, the only valid
    /// principal is <code>acm.amazonaws.com</code>.</p>
    pub fn principal(&self) -> std::option::Option<&str> {
        self.principal.as_deref()
    }
    /// <p>The ID of the account that assigned the permission.</p>
    pub fn source_account(&self) -> std::option::Option<&str> {
        self.source_account.as_deref()
    }
    /// <p>The private CA actions that can be performed by the designated AWS service.</p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::ActionType]> {
        self.actions.as_deref()
    }
    /// <p>The name of the policy that is associated with the permission.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for Permission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Permission");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("principal", &self.principal);
        formatter.field("source_account", &self.source_account);
        formatter.field("actions", &self.actions);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`Permission`](crate::model::Permission)
pub mod permission {
    /// A builder for [`Permission`](crate::model::Permission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) source_account: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::ActionType>>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the private CA from which the permission was
        /// issued.</p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA from which the permission was
        /// issued.</p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>The time at which the permission was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the permission was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The AWS service or entity that holds the permission. At this time, the only valid
        /// principal is <code>acm.amazonaws.com</code>.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The AWS service or entity that holds the permission. At this time, the only valid
        /// principal is <code>acm.amazonaws.com</code>.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// <p>The ID of the account that assigned the permission.</p>
        pub fn source_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_account = Some(input.into());
            self
        }
        /// <p>The ID of the account that assigned the permission.</p>
        pub fn set_source_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_account = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The private CA actions that can be performed by the designated AWS service.</p>
        pub fn actions(mut self, input: impl Into<crate::model::ActionType>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The private CA actions that can be performed by the designated AWS service.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionType>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>The name of the policy that is associated with the permission.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The name of the policy that is associated with the permission.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`Permission`](crate::model::Permission)
        pub fn build(self) -> crate::model::Permission {
            crate::model::Permission {
                certificate_authority_arn: self.certificate_authority_arn,
                created_at: self.created_at,
                principal: self.principal,
                source_account: self.source_account,
                actions: self.actions,
                policy: self.policy,
            }
        }
    }
}
impl Permission {
    /// Creates a new builder-style object to manufacture [`Permission`](crate::model::Permission)
    pub fn builder() -> crate::model::permission::Builder {
        crate::model::permission::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionType {
    #[allow(missing_docs)] // documentation missing in model
    GetCertificate,
    #[allow(missing_docs)] // documentation missing in model
    IssueCertificate,
    #[allow(missing_docs)] // documentation missing in model
    ListPermissions,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionType {
    fn from(s: &str) -> Self {
        match s {
            "GetCertificate" => ActionType::GetCertificate,
            "IssueCertificate" => ActionType::IssueCertificate,
            "ListPermissions" => ActionType::ListPermissions,
            other => ActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionType::from(s))
    }
}
impl ActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionType::GetCertificate => "GetCertificate",
            ActionType::IssueCertificate => "IssueCertificate",
            ActionType::ListPermissions => "ListPermissions",
            ActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GetCertificate", "IssueCertificate", "ListPermissions"]
    }
}
impl AsRef<str> for ActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about your private certificate authority (CA). Your private CA
/// can issue and revoke X.509 digital certificates. Digital certificates verify that the
/// entity named in the certificate <b>Subject</b> field owns or
/// controls the public key contained in the <b>Subject Public Key
/// Info</b> field. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action to create your private CA. You must then
/// call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCertificate.html">GetCertificateAuthorityCertificate</a> action to retrieve a private CA
/// certificate signing request (CSR). Sign the CSR with your ACM Private CA-hosted or on-premises
/// root or subordinate CA certificate. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html">ImportCertificateAuthorityCertificate</a> action to import the signed
/// certificate into AWS Certificate Manager (ACM). </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateAuthority {
    /// <p>Amazon Resource Name (ARN) for your private certificate authority (CA). The format is
    /// <code>
    /// <i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The AWS account ID that owns the certificate authority.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>Date and time at which your private CA was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Date and time at which your private CA was last updated.</p>
    pub last_state_change_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Type of your private CA.</p>
    pub r#type: std::option::Option<crate::model::CertificateAuthorityType>,
    /// <p>Serial number of your private CA.</p>
    pub serial: std::option::Option<std::string::String>,
    /// <p>Status of your private CA.</p>
    pub status: std::option::Option<crate::model::CertificateAuthorityStatus>,
    /// <p>Date and time before which your private CA certificate is not valid.</p>
    pub not_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Date and time after which your private CA certificate is not valid.</p>
    pub not_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Reason the request to create your private CA failed.</p>
    pub failure_reason: std::option::Option<crate::model::FailureReason>,
    /// <p>Your private CA configuration.</p>
    pub certificate_authority_configuration:
        std::option::Option<crate::model::CertificateAuthorityConfiguration>,
    /// <p>Information about the Online Certificate Status Protocol (OCSP) configuration or
    /// certificate revocation list (CRL) created and maintained by your private CA. </p>
    pub revocation_configuration: std::option::Option<crate::model::RevocationConfiguration>,
    /// <p>The period during which a deleted CA can be restored. For more information, see the
    /// <code>PermanentDeletionTimeInDays</code> parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthorityRequest.html">DeleteCertificateAuthorityRequest</a> action. </p>
    pub restorable_until: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Defines a cryptographic key management compliance standard used for handling CA keys. </p>
    /// <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p>
    /// <p>Note: AWS Region ap-northeast-3 supports only FIPS_140_2_LEVEL_2_OR_HIGHER. You must
    /// explicitly specify this parameter and value when creating a CA in that Region.
    /// Specifying a different value (or no value) results in an
    /// <code>InvalidArgsException</code> with the message "A certificate authority cannot
    /// be created in this region with the specified security standard."</p>
    pub key_storage_security_standard:
        std::option::Option<crate::model::KeyStorageSecurityStandard>,
}
impl CertificateAuthority {
    /// <p>Amazon Resource Name (ARN) for your private certificate authority (CA). The format is
    /// <code>
    /// <i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The AWS account ID that owns the certificate authority.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>Date and time at which your private CA was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>Date and time at which your private CA was last updated.</p>
    pub fn last_state_change_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_state_change_at.as_ref()
    }
    /// <p>Type of your private CA.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::CertificateAuthorityType> {
        self.r#type.as_ref()
    }
    /// <p>Serial number of your private CA.</p>
    pub fn serial(&self) -> std::option::Option<&str> {
        self.serial.as_deref()
    }
    /// <p>Status of your private CA.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CertificateAuthorityStatus> {
        self.status.as_ref()
    }
    /// <p>Date and time before which your private CA certificate is not valid.</p>
    pub fn not_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.not_before.as_ref()
    }
    /// <p>Date and time after which your private CA certificate is not valid.</p>
    pub fn not_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.not_after.as_ref()
    }
    /// <p>Reason the request to create your private CA failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&crate::model::FailureReason> {
        self.failure_reason.as_ref()
    }
    /// <p>Your private CA configuration.</p>
    pub fn certificate_authority_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CertificateAuthorityConfiguration> {
        self.certificate_authority_configuration.as_ref()
    }
    /// <p>Information about the Online Certificate Status Protocol (OCSP) configuration or
    /// certificate revocation list (CRL) created and maintained by your private CA. </p>
    pub fn revocation_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RevocationConfiguration> {
        self.revocation_configuration.as_ref()
    }
    /// <p>The period during which a deleted CA can be restored. For more information, see the
    /// <code>PermanentDeletionTimeInDays</code> parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthorityRequest.html">DeleteCertificateAuthorityRequest</a> action. </p>
    pub fn restorable_until(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.restorable_until.as_ref()
    }
    /// <p>Defines a cryptographic key management compliance standard used for handling CA keys. </p>
    /// <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p>
    /// <p>Note: AWS Region ap-northeast-3 supports only FIPS_140_2_LEVEL_2_OR_HIGHER. You must
    /// explicitly specify this parameter and value when creating a CA in that Region.
    /// Specifying a different value (or no value) results in an
    /// <code>InvalidArgsException</code> with the message "A certificate authority cannot
    /// be created in this region with the specified security standard."</p>
    pub fn key_storage_security_standard(
        &self,
    ) -> std::option::Option<&crate::model::KeyStorageSecurityStandard> {
        self.key_storage_security_standard.as_ref()
    }
}
impl std::fmt::Debug for CertificateAuthority {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateAuthority");
        formatter.field("arn", &self.arn);
        formatter.field("owner_account", &self.owner_account);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_state_change_at", &self.last_state_change_at);
        formatter.field("r#type", &self.r#type);
        formatter.field("serial", &self.serial);
        formatter.field("status", &self.status);
        formatter.field("not_before", &self.not_before);
        formatter.field("not_after", &self.not_after);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field(
            "certificate_authority_configuration",
            &self.certificate_authority_configuration,
        );
        formatter.field("revocation_configuration", &self.revocation_configuration);
        formatter.field("restorable_until", &self.restorable_until);
        formatter.field(
            "key_storage_security_standard",
            &self.key_storage_security_standard,
        );
        formatter.finish()
    }
}
/// See [`CertificateAuthority`](crate::model::CertificateAuthority)
pub mod certificate_authority {
    /// A builder for [`CertificateAuthority`](crate::model::CertificateAuthority)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_state_change_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) r#type: std::option::Option<crate::model::CertificateAuthorityType>,
        pub(crate) serial: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CertificateAuthorityStatus>,
        pub(crate) not_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) not_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<crate::model::FailureReason>,
        pub(crate) certificate_authority_configuration:
            std::option::Option<crate::model::CertificateAuthorityConfiguration>,
        pub(crate) revocation_configuration:
            std::option::Option<crate::model::RevocationConfiguration>,
        pub(crate) restorable_until: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) key_storage_security_standard:
            std::option::Option<crate::model::KeyStorageSecurityStandard>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) for your private certificate authority (CA). The format is
        /// <code>
        /// <i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) for your private certificate authority (CA). The format is
        /// <code>
        /// <i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The AWS account ID that owns the certificate authority.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The AWS account ID that owns the certificate authority.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>Date and time at which your private CA was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>Date and time at which your private CA was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Date and time at which your private CA was last updated.</p>
        pub fn last_state_change_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_state_change_at = Some(input);
            self
        }
        /// <p>Date and time at which your private CA was last updated.</p>
        pub fn set_last_state_change_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_state_change_at = input;
            self
        }
        /// <p>Type of your private CA.</p>
        pub fn r#type(mut self, input: crate::model::CertificateAuthorityType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Type of your private CA.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CertificateAuthorityType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Serial number of your private CA.</p>
        pub fn serial(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial = Some(input.into());
            self
        }
        /// <p>Serial number of your private CA.</p>
        pub fn set_serial(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.serial = input;
            self
        }
        /// <p>Status of your private CA.</p>
        pub fn status(mut self, input: crate::model::CertificateAuthorityStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of your private CA.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CertificateAuthorityStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Date and time before which your private CA certificate is not valid.</p>
        pub fn not_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.not_before = Some(input);
            self
        }
        /// <p>Date and time before which your private CA certificate is not valid.</p>
        pub fn set_not_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.not_before = input;
            self
        }
        /// <p>Date and time after which your private CA certificate is not valid.</p>
        pub fn not_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.not_after = Some(input);
            self
        }
        /// <p>Date and time after which your private CA certificate is not valid.</p>
        pub fn set_not_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.not_after = input;
            self
        }
        /// <p>Reason the request to create your private CA failed.</p>
        pub fn failure_reason(mut self, input: crate::model::FailureReason) -> Self {
            self.failure_reason = Some(input);
            self
        }
        /// <p>Reason the request to create your private CA failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<crate::model::FailureReason>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>Your private CA configuration.</p>
        pub fn certificate_authority_configuration(
            mut self,
            input: crate::model::CertificateAuthorityConfiguration,
        ) -> Self {
            self.certificate_authority_configuration = Some(input);
            self
        }
        /// <p>Your private CA configuration.</p>
        pub fn set_certificate_authority_configuration(
            mut self,
            input: std::option::Option<crate::model::CertificateAuthorityConfiguration>,
        ) -> Self {
            self.certificate_authority_configuration = input;
            self
        }
        /// <p>Information about the Online Certificate Status Protocol (OCSP) configuration or
        /// certificate revocation list (CRL) created and maintained by your private CA. </p>
        pub fn revocation_configuration(
            mut self,
            input: crate::model::RevocationConfiguration,
        ) -> Self {
            self.revocation_configuration = Some(input);
            self
        }
        /// <p>Information about the Online Certificate Status Protocol (OCSP) configuration or
        /// certificate revocation list (CRL) created and maintained by your private CA. </p>
        pub fn set_revocation_configuration(
            mut self,
            input: std::option::Option<crate::model::RevocationConfiguration>,
        ) -> Self {
            self.revocation_configuration = input;
            self
        }
        /// <p>The period during which a deleted CA can be restored. For more information, see the
        /// <code>PermanentDeletionTimeInDays</code> parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthorityRequest.html">DeleteCertificateAuthorityRequest</a> action. </p>
        pub fn restorable_until(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.restorable_until = Some(input);
            self
        }
        /// <p>The period during which a deleted CA can be restored. For more information, see the
        /// <code>PermanentDeletionTimeInDays</code> parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthorityRequest.html">DeleteCertificateAuthorityRequest</a> action. </p>
        pub fn set_restorable_until(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.restorable_until = input;
            self
        }
        /// <p>Defines a cryptographic key management compliance standard used for handling CA keys. </p>
        /// <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p>
        /// <p>Note: AWS Region ap-northeast-3 supports only FIPS_140_2_LEVEL_2_OR_HIGHER. You must
        /// explicitly specify this parameter and value when creating a CA in that Region.
        /// Specifying a different value (or no value) results in an
        /// <code>InvalidArgsException</code> with the message "A certificate authority cannot
        /// be created in this region with the specified security standard."</p>
        pub fn key_storage_security_standard(
            mut self,
            input: crate::model::KeyStorageSecurityStandard,
        ) -> Self {
            self.key_storage_security_standard = Some(input);
            self
        }
        /// <p>Defines a cryptographic key management compliance standard used for handling CA keys. </p>
        /// <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p>
        /// <p>Note: AWS Region ap-northeast-3 supports only FIPS_140_2_LEVEL_2_OR_HIGHER. You must
        /// explicitly specify this parameter and value when creating a CA in that Region.
        /// Specifying a different value (or no value) results in an
        /// <code>InvalidArgsException</code> with the message "A certificate authority cannot
        /// be created in this region with the specified security standard."</p>
        pub fn set_key_storage_security_standard(
            mut self,
            input: std::option::Option<crate::model::KeyStorageSecurityStandard>,
        ) -> Self {
            self.key_storage_security_standard = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateAuthority`](crate::model::CertificateAuthority)
        pub fn build(self) -> crate::model::CertificateAuthority {
            crate::model::CertificateAuthority {
                arn: self.arn,
                owner_account: self.owner_account,
                created_at: self.created_at,
                last_state_change_at: self.last_state_change_at,
                r#type: self.r#type,
                serial: self.serial,
                status: self.status,
                not_before: self.not_before,
                not_after: self.not_after,
                failure_reason: self.failure_reason,
                certificate_authority_configuration: self.certificate_authority_configuration,
                revocation_configuration: self.revocation_configuration,
                restorable_until: self.restorable_until,
                key_storage_security_standard: self.key_storage_security_standard,
            }
        }
    }
}
impl CertificateAuthority {
    /// Creates a new builder-style object to manufacture [`CertificateAuthority`](crate::model::CertificateAuthority)
    pub fn builder() -> crate::model::certificate_authority::Builder {
        crate::model::certificate_authority::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeyStorageSecurityStandard {
    #[allow(missing_docs)] // documentation missing in model
    Fips1402Level2OrHigher,
    #[allow(missing_docs)] // documentation missing in model
    Fips1402Level3OrHigher,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeyStorageSecurityStandard {
    fn from(s: &str) -> Self {
        match s {
            "FIPS_140_2_LEVEL_2_OR_HIGHER" => KeyStorageSecurityStandard::Fips1402Level2OrHigher,
            "FIPS_140_2_LEVEL_3_OR_HIGHER" => KeyStorageSecurityStandard::Fips1402Level3OrHigher,
            other => KeyStorageSecurityStandard::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeyStorageSecurityStandard {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeyStorageSecurityStandard::from(s))
    }
}
impl KeyStorageSecurityStandard {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeyStorageSecurityStandard::Fips1402Level2OrHigher => "FIPS_140_2_LEVEL_2_OR_HIGHER",
            KeyStorageSecurityStandard::Fips1402Level3OrHigher => "FIPS_140_2_LEVEL_3_OR_HIGHER",
            KeyStorageSecurityStandard::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FIPS_140_2_LEVEL_2_OR_HIGHER",
            "FIPS_140_2_LEVEL_3_OR_HIGHER",
        ]
    }
}
impl AsRef<str> for KeyStorageSecurityStandard {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains configuration information for your private certificate authority (CA). This
/// includes information about the class of public key algorithm and the key pair that your
/// private CA creates when it issues a certificate. It also includes the signature
/// algorithm that it uses when issuing certificates, and its X.500 distinguished name. You
/// must specify this information when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateAuthorityConfiguration {
    /// <p>Type of the public key algorithm and size, in bits, of the key pair that your CA
    /// creates when it issues a certificate. When you create a subordinate CA, you must use a
    /// key algorithm supported by the parent CA.</p>
    pub key_algorithm: std::option::Option<crate::model::KeyAlgorithm>,
    /// <p>Name of the algorithm your private CA uses to sign certificate requests.</p>
    /// <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter
    /// used to sign certificates when they are issued.</p>
    pub signing_algorithm: std::option::Option<crate::model::SigningAlgorithm>,
    /// <p>Structure that contains X.500 distinguished name information for your private
    /// CA.</p>
    pub subject: std::option::Option<crate::model::Asn1Subject>,
    /// <p>Specifies information to be added to the extension section of the certificate signing
    /// request (CSR).</p>
    pub csr_extensions: std::option::Option<crate::model::CsrExtensions>,
}
impl CertificateAuthorityConfiguration {
    /// <p>Type of the public key algorithm and size, in bits, of the key pair that your CA
    /// creates when it issues a certificate. When you create a subordinate CA, you must use a
    /// key algorithm supported by the parent CA.</p>
    pub fn key_algorithm(&self) -> std::option::Option<&crate::model::KeyAlgorithm> {
        self.key_algorithm.as_ref()
    }
    /// <p>Name of the algorithm your private CA uses to sign certificate requests.</p>
    /// <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter
    /// used to sign certificates when they are issued.</p>
    pub fn signing_algorithm(&self) -> std::option::Option<&crate::model::SigningAlgorithm> {
        self.signing_algorithm.as_ref()
    }
    /// <p>Structure that contains X.500 distinguished name information for your private
    /// CA.</p>
    pub fn subject(&self) -> std::option::Option<&crate::model::Asn1Subject> {
        self.subject.as_ref()
    }
    /// <p>Specifies information to be added to the extension section of the certificate signing
    /// request (CSR).</p>
    pub fn csr_extensions(&self) -> std::option::Option<&crate::model::CsrExtensions> {
        self.csr_extensions.as_ref()
    }
}
impl std::fmt::Debug for CertificateAuthorityConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateAuthorityConfiguration");
        formatter.field("key_algorithm", &self.key_algorithm);
        formatter.field("signing_algorithm", &self.signing_algorithm);
        formatter.field("subject", &self.subject);
        formatter.field("csr_extensions", &self.csr_extensions);
        formatter.finish()
    }
}
/// See [`CertificateAuthorityConfiguration`](crate::model::CertificateAuthorityConfiguration)
pub mod certificate_authority_configuration {
    /// A builder for [`CertificateAuthorityConfiguration`](crate::model::CertificateAuthorityConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_algorithm: std::option::Option<crate::model::KeyAlgorithm>,
        pub(crate) signing_algorithm: std::option::Option<crate::model::SigningAlgorithm>,
        pub(crate) subject: std::option::Option<crate::model::Asn1Subject>,
        pub(crate) csr_extensions: std::option::Option<crate::model::CsrExtensions>,
    }
    impl Builder {
        /// <p>Type of the public key algorithm and size, in bits, of the key pair that your CA
        /// creates when it issues a certificate. When you create a subordinate CA, you must use a
        /// key algorithm supported by the parent CA.</p>
        pub fn key_algorithm(mut self, input: crate::model::KeyAlgorithm) -> Self {
            self.key_algorithm = Some(input);
            self
        }
        /// <p>Type of the public key algorithm and size, in bits, of the key pair that your CA
        /// creates when it issues a certificate. When you create a subordinate CA, you must use a
        /// key algorithm supported by the parent CA.</p>
        pub fn set_key_algorithm(
            mut self,
            input: std::option::Option<crate::model::KeyAlgorithm>,
        ) -> Self {
            self.key_algorithm = input;
            self
        }
        /// <p>Name of the algorithm your private CA uses to sign certificate requests.</p>
        /// <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter
        /// used to sign certificates when they are issued.</p>
        pub fn signing_algorithm(mut self, input: crate::model::SigningAlgorithm) -> Self {
            self.signing_algorithm = Some(input);
            self
        }
        /// <p>Name of the algorithm your private CA uses to sign certificate requests.</p>
        /// <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter
        /// used to sign certificates when they are issued.</p>
        pub fn set_signing_algorithm(
            mut self,
            input: std::option::Option<crate::model::SigningAlgorithm>,
        ) -> Self {
            self.signing_algorithm = input;
            self
        }
        /// <p>Structure that contains X.500 distinguished name information for your private
        /// CA.</p>
        pub fn subject(mut self, input: crate::model::Asn1Subject) -> Self {
            self.subject = Some(input);
            self
        }
        /// <p>Structure that contains X.500 distinguished name information for your private
        /// CA.</p>
        pub fn set_subject(
            mut self,
            input: std::option::Option<crate::model::Asn1Subject>,
        ) -> Self {
            self.subject = input;
            self
        }
        /// <p>Specifies information to be added to the extension section of the certificate signing
        /// request (CSR).</p>
        pub fn csr_extensions(mut self, input: crate::model::CsrExtensions) -> Self {
            self.csr_extensions = Some(input);
            self
        }
        /// <p>Specifies information to be added to the extension section of the certificate signing
        /// request (CSR).</p>
        pub fn set_csr_extensions(
            mut self,
            input: std::option::Option<crate::model::CsrExtensions>,
        ) -> Self {
            self.csr_extensions = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateAuthorityConfiguration`](crate::model::CertificateAuthorityConfiguration)
        pub fn build(self) -> crate::model::CertificateAuthorityConfiguration {
            crate::model::CertificateAuthorityConfiguration {
                key_algorithm: self.key_algorithm,
                signing_algorithm: self.signing_algorithm,
                subject: self.subject,
                csr_extensions: self.csr_extensions,
            }
        }
    }
}
impl CertificateAuthorityConfiguration {
    /// Creates a new builder-style object to manufacture [`CertificateAuthorityConfiguration`](crate::model::CertificateAuthorityConfiguration)
    pub fn builder() -> crate::model::certificate_authority_configuration::Builder {
        crate::model::certificate_authority_configuration::Builder::default()
    }
}

/// <p>Describes the certificate extensions to be added to the certificate signing request
/// (CSR).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CsrExtensions {
    /// <p>Indicates the purpose of the certificate and of the key contained in the
    /// certificate.</p>
    pub key_usage: std::option::Option<crate::model::KeyUsage>,
    /// <p>For CA certificates, provides a path to additional information pertaining to the CA,
    /// such as revocation and policy. For more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.2.2.2">Subject Information
    /// Access</a> in RFC 5280.</p>
    pub subject_information_access:
        std::option::Option<std::vec::Vec<crate::model::AccessDescription>>,
}
impl CsrExtensions {
    /// <p>Indicates the purpose of the certificate and of the key contained in the
    /// certificate.</p>
    pub fn key_usage(&self) -> std::option::Option<&crate::model::KeyUsage> {
        self.key_usage.as_ref()
    }
    /// <p>For CA certificates, provides a path to additional information pertaining to the CA,
    /// such as revocation and policy. For more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.2.2.2">Subject Information
    /// Access</a> in RFC 5280.</p>
    pub fn subject_information_access(
        &self,
    ) -> std::option::Option<&[crate::model::AccessDescription]> {
        self.subject_information_access.as_deref()
    }
}
impl std::fmt::Debug for CsrExtensions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CsrExtensions");
        formatter.field("key_usage", &self.key_usage);
        formatter.field(
            "subject_information_access",
            &self.subject_information_access,
        );
        formatter.finish()
    }
}
/// See [`CsrExtensions`](crate::model::CsrExtensions)
pub mod csr_extensions {
    /// A builder for [`CsrExtensions`](crate::model::CsrExtensions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_usage: std::option::Option<crate::model::KeyUsage>,
        pub(crate) subject_information_access:
            std::option::Option<std::vec::Vec<crate::model::AccessDescription>>,
    }
    impl Builder {
        /// <p>Indicates the purpose of the certificate and of the key contained in the
        /// certificate.</p>
        pub fn key_usage(mut self, input: crate::model::KeyUsage) -> Self {
            self.key_usage = Some(input);
            self
        }
        /// <p>Indicates the purpose of the certificate and of the key contained in the
        /// certificate.</p>
        pub fn set_key_usage(mut self, input: std::option::Option<crate::model::KeyUsage>) -> Self {
            self.key_usage = input;
            self
        }
        /// Appends an item to `subject_information_access`.
        ///
        /// To override the contents of this collection use [`set_subject_information_access`](Self::set_subject_information_access).
        ///
        /// <p>For CA certificates, provides a path to additional information pertaining to the CA,
        /// such as revocation and policy. For more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.2.2.2">Subject Information
        /// Access</a> in RFC 5280.</p>
        pub fn subject_information_access(
            mut self,
            input: impl Into<crate::model::AccessDescription>,
        ) -> Self {
            let mut v = self.subject_information_access.unwrap_or_default();
            v.push(input.into());
            self.subject_information_access = Some(v);
            self
        }
        /// <p>For CA certificates, provides a path to additional information pertaining to the CA,
        /// such as revocation and policy. For more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.2.2.2">Subject Information
        /// Access</a> in RFC 5280.</p>
        pub fn set_subject_information_access(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessDescription>>,
        ) -> Self {
            self.subject_information_access = input;
            self
        }
        /// Consumes the builder and constructs a [`CsrExtensions`](crate::model::CsrExtensions)
        pub fn build(self) -> crate::model::CsrExtensions {
            crate::model::CsrExtensions {
                key_usage: self.key_usage,
                subject_information_access: self.subject_information_access,
            }
        }
    }
}
impl CsrExtensions {
    /// Creates a new builder-style object to manufacture [`CsrExtensions`](crate::model::CsrExtensions)
    pub fn builder() -> crate::model::csr_extensions::Builder {
        crate::model::csr_extensions::Builder::default()
    }
}

/// <p>Provides access information used by the <code>authorityInfoAccess</code> and
/// <code>subjectInfoAccess</code> extensions described in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDescription {
    /// <p>The type and format of <code>AccessDescription</code> information.</p>
    pub access_method: std::option::Option<crate::model::AccessMethod>,
    /// <p>The location of <code>AccessDescription</code> information.</p>
    pub access_location: std::option::Option<crate::model::GeneralName>,
}
impl AccessDescription {
    /// <p>The type and format of <code>AccessDescription</code> information.</p>
    pub fn access_method(&self) -> std::option::Option<&crate::model::AccessMethod> {
        self.access_method.as_ref()
    }
    /// <p>The location of <code>AccessDescription</code> information.</p>
    pub fn access_location(&self) -> std::option::Option<&crate::model::GeneralName> {
        self.access_location.as_ref()
    }
}
impl std::fmt::Debug for AccessDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDescription");
        formatter.field("access_method", &self.access_method);
        formatter.field("access_location", &self.access_location);
        formatter.finish()
    }
}
/// See [`AccessDescription`](crate::model::AccessDescription)
pub mod access_description {
    /// A builder for [`AccessDescription`](crate::model::AccessDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_method: std::option::Option<crate::model::AccessMethod>,
        pub(crate) access_location: std::option::Option<crate::model::GeneralName>,
    }
    impl Builder {
        /// <p>The type and format of <code>AccessDescription</code> information.</p>
        pub fn access_method(mut self, input: crate::model::AccessMethod) -> Self {
            self.access_method = Some(input);
            self
        }
        /// <p>The type and format of <code>AccessDescription</code> information.</p>
        pub fn set_access_method(
            mut self,
            input: std::option::Option<crate::model::AccessMethod>,
        ) -> Self {
            self.access_method = input;
            self
        }
        /// <p>The location of <code>AccessDescription</code> information.</p>
        pub fn access_location(mut self, input: crate::model::GeneralName) -> Self {
            self.access_location = Some(input);
            self
        }
        /// <p>The location of <code>AccessDescription</code> information.</p>
        pub fn set_access_location(
            mut self,
            input: std::option::Option<crate::model::GeneralName>,
        ) -> Self {
            self.access_location = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDescription`](crate::model::AccessDescription)
        pub fn build(self) -> crate::model::AccessDescription {
            crate::model::AccessDescription {
                access_method: self.access_method,
                access_location: self.access_location,
            }
        }
    }
}
impl AccessDescription {
    /// Creates a new builder-style object to manufacture [`AccessDescription`](crate::model::AccessDescription)
    pub fn builder() -> crate::model::access_description::Builder {
        crate::model::access_description::Builder::default()
    }
}

/// <p>Describes an ASN.1 X.400 <code>GeneralName</code> as defined in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280</a>. Only one of the
/// following naming options should be provided. Providing more than one option results in
/// an <code>InvalidArgsException</code> error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeneralName {
    /// <p>Represents <code>GeneralName</code> using an <code>OtherName</code> object.</p>
    pub other_name: std::option::Option<crate::model::OtherName>,
    /// <p>Represents <code>GeneralName</code> as an <a href="https://tools.ietf.org/html/rfc822">RFC 822</a> email address.</p>
    pub rfc822_name: std::option::Option<std::string::String>,
    /// <p>Represents <code>GeneralName</code> as a DNS name.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>Contains information about the certificate subject. The <code>Subject</code> field in
    /// the certificate identifies the entity that owns or controls the public key in the
    /// certificate. The entity can be a user, computer, device, or service. The <code>Subject
    /// </code>must contain an X.500 distinguished name (DN). A DN is a sequence of relative
    /// distinguished names (RDNs). The RDNs are separated by commas in the certificate.</p>
    pub directory_name: std::option::Option<crate::model::Asn1Subject>,
    /// <p>Represents <code>GeneralName</code> as an <code>EdiPartyName</code> object.</p>
    pub edi_party_name: std::option::Option<crate::model::EdiPartyName>,
    /// <p>Represents <code>GeneralName</code> as a URI.</p>
    pub uniform_resource_identifier: std::option::Option<std::string::String>,
    /// <p>Represents <code>GeneralName</code> as an IPv4 or IPv6 address.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p> Represents <code>GeneralName</code> as an object identifier (OID).</p>
    pub registered_id: std::option::Option<std::string::String>,
}
impl GeneralName {
    /// <p>Represents <code>GeneralName</code> using an <code>OtherName</code> object.</p>
    pub fn other_name(&self) -> std::option::Option<&crate::model::OtherName> {
        self.other_name.as_ref()
    }
    /// <p>Represents <code>GeneralName</code> as an <a href="https://tools.ietf.org/html/rfc822">RFC 822</a> email address.</p>
    pub fn rfc822_name(&self) -> std::option::Option<&str> {
        self.rfc822_name.as_deref()
    }
    /// <p>Represents <code>GeneralName</code> as a DNS name.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>Contains information about the certificate subject. The <code>Subject</code> field in
    /// the certificate identifies the entity that owns or controls the public key in the
    /// certificate. The entity can be a user, computer, device, or service. The <code>Subject
    /// </code>must contain an X.500 distinguished name (DN). A DN is a sequence of relative
    /// distinguished names (RDNs). The RDNs are separated by commas in the certificate.</p>
    pub fn directory_name(&self) -> std::option::Option<&crate::model::Asn1Subject> {
        self.directory_name.as_ref()
    }
    /// <p>Represents <code>GeneralName</code> as an <code>EdiPartyName</code> object.</p>
    pub fn edi_party_name(&self) -> std::option::Option<&crate::model::EdiPartyName> {
        self.edi_party_name.as_ref()
    }
    /// <p>Represents <code>GeneralName</code> as a URI.</p>
    pub fn uniform_resource_identifier(&self) -> std::option::Option<&str> {
        self.uniform_resource_identifier.as_deref()
    }
    /// <p>Represents <code>GeneralName</code> as an IPv4 or IPv6 address.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p> Represents <code>GeneralName</code> as an object identifier (OID).</p>
    pub fn registered_id(&self) -> std::option::Option<&str> {
        self.registered_id.as_deref()
    }
}
impl std::fmt::Debug for GeneralName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeneralName");
        formatter.field("other_name", &self.other_name);
        formatter.field("rfc822_name", &self.rfc822_name);
        formatter.field("dns_name", &self.dns_name);
        formatter.field("directory_name", &self.directory_name);
        formatter.field("edi_party_name", &self.edi_party_name);
        formatter.field(
            "uniform_resource_identifier",
            &self.uniform_resource_identifier,
        );
        formatter.field("ip_address", &self.ip_address);
        formatter.field("registered_id", &self.registered_id);
        formatter.finish()
    }
}
/// See [`GeneralName`](crate::model::GeneralName)
pub mod general_name {
    /// A builder for [`GeneralName`](crate::model::GeneralName)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) other_name: std::option::Option<crate::model::OtherName>,
        pub(crate) rfc822_name: std::option::Option<std::string::String>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) directory_name: std::option::Option<crate::model::Asn1Subject>,
        pub(crate) edi_party_name: std::option::Option<crate::model::EdiPartyName>,
        pub(crate) uniform_resource_identifier: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) registered_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents <code>GeneralName</code> using an <code>OtherName</code> object.</p>
        pub fn other_name(mut self, input: crate::model::OtherName) -> Self {
            self.other_name = Some(input);
            self
        }
        /// <p>Represents <code>GeneralName</code> using an <code>OtherName</code> object.</p>
        pub fn set_other_name(
            mut self,
            input: std::option::Option<crate::model::OtherName>,
        ) -> Self {
            self.other_name = input;
            self
        }
        /// <p>Represents <code>GeneralName</code> as an <a href="https://tools.ietf.org/html/rfc822">RFC 822</a> email address.</p>
        pub fn rfc822_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rfc822_name = Some(input.into());
            self
        }
        /// <p>Represents <code>GeneralName</code> as an <a href="https://tools.ietf.org/html/rfc822">RFC 822</a> email address.</p>
        pub fn set_rfc822_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rfc822_name = input;
            self
        }
        /// <p>Represents <code>GeneralName</code> as a DNS name.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>Represents <code>GeneralName</code> as a DNS name.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>Contains information about the certificate subject. The <code>Subject</code> field in
        /// the certificate identifies the entity that owns or controls the public key in the
        /// certificate. The entity can be a user, computer, device, or service. The <code>Subject
        /// </code>must contain an X.500 distinguished name (DN). A DN is a sequence of relative
        /// distinguished names (RDNs). The RDNs are separated by commas in the certificate.</p>
        pub fn directory_name(mut self, input: crate::model::Asn1Subject) -> Self {
            self.directory_name = Some(input);
            self
        }
        /// <p>Contains information about the certificate subject. The <code>Subject</code> field in
        /// the certificate identifies the entity that owns or controls the public key in the
        /// certificate. The entity can be a user, computer, device, or service. The <code>Subject
        /// </code>must contain an X.500 distinguished name (DN). A DN is a sequence of relative
        /// distinguished names (RDNs). The RDNs are separated by commas in the certificate.</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<crate::model::Asn1Subject>,
        ) -> Self {
            self.directory_name = input;
            self
        }
        /// <p>Represents <code>GeneralName</code> as an <code>EdiPartyName</code> object.</p>
        pub fn edi_party_name(mut self, input: crate::model::EdiPartyName) -> Self {
            self.edi_party_name = Some(input);
            self
        }
        /// <p>Represents <code>GeneralName</code> as an <code>EdiPartyName</code> object.</p>
        pub fn set_edi_party_name(
            mut self,
            input: std::option::Option<crate::model::EdiPartyName>,
        ) -> Self {
            self.edi_party_name = input;
            self
        }
        /// <p>Represents <code>GeneralName</code> as a URI.</p>
        pub fn uniform_resource_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.uniform_resource_identifier = Some(input.into());
            self
        }
        /// <p>Represents <code>GeneralName</code> as a URI.</p>
        pub fn set_uniform_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.uniform_resource_identifier = input;
            self
        }
        /// <p>Represents <code>GeneralName</code> as an IPv4 or IPv6 address.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>Represents <code>GeneralName</code> as an IPv4 or IPv6 address.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p> Represents <code>GeneralName</code> as an object identifier (OID).</p>
        pub fn registered_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registered_id = Some(input.into());
            self
        }
        /// <p> Represents <code>GeneralName</code> as an object identifier (OID).</p>
        pub fn set_registered_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registered_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GeneralName`](crate::model::GeneralName)
        pub fn build(self) -> crate::model::GeneralName {
            crate::model::GeneralName {
                other_name: self.other_name,
                rfc822_name: self.rfc822_name,
                dns_name: self.dns_name,
                directory_name: self.directory_name,
                edi_party_name: self.edi_party_name,
                uniform_resource_identifier: self.uniform_resource_identifier,
                ip_address: self.ip_address,
                registered_id: self.registered_id,
            }
        }
    }
}
impl GeneralName {
    /// Creates a new builder-style object to manufacture [`GeneralName`](crate::model::GeneralName)
    pub fn builder() -> crate::model::general_name::Builder {
        crate::model::general_name::Builder::default()
    }
}

/// <p>Describes an Electronic Data Interchange (EDI) entity as described in as defined in
/// <a href="https://tools.ietf.org/html/rfc5280">Subject Alternative Name</a> in
/// RFC 5280.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EdiPartyName {
    /// <p>Specifies the party name.</p>
    pub party_name: std::option::Option<std::string::String>,
    /// <p>Specifies the name assigner.</p>
    pub name_assigner: std::option::Option<std::string::String>,
}
impl EdiPartyName {
    /// <p>Specifies the party name.</p>
    pub fn party_name(&self) -> std::option::Option<&str> {
        self.party_name.as_deref()
    }
    /// <p>Specifies the name assigner.</p>
    pub fn name_assigner(&self) -> std::option::Option<&str> {
        self.name_assigner.as_deref()
    }
}
impl std::fmt::Debug for EdiPartyName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EdiPartyName");
        formatter.field("party_name", &self.party_name);
        formatter.field("name_assigner", &self.name_assigner);
        formatter.finish()
    }
}
/// See [`EdiPartyName`](crate::model::EdiPartyName)
pub mod edi_party_name {
    /// A builder for [`EdiPartyName`](crate::model::EdiPartyName)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) party_name: std::option::Option<std::string::String>,
        pub(crate) name_assigner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the party name.</p>
        pub fn party_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.party_name = Some(input.into());
            self
        }
        /// <p>Specifies the party name.</p>
        pub fn set_party_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.party_name = input;
            self
        }
        /// <p>Specifies the name assigner.</p>
        pub fn name_assigner(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_assigner = Some(input.into());
            self
        }
        /// <p>Specifies the name assigner.</p>
        pub fn set_name_assigner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_assigner = input;
            self
        }
        /// Consumes the builder and constructs a [`EdiPartyName`](crate::model::EdiPartyName)
        pub fn build(self) -> crate::model::EdiPartyName {
            crate::model::EdiPartyName {
                party_name: self.party_name,
                name_assigner: self.name_assigner,
            }
        }
    }
}
impl EdiPartyName {
    /// Creates a new builder-style object to manufacture [`EdiPartyName`](crate::model::EdiPartyName)
    pub fn builder() -> crate::model::edi_party_name::Builder {
        crate::model::edi_party_name::Builder::default()
    }
}

/// <p>Contains information about the certificate subject. The <code>Subject</code> field in
/// the certificate identifies the entity that owns or controls the public key in the
/// certificate. The entity can be a user, computer, device, or service. The <code>Subject
/// </code>must contain an X.500 distinguished name (DN). A DN is a sequence of relative
/// distinguished names (RDNs). The RDNs are separated by commas in the certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Asn1Subject {
    /// <p>Two-digit code that specifies the country in which the certificate subject
    /// located.</p>
    pub country: std::option::Option<std::string::String>,
    /// <p>Legal name of the organization with which the certificate subject is affiliated.
    /// </p>
    pub organization: std::option::Option<std::string::String>,
    /// <p>A subdivision or unit of the organization (such as sales or finance) with which the
    /// certificate subject is affiliated.</p>
    pub organizational_unit: std::option::Option<std::string::String>,
    /// <p>Disambiguating information for the certificate subject.</p>
    pub distinguished_name_qualifier: std::option::Option<std::string::String>,
    /// <p>State in which the subject of the certificate is located.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>For CA and end-entity certificates in a private PKI, the common name (CN) can be any
    /// string within the length limit. </p>
    /// <p>Note: In publicly trusted certificates, the common name must be a fully qualified
    /// domain name (FQDN) associated with the certificate subject.</p>
    pub common_name: std::option::Option<std::string::String>,
    /// <p>The certificate serial number.</p>
    pub serial_number: std::option::Option<std::string::String>,
    /// <p>The locality (such as a city or town) in which the certificate subject is
    /// located.</p>
    pub locality: std::option::Option<std::string::String>,
    /// <p>A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the
    /// certificate subject.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>Family name. In the US and the UK, for example, the surname of an individual is
    /// ordered last. In Asian cultures the surname is typically ordered first.</p>
    pub surname: std::option::Option<std::string::String>,
    /// <p>First name.</p>
    pub given_name: std::option::Option<std::string::String>,
    /// <p>Concatenation that typically contains the first letter of the <b>GivenName</b>, the first letter of the middle name if one exists, and the
    /// first letter of the <b>Surname</b>.</p>
    pub initials: std::option::Option<std::string::String>,
    /// <p>Typically a shortened version of a longer <b>GivenName</b>.
    /// For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth,
    /// Liz, or Eliza.</p>
    pub pseudonym: std::option::Option<std::string::String>,
    /// <p>Typically a qualifier appended to the name of an individual. Examples include Jr. for
    /// junior, Sr. for senior, and III for third.</p>
    pub generation_qualifier: std::option::Option<std::string::String>,
}
impl Asn1Subject {
    /// <p>Two-digit code that specifies the country in which the certificate subject
    /// located.</p>
    pub fn country(&self) -> std::option::Option<&str> {
        self.country.as_deref()
    }
    /// <p>Legal name of the organization with which the certificate subject is affiliated.
    /// </p>
    pub fn organization(&self) -> std::option::Option<&str> {
        self.organization.as_deref()
    }
    /// <p>A subdivision or unit of the organization (such as sales or finance) with which the
    /// certificate subject is affiliated.</p>
    pub fn organizational_unit(&self) -> std::option::Option<&str> {
        self.organizational_unit.as_deref()
    }
    /// <p>Disambiguating information for the certificate subject.</p>
    pub fn distinguished_name_qualifier(&self) -> std::option::Option<&str> {
        self.distinguished_name_qualifier.as_deref()
    }
    /// <p>State in which the subject of the certificate is located.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>For CA and end-entity certificates in a private PKI, the common name (CN) can be any
    /// string within the length limit. </p>
    /// <p>Note: In publicly trusted certificates, the common name must be a fully qualified
    /// domain name (FQDN) associated with the certificate subject.</p>
    pub fn common_name(&self) -> std::option::Option<&str> {
        self.common_name.as_deref()
    }
    /// <p>The certificate serial number.</p>
    pub fn serial_number(&self) -> std::option::Option<&str> {
        self.serial_number.as_deref()
    }
    /// <p>The locality (such as a city or town) in which the certificate subject is
    /// located.</p>
    pub fn locality(&self) -> std::option::Option<&str> {
        self.locality.as_deref()
    }
    /// <p>A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the
    /// certificate subject.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>Family name. In the US and the UK, for example, the surname of an individual is
    /// ordered last. In Asian cultures the surname is typically ordered first.</p>
    pub fn surname(&self) -> std::option::Option<&str> {
        self.surname.as_deref()
    }
    /// <p>First name.</p>
    pub fn given_name(&self) -> std::option::Option<&str> {
        self.given_name.as_deref()
    }
    /// <p>Concatenation that typically contains the first letter of the <b>GivenName</b>, the first letter of the middle name if one exists, and the
    /// first letter of the <b>Surname</b>.</p>
    pub fn initials(&self) -> std::option::Option<&str> {
        self.initials.as_deref()
    }
    /// <p>Typically a shortened version of a longer <b>GivenName</b>.
    /// For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth,
    /// Liz, or Eliza.</p>
    pub fn pseudonym(&self) -> std::option::Option<&str> {
        self.pseudonym.as_deref()
    }
    /// <p>Typically a qualifier appended to the name of an individual. Examples include Jr. for
    /// junior, Sr. for senior, and III for third.</p>
    pub fn generation_qualifier(&self) -> std::option::Option<&str> {
        self.generation_qualifier.as_deref()
    }
}
impl std::fmt::Debug for Asn1Subject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Asn1Subject");
        formatter.field("country", &self.country);
        formatter.field("organization", &self.organization);
        formatter.field("organizational_unit", &self.organizational_unit);
        formatter.field(
            "distinguished_name_qualifier",
            &self.distinguished_name_qualifier,
        );
        formatter.field("state", &self.state);
        formatter.field("common_name", &self.common_name);
        formatter.field("serial_number", &self.serial_number);
        formatter.field("locality", &self.locality);
        formatter.field("title", &self.title);
        formatter.field("surname", &self.surname);
        formatter.field("given_name", &self.given_name);
        formatter.field("initials", &self.initials);
        formatter.field("pseudonym", &self.pseudonym);
        formatter.field("generation_qualifier", &self.generation_qualifier);
        formatter.finish()
    }
}
/// See [`Asn1Subject`](crate::model::Asn1Subject)
pub mod asn1_subject {
    /// A builder for [`Asn1Subject`](crate::model::Asn1Subject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) country: std::option::Option<std::string::String>,
        pub(crate) organization: std::option::Option<std::string::String>,
        pub(crate) organizational_unit: std::option::Option<std::string::String>,
        pub(crate) distinguished_name_qualifier: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) common_name: std::option::Option<std::string::String>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) locality: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) surname: std::option::Option<std::string::String>,
        pub(crate) given_name: std::option::Option<std::string::String>,
        pub(crate) initials: std::option::Option<std::string::String>,
        pub(crate) pseudonym: std::option::Option<std::string::String>,
        pub(crate) generation_qualifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Two-digit code that specifies the country in which the certificate subject
        /// located.</p>
        pub fn country(mut self, input: impl Into<std::string::String>) -> Self {
            self.country = Some(input.into());
            self
        }
        /// <p>Two-digit code that specifies the country in which the certificate subject
        /// located.</p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country = input;
            self
        }
        /// <p>Legal name of the organization with which the certificate subject is affiliated.
        /// </p>
        pub fn organization(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization = Some(input.into());
            self
        }
        /// <p>Legal name of the organization with which the certificate subject is affiliated.
        /// </p>
        pub fn set_organization(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.organization = input;
            self
        }
        /// <p>A subdivision or unit of the organization (such as sales or finance) with which the
        /// certificate subject is affiliated.</p>
        pub fn organizational_unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.organizational_unit = Some(input.into());
            self
        }
        /// <p>A subdivision or unit of the organization (such as sales or finance) with which the
        /// certificate subject is affiliated.</p>
        pub fn set_organizational_unit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit = input;
            self
        }
        /// <p>Disambiguating information for the certificate subject.</p>
        pub fn distinguished_name_qualifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distinguished_name_qualifier = Some(input.into());
            self
        }
        /// <p>Disambiguating information for the certificate subject.</p>
        pub fn set_distinguished_name_qualifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distinguished_name_qualifier = input;
            self
        }
        /// <p>State in which the subject of the certificate is located.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>State in which the subject of the certificate is located.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>For CA and end-entity certificates in a private PKI, the common name (CN) can be any
        /// string within the length limit. </p>
        /// <p>Note: In publicly trusted certificates, the common name must be a fully qualified
        /// domain name (FQDN) associated with the certificate subject.</p>
        pub fn common_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.common_name = Some(input.into());
            self
        }
        /// <p>For CA and end-entity certificates in a private PKI, the common name (CN) can be any
        /// string within the length limit. </p>
        /// <p>Note: In publicly trusted certificates, the common name must be a fully qualified
        /// domain name (FQDN) associated with the certificate subject.</p>
        pub fn set_common_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.common_name = input;
            self
        }
        /// <p>The certificate serial number.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The certificate serial number.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// <p>The locality (such as a city or town) in which the certificate subject is
        /// located.</p>
        pub fn locality(mut self, input: impl Into<std::string::String>) -> Self {
            self.locality = Some(input.into());
            self
        }
        /// <p>The locality (such as a city or town) in which the certificate subject is
        /// located.</p>
        pub fn set_locality(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locality = input;
            self
        }
        /// <p>A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the
        /// certificate subject.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the
        /// certificate subject.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>Family name. In the US and the UK, for example, the surname of an individual is
        /// ordered last. In Asian cultures the surname is typically ordered first.</p>
        pub fn surname(mut self, input: impl Into<std::string::String>) -> Self {
            self.surname = Some(input.into());
            self
        }
        /// <p>Family name. In the US and the UK, for example, the surname of an individual is
        /// ordered last. In Asian cultures the surname is typically ordered first.</p>
        pub fn set_surname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.surname = input;
            self
        }
        /// <p>First name.</p>
        pub fn given_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.given_name = Some(input.into());
            self
        }
        /// <p>First name.</p>
        pub fn set_given_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.given_name = input;
            self
        }
        /// <p>Concatenation that typically contains the first letter of the <b>GivenName</b>, the first letter of the middle name if one exists, and the
        /// first letter of the <b>Surname</b>.</p>
        pub fn initials(mut self, input: impl Into<std::string::String>) -> Self {
            self.initials = Some(input.into());
            self
        }
        /// <p>Concatenation that typically contains the first letter of the <b>GivenName</b>, the first letter of the middle name if one exists, and the
        /// first letter of the <b>Surname</b>.</p>
        pub fn set_initials(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.initials = input;
            self
        }
        /// <p>Typically a shortened version of a longer <b>GivenName</b>.
        /// For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth,
        /// Liz, or Eliza.</p>
        pub fn pseudonym(mut self, input: impl Into<std::string::String>) -> Self {
            self.pseudonym = Some(input.into());
            self
        }
        /// <p>Typically a shortened version of a longer <b>GivenName</b>.
        /// For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth,
        /// Liz, or Eliza.</p>
        pub fn set_pseudonym(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pseudonym = input;
            self
        }
        /// <p>Typically a qualifier appended to the name of an individual. Examples include Jr. for
        /// junior, Sr. for senior, and III for third.</p>
        pub fn generation_qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.generation_qualifier = Some(input.into());
            self
        }
        /// <p>Typically a qualifier appended to the name of an individual. Examples include Jr. for
        /// junior, Sr. for senior, and III for third.</p>
        pub fn set_generation_qualifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generation_qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`Asn1Subject`](crate::model::Asn1Subject)
        pub fn build(self) -> crate::model::Asn1Subject {
            crate::model::Asn1Subject {
                country: self.country,
                organization: self.organization,
                organizational_unit: self.organizational_unit,
                distinguished_name_qualifier: self.distinguished_name_qualifier,
                state: self.state,
                common_name: self.common_name,
                serial_number: self.serial_number,
                locality: self.locality,
                title: self.title,
                surname: self.surname,
                given_name: self.given_name,
                initials: self.initials,
                pseudonym: self.pseudonym,
                generation_qualifier: self.generation_qualifier,
            }
        }
    }
}
impl Asn1Subject {
    /// Creates a new builder-style object to manufacture [`Asn1Subject`](crate::model::Asn1Subject)
    pub fn builder() -> crate::model::asn1_subject::Builder {
        crate::model::asn1_subject::Builder::default()
    }
}

/// <p>Defines a custom ASN.1 X.400 <code>GeneralName</code> using an object identifier (OID)
/// and value. The OID must satisfy the regular expression shown below. For more
/// information, see NIST's definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
/// (OID)</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OtherName {
    /// <p>Specifies an OID. </p>
    pub type_id: std::option::Option<std::string::String>,
    /// <p>Specifies an OID value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl OtherName {
    /// <p>Specifies an OID. </p>
    pub fn type_id(&self) -> std::option::Option<&str> {
        self.type_id.as_deref()
    }
    /// <p>Specifies an OID value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for OtherName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OtherName");
        formatter.field("type_id", &self.type_id);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`OtherName`](crate::model::OtherName)
pub mod other_name {
    /// A builder for [`OtherName`](crate::model::OtherName)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_id: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies an OID. </p>
        pub fn type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_id = Some(input.into());
            self
        }
        /// <p>Specifies an OID. </p>
        pub fn set_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_id = input;
            self
        }
        /// <p>Specifies an OID value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Specifies an OID value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`OtherName`](crate::model::OtherName)
        pub fn build(self) -> crate::model::OtherName {
            crate::model::OtherName {
                type_id: self.type_id,
                value: self.value,
            }
        }
    }
}
impl OtherName {
    /// Creates a new builder-style object to manufacture [`OtherName`](crate::model::OtherName)
    pub fn builder() -> crate::model::other_name::Builder {
        crate::model::other_name::Builder::default()
    }
}

/// <p>Describes the type and format of extension access. Only one of
/// <code>CustomObjectIdentifier</code> or <code>AccessMethodType</code> may be
/// provided. Providing both results in <code>InvalidArgsException</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessMethod {
    /// <p>An object identifier (OID) specifying the <code>AccessMethod</code>. The OID must
    /// satisfy the regular expression shown below. For more information, see NIST's definition
    /// of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
    /// (OID)</a>.</p>
    pub custom_object_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the <code>AccessMethod</code>.</p>
    pub access_method_type: std::option::Option<crate::model::AccessMethodType>,
}
impl AccessMethod {
    /// <p>An object identifier (OID) specifying the <code>AccessMethod</code>. The OID must
    /// satisfy the regular expression shown below. For more information, see NIST's definition
    /// of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
    /// (OID)</a>.</p>
    pub fn custom_object_identifier(&self) -> std::option::Option<&str> {
        self.custom_object_identifier.as_deref()
    }
    /// <p>Specifies the <code>AccessMethod</code>.</p>
    pub fn access_method_type(&self) -> std::option::Option<&crate::model::AccessMethodType> {
        self.access_method_type.as_ref()
    }
}
impl std::fmt::Debug for AccessMethod {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessMethod");
        formatter.field("custom_object_identifier", &self.custom_object_identifier);
        formatter.field("access_method_type", &self.access_method_type);
        formatter.finish()
    }
}
/// See [`AccessMethod`](crate::model::AccessMethod)
pub mod access_method {
    /// A builder for [`AccessMethod`](crate::model::AccessMethod)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_object_identifier: std::option::Option<std::string::String>,
        pub(crate) access_method_type: std::option::Option<crate::model::AccessMethodType>,
    }
    impl Builder {
        /// <p>An object identifier (OID) specifying the <code>AccessMethod</code>. The OID must
        /// satisfy the regular expression shown below. For more information, see NIST's definition
        /// of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
        /// (OID)</a>.</p>
        pub fn custom_object_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_object_identifier = Some(input.into());
            self
        }
        /// <p>An object identifier (OID) specifying the <code>AccessMethod</code>. The OID must
        /// satisfy the regular expression shown below. For more information, see NIST's definition
        /// of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
        /// (OID)</a>.</p>
        pub fn set_custom_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_object_identifier = input;
            self
        }
        /// <p>Specifies the <code>AccessMethod</code>.</p>
        pub fn access_method_type(mut self, input: crate::model::AccessMethodType) -> Self {
            self.access_method_type = Some(input);
            self
        }
        /// <p>Specifies the <code>AccessMethod</code>.</p>
        pub fn set_access_method_type(
            mut self,
            input: std::option::Option<crate::model::AccessMethodType>,
        ) -> Self {
            self.access_method_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessMethod`](crate::model::AccessMethod)
        pub fn build(self) -> crate::model::AccessMethod {
            crate::model::AccessMethod {
                custom_object_identifier: self.custom_object_identifier,
                access_method_type: self.access_method_type,
            }
        }
    }
}
impl AccessMethod {
    /// Creates a new builder-style object to manufacture [`AccessMethod`](crate::model::AccessMethod)
    pub fn builder() -> crate::model::access_method::Builder {
        crate::model::access_method::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessMethodType {
    #[allow(missing_docs)] // documentation missing in model
    CaRepository,
    #[allow(missing_docs)] // documentation missing in model
    ResourcePkiManifest,
    #[allow(missing_docs)] // documentation missing in model
    ResourcePkiNotify,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessMethodType {
    fn from(s: &str) -> Self {
        match s {
            "CA_REPOSITORY" => AccessMethodType::CaRepository,
            "RESOURCE_PKI_MANIFEST" => AccessMethodType::ResourcePkiManifest,
            "RESOURCE_PKI_NOTIFY" => AccessMethodType::ResourcePkiNotify,
            other => AccessMethodType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessMethodType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessMethodType::from(s))
    }
}
impl AccessMethodType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessMethodType::CaRepository => "CA_REPOSITORY",
            AccessMethodType::ResourcePkiManifest => "RESOURCE_PKI_MANIFEST",
            AccessMethodType::ResourcePkiNotify => "RESOURCE_PKI_NOTIFY",
            AccessMethodType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CA_REPOSITORY",
            "RESOURCE_PKI_MANIFEST",
            "RESOURCE_PKI_NOTIFY",
        ]
    }
}
impl AsRef<str> for AccessMethodType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines one or more purposes for which the key contained in the certificate can be
/// used. Default value for each option is false.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyUsage {
    /// <p> Key can be used for digital signing.</p>
    pub digital_signature: bool,
    /// <p>Key can be used for non-repudiation.</p>
    pub non_repudiation: bool,
    /// <p>Key can be used to encipher data.</p>
    pub key_encipherment: bool,
    /// <p>Key can be used to decipher data.</p>
    pub data_encipherment: bool,
    /// <p>Key can be used in a key-agreement protocol.</p>
    pub key_agreement: bool,
    /// <p>Key can be used to sign certificates.</p>
    pub key_cert_sign: bool,
    /// <p>Key can be used to sign CRLs.</p>
    pub crl_sign: bool,
    /// <p>Key can be used only to encipher data.</p>
    pub encipher_only: bool,
    /// <p>Key can be used only to decipher data.</p>
    pub decipher_only: bool,
}
impl KeyUsage {
    /// <p> Key can be used for digital signing.</p>
    pub fn digital_signature(&self) -> bool {
        self.digital_signature
    }
    /// <p>Key can be used for non-repudiation.</p>
    pub fn non_repudiation(&self) -> bool {
        self.non_repudiation
    }
    /// <p>Key can be used to encipher data.</p>
    pub fn key_encipherment(&self) -> bool {
        self.key_encipherment
    }
    /// <p>Key can be used to decipher data.</p>
    pub fn data_encipherment(&self) -> bool {
        self.data_encipherment
    }
    /// <p>Key can be used in a key-agreement protocol.</p>
    pub fn key_agreement(&self) -> bool {
        self.key_agreement
    }
    /// <p>Key can be used to sign certificates.</p>
    pub fn key_cert_sign(&self) -> bool {
        self.key_cert_sign
    }
    /// <p>Key can be used to sign CRLs.</p>
    pub fn crl_sign(&self) -> bool {
        self.crl_sign
    }
    /// <p>Key can be used only to encipher data.</p>
    pub fn encipher_only(&self) -> bool {
        self.encipher_only
    }
    /// <p>Key can be used only to decipher data.</p>
    pub fn decipher_only(&self) -> bool {
        self.decipher_only
    }
}
impl std::fmt::Debug for KeyUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyUsage");
        formatter.field("digital_signature", &self.digital_signature);
        formatter.field("non_repudiation", &self.non_repudiation);
        formatter.field("key_encipherment", &self.key_encipherment);
        formatter.field("data_encipherment", &self.data_encipherment);
        formatter.field("key_agreement", &self.key_agreement);
        formatter.field("key_cert_sign", &self.key_cert_sign);
        formatter.field("crl_sign", &self.crl_sign);
        formatter.field("encipher_only", &self.encipher_only);
        formatter.field("decipher_only", &self.decipher_only);
        formatter.finish()
    }
}
/// See [`KeyUsage`](crate::model::KeyUsage)
pub mod key_usage {
    /// A builder for [`KeyUsage`](crate::model::KeyUsage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) digital_signature: std::option::Option<bool>,
        pub(crate) non_repudiation: std::option::Option<bool>,
        pub(crate) key_encipherment: std::option::Option<bool>,
        pub(crate) data_encipherment: std::option::Option<bool>,
        pub(crate) key_agreement: std::option::Option<bool>,
        pub(crate) key_cert_sign: std::option::Option<bool>,
        pub(crate) crl_sign: std::option::Option<bool>,
        pub(crate) encipher_only: std::option::Option<bool>,
        pub(crate) decipher_only: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> Key can be used for digital signing.</p>
        pub fn digital_signature(mut self, input: bool) -> Self {
            self.digital_signature = Some(input);
            self
        }
        /// <p> Key can be used for digital signing.</p>
        pub fn set_digital_signature(mut self, input: std::option::Option<bool>) -> Self {
            self.digital_signature = input;
            self
        }
        /// <p>Key can be used for non-repudiation.</p>
        pub fn non_repudiation(mut self, input: bool) -> Self {
            self.non_repudiation = Some(input);
            self
        }
        /// <p>Key can be used for non-repudiation.</p>
        pub fn set_non_repudiation(mut self, input: std::option::Option<bool>) -> Self {
            self.non_repudiation = input;
            self
        }
        /// <p>Key can be used to encipher data.</p>
        pub fn key_encipherment(mut self, input: bool) -> Self {
            self.key_encipherment = Some(input);
            self
        }
        /// <p>Key can be used to encipher data.</p>
        pub fn set_key_encipherment(mut self, input: std::option::Option<bool>) -> Self {
            self.key_encipherment = input;
            self
        }
        /// <p>Key can be used to decipher data.</p>
        pub fn data_encipherment(mut self, input: bool) -> Self {
            self.data_encipherment = Some(input);
            self
        }
        /// <p>Key can be used to decipher data.</p>
        pub fn set_data_encipherment(mut self, input: std::option::Option<bool>) -> Self {
            self.data_encipherment = input;
            self
        }
        /// <p>Key can be used in a key-agreement protocol.</p>
        pub fn key_agreement(mut self, input: bool) -> Self {
            self.key_agreement = Some(input);
            self
        }
        /// <p>Key can be used in a key-agreement protocol.</p>
        pub fn set_key_agreement(mut self, input: std::option::Option<bool>) -> Self {
            self.key_agreement = input;
            self
        }
        /// <p>Key can be used to sign certificates.</p>
        pub fn key_cert_sign(mut self, input: bool) -> Self {
            self.key_cert_sign = Some(input);
            self
        }
        /// <p>Key can be used to sign certificates.</p>
        pub fn set_key_cert_sign(mut self, input: std::option::Option<bool>) -> Self {
            self.key_cert_sign = input;
            self
        }
        /// <p>Key can be used to sign CRLs.</p>
        pub fn crl_sign(mut self, input: bool) -> Self {
            self.crl_sign = Some(input);
            self
        }
        /// <p>Key can be used to sign CRLs.</p>
        pub fn set_crl_sign(mut self, input: std::option::Option<bool>) -> Self {
            self.crl_sign = input;
            self
        }
        /// <p>Key can be used only to encipher data.</p>
        pub fn encipher_only(mut self, input: bool) -> Self {
            self.encipher_only = Some(input);
            self
        }
        /// <p>Key can be used only to encipher data.</p>
        pub fn set_encipher_only(mut self, input: std::option::Option<bool>) -> Self {
            self.encipher_only = input;
            self
        }
        /// <p>Key can be used only to decipher data.</p>
        pub fn decipher_only(mut self, input: bool) -> Self {
            self.decipher_only = Some(input);
            self
        }
        /// <p>Key can be used only to decipher data.</p>
        pub fn set_decipher_only(mut self, input: std::option::Option<bool>) -> Self {
            self.decipher_only = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyUsage`](crate::model::KeyUsage)
        pub fn build(self) -> crate::model::KeyUsage {
            crate::model::KeyUsage {
                digital_signature: self.digital_signature.unwrap_or_default(),
                non_repudiation: self.non_repudiation.unwrap_or_default(),
                key_encipherment: self.key_encipherment.unwrap_or_default(),
                data_encipherment: self.data_encipherment.unwrap_or_default(),
                key_agreement: self.key_agreement.unwrap_or_default(),
                key_cert_sign: self.key_cert_sign.unwrap_or_default(),
                crl_sign: self.crl_sign.unwrap_or_default(),
                encipher_only: self.encipher_only.unwrap_or_default(),
                decipher_only: self.decipher_only.unwrap_or_default(),
            }
        }
    }
}
impl KeyUsage {
    /// Creates a new builder-style object to manufacture [`KeyUsage`](crate::model::KeyUsage)
    pub fn builder() -> crate::model::key_usage::Builder {
        crate::model::key_usage::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SigningAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    Sha256Withecdsa,
    #[allow(missing_docs)] // documentation missing in model
    Sha256Withrsa,
    #[allow(missing_docs)] // documentation missing in model
    Sha384Withecdsa,
    #[allow(missing_docs)] // documentation missing in model
    Sha384Withrsa,
    #[allow(missing_docs)] // documentation missing in model
    Sha512Withecdsa,
    #[allow(missing_docs)] // documentation missing in model
    Sha512Withrsa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SigningAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "SHA256WITHECDSA" => SigningAlgorithm::Sha256Withecdsa,
            "SHA256WITHRSA" => SigningAlgorithm::Sha256Withrsa,
            "SHA384WITHECDSA" => SigningAlgorithm::Sha384Withecdsa,
            "SHA384WITHRSA" => SigningAlgorithm::Sha384Withrsa,
            "SHA512WITHECDSA" => SigningAlgorithm::Sha512Withecdsa,
            "SHA512WITHRSA" => SigningAlgorithm::Sha512Withrsa,
            other => SigningAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SigningAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SigningAlgorithm::from(s))
    }
}
impl SigningAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SigningAlgorithm::Sha256Withecdsa => "SHA256WITHECDSA",
            SigningAlgorithm::Sha256Withrsa => "SHA256WITHRSA",
            SigningAlgorithm::Sha384Withecdsa => "SHA384WITHECDSA",
            SigningAlgorithm::Sha384Withrsa => "SHA384WITHRSA",
            SigningAlgorithm::Sha512Withecdsa => "SHA512WITHECDSA",
            SigningAlgorithm::Sha512Withrsa => "SHA512WITHRSA",
            SigningAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "SHA256WITHECDSA",
            "SHA256WITHRSA",
            "SHA384WITHECDSA",
            "SHA384WITHRSA",
            "SHA512WITHECDSA",
            "SHA512WITHRSA",
        ]
    }
}
impl AsRef<str> for SigningAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeyAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    EcPrime256v1,
    #[allow(missing_docs)] // documentation missing in model
    EcSecp384r1,
    #[allow(missing_docs)] // documentation missing in model
    Rsa2048,
    #[allow(missing_docs)] // documentation missing in model
    Rsa4096,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeyAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "EC_prime256v1" => KeyAlgorithm::EcPrime256v1,
            "EC_secp384r1" => KeyAlgorithm::EcSecp384r1,
            "RSA_2048" => KeyAlgorithm::Rsa2048,
            "RSA_4096" => KeyAlgorithm::Rsa4096,
            other => KeyAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeyAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeyAlgorithm::from(s))
    }
}
impl KeyAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeyAlgorithm::EcPrime256v1 => "EC_prime256v1",
            KeyAlgorithm::EcSecp384r1 => "EC_secp384r1",
            KeyAlgorithm::Rsa2048 => "RSA_2048",
            KeyAlgorithm::Rsa4096 => "RSA_4096",
            KeyAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EC_prime256v1", "EC_secp384r1", "RSA_2048", "RSA_4096"]
    }
}
impl AsRef<str> for KeyAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailureReason {
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    RequestTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    UnsupportedAlgorithm,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailureReason {
    fn from(s: &str) -> Self {
        match s {
            "OTHER" => FailureReason::Other,
            "REQUEST_TIMED_OUT" => FailureReason::RequestTimedOut,
            "UNSUPPORTED_ALGORITHM" => FailureReason::UnsupportedAlgorithm,
            other => FailureReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailureReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailureReason::from(s))
    }
}
impl FailureReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailureReason::Other => "OTHER",
            FailureReason::RequestTimedOut => "REQUEST_TIMED_OUT",
            FailureReason::UnsupportedAlgorithm => "UNSUPPORTED_ALGORITHM",
            FailureReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OTHER", "REQUEST_TIMED_OUT", "UNSUPPORTED_ALGORITHM"]
    }
}
impl AsRef<str> for FailureReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateAuthorityType {
    #[allow(missing_docs)] // documentation missing in model
    Root,
    #[allow(missing_docs)] // documentation missing in model
    Subordinate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateAuthorityType {
    fn from(s: &str) -> Self {
        match s {
            "ROOT" => CertificateAuthorityType::Root,
            "SUBORDINATE" => CertificateAuthorityType::Subordinate,
            other => CertificateAuthorityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateAuthorityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateAuthorityType::from(s))
    }
}
impl CertificateAuthorityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateAuthorityType::Root => "ROOT",
            CertificateAuthorityType::Subordinate => "SUBORDINATE",
            CertificateAuthorityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ROOT", "SUBORDINATE"]
    }
}
impl AsRef<str> for CertificateAuthorityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `ResourceOwner::Self` has been renamed to `::SelfValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceOwner {
    #[allow(missing_docs)] // documentation missing in model
    OtherAccounts,
    /// _Note: `::Self` has been renamed to `::SelfValue`._
    SelfValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceOwner {
    fn from(s: &str) -> Self {
        match s {
            "OTHER_ACCOUNTS" => ResourceOwner::OtherAccounts,
            "SELF" => ResourceOwner::SelfValue,
            other => ResourceOwner::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceOwner {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceOwner::from(s))
    }
}
impl ResourceOwner {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceOwner::OtherAccounts => "OTHER_ACCOUNTS",
            ResourceOwner::SelfValue => "SELF",
            ResourceOwner::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OTHER_ACCOUNTS", "SELF"]
    }
}
impl AsRef<str> for ResourceOwner {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Validity specifies the period of time during which a certificate is valid. Validity
/// can be expressed as an explicit date and time when the validity of a certificate starts
/// or expires, or as a span of time after issuance, stated in days, months, or years. For
/// more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280.</p>
/// <p>ACM Private CA API consumes the <code>Validity</code> data type differently in two distinct
/// parameters of the <code>IssueCertificate</code> action. The required parameter
/// <code>IssueCertificate</code>:<code>Validity</code> specifies the end of a
/// certificate's validity period. The optional parameter
/// <code>IssueCertificate</code>:<code>ValidityNotBefore</code> specifies a customized
/// starting time for the validity period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Validity {
    /// <p>A long integer interpreted according to the value of <code>Type</code>, below.</p>
    pub value: std::option::Option<i64>,
    /// <p>Determines how <i>ACM Private CA</i> interprets the <code>Value</code>
    /// parameter, an integer. Supported validity types include those listed below. Type
    /// definitions with values include a sample input value and the resulting output. </p>
    /// <p>
    /// <code>END_DATE</code>: The specific date and time when the certificate will expire,
    /// expressed using UTCTime (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When
    /// UTCTime is used, if the year field (YY) is greater than or equal to 50, the year is
    /// interpreted as 19YY. If the year field is less than 50, the year is interpreted as
    /// 20YY.</p>
    /// <ul>
    /// <li>
    /// <p>Sample input value: 491231235959 (UTCTime format)</p>
    /// </li>
    /// <li>
    /// <p>Output expiration date/time: 12/31/2049 23:59:59</p>
    /// </li>
    /// </ul>
    /// <p>
    /// <code>ABSOLUTE</code>: The specific date and time when the validity of a certificate
    /// will start or expire, expressed in seconds since the Unix Epoch. </p>
    /// <ul>
    /// <li>
    /// <p>Sample input value: 2524608000</p>
    /// </li>
    /// <li>
    /// <p>Output expiration date/time: 01/01/2050 00:00:00</p>
    /// </li>
    /// </ul>
    /// <p>
    /// <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the
    /// moment of issuance until the certificate will expire, expressed in days, months, or
    /// years. </p>
    /// <p>Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:</p>
    /// <ul>
    /// <li>
    /// <p>Sample input value: 90</p>
    /// </li>
    /// <li>
    /// <p>Output expiration date: 01/10/2020 12:34:54 UTC</p>
    /// </li>
    /// </ul>
    /// <p>The minimum validity duration for a certificate using relative time
    /// (<code>DAYS</code>) is one day. The minimum validity for a certificate using absolute
    /// time (<code>ABSOLUTE</code> or <code>END_DATE</code>) is one second.</p>
    pub r#type: std::option::Option<crate::model::ValidityPeriodType>,
}
impl Validity {
    /// <p>A long integer interpreted according to the value of <code>Type</code>, below.</p>
    pub fn value(&self) -> std::option::Option<i64> {
        self.value
    }
    /// <p>Determines how <i>ACM Private CA</i> interprets the <code>Value</code>
    /// parameter, an integer. Supported validity types include those listed below. Type
    /// definitions with values include a sample input value and the resulting output. </p>
    /// <p>
    /// <code>END_DATE</code>: The specific date and time when the certificate will expire,
    /// expressed using UTCTime (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When
    /// UTCTime is used, if the year field (YY) is greater than or equal to 50, the year is
    /// interpreted as 19YY. If the year field is less than 50, the year is interpreted as
    /// 20YY.</p>
    /// <ul>
    /// <li>
    /// <p>Sample input value: 491231235959 (UTCTime format)</p>
    /// </li>
    /// <li>
    /// <p>Output expiration date/time: 12/31/2049 23:59:59</p>
    /// </li>
    /// </ul>
    /// <p>
    /// <code>ABSOLUTE</code>: The specific date and time when the validity of a certificate
    /// will start or expire, expressed in seconds since the Unix Epoch. </p>
    /// <ul>
    /// <li>
    /// <p>Sample input value: 2524608000</p>
    /// </li>
    /// <li>
    /// <p>Output expiration date/time: 01/01/2050 00:00:00</p>
    /// </li>
    /// </ul>
    /// <p>
    /// <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the
    /// moment of issuance until the certificate will expire, expressed in days, months, or
    /// years. </p>
    /// <p>Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:</p>
    /// <ul>
    /// <li>
    /// <p>Sample input value: 90</p>
    /// </li>
    /// <li>
    /// <p>Output expiration date: 01/10/2020 12:34:54 UTC</p>
    /// </li>
    /// </ul>
    /// <p>The minimum validity duration for a certificate using relative time
    /// (<code>DAYS</code>) is one day. The minimum validity for a certificate using absolute
    /// time (<code>ABSOLUTE</code> or <code>END_DATE</code>) is one second.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ValidityPeriodType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Validity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Validity");
        formatter.field("value", &self.value);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Validity`](crate::model::Validity)
pub mod validity {
    /// A builder for [`Validity`](crate::model::Validity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<i64>,
        pub(crate) r#type: std::option::Option<crate::model::ValidityPeriodType>,
    }
    impl Builder {
        /// <p>A long integer interpreted according to the value of <code>Type</code>, below.</p>
        pub fn value(mut self, input: i64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>A long integer interpreted according to the value of <code>Type</code>, below.</p>
        pub fn set_value(mut self, input: std::option::Option<i64>) -> Self {
            self.value = input;
            self
        }
        /// <p>Determines how <i>ACM Private CA</i> interprets the <code>Value</code>
        /// parameter, an integer. Supported validity types include those listed below. Type
        /// definitions with values include a sample input value and the resulting output. </p>
        /// <p>
        /// <code>END_DATE</code>: The specific date and time when the certificate will expire,
        /// expressed using UTCTime (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When
        /// UTCTime is used, if the year field (YY) is greater than or equal to 50, the year is
        /// interpreted as 19YY. If the year field is less than 50, the year is interpreted as
        /// 20YY.</p>
        /// <ul>
        /// <li>
        /// <p>Sample input value: 491231235959 (UTCTime format)</p>
        /// </li>
        /// <li>
        /// <p>Output expiration date/time: 12/31/2049 23:59:59</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>ABSOLUTE</code>: The specific date and time when the validity of a certificate
        /// will start or expire, expressed in seconds since the Unix Epoch. </p>
        /// <ul>
        /// <li>
        /// <p>Sample input value: 2524608000</p>
        /// </li>
        /// <li>
        /// <p>Output expiration date/time: 01/01/2050 00:00:00</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the
        /// moment of issuance until the certificate will expire, expressed in days, months, or
        /// years. </p>
        /// <p>Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:</p>
        /// <ul>
        /// <li>
        /// <p>Sample input value: 90</p>
        /// </li>
        /// <li>
        /// <p>Output expiration date: 01/10/2020 12:34:54 UTC</p>
        /// </li>
        /// </ul>
        /// <p>The minimum validity duration for a certificate using relative time
        /// (<code>DAYS</code>) is one day. The minimum validity for a certificate using absolute
        /// time (<code>ABSOLUTE</code> or <code>END_DATE</code>) is one second.</p>
        pub fn r#type(mut self, input: crate::model::ValidityPeriodType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Determines how <i>ACM Private CA</i> interprets the <code>Value</code>
        /// parameter, an integer. Supported validity types include those listed below. Type
        /// definitions with values include a sample input value and the resulting output. </p>
        /// <p>
        /// <code>END_DATE</code>: The specific date and time when the certificate will expire,
        /// expressed using UTCTime (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When
        /// UTCTime is used, if the year field (YY) is greater than or equal to 50, the year is
        /// interpreted as 19YY. If the year field is less than 50, the year is interpreted as
        /// 20YY.</p>
        /// <ul>
        /// <li>
        /// <p>Sample input value: 491231235959 (UTCTime format)</p>
        /// </li>
        /// <li>
        /// <p>Output expiration date/time: 12/31/2049 23:59:59</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>ABSOLUTE</code>: The specific date and time when the validity of a certificate
        /// will start or expire, expressed in seconds since the Unix Epoch. </p>
        /// <ul>
        /// <li>
        /// <p>Sample input value: 2524608000</p>
        /// </li>
        /// <li>
        /// <p>Output expiration date/time: 01/01/2050 00:00:00</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the
        /// moment of issuance until the certificate will expire, expressed in days, months, or
        /// years. </p>
        /// <p>Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:</p>
        /// <ul>
        /// <li>
        /// <p>Sample input value: 90</p>
        /// </li>
        /// <li>
        /// <p>Output expiration date: 01/10/2020 12:34:54 UTC</p>
        /// </li>
        /// </ul>
        /// <p>The minimum validity duration for a certificate using relative time
        /// (<code>DAYS</code>) is one day. The minimum validity for a certificate using absolute
        /// time (<code>ABSOLUTE</code> or <code>END_DATE</code>) is one second.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ValidityPeriodType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Validity`](crate::model::Validity)
        pub fn build(self) -> crate::model::Validity {
            crate::model::Validity {
                value: self.value,
                r#type: self.r#type,
            }
        }
    }
}
impl Validity {
    /// Creates a new builder-style object to manufacture [`Validity`](crate::model::Validity)
    pub fn builder() -> crate::model::validity::Builder {
        crate::model::validity::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidityPeriodType {
    #[allow(missing_docs)] // documentation missing in model
    Absolute,
    #[allow(missing_docs)] // documentation missing in model
    Days,
    #[allow(missing_docs)] // documentation missing in model
    EndDate,
    #[allow(missing_docs)] // documentation missing in model
    Months,
    #[allow(missing_docs)] // documentation missing in model
    Years,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidityPeriodType {
    fn from(s: &str) -> Self {
        match s {
            "ABSOLUTE" => ValidityPeriodType::Absolute,
            "DAYS" => ValidityPeriodType::Days,
            "END_DATE" => ValidityPeriodType::EndDate,
            "MONTHS" => ValidityPeriodType::Months,
            "YEARS" => ValidityPeriodType::Years,
            other => ValidityPeriodType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidityPeriodType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidityPeriodType::from(s))
    }
}
impl ValidityPeriodType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidityPeriodType::Absolute => "ABSOLUTE",
            ValidityPeriodType::Days => "DAYS",
            ValidityPeriodType::EndDate => "END_DATE",
            ValidityPeriodType::Months => "MONTHS",
            ValidityPeriodType::Years => "YEARS",
            ValidityPeriodType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ABSOLUTE", "DAYS", "END_DATE", "MONTHS", "YEARS"]
    }
}
impl AsRef<str> for ValidityPeriodType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains X.509 certificate information to be placed in an issued certificate. An
/// <code>APIPassthrough</code> or <code>APICSRPassthrough</code> template variant must
/// be selected, or else this parameter is ignored. </p>
/// <p>If conflicting or duplicate certificate information is supplied from other sources,
/// ACM Private CA applies <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">order of
/// operation rules</a> to determine what information is used.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiPassthrough {
    /// <p>Specifies X.509 extension information for a certificate.</p>
    pub extensions: std::option::Option<crate::model::Extensions>,
    /// <p>Contains information about the certificate subject. The <code>Subject</code> field in
    /// the certificate identifies the entity that owns or controls the public key in the
    /// certificate. The entity can be a user, computer, device, or service. The <code>Subject
    /// </code>must contain an X.500 distinguished name (DN). A DN is a sequence of relative
    /// distinguished names (RDNs). The RDNs are separated by commas in the certificate.</p>
    pub subject: std::option::Option<crate::model::Asn1Subject>,
}
impl ApiPassthrough {
    /// <p>Specifies X.509 extension information for a certificate.</p>
    pub fn extensions(&self) -> std::option::Option<&crate::model::Extensions> {
        self.extensions.as_ref()
    }
    /// <p>Contains information about the certificate subject. The <code>Subject</code> field in
    /// the certificate identifies the entity that owns or controls the public key in the
    /// certificate. The entity can be a user, computer, device, or service. The <code>Subject
    /// </code>must contain an X.500 distinguished name (DN). A DN is a sequence of relative
    /// distinguished names (RDNs). The RDNs are separated by commas in the certificate.</p>
    pub fn subject(&self) -> std::option::Option<&crate::model::Asn1Subject> {
        self.subject.as_ref()
    }
}
impl std::fmt::Debug for ApiPassthrough {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiPassthrough");
        formatter.field("extensions", &self.extensions);
        formatter.field("subject", &self.subject);
        formatter.finish()
    }
}
/// See [`ApiPassthrough`](crate::model::ApiPassthrough)
pub mod api_passthrough {
    /// A builder for [`ApiPassthrough`](crate::model::ApiPassthrough)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) extensions: std::option::Option<crate::model::Extensions>,
        pub(crate) subject: std::option::Option<crate::model::Asn1Subject>,
    }
    impl Builder {
        /// <p>Specifies X.509 extension information for a certificate.</p>
        pub fn extensions(mut self, input: crate::model::Extensions) -> Self {
            self.extensions = Some(input);
            self
        }
        /// <p>Specifies X.509 extension information for a certificate.</p>
        pub fn set_extensions(
            mut self,
            input: std::option::Option<crate::model::Extensions>,
        ) -> Self {
            self.extensions = input;
            self
        }
        /// <p>Contains information about the certificate subject. The <code>Subject</code> field in
        /// the certificate identifies the entity that owns or controls the public key in the
        /// certificate. The entity can be a user, computer, device, or service. The <code>Subject
        /// </code>must contain an X.500 distinguished name (DN). A DN is a sequence of relative
        /// distinguished names (RDNs). The RDNs are separated by commas in the certificate.</p>
        pub fn subject(mut self, input: crate::model::Asn1Subject) -> Self {
            self.subject = Some(input);
            self
        }
        /// <p>Contains information about the certificate subject. The <code>Subject</code> field in
        /// the certificate identifies the entity that owns or controls the public key in the
        /// certificate. The entity can be a user, computer, device, or service. The <code>Subject
        /// </code>must contain an X.500 distinguished name (DN). A DN is a sequence of relative
        /// distinguished names (RDNs). The RDNs are separated by commas in the certificate.</p>
        pub fn set_subject(
            mut self,
            input: std::option::Option<crate::model::Asn1Subject>,
        ) -> Self {
            self.subject = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiPassthrough`](crate::model::ApiPassthrough)
        pub fn build(self) -> crate::model::ApiPassthrough {
            crate::model::ApiPassthrough {
                extensions: self.extensions,
                subject: self.subject,
            }
        }
    }
}
impl ApiPassthrough {
    /// Creates a new builder-style object to manufacture [`ApiPassthrough`](crate::model::ApiPassthrough)
    pub fn builder() -> crate::model::api_passthrough::Builder {
        crate::model::api_passthrough::Builder::default()
    }
}

/// <p>Contains X.509 extension information for a certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Extensions {
    /// <p>Contains a sequence of one or more policy information terms, each of which consists of
    /// an object identifier (OID) and optional qualifiers. For more information, see NIST's
    /// definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object
    /// Identifier (OID)</a>.</p>
    /// <p>In an end-entity certificate, these terms indicate the policy under which the
    /// certificate was issued and the purposes for which it may be used. In a CA certificate,
    /// these terms limit the set of policies for certification paths that include this
    /// certificate.</p>
    pub certificate_policies: std::option::Option<std::vec::Vec<crate::model::PolicyInformation>>,
    /// <p>Specifies additional purposes for which the certified public key may be used other
    /// than basic purposes indicated in the <code>KeyUsage</code> extension.</p>
    pub extended_key_usage: std::option::Option<std::vec::Vec<crate::model::ExtendedKeyUsage>>,
    /// <p>Defines one or more purposes for which the key contained in the certificate can be
    /// used. Default value for each option is false.</p>
    pub key_usage: std::option::Option<crate::model::KeyUsage>,
    /// <p>The subject alternative name extension allows identities to be bound to the subject of
    /// the certificate. These identities may be included in addition to or in place of the
    /// identity in the subject field of the certificate.</p>
    pub subject_alternative_names: std::option::Option<std::vec::Vec<crate::model::GeneralName>>,
}
impl Extensions {
    /// <p>Contains a sequence of one or more policy information terms, each of which consists of
    /// an object identifier (OID) and optional qualifiers. For more information, see NIST's
    /// definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object
    /// Identifier (OID)</a>.</p>
    /// <p>In an end-entity certificate, these terms indicate the policy under which the
    /// certificate was issued and the purposes for which it may be used. In a CA certificate,
    /// these terms limit the set of policies for certification paths that include this
    /// certificate.</p>
    pub fn certificate_policies(&self) -> std::option::Option<&[crate::model::PolicyInformation]> {
        self.certificate_policies.as_deref()
    }
    /// <p>Specifies additional purposes for which the certified public key may be used other
    /// than basic purposes indicated in the <code>KeyUsage</code> extension.</p>
    pub fn extended_key_usage(&self) -> std::option::Option<&[crate::model::ExtendedKeyUsage]> {
        self.extended_key_usage.as_deref()
    }
    /// <p>Defines one or more purposes for which the key contained in the certificate can be
    /// used. Default value for each option is false.</p>
    pub fn key_usage(&self) -> std::option::Option<&crate::model::KeyUsage> {
        self.key_usage.as_ref()
    }
    /// <p>The subject alternative name extension allows identities to be bound to the subject of
    /// the certificate. These identities may be included in addition to or in place of the
    /// identity in the subject field of the certificate.</p>
    pub fn subject_alternative_names(&self) -> std::option::Option<&[crate::model::GeneralName]> {
        self.subject_alternative_names.as_deref()
    }
}
impl std::fmt::Debug for Extensions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Extensions");
        formatter.field("certificate_policies", &self.certificate_policies);
        formatter.field("extended_key_usage", &self.extended_key_usage);
        formatter.field("key_usage", &self.key_usage);
        formatter.field("subject_alternative_names", &self.subject_alternative_names);
        formatter.finish()
    }
}
/// See [`Extensions`](crate::model::Extensions)
pub mod extensions {
    /// A builder for [`Extensions`](crate::model::Extensions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_policies:
            std::option::Option<std::vec::Vec<crate::model::PolicyInformation>>,
        pub(crate) extended_key_usage:
            std::option::Option<std::vec::Vec<crate::model::ExtendedKeyUsage>>,
        pub(crate) key_usage: std::option::Option<crate::model::KeyUsage>,
        pub(crate) subject_alternative_names:
            std::option::Option<std::vec::Vec<crate::model::GeneralName>>,
    }
    impl Builder {
        /// Appends an item to `certificate_policies`.
        ///
        /// To override the contents of this collection use [`set_certificate_policies`](Self::set_certificate_policies).
        ///
        /// <p>Contains a sequence of one or more policy information terms, each of which consists of
        /// an object identifier (OID) and optional qualifiers. For more information, see NIST's
        /// definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object
        /// Identifier (OID)</a>.</p>
        /// <p>In an end-entity certificate, these terms indicate the policy under which the
        /// certificate was issued and the purposes for which it may be used. In a CA certificate,
        /// these terms limit the set of policies for certification paths that include this
        /// certificate.</p>
        pub fn certificate_policies(
            mut self,
            input: impl Into<crate::model::PolicyInformation>,
        ) -> Self {
            let mut v = self.certificate_policies.unwrap_or_default();
            v.push(input.into());
            self.certificate_policies = Some(v);
            self
        }
        /// <p>Contains a sequence of one or more policy information terms, each of which consists of
        /// an object identifier (OID) and optional qualifiers. For more information, see NIST's
        /// definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object
        /// Identifier (OID)</a>.</p>
        /// <p>In an end-entity certificate, these terms indicate the policy under which the
        /// certificate was issued and the purposes for which it may be used. In a CA certificate,
        /// these terms limit the set of policies for certification paths that include this
        /// certificate.</p>
        pub fn set_certificate_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyInformation>>,
        ) -> Self {
            self.certificate_policies = input;
            self
        }
        /// Appends an item to `extended_key_usage`.
        ///
        /// To override the contents of this collection use [`set_extended_key_usage`](Self::set_extended_key_usage).
        ///
        /// <p>Specifies additional purposes for which the certified public key may be used other
        /// than basic purposes indicated in the <code>KeyUsage</code> extension.</p>
        pub fn extended_key_usage(
            mut self,
            input: impl Into<crate::model::ExtendedKeyUsage>,
        ) -> Self {
            let mut v = self.extended_key_usage.unwrap_or_default();
            v.push(input.into());
            self.extended_key_usage = Some(v);
            self
        }
        /// <p>Specifies additional purposes for which the certified public key may be used other
        /// than basic purposes indicated in the <code>KeyUsage</code> extension.</p>
        pub fn set_extended_key_usage(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExtendedKeyUsage>>,
        ) -> Self {
            self.extended_key_usage = input;
            self
        }
        /// <p>Defines one or more purposes for which the key contained in the certificate can be
        /// used. Default value for each option is false.</p>
        pub fn key_usage(mut self, input: crate::model::KeyUsage) -> Self {
            self.key_usage = Some(input);
            self
        }
        /// <p>Defines one or more purposes for which the key contained in the certificate can be
        /// used. Default value for each option is false.</p>
        pub fn set_key_usage(mut self, input: std::option::Option<crate::model::KeyUsage>) -> Self {
            self.key_usage = input;
            self
        }
        /// Appends an item to `subject_alternative_names`.
        ///
        /// To override the contents of this collection use [`set_subject_alternative_names`](Self::set_subject_alternative_names).
        ///
        /// <p>The subject alternative name extension allows identities to be bound to the subject of
        /// the certificate. These identities may be included in addition to or in place of the
        /// identity in the subject field of the certificate.</p>
        pub fn subject_alternative_names(
            mut self,
            input: impl Into<crate::model::GeneralName>,
        ) -> Self {
            let mut v = self.subject_alternative_names.unwrap_or_default();
            v.push(input.into());
            self.subject_alternative_names = Some(v);
            self
        }
        /// <p>The subject alternative name extension allows identities to be bound to the subject of
        /// the certificate. These identities may be included in addition to or in place of the
        /// identity in the subject field of the certificate.</p>
        pub fn set_subject_alternative_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GeneralName>>,
        ) -> Self {
            self.subject_alternative_names = input;
            self
        }
        /// Consumes the builder and constructs a [`Extensions`](crate::model::Extensions)
        pub fn build(self) -> crate::model::Extensions {
            crate::model::Extensions {
                certificate_policies: self.certificate_policies,
                extended_key_usage: self.extended_key_usage,
                key_usage: self.key_usage,
                subject_alternative_names: self.subject_alternative_names,
            }
        }
    }
}
impl Extensions {
    /// Creates a new builder-style object to manufacture [`Extensions`](crate::model::Extensions)
    pub fn builder() -> crate::model::extensions::Builder {
        crate::model::extensions::Builder::default()
    }
}

/// <p>Specifies additional purposes for which the certified public key may be used other
/// than basic purposes indicated in the <code>KeyUsage</code> extension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExtendedKeyUsage {
    /// <p>Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.</p>
    pub extended_key_usage_type: std::option::Option<crate::model::ExtendedKeyUsageType>,
    /// <p>Specifies a custom <code>ExtendedKeyUsage</code> with an object identifier
    /// (OID).</p>
    pub extended_key_usage_object_identifier: std::option::Option<std::string::String>,
}
impl ExtendedKeyUsage {
    /// <p>Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.</p>
    pub fn extended_key_usage_type(
        &self,
    ) -> std::option::Option<&crate::model::ExtendedKeyUsageType> {
        self.extended_key_usage_type.as_ref()
    }
    /// <p>Specifies a custom <code>ExtendedKeyUsage</code> with an object identifier
    /// (OID).</p>
    pub fn extended_key_usage_object_identifier(&self) -> std::option::Option<&str> {
        self.extended_key_usage_object_identifier.as_deref()
    }
}
impl std::fmt::Debug for ExtendedKeyUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExtendedKeyUsage");
        formatter.field("extended_key_usage_type", &self.extended_key_usage_type);
        formatter.field(
            "extended_key_usage_object_identifier",
            &self.extended_key_usage_object_identifier,
        );
        formatter.finish()
    }
}
/// See [`ExtendedKeyUsage`](crate::model::ExtendedKeyUsage)
pub mod extended_key_usage {
    /// A builder for [`ExtendedKeyUsage`](crate::model::ExtendedKeyUsage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) extended_key_usage_type: std::option::Option<crate::model::ExtendedKeyUsageType>,
        pub(crate) extended_key_usage_object_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.</p>
        pub fn extended_key_usage_type(
            mut self,
            input: crate::model::ExtendedKeyUsageType,
        ) -> Self {
            self.extended_key_usage_type = Some(input);
            self
        }
        /// <p>Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.</p>
        pub fn set_extended_key_usage_type(
            mut self,
            input: std::option::Option<crate::model::ExtendedKeyUsageType>,
        ) -> Self {
            self.extended_key_usage_type = input;
            self
        }
        /// <p>Specifies a custom <code>ExtendedKeyUsage</code> with an object identifier
        /// (OID).</p>
        pub fn extended_key_usage_object_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.extended_key_usage_object_identifier = Some(input.into());
            self
        }
        /// <p>Specifies a custom <code>ExtendedKeyUsage</code> with an object identifier
        /// (OID).</p>
        pub fn set_extended_key_usage_object_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extended_key_usage_object_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`ExtendedKeyUsage`](crate::model::ExtendedKeyUsage)
        pub fn build(self) -> crate::model::ExtendedKeyUsage {
            crate::model::ExtendedKeyUsage {
                extended_key_usage_type: self.extended_key_usage_type,
                extended_key_usage_object_identifier: self.extended_key_usage_object_identifier,
            }
        }
    }
}
impl ExtendedKeyUsage {
    /// Creates a new builder-style object to manufacture [`ExtendedKeyUsage`](crate::model::ExtendedKeyUsage)
    pub fn builder() -> crate::model::extended_key_usage::Builder {
        crate::model::extended_key_usage::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExtendedKeyUsageType {
    #[allow(missing_docs)] // documentation missing in model
    CertificateTransparency,
    #[allow(missing_docs)] // documentation missing in model
    ClientAuth,
    #[allow(missing_docs)] // documentation missing in model
    CodeSigning,
    #[allow(missing_docs)] // documentation missing in model
    DocumentSigning,
    #[allow(missing_docs)] // documentation missing in model
    EmailProtection,
    #[allow(missing_docs)] // documentation missing in model
    OcspSigning,
    #[allow(missing_docs)] // documentation missing in model
    ServerAuth,
    #[allow(missing_docs)] // documentation missing in model
    SmartCardLogin,
    #[allow(missing_docs)] // documentation missing in model
    TimeStamping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExtendedKeyUsageType {
    fn from(s: &str) -> Self {
        match s {
            "CERTIFICATE_TRANSPARENCY" => ExtendedKeyUsageType::CertificateTransparency,
            "CLIENT_AUTH" => ExtendedKeyUsageType::ClientAuth,
            "CODE_SIGNING" => ExtendedKeyUsageType::CodeSigning,
            "DOCUMENT_SIGNING" => ExtendedKeyUsageType::DocumentSigning,
            "EMAIL_PROTECTION" => ExtendedKeyUsageType::EmailProtection,
            "OCSP_SIGNING" => ExtendedKeyUsageType::OcspSigning,
            "SERVER_AUTH" => ExtendedKeyUsageType::ServerAuth,
            "SMART_CARD_LOGIN" => ExtendedKeyUsageType::SmartCardLogin,
            "TIME_STAMPING" => ExtendedKeyUsageType::TimeStamping,
            other => ExtendedKeyUsageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExtendedKeyUsageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExtendedKeyUsageType::from(s))
    }
}
impl ExtendedKeyUsageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExtendedKeyUsageType::CertificateTransparency => "CERTIFICATE_TRANSPARENCY",
            ExtendedKeyUsageType::ClientAuth => "CLIENT_AUTH",
            ExtendedKeyUsageType::CodeSigning => "CODE_SIGNING",
            ExtendedKeyUsageType::DocumentSigning => "DOCUMENT_SIGNING",
            ExtendedKeyUsageType::EmailProtection => "EMAIL_PROTECTION",
            ExtendedKeyUsageType::OcspSigning => "OCSP_SIGNING",
            ExtendedKeyUsageType::ServerAuth => "SERVER_AUTH",
            ExtendedKeyUsageType::SmartCardLogin => "SMART_CARD_LOGIN",
            ExtendedKeyUsageType::TimeStamping => "TIME_STAMPING",
            ExtendedKeyUsageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CERTIFICATE_TRANSPARENCY",
            "CLIENT_AUTH",
            "CODE_SIGNING",
            "DOCUMENT_SIGNING",
            "EMAIL_PROTECTION",
            "OCSP_SIGNING",
            "SERVER_AUTH",
            "SMART_CARD_LOGIN",
            "TIME_STAMPING",
        ]
    }
}
impl AsRef<str> for ExtendedKeyUsageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines the X.509 <code>CertificatePolicies</code> extension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyInformation {
    /// <p>Specifies the object identifier (OID) of the certificate policy under which the
    /// certificate was issued. For more information, see NIST's definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
    /// (OID)</a>.</p>
    pub cert_policy_id: std::option::Option<std::string::String>,
    /// <p>Modifies the given <code>CertPolicyId</code> with a qualifier. ACM Private CA supports the
    /// certification practice statement (CPS) qualifier.</p>
    pub policy_qualifiers: std::option::Option<std::vec::Vec<crate::model::PolicyQualifierInfo>>,
}
impl PolicyInformation {
    /// <p>Specifies the object identifier (OID) of the certificate policy under which the
    /// certificate was issued. For more information, see NIST's definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
    /// (OID)</a>.</p>
    pub fn cert_policy_id(&self) -> std::option::Option<&str> {
        self.cert_policy_id.as_deref()
    }
    /// <p>Modifies the given <code>CertPolicyId</code> with a qualifier. ACM Private CA supports the
    /// certification practice statement (CPS) qualifier.</p>
    pub fn policy_qualifiers(&self) -> std::option::Option<&[crate::model::PolicyQualifierInfo]> {
        self.policy_qualifiers.as_deref()
    }
}
impl std::fmt::Debug for PolicyInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyInformation");
        formatter.field("cert_policy_id", &self.cert_policy_id);
        formatter.field("policy_qualifiers", &self.policy_qualifiers);
        formatter.finish()
    }
}
/// See [`PolicyInformation`](crate::model::PolicyInformation)
pub mod policy_information {
    /// A builder for [`PolicyInformation`](crate::model::PolicyInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cert_policy_id: std::option::Option<std::string::String>,
        pub(crate) policy_qualifiers:
            std::option::Option<std::vec::Vec<crate::model::PolicyQualifierInfo>>,
    }
    impl Builder {
        /// <p>Specifies the object identifier (OID) of the certificate policy under which the
        /// certificate was issued. For more information, see NIST's definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
        /// (OID)</a>.</p>
        pub fn cert_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cert_policy_id = Some(input.into());
            self
        }
        /// <p>Specifies the object identifier (OID) of the certificate policy under which the
        /// certificate was issued. For more information, see NIST's definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
        /// (OID)</a>.</p>
        pub fn set_cert_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cert_policy_id = input;
            self
        }
        /// Appends an item to `policy_qualifiers`.
        ///
        /// To override the contents of this collection use [`set_policy_qualifiers`](Self::set_policy_qualifiers).
        ///
        /// <p>Modifies the given <code>CertPolicyId</code> with a qualifier. ACM Private CA supports the
        /// certification practice statement (CPS) qualifier.</p>
        pub fn policy_qualifiers(
            mut self,
            input: impl Into<crate::model::PolicyQualifierInfo>,
        ) -> Self {
            let mut v = self.policy_qualifiers.unwrap_or_default();
            v.push(input.into());
            self.policy_qualifiers = Some(v);
            self
        }
        /// <p>Modifies the given <code>CertPolicyId</code> with a qualifier. ACM Private CA supports the
        /// certification practice statement (CPS) qualifier.</p>
        pub fn set_policy_qualifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyQualifierInfo>>,
        ) -> Self {
            self.policy_qualifiers = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyInformation`](crate::model::PolicyInformation)
        pub fn build(self) -> crate::model::PolicyInformation {
            crate::model::PolicyInformation {
                cert_policy_id: self.cert_policy_id,
                policy_qualifiers: self.policy_qualifiers,
            }
        }
    }
}
impl PolicyInformation {
    /// Creates a new builder-style object to manufacture [`PolicyInformation`](crate::model::PolicyInformation)
    pub fn builder() -> crate::model::policy_information::Builder {
        crate::model::policy_information::Builder::default()
    }
}

/// <p>Modifies the <code>CertPolicyId</code> of a <code>PolicyInformation</code> object with
/// a qualifier. ACM Private CA supports the certification practice statement (CPS) qualifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyQualifierInfo {
    /// <p>Identifies the qualifier modifying a <code>CertPolicyId</code>.</p>
    pub policy_qualifier_id: std::option::Option<crate::model::PolicyQualifierId>,
    /// <p>Defines the qualifier type. ACM Private CA supports the use of a URI for a CPS qualifier in
    /// this field.</p>
    pub qualifier: std::option::Option<crate::model::Qualifier>,
}
impl PolicyQualifierInfo {
    /// <p>Identifies the qualifier modifying a <code>CertPolicyId</code>.</p>
    pub fn policy_qualifier_id(&self) -> std::option::Option<&crate::model::PolicyQualifierId> {
        self.policy_qualifier_id.as_ref()
    }
    /// <p>Defines the qualifier type. ACM Private CA supports the use of a URI for a CPS qualifier in
    /// this field.</p>
    pub fn qualifier(&self) -> std::option::Option<&crate::model::Qualifier> {
        self.qualifier.as_ref()
    }
}
impl std::fmt::Debug for PolicyQualifierInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyQualifierInfo");
        formatter.field("policy_qualifier_id", &self.policy_qualifier_id);
        formatter.field("qualifier", &self.qualifier);
        formatter.finish()
    }
}
/// See [`PolicyQualifierInfo`](crate::model::PolicyQualifierInfo)
pub mod policy_qualifier_info {
    /// A builder for [`PolicyQualifierInfo`](crate::model::PolicyQualifierInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_qualifier_id: std::option::Option<crate::model::PolicyQualifierId>,
        pub(crate) qualifier: std::option::Option<crate::model::Qualifier>,
    }
    impl Builder {
        /// <p>Identifies the qualifier modifying a <code>CertPolicyId</code>.</p>
        pub fn policy_qualifier_id(mut self, input: crate::model::PolicyQualifierId) -> Self {
            self.policy_qualifier_id = Some(input);
            self
        }
        /// <p>Identifies the qualifier modifying a <code>CertPolicyId</code>.</p>
        pub fn set_policy_qualifier_id(
            mut self,
            input: std::option::Option<crate::model::PolicyQualifierId>,
        ) -> Self {
            self.policy_qualifier_id = input;
            self
        }
        /// <p>Defines the qualifier type. ACM Private CA supports the use of a URI for a CPS qualifier in
        /// this field.</p>
        pub fn qualifier(mut self, input: crate::model::Qualifier) -> Self {
            self.qualifier = Some(input);
            self
        }
        /// <p>Defines the qualifier type. ACM Private CA supports the use of a URI for a CPS qualifier in
        /// this field.</p>
        pub fn set_qualifier(
            mut self,
            input: std::option::Option<crate::model::Qualifier>,
        ) -> Self {
            self.qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyQualifierInfo`](crate::model::PolicyQualifierInfo)
        pub fn build(self) -> crate::model::PolicyQualifierInfo {
            crate::model::PolicyQualifierInfo {
                policy_qualifier_id: self.policy_qualifier_id,
                qualifier: self.qualifier,
            }
        }
    }
}
impl PolicyQualifierInfo {
    /// Creates a new builder-style object to manufacture [`PolicyQualifierInfo`](crate::model::PolicyQualifierInfo)
    pub fn builder() -> crate::model::policy_qualifier_info::Builder {
        crate::model::policy_qualifier_info::Builder::default()
    }
}

/// <p>Defines a <code>PolicyInformation</code> qualifier. ACM Private CA supports the <a href="https://tools.ietf.org/html/rfc5280#section-4.2.1.4">certification practice
/// statement (CPS) qualifier</a> defined in RFC 5280. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Qualifier {
    /// <p>Contains a pointer to a certification practice statement (CPS) published by the
    /// CA.</p>
    pub cps_uri: std::option::Option<std::string::String>,
}
impl Qualifier {
    /// <p>Contains a pointer to a certification practice statement (CPS) published by the
    /// CA.</p>
    pub fn cps_uri(&self) -> std::option::Option<&str> {
        self.cps_uri.as_deref()
    }
}
impl std::fmt::Debug for Qualifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Qualifier");
        formatter.field("cps_uri", &self.cps_uri);
        formatter.finish()
    }
}
/// See [`Qualifier`](crate::model::Qualifier)
pub mod qualifier {
    /// A builder for [`Qualifier`](crate::model::Qualifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cps_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains a pointer to a certification practice statement (CPS) published by the
        /// CA.</p>
        pub fn cps_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.cps_uri = Some(input.into());
            self
        }
        /// <p>Contains a pointer to a certification practice statement (CPS) published by the
        /// CA.</p>
        pub fn set_cps_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cps_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`Qualifier`](crate::model::Qualifier)
        pub fn build(self) -> crate::model::Qualifier {
            crate::model::Qualifier {
                cps_uri: self.cps_uri,
            }
        }
    }
}
impl Qualifier {
    /// Creates a new builder-style object to manufacture [`Qualifier`](crate::model::Qualifier)
    pub fn builder() -> crate::model::qualifier::Builder {
        crate::model::qualifier::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyQualifierId {
    #[allow(missing_docs)] // documentation missing in model
    Cps,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyQualifierId {
    fn from(s: &str) -> Self {
        match s {
            "CPS" => PolicyQualifierId::Cps,
            other => PolicyQualifierId::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyQualifierId {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyQualifierId::from(s))
    }
}
impl PolicyQualifierId {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyQualifierId::Cps => "CPS",
            PolicyQualifierId::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CPS"]
    }
}
impl AsRef<str> for PolicyQualifierId {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuditReportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuditReportStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATING" => AuditReportStatus::Creating,
            "FAILED" => AuditReportStatus::Failed,
            "SUCCESS" => AuditReportStatus::Success,
            other => AuditReportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuditReportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuditReportStatus::from(s))
    }
}
impl AuditReportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuditReportStatus::Creating => "CREATING",
            AuditReportStatus::Failed => "FAILED",
            AuditReportStatus::Success => "SUCCESS",
            AuditReportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATING", "FAILED", "SUCCESS"]
    }
}
impl AsRef<str> for AuditReportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuditReportResponseFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuditReportResponseFormat {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => AuditReportResponseFormat::Csv,
            "JSON" => AuditReportResponseFormat::Json,
            other => AuditReportResponseFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuditReportResponseFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuditReportResponseFormat::from(s))
    }
}
impl AuditReportResponseFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuditReportResponseFormat::Csv => "CSV",
            AuditReportResponseFormat::Json => "JSON",
            AuditReportResponseFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "JSON"]
    }
}
impl AsRef<str> for AuditReportResponseFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
