// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateCertificateAuthorityInput`](crate::input::CreateCertificateAuthorityInput)
pub mod create_certificate_authority_input {
    /// A builder for [`CreateCertificateAuthorityInput`](crate::input::CreateCertificateAuthorityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_configuration:
            std::option::Option<crate::model::CertificateAuthorityConfiguration>,
        pub(crate) revocation_configuration:
            std::option::Option<crate::model::RevocationConfiguration>,
        pub(crate) certificate_authority_type:
            std::option::Option<crate::model::CertificateAuthorityType>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
        pub(crate) key_storage_security_standard:
            std::option::Option<crate::model::KeyStorageSecurityStandard>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Name and bit size of the private key algorithm, the name of the signing algorithm, and
        /// X.500 certificate subject information.</p>
        pub fn certificate_authority_configuration(
            mut self,
            input: crate::model::CertificateAuthorityConfiguration,
        ) -> Self {
            self.certificate_authority_configuration = Some(input);
            self
        }
        /// <p>Name and bit size of the private key algorithm, the name of the signing algorithm, and
        /// X.500 certificate subject information.</p>
        pub fn set_certificate_authority_configuration(
            mut self,
            input: std::option::Option<crate::model::CertificateAuthorityConfiguration>,
        ) -> Self {
            self.certificate_authority_configuration = input;
            self
        }
        /// <p>Contains information to enable Online Certificate Status Protocol (OCSP) support,
        /// to enable a certificate revocation list (CRL), to enable both, or to enable neither. The
        /// default is for both certificate validation mechanisms to be disabled. For more
        /// information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
        pub fn revocation_configuration(
            mut self,
            input: crate::model::RevocationConfiguration,
        ) -> Self {
            self.revocation_configuration = Some(input);
            self
        }
        /// <p>Contains information to enable Online Certificate Status Protocol (OCSP) support,
        /// to enable a certificate revocation list (CRL), to enable both, or to enable neither. The
        /// default is for both certificate validation mechanisms to be disabled. For more
        /// information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
        pub fn set_revocation_configuration(
            mut self,
            input: std::option::Option<crate::model::RevocationConfiguration>,
        ) -> Self {
            self.revocation_configuration = input;
            self
        }
        /// <p>The type of the certificate authority.</p>
        pub fn certificate_authority_type(
            mut self,
            input: crate::model::CertificateAuthorityType,
        ) -> Self {
            self.certificate_authority_type = Some(input);
            self
        }
        /// <p>The type of the certificate authority.</p>
        pub fn set_certificate_authority_type(
            mut self,
            input: std::option::Option<crate::model::CertificateAuthorityType>,
        ) -> Self {
            self.certificate_authority_type = input;
            self
        }
        /// <p>Custom string that can be used to distinguish between calls to the <b>CreateCertificateAuthority</b> action. Idempotency tokens for
        /// <b>CreateCertificateAuthority</b> time out after five
        /// minutes. Therefore, if you call <b>CreateCertificateAuthority</b> multiple times with the same idempotency
        /// token within five minutes, ACM Private CA recognizes that you are requesting only certificate
        /// authority and will issue only one. If you change the idempotency token for each call,
        /// PCA recognizes that you are requesting multiple certificate authorities.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>Custom string that can be used to distinguish between calls to the <b>CreateCertificateAuthority</b> action. Idempotency tokens for
        /// <b>CreateCertificateAuthority</b> time out after five
        /// minutes. Therefore, if you call <b>CreateCertificateAuthority</b> multiple times with the same idempotency
        /// token within five minutes, ACM Private CA recognizes that you are requesting only certificate
        /// authority and will issue only one. If you change the idempotency token for each call,
        /// PCA recognizes that you are requesting multiple certificate authorities.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// <p>Specifies a
        /// cryptographic key management compliance standard used for handling CA keys.</p>
        /// <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p>
        /// <p>Note: <code>FIPS_140_2_LEVEL_3_OR_HIGHER</code> is not supported in Region
        /// ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide
        /// <code>FIPS_140_2_LEVEL_2_OR_HIGHER</code> as the argument for
        /// <code>KeyStorageSecurityStandard</code>. Failure to do this results in an
        /// <code>InvalidArgsException</code> with the message, "A certificate authority cannot
        /// be created in this region with the specified security standard."</p>
        pub fn key_storage_security_standard(
            mut self,
            input: crate::model::KeyStorageSecurityStandard,
        ) -> Self {
            self.key_storage_security_standard = Some(input);
            self
        }
        /// <p>Specifies a
        /// cryptographic key management compliance standard used for handling CA keys.</p>
        /// <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p>
        /// <p>Note: <code>FIPS_140_2_LEVEL_3_OR_HIGHER</code> is not supported in Region
        /// ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide
        /// <code>FIPS_140_2_LEVEL_2_OR_HIGHER</code> as the argument for
        /// <code>KeyStorageSecurityStandard</code>. Failure to do this results in an
        /// <code>InvalidArgsException</code> with the message, "A certificate authority cannot
        /// be created in this region with the specified security standard."</p>
        pub fn set_key_storage_security_standard(
            mut self,
            input: std::option::Option<crate::model::KeyStorageSecurityStandard>,
        ) -> Self {
            self.key_storage_security_standard = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs that will be attached to the new private CA. You can associate up to
        /// 50 tags with a private CA. For information using tags with IAM to manage permissions,
        /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Key-value pairs that will be attached to the new private CA. You can associate up to
        /// 50 tags with a private CA. For information using tags with IAM to manage permissions,
        /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCertificateAuthorityInput`](crate::input::CreateCertificateAuthorityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCertificateAuthorityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCertificateAuthorityInput {
                certificate_authority_configuration: self.certificate_authority_configuration,
                revocation_configuration: self.revocation_configuration,
                certificate_authority_type: self.certificate_authority_type,
                idempotency_token: self.idempotency_token,
                key_storage_security_standard: self.key_storage_security_standard,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCertificateAuthorityInputOperationOutputAlias =
    crate::operation::CreateCertificateAuthority;
#[doc(hidden)]
pub type CreateCertificateAuthorityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCertificateAuthorityInput {
    /// Consumes the builder and constructs an Operation<[`CreateCertificateAuthority`](crate::operation::CreateCertificateAuthority)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCertificateAuthority,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCertificateAuthorityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCertificateAuthorityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCertificateAuthorityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.CreateCertificateAuthority",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_certificate_authority(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCertificateAuthority::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCertificateAuthority",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCertificateAuthorityInput`](crate::input::CreateCertificateAuthorityInput)
    pub fn builder() -> crate::input::create_certificate_authority_input::Builder {
        crate::input::create_certificate_authority_input::Builder::default()
    }
}

/// See [`CreateCertificateAuthorityAuditReportInput`](crate::input::CreateCertificateAuthorityAuditReportInput)
pub mod create_certificate_authority_audit_report_input {
    /// A builder for [`CreateCertificateAuthorityAuditReportInput`](crate::input::CreateCertificateAuthorityAuditReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) audit_report_response_format:
            std::option::Option<crate::model::AuditReportResponseFormat>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:</p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.</p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:</p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.</p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>The name of the S3 bucket that will contain the audit report.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket that will contain the audit report.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.</p>
        pub fn audit_report_response_format(
            mut self,
            input: crate::model::AuditReportResponseFormat,
        ) -> Self {
            self.audit_report_response_format = Some(input);
            self
        }
        /// <p>The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.</p>
        pub fn set_audit_report_response_format(
            mut self,
            input: std::option::Option<crate::model::AuditReportResponseFormat>,
        ) -> Self {
            self.audit_report_response_format = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCertificateAuthorityAuditReportInput`](crate::input::CreateCertificateAuthorityAuditReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCertificateAuthorityAuditReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCertificateAuthorityAuditReportInput {
                certificate_authority_arn: self.certificate_authority_arn,
                s3_bucket_name: self.s3_bucket_name,
                audit_report_response_format: self.audit_report_response_format,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCertificateAuthorityAuditReportInputOperationOutputAlias =
    crate::operation::CreateCertificateAuthorityAuditReport;
#[doc(hidden)]
pub type CreateCertificateAuthorityAuditReportInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl CreateCertificateAuthorityAuditReportInput {
    /// Consumes the builder and constructs an Operation<[`CreateCertificateAuthorityAuditReport`](crate::operation::CreateCertificateAuthorityAuditReport)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCertificateAuthorityAuditReport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCertificateAuthorityAuditReportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCertificateAuthorityAuditReportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCertificateAuthorityAuditReportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.CreateCertificateAuthorityAuditReport",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_certificate_authority_audit_report(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCertificateAuthorityAuditReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCertificateAuthorityAuditReport",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCertificateAuthorityAuditReportInput`](crate::input::CreateCertificateAuthorityAuditReportInput)
    pub fn builder() -> crate::input::create_certificate_authority_audit_report_input::Builder {
        crate::input::create_certificate_authority_audit_report_input::Builder::default()
    }
}

/// See [`CreatePermissionInput`](crate::input::CreatePermissionInput)
pub mod create_permission_input {
    /// A builder for [`CreatePermissionInput`](crate::input::CreatePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) source_account: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::ActionType>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the
        /// ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the
        /// ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>The AWS service or identity that receives the permission. At this time, the only
        /// valid principal is <code>acm.amazonaws.com</code>.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The AWS service or identity that receives the permission. At this time, the only
        /// valid principal is <code>acm.amazonaws.com</code>.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// <p>The ID of the calling account.</p>
        pub fn source_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_account = Some(input.into());
            self
        }
        /// <p>The ID of the calling account.</p>
        pub fn set_source_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_account = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions that the specified AWS service principal can use. These include
        /// <code>IssueCertificate</code>, <code>GetCertificate</code>, and
        /// <code>ListPermissions</code>.</p>
        pub fn actions(mut self, input: impl Into<crate::model::ActionType>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The actions that the specified AWS service principal can use. These include
        /// <code>IssueCertificate</code>, <code>GetCertificate</code>, and
        /// <code>ListPermissions</code>.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionType>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePermissionInput`](crate::input::CreatePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePermissionInput {
                certificate_authority_arn: self.certificate_authority_arn,
                principal: self.principal,
                source_account: self.source_account,
                actions: self.actions,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePermissionInputOperationOutputAlias = crate::operation::CreatePermission;
#[doc(hidden)]
pub type CreatePermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePermissionInput {
    /// Consumes the builder and constructs an Operation<[`CreatePermission`](crate::operation::CreatePermission)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.CreatePermission",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_permission(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePermission",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePermissionInput`](crate::input::CreatePermissionInput)
    pub fn builder() -> crate::input::create_permission_input::Builder {
        crate::input::create_permission_input::Builder::default()
    }
}

/// See [`DeleteCertificateAuthorityInput`](crate::input::DeleteCertificateAuthorityInput)
pub mod delete_certificate_authority_input {
    /// A builder for [`DeleteCertificateAuthorityInput`](crate::input::DeleteCertificateAuthorityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) permanent_deletion_time_in_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must have the following form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must have the following form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>The number of days to make a CA restorable after it has been deleted. This can be
        /// anywhere from 7 to 30 days, with 30 being the default.</p>
        pub fn permanent_deletion_time_in_days(mut self, input: i32) -> Self {
            self.permanent_deletion_time_in_days = Some(input);
            self
        }
        /// <p>The number of days to make a CA restorable after it has been deleted. This can be
        /// anywhere from 7 to 30 days, with 30 being the default.</p>
        pub fn set_permanent_deletion_time_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.permanent_deletion_time_in_days = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCertificateAuthorityInput`](crate::input::DeleteCertificateAuthorityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCertificateAuthorityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCertificateAuthorityInput {
                certificate_authority_arn: self.certificate_authority_arn,
                permanent_deletion_time_in_days: self.permanent_deletion_time_in_days,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCertificateAuthorityInputOperationOutputAlias =
    crate::operation::DeleteCertificateAuthority;
#[doc(hidden)]
pub type DeleteCertificateAuthorityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCertificateAuthorityInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCertificateAuthority`](crate::operation::DeleteCertificateAuthority)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCertificateAuthority,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCertificateAuthorityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCertificateAuthorityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCertificateAuthorityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.DeleteCertificateAuthority",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_certificate_authority(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCertificateAuthority::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCertificateAuthority",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCertificateAuthorityInput`](crate::input::DeleteCertificateAuthorityInput)
    pub fn builder() -> crate::input::delete_certificate_authority_input::Builder {
        crate::input::delete_certificate_authority_input::Builder::default()
    }
}

/// See [`DeletePermissionInput`](crate::input::DeletePermissionInput)
pub mod delete_permission_input {
    /// A builder for [`DeletePermissionInput`](crate::input::DeletePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) source_account: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the private CA that issued the permissions. You
        /// can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA that issued the permissions. You
        /// can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>The AWS service or identity that will have its CA permissions revoked. At this time,
        /// the only valid service principal is <code>acm.amazonaws.com</code>
        /// </p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The AWS service or identity that will have its CA permissions revoked. At this time,
        /// the only valid service principal is <code>acm.amazonaws.com</code>
        /// </p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// <p>The AWS account that calls this action.</p>
        pub fn source_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_account = Some(input.into());
            self
        }
        /// <p>The AWS account that calls this action.</p>
        pub fn set_source_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_account = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePermissionInput`](crate::input::DeletePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePermissionInput {
                certificate_authority_arn: self.certificate_authority_arn,
                principal: self.principal,
                source_account: self.source_account,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePermissionInputOperationOutputAlias = crate::operation::DeletePermission;
#[doc(hidden)]
pub type DeletePermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePermissionInput {
    /// Consumes the builder and constructs an Operation<[`DeletePermission`](crate::operation::DeletePermission)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.DeletePermission",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_permission(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePermission",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePermissionInput`](crate::input::DeletePermissionInput)
    pub fn builder() -> crate::input::delete_permission_input::Builder {
        crate::input::delete_permission_input::Builder::default()
    }
}

/// See [`DeletePolicyInput`](crate::input::DeletePolicyInput)
pub mod delete_policy_input {
    /// A builder for [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the private CA that will have its policy deleted.
        /// You can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. The ARN value must have the form
        /// <code>arn:aws:acm-pca:region:account:certificate-authority/01234567-89ab-cdef-0123-0123456789ab</code>.
        /// </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA that will have its policy deleted.
        /// You can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. The ARN value must have the form
        /// <code>arn:aws:acm-pca:region:account:certificate-authority/01234567-89ab-cdef-0123-0123456789ab</code>.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePolicyInput`](crate::input::DeletePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePolicyInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePolicyInputOperationOutputAlias = crate::operation::DeletePolicy;
#[doc(hidden)]
pub type DeletePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeletePolicy`](crate::operation::DeletePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.DeletePolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePolicy",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    pub fn builder() -> crate::input::delete_policy_input::Builder {
        crate::input::delete_policy_input::Builder::default()
    }
}

/// See [`DescribeCertificateAuthorityInput`](crate::input::DescribeCertificateAuthorityInput)
pub mod describe_certificate_authority_input {
    /// A builder for [`DescribeCertificateAuthorityInput`](crate::input::DescribeCertificateAuthorityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCertificateAuthorityInput`](crate::input::DescribeCertificateAuthorityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCertificateAuthorityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCertificateAuthorityInput {
                certificate_authority_arn: self.certificate_authority_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCertificateAuthorityInputOperationOutputAlias =
    crate::operation::DescribeCertificateAuthority;
#[doc(hidden)]
pub type DescribeCertificateAuthorityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCertificateAuthorityInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCertificateAuthority`](crate::operation::DescribeCertificateAuthority)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCertificateAuthority,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCertificateAuthorityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCertificateAuthorityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCertificateAuthorityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.DescribeCertificateAuthority",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_certificate_authority(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCertificateAuthority::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCertificateAuthority",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCertificateAuthorityInput`](crate::input::DescribeCertificateAuthorityInput)
    pub fn builder() -> crate::input::describe_certificate_authority_input::Builder {
        crate::input::describe_certificate_authority_input::Builder::default()
    }
}

/// See [`DescribeCertificateAuthorityAuditReportInput`](crate::input::DescribeCertificateAuthorityAuditReportInput)
pub mod describe_certificate_authority_audit_report_input {
    /// A builder for [`DescribeCertificateAuthorityAuditReportInput`](crate::input::DescribeCertificateAuthorityAuditReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) audit_report_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the private CA. This must be of the form:</p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the private CA. This must be of the form:</p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>The report ID returned by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a> action.</p>
        pub fn audit_report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_report_id = Some(input.into());
            self
        }
        /// <p>The report ID returned by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a> action.</p>
        pub fn set_audit_report_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_report_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCertificateAuthorityAuditReportInput`](crate::input::DescribeCertificateAuthorityAuditReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCertificateAuthorityAuditReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCertificateAuthorityAuditReportInput {
                certificate_authority_arn: self.certificate_authority_arn,
                audit_report_id: self.audit_report_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCertificateAuthorityAuditReportInputOperationOutputAlias =
    crate::operation::DescribeCertificateAuthorityAuditReport;
#[doc(hidden)]
pub type DescribeCertificateAuthorityAuditReportInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeCertificateAuthorityAuditReportInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCertificateAuthorityAuditReport`](crate::operation::DescribeCertificateAuthorityAuditReport)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCertificateAuthorityAuditReport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCertificateAuthorityAuditReportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCertificateAuthorityAuditReportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCertificateAuthorityAuditReportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.DescribeCertificateAuthorityAuditReport",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_certificate_authority_audit_report(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCertificateAuthorityAuditReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCertificateAuthorityAuditReport",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCertificateAuthorityAuditReportInput`](crate::input::DescribeCertificateAuthorityAuditReportInput)
    pub fn builder() -> crate::input::describe_certificate_authority_audit_report_input::Builder {
        crate::input::describe_certificate_authority_audit_report_input::Builder::default()
    }
}

/// See [`GetCertificateInput`](crate::input::GetCertificateInput)
pub mod get_certificate_input {
    /// A builder for [`GetCertificateInput`](crate::input::GetCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>The ARN of the issued certificate. The ARN contains the certificate serial number and
        /// must be in the following form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i>
        /// </code>
        /// </p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the issued certificate. The ARN contains the certificate serial number and
        /// must be in the following form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i>
        /// </code>
        /// </p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCertificateInput`](crate::input::GetCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCertificateInput {
                certificate_authority_arn: self.certificate_authority_arn,
                certificate_arn: self.certificate_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCertificateInputOperationOutputAlias = crate::operation::GetCertificate;
#[doc(hidden)]
pub type GetCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCertificateInput {
    /// Consumes the builder and constructs an Operation<[`GetCertificate`](crate::operation::GetCertificate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.GetCertificate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_certificate(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCertificate",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCertificateInput`](crate::input::GetCertificateInput)
    pub fn builder() -> crate::input::get_certificate_input::Builder {
        crate::input::get_certificate_input::Builder::default()
    }
}

/// See [`GetCertificateAuthorityCertificateInput`](crate::input::GetCertificateAuthorityCertificateInput)
pub mod get_certificate_authority_certificate_input {
    /// A builder for [`GetCertificateAuthorityCertificateInput`](crate::input::GetCertificateAuthorityCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of your private CA. This is of the form:</p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of your private CA. This is of the form:</p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>.
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCertificateAuthorityCertificateInput`](crate::input::GetCertificateAuthorityCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCertificateAuthorityCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCertificateAuthorityCertificateInput {
                certificate_authority_arn: self.certificate_authority_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCertificateAuthorityCertificateInputOperationOutputAlias =
    crate::operation::GetCertificateAuthorityCertificate;
#[doc(hidden)]
pub type GetCertificateAuthorityCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCertificateAuthorityCertificateInput {
    /// Consumes the builder and constructs an Operation<[`GetCertificateAuthorityCertificate`](crate::operation::GetCertificateAuthorityCertificate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCertificateAuthorityCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCertificateAuthorityCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCertificateAuthorityCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCertificateAuthorityCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.GetCertificateAuthorityCertificate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_certificate_authority_certificate(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCertificateAuthorityCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCertificateAuthorityCertificate",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCertificateAuthorityCertificateInput`](crate::input::GetCertificateAuthorityCertificateInput)
    pub fn builder() -> crate::input::get_certificate_authority_certificate_input::Builder {
        crate::input::get_certificate_authority_certificate_input::Builder::default()
    }
}

/// See [`GetCertificateAuthorityCsrInput`](crate::input::GetCertificateAuthorityCsrInput)
pub mod get_certificate_authority_csr_input {
    /// A builder for [`GetCertificateAuthorityCsrInput`](crate::input::GetCertificateAuthorityCsrInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCertificateAuthorityCsrInput`](crate::input::GetCertificateAuthorityCsrInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCertificateAuthorityCsrInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCertificateAuthorityCsrInput {
                certificate_authority_arn: self.certificate_authority_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCertificateAuthorityCsrInputOperationOutputAlias =
    crate::operation::GetCertificateAuthorityCsr;
#[doc(hidden)]
pub type GetCertificateAuthorityCsrInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCertificateAuthorityCsrInput {
    /// Consumes the builder and constructs an Operation<[`GetCertificateAuthorityCsr`](crate::operation::GetCertificateAuthorityCsr)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCertificateAuthorityCsr,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCertificateAuthorityCsrInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCertificateAuthorityCsrInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCertificateAuthorityCsrInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.GetCertificateAuthorityCsr",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_certificate_authority_csr(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCertificateAuthorityCsr::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCertificateAuthorityCsr",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCertificateAuthorityCsrInput`](crate::input::GetCertificateAuthorityCsrInput)
    pub fn builder() -> crate::input::get_certificate_authority_csr_input::Builder {
        crate::input::get_certificate_authority_csr_input::Builder::default()
    }
}

/// See [`GetPolicyInput`](crate::input::GetPolicyInput)
pub mod get_policy_input {
    /// A builder for [`GetPolicyInput`](crate::input::GetPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the private CA that will have its policy
        /// retrieved. You can find the CA's ARN by calling the ListCertificateAuthorities action.
        ///
        /// </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA that will have its policy
        /// retrieved. You can find the CA's ARN by calling the ListCertificateAuthorities action.
        ///
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyInput`](crate::input::GetPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetPolicyInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetPolicyInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPolicyInputOperationOutputAlias = crate::operation::GetPolicy;
#[doc(hidden)]
pub type GetPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetPolicy`](crate::operation::GetPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.GetPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetPolicy::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetPolicy",
                    "acmpca",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPolicyInput`](crate::input::GetPolicyInput)
    pub fn builder() -> crate::input::get_policy_input::Builder {
        crate::input::get_policy_input::Builder::default()
    }
}

/// See [`ImportCertificateAuthorityCertificateInput`](crate::input::ImportCertificateAuthorityCertificateInput)
pub mod import_certificate_authority_certificate_input {
    /// A builder for [`ImportCertificateAuthorityCertificateInput`](crate::input::ImportCertificateAuthorityCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) certificate: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) certificate_chain: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>The PEM-encoded certificate for a private CA. This may be a self-signed certificate in
        /// the case of a root CA, or it may be signed by another CA that you control.</p>
        pub fn certificate(mut self, input: aws_smithy_types::Blob) -> Self {
            self.certificate = Some(input);
            self
        }
        /// <p>The PEM-encoded certificate for a private CA. This may be a self-signed certificate in
        /// the case of a root CA, or it may be signed by another CA that you control.</p>
        pub fn set_certificate(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.certificate = input;
            self
        }
        /// <p>A PEM-encoded file that contains all of your certificates, other than the certificate
        /// you're importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root
        /// certificate is the last in the chain, and each certificate in the chain signs the one
        /// preceding. </p>
        /// <p>This parameter must be supplied when you import a subordinate CA. When you import a
        /// root CA, there is no chain.</p>
        pub fn certificate_chain(mut self, input: aws_smithy_types::Blob) -> Self {
            self.certificate_chain = Some(input);
            self
        }
        /// <p>A PEM-encoded file that contains all of your certificates, other than the certificate
        /// you're importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root
        /// certificate is the last in the chain, and each certificate in the chain signs the one
        /// preceding. </p>
        /// <p>This parameter must be supplied when you import a subordinate CA. When you import a
        /// root CA, there is no chain.</p>
        pub fn set_certificate_chain(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.certificate_chain = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportCertificateAuthorityCertificateInput`](crate::input::ImportCertificateAuthorityCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportCertificateAuthorityCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportCertificateAuthorityCertificateInput {
                certificate_authority_arn: self.certificate_authority_arn,
                certificate: self.certificate,
                certificate_chain: self.certificate_chain,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportCertificateAuthorityCertificateInputOperationOutputAlias =
    crate::operation::ImportCertificateAuthorityCertificate;
#[doc(hidden)]
pub type ImportCertificateAuthorityCertificateInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl ImportCertificateAuthorityCertificateInput {
    /// Consumes the builder and constructs an Operation<[`ImportCertificateAuthorityCertificate`](crate::operation::ImportCertificateAuthorityCertificate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportCertificateAuthorityCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportCertificateAuthorityCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportCertificateAuthorityCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportCertificateAuthorityCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.ImportCertificateAuthorityCertificate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_import_certificate_authority_certificate(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportCertificateAuthorityCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportCertificateAuthorityCertificate",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportCertificateAuthorityCertificateInput`](crate::input::ImportCertificateAuthorityCertificateInput)
    pub fn builder() -> crate::input::import_certificate_authority_certificate_input::Builder {
        crate::input::import_certificate_authority_certificate_input::Builder::default()
    }
}

/// See [`IssueCertificateInput`](crate::input::IssueCertificateInput)
pub mod issue_certificate_input {
    /// A builder for [`IssueCertificateInput`](crate::input::IssueCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_passthrough: std::option::Option<crate::model::ApiPassthrough>,
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) csr: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) signing_algorithm: std::option::Option<crate::model::SigningAlgorithm>,
        pub(crate) template_arn: std::option::Option<std::string::String>,
        pub(crate) validity: std::option::Option<crate::model::Validity>,
        pub(crate) validity_not_before: std::option::Option<crate::model::Validity>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies X.509 certificate information to be included in the issued certificate. An
        /// <code>APIPassthrough</code> or <code>APICSRPassthrough</code> template variant must
        /// be selected, or else this parameter is ignored. For more information about using these
        /// templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate Templates</a>.</p>
        /// <p>If conflicting or duplicate certificate information is supplied during certificate
        /// issuance, ACM Private CA applies <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">order of
        /// operation rules</a> to determine what information is used.</p>
        pub fn api_passthrough(mut self, input: crate::model::ApiPassthrough) -> Self {
            self.api_passthrough = Some(input);
            self
        }
        /// <p>Specifies X.509 certificate information to be included in the issued certificate. An
        /// <code>APIPassthrough</code> or <code>APICSRPassthrough</code> template variant must
        /// be selected, or else this parameter is ignored. For more information about using these
        /// templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate Templates</a>.</p>
        /// <p>If conflicting or duplicate certificate information is supplied during certificate
        /// issuance, ACM Private CA applies <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">order of
        /// operation rules</a> to determine what information is used.</p>
        pub fn set_api_passthrough(
            mut self,
            input: std::option::Option<crate::model::ApiPassthrough>,
        ) -> Self {
            self.api_passthrough = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form:</p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form:</p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>The certificate signing request (CSR) for the certificate you want to issue. As an
        /// example, you can use the following OpenSSL command to create the CSR and a 2048 bit RSA
        /// private key. </p>
        /// <p>
        /// <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem
        /// -out csr/test_cert_.csr</code>
        /// </p>
        /// <p>If you have a configuration file, you can then use the following OpenSSL command. The
        /// <code>usr_cert</code> block in the configuration file contains your X509 version 3
        /// extensions. </p>
        /// <p>
        /// <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048
        /// -days -365 -keyout private/test_cert_priv_key.pem -out
        /// csr/test_cert_.csr</code>
        /// </p>
        /// <p>Note: A CSR must provide either a <i>subject name</i> or a
        /// <i>subject alternative name</i> or the request will be rejected.
        /// </p>
        pub fn csr(mut self, input: aws_smithy_types::Blob) -> Self {
            self.csr = Some(input);
            self
        }
        /// <p>The certificate signing request (CSR) for the certificate you want to issue. As an
        /// example, you can use the following OpenSSL command to create the CSR and a 2048 bit RSA
        /// private key. </p>
        /// <p>
        /// <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem
        /// -out csr/test_cert_.csr</code>
        /// </p>
        /// <p>If you have a configuration file, you can then use the following OpenSSL command. The
        /// <code>usr_cert</code> block in the configuration file contains your X509 version 3
        /// extensions. </p>
        /// <p>
        /// <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048
        /// -days -365 -keyout private/test_cert_priv_key.pem -out
        /// csr/test_cert_.csr</code>
        /// </p>
        /// <p>Note: A CSR must provide either a <i>subject name</i> or a
        /// <i>subject alternative name</i> or the request will be rejected.
        /// </p>
        pub fn set_csr(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.csr = input;
            self
        }
        /// <p>The name of the algorithm that will be used to sign the certificate to be issued. </p>
        /// <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter
        /// used to sign a CSR in the <code>CreateCertificateAuthority</code> action.</p>
        pub fn signing_algorithm(mut self, input: crate::model::SigningAlgorithm) -> Self {
            self.signing_algorithm = Some(input);
            self
        }
        /// <p>The name of the algorithm that will be used to sign the certificate to be issued. </p>
        /// <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter
        /// used to sign a CSR in the <code>CreateCertificateAuthority</code> action.</p>
        pub fn set_signing_algorithm(
            mut self,
            input: std::option::Option<crate::model::SigningAlgorithm>,
        ) -> Self {
            self.signing_algorithm = input;
            self
        }
        /// <p>Specifies a custom configuration template to use when issuing a certificate. If this
        /// parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code>
        /// template. For CA certificates, you should choose the shortest path length that meets
        /// your needs. The path length is indicated by the PathLen<i>N</i> portion of
        /// the ARN, where <i>N</i> is the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaTerms.html#terms-cadepth">CA depth</a>.</p>
        /// <p>Note: The CA depth configured on a subordinate CA certificate must not exceed the
        /// limit set by its parents in the CA hierarchy.</p>
        /// <p>For a list of <code>TemplateArn</code> values supported by ACM Private CA, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate
        /// Templates</a>.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_arn = Some(input.into());
            self
        }
        /// <p>Specifies a custom configuration template to use when issuing a certificate. If this
        /// parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code>
        /// template. For CA certificates, you should choose the shortest path length that meets
        /// your needs. The path length is indicated by the PathLen<i>N</i> portion of
        /// the ARN, where <i>N</i> is the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaTerms.html#terms-cadepth">CA depth</a>.</p>
        /// <p>Note: The CA depth configured on a subordinate CA certificate must not exceed the
        /// limit set by its parents in the CA hierarchy.</p>
        /// <p>For a list of <code>TemplateArn</code> values supported by ACM Private CA, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate
        /// Templates</a>.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_arn = input;
            self
        }
        /// <p>Information describing the end of the validity period of the certificate. This
        /// parameter sets the “Not After” date for the certificate.</p>
        /// <p>Certificate validity is the period of time during which a certificate is valid.
        /// Validity can be expressed as an explicit date and time when the certificate expires, or
        /// as a span of time after issuance, stated in days, months, or years. For more
        /// information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280. </p>
        /// <p>This value is unaffected when <code>ValidityNotBefore</code> is also specified. For
        /// example, if <code>Validity</code> is set to 20 days in the future, the certificate will
        /// expire 20 days from issuance time regardless of the <code>ValidityNotBefore</code>
        /// value.</p>
        /// <p>The end of the validity period configured on a certificate must not exceed the limit
        /// set on its parents in the CA hierarchy.</p>
        pub fn validity(mut self, input: crate::model::Validity) -> Self {
            self.validity = Some(input);
            self
        }
        /// <p>Information describing the end of the validity period of the certificate. This
        /// parameter sets the “Not After” date for the certificate.</p>
        /// <p>Certificate validity is the period of time during which a certificate is valid.
        /// Validity can be expressed as an explicit date and time when the certificate expires, or
        /// as a span of time after issuance, stated in days, months, or years. For more
        /// information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280. </p>
        /// <p>This value is unaffected when <code>ValidityNotBefore</code> is also specified. For
        /// example, if <code>Validity</code> is set to 20 days in the future, the certificate will
        /// expire 20 days from issuance time regardless of the <code>ValidityNotBefore</code>
        /// value.</p>
        /// <p>The end of the validity period configured on a certificate must not exceed the limit
        /// set on its parents in the CA hierarchy.</p>
        pub fn set_validity(mut self, input: std::option::Option<crate::model::Validity>) -> Self {
            self.validity = input;
            self
        }
        /// <p>Information describing the start of the validity period of the certificate. This
        /// parameter sets the “Not Before" date for the certificate.</p>
        /// <p>By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the
        /// issuance time minus 60 minutes. This compensates for clock inconsistencies across
        /// computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize
        /// the “Not Before” value. </p>
        /// <p>Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code>
        /// parameter is optional.</p>
        /// <p>The <code>ValidityNotBefore</code> value is expressed as an explicit date and time,
        /// using the <code>Validity</code> type value <code>ABSOLUTE</code>. For more information,
        /// see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_Validity.html">Validity</a> in this API reference and <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC
        /// 5280.</p>
        pub fn validity_not_before(mut self, input: crate::model::Validity) -> Self {
            self.validity_not_before = Some(input);
            self
        }
        /// <p>Information describing the start of the validity period of the certificate. This
        /// parameter sets the “Not Before" date for the certificate.</p>
        /// <p>By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the
        /// issuance time minus 60 minutes. This compensates for clock inconsistencies across
        /// computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize
        /// the “Not Before” value. </p>
        /// <p>Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code>
        /// parameter is optional.</p>
        /// <p>The <code>ValidityNotBefore</code> value is expressed as an explicit date and time,
        /// using the <code>Validity</code> type value <code>ABSOLUTE</code>. For more information,
        /// see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_Validity.html">Validity</a> in this API reference and <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC
        /// 5280.</p>
        pub fn set_validity_not_before(
            mut self,
            input: std::option::Option<crate::model::Validity>,
        ) -> Self {
            self.validity_not_before = input;
            self
        }
        /// <p>Alphanumeric string that can be used to distinguish between calls to the <b>IssueCertificate</b> action. Idempotency tokens for <b>IssueCertificate</b> time out after one minute. Therefore, if you
        /// call <b>IssueCertificate</b> multiple times with the same
        /// idempotency token within one minute, ACM Private CA recognizes that you are requesting only one
        /// certificate and will issue only one. If you change the idempotency token for each call,
        /// PCA recognizes that you are requesting multiple certificates.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>Alphanumeric string that can be used to distinguish between calls to the <b>IssueCertificate</b> action. Idempotency tokens for <b>IssueCertificate</b> time out after one minute. Therefore, if you
        /// call <b>IssueCertificate</b> multiple times with the same
        /// idempotency token within one minute, ACM Private CA recognizes that you are requesting only one
        /// certificate and will issue only one. If you change the idempotency token for each call,
        /// PCA recognizes that you are requesting multiple certificates.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`IssueCertificateInput`](crate::input::IssueCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::IssueCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::IssueCertificateInput {
                api_passthrough: self.api_passthrough,
                certificate_authority_arn: self.certificate_authority_arn,
                csr: self.csr,
                signing_algorithm: self.signing_algorithm,
                template_arn: self.template_arn,
                validity: self.validity,
                validity_not_before: self.validity_not_before,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type IssueCertificateInputOperationOutputAlias = crate::operation::IssueCertificate;
#[doc(hidden)]
pub type IssueCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl IssueCertificateInput {
    /// Consumes the builder and constructs an Operation<[`IssueCertificate`](crate::operation::IssueCertificate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::IssueCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::IssueCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::IssueCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::IssueCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.IssueCertificate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_issue_certificate(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::IssueCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "IssueCertificate",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`IssueCertificateInput`](crate::input::IssueCertificateInput)
    pub fn builder() -> crate::input::issue_certificate_input::Builder {
        crate::input::issue_certificate_input::Builder::default()
    }
}

/// See [`ListCertificateAuthoritiesInput`](crate::input::ListCertificateAuthoritiesInput)
pub mod list_certificate_authorities_input {
    /// A builder for [`ListCertificateAuthoritiesInput`](crate::input::ListCertificateAuthoritiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) resource_owner: std::option::Option<crate::model::ResourceOwner>,
    }
    impl Builder {
        /// <p>Use this parameter when paginating results in a subsequent request after you receive a
        /// response with truncated results. Set it to the value of the <code>NextToken</code>
        /// parameter from the response you just received.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Use this parameter when paginating results in a subsequent request after you receive a
        /// response with truncated results. Set it to the value of the <code>NextToken</code>
        /// parameter from the response you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Use this parameter when paginating results to specify the maximum number of items to
        /// return in the response on each page. If additional items exist beyond the number you
        /// specify, the <code>NextToken</code> element is sent in the response. Use this
        /// <code>NextToken</code> value in a subsequent request to retrieve additional
        /// items.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Use this parameter when paginating results to specify the maximum number of items to
        /// return in the response on each page. If additional items exist beyond the number you
        /// specify, the <code>NextToken</code> element is sent in the response. Use this
        /// <code>NextToken</code> value in a subsequent request to retrieve additional
        /// items.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Use this parameter to filter the returned set of certificate authorities based on
        /// their owner. The default is SELF.</p>
        pub fn resource_owner(mut self, input: crate::model::ResourceOwner) -> Self {
            self.resource_owner = Some(input);
            self
        }
        /// <p>Use this parameter to filter the returned set of certificate authorities based on
        /// their owner. The default is SELF.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<crate::model::ResourceOwner>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCertificateAuthoritiesInput`](crate::input::ListCertificateAuthoritiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCertificateAuthoritiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCertificateAuthoritiesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                resource_owner: self.resource_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCertificateAuthoritiesInputOperationOutputAlias =
    crate::operation::ListCertificateAuthorities;
#[doc(hidden)]
pub type ListCertificateAuthoritiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCertificateAuthoritiesInput {
    /// Consumes the builder and constructs an Operation<[`ListCertificateAuthorities`](crate::operation::ListCertificateAuthorities)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCertificateAuthorities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCertificateAuthoritiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCertificateAuthoritiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCertificateAuthoritiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.ListCertificateAuthorities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_certificate_authorities(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCertificateAuthorities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCertificateAuthorities",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCertificateAuthoritiesInput`](crate::input::ListCertificateAuthoritiesInput)
    pub fn builder() -> crate::input::list_certificate_authorities_input::Builder {
        crate::input::list_certificate_authorities_input::Builder::default()
    }
}

/// See [`ListPermissionsInput`](crate::input::ListPermissionsInput)
pub mod list_permissions_input {
    /// A builder for [`ListPermissionsInput`](crate::input::ListPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by
        /// calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must be of the form:
        /// <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code>
        /// You can get a private CA's ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by
        /// calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must be of the form:
        /// <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code>
        /// You can get a private CA's ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>When paginating results, use this parameter in a subsequent request after you receive
        /// a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When paginating results, use this parameter in a subsequent request after you receive
        /// a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>When paginating results, use this parameter to specify the maximum number of items to
        /// return in the response. If additional items exist beyond the number you specify, the
        /// <b>NextToken</b> element is sent in the response. Use this
        /// <b>NextToken</b> value in a subsequent request to retrieve
        /// additional items.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>When paginating results, use this parameter to specify the maximum number of items to
        /// return in the response. If additional items exist beyond the number you specify, the
        /// <b>NextToken</b> element is sent in the response. Use this
        /// <b>NextToken</b> value in a subsequent request to retrieve
        /// additional items.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPermissionsInput`](crate::input::ListPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPermissionsInput {
                certificate_authority_arn: self.certificate_authority_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPermissionsInputOperationOutputAlias = crate::operation::ListPermissions;
#[doc(hidden)]
pub type ListPermissionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`ListPermissions`](crate::operation::ListPermissions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPermissions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.ListPermissions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_permissions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPermissions",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPermissionsInput`](crate::input::ListPermissionsInput)
    pub fn builder() -> crate::input::list_permissions_input::Builder {
        crate::input::list_permissions_input::Builder::default()
    }
}

/// See [`ListTagsInput`](crate::input::ListTagsInput)
pub mod list_tags_input {
    /// A builder for [`ListTagsInput`](crate::input::ListTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>Use this parameter when paginating results in a subsequent request after you receive a
        /// response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Use this parameter when paginating results in a subsequent request after you receive a
        /// response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Use this parameter when paginating results to specify the maximum number of items to
        /// return in the response. If additional items exist beyond the number you specify, the
        /// <b>NextToken</b> element is sent in the response. Use this
        /// <b>NextToken</b> value in a subsequent request to retrieve
        /// additional items.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Use this parameter when paginating results to specify the maximum number of items to
        /// return in the response. If additional items exist beyond the number you specify, the
        /// <b>NextToken</b> element is sent in the response. Use this
        /// <b>NextToken</b> value in a subsequent request to retrieve
        /// additional items.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsInput`](crate::input::ListTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTagsInput {
                certificate_authority_arn: self.certificate_authority_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsInputOperationOutputAlias = crate::operation::ListTags;
#[doc(hidden)]
pub type ListTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListTags`](crate::operation::ListTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.ListTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTags", "acmpca",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
}

/// See [`PutPolicyInput`](crate::input::PutPolicyInput)
pub mod put_policy_input {
    /// A builder for [`PutPolicyInput`](crate::input::PutPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the private CA to associate with the policy. The
        /// ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
        /// <p></p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the private CA to associate with the policy. The
        /// ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
        /// <p></p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The path and file name of a JSON-formatted IAM policy to attach to the specified
        /// private CA resource. If this policy does not contain all required statements or if it
        /// includes any statement that is not allowed, the <code>PutPolicy</code> action returns an
        /// <code>InvalidPolicyException</code>. For information about IAM policy and
        /// statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The path and file name of a JSON-formatted IAM policy to attach to the specified
        /// private CA resource. If this policy does not contain all required statements or if it
        /// includes any statement that is not allowed, the <code>PutPolicy</code> action returns an
        /// <code>InvalidPolicyException</code>. For information about IAM policy and
        /// statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutPolicyInput`](crate::input::PutPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutPolicyInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutPolicyInput {
                resource_arn: self.resource_arn,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutPolicyInputOperationOutputAlias = crate::operation::PutPolicy;
#[doc(hidden)]
pub type PutPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutPolicy`](crate::operation::PutPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.PutPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutPolicy::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutPolicy",
                    "acmpca",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutPolicyInput`](crate::input::PutPolicyInput)
    pub fn builder() -> crate::input::put_policy_input::Builder {
        crate::input::put_policy_input::Builder::default()
    }
}

/// See [`RestoreCertificateAuthorityInput`](crate::input::RestoreCertificateAuthorityInput)
pub mod restore_certificate_authority_input {
    /// A builder for [`RestoreCertificateAuthorityInput`](crate::input::RestoreCertificateAuthorityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreCertificateAuthorityInput`](crate::input::RestoreCertificateAuthorityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestoreCertificateAuthorityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestoreCertificateAuthorityInput {
                certificate_authority_arn: self.certificate_authority_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RestoreCertificateAuthorityInputOperationOutputAlias =
    crate::operation::RestoreCertificateAuthority;
#[doc(hidden)]
pub type RestoreCertificateAuthorityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RestoreCertificateAuthorityInput {
    /// Consumes the builder and constructs an Operation<[`RestoreCertificateAuthority`](crate::operation::RestoreCertificateAuthority)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestoreCertificateAuthority,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RestoreCertificateAuthorityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RestoreCertificateAuthorityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RestoreCertificateAuthorityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.RestoreCertificateAuthority",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_restore_certificate_authority(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestoreCertificateAuthority::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestoreCertificateAuthority",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RestoreCertificateAuthorityInput`](crate::input::RestoreCertificateAuthorityInput)
    pub fn builder() -> crate::input::restore_certificate_authority_input::Builder {
        crate::input::restore_certificate_authority_input::Builder::default()
    }
}

/// See [`RevokeCertificateInput`](crate::input::RevokeCertificateInput)
pub mod revoke_certificate_input {
    /// A builder for [`RevokeCertificateInput`](crate::input::RevokeCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_serial: std::option::Option<std::string::String>,
        pub(crate) revocation_reason: std::option::Option<crate::model::RevocationReason>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be
        /// revoked. This must be of the form:</p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be
        /// revoked. This must be of the form:</p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>Serial number of the certificate to be revoked. This must be in hexadecimal format.
        /// You can retrieve the serial number by calling <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate</a> with the Amazon
        /// Resource Name (ARN) of the certificate you want and the ARN of your private CA. The
        /// <b>GetCertificate</b> action retrieves the certificate in
        /// the PEM format. You can use the following OpenSSL command to list the certificate in
        /// text format and copy the hexadecimal serial number. </p>
        /// <p>
        /// <code>openssl x509 -in <i>file_path</i> -text -noout</code>
        /// </p>
        /// <p>You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate</a> action in the <i>AWS Certificate Manager API
        /// Reference</i>. </p>
        pub fn certificate_serial(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_serial = Some(input.into());
            self
        }
        /// <p>Serial number of the certificate to be revoked. This must be in hexadecimal format.
        /// You can retrieve the serial number by calling <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate</a> with the Amazon
        /// Resource Name (ARN) of the certificate you want and the ARN of your private CA. The
        /// <b>GetCertificate</b> action retrieves the certificate in
        /// the PEM format. You can use the following OpenSSL command to list the certificate in
        /// text format and copy the hexadecimal serial number. </p>
        /// <p>
        /// <code>openssl x509 -in <i>file_path</i> -text -noout</code>
        /// </p>
        /// <p>You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate</a> action in the <i>AWS Certificate Manager API
        /// Reference</i>. </p>
        pub fn set_certificate_serial(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_serial = input;
            self
        }
        /// <p>Specifies why you revoked the certificate.</p>
        pub fn revocation_reason(mut self, input: crate::model::RevocationReason) -> Self {
            self.revocation_reason = Some(input);
            self
        }
        /// <p>Specifies why you revoked the certificate.</p>
        pub fn set_revocation_reason(
            mut self,
            input: std::option::Option<crate::model::RevocationReason>,
        ) -> Self {
            self.revocation_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeCertificateInput`](crate::input::RevokeCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RevokeCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RevokeCertificateInput {
                certificate_authority_arn: self.certificate_authority_arn,
                certificate_serial: self.certificate_serial,
                revocation_reason: self.revocation_reason,
            })
        }
    }
}
#[doc(hidden)]
pub type RevokeCertificateInputOperationOutputAlias = crate::operation::RevokeCertificate;
#[doc(hidden)]
pub type RevokeCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RevokeCertificateInput {
    /// Consumes the builder and constructs an Operation<[`RevokeCertificate`](crate::operation::RevokeCertificate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RevokeCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RevokeCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RevokeCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RevokeCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.RevokeCertificate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_revoke_certificate(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RevokeCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RevokeCertificate",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RevokeCertificateInput`](crate::input::RevokeCertificateInput)
    pub fn builder() -> crate::input::revoke_certificate_input::Builder {
        crate::input::revoke_certificate_input::Builder::default()
    }
}

/// See [`TagCertificateAuthorityInput`](crate::input::TagCertificateAuthorityInput)
pub mod tag_certificate_authority_input {
    /// A builder for [`TagCertificateAuthorityInput`](crate::input::TagCertificateAuthorityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>List of tags to be associated with the CA.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>List of tags to be associated with the CA.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagCertificateAuthorityInput`](crate::input::TagCertificateAuthorityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagCertificateAuthorityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagCertificateAuthorityInput {
                certificate_authority_arn: self.certificate_authority_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagCertificateAuthorityInputOperationOutputAlias =
    crate::operation::TagCertificateAuthority;
#[doc(hidden)]
pub type TagCertificateAuthorityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagCertificateAuthorityInput {
    /// Consumes the builder and constructs an Operation<[`TagCertificateAuthority`](crate::operation::TagCertificateAuthority)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagCertificateAuthority,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagCertificateAuthorityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagCertificateAuthorityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagCertificateAuthorityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.TagCertificateAuthority",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_tag_certificate_authority(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagCertificateAuthority::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagCertificateAuthority",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagCertificateAuthorityInput`](crate::input::TagCertificateAuthorityInput)
    pub fn builder() -> crate::input::tag_certificate_authority_input::Builder {
        crate::input::tag_certificate_authority_input::Builder::default()
    }
}

/// See [`UntagCertificateAuthorityInput`](crate::input::UntagCertificateAuthorityInput)
pub mod untag_certificate_authority_input {
    /// A builder for [`UntagCertificateAuthorityInput`](crate::input::UntagCertificateAuthorityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>List of tags to be removed from the CA.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>List of tags to be removed from the CA.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagCertificateAuthorityInput`](crate::input::UntagCertificateAuthorityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagCertificateAuthorityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagCertificateAuthorityInput {
                certificate_authority_arn: self.certificate_authority_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagCertificateAuthorityInputOperationOutputAlias =
    crate::operation::UntagCertificateAuthority;
#[doc(hidden)]
pub type UntagCertificateAuthorityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagCertificateAuthorityInput {
    /// Consumes the builder and constructs an Operation<[`UntagCertificateAuthority`](crate::operation::UntagCertificateAuthority)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagCertificateAuthority,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagCertificateAuthorityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagCertificateAuthorityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagCertificateAuthorityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.UntagCertificateAuthority",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_untag_certificate_authority(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagCertificateAuthority::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagCertificateAuthority",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagCertificateAuthorityInput`](crate::input::UntagCertificateAuthorityInput)
    pub fn builder() -> crate::input::untag_certificate_authority_input::Builder {
        crate::input::untag_certificate_authority_input::Builder::default()
    }
}

/// See [`UpdateCertificateAuthorityInput`](crate::input::UpdateCertificateAuthorityInput)
pub mod update_certificate_authority_input {
    /// A builder for [`UpdateCertificateAuthorityInput`](crate::input::UpdateCertificateAuthorityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) revocation_configuration:
            std::option::Option<crate::model::RevocationConfiguration>,
        pub(crate) status: std::option::Option<crate::model::CertificateAuthorityStatus>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be
        /// revoked. This must be of the form:</p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be
        /// revoked. This must be of the form:</p>
        /// <p>
        /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
        /// </code>
        /// </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>Contains information to enable Online Certificate Status Protocol (OCSP) support,
        /// to enable a certificate revocation list (CRL), to enable both, or to enable neither. If
        /// this parameter is not supplied, existing capibilites remain unchanged. For more
        /// information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
        pub fn revocation_configuration(
            mut self,
            input: crate::model::RevocationConfiguration,
        ) -> Self {
            self.revocation_configuration = Some(input);
            self
        }
        /// <p>Contains information to enable Online Certificate Status Protocol (OCSP) support,
        /// to enable a certificate revocation list (CRL), to enable both, or to enable neither. If
        /// this parameter is not supplied, existing capibilites remain unchanged. For more
        /// information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
        pub fn set_revocation_configuration(
            mut self,
            input: std::option::Option<crate::model::RevocationConfiguration>,
        ) -> Self {
            self.revocation_configuration = input;
            self
        }
        /// <p>Status of your private CA.</p>
        pub fn status(mut self, input: crate::model::CertificateAuthorityStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of your private CA.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CertificateAuthorityStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCertificateAuthorityInput`](crate::input::UpdateCertificateAuthorityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCertificateAuthorityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCertificateAuthorityInput {
                certificate_authority_arn: self.certificate_authority_arn,
                revocation_configuration: self.revocation_configuration,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCertificateAuthorityInputOperationOutputAlias =
    crate::operation::UpdateCertificateAuthority;
#[doc(hidden)]
pub type UpdateCertificateAuthorityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateCertificateAuthorityInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCertificateAuthority`](crate::operation::UpdateCertificateAuthority)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCertificateAuthority,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateCertificateAuthorityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateCertificateAuthorityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateCertificateAuthorityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "ACMPrivateCA.UpdateCertificateAuthority",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_certificate_authority(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCertificateAuthority::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCertificateAuthority",
            "acmpca",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateCertificateAuthorityInput`](crate::input::UpdateCertificateAuthorityInput)
    pub fn builder() -> crate::input::update_certificate_authority_input::Builder {
        crate::input::update_certificate_authority_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCertificateAuthorityInput {
    /// <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be
    /// revoked. This must be of the form:</p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>Contains information to enable Online Certificate Status Protocol (OCSP) support,
    /// to enable a certificate revocation list (CRL), to enable both, or to enable neither. If
    /// this parameter is not supplied, existing capibilites remain unchanged. For more
    /// information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
    pub revocation_configuration: std::option::Option<crate::model::RevocationConfiguration>,
    /// <p>Status of your private CA.</p>
    pub status: std::option::Option<crate::model::CertificateAuthorityStatus>,
}
impl UpdateCertificateAuthorityInput {
    /// <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be
    /// revoked. This must be of the form:</p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>Contains information to enable Online Certificate Status Protocol (OCSP) support,
    /// to enable a certificate revocation list (CRL), to enable both, or to enable neither. If
    /// this parameter is not supplied, existing capibilites remain unchanged. For more
    /// information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
    pub fn revocation_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RevocationConfiguration> {
        self.revocation_configuration.as_ref()
    }
    /// <p>Status of your private CA.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CertificateAuthorityStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for UpdateCertificateAuthorityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCertificateAuthorityInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("revocation_configuration", &self.revocation_configuration);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagCertificateAuthorityInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>List of tags to be removed from the CA.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl UntagCertificateAuthorityInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>List of tags to be removed from the CA.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for UntagCertificateAuthorityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagCertificateAuthorityInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagCertificateAuthorityInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>List of tags to be associated with the CA.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagCertificateAuthorityInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>List of tags to be associated with the CA.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagCertificateAuthorityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagCertificateAuthorityInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeCertificateInput {
    /// <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be
    /// revoked. This must be of the form:</p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>Serial number of the certificate to be revoked. This must be in hexadecimal format.
    /// You can retrieve the serial number by calling <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate</a> with the Amazon
    /// Resource Name (ARN) of the certificate you want and the ARN of your private CA. The
    /// <b>GetCertificate</b> action retrieves the certificate in
    /// the PEM format. You can use the following OpenSSL command to list the certificate in
    /// text format and copy the hexadecimal serial number. </p>
    /// <p>
    /// <code>openssl x509 -in <i>file_path</i> -text -noout</code>
    /// </p>
    /// <p>You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate</a> action in the <i>AWS Certificate Manager API
    /// Reference</i>. </p>
    pub certificate_serial: std::option::Option<std::string::String>,
    /// <p>Specifies why you revoked the certificate.</p>
    pub revocation_reason: std::option::Option<crate::model::RevocationReason>,
}
impl RevokeCertificateInput {
    /// <p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be
    /// revoked. This must be of the form:</p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>Serial number of the certificate to be revoked. This must be in hexadecimal format.
    /// You can retrieve the serial number by calling <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate</a> with the Amazon
    /// Resource Name (ARN) of the certificate you want and the ARN of your private CA. The
    /// <b>GetCertificate</b> action retrieves the certificate in
    /// the PEM format. You can use the following OpenSSL command to list the certificate in
    /// text format and copy the hexadecimal serial number. </p>
    /// <p>
    /// <code>openssl x509 -in <i>file_path</i> -text -noout</code>
    /// </p>
    /// <p>You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate</a> action in the <i>AWS Certificate Manager API
    /// Reference</i>. </p>
    pub fn certificate_serial(&self) -> std::option::Option<&str> {
        self.certificate_serial.as_deref()
    }
    /// <p>Specifies why you revoked the certificate.</p>
    pub fn revocation_reason(&self) -> std::option::Option<&crate::model::RevocationReason> {
        self.revocation_reason.as_ref()
    }
}
impl std::fmt::Debug for RevokeCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeCertificateInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("certificate_serial", &self.certificate_serial);
        formatter.field("revocation_reason", &self.revocation_reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreCertificateAuthorityInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
}
impl RestoreCertificateAuthorityInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
}
impl std::fmt::Debug for RestoreCertificateAuthorityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreCertificateAuthorityInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPolicyInput {
    /// <p>The Amazon Resource Number (ARN) of the private CA to associate with the policy. The
    /// ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
    /// <p></p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The path and file name of a JSON-formatted IAM policy to attach to the specified
    /// private CA resource. If this policy does not contain all required statements or if it
    /// includes any statement that is not allowed, the <code>PutPolicy</code> action returns an
    /// <code>InvalidPolicyException</code>. For information about IAM policy and
    /// statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutPolicyInput {
    /// <p>The Amazon Resource Number (ARN) of the private CA to associate with the policy. The
    /// ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
    /// <p></p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The path and file name of a JSON-formatted IAM policy to attach to the specified
    /// private CA resource. If this policy does not contain all required statements or if it
    /// includes any statement that is not allowed, the <code>PutPolicy</code> action returns an
    /// <code>InvalidPolicyException</code>. For information about IAM policy and
    /// statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPolicyInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>Use this parameter when paginating results in a subsequent request after you receive a
    /// response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Use this parameter when paginating results to specify the maximum number of items to
    /// return in the response. If additional items exist beyond the number you specify, the
    /// <b>NextToken</b> element is sent in the response. Use this
    /// <b>NextToken</b> value in a subsequent request to retrieve
    /// additional items.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTagsInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>Use this parameter when paginating results in a subsequent request after you receive a
    /// response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Use this parameter when paginating results to specify the maximum number of items to
    /// return in the response. If additional items exist beyond the number you specify, the
    /// <b>NextToken</b> element is sent in the response. Use this
    /// <b>NextToken</b> value in a subsequent request to retrieve
    /// additional items.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPermissionsInput {
    /// <p>The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by
    /// calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must be of the form:
    /// <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code>
    /// You can get a private CA's ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>When paginating results, use this parameter in a subsequent request after you receive
    /// a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>When paginating results, use this parameter to specify the maximum number of items to
    /// return in the response. If additional items exist beyond the number you specify, the
    /// <b>NextToken</b> element is sent in the response. Use this
    /// <b>NextToken</b> value in a subsequent request to retrieve
    /// additional items.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPermissionsInput {
    /// <p>The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by
    /// calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must be of the form:
    /// <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code>
    /// You can get a private CA's ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>When paginating results, use this parameter in a subsequent request after you receive
    /// a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>When paginating results, use this parameter to specify the maximum number of items to
    /// return in the response. If additional items exist beyond the number you specify, the
    /// <b>NextToken</b> element is sent in the response. Use this
    /// <b>NextToken</b> value in a subsequent request to retrieve
    /// additional items.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPermissionsInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCertificateAuthoritiesInput {
    /// <p>Use this parameter when paginating results in a subsequent request after you receive a
    /// response with truncated results. Set it to the value of the <code>NextToken</code>
    /// parameter from the response you just received.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Use this parameter when paginating results to specify the maximum number of items to
    /// return in the response on each page. If additional items exist beyond the number you
    /// specify, the <code>NextToken</code> element is sent in the response. Use this
    /// <code>NextToken</code> value in a subsequent request to retrieve additional
    /// items.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Use this parameter to filter the returned set of certificate authorities based on
    /// their owner. The default is SELF.</p>
    pub resource_owner: std::option::Option<crate::model::ResourceOwner>,
}
impl ListCertificateAuthoritiesInput {
    /// <p>Use this parameter when paginating results in a subsequent request after you receive a
    /// response with truncated results. Set it to the value of the <code>NextToken</code>
    /// parameter from the response you just received.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Use this parameter when paginating results to specify the maximum number of items to
    /// return in the response on each page. If additional items exist beyond the number you
    /// specify, the <code>NextToken</code> element is sent in the response. Use this
    /// <code>NextToken</code> value in a subsequent request to retrieve additional
    /// items.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Use this parameter to filter the returned set of certificate authorities based on
    /// their owner. The default is SELF.</p>
    pub fn resource_owner(&self) -> std::option::Option<&crate::model::ResourceOwner> {
        self.resource_owner.as_ref()
    }
}
impl std::fmt::Debug for ListCertificateAuthoritiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCertificateAuthoritiesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IssueCertificateInput {
    /// <p>Specifies X.509 certificate information to be included in the issued certificate. An
    /// <code>APIPassthrough</code> or <code>APICSRPassthrough</code> template variant must
    /// be selected, or else this parameter is ignored. For more information about using these
    /// templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate Templates</a>.</p>
    /// <p>If conflicting or duplicate certificate information is supplied during certificate
    /// issuance, ACM Private CA applies <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">order of
    /// operation rules</a> to determine what information is used.</p>
    pub api_passthrough: std::option::Option<crate::model::ApiPassthrough>,
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form:</p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>The certificate signing request (CSR) for the certificate you want to issue. As an
    /// example, you can use the following OpenSSL command to create the CSR and a 2048 bit RSA
    /// private key. </p>
    /// <p>
    /// <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem
    /// -out csr/test_cert_.csr</code>
    /// </p>
    /// <p>If you have a configuration file, you can then use the following OpenSSL command. The
    /// <code>usr_cert</code> block in the configuration file contains your X509 version 3
    /// extensions. </p>
    /// <p>
    /// <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048
    /// -days -365 -keyout private/test_cert_priv_key.pem -out
    /// csr/test_cert_.csr</code>
    /// </p>
    /// <p>Note: A CSR must provide either a <i>subject name</i> or a
    /// <i>subject alternative name</i> or the request will be rejected.
    /// </p>
    pub csr: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The name of the algorithm that will be used to sign the certificate to be issued. </p>
    /// <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter
    /// used to sign a CSR in the <code>CreateCertificateAuthority</code> action.</p>
    pub signing_algorithm: std::option::Option<crate::model::SigningAlgorithm>,
    /// <p>Specifies a custom configuration template to use when issuing a certificate. If this
    /// parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code>
    /// template. For CA certificates, you should choose the shortest path length that meets
    /// your needs. The path length is indicated by the PathLen<i>N</i> portion of
    /// the ARN, where <i>N</i> is the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaTerms.html#terms-cadepth">CA depth</a>.</p>
    /// <p>Note: The CA depth configured on a subordinate CA certificate must not exceed the
    /// limit set by its parents in the CA hierarchy.</p>
    /// <p>For a list of <code>TemplateArn</code> values supported by ACM Private CA, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate
    /// Templates</a>.</p>
    pub template_arn: std::option::Option<std::string::String>,
    /// <p>Information describing the end of the validity period of the certificate. This
    /// parameter sets the “Not After” date for the certificate.</p>
    /// <p>Certificate validity is the period of time during which a certificate is valid.
    /// Validity can be expressed as an explicit date and time when the certificate expires, or
    /// as a span of time after issuance, stated in days, months, or years. For more
    /// information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280. </p>
    /// <p>This value is unaffected when <code>ValidityNotBefore</code> is also specified. For
    /// example, if <code>Validity</code> is set to 20 days in the future, the certificate will
    /// expire 20 days from issuance time regardless of the <code>ValidityNotBefore</code>
    /// value.</p>
    /// <p>The end of the validity period configured on a certificate must not exceed the limit
    /// set on its parents in the CA hierarchy.</p>
    pub validity: std::option::Option<crate::model::Validity>,
    /// <p>Information describing the start of the validity period of the certificate. This
    /// parameter sets the “Not Before" date for the certificate.</p>
    /// <p>By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the
    /// issuance time minus 60 minutes. This compensates for clock inconsistencies across
    /// computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize
    /// the “Not Before” value. </p>
    /// <p>Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code>
    /// parameter is optional.</p>
    /// <p>The <code>ValidityNotBefore</code> value is expressed as an explicit date and time,
    /// using the <code>Validity</code> type value <code>ABSOLUTE</code>. For more information,
    /// see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_Validity.html">Validity</a> in this API reference and <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC
    /// 5280.</p>
    pub validity_not_before: std::option::Option<crate::model::Validity>,
    /// <p>Alphanumeric string that can be used to distinguish between calls to the <b>IssueCertificate</b> action. Idempotency tokens for <b>IssueCertificate</b> time out after one minute. Therefore, if you
    /// call <b>IssueCertificate</b> multiple times with the same
    /// idempotency token within one minute, ACM Private CA recognizes that you are requesting only one
    /// certificate and will issue only one. If you change the idempotency token for each call,
    /// PCA recognizes that you are requesting multiple certificates.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl IssueCertificateInput {
    /// <p>Specifies X.509 certificate information to be included in the issued certificate. An
    /// <code>APIPassthrough</code> or <code>APICSRPassthrough</code> template variant must
    /// be selected, or else this parameter is ignored. For more information about using these
    /// templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate Templates</a>.</p>
    /// <p>If conflicting or duplicate certificate information is supplied during certificate
    /// issuance, ACM Private CA applies <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">order of
    /// operation rules</a> to determine what information is used.</p>
    pub fn api_passthrough(&self) -> std::option::Option<&crate::model::ApiPassthrough> {
        self.api_passthrough.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form:</p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>The certificate signing request (CSR) for the certificate you want to issue. As an
    /// example, you can use the following OpenSSL command to create the CSR and a 2048 bit RSA
    /// private key. </p>
    /// <p>
    /// <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem
    /// -out csr/test_cert_.csr</code>
    /// </p>
    /// <p>If you have a configuration file, you can then use the following OpenSSL command. The
    /// <code>usr_cert</code> block in the configuration file contains your X509 version 3
    /// extensions. </p>
    /// <p>
    /// <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048
    /// -days -365 -keyout private/test_cert_priv_key.pem -out
    /// csr/test_cert_.csr</code>
    /// </p>
    /// <p>Note: A CSR must provide either a <i>subject name</i> or a
    /// <i>subject alternative name</i> or the request will be rejected.
    /// </p>
    pub fn csr(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.csr.as_ref()
    }
    /// <p>The name of the algorithm that will be used to sign the certificate to be issued. </p>
    /// <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter
    /// used to sign a CSR in the <code>CreateCertificateAuthority</code> action.</p>
    pub fn signing_algorithm(&self) -> std::option::Option<&crate::model::SigningAlgorithm> {
        self.signing_algorithm.as_ref()
    }
    /// <p>Specifies a custom configuration template to use when issuing a certificate. If this
    /// parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code>
    /// template. For CA certificates, you should choose the shortest path length that meets
    /// your needs. The path length is indicated by the PathLen<i>N</i> portion of
    /// the ARN, where <i>N</i> is the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaTerms.html#terms-cadepth">CA depth</a>.</p>
    /// <p>Note: The CA depth configured on a subordinate CA certificate must not exceed the
    /// limit set by its parents in the CA hierarchy.</p>
    /// <p>For a list of <code>TemplateArn</code> values supported by ACM Private CA, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate
    /// Templates</a>.</p>
    pub fn template_arn(&self) -> std::option::Option<&str> {
        self.template_arn.as_deref()
    }
    /// <p>Information describing the end of the validity period of the certificate. This
    /// parameter sets the “Not After” date for the certificate.</p>
    /// <p>Certificate validity is the period of time during which a certificate is valid.
    /// Validity can be expressed as an explicit date and time when the certificate expires, or
    /// as a span of time after issuance, stated in days, months, or years. For more
    /// information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280. </p>
    /// <p>This value is unaffected when <code>ValidityNotBefore</code> is also specified. For
    /// example, if <code>Validity</code> is set to 20 days in the future, the certificate will
    /// expire 20 days from issuance time regardless of the <code>ValidityNotBefore</code>
    /// value.</p>
    /// <p>The end of the validity period configured on a certificate must not exceed the limit
    /// set on its parents in the CA hierarchy.</p>
    pub fn validity(&self) -> std::option::Option<&crate::model::Validity> {
        self.validity.as_ref()
    }
    /// <p>Information describing the start of the validity period of the certificate. This
    /// parameter sets the “Not Before" date for the certificate.</p>
    /// <p>By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the
    /// issuance time minus 60 minutes. This compensates for clock inconsistencies across
    /// computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize
    /// the “Not Before” value. </p>
    /// <p>Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code>
    /// parameter is optional.</p>
    /// <p>The <code>ValidityNotBefore</code> value is expressed as an explicit date and time,
    /// using the <code>Validity</code> type value <code>ABSOLUTE</code>. For more information,
    /// see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_Validity.html">Validity</a> in this API reference and <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC
    /// 5280.</p>
    pub fn validity_not_before(&self) -> std::option::Option<&crate::model::Validity> {
        self.validity_not_before.as_ref()
    }
    /// <p>Alphanumeric string that can be used to distinguish between calls to the <b>IssueCertificate</b> action. Idempotency tokens for <b>IssueCertificate</b> time out after one minute. Therefore, if you
    /// call <b>IssueCertificate</b> multiple times with the same
    /// idempotency token within one minute, ACM Private CA recognizes that you are requesting only one
    /// certificate and will issue only one. If you change the idempotency token for each call,
    /// PCA recognizes that you are requesting multiple certificates.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for IssueCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IssueCertificateInput");
        formatter.field("api_passthrough", &self.api_passthrough);
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("csr", &self.csr);
        formatter.field("signing_algorithm", &self.signing_algorithm);
        formatter.field("template_arn", &self.template_arn);
        formatter.field("validity", &self.validity);
        formatter.field("validity_not_before", &self.validity_not_before);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportCertificateAuthorityCertificateInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>The PEM-encoded certificate for a private CA. This may be a self-signed certificate in
    /// the case of a root CA, or it may be signed by another CA that you control.</p>
    pub certificate: std::option::Option<aws_smithy_types::Blob>,
    /// <p>A PEM-encoded file that contains all of your certificates, other than the certificate
    /// you're importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root
    /// certificate is the last in the chain, and each certificate in the chain signs the one
    /// preceding. </p>
    /// <p>This parameter must be supplied when you import a subordinate CA. When you import a
    /// root CA, there is no chain.</p>
    pub certificate_chain: std::option::Option<aws_smithy_types::Blob>,
}
impl ImportCertificateAuthorityCertificateInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>The PEM-encoded certificate for a private CA. This may be a self-signed certificate in
    /// the case of a root CA, or it may be signed by another CA that you control.</p>
    pub fn certificate(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.certificate.as_ref()
    }
    /// <p>A PEM-encoded file that contains all of your certificates, other than the certificate
    /// you're importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root
    /// certificate is the last in the chain, and each certificate in the chain signs the one
    /// preceding. </p>
    /// <p>This parameter must be supplied when you import a subordinate CA. When you import a
    /// root CA, there is no chain.</p>
    pub fn certificate_chain(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.certificate_chain.as_ref()
    }
}
impl std::fmt::Debug for ImportCertificateAuthorityCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportCertificateAuthorityCertificateInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("certificate", &self.certificate);
        formatter.field("certificate_chain", &self.certificate_chain);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPolicyInput {
    /// <p>The Amazon Resource Number (ARN) of the private CA that will have its policy
    /// retrieved. You can find the CA's ARN by calling the ListCertificateAuthorities action.
    ///
    /// </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl GetPolicyInput {
    /// <p>The Amazon Resource Number (ARN) of the private CA that will have its policy
    /// retrieved. You can find the CA's ARN by calling the ListCertificateAuthorities action.
    ///
    /// </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for GetPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPolicyInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCertificateAuthorityCsrInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
}
impl GetCertificateAuthorityCsrInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
}
impl std::fmt::Debug for GetCertificateAuthorityCsrInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCertificateAuthorityCsrInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCertificateAuthorityCertificateInput {
    /// <p>The Amazon Resource Name (ARN) of your private CA. This is of the form:</p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
}
impl GetCertificateAuthorityCertificateInput {
    /// <p>The Amazon Resource Name (ARN) of your private CA. This is of the form:</p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
}
impl std::fmt::Debug for GetCertificateAuthorityCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCertificateAuthorityCertificateInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCertificateInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the issued certificate. The ARN contains the certificate serial number and
    /// must be in the following form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i>
    /// </code>
    /// </p>
    pub certificate_arn: std::option::Option<std::string::String>,
}
impl GetCertificateInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>The ARN of the issued certificate. The ARN contains the certificate serial number and
    /// must be in the following form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i>
    /// </code>
    /// </p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for GetCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCertificateInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCertificateAuthorityAuditReportInput {
    /// <p>The Amazon Resource Name (ARN) of the private CA. This must be of the form:</p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>The report ID returned by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a> action.</p>
    pub audit_report_id: std::option::Option<std::string::String>,
}
impl DescribeCertificateAuthorityAuditReportInput {
    /// <p>The Amazon Resource Name (ARN) of the private CA. This must be of the form:</p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>The report ID returned by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a> action.</p>
    pub fn audit_report_id(&self) -> std::option::Option<&str> {
        self.audit_report_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeCertificateAuthorityAuditReportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCertificateAuthorityAuditReportInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("audit_report_id", &self.audit_report_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCertificateAuthorityInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
}
impl DescribeCertificateAuthorityInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeCertificateAuthorityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCertificateAuthorityInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePolicyInput {
    /// <p>The Amazon Resource Number (ARN) of the private CA that will have its policy deleted.
    /// You can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. The ARN value must have the form
    /// <code>arn:aws:acm-pca:region:account:certificate-authority/01234567-89ab-cdef-0123-0123456789ab</code>.
    /// </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl DeletePolicyInput {
    /// <p>The Amazon Resource Number (ARN) of the private CA that will have its policy deleted.
    /// You can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. The ARN value must have the form
    /// <code>arn:aws:acm-pca:region:account:certificate-authority/01234567-89ab-cdef-0123-0123456789ab</code>.
    /// </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for DeletePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePolicyInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePermissionInput {
    /// <p>The Amazon Resource Number (ARN) of the private CA that issued the permissions. You
    /// can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>The AWS service or identity that will have its CA permissions revoked. At this time,
    /// the only valid service principal is <code>acm.amazonaws.com</code>
    /// </p>
    pub principal: std::option::Option<std::string::String>,
    /// <p>The AWS account that calls this action.</p>
    pub source_account: std::option::Option<std::string::String>,
}
impl DeletePermissionInput {
    /// <p>The Amazon Resource Number (ARN) of the private CA that issued the permissions. You
    /// can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>The AWS service or identity that will have its CA permissions revoked. At this time,
    /// the only valid service principal is <code>acm.amazonaws.com</code>
    /// </p>
    pub fn principal(&self) -> std::option::Option<&str> {
        self.principal.as_deref()
    }
    /// <p>The AWS account that calls this action.</p>
    pub fn source_account(&self) -> std::option::Option<&str> {
        self.source_account.as_deref()
    }
}
impl std::fmt::Debug for DeletePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePermissionInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("principal", &self.principal);
        formatter.field("source_account", &self.source_account);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCertificateAuthorityInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must have the following form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>The number of days to make a CA restorable after it has been deleted. This can be
    /// anywhere from 7 to 30 days, with 30 being the default.</p>
    pub permanent_deletion_time_in_days: std::option::Option<i32>,
}
impl DeleteCertificateAuthorityInput {
    /// <p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must have the following form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>The number of days to make a CA restorable after it has been deleted. This can be
    /// anywhere from 7 to 30 days, with 30 being the default.</p>
    pub fn permanent_deletion_time_in_days(&self) -> std::option::Option<i32> {
        self.permanent_deletion_time_in_days
    }
}
impl std::fmt::Debug for DeleteCertificateAuthorityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCertificateAuthorityInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field(
            "permanent_deletion_time_in_days",
            &self.permanent_deletion_time_in_days,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePermissionInput {
    /// <p>The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the
    /// ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>The AWS service or identity that receives the permission. At this time, the only
    /// valid principal is <code>acm.amazonaws.com</code>.</p>
    pub principal: std::option::Option<std::string::String>,
    /// <p>The ID of the calling account.</p>
    pub source_account: std::option::Option<std::string::String>,
    /// <p>The actions that the specified AWS service principal can use. These include
    /// <code>IssueCertificate</code>, <code>GetCertificate</code>, and
    /// <code>ListPermissions</code>.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::ActionType>>,
}
impl CreatePermissionInput {
    /// <p>The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the
    /// ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.
    /// </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>The AWS service or identity that receives the permission. At this time, the only
    /// valid principal is <code>acm.amazonaws.com</code>.</p>
    pub fn principal(&self) -> std::option::Option<&str> {
        self.principal.as_deref()
    }
    /// <p>The ID of the calling account.</p>
    pub fn source_account(&self) -> std::option::Option<&str> {
        self.source_account.as_deref()
    }
    /// <p>The actions that the specified AWS service principal can use. These include
    /// <code>IssueCertificate</code>, <code>GetCertificate</code>, and
    /// <code>ListPermissions</code>.</p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::ActionType]> {
        self.actions.as_deref()
    }
}
impl std::fmt::Debug for CreatePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePermissionInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("principal", &self.principal);
        formatter.field("source_account", &self.source_account);
        formatter.field("actions", &self.actions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCertificateAuthorityAuditReportInput {
    /// <p>The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:</p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.</p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>The name of the S3 bucket that will contain the audit report.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.</p>
    pub audit_report_response_format: std::option::Option<crate::model::AuditReportResponseFormat>,
}
impl CreateCertificateAuthorityAuditReportInput {
    /// <p>The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:</p>
    /// <p>
    /// <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>
    /// </code>.</p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>The name of the S3 bucket that will contain the audit report.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.</p>
    pub fn audit_report_response_format(
        &self,
    ) -> std::option::Option<&crate::model::AuditReportResponseFormat> {
        self.audit_report_response_format.as_ref()
    }
}
impl std::fmt::Debug for CreateCertificateAuthorityAuditReportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCertificateAuthorityAuditReportInput");
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field(
            "audit_report_response_format",
            &self.audit_report_response_format,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCertificateAuthorityInput {
    /// <p>Name and bit size of the private key algorithm, the name of the signing algorithm, and
    /// X.500 certificate subject information.</p>
    pub certificate_authority_configuration:
        std::option::Option<crate::model::CertificateAuthorityConfiguration>,
    /// <p>Contains information to enable Online Certificate Status Protocol (OCSP) support,
    /// to enable a certificate revocation list (CRL), to enable both, or to enable neither. The
    /// default is for both certificate validation mechanisms to be disabled. For more
    /// information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
    pub revocation_configuration: std::option::Option<crate::model::RevocationConfiguration>,
    /// <p>The type of the certificate authority.</p>
    pub certificate_authority_type: std::option::Option<crate::model::CertificateAuthorityType>,
    /// <p>Custom string that can be used to distinguish between calls to the <b>CreateCertificateAuthority</b> action. Idempotency tokens for
    /// <b>CreateCertificateAuthority</b> time out after five
    /// minutes. Therefore, if you call <b>CreateCertificateAuthority</b> multiple times with the same idempotency
    /// token within five minutes, ACM Private CA recognizes that you are requesting only certificate
    /// authority and will issue only one. If you change the idempotency token for each call,
    /// PCA recognizes that you are requesting multiple certificate authorities.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
    /// <p>Specifies a
    /// cryptographic key management compliance standard used for handling CA keys.</p>
    /// <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p>
    /// <p>Note: <code>FIPS_140_2_LEVEL_3_OR_HIGHER</code> is not supported in Region
    /// ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide
    /// <code>FIPS_140_2_LEVEL_2_OR_HIGHER</code> as the argument for
    /// <code>KeyStorageSecurityStandard</code>. Failure to do this results in an
    /// <code>InvalidArgsException</code> with the message, "A certificate authority cannot
    /// be created in this region with the specified security standard."</p>
    pub key_storage_security_standard:
        std::option::Option<crate::model::KeyStorageSecurityStandard>,
    /// <p>Key-value pairs that will be attached to the new private CA. You can associate up to
    /// 50 tags with a private CA. For information using tags with IAM to manage permissions,
    /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateCertificateAuthorityInput {
    /// <p>Name and bit size of the private key algorithm, the name of the signing algorithm, and
    /// X.500 certificate subject information.</p>
    pub fn certificate_authority_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CertificateAuthorityConfiguration> {
        self.certificate_authority_configuration.as_ref()
    }
    /// <p>Contains information to enable Online Certificate Status Protocol (OCSP) support,
    /// to enable a certificate revocation list (CRL), to enable both, or to enable neither. The
    /// default is for both certificate validation mechanisms to be disabled. For more
    /// information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>
    pub fn revocation_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RevocationConfiguration> {
        self.revocation_configuration.as_ref()
    }
    /// <p>The type of the certificate authority.</p>
    pub fn certificate_authority_type(
        &self,
    ) -> std::option::Option<&crate::model::CertificateAuthorityType> {
        self.certificate_authority_type.as_ref()
    }
    /// <p>Custom string that can be used to distinguish between calls to the <b>CreateCertificateAuthority</b> action. Idempotency tokens for
    /// <b>CreateCertificateAuthority</b> time out after five
    /// minutes. Therefore, if you call <b>CreateCertificateAuthority</b> multiple times with the same idempotency
    /// token within five minutes, ACM Private CA recognizes that you are requesting only certificate
    /// authority and will issue only one. If you change the idempotency token for each call,
    /// PCA recognizes that you are requesting multiple certificate authorities.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
    /// <p>Specifies a
    /// cryptographic key management compliance standard used for handling CA keys.</p>
    /// <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p>
    /// <p>Note: <code>FIPS_140_2_LEVEL_3_OR_HIGHER</code> is not supported in Region
    /// ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide
    /// <code>FIPS_140_2_LEVEL_2_OR_HIGHER</code> as the argument for
    /// <code>KeyStorageSecurityStandard</code>. Failure to do this results in an
    /// <code>InvalidArgsException</code> with the message, "A certificate authority cannot
    /// be created in this region with the specified security standard."</p>
    pub fn key_storage_security_standard(
        &self,
    ) -> std::option::Option<&crate::model::KeyStorageSecurityStandard> {
        self.key_storage_security_standard.as_ref()
    }
    /// <p>Key-value pairs that will be attached to the new private CA. You can associate up to
    /// 50 tags with a private CA. For information using tags with IAM to manage permissions,
    /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateCertificateAuthorityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCertificateAuthorityInput");
        formatter.field(
            "certificate_authority_configuration",
            &self.certificate_authority_configuration,
        );
        formatter.field("revocation_configuration", &self.revocation_configuration);
        formatter.field(
            "certificate_authority_type",
            &self.certificate_authority_type,
        );
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.field(
            "key_storage_security_standard",
            &self.key_storage_security_standard,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
