// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The certificate authority certificate you are importing does not comply with
    /// conditions specified in the certificate that signed it.</p>
    CertificateMismatchException(crate::error::CertificateMismatchException),
    /// <p>A previous update to your private CA is still ongoing.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>One or more of the specified arguments was not valid.</p>
    InvalidArgsException(crate::error::InvalidArgsException),
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing
    /// resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The token specified in the <code>NextToken</code> argument is not valid. Use the token
    /// returned from your previous call to <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a>.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The resource policy is invalid or is missing a required statement. For general
    /// information about IAM policy and statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>
    InvalidPolicyException(crate::error::InvalidPolicyException),
    /// <p>The request action cannot be performed or is prohibited.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The state of the private CA does not allow this action to occur.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The tag associated with the CA is not valid. The invalid argument is contained in the
    /// message field.</p>
    InvalidTagException(crate::error::InvalidTagException),
    /// <p>An ACM Private CA quota has been exceeded. See the exception message returned to determine the
    /// quota that was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The current action was prevented because it would lock the caller out from performing
    /// subsequent actions. Verify that the specified parameters would not result in the caller
    /// being denied access to the resource. </p>
    LockoutPreventedException(crate::error::LockoutPreventedException),
    /// <p>The certificate signing request is invalid.</p>
    MalformedCsrException(crate::error::MalformedCsrException),
    /// <p>One or more fields in the certificate are invalid.</p>
    MalformedCertificateException(crate::error::MalformedCertificateException),
    /// <p>The designated permission has already been given to the user.</p>
    PermissionAlreadyExistsException(crate::error::PermissionAlreadyExistsException),
    /// <p>Your request has already been completed.</p>
    RequestAlreadyProcessedException(crate::error::RequestAlreadyProcessedException),
    /// <p>The request has failed for an unspecified reason.</p>
    RequestFailedException(crate::error::RequestFailedException),
    /// <p>Your request is already in progress.</p>
    RequestInProgressException(crate::error::RequestInProgressException),
    /// <p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy
    /// cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You can associate up to 50 tags with a private CA. Exception information is contained
    /// in the exception message field.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::CertificateMismatchException(inner) => inner.fmt(f),
            Error::ConcurrentModificationException(inner) => inner.fmt(f),
            Error::InvalidArgsException(inner) => inner.fmt(f),
            Error::InvalidArnException(inner) => inner.fmt(f),
            Error::InvalidNextTokenException(inner) => inner.fmt(f),
            Error::InvalidPolicyException(inner) => inner.fmt(f),
            Error::InvalidRequestException(inner) => inner.fmt(f),
            Error::InvalidStateException(inner) => inner.fmt(f),
            Error::InvalidTagException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::LockoutPreventedException(inner) => inner.fmt(f),
            Error::MalformedCsrException(inner) => inner.fmt(f),
            Error::MalformedCertificateException(inner) => inner.fmt(f),
            Error::PermissionAlreadyExistsException(inner) => inner.fmt(f),
            Error::RequestAlreadyProcessedException(inner) => inner.fmt(f),
            Error::RequestFailedException(inner) => inner.fmt(f),
            Error::RequestInProgressException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::TooManyTagsException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCertificateAuthorityError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCertificateAuthorityError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateCertificateAuthorityErrorKind::InvalidArgsException(inner) => {
                    Error::InvalidArgsException(inner)
                }
                crate::error::CreateCertificateAuthorityErrorKind::InvalidPolicyException(
                    inner,
                ) => Error::InvalidPolicyException(inner),
                crate::error::CreateCertificateAuthorityErrorKind::InvalidTagException(inner) => {
                    Error::InvalidTagException(inner)
                }
                crate::error::CreateCertificateAuthorityErrorKind::LimitExceededException(
                    inner,
                ) => Error::LimitExceededException(inner),
                crate::error::CreateCertificateAuthorityErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::CreateCertificateAuthorityAuditReportError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateCertificateAuthorityAuditReportError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCertificateAuthorityAuditReportErrorKind::InvalidArgsException(inner) => Error::InvalidArgsException(inner),
                crate::error::CreateCertificateAuthorityAuditReportErrorKind::InvalidArnException(inner) => Error::InvalidArnException(inner),
                crate::error::CreateCertificateAuthorityAuditReportErrorKind::InvalidStateException(inner) => Error::InvalidStateException(inner),
                crate::error::CreateCertificateAuthorityAuditReportErrorKind::RequestFailedException(inner) => Error::RequestFailedException(inner),
                crate::error::CreateCertificateAuthorityAuditReportErrorKind::RequestInProgressException(inner) => Error::RequestInProgressException(inner),
                crate::error::CreateCertificateAuthorityAuditReportErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::CreateCertificateAuthorityAuditReportErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePermissionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreatePermissionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreatePermissionErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::CreatePermissionErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::CreatePermissionErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreatePermissionErrorKind::PermissionAlreadyExistsException(
                    inner,
                ) => Error::PermissionAlreadyExistsException(inner),
                crate::error::CreatePermissionErrorKind::RequestFailedException(inner) => {
                    Error::RequestFailedException(inner)
                }
                crate::error::CreatePermissionErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreatePermissionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCertificateAuthorityError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCertificateAuthorityError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteCertificateAuthorityErrorKind::ConcurrentModificationException(inner) => Error::ConcurrentModificationException(inner),
                crate::error::DeleteCertificateAuthorityErrorKind::InvalidArnException(inner) => Error::InvalidArnException(inner),
                crate::error::DeleteCertificateAuthorityErrorKind::InvalidStateException(inner) => Error::InvalidStateException(inner),
                crate::error::DeleteCertificateAuthorityErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteCertificateAuthorityErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeletePermissionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeletePermissionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeletePermissionErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::DeletePermissionErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::DeletePermissionErrorKind::RequestFailedException(inner) => {
                    Error::RequestFailedException(inner)
                }
                crate::error::DeletePermissionErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeletePermissionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeletePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeletePolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeletePolicyErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::DeletePolicyErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::DeletePolicyErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::DeletePolicyErrorKind::LockoutPreventedException(inner) => {
                    Error::LockoutPreventedException(inner)
                }
                crate::error::DeletePolicyErrorKind::RequestFailedException(inner) => {
                    Error::RequestFailedException(inner)
                }
                crate::error::DeletePolicyErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeletePolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCertificateAuthorityError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCertificateAuthorityError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCertificateAuthorityErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::DescribeCertificateAuthorityErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeCertificateAuthorityErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeCertificateAuthorityAuditReportError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeCertificateAuthorityAuditReportError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeCertificateAuthorityAuditReportErrorKind::InvalidArgsException(inner) => Error::InvalidArgsException(inner),
                crate::error::DescribeCertificateAuthorityAuditReportErrorKind::InvalidArnException(inner) => Error::InvalidArnException(inner),
                crate::error::DescribeCertificateAuthorityAuditReportErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeCertificateAuthorityAuditReportErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCertificateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetCertificateError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCertificateErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::GetCertificateErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::GetCertificateErrorKind::RequestFailedException(inner) => {
                    Error::RequestFailedException(inner)
                }
                crate::error::GetCertificateErrorKind::RequestInProgressException(inner) => {
                    Error::RequestInProgressException(inner)
                }
                crate::error::GetCertificateErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetCertificateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::GetCertificateAuthorityCertificateError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetCertificateAuthorityCertificateError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetCertificateAuthorityCertificateErrorKind::InvalidArnException(inner) => Error::InvalidArnException(inner),
                crate::error::GetCertificateAuthorityCertificateErrorKind::InvalidStateException(inner) => Error::InvalidStateException(inner),
                crate::error::GetCertificateAuthorityCertificateErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetCertificateAuthorityCertificateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCertificateAuthorityCsrError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCertificateAuthorityCsrError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCertificateAuthorityCsrErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::GetCertificateAuthorityCsrErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::GetCertificateAuthorityCsrErrorKind::RequestFailedException(
                    inner,
                ) => Error::RequestFailedException(inner),
                crate::error::GetCertificateAuthorityCsrErrorKind::RequestInProgressException(
                    inner,
                ) => Error::RequestInProgressException(inner),
                crate::error::GetCertificateAuthorityCsrErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::GetCertificateAuthorityCsrErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetPolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPolicyErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::GetPolicyErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::GetPolicyErrorKind::RequestFailedException(inner) => {
                    Error::RequestFailedException(inner)
                }
                crate::error::GetPolicyErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ImportCertificateAuthorityCertificateError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ImportCertificateAuthorityCertificateError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ImportCertificateAuthorityCertificateErrorKind::CertificateMismatchException(inner) => Error::CertificateMismatchException(inner),
                crate::error::ImportCertificateAuthorityCertificateErrorKind::ConcurrentModificationException(inner) => Error::ConcurrentModificationException(inner),
                crate::error::ImportCertificateAuthorityCertificateErrorKind::InvalidArnException(inner) => Error::InvalidArnException(inner),
                crate::error::ImportCertificateAuthorityCertificateErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::ImportCertificateAuthorityCertificateErrorKind::InvalidStateException(inner) => Error::InvalidStateException(inner),
                crate::error::ImportCertificateAuthorityCertificateErrorKind::MalformedCertificateException(inner) => Error::MalformedCertificateException(inner),
                crate::error::ImportCertificateAuthorityCertificateErrorKind::RequestFailedException(inner) => Error::RequestFailedException(inner),
                crate::error::ImportCertificateAuthorityCertificateErrorKind::RequestInProgressException(inner) => Error::RequestInProgressException(inner),
                crate::error::ImportCertificateAuthorityCertificateErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::ImportCertificateAuthorityCertificateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::IssueCertificateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::IssueCertificateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::IssueCertificateErrorKind::InvalidArgsException(inner) => {
                    Error::InvalidArgsException(inner)
                }
                crate::error::IssueCertificateErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::IssueCertificateErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::IssueCertificateErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::IssueCertificateErrorKind::MalformedCsrException(inner) => {
                    Error::MalformedCsrException(inner)
                }
                crate::error::IssueCertificateErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::IssueCertificateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListCertificateAuthoritiesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListCertificateAuthoritiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListCertificateAuthoritiesErrorKind::InvalidNextTokenException(
                    inner,
                ) => Error::InvalidNextTokenException(inner),
                crate::error::ListCertificateAuthoritiesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListPermissionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListPermissionsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListPermissionsErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::ListPermissionsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListPermissionsErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::ListPermissionsErrorKind::RequestFailedException(inner) => {
                    Error::RequestFailedException(inner)
                }
                crate::error::ListPermissionsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListPermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::ListTagsErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::ListTagsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutPolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutPolicyErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::PutPolicyErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::PutPolicyErrorKind::InvalidPolicyException(inner) => {
                    Error::InvalidPolicyException(inner)
                }
                crate::error::PutPolicyErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::PutPolicyErrorKind::LockoutPreventedException(inner) => {
                    Error::LockoutPreventedException(inner)
                }
                crate::error::PutPolicyErrorKind::RequestFailedException(inner) => {
                    Error::RequestFailedException(inner)
                }
                crate::error::PutPolicyErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::PutPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreCertificateAuthorityError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RestoreCertificateAuthorityError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RestoreCertificateAuthorityErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::RestoreCertificateAuthorityErrorKind::InvalidStateException(
                    inner,
                ) => Error::InvalidStateException(inner),
                crate::error::RestoreCertificateAuthorityErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::RestoreCertificateAuthorityErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RevokeCertificateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RevokeCertificateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RevokeCertificateErrorKind::ConcurrentModificationException(
                    inner,
                ) => Error::ConcurrentModificationException(inner),
                crate::error::RevokeCertificateErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::RevokeCertificateErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::RevokeCertificateErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::RevokeCertificateErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::RevokeCertificateErrorKind::RequestAlreadyProcessedException(
                    inner,
                ) => Error::RequestAlreadyProcessedException(inner),
                crate::error::RevokeCertificateErrorKind::RequestFailedException(inner) => {
                    Error::RequestFailedException(inner)
                }
                crate::error::RevokeCertificateErrorKind::RequestInProgressException(inner) => {
                    Error::RequestInProgressException(inner)
                }
                crate::error::RevokeCertificateErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::RevokeCertificateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagCertificateAuthorityError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::TagCertificateAuthorityError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagCertificateAuthorityErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::TagCertificateAuthorityErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::TagCertificateAuthorityErrorKind::InvalidTagException(inner) => {
                    Error::InvalidTagException(inner)
                }
                crate::error::TagCertificateAuthorityErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::TagCertificateAuthorityErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::TagCertificateAuthorityErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagCertificateAuthorityError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UntagCertificateAuthorityError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagCertificateAuthorityErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::UntagCertificateAuthorityErrorKind::InvalidStateException(inner) => {
                    Error::InvalidStateException(inner)
                }
                crate::error::UntagCertificateAuthorityErrorKind::InvalidTagException(inner) => {
                    Error::InvalidTagException(inner)
                }
                crate::error::UntagCertificateAuthorityErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::UntagCertificateAuthorityErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateCertificateAuthorityError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateCertificateAuthorityError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateCertificateAuthorityErrorKind::ConcurrentModificationException(inner) => Error::ConcurrentModificationException(inner),
                crate::error::UpdateCertificateAuthorityErrorKind::InvalidArgsException(inner) => Error::InvalidArgsException(inner),
                crate::error::UpdateCertificateAuthorityErrorKind::InvalidArnException(inner) => Error::InvalidArnException(inner),
                crate::error::UpdateCertificateAuthorityErrorKind::InvalidPolicyException(inner) => Error::InvalidPolicyException(inner),
                crate::error::UpdateCertificateAuthorityErrorKind::InvalidStateException(inner) => Error::InvalidStateException(inner),
                crate::error::UpdateCertificateAuthorityErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateCertificateAuthorityErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
