// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Structure that contains options for your certificate. Currently, you can use this only to specify whether to opt in to or out of certificate transparency logging. Some browsers require that public certificates issued for your domain be recorded in a log. Certificates that are not logged typically generate a browser error. Transparency makes it possible for you to detect SSL/TLS certificates that have been mistakenly or maliciously issued for your domain. For general information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency">Certificate Transparency Logging</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateOptions {
    /// <p>You can opt out of certificate transparency logging by specifying the <code>DISABLED</code> option. Opt in by specifying <code>ENABLED</code>. </p>
    pub certificate_transparency_logging_preference:
        std::option::Option<crate::model::CertificateTransparencyLoggingPreference>,
}
impl CertificateOptions {
    /// <p>You can opt out of certificate transparency logging by specifying the <code>DISABLED</code> option. Opt in by specifying <code>ENABLED</code>. </p>
    pub fn certificate_transparency_logging_preference(
        &self,
    ) -> std::option::Option<&crate::model::CertificateTransparencyLoggingPreference> {
        self.certificate_transparency_logging_preference.as_ref()
    }
}
impl std::fmt::Debug for CertificateOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateOptions");
        formatter.field(
            "certificate_transparency_logging_preference",
            &self.certificate_transparency_logging_preference,
        );
        formatter.finish()
    }
}
/// See [`CertificateOptions`](crate::model::CertificateOptions)
pub mod certificate_options {
    /// A builder for [`CertificateOptions`](crate::model::CertificateOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_transparency_logging_preference:
            std::option::Option<crate::model::CertificateTransparencyLoggingPreference>,
    }
    impl Builder {
        /// <p>You can opt out of certificate transparency logging by specifying the <code>DISABLED</code> option. Opt in by specifying <code>ENABLED</code>. </p>
        pub fn certificate_transparency_logging_preference(
            mut self,
            input: crate::model::CertificateTransparencyLoggingPreference,
        ) -> Self {
            self.certificate_transparency_logging_preference = Some(input);
            self
        }
        /// <p>You can opt out of certificate transparency logging by specifying the <code>DISABLED</code> option. Opt in by specifying <code>ENABLED</code>. </p>
        pub fn set_certificate_transparency_logging_preference(
            mut self,
            input: std::option::Option<crate::model::CertificateTransparencyLoggingPreference>,
        ) -> Self {
            self.certificate_transparency_logging_preference = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateOptions`](crate::model::CertificateOptions)
        pub fn build(self) -> crate::model::CertificateOptions {
            crate::model::CertificateOptions {
                certificate_transparency_logging_preference: self
                    .certificate_transparency_logging_preference,
            }
        }
    }
}
impl CertificateOptions {
    /// Creates a new builder-style object to manufacture [`CertificateOptions`](crate::model::CertificateOptions)
    pub fn builder() -> crate::model::certificate_options::Builder {
        crate::model::certificate_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateTransparencyLoggingPreference {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateTransparencyLoggingPreference {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => CertificateTransparencyLoggingPreference::Disabled,
            "ENABLED" => CertificateTransparencyLoggingPreference::Enabled,
            other => CertificateTransparencyLoggingPreference::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateTransparencyLoggingPreference {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateTransparencyLoggingPreference::from(s))
    }
}
impl CertificateTransparencyLoggingPreference {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateTransparencyLoggingPreference::Disabled => "DISABLED",
            CertificateTransparencyLoggingPreference::Enabled => "ENABLED",
            CertificateTransparencyLoggingPreference::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for CertificateTransparencyLoggingPreference {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A key-value pair that identifies or specifies metadata about an ACM resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Contains information about the domain names that you want ACM to use to send you emails that enable you to validate domain ownership.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainValidationOption {
    /// <p>A fully qualified domain name (FQDN) in the certificate request.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the <code>DomainName</code> value or a superdomain of the <code>DomainName</code> value. For example, if you request a certificate for <code>testing.example.com</code>, you can specify <code>example.com</code> for this value. In that case, ACM sends domain validation emails to the following five addresses:</p>
    /// <ul>
    /// <li> <p>admin@example.com</p> </li>
    /// <li> <p>administrator@example.com</p> </li>
    /// <li> <p>hostmaster@example.com</p> </li>
    /// <li> <p>postmaster@example.com</p> </li>
    /// <li> <p>webmaster@example.com</p> </li>
    /// </ul>
    pub validation_domain: std::option::Option<std::string::String>,
}
impl DomainValidationOption {
    /// <p>A fully qualified domain name (FQDN) in the certificate request.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the <code>DomainName</code> value or a superdomain of the <code>DomainName</code> value. For example, if you request a certificate for <code>testing.example.com</code>, you can specify <code>example.com</code> for this value. In that case, ACM sends domain validation emails to the following five addresses:</p>
    /// <ul>
    /// <li> <p>admin@example.com</p> </li>
    /// <li> <p>administrator@example.com</p> </li>
    /// <li> <p>hostmaster@example.com</p> </li>
    /// <li> <p>postmaster@example.com</p> </li>
    /// <li> <p>webmaster@example.com</p> </li>
    /// </ul>
    pub fn validation_domain(&self) -> std::option::Option<&str> {
        self.validation_domain.as_deref()
    }
}
impl std::fmt::Debug for DomainValidationOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainValidationOption");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("validation_domain", &self.validation_domain);
        formatter.finish()
    }
}
/// See [`DomainValidationOption`](crate::model::DomainValidationOption)
pub mod domain_validation_option {
    /// A builder for [`DomainValidationOption`](crate::model::DomainValidationOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) validation_domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A fully qualified domain name (FQDN) in the certificate request.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>A fully qualified domain name (FQDN) in the certificate request.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the <code>DomainName</code> value or a superdomain of the <code>DomainName</code> value. For example, if you request a certificate for <code>testing.example.com</code>, you can specify <code>example.com</code> for this value. In that case, ACM sends domain validation emails to the following five addresses:</p>
        /// <ul>
        /// <li> <p>admin@example.com</p> </li>
        /// <li> <p>administrator@example.com</p> </li>
        /// <li> <p>hostmaster@example.com</p> </li>
        /// <li> <p>postmaster@example.com</p> </li>
        /// <li> <p>webmaster@example.com</p> </li>
        /// </ul>
        pub fn validation_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.validation_domain = Some(input.into());
            self
        }
        /// <p>The domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the <code>DomainName</code> value or a superdomain of the <code>DomainName</code> value. For example, if you request a certificate for <code>testing.example.com</code>, you can specify <code>example.com</code> for this value. In that case, ACM sends domain validation emails to the following five addresses:</p>
        /// <ul>
        /// <li> <p>admin@example.com</p> </li>
        /// <li> <p>administrator@example.com</p> </li>
        /// <li> <p>hostmaster@example.com</p> </li>
        /// <li> <p>postmaster@example.com</p> </li>
        /// <li> <p>webmaster@example.com</p> </li>
        /// </ul>
        pub fn set_validation_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.validation_domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainValidationOption`](crate::model::DomainValidationOption)
        pub fn build(self) -> crate::model::DomainValidationOption {
            crate::model::DomainValidationOption {
                domain_name: self.domain_name,
                validation_domain: self.validation_domain,
            }
        }
    }
}
impl DomainValidationOption {
    /// Creates a new builder-style object to manufacture [`DomainValidationOption`](crate::model::DomainValidationOption)
    pub fn builder() -> crate::model::domain_validation_option::Builder {
        crate::model::domain_validation_option::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationMethod {
    #[allow(missing_docs)] // documentation missing in model
    Dns,
    #[allow(missing_docs)] // documentation missing in model
    Email,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationMethod {
    fn from(s: &str) -> Self {
        match s {
            "DNS" => ValidationMethod::Dns,
            "EMAIL" => ValidationMethod::Email,
            other => ValidationMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationMethod::from(s))
    }
}
impl ValidationMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationMethod::Dns => "DNS",
            ValidationMethod::Email => "EMAIL",
            ValidationMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DNS", "EMAIL"]
    }
}
impl AsRef<str> for ValidationMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Object containing expiration events options associated with an Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpiryEventsConfiguration {
    /// <p>Specifies the number of days prior to certificate expiration when ACM starts generating <code>EventBridge</code> events. ACM sends one event per day per certificate until the certificate expires. By default, accounts receive events starting 45 days before certificate expiration.</p>
    pub days_before_expiry: std::option::Option<i32>,
}
impl ExpiryEventsConfiguration {
    /// <p>Specifies the number of days prior to certificate expiration when ACM starts generating <code>EventBridge</code> events. ACM sends one event per day per certificate until the certificate expires. By default, accounts receive events starting 45 days before certificate expiration.</p>
    pub fn days_before_expiry(&self) -> std::option::Option<i32> {
        self.days_before_expiry
    }
}
impl std::fmt::Debug for ExpiryEventsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpiryEventsConfiguration");
        formatter.field("days_before_expiry", &self.days_before_expiry);
        formatter.finish()
    }
}
/// See [`ExpiryEventsConfiguration`](crate::model::ExpiryEventsConfiguration)
pub mod expiry_events_configuration {
    /// A builder for [`ExpiryEventsConfiguration`](crate::model::ExpiryEventsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) days_before_expiry: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the number of days prior to certificate expiration when ACM starts generating <code>EventBridge</code> events. ACM sends one event per day per certificate until the certificate expires. By default, accounts receive events starting 45 days before certificate expiration.</p>
        pub fn days_before_expiry(mut self, input: i32) -> Self {
            self.days_before_expiry = Some(input);
            self
        }
        /// <p>Specifies the number of days prior to certificate expiration when ACM starts generating <code>EventBridge</code> events. ACM sends one event per day per certificate until the certificate expires. By default, accounts receive events starting 45 days before certificate expiration.</p>
        pub fn set_days_before_expiry(mut self, input: std::option::Option<i32>) -> Self {
            self.days_before_expiry = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpiryEventsConfiguration`](crate::model::ExpiryEventsConfiguration)
        pub fn build(self) -> crate::model::ExpiryEventsConfiguration {
            crate::model::ExpiryEventsConfiguration {
                days_before_expiry: self.days_before_expiry,
            }
        }
    }
}
impl ExpiryEventsConfiguration {
    /// Creates a new builder-style object to manufacture [`ExpiryEventsConfiguration`](crate::model::ExpiryEventsConfiguration)
    pub fn builder() -> crate::model::expiry_events_configuration::Builder {
        crate::model::expiry_events_configuration::Builder::default()
    }
}

/// <p>This structure is returned in the response object of <code>ListCertificates</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateSummary {
    /// <p>Amazon Resource Name (ARN) of the certificate. This is of the form:</p>
    /// <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p>
    /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>Fully qualified domain name (FQDN), such as www.example.com or example.com, for the certificate.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl CertificateSummary {
    /// <p>Amazon Resource Name (ARN) of the certificate. This is of the form:</p>
    /// <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p>
    /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>Fully qualified domain name (FQDN), such as www.example.com or example.com, for the certificate.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for CertificateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateSummary");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}
/// See [`CertificateSummary`](crate::model::CertificateSummary)
pub mod certificate_summary {
    /// A builder for [`CertificateSummary`](crate::model::CertificateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the certificate. This is of the form:</p>
        /// <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the certificate. This is of the form:</p>
        /// <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>Fully qualified domain name (FQDN), such as www.example.com or example.com, for the certificate.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>Fully qualified domain name (FQDN), such as www.example.com or example.com, for the certificate.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateSummary`](crate::model::CertificateSummary)
        pub fn build(self) -> crate::model::CertificateSummary {
            crate::model::CertificateSummary {
                certificate_arn: self.certificate_arn,
                domain_name: self.domain_name,
            }
        }
    }
}
impl CertificateSummary {
    /// Creates a new builder-style object to manufacture [`CertificateSummary`](crate::model::CertificateSummary)
    pub fn builder() -> crate::model::certificate_summary::Builder {
        crate::model::certificate_summary::Builder::default()
    }
}

/// <p>This structure can be used in the <code>ListCertificates</code> action to filter the output of the certificate list. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filters {
    /// <p>Specify one or more <code>ExtendedKeyUsage</code> extension values.</p>
    pub extended_key_usage: std::option::Option<std::vec::Vec<crate::model::ExtendedKeyUsageName>>,
    /// <p>Specify one or more <code>KeyUsage</code> extension values.</p>
    pub key_usage: std::option::Option<std::vec::Vec<crate::model::KeyUsageName>>,
    /// <p>Specify one or more algorithms that can be used to generate key pairs.</p>
    /// <p>Default filtering returns only <code>RSA_1024</code> and <code>RSA_2048</code> certificates that have at least one domain. To return other certificate types, provide the desired type signatures in a comma-separated list. For example, <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and <code>RSA_4096</code> certificates.</p>
    pub key_types: std::option::Option<std::vec::Vec<crate::model::KeyAlgorithm>>,
}
impl Filters {
    /// <p>Specify one or more <code>ExtendedKeyUsage</code> extension values.</p>
    pub fn extended_key_usage(&self) -> std::option::Option<&[crate::model::ExtendedKeyUsageName]> {
        self.extended_key_usage.as_deref()
    }
    /// <p>Specify one or more <code>KeyUsage</code> extension values.</p>
    pub fn key_usage(&self) -> std::option::Option<&[crate::model::KeyUsageName]> {
        self.key_usage.as_deref()
    }
    /// <p>Specify one or more algorithms that can be used to generate key pairs.</p>
    /// <p>Default filtering returns only <code>RSA_1024</code> and <code>RSA_2048</code> certificates that have at least one domain. To return other certificate types, provide the desired type signatures in a comma-separated list. For example, <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and <code>RSA_4096</code> certificates.</p>
    pub fn key_types(&self) -> std::option::Option<&[crate::model::KeyAlgorithm]> {
        self.key_types.as_deref()
    }
}
impl std::fmt::Debug for Filters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filters");
        formatter.field("extended_key_usage", &self.extended_key_usage);
        formatter.field("key_usage", &self.key_usage);
        formatter.field("key_types", &self.key_types);
        formatter.finish()
    }
}
/// See [`Filters`](crate::model::Filters)
pub mod filters {
    /// A builder for [`Filters`](crate::model::Filters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) extended_key_usage:
            std::option::Option<std::vec::Vec<crate::model::ExtendedKeyUsageName>>,
        pub(crate) key_usage: std::option::Option<std::vec::Vec<crate::model::KeyUsageName>>,
        pub(crate) key_types: std::option::Option<std::vec::Vec<crate::model::KeyAlgorithm>>,
    }
    impl Builder {
        /// Appends an item to `extended_key_usage`.
        ///
        /// To override the contents of this collection use [`set_extended_key_usage`](Self::set_extended_key_usage).
        ///
        /// <p>Specify one or more <code>ExtendedKeyUsage</code> extension values.</p>
        pub fn extended_key_usage(mut self, input: crate::model::ExtendedKeyUsageName) -> Self {
            let mut v = self.extended_key_usage.unwrap_or_default();
            v.push(input);
            self.extended_key_usage = Some(v);
            self
        }
        /// <p>Specify one or more <code>ExtendedKeyUsage</code> extension values.</p>
        pub fn set_extended_key_usage(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExtendedKeyUsageName>>,
        ) -> Self {
            self.extended_key_usage = input;
            self
        }
        /// Appends an item to `key_usage`.
        ///
        /// To override the contents of this collection use [`set_key_usage`](Self::set_key_usage).
        ///
        /// <p>Specify one or more <code>KeyUsage</code> extension values.</p>
        pub fn key_usage(mut self, input: crate::model::KeyUsageName) -> Self {
            let mut v = self.key_usage.unwrap_or_default();
            v.push(input);
            self.key_usage = Some(v);
            self
        }
        /// <p>Specify one or more <code>KeyUsage</code> extension values.</p>
        pub fn set_key_usage(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyUsageName>>,
        ) -> Self {
            self.key_usage = input;
            self
        }
        /// Appends an item to `key_types`.
        ///
        /// To override the contents of this collection use [`set_key_types`](Self::set_key_types).
        ///
        /// <p>Specify one or more algorithms that can be used to generate key pairs.</p>
        /// <p>Default filtering returns only <code>RSA_1024</code> and <code>RSA_2048</code> certificates that have at least one domain. To return other certificate types, provide the desired type signatures in a comma-separated list. For example, <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and <code>RSA_4096</code> certificates.</p>
        pub fn key_types(mut self, input: crate::model::KeyAlgorithm) -> Self {
            let mut v = self.key_types.unwrap_or_default();
            v.push(input);
            self.key_types = Some(v);
            self
        }
        /// <p>Specify one or more algorithms that can be used to generate key pairs.</p>
        /// <p>Default filtering returns only <code>RSA_1024</code> and <code>RSA_2048</code> certificates that have at least one domain. To return other certificate types, provide the desired type signatures in a comma-separated list. For example, <code>"keyTypes": ["RSA_2048,RSA_4096"]</code> returns both <code>RSA_2048</code> and <code>RSA_4096</code> certificates.</p>
        pub fn set_key_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyAlgorithm>>,
        ) -> Self {
            self.key_types = input;
            self
        }
        /// Consumes the builder and constructs a [`Filters`](crate::model::Filters)
        pub fn build(self) -> crate::model::Filters {
            crate::model::Filters {
                extended_key_usage: self.extended_key_usage,
                key_usage: self.key_usage,
                key_types: self.key_types,
            }
        }
    }
}
impl Filters {
    /// Creates a new builder-style object to manufacture [`Filters`](crate::model::Filters)
    pub fn builder() -> crate::model::filters::Builder {
        crate::model::filters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeyAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    EcPrime256v1,
    #[allow(missing_docs)] // documentation missing in model
    EcSecp384r1,
    #[allow(missing_docs)] // documentation missing in model
    EcSecp521r1,
    #[allow(missing_docs)] // documentation missing in model
    Rsa1024,
    #[allow(missing_docs)] // documentation missing in model
    Rsa2048,
    #[allow(missing_docs)] // documentation missing in model
    Rsa3072,
    #[allow(missing_docs)] // documentation missing in model
    Rsa4096,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeyAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "EC_prime256v1" => KeyAlgorithm::EcPrime256v1,
            "EC_secp384r1" => KeyAlgorithm::EcSecp384r1,
            "EC_secp521r1" => KeyAlgorithm::EcSecp521r1,
            "RSA_1024" => KeyAlgorithm::Rsa1024,
            "RSA_2048" => KeyAlgorithm::Rsa2048,
            "RSA_3072" => KeyAlgorithm::Rsa3072,
            "RSA_4096" => KeyAlgorithm::Rsa4096,
            other => KeyAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeyAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeyAlgorithm::from(s))
    }
}
impl KeyAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeyAlgorithm::EcPrime256v1 => "EC_prime256v1",
            KeyAlgorithm::EcSecp384r1 => "EC_secp384r1",
            KeyAlgorithm::EcSecp521r1 => "EC_secp521r1",
            KeyAlgorithm::Rsa1024 => "RSA_1024",
            KeyAlgorithm::Rsa2048 => "RSA_2048",
            KeyAlgorithm::Rsa3072 => "RSA_3072",
            KeyAlgorithm::Rsa4096 => "RSA_4096",
            KeyAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EC_prime256v1",
            "EC_secp384r1",
            "EC_secp521r1",
            "RSA_1024",
            "RSA_2048",
            "RSA_3072",
            "RSA_4096",
        ]
    }
}
impl AsRef<str> for KeyAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeyUsageName {
    #[allow(missing_docs)] // documentation missing in model
    Any,
    #[allow(missing_docs)] // documentation missing in model
    CertificateSigning,
    #[allow(missing_docs)] // documentation missing in model
    CrlSigning,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    DataEncipherment,
    #[allow(missing_docs)] // documentation missing in model
    DecipherOnly,
    #[allow(missing_docs)] // documentation missing in model
    DigitalSignature,
    #[allow(missing_docs)] // documentation missing in model
    EnchiperOnly,
    #[allow(missing_docs)] // documentation missing in model
    KeyAgreement,
    #[allow(missing_docs)] // documentation missing in model
    KeyEncipherment,
    #[allow(missing_docs)] // documentation missing in model
    NonRepudation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeyUsageName {
    fn from(s: &str) -> Self {
        match s {
            "ANY" => KeyUsageName::Any,
            "CERTIFICATE_SIGNING" => KeyUsageName::CertificateSigning,
            "CRL_SIGNING" => KeyUsageName::CrlSigning,
            "CUSTOM" => KeyUsageName::Custom,
            "DATA_ENCIPHERMENT" => KeyUsageName::DataEncipherment,
            "DECIPHER_ONLY" => KeyUsageName::DecipherOnly,
            "DIGITAL_SIGNATURE" => KeyUsageName::DigitalSignature,
            "ENCIPHER_ONLY" => KeyUsageName::EnchiperOnly,
            "KEY_AGREEMENT" => KeyUsageName::KeyAgreement,
            "KEY_ENCIPHERMENT" => KeyUsageName::KeyEncipherment,
            "NON_REPUDIATION" => KeyUsageName::NonRepudation,
            other => KeyUsageName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeyUsageName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeyUsageName::from(s))
    }
}
impl KeyUsageName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeyUsageName::Any => "ANY",
            KeyUsageName::CertificateSigning => "CERTIFICATE_SIGNING",
            KeyUsageName::CrlSigning => "CRL_SIGNING",
            KeyUsageName::Custom => "CUSTOM",
            KeyUsageName::DataEncipherment => "DATA_ENCIPHERMENT",
            KeyUsageName::DecipherOnly => "DECIPHER_ONLY",
            KeyUsageName::DigitalSignature => "DIGITAL_SIGNATURE",
            KeyUsageName::EnchiperOnly => "ENCIPHER_ONLY",
            KeyUsageName::KeyAgreement => "KEY_AGREEMENT",
            KeyUsageName::KeyEncipherment => "KEY_ENCIPHERMENT",
            KeyUsageName::NonRepudation => "NON_REPUDIATION",
            KeyUsageName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ANY",
            "CERTIFICATE_SIGNING",
            "CRL_SIGNING",
            "CUSTOM",
            "DATA_ENCIPHERMENT",
            "DECIPHER_ONLY",
            "DIGITAL_SIGNATURE",
            "ENCIPHER_ONLY",
            "KEY_AGREEMENT",
            "KEY_ENCIPHERMENT",
            "NON_REPUDIATION",
        ]
    }
}
impl AsRef<str> for KeyUsageName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExtendedKeyUsageName {
    #[allow(missing_docs)] // documentation missing in model
    Any,
    #[allow(missing_docs)] // documentation missing in model
    CodeSigning,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    EmailProtection,
    #[allow(missing_docs)] // documentation missing in model
    IpsecEndSystem,
    #[allow(missing_docs)] // documentation missing in model
    IpsecTunnel,
    #[allow(missing_docs)] // documentation missing in model
    IpsecUser,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    OcspSigning,
    #[allow(missing_docs)] // documentation missing in model
    TimeStamping,
    #[allow(missing_docs)] // documentation missing in model
    TlsWebClientAuthentication,
    #[allow(missing_docs)] // documentation missing in model
    TlsWebServerAuthentication,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExtendedKeyUsageName {
    fn from(s: &str) -> Self {
        match s {
            "ANY" => ExtendedKeyUsageName::Any,
            "CODE_SIGNING" => ExtendedKeyUsageName::CodeSigning,
            "CUSTOM" => ExtendedKeyUsageName::Custom,
            "EMAIL_PROTECTION" => ExtendedKeyUsageName::EmailProtection,
            "IPSEC_END_SYSTEM" => ExtendedKeyUsageName::IpsecEndSystem,
            "IPSEC_TUNNEL" => ExtendedKeyUsageName::IpsecTunnel,
            "IPSEC_USER" => ExtendedKeyUsageName::IpsecUser,
            "NONE" => ExtendedKeyUsageName::None,
            "OCSP_SIGNING" => ExtendedKeyUsageName::OcspSigning,
            "TIME_STAMPING" => ExtendedKeyUsageName::TimeStamping,
            "TLS_WEB_CLIENT_AUTHENTICATION" => ExtendedKeyUsageName::TlsWebClientAuthentication,
            "TLS_WEB_SERVER_AUTHENTICATION" => ExtendedKeyUsageName::TlsWebServerAuthentication,
            other => ExtendedKeyUsageName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExtendedKeyUsageName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExtendedKeyUsageName::from(s))
    }
}
impl ExtendedKeyUsageName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExtendedKeyUsageName::Any => "ANY",
            ExtendedKeyUsageName::CodeSigning => "CODE_SIGNING",
            ExtendedKeyUsageName::Custom => "CUSTOM",
            ExtendedKeyUsageName::EmailProtection => "EMAIL_PROTECTION",
            ExtendedKeyUsageName::IpsecEndSystem => "IPSEC_END_SYSTEM",
            ExtendedKeyUsageName::IpsecTunnel => "IPSEC_TUNNEL",
            ExtendedKeyUsageName::IpsecUser => "IPSEC_USER",
            ExtendedKeyUsageName::None => "NONE",
            ExtendedKeyUsageName::OcspSigning => "OCSP_SIGNING",
            ExtendedKeyUsageName::TimeStamping => "TIME_STAMPING",
            ExtendedKeyUsageName::TlsWebClientAuthentication => "TLS_WEB_CLIENT_AUTHENTICATION",
            ExtendedKeyUsageName::TlsWebServerAuthentication => "TLS_WEB_SERVER_AUTHENTICATION",
            ExtendedKeyUsageName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ANY",
            "CODE_SIGNING",
            "CUSTOM",
            "EMAIL_PROTECTION",
            "IPSEC_END_SYSTEM",
            "IPSEC_TUNNEL",
            "IPSEC_USER",
            "NONE",
            "OCSP_SIGNING",
            "TIME_STAMPING",
            "TLS_WEB_CLIENT_AUTHENTICATION",
            "TLS_WEB_SERVER_AUTHENTICATION",
        ]
    }
}
impl AsRef<str> for ExtendedKeyUsageName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Issued,
    #[allow(missing_docs)] // documentation missing in model
    PendingValidation,
    #[allow(missing_docs)] // documentation missing in model
    Revoked,
    #[allow(missing_docs)] // documentation missing in model
    ValidationTimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateStatus {
    fn from(s: &str) -> Self {
        match s {
            "EXPIRED" => CertificateStatus::Expired,
            "FAILED" => CertificateStatus::Failed,
            "INACTIVE" => CertificateStatus::Inactive,
            "ISSUED" => CertificateStatus::Issued,
            "PENDING_VALIDATION" => CertificateStatus::PendingValidation,
            "REVOKED" => CertificateStatus::Revoked,
            "VALIDATION_TIMED_OUT" => CertificateStatus::ValidationTimedOut,
            other => CertificateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateStatus::from(s))
    }
}
impl CertificateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateStatus::Expired => "EXPIRED",
            CertificateStatus::Failed => "FAILED",
            CertificateStatus::Inactive => "INACTIVE",
            CertificateStatus::Issued => "ISSUED",
            CertificateStatus::PendingValidation => "PENDING_VALIDATION",
            CertificateStatus::Revoked => "REVOKED",
            CertificateStatus::ValidationTimedOut => "VALIDATION_TIMED_OUT",
            CertificateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EXPIRED",
            "FAILED",
            "INACTIVE",
            "ISSUED",
            "PENDING_VALIDATION",
            "REVOKED",
            "VALIDATION_TIMED_OUT",
        ]
    }
}
impl AsRef<str> for CertificateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains metadata about an ACM certificate. This structure is returned in the response to a <code>DescribeCertificate</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateDetail {
    /// <p>The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The fully qualified domain name for the certificate, such as www.example.com or example.com.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate. The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website. </p>
    pub subject_alternative_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Contains information about the initial validation of each domain name that occurs as a result of the <code>RequestCertificate</code> request. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>. </p>
    pub domain_validation_options:
        std::option::Option<std::vec::Vec<crate::model::DomainValidation>>,
    /// <p>The serial number of the certificate.</p>
    pub serial: std::option::Option<std::string::String>,
    /// <p>The name of the entity that is associated with the public key contained in the certificate.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The name of the certificate authority that issued and signed the certificate.</p>
    pub issuer: std::option::Option<std::string::String>,
    /// <p>The time at which the certificate was requested.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the certificate was issued. This value exists only when the certificate type is <code>AMAZON_ISSUED</code>. </p>
    pub issued_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time at which the certificate was imported. This value exists only when the certificate type is <code>IMPORTED</code>. </p>
    pub imported_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the certificate.</p>
    pub status: std::option::Option<crate::model::CertificateStatus>,
    /// <p>The time at which the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. </p>
    pub revoked_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The reason the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. </p>
    pub revocation_reason: std::option::Option<crate::model::RevocationReason>,
    /// <p>The time before which the certificate is not valid.</p>
    pub not_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time after which the certificate is not valid.</p>
    pub not_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The algorithm that was used to generate the public-private key pair.</p>
    pub key_algorithm: std::option::Option<crate::model::KeyAlgorithm>,
    /// <p>The algorithm that was used to sign the certificate.</p>
    pub signature_algorithm: std::option::Option<std::string::String>,
    /// <p>A list of ARNs for the Amazon Web Services resources that are using the certificate. A certificate can be used by multiple Amazon Web Services resources. </p>
    pub in_use_by: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The reason the certificate request failed. This value exists only when the certificate status is <code>FAILED</code>. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed">Certificate Request Failed</a> in the <i>Amazon Web Services Certificate Manager User Guide</i>. </p>
    pub failure_reason: std::option::Option<crate::model::FailureReason>,
    /// <p>The source of the certificate. For certificates provided by ACM, this value is <code>AMAZON_ISSUED</code>. For certificates that you imported with <code>ImportCertificate</code>, this value is <code>IMPORTED</code>. ACM does not provide <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for imported certificates. For more information about the differences between certificates that you import and those that ACM provides, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates</a> in the <i>Amazon Web Services Certificate Manager User Guide</i>. </p>
    pub r#type: std::option::Option<crate::model::CertificateType>,
    /// <p>Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for the certificate. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.</p>
    pub renewal_summary: std::option::Option<crate::model::RenewalSummary>,
    /// <p>A list of Key Usage X.509 v3 extension objects. Each object is a string value that identifies the purpose of the public key contained in the certificate. Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.</p>
    pub key_usages: std::option::Option<std::vec::Vec<crate::model::KeyUsage>>,
    /// <p>Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID). </p>
    pub extended_key_usages: std::option::Option<std::vec::Vec<crate::model::ExtendedKeyUsage>>,
    /// <p>The Amazon Resource Name (ARN) of the ACM PCA private certificate authority (CA) that issued the certificate. This has the following format: </p>
    /// <p> <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> </p>
    pub certificate_authority_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether the certificate is eligible for renewal. At this time, only exported private certificates can be renewed with the <code>RenewCertificate</code> command.</p>
    pub renewal_eligibility: std::option::Option<crate::model::RenewalEligibility>,
    /// <p>Value that specifies whether to add the certificate to a transparency log. Certificate transparency makes it possible to detect SSL certificates that have been mistakenly or maliciously issued. A browser might respond to certificate that has not been logged by showing an error message. The logs are cryptographically secure. </p>
    pub options: std::option::Option<crate::model::CertificateOptions>,
}
impl CertificateDetail {
    /// <p>The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The fully qualified domain name for the certificate, such as www.example.com or example.com.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate. The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website. </p>
    pub fn subject_alternative_names(&self) -> std::option::Option<&[std::string::String]> {
        self.subject_alternative_names.as_deref()
    }
    /// <p>Contains information about the initial validation of each domain name that occurs as a result of the <code>RequestCertificate</code> request. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>. </p>
    pub fn domain_validation_options(
        &self,
    ) -> std::option::Option<&[crate::model::DomainValidation]> {
        self.domain_validation_options.as_deref()
    }
    /// <p>The serial number of the certificate.</p>
    pub fn serial(&self) -> std::option::Option<&str> {
        self.serial.as_deref()
    }
    /// <p>The name of the entity that is associated with the public key contained in the certificate.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The name of the certificate authority that issued and signed the certificate.</p>
    pub fn issuer(&self) -> std::option::Option<&str> {
        self.issuer.as_deref()
    }
    /// <p>The time at which the certificate was requested.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time at which the certificate was issued. This value exists only when the certificate type is <code>AMAZON_ISSUED</code>. </p>
    pub fn issued_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.issued_at.as_ref()
    }
    /// <p>The date and time at which the certificate was imported. This value exists only when the certificate type is <code>IMPORTED</code>. </p>
    pub fn imported_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.imported_at.as_ref()
    }
    /// <p>The status of the certificate.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CertificateStatus> {
        self.status.as_ref()
    }
    /// <p>The time at which the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. </p>
    pub fn revoked_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.revoked_at.as_ref()
    }
    /// <p>The reason the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. </p>
    pub fn revocation_reason(&self) -> std::option::Option<&crate::model::RevocationReason> {
        self.revocation_reason.as_ref()
    }
    /// <p>The time before which the certificate is not valid.</p>
    pub fn not_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.not_before.as_ref()
    }
    /// <p>The time after which the certificate is not valid.</p>
    pub fn not_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.not_after.as_ref()
    }
    /// <p>The algorithm that was used to generate the public-private key pair.</p>
    pub fn key_algorithm(&self) -> std::option::Option<&crate::model::KeyAlgorithm> {
        self.key_algorithm.as_ref()
    }
    /// <p>The algorithm that was used to sign the certificate.</p>
    pub fn signature_algorithm(&self) -> std::option::Option<&str> {
        self.signature_algorithm.as_deref()
    }
    /// <p>A list of ARNs for the Amazon Web Services resources that are using the certificate. A certificate can be used by multiple Amazon Web Services resources. </p>
    pub fn in_use_by(&self) -> std::option::Option<&[std::string::String]> {
        self.in_use_by.as_deref()
    }
    /// <p>The reason the certificate request failed. This value exists only when the certificate status is <code>FAILED</code>. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed">Certificate Request Failed</a> in the <i>Amazon Web Services Certificate Manager User Guide</i>. </p>
    pub fn failure_reason(&self) -> std::option::Option<&crate::model::FailureReason> {
        self.failure_reason.as_ref()
    }
    /// <p>The source of the certificate. For certificates provided by ACM, this value is <code>AMAZON_ISSUED</code>. For certificates that you imported with <code>ImportCertificate</code>, this value is <code>IMPORTED</code>. ACM does not provide <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for imported certificates. For more information about the differences between certificates that you import and those that ACM provides, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates</a> in the <i>Amazon Web Services Certificate Manager User Guide</i>. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::CertificateType> {
        self.r#type.as_ref()
    }
    /// <p>Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for the certificate. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.</p>
    pub fn renewal_summary(&self) -> std::option::Option<&crate::model::RenewalSummary> {
        self.renewal_summary.as_ref()
    }
    /// <p>A list of Key Usage X.509 v3 extension objects. Each object is a string value that identifies the purpose of the public key contained in the certificate. Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.</p>
    pub fn key_usages(&self) -> std::option::Option<&[crate::model::KeyUsage]> {
        self.key_usages.as_deref()
    }
    /// <p>Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID). </p>
    pub fn extended_key_usages(&self) -> std::option::Option<&[crate::model::ExtendedKeyUsage]> {
        self.extended_key_usages.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the ACM PCA private certificate authority (CA) that issued the certificate. This has the following format: </p>
    /// <p> <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> </p>
    pub fn certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.certificate_authority_arn.as_deref()
    }
    /// <p>Specifies whether the certificate is eligible for renewal. At this time, only exported private certificates can be renewed with the <code>RenewCertificate</code> command.</p>
    pub fn renewal_eligibility(&self) -> std::option::Option<&crate::model::RenewalEligibility> {
        self.renewal_eligibility.as_ref()
    }
    /// <p>Value that specifies whether to add the certificate to a transparency log. Certificate transparency makes it possible to detect SSL certificates that have been mistakenly or maliciously issued. A browser might respond to certificate that has not been logged by showing an error message. The logs are cryptographically secure. </p>
    pub fn options(&self) -> std::option::Option<&crate::model::CertificateOptions> {
        self.options.as_ref()
    }
}
impl std::fmt::Debug for CertificateDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateDetail");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("subject_alternative_names", &self.subject_alternative_names);
        formatter.field("domain_validation_options", &self.domain_validation_options);
        formatter.field("serial", &self.serial);
        formatter.field("subject", &self.subject);
        formatter.field("issuer", &self.issuer);
        formatter.field("created_at", &self.created_at);
        formatter.field("issued_at", &self.issued_at);
        formatter.field("imported_at", &self.imported_at);
        formatter.field("status", &self.status);
        formatter.field("revoked_at", &self.revoked_at);
        formatter.field("revocation_reason", &self.revocation_reason);
        formatter.field("not_before", &self.not_before);
        formatter.field("not_after", &self.not_after);
        formatter.field("key_algorithm", &self.key_algorithm);
        formatter.field("signature_algorithm", &self.signature_algorithm);
        formatter.field("in_use_by", &self.in_use_by);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("r#type", &self.r#type);
        formatter.field("renewal_summary", &self.renewal_summary);
        formatter.field("key_usages", &self.key_usages);
        formatter.field("extended_key_usages", &self.extended_key_usages);
        formatter.field("certificate_authority_arn", &self.certificate_authority_arn);
        formatter.field("renewal_eligibility", &self.renewal_eligibility);
        formatter.field("options", &self.options);
        formatter.finish()
    }
}
/// See [`CertificateDetail`](crate::model::CertificateDetail)
pub mod certificate_detail {
    /// A builder for [`CertificateDetail`](crate::model::CertificateDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) subject_alternative_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) domain_validation_options:
            std::option::Option<std::vec::Vec<crate::model::DomainValidation>>,
        pub(crate) serial: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) issuer: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) issued_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) imported_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::CertificateStatus>,
        pub(crate) revoked_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revocation_reason: std::option::Option<crate::model::RevocationReason>,
        pub(crate) not_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) not_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) key_algorithm: std::option::Option<crate::model::KeyAlgorithm>,
        pub(crate) signature_algorithm: std::option::Option<std::string::String>,
        pub(crate) in_use_by: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) failure_reason: std::option::Option<crate::model::FailureReason>,
        pub(crate) r#type: std::option::Option<crate::model::CertificateType>,
        pub(crate) renewal_summary: std::option::Option<crate::model::RenewalSummary>,
        pub(crate) key_usages: std::option::Option<std::vec::Vec<crate::model::KeyUsage>>,
        pub(crate) extended_key_usages:
            std::option::Option<std::vec::Vec<crate::model::ExtendedKeyUsage>>,
        pub(crate) certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) renewal_eligibility: std::option::Option<crate::model::RenewalEligibility>,
        pub(crate) options: std::option::Option<crate::model::CertificateOptions>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The fully qualified domain name for the certificate, such as www.example.com or example.com.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name for the certificate, such as www.example.com or example.com.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `subject_alternative_names`.
        ///
        /// To override the contents of this collection use [`set_subject_alternative_names`](Self::set_subject_alternative_names).
        ///
        /// <p>One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate. The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website. </p>
        pub fn subject_alternative_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subject_alternative_names.unwrap_or_default();
            v.push(input.into());
            self.subject_alternative_names = Some(v);
            self
        }
        /// <p>One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate. The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website. </p>
        pub fn set_subject_alternative_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subject_alternative_names = input;
            self
        }
        /// Appends an item to `domain_validation_options`.
        ///
        /// To override the contents of this collection use [`set_domain_validation_options`](Self::set_domain_validation_options).
        ///
        /// <p>Contains information about the initial validation of each domain name that occurs as a result of the <code>RequestCertificate</code> request. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>. </p>
        pub fn domain_validation_options(mut self, input: crate::model::DomainValidation) -> Self {
            let mut v = self.domain_validation_options.unwrap_or_default();
            v.push(input);
            self.domain_validation_options = Some(v);
            self
        }
        /// <p>Contains information about the initial validation of each domain name that occurs as a result of the <code>RequestCertificate</code> request. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>. </p>
        pub fn set_domain_validation_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainValidation>>,
        ) -> Self {
            self.domain_validation_options = input;
            self
        }
        /// <p>The serial number of the certificate.</p>
        pub fn serial(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial = Some(input.into());
            self
        }
        /// <p>The serial number of the certificate.</p>
        pub fn set_serial(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.serial = input;
            self
        }
        /// <p>The name of the entity that is associated with the public key contained in the certificate.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The name of the entity that is associated with the public key contained in the certificate.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The name of the certificate authority that issued and signed the certificate.</p>
        pub fn issuer(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer = Some(input.into());
            self
        }
        /// <p>The name of the certificate authority that issued and signed the certificate.</p>
        pub fn set_issuer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer = input;
            self
        }
        /// <p>The time at which the certificate was requested.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the certificate was requested.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time at which the certificate was issued. This value exists only when the certificate type is <code>AMAZON_ISSUED</code>. </p>
        pub fn issued_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.issued_at = Some(input);
            self
        }
        /// <p>The time at which the certificate was issued. This value exists only when the certificate type is <code>AMAZON_ISSUED</code>. </p>
        pub fn set_issued_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.issued_at = input;
            self
        }
        /// <p>The date and time at which the certificate was imported. This value exists only when the certificate type is <code>IMPORTED</code>. </p>
        pub fn imported_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.imported_at = Some(input);
            self
        }
        /// <p>The date and time at which the certificate was imported. This value exists only when the certificate type is <code>IMPORTED</code>. </p>
        pub fn set_imported_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.imported_at = input;
            self
        }
        /// <p>The status of the certificate.</p>
        pub fn status(mut self, input: crate::model::CertificateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the certificate.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CertificateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time at which the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. </p>
        pub fn revoked_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.revoked_at = Some(input);
            self
        }
        /// <p>The time at which the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. </p>
        pub fn set_revoked_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.revoked_at = input;
            self
        }
        /// <p>The reason the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. </p>
        pub fn revocation_reason(mut self, input: crate::model::RevocationReason) -> Self {
            self.revocation_reason = Some(input);
            self
        }
        /// <p>The reason the certificate was revoked. This value exists only when the certificate status is <code>REVOKED</code>. </p>
        pub fn set_revocation_reason(
            mut self,
            input: std::option::Option<crate::model::RevocationReason>,
        ) -> Self {
            self.revocation_reason = input;
            self
        }
        /// <p>The time before which the certificate is not valid.</p>
        pub fn not_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.not_before = Some(input);
            self
        }
        /// <p>The time before which the certificate is not valid.</p>
        pub fn set_not_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.not_before = input;
            self
        }
        /// <p>The time after which the certificate is not valid.</p>
        pub fn not_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.not_after = Some(input);
            self
        }
        /// <p>The time after which the certificate is not valid.</p>
        pub fn set_not_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.not_after = input;
            self
        }
        /// <p>The algorithm that was used to generate the public-private key pair.</p>
        pub fn key_algorithm(mut self, input: crate::model::KeyAlgorithm) -> Self {
            self.key_algorithm = Some(input);
            self
        }
        /// <p>The algorithm that was used to generate the public-private key pair.</p>
        pub fn set_key_algorithm(
            mut self,
            input: std::option::Option<crate::model::KeyAlgorithm>,
        ) -> Self {
            self.key_algorithm = input;
            self
        }
        /// <p>The algorithm that was used to sign the certificate.</p>
        pub fn signature_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature_algorithm = Some(input.into());
            self
        }
        /// <p>The algorithm that was used to sign the certificate.</p>
        pub fn set_signature_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signature_algorithm = input;
            self
        }
        /// Appends an item to `in_use_by`.
        ///
        /// To override the contents of this collection use [`set_in_use_by`](Self::set_in_use_by).
        ///
        /// <p>A list of ARNs for the Amazon Web Services resources that are using the certificate. A certificate can be used by multiple Amazon Web Services resources. </p>
        pub fn in_use_by(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.in_use_by.unwrap_or_default();
            v.push(input.into());
            self.in_use_by = Some(v);
            self
        }
        /// <p>A list of ARNs for the Amazon Web Services resources that are using the certificate. A certificate can be used by multiple Amazon Web Services resources. </p>
        pub fn set_in_use_by(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.in_use_by = input;
            self
        }
        /// <p>The reason the certificate request failed. This value exists only when the certificate status is <code>FAILED</code>. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed">Certificate Request Failed</a> in the <i>Amazon Web Services Certificate Manager User Guide</i>. </p>
        pub fn failure_reason(mut self, input: crate::model::FailureReason) -> Self {
            self.failure_reason = Some(input);
            self
        }
        /// <p>The reason the certificate request failed. This value exists only when the certificate status is <code>FAILED</code>. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed">Certificate Request Failed</a> in the <i>Amazon Web Services Certificate Manager User Guide</i>. </p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<crate::model::FailureReason>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The source of the certificate. For certificates provided by ACM, this value is <code>AMAZON_ISSUED</code>. For certificates that you imported with <code>ImportCertificate</code>, this value is <code>IMPORTED</code>. ACM does not provide <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for imported certificates. For more information about the differences between certificates that you import and those that ACM provides, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates</a> in the <i>Amazon Web Services Certificate Manager User Guide</i>. </p>
        pub fn r#type(mut self, input: crate::model::CertificateType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The source of the certificate. For certificates provided by ACM, this value is <code>AMAZON_ISSUED</code>. For certificates that you imported with <code>ImportCertificate</code>, this value is <code>IMPORTED</code>. ACM does not provide <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for imported certificates. For more information about the differences between certificates that you import and those that ACM provides, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing Certificates</a> in the <i>Amazon Web Services Certificate Manager User Guide</i>. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CertificateType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for the certificate. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.</p>
        pub fn renewal_summary(mut self, input: crate::model::RenewalSummary) -> Self {
            self.renewal_summary = Some(input);
            self
        }
        /// <p>Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for the certificate. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.</p>
        pub fn set_renewal_summary(
            mut self,
            input: std::option::Option<crate::model::RenewalSummary>,
        ) -> Self {
            self.renewal_summary = input;
            self
        }
        /// Appends an item to `key_usages`.
        ///
        /// To override the contents of this collection use [`set_key_usages`](Self::set_key_usages).
        ///
        /// <p>A list of Key Usage X.509 v3 extension objects. Each object is a string value that identifies the purpose of the public key contained in the certificate. Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.</p>
        pub fn key_usages(mut self, input: crate::model::KeyUsage) -> Self {
            let mut v = self.key_usages.unwrap_or_default();
            v.push(input);
            self.key_usages = Some(v);
            self
        }
        /// <p>A list of Key Usage X.509 v3 extension objects. Each object is a string value that identifies the purpose of the public key contained in the certificate. Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION, and more.</p>
        pub fn set_key_usages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyUsage>>,
        ) -> Self {
            self.key_usages = input;
            self
        }
        /// Appends an item to `extended_key_usages`.
        ///
        /// To override the contents of this collection use [`set_extended_key_usages`](Self::set_extended_key_usages).
        ///
        /// <p>Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID). </p>
        pub fn extended_key_usages(mut self, input: crate::model::ExtendedKeyUsage) -> Self {
            let mut v = self.extended_key_usages.unwrap_or_default();
            v.push(input);
            self.extended_key_usages = Some(v);
            self
        }
        /// <p>Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID). </p>
        pub fn set_extended_key_usages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExtendedKeyUsage>>,
        ) -> Self {
            self.extended_key_usages = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the ACM PCA private certificate authority (CA) that issued the certificate. This has the following format: </p>
        /// <p> <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> </p>
        pub fn certificate_authority_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the ACM PCA private certificate authority (CA) that issued the certificate. This has the following format: </p>
        /// <p> <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> </p>
        pub fn set_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_arn = input;
            self
        }
        /// <p>Specifies whether the certificate is eligible for renewal. At this time, only exported private certificates can be renewed with the <code>RenewCertificate</code> command.</p>
        pub fn renewal_eligibility(mut self, input: crate::model::RenewalEligibility) -> Self {
            self.renewal_eligibility = Some(input);
            self
        }
        /// <p>Specifies whether the certificate is eligible for renewal. At this time, only exported private certificates can be renewed with the <code>RenewCertificate</code> command.</p>
        pub fn set_renewal_eligibility(
            mut self,
            input: std::option::Option<crate::model::RenewalEligibility>,
        ) -> Self {
            self.renewal_eligibility = input;
            self
        }
        /// <p>Value that specifies whether to add the certificate to a transparency log. Certificate transparency makes it possible to detect SSL certificates that have been mistakenly or maliciously issued. A browser might respond to certificate that has not been logged by showing an error message. The logs are cryptographically secure. </p>
        pub fn options(mut self, input: crate::model::CertificateOptions) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>Value that specifies whether to add the certificate to a transparency log. Certificate transparency makes it possible to detect SSL certificates that have been mistakenly or maliciously issued. A browser might respond to certificate that has not been logged by showing an error message. The logs are cryptographically secure. </p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::CertificateOptions>,
        ) -> Self {
            self.options = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateDetail`](crate::model::CertificateDetail)
        pub fn build(self) -> crate::model::CertificateDetail {
            crate::model::CertificateDetail {
                certificate_arn: self.certificate_arn,
                domain_name: self.domain_name,
                subject_alternative_names: self.subject_alternative_names,
                domain_validation_options: self.domain_validation_options,
                serial: self.serial,
                subject: self.subject,
                issuer: self.issuer,
                created_at: self.created_at,
                issued_at: self.issued_at,
                imported_at: self.imported_at,
                status: self.status,
                revoked_at: self.revoked_at,
                revocation_reason: self.revocation_reason,
                not_before: self.not_before,
                not_after: self.not_after,
                key_algorithm: self.key_algorithm,
                signature_algorithm: self.signature_algorithm,
                in_use_by: self.in_use_by,
                failure_reason: self.failure_reason,
                r#type: self.r#type,
                renewal_summary: self.renewal_summary,
                key_usages: self.key_usages,
                extended_key_usages: self.extended_key_usages,
                certificate_authority_arn: self.certificate_authority_arn,
                renewal_eligibility: self.renewal_eligibility,
                options: self.options,
            }
        }
    }
}
impl CertificateDetail {
    /// Creates a new builder-style object to manufacture [`CertificateDetail`](crate::model::CertificateDetail)
    pub fn builder() -> crate::model::certificate_detail::Builder {
        crate::model::certificate_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RenewalEligibility {
    #[allow(missing_docs)] // documentation missing in model
    Eligible,
    #[allow(missing_docs)] // documentation missing in model
    Ineligible,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RenewalEligibility {
    fn from(s: &str) -> Self {
        match s {
            "ELIGIBLE" => RenewalEligibility::Eligible,
            "INELIGIBLE" => RenewalEligibility::Ineligible,
            other => RenewalEligibility::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RenewalEligibility {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RenewalEligibility::from(s))
    }
}
impl RenewalEligibility {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RenewalEligibility::Eligible => "ELIGIBLE",
            RenewalEligibility::Ineligible => "INELIGIBLE",
            RenewalEligibility::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ELIGIBLE", "INELIGIBLE"]
    }
}
impl AsRef<str> for RenewalEligibility {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Extended Key Usage X.509 v3 extension defines one or more purposes for which the public key can be used. This is in addition to or in place of the basic purposes specified by the Key Usage extension. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExtendedKeyUsage {
    /// <p>The name of an Extended Key Usage value.</p>
    pub name: std::option::Option<crate::model::ExtendedKeyUsageName>,
    /// <p>An object identifier (OID) for the extension value. OIDs are strings of numbers separated by periods. The following OIDs are defined in RFC 3280 and RFC 5280. </p>
    /// <ul>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.1 (TLS_WEB_SERVER_AUTHENTICATION)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.2 (TLS_WEB_CLIENT_AUTHENTICATION)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.3 (CODE_SIGNING)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.4 (EMAIL_PROTECTION)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.8 (TIME_STAMPING)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.9 (OCSP_SIGNING)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.5 (IPSEC_END_SYSTEM)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.6 (IPSEC_TUNNEL)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.7 (IPSEC_USER)</code> </p> </li>
    /// </ul>
    pub oid: std::option::Option<std::string::String>,
}
impl ExtendedKeyUsage {
    /// <p>The name of an Extended Key Usage value.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::ExtendedKeyUsageName> {
        self.name.as_ref()
    }
    /// <p>An object identifier (OID) for the extension value. OIDs are strings of numbers separated by periods. The following OIDs are defined in RFC 3280 and RFC 5280. </p>
    /// <ul>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.1 (TLS_WEB_SERVER_AUTHENTICATION)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.2 (TLS_WEB_CLIENT_AUTHENTICATION)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.3 (CODE_SIGNING)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.4 (EMAIL_PROTECTION)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.8 (TIME_STAMPING)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.9 (OCSP_SIGNING)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.5 (IPSEC_END_SYSTEM)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.6 (IPSEC_TUNNEL)</code> </p> </li>
    /// <li> <p> <code>1.3.6.1.5.5.7.3.7 (IPSEC_USER)</code> </p> </li>
    /// </ul>
    pub fn oid(&self) -> std::option::Option<&str> {
        self.oid.as_deref()
    }
}
impl std::fmt::Debug for ExtendedKeyUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExtendedKeyUsage");
        formatter.field("name", &self.name);
        formatter.field("oid", &self.oid);
        formatter.finish()
    }
}
/// See [`ExtendedKeyUsage`](crate::model::ExtendedKeyUsage)
pub mod extended_key_usage {
    /// A builder for [`ExtendedKeyUsage`](crate::model::ExtendedKeyUsage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::ExtendedKeyUsageName>,
        pub(crate) oid: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an Extended Key Usage value.</p>
        pub fn name(mut self, input: crate::model::ExtendedKeyUsageName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of an Extended Key Usage value.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::ExtendedKeyUsageName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>An object identifier (OID) for the extension value. OIDs are strings of numbers separated by periods. The following OIDs are defined in RFC 3280 and RFC 5280. </p>
        /// <ul>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.1 (TLS_WEB_SERVER_AUTHENTICATION)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.2 (TLS_WEB_CLIENT_AUTHENTICATION)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.3 (CODE_SIGNING)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.4 (EMAIL_PROTECTION)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.8 (TIME_STAMPING)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.9 (OCSP_SIGNING)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.5 (IPSEC_END_SYSTEM)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.6 (IPSEC_TUNNEL)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.7 (IPSEC_USER)</code> </p> </li>
        /// </ul>
        pub fn oid(mut self, input: impl Into<std::string::String>) -> Self {
            self.oid = Some(input.into());
            self
        }
        /// <p>An object identifier (OID) for the extension value. OIDs are strings of numbers separated by periods. The following OIDs are defined in RFC 3280 and RFC 5280. </p>
        /// <ul>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.1 (TLS_WEB_SERVER_AUTHENTICATION)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.2 (TLS_WEB_CLIENT_AUTHENTICATION)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.3 (CODE_SIGNING)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.4 (EMAIL_PROTECTION)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.8 (TIME_STAMPING)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.9 (OCSP_SIGNING)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.5 (IPSEC_END_SYSTEM)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.6 (IPSEC_TUNNEL)</code> </p> </li>
        /// <li> <p> <code>1.3.6.1.5.5.7.3.7 (IPSEC_USER)</code> </p> </li>
        /// </ul>
        pub fn set_oid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.oid = input;
            self
        }
        /// Consumes the builder and constructs a [`ExtendedKeyUsage`](crate::model::ExtendedKeyUsage)
        pub fn build(self) -> crate::model::ExtendedKeyUsage {
            crate::model::ExtendedKeyUsage {
                name: self.name,
                oid: self.oid,
            }
        }
    }
}
impl ExtendedKeyUsage {
    /// Creates a new builder-style object to manufacture [`ExtendedKeyUsage`](crate::model::ExtendedKeyUsage)
    pub fn builder() -> crate::model::extended_key_usage::Builder {
        crate::model::extended_key_usage::Builder::default()
    }
}

/// <p>The Key Usage X.509 v3 extension defines the purpose of the public key contained in the certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyUsage {
    /// <p>A string value that contains a Key Usage extension name.</p>
    pub name: std::option::Option<crate::model::KeyUsageName>,
}
impl KeyUsage {
    /// <p>A string value that contains a Key Usage extension name.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::KeyUsageName> {
        self.name.as_ref()
    }
}
impl std::fmt::Debug for KeyUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyUsage");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`KeyUsage`](crate::model::KeyUsage)
pub mod key_usage {
    /// A builder for [`KeyUsage`](crate::model::KeyUsage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::KeyUsageName>,
    }
    impl Builder {
        /// <p>A string value that contains a Key Usage extension name.</p>
        pub fn name(mut self, input: crate::model::KeyUsageName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>A string value that contains a Key Usage extension name.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::KeyUsageName>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyUsage`](crate::model::KeyUsage)
        pub fn build(self) -> crate::model::KeyUsage {
            crate::model::KeyUsage { name: self.name }
        }
    }
}
impl KeyUsage {
    /// Creates a new builder-style object to manufacture [`KeyUsage`](crate::model::KeyUsage)
    pub fn builder() -> crate::model::key_usage::Builder {
        crate::model::key_usage::Builder::default()
    }
}

/// <p>Contains information about the status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> for the certificate. This structure exists only when the certificate type is <code>AMAZON_ISSUED</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RenewalSummary {
    /// <p>The status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> of the certificate.</p>
    pub renewal_status: std::option::Option<crate::model::RenewalStatus>,
    /// <p>Contains information about the validation of each domain name in the certificate, as it pertains to ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a>. This is different from the initial validation that occurs as a result of the <code>RequestCertificate</code> request. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.</p>
    pub domain_validation_options:
        std::option::Option<std::vec::Vec<crate::model::DomainValidation>>,
    /// <p>The reason that a renewal request was unsuccessful.</p>
    pub renewal_status_reason: std::option::Option<crate::model::FailureReason>,
    /// <p>The time at which the renewal summary was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl RenewalSummary {
    /// <p>The status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> of the certificate.</p>
    pub fn renewal_status(&self) -> std::option::Option<&crate::model::RenewalStatus> {
        self.renewal_status.as_ref()
    }
    /// <p>Contains information about the validation of each domain name in the certificate, as it pertains to ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a>. This is different from the initial validation that occurs as a result of the <code>RequestCertificate</code> request. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.</p>
    pub fn domain_validation_options(
        &self,
    ) -> std::option::Option<&[crate::model::DomainValidation]> {
        self.domain_validation_options.as_deref()
    }
    /// <p>The reason that a renewal request was unsuccessful.</p>
    pub fn renewal_status_reason(&self) -> std::option::Option<&crate::model::FailureReason> {
        self.renewal_status_reason.as_ref()
    }
    /// <p>The time at which the renewal summary was last updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for RenewalSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RenewalSummary");
        formatter.field("renewal_status", &self.renewal_status);
        formatter.field("domain_validation_options", &self.domain_validation_options);
        formatter.field("renewal_status_reason", &self.renewal_status_reason);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`RenewalSummary`](crate::model::RenewalSummary)
pub mod renewal_summary {
    /// A builder for [`RenewalSummary`](crate::model::RenewalSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) renewal_status: std::option::Option<crate::model::RenewalStatus>,
        pub(crate) domain_validation_options:
            std::option::Option<std::vec::Vec<crate::model::DomainValidation>>,
        pub(crate) renewal_status_reason: std::option::Option<crate::model::FailureReason>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> of the certificate.</p>
        pub fn renewal_status(mut self, input: crate::model::RenewalStatus) -> Self {
            self.renewal_status = Some(input);
            self
        }
        /// <p>The status of ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a> of the certificate.</p>
        pub fn set_renewal_status(
            mut self,
            input: std::option::Option<crate::model::RenewalStatus>,
        ) -> Self {
            self.renewal_status = input;
            self
        }
        /// Appends an item to `domain_validation_options`.
        ///
        /// To override the contents of this collection use [`set_domain_validation_options`](Self::set_domain_validation_options).
        ///
        /// <p>Contains information about the validation of each domain name in the certificate, as it pertains to ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a>. This is different from the initial validation that occurs as a result of the <code>RequestCertificate</code> request. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.</p>
        pub fn domain_validation_options(mut self, input: crate::model::DomainValidation) -> Self {
            let mut v = self.domain_validation_options.unwrap_or_default();
            v.push(input);
            self.domain_validation_options = Some(v);
            self
        }
        /// <p>Contains information about the validation of each domain name in the certificate, as it pertains to ACM's <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html">managed renewal</a>. This is different from the initial validation that occurs as a result of the <code>RequestCertificate</code> request. This field exists only when the certificate type is <code>AMAZON_ISSUED</code>.</p>
        pub fn set_domain_validation_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainValidation>>,
        ) -> Self {
            self.domain_validation_options = input;
            self
        }
        /// <p>The reason that a renewal request was unsuccessful.</p>
        pub fn renewal_status_reason(mut self, input: crate::model::FailureReason) -> Self {
            self.renewal_status_reason = Some(input);
            self
        }
        /// <p>The reason that a renewal request was unsuccessful.</p>
        pub fn set_renewal_status_reason(
            mut self,
            input: std::option::Option<crate::model::FailureReason>,
        ) -> Self {
            self.renewal_status_reason = input;
            self
        }
        /// <p>The time at which the renewal summary was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The time at which the renewal summary was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`RenewalSummary`](crate::model::RenewalSummary)
        pub fn build(self) -> crate::model::RenewalSummary {
            crate::model::RenewalSummary {
                renewal_status: self.renewal_status,
                domain_validation_options: self.domain_validation_options,
                renewal_status_reason: self.renewal_status_reason,
                updated_at: self.updated_at,
            }
        }
    }
}
impl RenewalSummary {
    /// Creates a new builder-style object to manufacture [`RenewalSummary`](crate::model::RenewalSummary)
    pub fn builder() -> crate::model::renewal_summary::Builder {
        crate::model::renewal_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailureReason {
    #[allow(missing_docs)] // documentation missing in model
    AdditionalVerificationRequired,
    #[allow(missing_docs)] // documentation missing in model
    CaaError,
    #[allow(missing_docs)] // documentation missing in model
    DomainNotAllowed,
    #[allow(missing_docs)] // documentation missing in model
    DomainValidationDenied,
    #[allow(missing_docs)] // documentation missing in model
    InvalidPublicDomain,
    #[allow(missing_docs)] // documentation missing in model
    NoAvailableContacts,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    PcaAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    PcaInvalidArgs,
    #[allow(missing_docs)] // documentation missing in model
    PcaInvalidArn,
    #[allow(missing_docs)] // documentation missing in model
    PcaInvalidDuration,
    #[allow(missing_docs)] // documentation missing in model
    PcaInvalidState,
    #[allow(missing_docs)] // documentation missing in model
    PcaLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    PcaNameConstraintsValidation,
    #[allow(missing_docs)] // documentation missing in model
    PcaRequestFailed,
    #[allow(missing_docs)] // documentation missing in model
    PcaResourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    SlrNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailureReason {
    fn from(s: &str) -> Self {
        match s {
            "ADDITIONAL_VERIFICATION_REQUIRED" => FailureReason::AdditionalVerificationRequired,
            "CAA_ERROR" => FailureReason::CaaError,
            "DOMAIN_NOT_ALLOWED" => FailureReason::DomainNotAllowed,
            "DOMAIN_VALIDATION_DENIED" => FailureReason::DomainValidationDenied,
            "INVALID_PUBLIC_DOMAIN" => FailureReason::InvalidPublicDomain,
            "NO_AVAILABLE_CONTACTS" => FailureReason::NoAvailableContacts,
            "OTHER" => FailureReason::Other,
            "PCA_ACCESS_DENIED" => FailureReason::PcaAccessDenied,
            "PCA_INVALID_ARGS" => FailureReason::PcaInvalidArgs,
            "PCA_INVALID_ARN" => FailureReason::PcaInvalidArn,
            "PCA_INVALID_DURATION" => FailureReason::PcaInvalidDuration,
            "PCA_INVALID_STATE" => FailureReason::PcaInvalidState,
            "PCA_LIMIT_EXCEEDED" => FailureReason::PcaLimitExceeded,
            "PCA_NAME_CONSTRAINTS_VALIDATION" => FailureReason::PcaNameConstraintsValidation,
            "PCA_REQUEST_FAILED" => FailureReason::PcaRequestFailed,
            "PCA_RESOURCE_NOT_FOUND" => FailureReason::PcaResourceNotFound,
            "SLR_NOT_FOUND" => FailureReason::SlrNotFound,
            other => FailureReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailureReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailureReason::from(s))
    }
}
impl FailureReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailureReason::AdditionalVerificationRequired => "ADDITIONAL_VERIFICATION_REQUIRED",
            FailureReason::CaaError => "CAA_ERROR",
            FailureReason::DomainNotAllowed => "DOMAIN_NOT_ALLOWED",
            FailureReason::DomainValidationDenied => "DOMAIN_VALIDATION_DENIED",
            FailureReason::InvalidPublicDomain => "INVALID_PUBLIC_DOMAIN",
            FailureReason::NoAvailableContacts => "NO_AVAILABLE_CONTACTS",
            FailureReason::Other => "OTHER",
            FailureReason::PcaAccessDenied => "PCA_ACCESS_DENIED",
            FailureReason::PcaInvalidArgs => "PCA_INVALID_ARGS",
            FailureReason::PcaInvalidArn => "PCA_INVALID_ARN",
            FailureReason::PcaInvalidDuration => "PCA_INVALID_DURATION",
            FailureReason::PcaInvalidState => "PCA_INVALID_STATE",
            FailureReason::PcaLimitExceeded => "PCA_LIMIT_EXCEEDED",
            FailureReason::PcaNameConstraintsValidation => "PCA_NAME_CONSTRAINTS_VALIDATION",
            FailureReason::PcaRequestFailed => "PCA_REQUEST_FAILED",
            FailureReason::PcaResourceNotFound => "PCA_RESOURCE_NOT_FOUND",
            FailureReason::SlrNotFound => "SLR_NOT_FOUND",
            FailureReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITIONAL_VERIFICATION_REQUIRED",
            "CAA_ERROR",
            "DOMAIN_NOT_ALLOWED",
            "DOMAIN_VALIDATION_DENIED",
            "INVALID_PUBLIC_DOMAIN",
            "NO_AVAILABLE_CONTACTS",
            "OTHER",
            "PCA_ACCESS_DENIED",
            "PCA_INVALID_ARGS",
            "PCA_INVALID_ARN",
            "PCA_INVALID_DURATION",
            "PCA_INVALID_STATE",
            "PCA_LIMIT_EXCEEDED",
            "PCA_NAME_CONSTRAINTS_VALIDATION",
            "PCA_REQUEST_FAILED",
            "PCA_RESOURCE_NOT_FOUND",
            "SLR_NOT_FOUND",
        ]
    }
}
impl AsRef<str> for FailureReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the validation of each domain name in the certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainValidation {
    /// <p>A fully qualified domain name (FQDN) in the certificate. For example, <code>www.example.com</code> or <code>example.com</code>. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>A list of email addresses that ACM used to send domain validation emails.</p>
    pub validation_emails: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The domain name that ACM used to send domain validation emails.</p>
    pub validation_domain: std::option::Option<std::string::String>,
    /// <p>The validation status of the domain name. This can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>PENDING_VALIDATION</code> </p> </li>
    /// <li> <p> <code></code>SUCCESS</p> </li>
    /// <li> <p> <code></code>FAILED</p> </li>
    /// </ul>
    pub validation_status: std::option::Option<crate::model::DomainStatus>,
    /// <p>Contains the CNAME record that you add to your DNS database for domain validation. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">Use DNS to Validate Domain Ownership</a>.</p>
    /// <p>Note: The CNAME information that you need does not include the name of your domain. If you include  your domain name in the DNS database CNAME record, validation fails.  For example, if the name is "_a79865eb4cd1a6ab990a45779b4e0b96.yourdomain.com", only "_a79865eb4cd1a6ab990a45779b4e0b96" must be used.</p>
    pub resource_record: std::option::Option<crate::model::ResourceRecord>,
    /// <p>Specifies the domain validation method.</p>
    pub validation_method: std::option::Option<crate::model::ValidationMethod>,
}
impl DomainValidation {
    /// <p>A fully qualified domain name (FQDN) in the certificate. For example, <code>www.example.com</code> or <code>example.com</code>. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>A list of email addresses that ACM used to send domain validation emails.</p>
    pub fn validation_emails(&self) -> std::option::Option<&[std::string::String]> {
        self.validation_emails.as_deref()
    }
    /// <p>The domain name that ACM used to send domain validation emails.</p>
    pub fn validation_domain(&self) -> std::option::Option<&str> {
        self.validation_domain.as_deref()
    }
    /// <p>The validation status of the domain name. This can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>PENDING_VALIDATION</code> </p> </li>
    /// <li> <p> <code></code>SUCCESS</p> </li>
    /// <li> <p> <code></code>FAILED</p> </li>
    /// </ul>
    pub fn validation_status(&self) -> std::option::Option<&crate::model::DomainStatus> {
        self.validation_status.as_ref()
    }
    /// <p>Contains the CNAME record that you add to your DNS database for domain validation. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">Use DNS to Validate Domain Ownership</a>.</p>
    /// <p>Note: The CNAME information that you need does not include the name of your domain. If you include  your domain name in the DNS database CNAME record, validation fails.  For example, if the name is "_a79865eb4cd1a6ab990a45779b4e0b96.yourdomain.com", only "_a79865eb4cd1a6ab990a45779b4e0b96" must be used.</p>
    pub fn resource_record(&self) -> std::option::Option<&crate::model::ResourceRecord> {
        self.resource_record.as_ref()
    }
    /// <p>Specifies the domain validation method.</p>
    pub fn validation_method(&self) -> std::option::Option<&crate::model::ValidationMethod> {
        self.validation_method.as_ref()
    }
}
impl std::fmt::Debug for DomainValidation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainValidation");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("validation_emails", &self.validation_emails);
        formatter.field("validation_domain", &self.validation_domain);
        formatter.field("validation_status", &self.validation_status);
        formatter.field("resource_record", &self.resource_record);
        formatter.field("validation_method", &self.validation_method);
        formatter.finish()
    }
}
/// See [`DomainValidation`](crate::model::DomainValidation)
pub mod domain_validation {
    /// A builder for [`DomainValidation`](crate::model::DomainValidation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) validation_emails: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) validation_domain: std::option::Option<std::string::String>,
        pub(crate) validation_status: std::option::Option<crate::model::DomainStatus>,
        pub(crate) resource_record: std::option::Option<crate::model::ResourceRecord>,
        pub(crate) validation_method: std::option::Option<crate::model::ValidationMethod>,
    }
    impl Builder {
        /// <p>A fully qualified domain name (FQDN) in the certificate. For example, <code>www.example.com</code> or <code>example.com</code>. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>A fully qualified domain name (FQDN) in the certificate. For example, <code>www.example.com</code> or <code>example.com</code>. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `validation_emails`.
        ///
        /// To override the contents of this collection use [`set_validation_emails`](Self::set_validation_emails).
        ///
        /// <p>A list of email addresses that ACM used to send domain validation emails.</p>
        pub fn validation_emails(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.validation_emails.unwrap_or_default();
            v.push(input.into());
            self.validation_emails = Some(v);
            self
        }
        /// <p>A list of email addresses that ACM used to send domain validation emails.</p>
        pub fn set_validation_emails(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.validation_emails = input;
            self
        }
        /// <p>The domain name that ACM used to send domain validation emails.</p>
        pub fn validation_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.validation_domain = Some(input.into());
            self
        }
        /// <p>The domain name that ACM used to send domain validation emails.</p>
        pub fn set_validation_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.validation_domain = input;
            self
        }
        /// <p>The validation status of the domain name. This can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>PENDING_VALIDATION</code> </p> </li>
        /// <li> <p> <code></code>SUCCESS</p> </li>
        /// <li> <p> <code></code>FAILED</p> </li>
        /// </ul>
        pub fn validation_status(mut self, input: crate::model::DomainStatus) -> Self {
            self.validation_status = Some(input);
            self
        }
        /// <p>The validation status of the domain name. This can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>PENDING_VALIDATION</code> </p> </li>
        /// <li> <p> <code></code>SUCCESS</p> </li>
        /// <li> <p> <code></code>FAILED</p> </li>
        /// </ul>
        pub fn set_validation_status(
            mut self,
            input: std::option::Option<crate::model::DomainStatus>,
        ) -> Self {
            self.validation_status = input;
            self
        }
        /// <p>Contains the CNAME record that you add to your DNS database for domain validation. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">Use DNS to Validate Domain Ownership</a>.</p>
        /// <p>Note: The CNAME information that you need does not include the name of your domain. If you include  your domain name in the DNS database CNAME record, validation fails.  For example, if the name is "_a79865eb4cd1a6ab990a45779b4e0b96.yourdomain.com", only "_a79865eb4cd1a6ab990a45779b4e0b96" must be used.</p>
        pub fn resource_record(mut self, input: crate::model::ResourceRecord) -> Self {
            self.resource_record = Some(input);
            self
        }
        /// <p>Contains the CNAME record that you add to your DNS database for domain validation. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">Use DNS to Validate Domain Ownership</a>.</p>
        /// <p>Note: The CNAME information that you need does not include the name of your domain. If you include  your domain name in the DNS database CNAME record, validation fails.  For example, if the name is "_a79865eb4cd1a6ab990a45779b4e0b96.yourdomain.com", only "_a79865eb4cd1a6ab990a45779b4e0b96" must be used.</p>
        pub fn set_resource_record(
            mut self,
            input: std::option::Option<crate::model::ResourceRecord>,
        ) -> Self {
            self.resource_record = input;
            self
        }
        /// <p>Specifies the domain validation method.</p>
        pub fn validation_method(mut self, input: crate::model::ValidationMethod) -> Self {
            self.validation_method = Some(input);
            self
        }
        /// <p>Specifies the domain validation method.</p>
        pub fn set_validation_method(
            mut self,
            input: std::option::Option<crate::model::ValidationMethod>,
        ) -> Self {
            self.validation_method = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainValidation`](crate::model::DomainValidation)
        pub fn build(self) -> crate::model::DomainValidation {
            crate::model::DomainValidation {
                domain_name: self.domain_name,
                validation_emails: self.validation_emails,
                validation_domain: self.validation_domain,
                validation_status: self.validation_status,
                resource_record: self.resource_record,
                validation_method: self.validation_method,
            }
        }
    }
}
impl DomainValidation {
    /// Creates a new builder-style object to manufacture [`DomainValidation`](crate::model::DomainValidation)
    pub fn builder() -> crate::model::domain_validation::Builder {
        crate::model::domain_validation::Builder::default()
    }
}

/// <p>Contains a DNS record value that you can use to validate ownership or control of a domain. This is used by the <code>DescribeCertificate</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceRecord {
    /// <p>The name of the DNS record to create in your domain. This is supplied by ACM.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of DNS record. Currently this can be <code>CNAME</code>.</p>
    pub r#type: std::option::Option<crate::model::RecordType>,
    /// <p>The value of the CNAME record to add to your DNS database. This is supplied by ACM.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ResourceRecord {
    /// <p>The name of the DNS record to create in your domain. This is supplied by ACM.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of DNS record. Currently this can be <code>CNAME</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RecordType> {
        self.r#type.as_ref()
    }
    /// <p>The value of the CNAME record to add to your DNS database. This is supplied by ACM.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ResourceRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceRecord");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ResourceRecord`](crate::model::ResourceRecord)
pub mod resource_record {
    /// A builder for [`ResourceRecord`](crate::model::ResourceRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::RecordType>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DNS record to create in your domain. This is supplied by ACM.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the DNS record to create in your domain. This is supplied by ACM.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of DNS record. Currently this can be <code>CNAME</code>.</p>
        pub fn r#type(mut self, input: crate::model::RecordType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of DNS record. Currently this can be <code>CNAME</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RecordType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The value of the CNAME record to add to your DNS database. This is supplied by ACM.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the CNAME record to add to your DNS database. This is supplied by ACM.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceRecord`](crate::model::ResourceRecord)
        pub fn build(self) -> crate::model::ResourceRecord {
            crate::model::ResourceRecord {
                name: self.name,
                r#type: self.r#type,
                value: self.value,
            }
        }
    }
}
impl ResourceRecord {
    /// Creates a new builder-style object to manufacture [`ResourceRecord`](crate::model::ResourceRecord)
    pub fn builder() -> crate::model::resource_record::Builder {
        crate::model::resource_record::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecordType {
    #[allow(missing_docs)] // documentation missing in model
    Cname,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecordType {
    fn from(s: &str) -> Self {
        match s {
            "CNAME" => RecordType::Cname,
            other => RecordType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecordType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecordType::from(s))
    }
}
impl RecordType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecordType::Cname => "CNAME",
            RecordType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CNAME"]
    }
}
impl AsRef<str> for RecordType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DomainStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    PendingValidation,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DomainStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => DomainStatus::Failed,
            "PENDING_VALIDATION" => DomainStatus::PendingValidation,
            "SUCCESS" => DomainStatus::Success,
            other => DomainStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DomainStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DomainStatus::from(s))
    }
}
impl DomainStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DomainStatus::Failed => "FAILED",
            DomainStatus::PendingValidation => "PENDING_VALIDATION",
            DomainStatus::Success => "SUCCESS",
            DomainStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PENDING_VALIDATION", "SUCCESS"]
    }
}
impl AsRef<str> for DomainStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RenewalStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    PendingAutoRenewal,
    #[allow(missing_docs)] // documentation missing in model
    PendingValidation,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RenewalStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => RenewalStatus::Failed,
            "PENDING_AUTO_RENEWAL" => RenewalStatus::PendingAutoRenewal,
            "PENDING_VALIDATION" => RenewalStatus::PendingValidation,
            "SUCCESS" => RenewalStatus::Success,
            other => RenewalStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RenewalStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RenewalStatus::from(s))
    }
}
impl RenewalStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RenewalStatus::Failed => "FAILED",
            RenewalStatus::PendingAutoRenewal => "PENDING_AUTO_RENEWAL",
            RenewalStatus::PendingValidation => "PENDING_VALIDATION",
            RenewalStatus::Success => "SUCCESS",
            RenewalStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "PENDING_AUTO_RENEWAL",
            "PENDING_VALIDATION",
            "SUCCESS",
        ]
    }
}
impl AsRef<str> for RenewalStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateType {
    #[allow(missing_docs)] // documentation missing in model
    AmazonIssued,
    #[allow(missing_docs)] // documentation missing in model
    Imported,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateType {
    fn from(s: &str) -> Self {
        match s {
            "AMAZON_ISSUED" => CertificateType::AmazonIssued,
            "IMPORTED" => CertificateType::Imported,
            "PRIVATE" => CertificateType::Private,
            other => CertificateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateType::from(s))
    }
}
impl CertificateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateType::AmazonIssued => "AMAZON_ISSUED",
            CertificateType::Imported => "IMPORTED",
            CertificateType::Private => "PRIVATE",
            CertificateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AMAZON_ISSUED", "IMPORTED", "PRIVATE"]
    }
}
impl AsRef<str> for CertificateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RevocationReason {
    #[allow(missing_docs)] // documentation missing in model
    AffiliationChanged,
    #[allow(missing_docs)] // documentation missing in model
    AACompromise,
    #[allow(missing_docs)] // documentation missing in model
    CaCompromise,
    #[allow(missing_docs)] // documentation missing in model
    CertificateHold,
    #[allow(missing_docs)] // documentation missing in model
    CessationOfOperation,
    #[allow(missing_docs)] // documentation missing in model
    KeyCompromise,
    #[allow(missing_docs)] // documentation missing in model
    PrivilegeWithdrawn,
    #[allow(missing_docs)] // documentation missing in model
    RemoveFromCrl,
    #[allow(missing_docs)] // documentation missing in model
    Superceded,
    #[allow(missing_docs)] // documentation missing in model
    Unspecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RevocationReason {
    fn from(s: &str) -> Self {
        match s {
            "AFFILIATION_CHANGED" => RevocationReason::AffiliationChanged,
            "A_A_COMPROMISE" => RevocationReason::AACompromise,
            "CA_COMPROMISE" => RevocationReason::CaCompromise,
            "CERTIFICATE_HOLD" => RevocationReason::CertificateHold,
            "CESSATION_OF_OPERATION" => RevocationReason::CessationOfOperation,
            "KEY_COMPROMISE" => RevocationReason::KeyCompromise,
            "PRIVILEGE_WITHDRAWN" => RevocationReason::PrivilegeWithdrawn,
            "REMOVE_FROM_CRL" => RevocationReason::RemoveFromCrl,
            "SUPERCEDED" => RevocationReason::Superceded,
            "UNSPECIFIED" => RevocationReason::Unspecified,
            other => RevocationReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RevocationReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RevocationReason::from(s))
    }
}
impl RevocationReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RevocationReason::AffiliationChanged => "AFFILIATION_CHANGED",
            RevocationReason::AACompromise => "A_A_COMPROMISE",
            RevocationReason::CaCompromise => "CA_COMPROMISE",
            RevocationReason::CertificateHold => "CERTIFICATE_HOLD",
            RevocationReason::CessationOfOperation => "CESSATION_OF_OPERATION",
            RevocationReason::KeyCompromise => "KEY_COMPROMISE",
            RevocationReason::PrivilegeWithdrawn => "PRIVILEGE_WITHDRAWN",
            RevocationReason::RemoveFromCrl => "REMOVE_FROM_CRL",
            RevocationReason::Superceded => "SUPERCEDED",
            RevocationReason::Unspecified => "UNSPECIFIED",
            RevocationReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AFFILIATION_CHANGED",
            "A_A_COMPROMISE",
            "CA_COMPROMISE",
            "CERTIFICATE_HOLD",
            "CESSATION_OF_OPERATION",
            "KEY_COMPROMISE",
            "PRIVILEGE_WITHDRAWN",
            "REMOVE_FROM_CRL",
            "SUPERCEDED",
            "UNSPECIFIED",
        ]
    }
}
impl AsRef<str> for RevocationReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
