// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddTagsToCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsToCertificateError {
    /// Kind of error that occurred.
    pub kind: AddTagsToCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTagsToCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsToCertificateErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>An input parameter was invalid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>One or both of the values that make up the key-value pair is not valid. For example, you
    /// cannot specify a tag value that begins with <code>aws:</code>.</p>
    InvalidTagException(crate::error::InvalidTagException),
    /// <p>The specified certificate cannot be found in the caller's account or the caller's account
    /// cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A specified tag did not comply with an existing tag policy and was rejected.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// <p>The request was denied
    /// because it exceeded a quota.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request contains too many tags. Try the request again with fewer tags.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsToCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsToCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            AddTagsToCertificateErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AddTagsToCertificateErrorKind::InvalidTagException(_inner) => _inner.fmt(f),
            AddTagsToCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddTagsToCertificateErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            AddTagsToCertificateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AddTagsToCertificateErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            AddTagsToCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsToCertificateError {
    fn code(&self) -> Option<&str> {
        AddTagsToCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsToCertificateError {
    /// Creates a new `AddTagsToCertificateError`.
    pub fn new(kind: AddTagsToCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsToCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsToCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsToCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsToCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddTagsToCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `AddTagsToCertificateErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToCertificateErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `AddTagsToCertificateErrorKind::InvalidTagException`.
    pub fn is_invalid_tag_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToCertificateErrorKind::InvalidTagException(_)
        )
    }
    /// Returns true if the error kind is `AddTagsToCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AddTagsToCertificateErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToCertificateErrorKind::TagPolicyException(_)
        )
    }
    /// Returns true if the error kind is `AddTagsToCertificateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToCertificateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `AddTagsToCertificateErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToCertificateErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for AddTagsToCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsToCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            AddTagsToCertificateErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AddTagsToCertificateErrorKind::InvalidTagException(_inner) => Some(_inner),
            AddTagsToCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddTagsToCertificateErrorKind::TagPolicyException(_inner) => Some(_inner),
            AddTagsToCertificateErrorKind::ThrottlingException(_inner) => Some(_inner),
            AddTagsToCertificateErrorKind::TooManyTagsException(_inner) => Some(_inner),
            AddTagsToCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCertificateError {
    /// Kind of error that occurred.
    pub kind: DeleteCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCertificateErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The certificate is in use by another Amazon Web Services service in the caller's account. Remove the
    /// association and try again.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified certificate cannot be found in the caller's account or the caller's account
    /// cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCertificateError {
    fn code(&self) -> Option<&str> {
        DeleteCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCertificateError {
    /// Creates a new `DeleteCertificateError`.
    pub fn new(kind: DeleteCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCertificateErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCertificateError {
    /// Kind of error that occurred.
    pub kind: DescribeCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCertificateErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The specified certificate cannot be found in the caller's account or the caller's account
    /// cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCertificateError {
    fn code(&self) -> Option<&str> {
        DescribeCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCertificateError {
    /// Creates a new `DescribeCertificateError`.
    pub fn new(kind: DescribeCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExportCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExportCertificateError {
    /// Kind of error that occurred.
    pub kind: ExportCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExportCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExportCertificateErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The certificate request is in process and the certificate in your account has not yet been
    /// issued.</p>
    RequestInProgressException(crate::error::RequestInProgressException),
    /// <p>The specified certificate cannot be found in the caller's account or the caller's account
    /// cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExportCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExportCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ExportCertificateErrorKind::RequestInProgressException(_inner) => _inner.fmt(f),
            ExportCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ExportCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExportCertificateError {
    fn code(&self) -> Option<&str> {
        ExportCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExportCertificateError {
    /// Creates a new `ExportCertificateError`.
    pub fn new(kind: ExportCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExportCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExportCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExportCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExportCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ExportCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ExportCertificateErrorKind::RequestInProgressException`.
    pub fn is_request_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportCertificateErrorKind::RequestInProgressException(_)
        )
    }
    /// Returns true if the error kind is `ExportCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ExportCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExportCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            ExportCertificateErrorKind::RequestInProgressException(_inner) => Some(_inner),
            ExportCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ExportCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccountConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetAccountConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccountConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountConfigurationErrorKind {
    /// <p>You do not have access
    /// required to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request was denied
    /// because it exceeded a quota.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAccountConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetAccountConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountConfigurationError {
    fn code(&self) -> Option<&str> {
        GetAccountConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountConfigurationError {
    /// Creates a new `GetAccountConfigurationError`.
    pub fn new(kind: GetAccountConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAccountConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetAccountConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountConfigurationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetAccountConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAccountConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetAccountConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCertificateError {
    /// Kind of error that occurred.
    pub kind: GetCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCertificateErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The certificate request is in process and the certificate in your account has not yet been
    /// issued.</p>
    RequestInProgressException(crate::error::RequestInProgressException),
    /// <p>The specified certificate cannot be found in the caller's account or the caller's account
    /// cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetCertificateErrorKind::RequestInProgressException(_inner) => _inner.fmt(f),
            GetCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCertificateError {
    fn code(&self) -> Option<&str> {
        GetCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCertificateError {
    /// Creates a new `GetCertificateError`.
    pub fn new(kind: GetCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, GetCertificateErrorKind::InvalidArnException(_))
    }
    /// Returns true if the error kind is `GetCertificateErrorKind::RequestInProgressException`.
    pub fn is_request_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateErrorKind::RequestInProgressException(_)
        )
    }
    /// Returns true if the error kind is `GetCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetCertificateErrorKind::RequestInProgressException(_inner) => Some(_inner),
            GetCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportCertificateError {
    /// Kind of error that occurred.
    pub kind: ImportCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportCertificateErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>An input parameter was invalid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>One or both of the values that make up the key-value pair is not valid. For example, you
    /// cannot specify a tag value that begins with <code>aws:</code>.</p>
    InvalidTagException(crate::error::InvalidTagException),
    /// <p>An ACM quota has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified certificate cannot be found in the caller's account or the caller's account
    /// cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A specified tag did not comply with an existing tag policy and was rejected.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// <p>The request contains too many tags. Try the request again with fewer tags.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ImportCertificateErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ImportCertificateErrorKind::InvalidTagException(_inner) => _inner.fmt(f),
            ImportCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ImportCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ImportCertificateErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            ImportCertificateErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            ImportCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportCertificateError {
    fn code(&self) -> Option<&str> {
        ImportCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportCertificateError {
    /// Creates a new `ImportCertificateError`.
    pub fn new(kind: ImportCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ImportCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ImportCertificateErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `ImportCertificateErrorKind::InvalidTagException`.
    pub fn is_invalid_tag_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateErrorKind::InvalidTagException(_)
        )
    }
    /// Returns true if the error kind is `ImportCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ImportCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ImportCertificateErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateErrorKind::TagPolicyException(_)
        )
    }
    /// Returns true if the error kind is `ImportCertificateErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for ImportCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            ImportCertificateErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ImportCertificateErrorKind::InvalidTagException(_inner) => Some(_inner),
            ImportCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            ImportCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ImportCertificateErrorKind::TagPolicyException(_inner) => Some(_inner),
            ImportCertificateErrorKind::TooManyTagsException(_inner) => Some(_inner),
            ImportCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCertificatesError {
    /// Kind of error that occurred.
    pub kind: ListCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCertificatesErrorKind {
    /// <p>One or more of of request parameters specified is not valid.</p>
    InvalidArgsException(crate::error::InvalidArgsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCertificatesErrorKind::InvalidArgsException(_inner) => _inner.fmt(f),
            ListCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCertificatesError {
    fn code(&self) -> Option<&str> {
        ListCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCertificatesError {
    /// Creates a new `ListCertificatesError`.
    pub fn new(kind: ListCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListCertificatesErrorKind::InvalidArgsException`.
    pub fn is_invalid_args_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesErrorKind::InvalidArgsException(_)
        )
    }
}
impl std::error::Error for ListCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCertificatesErrorKind::InvalidArgsException(_inner) => Some(_inner),
            ListCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForCertificateError {
    /// Kind of error that occurred.
    pub kind: ListTagsForCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForCertificateErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The specified certificate cannot be found in the caller's account or the caller's account
    /// cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListTagsForCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForCertificateError {
    fn code(&self) -> Option<&str> {
        ListTagsForCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForCertificateError {
    /// Creates a new `ListTagsForCertificateError`.
    pub fn new(kind: ListTagsForCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListTagsForCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAccountConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAccountConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutAccountConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAccountConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAccountConfigurationErrorKind {
    /// <p>You do not have access
    /// required to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You are trying to
    /// update a resource or configuration that is already being created or updated. Wait for the
    /// previous operation to finish and try again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request was denied
    /// because it exceeded a quota.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The supplied input
    /// failed to satisfy constraints of an Amazon Web Services service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAccountConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAccountConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutAccountConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutAccountConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutAccountConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutAccountConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAccountConfigurationError {
    fn code(&self) -> Option<&str> {
        PutAccountConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAccountConfigurationError {
    /// Creates a new `PutAccountConfigurationError`.
    pub fn new(kind: PutAccountConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAccountConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAccountConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAccountConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAccountConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutAccountConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `PutAccountConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `PutAccountConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `PutAccountConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutAccountConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAccountConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutAccountConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            PutAccountConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutAccountConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            PutAccountConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTagsFromCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsFromCertificateError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsFromCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTagsFromCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsFromCertificateErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>An input parameter was invalid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>One or both of the values that make up the key-value pair is not valid. For example, you
    /// cannot specify a tag value that begins with <code>aws:</code>.</p>
    InvalidTagException(crate::error::InvalidTagException),
    /// <p>The specified certificate cannot be found in the caller's account or the caller's account
    /// cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A specified tag did not comply with an existing tag policy and was rejected.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// <p>The request was denied
    /// because it exceeded a quota.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsFromCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsFromCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            RemoveTagsFromCertificateErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RemoveTagsFromCertificateErrorKind::InvalidTagException(_inner) => _inner.fmt(f),
            RemoveTagsFromCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RemoveTagsFromCertificateErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            RemoveTagsFromCertificateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RemoveTagsFromCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsFromCertificateError {
    fn code(&self) -> Option<&str> {
        RemoveTagsFromCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsFromCertificateError {
    /// Creates a new `RemoveTagsFromCertificateError`.
    pub fn new(kind: RemoveTagsFromCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsFromCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsFromCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsFromCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsFromCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RemoveTagsFromCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `RemoveTagsFromCertificateErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromCertificateErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `RemoveTagsFromCertificateErrorKind::InvalidTagException`.
    pub fn is_invalid_tag_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromCertificateErrorKind::InvalidTagException(_)
        )
    }
    /// Returns true if the error kind is `RemoveTagsFromCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `RemoveTagsFromCertificateErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromCertificateErrorKind::TagPolicyException(_)
        )
    }
    /// Returns true if the error kind is `RemoveTagsFromCertificateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromCertificateErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for RemoveTagsFromCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsFromCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            RemoveTagsFromCertificateErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RemoveTagsFromCertificateErrorKind::InvalidTagException(_inner) => Some(_inner),
            RemoveTagsFromCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RemoveTagsFromCertificateErrorKind::TagPolicyException(_inner) => Some(_inner),
            RemoveTagsFromCertificateErrorKind::ThrottlingException(_inner) => Some(_inner),
            RemoveTagsFromCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RenewCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RenewCertificateError {
    /// Kind of error that occurred.
    pub kind: RenewCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RenewCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RenewCertificateErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The specified certificate cannot be found in the caller's account or the caller's account
    /// cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RenewCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RenewCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            RenewCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RenewCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RenewCertificateError {
    fn code(&self) -> Option<&str> {
        RenewCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RenewCertificateError {
    /// Creates a new `RenewCertificateError`.
    pub fn new(kind: RenewCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RenewCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RenewCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RenewCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RenewCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RenewCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            RenewCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `RenewCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RenewCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RenewCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RenewCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            RenewCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RenewCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RequestCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RequestCertificateError {
    /// Kind of error that occurred.
    pub kind: RequestCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RequestCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RequestCertificateErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>One or more values in the <a>DomainValidationOption</a> structure is
    /// incorrect.</p>
    InvalidDomainValidationOptionsException(crate::error::InvalidDomainValidationOptionsException),
    /// <p>An input parameter was invalid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>One or both of the values that make up the key-value pair is not valid. For example, you
    /// cannot specify a tag value that begins with <code>aws:</code>.</p>
    InvalidTagException(crate::error::InvalidTagException),
    /// <p>An ACM quota has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A specified tag did not comply with an existing tag policy and was rejected.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// <p>The request contains too many tags. Try the request again with fewer tags.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RequestCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RequestCertificateErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            RequestCertificateErrorKind::InvalidDomainValidationOptionsException(_inner) => {
                _inner.fmt(f)
            }
            RequestCertificateErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RequestCertificateErrorKind::InvalidTagException(_inner) => _inner.fmt(f),
            RequestCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RequestCertificateErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            RequestCertificateErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            RequestCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RequestCertificateError {
    fn code(&self) -> Option<&str> {
        RequestCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RequestCertificateError {
    /// Creates a new `RequestCertificateError`.
    pub fn new(kind: RequestCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RequestCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RequestCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RequestCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RequestCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RequestCertificateErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestCertificateErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `RequestCertificateErrorKind::InvalidDomainValidationOptionsException`.
    pub fn is_invalid_domain_validation_options_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestCertificateErrorKind::InvalidDomainValidationOptionsException(_)
        )
    }
    /// Returns true if the error kind is `RequestCertificateErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestCertificateErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `RequestCertificateErrorKind::InvalidTagException`.
    pub fn is_invalid_tag_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestCertificateErrorKind::InvalidTagException(_)
        )
    }
    /// Returns true if the error kind is `RequestCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `RequestCertificateErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestCertificateErrorKind::TagPolicyException(_)
        )
    }
    /// Returns true if the error kind is `RequestCertificateErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestCertificateErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for RequestCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RequestCertificateErrorKind::InvalidArnException(_inner) => Some(_inner),
            RequestCertificateErrorKind::InvalidDomainValidationOptionsException(_inner) => {
                Some(_inner)
            }
            RequestCertificateErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RequestCertificateErrorKind::InvalidTagException(_inner) => Some(_inner),
            RequestCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            RequestCertificateErrorKind::TagPolicyException(_inner) => Some(_inner),
            RequestCertificateErrorKind::TooManyTagsException(_inner) => Some(_inner),
            RequestCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResendValidationEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResendValidationEmailError {
    /// Kind of error that occurred.
    pub kind: ResendValidationEmailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResendValidationEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResendValidationEmailErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>One or more values in the <a>DomainValidationOption</a> structure is
    /// incorrect.</p>
    InvalidDomainValidationOptionsException(crate::error::InvalidDomainValidationOptionsException),
    /// <p>Processing has reached an invalid state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The specified certificate cannot be found in the caller's account or the caller's account
    /// cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResendValidationEmailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResendValidationEmailErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ResendValidationEmailErrorKind::InvalidDomainValidationOptionsException(_inner) => {
                _inner.fmt(f)
            }
            ResendValidationEmailErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            ResendValidationEmailErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ResendValidationEmailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResendValidationEmailError {
    fn code(&self) -> Option<&str> {
        ResendValidationEmailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResendValidationEmailError {
    /// Creates a new `ResendValidationEmailError`.
    pub fn new(kind: ResendValidationEmailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResendValidationEmailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResendValidationEmailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResendValidationEmailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResendValidationEmailErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ResendValidationEmailErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendValidationEmailErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `ResendValidationEmailErrorKind::InvalidDomainValidationOptionsException`.
    pub fn is_invalid_domain_validation_options_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendValidationEmailErrorKind::InvalidDomainValidationOptionsException(_)
        )
    }
    /// Returns true if the error kind is `ResendValidationEmailErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendValidationEmailErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `ResendValidationEmailErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResendValidationEmailErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ResendValidationEmailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResendValidationEmailErrorKind::InvalidArnException(_inner) => Some(_inner),
            ResendValidationEmailErrorKind::InvalidDomainValidationOptionsException(_inner) => {
                Some(_inner)
            }
            ResendValidationEmailErrorKind::InvalidStateException(_inner) => Some(_inner),
            ResendValidationEmailErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ResendValidationEmailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCertificateOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCertificateOptionsError {
    /// Kind of error that occurred.
    pub kind: UpdateCertificateOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCertificateOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCertificateOptionsErrorKind {
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>Processing has reached an invalid state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>An ACM quota has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified certificate cannot be found in the caller's account or the caller's account
    /// cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCertificateOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCertificateOptionsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UpdateCertificateOptionsErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            UpdateCertificateOptionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateCertificateOptionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateCertificateOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCertificateOptionsError {
    fn code(&self) -> Option<&str> {
        UpdateCertificateOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCertificateOptionsError {
    /// Creates a new `UpdateCertificateOptionsError`.
    pub fn new(kind: UpdateCertificateOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCertificateOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCertificateOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCertificateOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCertificateOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateCertificateOptionsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCertificateOptionsErrorKind::InvalidArnException(_)
        )
    }
    /// Returns true if the error kind is `UpdateCertificateOptionsErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCertificateOptionsErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `UpdateCertificateOptionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCertificateOptionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateCertificateOptionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCertificateOptionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateCertificateOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCertificateOptionsErrorKind::InvalidArnException(_inner) => Some(_inner),
            UpdateCertificateOptionsErrorKind::InvalidStateException(_inner) => Some(_inner),
            UpdateCertificateOptionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateCertificateOptionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateCertificateOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified certificate cannot be found in the caller's account or the caller's account
/// cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>An ACM quota has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>Processing has reached an invalid state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidStateException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidStateException {}
/// See [`InvalidStateException`](crate::error::InvalidStateException)
pub mod invalid_state_exception {
    /// A builder for [`InvalidStateException`](crate::error::InvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidStateException`](crate::error::InvalidStateException)
        pub fn build(self) -> crate::error::InvalidStateException {
            crate::error::InvalidStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidStateException {
    /// Creates a new builder-style object to manufacture [`InvalidStateException`](crate::error::InvalidStateException)
    pub fn builder() -> crate::error::invalid_state_exception::Builder {
        crate::error::invalid_state_exception::Builder::default()
    }
}

/// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArnException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArnException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArnException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArnException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArnException {}
/// See [`InvalidArnException`](crate::error::InvalidArnException)
pub mod invalid_arn_exception {
    /// A builder for [`InvalidArnException`](crate::error::InvalidArnException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArnException`](crate::error::InvalidArnException)
        pub fn build(self) -> crate::error::InvalidArnException {
            crate::error::InvalidArnException {
                message: self.message,
            }
        }
    }
}
impl InvalidArnException {
    /// Creates a new builder-style object to manufacture [`InvalidArnException`](crate::error::InvalidArnException)
    pub fn builder() -> crate::error::invalid_arn_exception::Builder {
        crate::error::invalid_arn_exception::Builder::default()
    }
}

/// <p>One or more values in the <a>DomainValidationOption</a> structure is
/// incorrect.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDomainValidationOptionsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDomainValidationOptionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDomainValidationOptionsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDomainValidationOptionsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDomainValidationOptionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDomainValidationOptionsException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDomainValidationOptionsException {}
/// See [`InvalidDomainValidationOptionsException`](crate::error::InvalidDomainValidationOptionsException)
pub mod invalid_domain_validation_options_exception {
    /// A builder for [`InvalidDomainValidationOptionsException`](crate::error::InvalidDomainValidationOptionsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDomainValidationOptionsException`](crate::error::InvalidDomainValidationOptionsException)
        pub fn build(self) -> crate::error::InvalidDomainValidationOptionsException {
            crate::error::InvalidDomainValidationOptionsException {
                message: self.message,
            }
        }
    }
}
impl InvalidDomainValidationOptionsException {
    /// Creates a new builder-style object to manufacture [`InvalidDomainValidationOptionsException`](crate::error::InvalidDomainValidationOptionsException)
    pub fn builder() -> crate::error::invalid_domain_validation_options_exception::Builder {
        crate::error::invalid_domain_validation_options_exception::Builder::default()
    }
}

/// <p>The request contains too many tags. Try the request again with fewer tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>A specified tag did not comply with an existing tag policy and was rejected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagPolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagPolicyException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagPolicyException {}
/// See [`TagPolicyException`](crate::error::TagPolicyException)
pub mod tag_policy_exception {
    /// A builder for [`TagPolicyException`](crate::error::TagPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagPolicyException`](crate::error::TagPolicyException)
        pub fn build(self) -> crate::error::TagPolicyException {
            crate::error::TagPolicyException {
                message: self.message,
            }
        }
    }
}
impl TagPolicyException {
    /// Creates a new builder-style object to manufacture [`TagPolicyException`](crate::error::TagPolicyException)
    pub fn builder() -> crate::error::tag_policy_exception::Builder {
        crate::error::tag_policy_exception::Builder::default()
    }
}

/// <p>One or both of the values that make up the key-value pair is not valid. For example, you
/// cannot specify a tag value that begins with <code>aws:</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTagException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTagException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTagException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTagException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTagException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTagException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTagException {}
/// See [`InvalidTagException`](crate::error::InvalidTagException)
pub mod invalid_tag_exception {
    /// A builder for [`InvalidTagException`](crate::error::InvalidTagException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTagException`](crate::error::InvalidTagException)
        pub fn build(self) -> crate::error::InvalidTagException {
            crate::error::InvalidTagException {
                message: self.message,
            }
        }
    }
}
impl InvalidTagException {
    /// Creates a new builder-style object to manufacture [`InvalidTagException`](crate::error::InvalidTagException)
    pub fn builder() -> crate::error::invalid_tag_exception::Builder {
        crate::error::invalid_tag_exception::Builder::default()
    }
}

/// <p>An input parameter was invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>The request was denied
/// because it exceeded a quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The supplied input
/// failed to satisfy constraints of an Amazon Web Services service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>You are trying to
/// update a resource or configuration that is already being created or updated. Wait for the
/// previous operation to finish and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You do not have access
/// required to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>One or more of of request parameters specified is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArgsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArgsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArgsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArgsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArgsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArgsException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArgsException {}
/// See [`InvalidArgsException`](crate::error::InvalidArgsException)
pub mod invalid_args_exception {
    /// A builder for [`InvalidArgsException`](crate::error::InvalidArgsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArgsException`](crate::error::InvalidArgsException)
        pub fn build(self) -> crate::error::InvalidArgsException {
            crate::error::InvalidArgsException {
                message: self.message,
            }
        }
    }
}
impl InvalidArgsException {
    /// Creates a new builder-style object to manufacture [`InvalidArgsException`](crate::error::InvalidArgsException)
    pub fn builder() -> crate::error::invalid_args_exception::Builder {
        crate::error::invalid_args_exception::Builder::default()
    }
}

/// <p>The certificate request is in process and the certificate in your account has not yet been
/// issued.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestInProgressException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestInProgressException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestInProgressException {}
/// See [`RequestInProgressException`](crate::error::RequestInProgressException)
pub mod request_in_progress_exception {
    /// A builder for [`RequestInProgressException`](crate::error::RequestInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestInProgressException`](crate::error::RequestInProgressException)
        pub fn build(self) -> crate::error::RequestInProgressException {
            crate::error::RequestInProgressException {
                message: self.message,
            }
        }
    }
}
impl RequestInProgressException {
    /// Creates a new builder-style object to manufacture [`RequestInProgressException`](crate::error::RequestInProgressException)
    pub fn builder() -> crate::error::request_in_progress_exception::Builder {
        crate::error::request_in_progress_exception::Builder::default()
    }
}

/// <p>The certificate is in use by another Amazon Web Services service in the caller's account. Remove the
/// association and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}
