// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`DeleteAlternateContactInput`](crate::input::DeleteAlternateContactInput)
pub mod delete_alternate_contact_input {
    /// A builder for [`DeleteAlternateContactInput`](crate::input::DeleteAlternateContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alternate_contact_type: std::option::Option<crate::model::AlternateContactType>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies which of the alternate contacts to delete. </p>
        pub fn alternate_contact_type(mut self, input: crate::model::AlternateContactType) -> Self {
            self.alternate_contact_type = Some(input);
            self
        }
        /// <p>Specifies which of the alternate contacts to delete. </p>
        pub fn set_alternate_contact_type(
            mut self,
            input: std::option::Option<crate::model::AlternateContactType>,
        ) -> Self {
            self.alternate_contact_type = input;
            self
        }
        /// <p>Specifies the 12 digit account ID number of the Amazon Web Services account that
        /// you want to access or modify with this operation.</p>
        /// <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the
        /// identity used to call the operation.</p>
        /// <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account</a> or a delegated administrator account, and
        /// the specified account ID must be a member account in the same organization. The
        /// organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
        /// enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the
        /// Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account
        /// assigned.</p>
        /// <note>
        /// <p>The management account can't specify its own <code>AccountId</code>; it must call
        /// the operation in standalone context by not including the <code>AccountId</code>
        /// parameter.</p>
        /// </note>
        /// <p>To call this operation on an account that is not a member of an organization, then
        /// don't specify this parameter, and call the operation using an identity belonging to
        /// the account whose contacts you wish to retrieve or modify.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>Specifies the 12 digit account ID number of the Amazon Web Services account that
        /// you want to access or modify with this operation.</p>
        /// <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the
        /// identity used to call the operation.</p>
        /// <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account</a> or a delegated administrator account, and
        /// the specified account ID must be a member account in the same organization. The
        /// organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
        /// enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the
        /// Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account
        /// assigned.</p>
        /// <note>
        /// <p>The management account can't specify its own <code>AccountId</code>; it must call
        /// the operation in standalone context by not including the <code>AccountId</code>
        /// parameter.</p>
        /// </note>
        /// <p>To call this operation on an account that is not a member of an organization, then
        /// don't specify this parameter, and call the operation using an identity belonging to
        /// the account whose contacts you wish to retrieve or modify.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAlternateContactInput`](crate::input::DeleteAlternateContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAlternateContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAlternateContactInput {
                alternate_contact_type: self.alternate_contact_type,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAlternateContactInputOperationOutputAlias = crate::operation::DeleteAlternateContact;
#[doc(hidden)]
pub type DeleteAlternateContactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAlternateContactInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAlternateContact`](crate::operation::DeleteAlternateContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAlternateContact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAlternateContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deleteAlternateContact").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAlternateContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAlternateContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_alternate_contact(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAlternateContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAlternateContact",
            "account",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAlternateContactInput`](crate::input::DeleteAlternateContactInput)
    pub fn builder() -> crate::input::delete_alternate_contact_input::Builder {
        crate::input::delete_alternate_contact_input::Builder::default()
    }
}

/// See [`GetAlternateContactInput`](crate::input::GetAlternateContactInput)
pub mod get_alternate_contact_input {
    /// A builder for [`GetAlternateContactInput`](crate::input::GetAlternateContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alternate_contact_type: std::option::Option<crate::model::AlternateContactType>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies which alternate contact you want to retrieve.</p>
        pub fn alternate_contact_type(mut self, input: crate::model::AlternateContactType) -> Self {
            self.alternate_contact_type = Some(input);
            self
        }
        /// <p>Specifies which alternate contact you want to retrieve.</p>
        pub fn set_alternate_contact_type(
            mut self,
            input: std::option::Option<crate::model::AlternateContactType>,
        ) -> Self {
            self.alternate_contact_type = input;
            self
        }
        /// <p>Specifies the 12 digit account ID number of the Amazon Web Services account that
        /// you want to access or modify with this operation.</p>
        /// <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the
        /// identity used to call the operation.</p>
        /// <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account</a> or a delegated administrator account, and
        /// the specified account ID must be a member account in the same organization. The
        /// organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
        /// enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the
        /// Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account
        /// assigned.</p>
        /// <note>
        /// <p>The management account can't specify its own <code>AccountId</code>; it must call
        /// the operation in standalone context by not including the <code>AccountId</code>
        /// parameter.</p>
        /// </note>
        /// <p>To call this operation on an account that is not a member of an organization, then
        /// don't specify this parameter, and call the operation using an identity belonging to
        /// the account whose contacts you wish to retrieve or modify.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>Specifies the 12 digit account ID number of the Amazon Web Services account that
        /// you want to access or modify with this operation.</p>
        /// <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the
        /// identity used to call the operation.</p>
        /// <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account</a> or a delegated administrator account, and
        /// the specified account ID must be a member account in the same organization. The
        /// organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
        /// enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the
        /// Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account
        /// assigned.</p>
        /// <note>
        /// <p>The management account can't specify its own <code>AccountId</code>; it must call
        /// the operation in standalone context by not including the <code>AccountId</code>
        /// parameter.</p>
        /// </note>
        /// <p>To call this operation on an account that is not a member of an organization, then
        /// don't specify this parameter, and call the operation using an identity belonging to
        /// the account whose contacts you wish to retrieve or modify.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAlternateContactInput`](crate::input::GetAlternateContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAlternateContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAlternateContactInput {
                alternate_contact_type: self.alternate_contact_type,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAlternateContactInputOperationOutputAlias = crate::operation::GetAlternateContact;
#[doc(hidden)]
pub type GetAlternateContactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAlternateContactInput {
    /// Consumes the builder and constructs an Operation<[`GetAlternateContact`](crate::operation::GetAlternateContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAlternateContact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAlternateContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getAlternateContact").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAlternateContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAlternateContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_alternate_contact(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAlternateContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAlternateContact",
            "account",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAlternateContactInput`](crate::input::GetAlternateContactInput)
    pub fn builder() -> crate::input::get_alternate_contact_input::Builder {
        crate::input::get_alternate_contact_input::Builder::default()
    }
}

/// See [`PutAlternateContactInput`](crate::input::PutAlternateContactInput)
pub mod put_alternate_contact_input {
    /// A builder for [`PutAlternateContactInput`](crate::input::PutAlternateContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) alternate_contact_type: std::option::Option<crate::model::AlternateContactType>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies a name for the alternate contact.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies a name for the alternate contact.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies a title for the alternate contact.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>Specifies a title for the alternate contact.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>Specifies an email address for the alternate contact. </p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>Specifies an email address for the alternate contact. </p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>Specifies a phone number for the alternate contact.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>Specifies a phone number for the alternate contact.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>Specifies which alternate contact you want to create or update.</p>
        pub fn alternate_contact_type(mut self, input: crate::model::AlternateContactType) -> Self {
            self.alternate_contact_type = Some(input);
            self
        }
        /// <p>Specifies which alternate contact you want to create or update.</p>
        pub fn set_alternate_contact_type(
            mut self,
            input: std::option::Option<crate::model::AlternateContactType>,
        ) -> Self {
            self.alternate_contact_type = input;
            self
        }
        /// <p>Specifies the 12 digit account ID number of the Amazon Web Services account that
        /// you want to access or modify with this operation.</p>
        /// <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the
        /// identity used to call the operation.</p>
        /// <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account</a> or a delegated administrator account, and
        /// the specified account ID must be a member account in the same organization. The
        /// organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
        /// enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the
        /// Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account
        /// assigned.</p>
        /// <note>
        /// <p>The management account can't specify its own <code>AccountId</code>; it must call
        /// the operation in standalone context by not including the <code>AccountId</code>
        /// parameter.</p>
        /// </note>
        /// <p>To call this operation on an account that is not a member of an organization, then
        /// don't specify this parameter, and call the operation using an identity belonging to
        /// the account whose contacts you wish to retrieve or modify.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>Specifies the 12 digit account ID number of the Amazon Web Services account that
        /// you want to access or modify with this operation.</p>
        /// <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the
        /// identity used to call the operation.</p>
        /// <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account</a> or a delegated administrator account, and
        /// the specified account ID must be a member account in the same organization. The
        /// organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
        /// enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the
        /// Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account
        /// assigned.</p>
        /// <note>
        /// <p>The management account can't specify its own <code>AccountId</code>; it must call
        /// the operation in standalone context by not including the <code>AccountId</code>
        /// parameter.</p>
        /// </note>
        /// <p>To call this operation on an account that is not a member of an organization, then
        /// don't specify this parameter, and call the operation using an identity belonging to
        /// the account whose contacts you wish to retrieve or modify.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAlternateContactInput`](crate::input::PutAlternateContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAlternateContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAlternateContactInput {
                name: self.name,
                title: self.title,
                email_address: self.email_address,
                phone_number: self.phone_number,
                alternate_contact_type: self.alternate_contact_type,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAlternateContactInputOperationOutputAlias = crate::operation::PutAlternateContact;
#[doc(hidden)]
pub type PutAlternateContactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutAlternateContactInput {
    /// Consumes the builder and constructs an Operation<[`PutAlternateContact`](crate::operation::PutAlternateContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAlternateContact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAlternateContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/putAlternateContact").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAlternateContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAlternateContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_alternate_contact(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAlternateContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAlternateContact",
            "account",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAlternateContactInput`](crate::input::PutAlternateContactInput)
    pub fn builder() -> crate::input::put_alternate_contact_input::Builder {
        crate::input::put_alternate_contact_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAlternateContactInput {
    /// <p>Specifies a name for the alternate contact.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies a title for the alternate contact.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>Specifies an email address for the alternate contact. </p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>Specifies a phone number for the alternate contact.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>Specifies which alternate contact you want to create or update.</p>
    pub alternate_contact_type: std::option::Option<crate::model::AlternateContactType>,
    /// <p>Specifies the 12 digit account ID number of the Amazon Web Services account that
    /// you want to access or modify with this operation.</p>
    /// <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the
    /// identity used to call the operation.</p>
    /// <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account</a> or a delegated administrator account, and
    /// the specified account ID must be a member account in the same organization. The
    /// organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
    /// enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the
    /// Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account
    /// assigned.</p>
    /// <note>
    /// <p>The management account can't specify its own <code>AccountId</code>; it must call
    /// the operation in standalone context by not including the <code>AccountId</code>
    /// parameter.</p>
    /// </note>
    /// <p>To call this operation on an account that is not a member of an organization, then
    /// don't specify this parameter, and call the operation using an identity belonging to
    /// the account whose contacts you wish to retrieve or modify.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl PutAlternateContactInput {
    /// <p>Specifies a name for the alternate contact.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies a title for the alternate contact.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>Specifies an email address for the alternate contact. </p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>Specifies a phone number for the alternate contact.</p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>Specifies which alternate contact you want to create or update.</p>
    pub fn alternate_contact_type(
        &self,
    ) -> std::option::Option<&crate::model::AlternateContactType> {
        self.alternate_contact_type.as_ref()
    }
    /// <p>Specifies the 12 digit account ID number of the Amazon Web Services account that
    /// you want to access or modify with this operation.</p>
    /// <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the
    /// identity used to call the operation.</p>
    /// <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account</a> or a delegated administrator account, and
    /// the specified account ID must be a member account in the same organization. The
    /// organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
    /// enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the
    /// Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account
    /// assigned.</p>
    /// <note>
    /// <p>The management account can't specify its own <code>AccountId</code>; it must call
    /// the operation in standalone context by not including the <code>AccountId</code>
    /// parameter.</p>
    /// </note>
    /// <p>To call this operation on an account that is not a member of an organization, then
    /// don't specify this parameter, and call the operation using an identity belonging to
    /// the account whose contacts you wish to retrieve or modify.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for PutAlternateContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAlternateContactInput");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("title", &"*** Sensitive Data Redacted ***");
        formatter.field("email_address", &"*** Sensitive Data Redacted ***");
        formatter.field("phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("alternate_contact_type", &self.alternate_contact_type);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAlternateContactInput {
    /// <p>Specifies which of the alternate contacts to delete. </p>
    pub alternate_contact_type: std::option::Option<crate::model::AlternateContactType>,
    /// <p>Specifies the 12 digit account ID number of the Amazon Web Services account that
    /// you want to access or modify with this operation.</p>
    /// <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the
    /// identity used to call the operation.</p>
    /// <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account</a> or a delegated administrator account, and
    /// the specified account ID must be a member account in the same organization. The
    /// organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
    /// enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the
    /// Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account
    /// assigned.</p>
    /// <note>
    /// <p>The management account can't specify its own <code>AccountId</code>; it must call
    /// the operation in standalone context by not including the <code>AccountId</code>
    /// parameter.</p>
    /// </note>
    /// <p>To call this operation on an account that is not a member of an organization, then
    /// don't specify this parameter, and call the operation using an identity belonging to
    /// the account whose contacts you wish to retrieve or modify.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl DeleteAlternateContactInput {
    /// <p>Specifies which of the alternate contacts to delete. </p>
    pub fn alternate_contact_type(
        &self,
    ) -> std::option::Option<&crate::model::AlternateContactType> {
        self.alternate_contact_type.as_ref()
    }
    /// <p>Specifies the 12 digit account ID number of the Amazon Web Services account that
    /// you want to access or modify with this operation.</p>
    /// <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the
    /// identity used to call the operation.</p>
    /// <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account</a> or a delegated administrator account, and
    /// the specified account ID must be a member account in the same organization. The
    /// organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
    /// enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the
    /// Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account
    /// assigned.</p>
    /// <note>
    /// <p>The management account can't specify its own <code>AccountId</code>; it must call
    /// the operation in standalone context by not including the <code>AccountId</code>
    /// parameter.</p>
    /// </note>
    /// <p>To call this operation on an account that is not a member of an organization, then
    /// don't specify this parameter, and call the operation using an identity belonging to
    /// the account whose contacts you wish to retrieve or modify.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAlternateContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAlternateContactInput");
        formatter.field("alternate_contact_type", &self.alternate_contact_type);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAlternateContactInput {
    /// <p>Specifies which alternate contact you want to retrieve.</p>
    pub alternate_contact_type: std::option::Option<crate::model::AlternateContactType>,
    /// <p>Specifies the 12 digit account ID number of the Amazon Web Services account that
    /// you want to access or modify with this operation.</p>
    /// <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the
    /// identity used to call the operation.</p>
    /// <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account</a> or a delegated administrator account, and
    /// the specified account ID must be a member account in the same organization. The
    /// organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
    /// enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the
    /// Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account
    /// assigned.</p>
    /// <note>
    /// <p>The management account can't specify its own <code>AccountId</code>; it must call
    /// the operation in standalone context by not including the <code>AccountId</code>
    /// parameter.</p>
    /// </note>
    /// <p>To call this operation on an account that is not a member of an organization, then
    /// don't specify this parameter, and call the operation using an identity belonging to
    /// the account whose contacts you wish to retrieve or modify.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl GetAlternateContactInput {
    /// <p>Specifies which alternate contact you want to retrieve.</p>
    pub fn alternate_contact_type(
        &self,
    ) -> std::option::Option<&crate::model::AlternateContactType> {
        self.alternate_contact_type.as_ref()
    }
    /// <p>Specifies the 12 digit account ID number of the Amazon Web Services account that
    /// you want to access or modify with this operation.</p>
    /// <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the
    /// identity used to call the operation.</p>
    /// <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization's management account</a> or a delegated administrator account, and
    /// the specified account ID must be a member account in the same organization. The
    /// organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features
    /// enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the
    /// Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account
    /// assigned.</p>
    /// <note>
    /// <p>The management account can't specify its own <code>AccountId</code>; it must call
    /// the operation in standalone context by not including the <code>AccountId</code>
    /// parameter.</p>
    /// </note>
    /// <p>To call this operation on an account that is not a member of an organization, then
    /// don't specify this parameter, and call the operation using an identity belonging to
    /// the account whose contacts you wish to retrieve or modify.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for GetAlternateContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAlternateContactInput");
        formatter.field("alternate_contact_type", &self.alternate_contact_type);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}
