// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AlternateContactType {
    #[allow(missing_docs)] // documentation missing in model
    Billing,
    #[allow(missing_docs)] // documentation missing in model
    Operations,
    #[allow(missing_docs)] // documentation missing in model
    Security,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AlternateContactType {
    fn from(s: &str) -> Self {
        match s {
            "BILLING" => AlternateContactType::Billing,
            "OPERATIONS" => AlternateContactType::Operations,
            "SECURITY" => AlternateContactType::Security,
            other => AlternateContactType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AlternateContactType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AlternateContactType::from(s))
    }
}
impl AlternateContactType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AlternateContactType::Billing => "BILLING",
            AlternateContactType::Operations => "OPERATIONS",
            AlternateContactType::Security => "SECURITY",
            AlternateContactType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BILLING", "OPERATIONS", "SECURITY"]
    }
}
impl AsRef<str> for AlternateContactType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that contains the details of an alternate contact associated with an Amazon Web Services
/// account</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlternateContact {
    /// <p>The name associated with this alternate contact.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The title associated with this alternate contact.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The email address associated with this alternate contact.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The phone number associated with this alternate contact.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The type of alternate contact.</p>
    pub alternate_contact_type: std::option::Option<crate::model::AlternateContactType>,
}
impl std::fmt::Debug for AlternateContact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlternateContact");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("title", &"*** Sensitive Data Redacted ***");
        formatter.field("email_address", &"*** Sensitive Data Redacted ***");
        formatter.field("phone_number", &"*** Sensitive Data Redacted ***");
        formatter.field("alternate_contact_type", &self.alternate_contact_type);
        formatter.finish()
    }
}
/// See [`AlternateContact`](crate::model::AlternateContact)
pub mod alternate_contact {
    /// A builder for [`AlternateContact`](crate::model::AlternateContact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) alternate_contact_type: std::option::Option<crate::model::AlternateContactType>,
    }
    impl Builder {
        /// <p>The name associated with this alternate contact.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name associated with this alternate contact.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The title associated with this alternate contact.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title associated with this alternate contact.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The email address associated with this alternate contact.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address associated with this alternate contact.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The phone number associated with this alternate contact.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number associated with this alternate contact.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The type of alternate contact.</p>
        pub fn alternate_contact_type(mut self, input: crate::model::AlternateContactType) -> Self {
            self.alternate_contact_type = Some(input);
            self
        }
        /// <p>The type of alternate contact.</p>
        pub fn set_alternate_contact_type(
            mut self,
            input: std::option::Option<crate::model::AlternateContactType>,
        ) -> Self {
            self.alternate_contact_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AlternateContact`](crate::model::AlternateContact)
        pub fn build(self) -> crate::model::AlternateContact {
            crate::model::AlternateContact {
                name: self.name,
                title: self.title,
                email_address: self.email_address,
                phone_number: self.phone_number,
                alternate_contact_type: self.alternate_contact_type,
            }
        }
    }
}
impl AlternateContact {
    /// Creates a new builder-style object to manufacture [`AlternateContact`](crate::model::AlternateContact)
    pub fn builder() -> crate::model::alternate_contact::Builder {
        crate::model::alternate_contact::Builder::default()
    }
}
