// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Access Analyzer
///
/// Client for invoking operations on Access Analyzer. Each operation on Access Analyzer is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_accessanalyzer::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_accessanalyzer::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_accessanalyzer::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`ApplyArchiveRule`](crate::client::fluent_builders::ApplyArchiveRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_arn(impl Into<String>)`](crate::client::fluent_builders::ApplyArchiveRule::analyzer_arn) / [`set_analyzer_arn(Option<String>)`](crate::client::fluent_builders::ApplyArchiveRule::set_analyzer_arn): <p>The Amazon resource name (ARN) of the analyzer.</p>
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::ApplyArchiveRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::ApplyArchiveRule::set_rule_name): <p>The name of the rule to apply.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::ApplyArchiveRule::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::ApplyArchiveRule::set_client_token): <p>A client token.</p>
    /// - On success, responds with [`ApplyArchiveRuleOutput`](crate::output::ApplyArchiveRuleOutput)

    /// - On failure, responds with [`SdkError<ApplyArchiveRuleError>`](crate::error::ApplyArchiveRuleError)
    pub fn apply_archive_rule(&self) -> fluent_builders::ApplyArchiveRule {
        fluent_builders::ApplyArchiveRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelPolicyGeneration`](crate::client::fluent_builders::CancelPolicyGeneration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::CancelPolicyGeneration::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::CancelPolicyGeneration::set_job_id): <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
    /// - On success, responds with [`CancelPolicyGenerationOutput`](crate::output::CancelPolicyGenerationOutput)

    /// - On failure, responds with [`SdkError<CancelPolicyGenerationError>`](crate::error::CancelPolicyGenerationError)
    pub fn cancel_policy_generation(&self) -> fluent_builders::CancelPolicyGeneration {
        fluent_builders::CancelPolicyGeneration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAccessPreview`](crate::client::fluent_builders::CreateAccessPreview) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAccessPreview::analyzer_arn) / [`set_analyzer_arn(Option<String>)`](crate::client::fluent_builders::CreateAccessPreview::set_analyzer_arn): <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the account analyzer</a> used to generate the access preview. You can only create an access preview for analyzers with an <code>Account</code> type and <code>Active</code> status.</p>
    ///   - [`configurations(HashMap<String, Configuration>)`](crate::client::fluent_builders::CreateAccessPreview::configurations) / [`set_configurations(Option<HashMap<String, Configuration>>)`](crate::client::fluent_builders::CreateAccessPreview::set_configurations): <p>Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateAccessPreview::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateAccessPreview::set_client_token): <p>A client token.</p>
    /// - On success, responds with [`CreateAccessPreviewOutput`](crate::output::CreateAccessPreviewOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateAccessPreviewOutput::id): <p>The unique ID for the access preview.</p>
    /// - On failure, responds with [`SdkError<CreateAccessPreviewError>`](crate::error::CreateAccessPreviewError)
    pub fn create_access_preview(&self) -> fluent_builders::CreateAccessPreview {
        fluent_builders::CreateAccessPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAnalyzer`](crate::client::fluent_builders::CreateAnalyzer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_name(impl Into<String>)`](crate::client::fluent_builders::CreateAnalyzer::analyzer_name) / [`set_analyzer_name(Option<String>)`](crate::client::fluent_builders::CreateAnalyzer::set_analyzer_name): <p>The name of the analyzer to create.</p>
    ///   - [`r#type(Type)`](crate::client::fluent_builders::CreateAnalyzer::type) / [`set_type(Option<Type>)`](crate::client::fluent_builders::CreateAnalyzer::set_type): <p>The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.</p>
    ///   - [`archive_rules(Vec<InlineArchiveRule>)`](crate::client::fluent_builders::CreateAnalyzer::archive_rules) / [`set_archive_rules(Option<Vec<InlineArchiveRule>>)`](crate::client::fluent_builders::CreateAnalyzer::set_archive_rules): <p>Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAnalyzer::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAnalyzer::set_tags): <p>The tags to apply to the analyzer.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateAnalyzer::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateAnalyzer::set_client_token): <p>A client token.</p>
    /// - On success, responds with [`CreateAnalyzerOutput`](crate::output::CreateAnalyzerOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateAnalyzerOutput::arn): <p>The ARN of the analyzer that was created by the request.</p>
    /// - On failure, responds with [`SdkError<CreateAnalyzerError>`](crate::error::CreateAnalyzerError)
    pub fn create_analyzer(&self) -> fluent_builders::CreateAnalyzer {
        fluent_builders::CreateAnalyzer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateArchiveRule`](crate::client::fluent_builders::CreateArchiveRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_name(impl Into<String>)`](crate::client::fluent_builders::CreateArchiveRule::analyzer_name) / [`set_analyzer_name(Option<String>)`](crate::client::fluent_builders::CreateArchiveRule::set_analyzer_name): <p>The name of the created analyzer.</p>
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::CreateArchiveRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::CreateArchiveRule::set_rule_name): <p>The name of the rule to create.</p>
    ///   - [`filter(HashMap<String, Criterion>)`](crate::client::fluent_builders::CreateArchiveRule::filter) / [`set_filter(Option<HashMap<String, Criterion>>)`](crate::client::fluent_builders::CreateArchiveRule::set_filter): <p>The criteria for the rule.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateArchiveRule::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateArchiveRule::set_client_token): <p>A client token.</p>
    /// - On success, responds with [`CreateArchiveRuleOutput`](crate::output::CreateArchiveRuleOutput)

    /// - On failure, responds with [`SdkError<CreateArchiveRuleError>`](crate::error::CreateArchiveRuleError)
    pub fn create_archive_rule(&self) -> fluent_builders::CreateArchiveRule {
        fluent_builders::CreateArchiveRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAnalyzer`](crate::client::fluent_builders::DeleteAnalyzer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_name(impl Into<String>)`](crate::client::fluent_builders::DeleteAnalyzer::analyzer_name) / [`set_analyzer_name(Option<String>)`](crate::client::fluent_builders::DeleteAnalyzer::set_analyzer_name): <p>The name of the analyzer to delete.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteAnalyzer::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteAnalyzer::set_client_token): <p>A client token.</p>
    /// - On success, responds with [`DeleteAnalyzerOutput`](crate::output::DeleteAnalyzerOutput)

    /// - On failure, responds with [`SdkError<DeleteAnalyzerError>`](crate::error::DeleteAnalyzerError)
    pub fn delete_analyzer(&self) -> fluent_builders::DeleteAnalyzer {
        fluent_builders::DeleteAnalyzer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteArchiveRule`](crate::client::fluent_builders::DeleteArchiveRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_name(impl Into<String>)`](crate::client::fluent_builders::DeleteArchiveRule::analyzer_name) / [`set_analyzer_name(Option<String>)`](crate::client::fluent_builders::DeleteArchiveRule::set_analyzer_name): <p>The name of the analyzer that associated with the archive rule to delete.</p>
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::DeleteArchiveRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::DeleteArchiveRule::set_rule_name): <p>The name of the rule to delete.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteArchiveRule::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteArchiveRule::set_client_token): <p>A client token.</p>
    /// - On success, responds with [`DeleteArchiveRuleOutput`](crate::output::DeleteArchiveRuleOutput)

    /// - On failure, responds with [`SdkError<DeleteArchiveRuleError>`](crate::error::DeleteArchiveRuleError)
    pub fn delete_archive_rule(&self) -> fluent_builders::DeleteArchiveRule {
        fluent_builders::DeleteArchiveRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccessPreview`](crate::client::fluent_builders::GetAccessPreview) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_preview_id(impl Into<String>)`](crate::client::fluent_builders::GetAccessPreview::access_preview_id) / [`set_access_preview_id(Option<String>)`](crate::client::fluent_builders::GetAccessPreview::set_access_preview_id): <p>The unique ID for the access preview.</p>
    ///   - [`analyzer_arn(impl Into<String>)`](crate::client::fluent_builders::GetAccessPreview::analyzer_arn) / [`set_analyzer_arn(Option<String>)`](crate::client::fluent_builders::GetAccessPreview::set_analyzer_arn): <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
    /// - On success, responds with [`GetAccessPreviewOutput`](crate::output::GetAccessPreviewOutput) with field(s):
    ///   - [`access_preview(Option<AccessPreview>)`](crate::output::GetAccessPreviewOutput::access_preview): <p>An object that contains information about the access preview.</p>
    /// - On failure, responds with [`SdkError<GetAccessPreviewError>`](crate::error::GetAccessPreviewError)
    pub fn get_access_preview(&self) -> fluent_builders::GetAccessPreview {
        fluent_builders::GetAccessPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAnalyzedResource`](crate::client::fluent_builders::GetAnalyzedResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_arn(impl Into<String>)`](crate::client::fluent_builders::GetAnalyzedResource::analyzer_arn) / [`set_analyzer_arn(Option<String>)`](crate::client::fluent_builders::GetAnalyzedResource::set_analyzer_arn): <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve information from.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetAnalyzedResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetAnalyzedResource::set_resource_arn): <p>The ARN of the resource to retrieve information about.</p>
    /// - On success, responds with [`GetAnalyzedResourceOutput`](crate::output::GetAnalyzedResourceOutput) with field(s):
    ///   - [`resource(Option<AnalyzedResource>)`](crate::output::GetAnalyzedResourceOutput::resource): <p>An <code>AnalyzedResource</code> object that contains information that IAM Access Analyzer found when it analyzed the resource.</p>
    /// - On failure, responds with [`SdkError<GetAnalyzedResourceError>`](crate::error::GetAnalyzedResourceError)
    pub fn get_analyzed_resource(&self) -> fluent_builders::GetAnalyzedResource {
        fluent_builders::GetAnalyzedResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAnalyzer`](crate::client::fluent_builders::GetAnalyzer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_name(impl Into<String>)`](crate::client::fluent_builders::GetAnalyzer::analyzer_name) / [`set_analyzer_name(Option<String>)`](crate::client::fluent_builders::GetAnalyzer::set_analyzer_name): <p>The name of the analyzer retrieved.</p>
    /// - On success, responds with [`GetAnalyzerOutput`](crate::output::GetAnalyzerOutput) with field(s):
    ///   - [`analyzer(Option<AnalyzerSummary>)`](crate::output::GetAnalyzerOutput::analyzer): <p>An <code>AnalyzerSummary</code> object that contains information about the analyzer.</p>
    /// - On failure, responds with [`SdkError<GetAnalyzerError>`](crate::error::GetAnalyzerError)
    pub fn get_analyzer(&self) -> fluent_builders::GetAnalyzer {
        fluent_builders::GetAnalyzer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetArchiveRule`](crate::client::fluent_builders::GetArchiveRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_name(impl Into<String>)`](crate::client::fluent_builders::GetArchiveRule::analyzer_name) / [`set_analyzer_name(Option<String>)`](crate::client::fluent_builders::GetArchiveRule::set_analyzer_name): <p>The name of the analyzer to retrieve rules from.</p>
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::GetArchiveRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::GetArchiveRule::set_rule_name): <p>The name of the rule to retrieve.</p>
    /// - On success, responds with [`GetArchiveRuleOutput`](crate::output::GetArchiveRuleOutput) with field(s):
    ///   - [`archive_rule(Option<ArchiveRuleSummary>)`](crate::output::GetArchiveRuleOutput::archive_rule): <p>Contains information about an archive rule.</p>
    /// - On failure, responds with [`SdkError<GetArchiveRuleError>`](crate::error::GetArchiveRuleError)
    pub fn get_archive_rule(&self) -> fluent_builders::GetArchiveRule {
        fluent_builders::GetArchiveRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFinding`](crate::client::fluent_builders::GetFinding) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_arn(impl Into<String>)`](crate::client::fluent_builders::GetFinding::analyzer_arn) / [`set_analyzer_arn(Option<String>)`](crate::client::fluent_builders::GetFinding::set_analyzer_arn): <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the finding.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetFinding::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetFinding::set_id): <p>The ID of the finding to retrieve.</p>
    /// - On success, responds with [`GetFindingOutput`](crate::output::GetFindingOutput) with field(s):
    ///   - [`finding(Option<Finding>)`](crate::output::GetFindingOutput::finding): <p>A <code>finding</code> object that contains finding details.</p>
    /// - On failure, responds with [`SdkError<GetFindingError>`](crate::error::GetFindingError)
    pub fn get_finding(&self) -> fluent_builders::GetFinding {
        fluent_builders::GetFinding::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGeneratedPolicy`](crate::client::fluent_builders::GetGeneratedPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetGeneratedPolicy::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetGeneratedPolicy::set_job_id): <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
    ///   - [`include_resource_placeholders(bool)`](crate::client::fluent_builders::GetGeneratedPolicy::include_resource_placeholders) / [`set_include_resource_placeholders(Option<bool>)`](crate::client::fluent_builders::GetGeneratedPolicy::set_include_resource_placeholders): <p>The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies.</p>  <p>For example, in the resource section of a policy, you can receive a placeholder such as <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.</p>
    ///   - [`include_service_level_template(bool)`](crate::client::fluent_builders::GetGeneratedPolicy::include_service_level_template) / [`set_include_service_level_template(Option<bool>)`](crate::client::fluent_builders::GetGeneratedPolicy::set_include_service_level_template): <p>The level of detail that you want to generate. You can specify whether to generate service-level policies. </p>  <p>IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used recently to create this service-level template.</p>
    /// - On success, responds with [`GetGeneratedPolicyOutput`](crate::output::GetGeneratedPolicyOutput) with field(s):
    ///   - [`job_details(Option<JobDetails>)`](crate::output::GetGeneratedPolicyOutput::job_details): <p>A <code>GeneratedPolicyDetails</code> object that contains details about the generated policy.</p>
    ///   - [`generated_policy_result(Option<GeneratedPolicyResult>)`](crate::output::GetGeneratedPolicyOutput::generated_policy_result): <p>A <code>GeneratedPolicyResult</code> object that contains the generated policies and associated details.</p>
    /// - On failure, responds with [`SdkError<GetGeneratedPolicyError>`](crate::error::GetGeneratedPolicyError)
    pub fn get_generated_policy(&self) -> fluent_builders::GetGeneratedPolicy {
        fluent_builders::GetGeneratedPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccessPreviewFindings`](crate::client::fluent_builders::ListAccessPreviewFindings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccessPreviewFindings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_preview_id(impl Into<String>)`](crate::client::fluent_builders::ListAccessPreviewFindings::access_preview_id) / [`set_access_preview_id(Option<String>)`](crate::client::fluent_builders::ListAccessPreviewFindings::set_access_preview_id): <p>The unique ID for the access preview.</p>
    ///   - [`analyzer_arn(impl Into<String>)`](crate::client::fluent_builders::ListAccessPreviewFindings::analyzer_arn) / [`set_analyzer_arn(Option<String>)`](crate::client::fluent_builders::ListAccessPreviewFindings::set_analyzer_arn): <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access.</p>
    ///   - [`filter(HashMap<String, Criterion>)`](crate::client::fluent_builders::ListAccessPreviewFindings::filter) / [`set_filter(Option<HashMap<String, Criterion>>)`](crate::client::fluent_builders::ListAccessPreviewFindings::set_filter): <p>Criteria to filter the returned findings.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccessPreviewFindings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccessPreviewFindings::set_next_token): <p>A token used for pagination of results returned.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccessPreviewFindings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccessPreviewFindings::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`ListAccessPreviewFindingsOutput`](crate::output::ListAccessPreviewFindingsOutput) with field(s):
    ///   - [`findings(Option<Vec<AccessPreviewFinding>>)`](crate::output::ListAccessPreviewFindingsOutput::findings): <p>A list of access preview findings that match the specified filter criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccessPreviewFindingsOutput::next_token): <p>A token used for pagination of results returned.</p>
    /// - On failure, responds with [`SdkError<ListAccessPreviewFindingsError>`](crate::error::ListAccessPreviewFindingsError)
    pub fn list_access_preview_findings(&self) -> fluent_builders::ListAccessPreviewFindings {
        fluent_builders::ListAccessPreviewFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccessPreviews`](crate::client::fluent_builders::ListAccessPreviews) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccessPreviews::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_arn(impl Into<String>)`](crate::client::fluent_builders::ListAccessPreviews::analyzer_arn) / [`set_analyzer_arn(Option<String>)`](crate::client::fluent_builders::ListAccessPreviews::set_analyzer_arn): <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccessPreviews::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccessPreviews::set_next_token): <p>A token used for pagination of results returned.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccessPreviews::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccessPreviews::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`ListAccessPreviewsOutput`](crate::output::ListAccessPreviewsOutput) with field(s):
    ///   - [`access_previews(Option<Vec<AccessPreviewSummary>>)`](crate::output::ListAccessPreviewsOutput::access_previews): <p>A list of access previews retrieved for the analyzer.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccessPreviewsOutput::next_token): <p>A token used for pagination of results returned.</p>
    /// - On failure, responds with [`SdkError<ListAccessPreviewsError>`](crate::error::ListAccessPreviewsError)
    pub fn list_access_previews(&self) -> fluent_builders::ListAccessPreviews {
        fluent_builders::ListAccessPreviews::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAnalyzedResources`](crate::client::fluent_builders::ListAnalyzedResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAnalyzedResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_arn(impl Into<String>)`](crate::client::fluent_builders::ListAnalyzedResources::analyzer_arn) / [`set_analyzer_arn(Option<String>)`](crate::client::fluent_builders::ListAnalyzedResources::set_analyzer_arn): <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve a list of analyzed resources from.</p>
    ///   - [`resource_type(ResourceType)`](crate::client::fluent_builders::ListAnalyzedResources::resource_type) / [`set_resource_type(Option<ResourceType>)`](crate::client::fluent_builders::ListAnalyzedResources::set_resource_type): <p>The type of resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAnalyzedResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAnalyzedResources::set_next_token): <p>A token used for pagination of results returned.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAnalyzedResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAnalyzedResources::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`ListAnalyzedResourcesOutput`](crate::output::ListAnalyzedResourcesOutput) with field(s):
    ///   - [`analyzed_resources(Option<Vec<AnalyzedResourceSummary>>)`](crate::output::ListAnalyzedResourcesOutput::analyzed_resources): <p>A list of resources that were analyzed.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAnalyzedResourcesOutput::next_token): <p>A token used for pagination of results returned.</p>
    /// - On failure, responds with [`SdkError<ListAnalyzedResourcesError>`](crate::error::ListAnalyzedResourcesError)
    pub fn list_analyzed_resources(&self) -> fluent_builders::ListAnalyzedResources {
        fluent_builders::ListAnalyzedResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAnalyzers`](crate::client::fluent_builders::ListAnalyzers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAnalyzers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAnalyzers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAnalyzers::set_next_token): <p>A token used for pagination of results returned.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAnalyzers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAnalyzers::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`r#type(Type)`](crate::client::fluent_builders::ListAnalyzers::type) / [`set_type(Option<Type>)`](crate::client::fluent_builders::ListAnalyzers::set_type): <p>The type of analyzer.</p>
    /// - On success, responds with [`ListAnalyzersOutput`](crate::output::ListAnalyzersOutput) with field(s):
    ///   - [`analyzers(Option<Vec<AnalyzerSummary>>)`](crate::output::ListAnalyzersOutput::analyzers): <p>The analyzers retrieved.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAnalyzersOutput::next_token): <p>A token used for pagination of results returned.</p>
    /// - On failure, responds with [`SdkError<ListAnalyzersError>`](crate::error::ListAnalyzersError)
    pub fn list_analyzers(&self) -> fluent_builders::ListAnalyzers {
        fluent_builders::ListAnalyzers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListArchiveRules`](crate::client::fluent_builders::ListArchiveRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListArchiveRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_name(impl Into<String>)`](crate::client::fluent_builders::ListArchiveRules::analyzer_name) / [`set_analyzer_name(Option<String>)`](crate::client::fluent_builders::ListArchiveRules::set_analyzer_name): <p>The name of the analyzer to retrieve rules from.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListArchiveRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListArchiveRules::set_next_token): <p>A token used for pagination of results returned.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListArchiveRules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListArchiveRules::set_max_results): <p>The maximum number of results to return in the request.</p>
    /// - On success, responds with [`ListArchiveRulesOutput`](crate::output::ListArchiveRulesOutput) with field(s):
    ///   - [`archive_rules(Option<Vec<ArchiveRuleSummary>>)`](crate::output::ListArchiveRulesOutput::archive_rules): <p>A list of archive rules created for the specified analyzer.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListArchiveRulesOutput::next_token): <p>A token used for pagination of results returned.</p>
    /// - On failure, responds with [`SdkError<ListArchiveRulesError>`](crate::error::ListArchiveRulesError)
    pub fn list_archive_rules(&self) -> fluent_builders::ListArchiveRules {
        fluent_builders::ListArchiveRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFindings`](crate::client::fluent_builders::ListFindings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFindings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_arn(impl Into<String>)`](crate::client::fluent_builders::ListFindings::analyzer_arn) / [`set_analyzer_arn(Option<String>)`](crate::client::fluent_builders::ListFindings::set_analyzer_arn): <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve findings from.</p>
    ///   - [`filter(HashMap<String, Criterion>)`](crate::client::fluent_builders::ListFindings::filter) / [`set_filter(Option<HashMap<String, Criterion>>)`](crate::client::fluent_builders::ListFindings::set_filter): <p>A filter to match for the findings to return.</p>
    ///   - [`sort(SortCriteria)`](crate::client::fluent_builders::ListFindings::sort) / [`set_sort(Option<SortCriteria>)`](crate::client::fluent_builders::ListFindings::set_sort): <p>The sort order for the findings returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFindings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFindings::set_next_token): <p>A token used for pagination of results returned.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFindings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFindings::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`ListFindingsOutput`](crate::output::ListFindingsOutput) with field(s):
    ///   - [`findings(Option<Vec<FindingSummary>>)`](crate::output::ListFindingsOutput::findings): <p>A list of findings retrieved from the analyzer that match the filter criteria specified, if any.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFindingsOutput::next_token): <p>A token used for pagination of results returned.</p>
    /// - On failure, responds with [`SdkError<ListFindingsError>`](crate::error::ListFindingsError)
    pub fn list_findings(&self) -> fluent_builders::ListFindings {
        fluent_builders::ListFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPolicyGenerations`](crate::client::fluent_builders::ListPolicyGenerations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPolicyGenerations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`principal_arn(impl Into<String>)`](crate::client::fluent_builders::ListPolicyGenerations::principal_arn) / [`set_principal_arn(Option<String>)`](crate::client::fluent_builders::ListPolicyGenerations::set_principal_arn): <p>The ARN of the IAM entity (user or role) for which you are generating a policy. Use this with <code>ListGeneratedPolicies</code> to filter the results to only include results for a specific principal.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPolicyGenerations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPolicyGenerations::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPolicyGenerations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPolicyGenerations::set_next_token): <p>A token used for pagination of results returned.</p>
    /// - On success, responds with [`ListPolicyGenerationsOutput`](crate::output::ListPolicyGenerationsOutput) with field(s):
    ///   - [`policy_generations(Option<Vec<PolicyGeneration>>)`](crate::output::ListPolicyGenerationsOutput::policy_generations): <p>A <code>PolicyGeneration</code> object that contains details about the generated policy.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPolicyGenerationsOutput::next_token): <p>A token used for pagination of results returned.</p>
    /// - On failure, responds with [`SdkError<ListPolicyGenerationsError>`](crate::error::ListPolicyGenerationsError)
    pub fn list_policy_generations(&self) -> fluent_builders::ListPolicyGenerations {
        fluent_builders::ListPolicyGenerations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource to retrieve tags from.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags that are applied to the specified resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartPolicyGeneration`](crate::client::fluent_builders::StartPolicyGeneration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_generation_details(PolicyGenerationDetails)`](crate::client::fluent_builders::StartPolicyGeneration::policy_generation_details) / [`set_policy_generation_details(Option<PolicyGenerationDetails>)`](crate::client::fluent_builders::StartPolicyGeneration::set_policy_generation_details): <p>Contains the ARN of the IAM entity (user or role) for which you are generating a policy.</p>
    ///   - [`cloud_trail_details(CloudTrailDetails)`](crate::client::fluent_builders::StartPolicyGeneration::cloud_trail_details) / [`set_cloud_trail_details(Option<CloudTrailDetails>)`](crate::client::fluent_builders::StartPolicyGeneration::set_cloud_trail_details): <p>A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze to generate policies.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartPolicyGeneration::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartPolicyGeneration::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p>  <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>
    /// - On success, responds with [`StartPolicyGenerationOutput`](crate::output::StartPolicyGenerationOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartPolicyGenerationOutput::job_id): <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
    /// - On failure, responds with [`SdkError<StartPolicyGenerationError>`](crate::error::StartPolicyGenerationError)
    pub fn start_policy_generation(&self) -> fluent_builders::StartPolicyGeneration {
        fluent_builders::StartPolicyGeneration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartResourceScan`](crate::client::fluent_builders::StartResourceScan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_arn(impl Into<String>)`](crate::client::fluent_builders::StartResourceScan::analyzer_arn) / [`set_analyzer_arn(Option<String>)`](crate::client::fluent_builders::StartResourceScan::set_analyzer_arn): <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to use to scan the policies applied to the specified resource.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::StartResourceScan::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::StartResourceScan::set_resource_arn): <p>The ARN of the resource to scan.</p>
    /// - On success, responds with [`StartResourceScanOutput`](crate::output::StartResourceScanOutput)

    /// - On failure, responds with [`SdkError<StartResourceScanError>`](crate::error::StartResourceScanError)
    pub fn start_resource_scan(&self) -> fluent_builders::StartResourceScan {
        fluent_builders::StartResourceScan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the resource to add the tag to.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to add to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource to remove the tag from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The key for the tag to add.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateArchiveRule`](crate::client::fluent_builders::UpdateArchiveRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_name(impl Into<String>)`](crate::client::fluent_builders::UpdateArchiveRule::analyzer_name) / [`set_analyzer_name(Option<String>)`](crate::client::fluent_builders::UpdateArchiveRule::set_analyzer_name): <p>The name of the analyzer to update the archive rules for.</p>
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::UpdateArchiveRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::UpdateArchiveRule::set_rule_name): <p>The name of the rule to update.</p>
    ///   - [`filter(HashMap<String, Criterion>)`](crate::client::fluent_builders::UpdateArchiveRule::filter) / [`set_filter(Option<HashMap<String, Criterion>>)`](crate::client::fluent_builders::UpdateArchiveRule::set_filter): <p>A filter to match for the rules to update. Only rules that match the filter are updated.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateArchiveRule::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateArchiveRule::set_client_token): <p>A client token.</p>
    /// - On success, responds with [`UpdateArchiveRuleOutput`](crate::output::UpdateArchiveRuleOutput)

    /// - On failure, responds with [`SdkError<UpdateArchiveRuleError>`](crate::error::UpdateArchiveRuleError)
    pub fn update_archive_rule(&self) -> fluent_builders::UpdateArchiveRule {
        fluent_builders::UpdateArchiveRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFindings`](crate::client::fluent_builders::UpdateFindings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analyzer_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFindings::analyzer_arn) / [`set_analyzer_arn(Option<String>)`](crate::client::fluent_builders::UpdateFindings::set_analyzer_arn): <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the findings to update.</p>
    ///   - [`status(FindingStatusUpdate)`](crate::client::fluent_builders::UpdateFindings::status) / [`set_status(Option<FindingStatusUpdate>)`](crate::client::fluent_builders::UpdateFindings::set_status): <p>The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active finding.</p>
    ///   - [`ids(Vec<String>)`](crate::client::fluent_builders::UpdateFindings::ids) / [`set_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateFindings::set_ids): <p>The IDs of the findings to update.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFindings::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UpdateFindings::set_resource_arn): <p>The ARN of the resource identified in the finding.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateFindings::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateFindings::set_client_token): <p>A client token.</p>
    /// - On success, responds with [`UpdateFindingsOutput`](crate::output::UpdateFindingsOutput)

    /// - On failure, responds with [`SdkError<UpdateFindingsError>`](crate::error::UpdateFindingsError)
    pub fn update_findings(&self) -> fluent_builders::UpdateFindings {
        fluent_builders::UpdateFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ValidatePolicy`](crate::client::fluent_builders::ValidatePolicy) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ValidatePolicy::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`locale(Locale)`](crate::client::fluent_builders::ValidatePolicy::locale) / [`set_locale(Option<Locale>)`](crate::client::fluent_builders::ValidatePolicy::set_locale): <p>The locale to use for localizing the findings.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ValidatePolicy::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ValidatePolicy::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ValidatePolicy::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ValidatePolicy::set_next_token): <p>A token used for pagination of results returned.</p>
    ///   - [`policy_document(impl Into<String>)`](crate::client::fluent_builders::ValidatePolicy::policy_document) / [`set_policy_document(Option<String>)`](crate::client::fluent_builders::ValidatePolicy::set_policy_document): <p>The JSON policy document to use as the content for the policy.</p>
    ///   - [`policy_type(PolicyType)`](crate::client::fluent_builders::ValidatePolicy::policy_type) / [`set_policy_type(Option<PolicyType>)`](crate::client::fluent_builders::ValidatePolicy::set_policy_type): <p>The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups. They also include service-control policies (SCPs) that are attached to an Amazon Web Services organization, organizational unit (OU), or an account.</p>  <p>Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy. </p>
    ///   - [`validate_policy_resource_type(ValidatePolicyResourceType)`](crate::client::fluent_builders::ValidatePolicy::validate_policy_resource_type) / [`set_validate_policy_resource_type(Option<ValidatePolicyResourceType>)`](crate::client::fluent_builders::ValidatePolicy::set_validate_policy_resource_type): <p>The type of resource to attach to your resource policy. Specify a value for the policy validation resource type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a resource policy to attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the policy validation resource type.</p>  <p>For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value for the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all resource policies.</p>
    /// - On success, responds with [`ValidatePolicyOutput`](crate::output::ValidatePolicyOutput) with field(s):
    ///   - [`findings(Option<Vec<ValidatePolicyFinding>>)`](crate::output::ValidatePolicyOutput::findings): <p>The list of findings in a policy returned by IAM Access Analyzer based on its suite of policy checks.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ValidatePolicyOutput::next_token): <p>A token used for pagination of results returned.</p>
    /// - On failure, responds with [`SdkError<ValidatePolicyError>`](crate::error::ValidatePolicyError)
    pub fn validate_policy(&self) -> fluent_builders::ValidatePolicy {
        fluent_builders::ValidatePolicy::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ApplyArchiveRule`.
    ///
    /// <p>Retroactively applies the archive rule to existing findings that meet the archive rule criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ApplyArchiveRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::apply_archive_rule_input::Builder,
    }
    impl ApplyArchiveRule {
        /// Creates a new `ApplyArchiveRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplyArchiveRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplyArchiveRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon resource name (ARN) of the analyzer.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) of the analyzer.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>The name of the rule to apply.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rule to apply.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelPolicyGeneration`.
    ///
    /// <p>Cancels the requested policy generation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelPolicyGeneration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_policy_generation_input::Builder,
    }
    impl CancelPolicyGeneration {
        /// Creates a new `CancelPolicyGeneration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelPolicyGenerationOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelPolicyGenerationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccessPreview`.
    ///
    /// <p>Creates an access preview that allows you to preview IAM Access Analyzer findings for your resource before deploying resource permissions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAccessPreview {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_access_preview_input::Builder,
    }
    impl CreateAccessPreview {
        /// Creates a new `CreateAccessPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccessPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccessPreviewError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the account analyzer</a> used to generate the access preview. You can only create an access preview for analyzers with an <code>Account</code> type and <code>Active</code> status.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the account analyzer</a> used to generate the access preview. You can only create an access preview for analyzers with an <code>Account</code> type and <code>Active</code> status.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// Adds a key-value pair to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.</p>
        pub fn configurations(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Configuration,
        ) -> Self {
            self.inner = self.inner.configurations(k.into(), v);
            self
        }
        /// <p>Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Configuration>,
            >,
        ) -> Self {
            self.inner = self.inner.set_configurations(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAnalyzer`.
    ///
    /// <p>Creates an analyzer for your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAnalyzer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_analyzer_input::Builder,
    }
    impl CreateAnalyzer {
        /// Creates a new `CreateAnalyzer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAnalyzerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAnalyzerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer to create.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(input.into());
            self
        }
        /// <p>The name of the analyzer to create.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `archiveRules`.
        ///
        /// To override the contents of this collection use [`set_archive_rules`](Self::set_archive_rules).
        ///
        /// <p>Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.</p>
        pub fn archive_rules(mut self, input: crate::model::InlineArchiveRule) -> Self {
            self.inner = self.inner.archive_rules(input);
            self
        }
        /// <p>Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.</p>
        pub fn set_archive_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InlineArchiveRule>>,
        ) -> Self {
            self.inner = self.inner.set_archive_rules(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the analyzer.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to apply to the analyzer.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateArchiveRule`.
    ///
    /// <p>Creates an archive rule for the specified analyzer. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.</p>
    /// <p>To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateArchiveRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_archive_rule_input::Builder,
    }
    impl CreateArchiveRule {
        /// Creates a new `CreateArchiveRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateArchiveRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateArchiveRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the created analyzer.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(input.into());
            self
        }
        /// <p>The name of the created analyzer.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>The name of the rule to create.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rule to create.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>The criteria for the rule.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Criterion,
        ) -> Self {
            self.inner = self.inner.filter(k.into(), v);
            self
        }
        /// <p>The criteria for the rule.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAnalyzer`.
    ///
    /// <p>Deletes the specified analyzer. When you delete an analyzer, IAM Access Analyzer is disabled for the account or organization in the current or specific Region. All findings that were generated by the analyzer are deleted. You cannot undo this action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAnalyzer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_analyzer_input::Builder,
    }
    impl DeleteAnalyzer {
        /// Creates a new `DeleteAnalyzer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAnalyzerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAnalyzerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer to delete.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(input.into());
            self
        }
        /// <p>The name of the analyzer to delete.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteArchiveRule`.
    ///
    /// <p>Deletes the specified archive rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteArchiveRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_archive_rule_input::Builder,
    }
    impl DeleteArchiveRule {
        /// Creates a new `DeleteArchiveRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteArchiveRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteArchiveRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer that associated with the archive rule to delete.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(input.into());
            self
        }
        /// <p>The name of the analyzer that associated with the archive rule to delete.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>The name of the rule to delete.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rule to delete.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPreview`.
    ///
    /// <p>Retrieves information about an access preview for the specified analyzer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccessPreview {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_access_preview_input::Builder,
    }
    impl GetAccessPreview {
        /// Creates a new `GetAccessPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessPreviewError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn access_preview_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_preview_id(input.into());
            self
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn set_access_preview_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_preview_id(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAnalyzedResource`.
    ///
    /// <p>Retrieves information about a resource that was analyzed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAnalyzedResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_analyzed_resource_input::Builder,
    }
    impl GetAnalyzedResource {
        /// Creates a new `GetAnalyzedResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAnalyzedResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAnalyzedResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve information from.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve information from.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>The ARN of the resource to retrieve information about.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to retrieve information about.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAnalyzer`.
    ///
    /// <p>Retrieves information about the specified analyzer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAnalyzer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_analyzer_input::Builder,
    }
    impl GetAnalyzer {
        /// Creates a new `GetAnalyzer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAnalyzerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAnalyzerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer retrieved.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(input.into());
            self
        }
        /// <p>The name of the analyzer retrieved.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetArchiveRule`.
    ///
    /// <p>Retrieves information about an archive rule.</p>
    /// <p>To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetArchiveRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_archive_rule_input::Builder,
    }
    impl GetArchiveRule {
        /// Creates a new `GetArchiveRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetArchiveRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetArchiveRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer to retrieve rules from.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(input.into());
            self
        }
        /// <p>The name of the analyzer to retrieve rules from.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>The name of the rule to retrieve.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rule to retrieve.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFinding`.
    ///
    /// <p>Retrieves information about the specified finding.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFinding {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_finding_input::Builder,
    }
    impl GetFinding {
        /// Creates a new `GetFinding`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the finding.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the finding.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>The ID of the finding to retrieve.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the finding to retrieve.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGeneratedPolicy`.
    ///
    /// <p>Retrieves the policy that was generated using <code>StartPolicyGeneration</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGeneratedPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_generated_policy_input::Builder,
    }
    impl GetGeneratedPolicy {
        /// Creates a new `GetGeneratedPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGeneratedPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGeneratedPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies.</p>
        /// <p>For example, in the resource section of a policy, you can receive a placeholder such as <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.</p>
        pub fn include_resource_placeholders(mut self, input: bool) -> Self {
            self.inner = self.inner.include_resource_placeholders(input);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies.</p>
        /// <p>For example, in the resource section of a policy, you can receive a placeholder such as <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.</p>
        pub fn set_include_resource_placeholders(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_include_resource_placeholders(input);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether to generate service-level policies. </p>
        /// <p>IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used recently to create this service-level template.</p>
        pub fn include_service_level_template(mut self, input: bool) -> Self {
            self.inner = self.inner.include_service_level_template(input);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether to generate service-level policies. </p>
        /// <p>IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used recently to create this service-level template.</p>
        pub fn set_include_service_level_template(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_include_service_level_template(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessPreviewFindings`.
    ///
    /// <p>Retrieves a list of access preview findings generated by the specified access preview.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccessPreviewFindings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_access_preview_findings_input::Builder,
    }
    impl ListAccessPreviewFindings {
        /// Creates a new `ListAccessPreviewFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessPreviewFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessPreviewFindingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccessPreviewFindingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccessPreviewFindingsPaginator {
            crate::paginator::ListAccessPreviewFindingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn access_preview_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_preview_id(input.into());
            self
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn set_access_preview_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_preview_id(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>Criteria to filter the returned findings.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Criterion,
        ) -> Self {
            self.inner = self.inner.filter(k.into(), v);
            self
        }
        /// <p>Criteria to filter the returned findings.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessPreviews`.
    ///
    /// <p>Retrieves a list of access previews for the specified analyzer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccessPreviews {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_access_previews_input::Builder,
    }
    impl ListAccessPreviews {
        /// Creates a new `ListAccessPreviews`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessPreviewsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessPreviewsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccessPreviewsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccessPreviewsPaginator {
            crate::paginator::ListAccessPreviewsPaginator::new(self.handle, self.inner)
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnalyzedResources`.
    ///
    /// <p>Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAnalyzedResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_analyzed_resources_input::Builder,
    }
    impl ListAnalyzedResources {
        /// Creates a new `ListAnalyzedResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnalyzedResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnalyzedResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAnalyzedResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAnalyzedResourcesPaginator {
            crate::paginator::ListAnalyzedResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve a list of analyzed resources from.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve a list of analyzed resources from.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>The type of resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnalyzers`.
    ///
    /// <p>Retrieves a list of analyzers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAnalyzers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_analyzers_input::Builder,
    }
    impl ListAnalyzers {
        /// Creates a new `ListAnalyzers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnalyzersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnalyzersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAnalyzersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAnalyzersPaginator {
            crate::paginator::ListAnalyzersPaginator::new(self.handle, self.inner)
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The type of analyzer.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of analyzer.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListArchiveRules`.
    ///
    /// <p>Retrieves a list of archive rules created for the specified analyzer.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListArchiveRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_archive_rules_input::Builder,
    }
    impl ListArchiveRules {
        /// Creates a new `ListArchiveRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListArchiveRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListArchiveRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListArchiveRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListArchiveRulesPaginator {
            crate::paginator::ListArchiveRulesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the analyzer to retrieve rules from.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(input.into());
            self
        }
        /// <p>The name of the analyzer to retrieve rules from.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindings`.
    ///
    /// <p>Retrieves a list of findings generated by the specified analyzer.</p>
    /// <p>To learn about filter keys that you can use to retrieve a list of findings, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFindings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_findings_input::Builder,
    }
    impl ListFindings {
        /// Creates a new `ListFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFindingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFindingsPaginator {
            crate::paginator::ListFindingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve findings from.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve findings from.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>A filter to match for the findings to return.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Criterion,
        ) -> Self {
            self.inner = self.inner.filter(k.into(), v);
            self
        }
        /// <p>A filter to match for the findings to return.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The sort order for the findings returned.</p>
        pub fn sort(mut self, input: crate::model::SortCriteria) -> Self {
            self.inner = self.inner.sort(input);
            self
        }
        /// <p>The sort order for the findings returned.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::SortCriteria>) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicyGenerations`.
    ///
    /// <p>Lists all of the policy generations requested in the last seven days.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPolicyGenerations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_policy_generations_input::Builder,
    }
    impl ListPolicyGenerations {
        /// Creates a new `ListPolicyGenerations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPolicyGenerationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPolicyGenerationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPolicyGenerationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPolicyGenerationsPaginator {
            crate::paginator::ListPolicyGenerationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy. Use this with <code>ListGeneratedPolicies</code> to filter the results to only include results for a specific principal.</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy. Use this with <code>ListGeneratedPolicies</code> to filter the results to only include results for a specific principal.</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_principal_arn(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves a list of tags applied to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to retrieve tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to retrieve tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartPolicyGeneration`.
    ///
    /// <p>Starts the policy generation request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartPolicyGeneration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_policy_generation_input::Builder,
    }
    impl StartPolicyGeneration {
        /// Creates a new `StartPolicyGeneration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartPolicyGenerationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartPolicyGenerationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Contains the ARN of the IAM entity (user or role) for which you are generating a policy.</p>
        pub fn policy_generation_details(
            mut self,
            input: crate::model::PolicyGenerationDetails,
        ) -> Self {
            self.inner = self.inner.policy_generation_details(input);
            self
        }
        /// <p>Contains the ARN of the IAM entity (user or role) for which you are generating a policy.</p>
        pub fn set_policy_generation_details(
            mut self,
            input: std::option::Option<crate::model::PolicyGenerationDetails>,
        ) -> Self {
            self.inner = self.inner.set_policy_generation_details(input);
            self
        }
        /// <p>A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze to generate policies.</p>
        pub fn cloud_trail_details(mut self, input: crate::model::CloudTrailDetails) -> Self {
            self.inner = self.inner.cloud_trail_details(input);
            self
        }
        /// <p>A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze to generate policies.</p>
        pub fn set_cloud_trail_details(
            mut self,
            input: std::option::Option<crate::model::CloudTrailDetails>,
        ) -> Self {
            self.inner = self.inner.set_cloud_trail_details(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartResourceScan`.
    ///
    /// <p>Immediately starts a scan of the policies applied to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartResourceScan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_resource_scan_input::Builder,
    }
    impl StartResourceScan {
        /// Creates a new `StartResourceScan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartResourceScanOutput,
            aws_smithy_http::result::SdkError<crate::error::StartResourceScanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to use to scan the policies applied to the specified resource.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to use to scan the policies applied to the specified resource.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>The ARN of the resource to scan.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to scan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds a tag to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to add the tag to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to add the tag to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to remove the tag from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to remove the tag from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key for the tag to add.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The key for the tag to add.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateArchiveRule`.
    ///
    /// <p>Updates the criteria and values for the specified archive rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateArchiveRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_archive_rule_input::Builder,
    }
    impl UpdateArchiveRule {
        /// Creates a new `UpdateArchiveRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateArchiveRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateArchiveRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer to update the archive rules for.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(input.into());
            self
        }
        /// <p>The name of the analyzer to update the archive rules for.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>The name of the rule to update.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rule to update.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>A filter to match for the rules to update. Only rules that match the filter are updated.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Criterion,
        ) -> Self {
            self.inner = self.inner.filter(k.into(), v);
            self
        }
        /// <p>A filter to match for the rules to update. Only rules that match the filter are updated.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFindings`.
    ///
    /// <p>Updates the status for the specified findings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFindings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_findings_input::Builder,
    }
    impl UpdateFindings {
        /// Creates a new `UpdateFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFindingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the findings to update.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the findings to update.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active finding.</p>
        pub fn status(mut self, input: crate::model::FindingStatusUpdate) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active finding.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FindingStatusUpdate>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>The IDs of the findings to update.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(input.into());
            self
        }
        /// <p>The IDs of the findings to update.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
        /// <p>The ARN of the resource identified in the finding.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource identified in the finding.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ValidatePolicy`.
    ///
    /// <p>Requests the validation of a policy and returns a list of findings. The findings help you identify issues and provide actionable recommendations to resolve the issue and enable you to author functional policies that meet security best practices. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ValidatePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::validate_policy_input::Builder,
    }
    impl ValidatePolicy {
        /// Creates a new `ValidatePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ValidatePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::ValidatePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ValidatePolicyPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ValidatePolicyPaginator {
            crate::paginator::ValidatePolicyPaginator::new(self.handle, self.inner)
        }
        /// <p>The locale to use for localizing the findings.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(input);
            self
        }
        /// <p>The locale to use for localizing the findings.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The JSON policy document to use as the content for the policy.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p>The JSON policy document to use as the content for the policy.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// <p>The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups. They also include service-control policies (SCPs) that are attached to an Amazon Web Services organization, organizational unit (OU), or an account.</p>
        /// <p>Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy. </p>
        pub fn policy_type(mut self, input: crate::model::PolicyType) -> Self {
            self.inner = self.inner.policy_type(input);
            self
        }
        /// <p>The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups. They also include service-control policies (SCPs) that are attached to an Amazon Web Services organization, organizational unit (OU), or an account.</p>
        /// <p>Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy. </p>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.inner = self.inner.set_policy_type(input);
            self
        }
        /// <p>The type of resource to attach to your resource policy. Specify a value for the policy validation resource type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a resource policy to attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the policy validation resource type.</p>
        /// <p>For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value for the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all resource policies.</p>
        pub fn validate_policy_resource_type(
            mut self,
            input: crate::model::ValidatePolicyResourceType,
        ) -> Self {
            self.inner = self.inner.validate_policy_resource_type(input);
            self
        }
        /// <p>The type of resource to attach to your resource policy. Specify a value for the policy validation resource type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a resource policy to attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the policy validation resource type.</p>
        /// <p>For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value for the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all resource policies.</p>
        pub fn set_validate_policy_resource_type(
            mut self,
            input: std::option::Option<crate::model::ValidatePolicyResourceType>,
        ) -> Self {
            self.inner = self.inner.set_validate_policy_resource_type(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
