// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`ApplyArchiveRuleInput`](crate::input::ApplyArchiveRuleInput)
pub mod apply_archive_rule_input {
    /// A builder for [`ApplyArchiveRuleInput`](crate::input::ApplyArchiveRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon resource name (ARN) of the analyzer.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) of the analyzer.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// <p>The name of the rule to apply.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule to apply.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplyArchiveRuleInput`](crate::input::ApplyArchiveRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ApplyArchiveRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ApplyArchiveRuleInput {
                analyzer_arn: self.analyzer_arn,
                rule_name: self.rule_name,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ApplyArchiveRuleInputOperationOutputAlias = crate::operation::ApplyArchiveRule;
#[doc(hidden)]
pub type ApplyArchiveRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ApplyArchiveRuleInput {
    /// Consumes the builder and constructs an Operation<[`ApplyArchiveRule`](crate::operation::ApplyArchiveRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ApplyArchiveRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ApplyArchiveRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/archive-rule").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ApplyArchiveRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ApplyArchiveRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_apply_archive_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ApplyArchiveRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ApplyArchiveRule",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ApplyArchiveRuleInput`](crate::input::ApplyArchiveRuleInput)
    pub fn builder() -> crate::input::apply_archive_rule_input::Builder {
        crate::input::apply_archive_rule_input::Builder::default()
    }
}

/// See [`CancelPolicyGenerationInput`](crate::input::CancelPolicyGenerationInput)
pub mod cancel_policy_generation_input {
    /// A builder for [`CancelPolicyGenerationInput`](crate::input::CancelPolicyGenerationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelPolicyGenerationInput`](crate::input::CancelPolicyGenerationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelPolicyGenerationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelPolicyGenerationInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelPolicyGenerationInputOperationOutputAlias = crate::operation::CancelPolicyGeneration;
#[doc(hidden)]
pub type CancelPolicyGenerationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelPolicyGenerationInput {
    /// Consumes the builder and constructs an Operation<[`CancelPolicyGeneration`](crate::operation::CancelPolicyGeneration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelPolicyGeneration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelPolicyGenerationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.job_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_1, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/policy/generation/{jobId}", jobId = job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelPolicyGenerationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelPolicyGenerationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelPolicyGeneration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelPolicyGeneration",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelPolicyGenerationInput`](crate::input::CancelPolicyGenerationInput)
    pub fn builder() -> crate::input::cancel_policy_generation_input::Builder {
        crate::input::cancel_policy_generation_input::Builder::default()
    }
}

/// See [`CreateAccessPreviewInput`](crate::input::CreateAccessPreviewInput)
pub mod create_access_preview_input {
    /// A builder for [`CreateAccessPreviewInput`](crate::input::CreateAccessPreviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
        pub(crate) configurations: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Configuration>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the account analyzer</a> used to generate the access preview. You can only create an access preview for analyzers with an <code>Account</code> type and <code>Active</code> status.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the account analyzer</a> used to generate the access preview. You can only create an access preview for analyzers with an <code>Account</code> type and <code>Active</code> status.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// Adds a key-value pair to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.</p>
        pub fn configurations(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Configuration,
        ) -> Self {
            let mut hash_map = self.configurations.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.configurations = Some(hash_map);
            self
        }
        /// <p>Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Configuration>,
            >,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessPreviewInput`](crate::input::CreateAccessPreviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAccessPreviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAccessPreviewInput {
                analyzer_arn: self.analyzer_arn,
                configurations: self.configurations,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAccessPreviewInputOperationOutputAlias = crate::operation::CreateAccessPreview;
#[doc(hidden)]
pub type CreateAccessPreviewInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAccessPreviewInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccessPreview`](crate::operation::CreateAccessPreview)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccessPreview,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAccessPreviewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/access-preview").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAccessPreviewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAccessPreviewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_access_preview(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccessPreview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccessPreview",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAccessPreviewInput`](crate::input::CreateAccessPreviewInput)
    pub fn builder() -> crate::input::create_access_preview_input::Builder {
        crate::input::create_access_preview_input::Builder::default()
    }
}

/// See [`CreateAnalyzerInput`](crate::input::CreateAnalyzerInput)
pub mod create_analyzer_input {
    /// A builder for [`CreateAnalyzerInput`](crate::input::CreateAnalyzerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
        pub(crate) archive_rules:
            std::option::Option<std::vec::Vec<crate::model::InlineArchiveRule>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the analyzer to create.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_name = Some(input.into());
            self
        }
        /// <p>The name of the analyzer to create.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analyzer_name = input;
            self
        }
        /// <p>The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `archive_rules`.
        ///
        /// To override the contents of this collection use [`set_archive_rules`](Self::set_archive_rules).
        ///
        /// <p>Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.</p>
        pub fn archive_rules(mut self, input: crate::model::InlineArchiveRule) -> Self {
            let mut v = self.archive_rules.unwrap_or_default();
            v.push(input);
            self.archive_rules = Some(v);
            self
        }
        /// <p>Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.</p>
        pub fn set_archive_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InlineArchiveRule>>,
        ) -> Self {
            self.archive_rules = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the analyzer.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to apply to the analyzer.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAnalyzerInput`](crate::input::CreateAnalyzerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAnalyzerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAnalyzerInput {
                analyzer_name: self.analyzer_name,
                r#type: self.r#type,
                archive_rules: self.archive_rules,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAnalyzerInputOperationOutputAlias = crate::operation::CreateAnalyzer;
#[doc(hidden)]
pub type CreateAnalyzerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAnalyzerInput {
    /// Consumes the builder and constructs an Operation<[`CreateAnalyzer`](crate::operation::CreateAnalyzer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAnalyzer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAnalyzerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/analyzer").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAnalyzerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAnalyzerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_analyzer(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAnalyzer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAnalyzer",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAnalyzerInput`](crate::input::CreateAnalyzerInput)
    pub fn builder() -> crate::input::create_analyzer_input::Builder {
        crate::input::create_analyzer_input::Builder::default()
    }
}

/// See [`CreateArchiveRuleInput`](crate::input::CreateArchiveRuleInput)
pub mod create_archive_rule_input {
    /// A builder for [`CreateArchiveRuleInput`](crate::input::CreateArchiveRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_name: std::option::Option<std::string::String>,
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Criterion>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the created analyzer.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_name = Some(input.into());
            self
        }
        /// <p>The name of the created analyzer.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analyzer_name = input;
            self
        }
        /// <p>The name of the rule to create.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule to create.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>The criteria for the rule.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Criterion,
        ) -> Self {
            let mut hash_map = self.filter.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.filter = Some(hash_map);
            self
        }
        /// <p>The criteria for the rule.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateArchiveRuleInput`](crate::input::CreateArchiveRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateArchiveRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateArchiveRuleInput {
                analyzer_name: self.analyzer_name,
                rule_name: self.rule_name,
                filter: self.filter,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateArchiveRuleInputOperationOutputAlias = crate::operation::CreateArchiveRule;
#[doc(hidden)]
pub type CreateArchiveRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateArchiveRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateArchiveRule`](crate::operation::CreateArchiveRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateArchiveRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateArchiveRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.analyzer_name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analyzer_name",
                        details: "cannot be empty or unset",
                    })?;
            let analyzer_name = aws_smithy_http::label::fmt_string(input_2, false);
            if analyzer_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analyzer_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/analyzer/{analyzerName}/archive-rule",
                analyzerName = analyzer_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateArchiveRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateArchiveRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_archive_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateArchiveRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateArchiveRule",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateArchiveRuleInput`](crate::input::CreateArchiveRuleInput)
    pub fn builder() -> crate::input::create_archive_rule_input::Builder {
        crate::input::create_archive_rule_input::Builder::default()
    }
}

/// See [`DeleteAnalyzerInput`](crate::input::DeleteAnalyzerInput)
pub mod delete_analyzer_input {
    /// A builder for [`DeleteAnalyzerInput`](crate::input::DeleteAnalyzerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the analyzer to delete.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_name = Some(input.into());
            self
        }
        /// <p>The name of the analyzer to delete.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analyzer_name = input;
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAnalyzerInput`](crate::input::DeleteAnalyzerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAnalyzerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAnalyzerInput {
                analyzer_name: self.analyzer_name,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAnalyzerInputOperationOutputAlias = crate::operation::DeleteAnalyzer;
#[doc(hidden)]
pub type DeleteAnalyzerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAnalyzerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAnalyzer`](crate::operation::DeleteAnalyzer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAnalyzer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAnalyzerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.analyzer_name;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analyzer_name",
                        details: "cannot be empty or unset",
                    })?;
            let analyzer_name = aws_smithy_http::label::fmt_string(input_3, false);
            if analyzer_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analyzer_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/analyzer/{analyzerName}",
                analyzerName = analyzer_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteAnalyzerInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_4) = &_input.client_token {
                query.push_kv("clientToken", &aws_smithy_http::query::fmt_string(&inner_4));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAnalyzerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAnalyzerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAnalyzer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAnalyzer",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAnalyzerInput`](crate::input::DeleteAnalyzerInput)
    pub fn builder() -> crate::input::delete_analyzer_input::Builder {
        crate::input::delete_analyzer_input::Builder::default()
    }
}

/// See [`DeleteArchiveRuleInput`](crate::input::DeleteArchiveRuleInput)
pub mod delete_archive_rule_input {
    /// A builder for [`DeleteArchiveRuleInput`](crate::input::DeleteArchiveRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_name: std::option::Option<std::string::String>,
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the analyzer that associated with the archive rule to delete.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_name = Some(input.into());
            self
        }
        /// <p>The name of the analyzer that associated with the archive rule to delete.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analyzer_name = input;
            self
        }
        /// <p>The name of the rule to delete.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule to delete.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteArchiveRuleInput`](crate::input::DeleteArchiveRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteArchiveRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteArchiveRuleInput {
                analyzer_name: self.analyzer_name,
                rule_name: self.rule_name,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteArchiveRuleInputOperationOutputAlias = crate::operation::DeleteArchiveRule;
#[doc(hidden)]
pub type DeleteArchiveRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteArchiveRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteArchiveRule`](crate::operation::DeleteArchiveRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteArchiveRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteArchiveRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.analyzer_name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analyzer_name",
                        details: "cannot be empty or unset",
                    })?;
            let analyzer_name = aws_smithy_http::label::fmt_string(input_5, false);
            if analyzer_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analyzer_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_6 = &_input.rule_name;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    })?;
            let rule_name = aws_smithy_http::label::fmt_string(input_6, false);
            if rule_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rule_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/analyzer/{analyzerName}/archive-rule/{ruleName}",
                analyzerName = analyzer_name,
                ruleName = rule_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteArchiveRuleInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_7) = &_input.client_token {
                query.push_kv("clientToken", &aws_smithy_http::query::fmt_string(&inner_7));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteArchiveRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteArchiveRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteArchiveRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteArchiveRule",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteArchiveRuleInput`](crate::input::DeleteArchiveRuleInput)
    pub fn builder() -> crate::input::delete_archive_rule_input::Builder {
        crate::input::delete_archive_rule_input::Builder::default()
    }
}

/// See [`GetAccessPreviewInput`](crate::input::GetAccessPreviewInput)
pub mod get_access_preview_input {
    /// A builder for [`GetAccessPreviewInput`](crate::input::GetAccessPreviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_preview_id: std::option::Option<std::string::String>,
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID for the access preview.</p>
        pub fn access_preview_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_preview_id = Some(input.into());
            self
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn set_access_preview_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_preview_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPreviewInput`](crate::input::GetAccessPreviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccessPreviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccessPreviewInput {
                access_preview_id: self.access_preview_id,
                analyzer_arn: self.analyzer_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccessPreviewInputOperationOutputAlias = crate::operation::GetAccessPreview;
#[doc(hidden)]
pub type GetAccessPreviewInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAccessPreviewInput {
    /// Consumes the builder and constructs an Operation<[`GetAccessPreview`](crate::operation::GetAccessPreview)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccessPreview,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccessPreviewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.access_preview_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "access_preview_id",
                        details: "cannot be empty or unset",
                    })?;
            let access_preview_id = aws_smithy_http::label::fmt_string(input_8, false);
            if access_preview_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "access_preview_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/access-preview/{accessPreviewId}",
                accessPreviewId = access_preview_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetAccessPreviewInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_9) = &_input.analyzer_arn {
                query.push_kv("analyzerArn", &aws_smithy_http::query::fmt_string(&inner_9));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccessPreviewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccessPreviewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccessPreview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccessPreview",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccessPreviewInput`](crate::input::GetAccessPreviewInput)
    pub fn builder() -> crate::input::get_access_preview_input::Builder {
        crate::input::get_access_preview_input::Builder::default()
    }
}

/// See [`GetAnalyzedResourceInput`](crate::input::GetAnalyzedResourceInput)
pub mod get_analyzed_resource_input {
    /// A builder for [`GetAnalyzedResourceInput`](crate::input::GetAnalyzedResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve information from.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve information from.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// <p>The ARN of the resource to retrieve information about.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to retrieve information about.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnalyzedResourceInput`](crate::input::GetAnalyzedResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAnalyzedResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAnalyzedResourceInput {
                analyzer_arn: self.analyzer_arn,
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAnalyzedResourceInputOperationOutputAlias = crate::operation::GetAnalyzedResource;
#[doc(hidden)]
pub type GetAnalyzedResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAnalyzedResourceInput {
    /// Consumes the builder and constructs an Operation<[`GetAnalyzedResource`](crate::operation::GetAnalyzedResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAnalyzedResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAnalyzedResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/analyzed-resource").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetAnalyzedResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_10) = &_input.analyzer_arn {
                query.push_kv(
                    "analyzerArn",
                    &aws_smithy_http::query::fmt_string(&inner_10),
                );
            }
            if let Some(inner_11) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_11),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAnalyzedResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAnalyzedResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAnalyzedResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAnalyzedResource",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAnalyzedResourceInput`](crate::input::GetAnalyzedResourceInput)
    pub fn builder() -> crate::input::get_analyzed_resource_input::Builder {
        crate::input::get_analyzed_resource_input::Builder::default()
    }
}

/// See [`GetAnalyzerInput`](crate::input::GetAnalyzerInput)
pub mod get_analyzer_input {
    /// A builder for [`GetAnalyzerInput`](crate::input::GetAnalyzerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the analyzer retrieved.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_name = Some(input.into());
            self
        }
        /// <p>The name of the analyzer retrieved.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analyzer_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnalyzerInput`](crate::input::GetAnalyzerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAnalyzerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAnalyzerInput {
                analyzer_name: self.analyzer_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAnalyzerInputOperationOutputAlias = crate::operation::GetAnalyzer;
#[doc(hidden)]
pub type GetAnalyzerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAnalyzerInput {
    /// Consumes the builder and constructs an Operation<[`GetAnalyzer`](crate::operation::GetAnalyzer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAnalyzer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAnalyzerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.analyzer_name;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analyzer_name",
                        details: "cannot be empty or unset",
                    })?;
            let analyzer_name = aws_smithy_http::label::fmt_string(input_12, false);
            if analyzer_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analyzer_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/analyzer/{analyzerName}",
                analyzerName = analyzer_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAnalyzerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAnalyzerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAnalyzer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAnalyzer",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAnalyzerInput`](crate::input::GetAnalyzerInput)
    pub fn builder() -> crate::input::get_analyzer_input::Builder {
        crate::input::get_analyzer_input::Builder::default()
    }
}

/// See [`GetArchiveRuleInput`](crate::input::GetArchiveRuleInput)
pub mod get_archive_rule_input {
    /// A builder for [`GetArchiveRuleInput`](crate::input::GetArchiveRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_name: std::option::Option<std::string::String>,
        pub(crate) rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the analyzer to retrieve rules from.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_name = Some(input.into());
            self
        }
        /// <p>The name of the analyzer to retrieve rules from.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analyzer_name = input;
            self
        }
        /// <p>The name of the rule to retrieve.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule to retrieve.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetArchiveRuleInput`](crate::input::GetArchiveRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetArchiveRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetArchiveRuleInput {
                analyzer_name: self.analyzer_name,
                rule_name: self.rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetArchiveRuleInputOperationOutputAlias = crate::operation::GetArchiveRule;
#[doc(hidden)]
pub type GetArchiveRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetArchiveRuleInput {
    /// Consumes the builder and constructs an Operation<[`GetArchiveRule`](crate::operation::GetArchiveRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetArchiveRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetArchiveRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.analyzer_name;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analyzer_name",
                        details: "cannot be empty or unset",
                    })?;
            let analyzer_name = aws_smithy_http::label::fmt_string(input_13, false);
            if analyzer_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analyzer_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_14 = &_input.rule_name;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    })?;
            let rule_name = aws_smithy_http::label::fmt_string(input_14, false);
            if rule_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rule_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/analyzer/{analyzerName}/archive-rule/{ruleName}",
                analyzerName = analyzer_name,
                ruleName = rule_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetArchiveRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetArchiveRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetArchiveRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetArchiveRule",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetArchiveRuleInput`](crate::input::GetArchiveRuleInput)
    pub fn builder() -> crate::input::get_archive_rule_input::Builder {
        crate::input::get_archive_rule_input::Builder::default()
    }
}

/// See [`GetFindingInput`](crate::input::GetFindingInput)
pub mod get_finding_input {
    /// A builder for [`GetFindingInput`](crate::input::GetFindingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the finding.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the finding.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// <p>The ID of the finding to retrieve.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the finding to retrieve.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFindingInput`](crate::input::GetFindingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFindingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFindingInput {
                analyzer_arn: self.analyzer_arn,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFindingInputOperationOutputAlias = crate::operation::GetFinding;
#[doc(hidden)]
pub type GetFindingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFindingInput {
    /// Consumes the builder and constructs an Operation<[`GetFinding`](crate::operation::GetFinding)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFinding,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFindingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_15, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/finding/{id}", id = id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetFindingInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_16) = &_input.analyzer_arn {
                query.push_kv(
                    "analyzerArn",
                    &aws_smithy_http::query::fmt_string(&inner_16),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFindingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFindingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFinding::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFinding",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFindingInput`](crate::input::GetFindingInput)
    pub fn builder() -> crate::input::get_finding_input::Builder {
        crate::input::get_finding_input::Builder::default()
    }
}

/// See [`GetGeneratedPolicyInput`](crate::input::GetGeneratedPolicyInput)
pub mod get_generated_policy_input {
    /// A builder for [`GetGeneratedPolicyInput`](crate::input::GetGeneratedPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) include_resource_placeholders: std::option::Option<bool>,
        pub(crate) include_service_level_template: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies.</p>
        /// <p>For example, in the resource section of a policy, you can receive a placeholder such as <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.</p>
        pub fn include_resource_placeholders(mut self, input: bool) -> Self {
            self.include_resource_placeholders = Some(input);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies.</p>
        /// <p>For example, in the resource section of a policy, you can receive a placeholder such as <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.</p>
        pub fn set_include_resource_placeholders(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_resource_placeholders = input;
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether to generate service-level policies. </p>
        /// <p>IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used recently to create this service-level template.</p>
        pub fn include_service_level_template(mut self, input: bool) -> Self {
            self.include_service_level_template = Some(input);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether to generate service-level policies. </p>
        /// <p>IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used recently to create this service-level template.</p>
        pub fn set_include_service_level_template(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_service_level_template = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGeneratedPolicyInput`](crate::input::GetGeneratedPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGeneratedPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGeneratedPolicyInput {
                job_id: self.job_id,
                include_resource_placeholders: self.include_resource_placeholders,
                include_service_level_template: self.include_service_level_template,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGeneratedPolicyInputOperationOutputAlias = crate::operation::GetGeneratedPolicy;
#[doc(hidden)]
pub type GetGeneratedPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetGeneratedPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetGeneratedPolicy`](crate::operation::GetGeneratedPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGeneratedPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGeneratedPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.job_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_17, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/policy/generation/{jobId}", jobId = job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetGeneratedPolicyInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_18) = &_input.include_resource_placeholders {
                query.push_kv(
                    "includeResourcePlaceholders",
                    aws_smithy_types::primitive::Encoder::from(*inner_18).encode(),
                );
            }
            if let Some(inner_19) = &_input.include_service_level_template {
                query.push_kv(
                    "includeServiceLevelTemplate",
                    aws_smithy_types::primitive::Encoder::from(*inner_19).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGeneratedPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGeneratedPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGeneratedPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGeneratedPolicy",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGeneratedPolicyInput`](crate::input::GetGeneratedPolicyInput)
    pub fn builder() -> crate::input::get_generated_policy_input::Builder {
        crate::input::get_generated_policy_input::Builder::default()
    }
}

/// See [`ListAccessPreviewFindingsInput`](crate::input::ListAccessPreviewFindingsInput)
pub mod list_access_preview_findings_input {
    /// A builder for [`ListAccessPreviewFindingsInput`](crate::input::ListAccessPreviewFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_preview_id: std::option::Option<std::string::String>,
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Criterion>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique ID for the access preview.</p>
        pub fn access_preview_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_preview_id = Some(input.into());
            self
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn set_access_preview_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_preview_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>Criteria to filter the returned findings.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Criterion,
        ) -> Self {
            let mut hash_map = self.filter.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.filter = Some(hash_map);
            self
        }
        /// <p>Criteria to filter the returned findings.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessPreviewFindingsInput`](crate::input::ListAccessPreviewFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccessPreviewFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccessPreviewFindingsInput {
                access_preview_id: self.access_preview_id,
                analyzer_arn: self.analyzer_arn,
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccessPreviewFindingsInputOperationOutputAlias =
    crate::operation::ListAccessPreviewFindings;
#[doc(hidden)]
pub type ListAccessPreviewFindingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAccessPreviewFindingsInput {
    /// Consumes the builder and constructs an Operation<[`ListAccessPreviewFindings`](crate::operation::ListAccessPreviewFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccessPreviewFindings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAccessPreviewFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.access_preview_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "access_preview_id",
                        details: "cannot be empty or unset",
                    })?;
            let access_preview_id = aws_smithy_http::label::fmt_string(input_20, false);
            if access_preview_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "access_preview_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/access-preview/{accessPreviewId}",
                accessPreviewId = access_preview_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAccessPreviewFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAccessPreviewFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_access_preview_findings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccessPreviewFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccessPreviewFindings",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAccessPreviewFindingsInput`](crate::input::ListAccessPreviewFindingsInput)
    pub fn builder() -> crate::input::list_access_preview_findings_input::Builder {
        crate::input::list_access_preview_findings_input::Builder::default()
    }
}

/// See [`ListAccessPreviewsInput`](crate::input::ListAccessPreviewsInput)
pub mod list_access_previews_input {
    /// A builder for [`ListAccessPreviewsInput`](crate::input::ListAccessPreviewsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessPreviewsInput`](crate::input::ListAccessPreviewsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccessPreviewsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccessPreviewsInput {
                analyzer_arn: self.analyzer_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccessPreviewsInputOperationOutputAlias = crate::operation::ListAccessPreviews;
#[doc(hidden)]
pub type ListAccessPreviewsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAccessPreviewsInput {
    /// Consumes the builder and constructs an Operation<[`ListAccessPreviews`](crate::operation::ListAccessPreviews)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccessPreviews,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAccessPreviewsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/access-preview").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAccessPreviewsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_21) = &_input.analyzer_arn {
                query.push_kv(
                    "analyzerArn",
                    &aws_smithy_http::query::fmt_string(&inner_21),
                );
            }
            if let Some(inner_22) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_22));
            }
            if let Some(inner_23) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_23).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAccessPreviewsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAccessPreviewsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccessPreviews::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccessPreviews",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAccessPreviewsInput`](crate::input::ListAccessPreviewsInput)
    pub fn builder() -> crate::input::list_access_previews_input::Builder {
        crate::input::list_access_previews_input::Builder::default()
    }
}

/// See [`ListAnalyzedResourcesInput`](crate::input::ListAnalyzedResourcesInput)
pub mod list_analyzed_resources_input {
    /// A builder for [`ListAnalyzedResourcesInput`](crate::input::ListAnalyzedResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve a list of analyzed resources from.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve a list of analyzed resources from.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// <p>The type of resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnalyzedResourcesInput`](crate::input::ListAnalyzedResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAnalyzedResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAnalyzedResourcesInput {
                analyzer_arn: self.analyzer_arn,
                resource_type: self.resource_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAnalyzedResourcesInputOperationOutputAlias = crate::operation::ListAnalyzedResources;
#[doc(hidden)]
pub type ListAnalyzedResourcesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAnalyzedResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListAnalyzedResources`](crate::operation::ListAnalyzedResources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAnalyzedResources,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAnalyzedResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/analyzed-resource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAnalyzedResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAnalyzedResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_analyzed_resources(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAnalyzedResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAnalyzedResources",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAnalyzedResourcesInput`](crate::input::ListAnalyzedResourcesInput)
    pub fn builder() -> crate::input::list_analyzed_resources_input::Builder {
        crate::input::list_analyzed_resources_input::Builder::default()
    }
}

/// See [`ListAnalyzersInput`](crate::input::ListAnalyzersInput)
pub mod list_analyzers_input {
    /// A builder for [`ListAnalyzersInput`](crate::input::ListAnalyzersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
    }
    impl Builder {
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The type of analyzer.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of analyzer.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnalyzersInput`](crate::input::ListAnalyzersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAnalyzersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAnalyzersInput {
                next_token: self.next_token,
                max_results: self.max_results,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAnalyzersInputOperationOutputAlias = crate::operation::ListAnalyzers;
#[doc(hidden)]
pub type ListAnalyzersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAnalyzersInput {
    /// Consumes the builder and constructs an Operation<[`ListAnalyzers`](crate::operation::ListAnalyzers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAnalyzers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAnalyzersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/analyzer").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAnalyzersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_24) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_24));
            }
            if let Some(inner_25) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_25).encode(),
                );
            }
            if let Some(inner_26) = &_input.r#type {
                query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_26));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAnalyzersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAnalyzersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAnalyzers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAnalyzers",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAnalyzersInput`](crate::input::ListAnalyzersInput)
    pub fn builder() -> crate::input::list_analyzers_input::Builder {
        crate::input::list_analyzers_input::Builder::default()
    }
}

/// See [`ListArchiveRulesInput`](crate::input::ListArchiveRulesInput)
pub mod list_archive_rules_input {
    /// A builder for [`ListArchiveRulesInput`](crate::input::ListArchiveRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the analyzer to retrieve rules from.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_name = Some(input.into());
            self
        }
        /// <p>The name of the analyzer to retrieve rules from.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analyzer_name = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListArchiveRulesInput`](crate::input::ListArchiveRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListArchiveRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListArchiveRulesInput {
                analyzer_name: self.analyzer_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListArchiveRulesInputOperationOutputAlias = crate::operation::ListArchiveRules;
#[doc(hidden)]
pub type ListArchiveRulesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListArchiveRulesInput {
    /// Consumes the builder and constructs an Operation<[`ListArchiveRules`](crate::operation::ListArchiveRules)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListArchiveRules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListArchiveRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.analyzer_name;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analyzer_name",
                        details: "cannot be empty or unset",
                    })?;
            let analyzer_name = aws_smithy_http::label::fmt_string(input_27, false);
            if analyzer_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analyzer_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/analyzer/{analyzerName}/archive-rule",
                analyzerName = analyzer_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListArchiveRulesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_28) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_28));
            }
            if let Some(inner_29) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_29).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListArchiveRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListArchiveRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListArchiveRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListArchiveRules",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListArchiveRulesInput`](crate::input::ListArchiveRulesInput)
    pub fn builder() -> crate::input::list_archive_rules_input::Builder {
        crate::input::list_archive_rules_input::Builder::default()
    }
}

/// See [`ListFindingsInput`](crate::input::ListFindingsInput)
pub mod list_findings_input {
    /// A builder for [`ListFindingsInput`](crate::input::ListFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Criterion>,
        >,
        pub(crate) sort: std::option::Option<crate::model::SortCriteria>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve findings from.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve findings from.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>A filter to match for the findings to return.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Criterion,
        ) -> Self {
            let mut hash_map = self.filter.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.filter = Some(hash_map);
            self
        }
        /// <p>A filter to match for the findings to return.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>The sort order for the findings returned.</p>
        pub fn sort(mut self, input: crate::model::SortCriteria) -> Self {
            self.sort = Some(input);
            self
        }
        /// <p>The sort order for the findings returned.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::SortCriteria>) -> Self {
            self.sort = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFindingsInput`](crate::input::ListFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFindingsInput {
                analyzer_arn: self.analyzer_arn,
                filter: self.filter,
                sort: self.sort,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFindingsInputOperationOutputAlias = crate::operation::ListFindings;
#[doc(hidden)]
pub type ListFindingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFindingsInput {
    /// Consumes the builder and constructs an Operation<[`ListFindings`](crate::operation::ListFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFindings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/finding").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFindings",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFindingsInput`](crate::input::ListFindingsInput)
    pub fn builder() -> crate::input::list_findings_input::Builder {
        crate::input::list_findings_input::Builder::default()
    }
}

/// See [`ListPolicyGenerationsInput`](crate::input::ListPolicyGenerationsInput)
pub mod list_policy_generations_input {
    /// A builder for [`ListPolicyGenerationsInput`](crate::input::ListPolicyGenerationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy. Use this with <code>ListGeneratedPolicies</code> to filter the results to only include results for a specific principal.</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy. Use this with <code>ListGeneratedPolicies</code> to filter the results to only include results for a specific principal.</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.principal_arn = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPolicyGenerationsInput`](crate::input::ListPolicyGenerationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPolicyGenerationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPolicyGenerationsInput {
                principal_arn: self.principal_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPolicyGenerationsInputOperationOutputAlias = crate::operation::ListPolicyGenerations;
#[doc(hidden)]
pub type ListPolicyGenerationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPolicyGenerationsInput {
    /// Consumes the builder and constructs an Operation<[`ListPolicyGenerations`](crate::operation::ListPolicyGenerations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPolicyGenerations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPolicyGenerationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/policy/generation").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListPolicyGenerationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_30) = &_input.principal_arn {
                query.push_kv(
                    "principalArn",
                    &aws_smithy_http::query::fmt_string(&inner_30),
                );
            }
            if let Some(inner_31) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_31).encode(),
                );
            }
            if let Some(inner_32) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_32));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPolicyGenerationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPolicyGenerationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPolicyGenerations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPolicyGenerations",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPolicyGenerationsInput`](crate::input::ListPolicyGenerationsInput)
    pub fn builder() -> crate::input::list_policy_generations_input::Builder {
        crate::input::list_policy_generations_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource to retrieve tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to retrieve tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.resource_arn;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_33, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`StartPolicyGenerationInput`](crate::input::StartPolicyGenerationInput)
pub mod start_policy_generation_input {
    /// A builder for [`StartPolicyGenerationInput`](crate::input::StartPolicyGenerationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_generation_details:
            std::option::Option<crate::model::PolicyGenerationDetails>,
        pub(crate) cloud_trail_details: std::option::Option<crate::model::CloudTrailDetails>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains the ARN of the IAM entity (user or role) for which you are generating a policy.</p>
        pub fn policy_generation_details(
            mut self,
            input: crate::model::PolicyGenerationDetails,
        ) -> Self {
            self.policy_generation_details = Some(input);
            self
        }
        /// <p>Contains the ARN of the IAM entity (user or role) for which you are generating a policy.</p>
        pub fn set_policy_generation_details(
            mut self,
            input: std::option::Option<crate::model::PolicyGenerationDetails>,
        ) -> Self {
            self.policy_generation_details = input;
            self
        }
        /// <p>A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze to generate policies.</p>
        pub fn cloud_trail_details(mut self, input: crate::model::CloudTrailDetails) -> Self {
            self.cloud_trail_details = Some(input);
            self
        }
        /// <p>A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze to generate policies.</p>
        pub fn set_cloud_trail_details(
            mut self,
            input: std::option::Option<crate::model::CloudTrailDetails>,
        ) -> Self {
            self.cloud_trail_details = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartPolicyGenerationInput`](crate::input::StartPolicyGenerationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartPolicyGenerationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartPolicyGenerationInput {
                policy_generation_details: self.policy_generation_details,
                cloud_trail_details: self.cloud_trail_details,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartPolicyGenerationInputOperationOutputAlias = crate::operation::StartPolicyGeneration;
#[doc(hidden)]
pub type StartPolicyGenerationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartPolicyGenerationInput {
    /// Consumes the builder and constructs an Operation<[`StartPolicyGeneration`](crate::operation::StartPolicyGeneration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartPolicyGeneration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartPolicyGenerationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/policy/generation").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartPolicyGenerationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartPolicyGenerationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_policy_generation(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartPolicyGeneration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartPolicyGeneration",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartPolicyGenerationInput`](crate::input::StartPolicyGenerationInput)
    pub fn builder() -> crate::input::start_policy_generation_input::Builder {
        crate::input::start_policy_generation_input::Builder::default()
    }
}

/// See [`StartResourceScanInput`](crate::input::StartResourceScanInput)
pub mod start_resource_scan_input {
    /// A builder for [`StartResourceScanInput`](crate::input::StartResourceScanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to use to scan the policies applied to the specified resource.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to use to scan the policies applied to the specified resource.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// <p>The ARN of the resource to scan.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to scan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartResourceScanInput`](crate::input::StartResourceScanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartResourceScanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartResourceScanInput {
                analyzer_arn: self.analyzer_arn,
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type StartResourceScanInputOperationOutputAlias = crate::operation::StartResourceScan;
#[doc(hidden)]
pub type StartResourceScanInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartResourceScanInput {
    /// Consumes the builder and constructs an Operation<[`StartResourceScan`](crate::operation::StartResourceScan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartResourceScan,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartResourceScanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/resource/scan").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartResourceScanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartResourceScanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_resource_scan(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartResourceScan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartResourceScan",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartResourceScanInput`](crate::input::StartResourceScanInput)
    pub fn builder() -> crate::input::start_resource_scan_input::Builder {
        crate::input::start_resource_scan_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resource to add the tag to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to add the tag to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.resource_arn;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_34, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource to remove the tag from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to remove the tag from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key for the tag to add.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The key for the tag to add.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_35 = &_input.resource_arn;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_35, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_36) = &_input.tag_keys {
                for inner_37 in inner_36 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_37));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateArchiveRuleInput`](crate::input::UpdateArchiveRuleInput)
pub mod update_archive_rule_input {
    /// A builder for [`UpdateArchiveRuleInput`](crate::input::UpdateArchiveRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_name: std::option::Option<std::string::String>,
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Criterion>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the analyzer to update the archive rules for.</p>
        pub fn analyzer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_name = Some(input.into());
            self
        }
        /// <p>The name of the analyzer to update the archive rules for.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analyzer_name = input;
            self
        }
        /// <p>The name of the rule to update.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule to update.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>A filter to match for the rules to update. Only rules that match the filter are updated.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Criterion,
        ) -> Self {
            let mut hash_map = self.filter.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.filter = Some(hash_map);
            self
        }
        /// <p>A filter to match for the rules to update. Only rules that match the filter are updated.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateArchiveRuleInput`](crate::input::UpdateArchiveRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateArchiveRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateArchiveRuleInput {
                analyzer_name: self.analyzer_name,
                rule_name: self.rule_name,
                filter: self.filter,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateArchiveRuleInputOperationOutputAlias = crate::operation::UpdateArchiveRule;
#[doc(hidden)]
pub type UpdateArchiveRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateArchiveRuleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateArchiveRule`](crate::operation::UpdateArchiveRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateArchiveRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateArchiveRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.analyzer_name;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analyzer_name",
                        details: "cannot be empty or unset",
                    })?;
            let analyzer_name = aws_smithy_http::label::fmt_string(input_38, false);
            if analyzer_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analyzer_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_39 = &_input.rule_name;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    })?;
            let rule_name = aws_smithy_http::label::fmt_string(input_39, false);
            if rule_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "rule_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/analyzer/{analyzerName}/archive-rule/{ruleName}",
                analyzerName = analyzer_name,
                ruleName = rule_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateArchiveRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateArchiveRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_archive_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateArchiveRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateArchiveRule",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateArchiveRuleInput`](crate::input::UpdateArchiveRuleInput)
    pub fn builder() -> crate::input::update_archive_rule_input::Builder {
        crate::input::update_archive_rule_input::Builder::default()
    }
}

/// See [`UpdateFindingsInput`](crate::input::UpdateFindingsInput)
pub mod update_findings_input {
    /// A builder for [`UpdateFindingsInput`](crate::input::UpdateFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::FindingStatusUpdate>,
        pub(crate) ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the findings to update.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the findings to update.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// <p>The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active finding.</p>
        pub fn status(mut self, input: crate::model::FindingStatusUpdate) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active finding.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FindingStatusUpdate>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>The IDs of the findings to update.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ids.unwrap_or_default();
            v.push(input.into());
            self.ids = Some(v);
            self
        }
        /// <p>The IDs of the findings to update.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ids = input;
            self
        }
        /// <p>The ARN of the resource identified in the finding.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource identified in the finding.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFindingsInput`](crate::input::UpdateFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFindingsInput {
                analyzer_arn: self.analyzer_arn,
                status: self.status,
                ids: self.ids,
                resource_arn: self.resource_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFindingsInputOperationOutputAlias = crate::operation::UpdateFindings;
#[doc(hidden)]
pub type UpdateFindingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFindingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFindings`](crate::operation::UpdateFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFindings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/finding").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFindings",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFindingsInput`](crate::input::UpdateFindingsInput)
    pub fn builder() -> crate::input::update_findings_input::Builder {
        crate::input::update_findings_input::Builder::default()
    }
}

/// See [`ValidatePolicyInput`](crate::input::ValidatePolicyInput)
pub mod validate_policy_input {
    /// A builder for [`ValidatePolicyInput`](crate::input::ValidatePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) locale: std::option::Option<crate::model::Locale>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
        pub(crate) policy_type: std::option::Option<crate::model::PolicyType>,
        pub(crate) validate_policy_resource_type:
            std::option::Option<crate::model::ValidatePolicyResourceType>,
    }
    impl Builder {
        /// <p>The locale to use for localizing the findings.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>The locale to use for localizing the findings.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The JSON policy document to use as the content for the policy.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The JSON policy document to use as the content for the policy.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// <p>The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups. They also include service-control policies (SCPs) that are attached to an Amazon Web Services organization, organizational unit (OU), or an account.</p>
        /// <p>Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy. </p>
        pub fn policy_type(mut self, input: crate::model::PolicyType) -> Self {
            self.policy_type = Some(input);
            self
        }
        /// <p>The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups. They also include service-control policies (SCPs) that are attached to an Amazon Web Services organization, organizational unit (OU), or an account.</p>
        /// <p>Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy. </p>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.policy_type = input;
            self
        }
        /// <p>The type of resource to attach to your resource policy. Specify a value for the policy validation resource type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a resource policy to attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the policy validation resource type.</p>
        /// <p>For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value for the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all resource policies.</p>
        pub fn validate_policy_resource_type(
            mut self,
            input: crate::model::ValidatePolicyResourceType,
        ) -> Self {
            self.validate_policy_resource_type = Some(input);
            self
        }
        /// <p>The type of resource to attach to your resource policy. Specify a value for the policy validation resource type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a resource policy to attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the policy validation resource type.</p>
        /// <p>For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value for the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all resource policies.</p>
        pub fn set_validate_policy_resource_type(
            mut self,
            input: std::option::Option<crate::model::ValidatePolicyResourceType>,
        ) -> Self {
            self.validate_policy_resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidatePolicyInput`](crate::input::ValidatePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ValidatePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ValidatePolicyInput {
                locale: self.locale,
                max_results: self.max_results,
                next_token: self.next_token,
                policy_document: self.policy_document,
                policy_type: self.policy_type,
                validate_policy_resource_type: self.validate_policy_resource_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ValidatePolicyInputOperationOutputAlias = crate::operation::ValidatePolicy;
#[doc(hidden)]
pub type ValidatePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ValidatePolicyInput {
    /// Consumes the builder and constructs an Operation<[`ValidatePolicy`](crate::operation::ValidatePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ValidatePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ValidatePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/policy/validation").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ValidatePolicyInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_40) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_40).encode(),
                );
            }
            if let Some(inner_41) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_41));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ValidatePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ValidatePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_validate_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ValidatePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ValidatePolicy",
            "accessanalyzer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ValidatePolicyInput`](crate::input::ValidatePolicyInput)
    pub fn builder() -> crate::input::validate_policy_input::Builder {
        crate::input::validate_policy_input::Builder::default()
    }
}

/// <p>Retrieves a list of analyzers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnalyzersInput {
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The type of analyzer.</p>
    pub r#type: std::option::Option<crate::model::Type>,
}
impl ListAnalyzersInput {
    /// <p>A token used for pagination of results returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The type of analyzer.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for ListAnalyzersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnalyzersInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

/// <p>Creates an analyzer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAnalyzerInput {
    /// <p>The name of the analyzer to create.</p>
    pub analyzer_name: std::option::Option<std::string::String>,
    /// <p>The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.</p>
    pub r#type: std::option::Option<crate::model::Type>,
    /// <p>Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.</p>
    pub archive_rules: std::option::Option<std::vec::Vec<crate::model::InlineArchiveRule>>,
    /// <p>The tags to apply to the analyzer.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A client token.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateAnalyzerInput {
    /// <p>The name of the analyzer to create.</p>
    pub fn analyzer_name(&self) -> std::option::Option<&str> {
        self.analyzer_name.as_deref()
    }
    /// <p>The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
    /// <p>Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.</p>
    pub fn archive_rules(&self) -> std::option::Option<&[crate::model::InlineArchiveRule]> {
        self.archive_rules.as_deref()
    }
    /// <p>The tags to apply to the analyzer.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateAnalyzerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAnalyzerInput");
        formatter.field("analyzer_name", &self.analyzer_name);
        formatter.field("r#type", &self.r#type);
        formatter.field("archive_rules", &self.archive_rules);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// <p>Deletes an analyzer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAnalyzerInput {
    /// <p>The name of the analyzer to delete.</p>
    pub analyzer_name: std::option::Option<std::string::String>,
    /// <p>A client token.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteAnalyzerInput {
    /// <p>The name of the analyzer to delete.</p>
    pub fn analyzer_name(&self) -> std::option::Option<&str> {
        self.analyzer_name.as_deref()
    }
    /// <p>A client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteAnalyzerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAnalyzerInput");
        formatter.field("analyzer_name", &self.analyzer_name);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// <p>Retrieves an analyzer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnalyzerInput {
    /// <p>The name of the analyzer retrieved.</p>
    pub analyzer_name: std::option::Option<std::string::String>,
}
impl GetAnalyzerInput {
    /// <p>The name of the analyzer retrieved.</p>
    pub fn analyzer_name(&self) -> std::option::Option<&str> {
        self.analyzer_name.as_deref()
    }
}
impl std::fmt::Debug for GetAnalyzerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnalyzerInput");
        formatter.field("analyzer_name", &self.analyzer_name);
        formatter.finish()
    }
}

/// <p>Retrieves a list of archive rules created for the specified analyzer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListArchiveRulesInput {
    /// <p>The name of the analyzer to retrieve rules from.</p>
    pub analyzer_name: std::option::Option<std::string::String>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListArchiveRulesInput {
    /// <p>The name of the analyzer to retrieve rules from.</p>
    pub fn analyzer_name(&self) -> std::option::Option<&str> {
        self.analyzer_name.as_deref()
    }
    /// <p>A token used for pagination of results returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in the request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListArchiveRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListArchiveRulesInput");
        formatter.field("analyzer_name", &self.analyzer_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Creates an archive rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateArchiveRuleInput {
    /// <p>The name of the created analyzer.</p>
    pub analyzer_name: std::option::Option<std::string::String>,
    /// <p>The name of the rule to create.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The criteria for the rule.</p>
    pub filter: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Criterion>,
    >,
    /// <p>A client token.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateArchiveRuleInput {
    /// <p>The name of the created analyzer.</p>
    pub fn analyzer_name(&self) -> std::option::Option<&str> {
        self.analyzer_name.as_deref()
    }
    /// <p>The name of the rule to create.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The criteria for the rule.</p>
    pub fn filter(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Criterion>>
    {
        self.filter.as_ref()
    }
    /// <p>A client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateArchiveRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateArchiveRuleInput");
        formatter.field("analyzer_name", &self.analyzer_name);
        formatter.field("rule_name", &self.rule_name);
        formatter.field("filter", &self.filter);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// <p>Deletes an archive rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteArchiveRuleInput {
    /// <p>The name of the analyzer that associated with the archive rule to delete.</p>
    pub analyzer_name: std::option::Option<std::string::String>,
    /// <p>The name of the rule to delete.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>A client token.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteArchiveRuleInput {
    /// <p>The name of the analyzer that associated with the archive rule to delete.</p>
    pub fn analyzer_name(&self) -> std::option::Option<&str> {
        self.analyzer_name.as_deref()
    }
    /// <p>The name of the rule to delete.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>A client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteArchiveRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteArchiveRuleInput");
        formatter.field("analyzer_name", &self.analyzer_name);
        formatter.field("rule_name", &self.rule_name);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// <p>Updates the specified archive rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateArchiveRuleInput {
    /// <p>The name of the analyzer to update the archive rules for.</p>
    pub analyzer_name: std::option::Option<std::string::String>,
    /// <p>The name of the rule to update.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>A filter to match for the rules to update. Only rules that match the filter are updated.</p>
    pub filter: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Criterion>,
    >,
    /// <p>A client token.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateArchiveRuleInput {
    /// <p>The name of the analyzer to update the archive rules for.</p>
    pub fn analyzer_name(&self) -> std::option::Option<&str> {
        self.analyzer_name.as_deref()
    }
    /// <p>The name of the rule to update.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>A filter to match for the rules to update. Only rules that match the filter are updated.</p>
    pub fn filter(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Criterion>>
    {
        self.filter.as_ref()
    }
    /// <p>A client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateArchiveRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateArchiveRuleInput");
        formatter.field("analyzer_name", &self.analyzer_name);
        formatter.field("rule_name", &self.rule_name);
        formatter.field("filter", &self.filter);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// <p>Retrieves an archive rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetArchiveRuleInput {
    /// <p>The name of the analyzer to retrieve rules from.</p>
    pub analyzer_name: std::option::Option<std::string::String>,
    /// <p>The name of the rule to retrieve.</p>
    pub rule_name: std::option::Option<std::string::String>,
}
impl GetArchiveRuleInput {
    /// <p>The name of the analyzer to retrieve rules from.</p>
    pub fn analyzer_name(&self) -> std::option::Option<&str> {
        self.analyzer_name.as_deref()
    }
    /// <p>The name of the rule to retrieve.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
}
impl std::fmt::Debug for GetArchiveRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetArchiveRuleInput");
        formatter.field("analyzer_name", &self.analyzer_name);
        formatter.field("rule_name", &self.rule_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidatePolicyInput {
    /// <p>The locale to use for localizing the findings.</p>
    pub locale: std::option::Option<crate::model::Locale>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The JSON policy document to use as the content for the policy.</p>
    pub policy_document: std::option::Option<std::string::String>,
    /// <p>The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups. They also include service-control policies (SCPs) that are attached to an Amazon Web Services organization, organizational unit (OU), or an account.</p>
    /// <p>Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy. </p>
    pub policy_type: std::option::Option<crate::model::PolicyType>,
    /// <p>The type of resource to attach to your resource policy. Specify a value for the policy validation resource type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a resource policy to attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the policy validation resource type.</p>
    /// <p>For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value for the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all resource policies.</p>
    pub validate_policy_resource_type:
        std::option::Option<crate::model::ValidatePolicyResourceType>,
}
impl ValidatePolicyInput {
    /// <p>The locale to use for localizing the findings.</p>
    pub fn locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale.as_ref()
    }
    /// <p>The maximum number of results to return in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token used for pagination of results returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The JSON policy document to use as the content for the policy.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
    /// <p>The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups. They also include service-control policies (SCPs) that are attached to an Amazon Web Services organization, organizational unit (OU), or an account.</p>
    /// <p>Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy. </p>
    pub fn policy_type(&self) -> std::option::Option<&crate::model::PolicyType> {
        self.policy_type.as_ref()
    }
    /// <p>The type of resource to attach to your resource policy. Specify a value for the policy validation resource type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a resource policy to attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the policy validation resource type.</p>
    /// <p>For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value for the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all resource policies.</p>
    pub fn validate_policy_resource_type(
        &self,
    ) -> std::option::Option<&crate::model::ValidatePolicyResourceType> {
        self.validate_policy_resource_type.as_ref()
    }
}
impl std::fmt::Debug for ValidatePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidatePolicyInput");
        formatter.field("locale", &self.locale);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("policy_document", &self.policy_document);
        formatter.field("policy_type", &self.policy_type);
        formatter.field(
            "validate_policy_resource_type",
            &self.validate_policy_resource_type,
        );
        formatter.finish()
    }
}

/// <p>Updates findings with the new values provided in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFindingsInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the findings to update.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
    /// <p>The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active finding.</p>
    pub status: std::option::Option<crate::model::FindingStatusUpdate>,
    /// <p>The IDs of the findings to update.</p>
    pub ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ARN of the resource identified in the finding.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A client token.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateFindingsInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the findings to update.</p>
    pub fn analyzer_arn(&self) -> std::option::Option<&str> {
        self.analyzer_arn.as_deref()
    }
    /// <p>The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active finding.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::FindingStatusUpdate> {
        self.status.as_ref()
    }
    /// <p>The IDs of the findings to update.</p>
    pub fn ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ids.as_deref()
    }
    /// <p>The ARN of the resource identified in the finding.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFindingsInput");
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.field("status", &self.status);
        formatter.field("ids", &self.ids);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// <p>Removes a tag from the specified resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource to remove the tag from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The key for the tag to add.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the resource to remove the tag from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The key for the tag to add.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>Adds a tag to the specified resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resource to add the tag to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to add to the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The ARN of the resource to add the tag to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to add to the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Starts a scan of the policies applied to the specified resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartResourceScanInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to use to scan the policies applied to the specified resource.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource to scan.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl StartResourceScanInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to use to scan the policies applied to the specified resource.</p>
    pub fn analyzer_arn(&self) -> std::option::Option<&str> {
        self.analyzer_arn.as_deref()
    }
    /// <p>The ARN of the resource to scan.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for StartResourceScanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartResourceScanInput");
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartPolicyGenerationInput {
    /// <p>Contains the ARN of the IAM entity (user or role) for which you are generating a policy.</p>
    pub policy_generation_details: std::option::Option<crate::model::PolicyGenerationDetails>,
    /// <p>A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze to generate policies.</p>
    pub cloud_trail_details: std::option::Option<crate::model::CloudTrailDetails>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p>
    /// <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl StartPolicyGenerationInput {
    /// <p>Contains the ARN of the IAM entity (user or role) for which you are generating a policy.</p>
    pub fn policy_generation_details(
        &self,
    ) -> std::option::Option<&crate::model::PolicyGenerationDetails> {
        self.policy_generation_details.as_ref()
    }
    /// <p>A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze to generate policies.</p>
    pub fn cloud_trail_details(&self) -> std::option::Option<&crate::model::CloudTrailDetails> {
        self.cloud_trail_details.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p>
    /// <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for StartPolicyGenerationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartPolicyGenerationInput");
        formatter.field("policy_generation_details", &self.policy_generation_details);
        formatter.field("cloud_trail_details", &self.cloud_trail_details);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// <p>Retrieves a list of tags applied to the specified resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource to retrieve tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource to retrieve tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPolicyGenerationsInput {
    /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy. Use this with <code>ListGeneratedPolicies</code> to filter the results to only include results for a specific principal.</p>
    pub principal_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPolicyGenerationsInput {
    /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy. Use this with <code>ListGeneratedPolicies</code> to filter the results to only include results for a specific principal.</p>
    pub fn principal_arn(&self) -> std::option::Option<&str> {
        self.principal_arn.as_deref()
    }
    /// <p>The maximum number of results to return in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token used for pagination of results returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPolicyGenerationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPolicyGenerationsInput");
        formatter.field("principal_arn", &self.principal_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Retrieves a list of findings generated by the specified analyzer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFindingsInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve findings from.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
    /// <p>A filter to match for the findings to return.</p>
    pub filter: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Criterion>,
    >,
    /// <p>The sort order for the findings returned.</p>
    pub sort: std::option::Option<crate::model::SortCriteria>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListFindingsInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve findings from.</p>
    pub fn analyzer_arn(&self) -> std::option::Option<&str> {
        self.analyzer_arn.as_deref()
    }
    /// <p>A filter to match for the findings to return.</p>
    pub fn filter(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Criterion>>
    {
        self.filter.as_ref()
    }
    /// <p>The sort order for the findings returned.</p>
    pub fn sort(&self) -> std::option::Option<&crate::model::SortCriteria> {
        self.sort.as_ref()
    }
    /// <p>A token used for pagination of results returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFindingsInput");
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.field("filter", &self.filter);
        formatter.field("sort", &self.sort);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Retrieves a list of resources that have been analyzed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnalyzedResourcesInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve a list of analyzed resources from.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
    /// <p>The type of resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAnalyzedResourcesInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve a list of analyzed resources from.</p>
    pub fn analyzer_arn(&self) -> std::option::Option<&str> {
        self.analyzer_arn.as_deref()
    }
    /// <p>The type of resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>A token used for pagination of results returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAnalyzedResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnalyzedResourcesInput");
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessPreviewsInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAccessPreviewsInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
    pub fn analyzer_arn(&self) -> std::option::Option<&str> {
        self.analyzer_arn.as_deref()
    }
    /// <p>A token used for pagination of results returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAccessPreviewsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessPreviewsInput");
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessPreviewFindingsInput {
    /// <p>The unique ID for the access preview.</p>
    pub access_preview_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
    /// <p>Criteria to filter the returned findings.</p>
    pub filter: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Criterion>,
    >,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAccessPreviewFindingsInput {
    /// <p>The unique ID for the access preview.</p>
    pub fn access_preview_id(&self) -> std::option::Option<&str> {
        self.access_preview_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access.</p>
    pub fn analyzer_arn(&self) -> std::option::Option<&str> {
        self.analyzer_arn.as_deref()
    }
    /// <p>Criteria to filter the returned findings.</p>
    pub fn filter(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Criterion>>
    {
        self.filter.as_ref()
    }
    /// <p>A token used for pagination of results returned.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAccessPreviewFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessPreviewFindingsInput");
        formatter.field("access_preview_id", &self.access_preview_id);
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGeneratedPolicyInput {
    /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies.</p>
    /// <p>For example, in the resource section of a policy, you can receive a placeholder such as <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.</p>
    pub include_resource_placeholders: std::option::Option<bool>,
    /// <p>The level of detail that you want to generate. You can specify whether to generate service-level policies. </p>
    /// <p>IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used recently to create this service-level template.</p>
    pub include_service_level_template: std::option::Option<bool>,
}
impl GetGeneratedPolicyInput {
    /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies.</p>
    /// <p>For example, in the resource section of a policy, you can receive a placeholder such as <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.</p>
    pub fn include_resource_placeholders(&self) -> std::option::Option<bool> {
        self.include_resource_placeholders
    }
    /// <p>The level of detail that you want to generate. You can specify whether to generate service-level policies. </p>
    /// <p>IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used recently to create this service-level template.</p>
    pub fn include_service_level_template(&self) -> std::option::Option<bool> {
        self.include_service_level_template
    }
}
impl std::fmt::Debug for GetGeneratedPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGeneratedPolicyInput");
        formatter.field("job_id", &self.job_id);
        formatter.field(
            "include_resource_placeholders",
            &self.include_resource_placeholders,
        );
        formatter.field(
            "include_service_level_template",
            &self.include_service_level_template,
        );
        formatter.finish()
    }
}

/// <p>Retrieves a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the finding.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the finding to retrieve.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetFindingInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the finding.</p>
    pub fn analyzer_arn(&self) -> std::option::Option<&str> {
        self.analyzer_arn.as_deref()
    }
    /// <p>The ID of the finding to retrieve.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetFindingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingInput");
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>Retrieves an analyzed resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnalyzedResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve information from.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource to retrieve information about.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl GetAnalyzedResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve information from.</p>
    pub fn analyzer_arn(&self) -> std::option::Option<&str> {
        self.analyzer_arn.as_deref()
    }
    /// <p>The ARN of the resource to retrieve information about.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for GetAnalyzedResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnalyzedResourceInput");
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPreviewInput {
    /// <p>The unique ID for the access preview.</p>
    pub access_preview_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
}
impl GetAccessPreviewInput {
    /// <p>The unique ID for the access preview.</p>
    pub fn access_preview_id(&self) -> std::option::Option<&str> {
        self.access_preview_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>
    pub fn analyzer_arn(&self) -> std::option::Option<&str> {
        self.analyzer_arn.as_deref()
    }
}
impl std::fmt::Debug for GetAccessPreviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPreviewInput");
        formatter.field("access_preview_id", &self.access_preview_id);
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessPreviewInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the account analyzer</a> used to generate the access preview. You can only create an access preview for analyzers with an <code>Account</code> type and <code>Active</code> status.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
    /// <p>Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.</p>
    pub configurations: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Configuration>,
    >,
    /// <p>A client token.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateAccessPreviewInput {
    /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the account analyzer</a> used to generate the access preview. You can only create an access preview for analyzers with an <code>Account</code> type and <code>Active</code> status.</p>
    pub fn analyzer_arn(&self) -> std::option::Option<&str> {
        self.analyzer_arn.as_deref()
    }
    /// <p>Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.</p>
    pub fn configurations(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::Configuration>,
    > {
        self.configurations.as_ref()
    }
    /// <p>A client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateAccessPreviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessPreviewInput");
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.field("configurations", &self.configurations);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelPolicyGenerationInput {
    /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl CancelPolicyGenerationInput {
    /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for CancelPolicyGenerationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelPolicyGenerationInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

/// <p>Retroactively applies an archive rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplyArchiveRuleInput {
    /// <p>The Amazon resource name (ARN) of the analyzer.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
    /// <p>The name of the rule to apply.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>A client token.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl ApplyArchiveRuleInput {
    /// <p>The Amazon resource name (ARN) of the analyzer.</p>
    pub fn analyzer_arn(&self) -> std::option::Option<&str> {
        self.analyzer_arn.as_deref()
    }
    /// <p>The name of the rule to apply.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>A client token.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for ApplyArchiveRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplyArchiveRuleInput");
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.field("rule_name", &self.rule_name);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
