// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AccessAnalyzer`.
///
/// This client allows ergonomic access to a `AccessAnalyzer`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `ApplyArchiveRule` operation.
    ///
    /// See [`ApplyArchiveRule`](crate::client::fluent_builders::ApplyArchiveRule) for more information about the
    /// operation and its arguments.
    pub fn apply_archive_rule(&self) -> fluent_builders::ApplyArchiveRule<C, M, R> {
        fluent_builders::ApplyArchiveRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelPolicyGeneration` operation.
    ///
    /// See [`CancelPolicyGeneration`](crate::client::fluent_builders::CancelPolicyGeneration) for more information about the
    /// operation and its arguments.
    pub fn cancel_policy_generation(&self) -> fluent_builders::CancelPolicyGeneration<C, M, R> {
        fluent_builders::CancelPolicyGeneration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAccessPreview` operation.
    ///
    /// See [`CreateAccessPreview`](crate::client::fluent_builders::CreateAccessPreview) for more information about the
    /// operation and its arguments.
    pub fn create_access_preview(&self) -> fluent_builders::CreateAccessPreview<C, M, R> {
        fluent_builders::CreateAccessPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAnalyzer` operation.
    ///
    /// See [`CreateAnalyzer`](crate::client::fluent_builders::CreateAnalyzer) for more information about the
    /// operation and its arguments.
    pub fn create_analyzer(&self) -> fluent_builders::CreateAnalyzer<C, M, R> {
        fluent_builders::CreateAnalyzer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateArchiveRule` operation.
    ///
    /// See [`CreateArchiveRule`](crate::client::fluent_builders::CreateArchiveRule) for more information about the
    /// operation and its arguments.
    pub fn create_archive_rule(&self) -> fluent_builders::CreateArchiveRule<C, M, R> {
        fluent_builders::CreateArchiveRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAnalyzer` operation.
    ///
    /// See [`DeleteAnalyzer`](crate::client::fluent_builders::DeleteAnalyzer) for more information about the
    /// operation and its arguments.
    pub fn delete_analyzer(&self) -> fluent_builders::DeleteAnalyzer<C, M, R> {
        fluent_builders::DeleteAnalyzer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteArchiveRule` operation.
    ///
    /// See [`DeleteArchiveRule`](crate::client::fluent_builders::DeleteArchiveRule) for more information about the
    /// operation and its arguments.
    pub fn delete_archive_rule(&self) -> fluent_builders::DeleteArchiveRule<C, M, R> {
        fluent_builders::DeleteArchiveRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccessPreview` operation.
    ///
    /// See [`GetAccessPreview`](crate::client::fluent_builders::GetAccessPreview) for more information about the
    /// operation and its arguments.
    pub fn get_access_preview(&self) -> fluent_builders::GetAccessPreview<C, M, R> {
        fluent_builders::GetAccessPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAnalyzedResource` operation.
    ///
    /// See [`GetAnalyzedResource`](crate::client::fluent_builders::GetAnalyzedResource) for more information about the
    /// operation and its arguments.
    pub fn get_analyzed_resource(&self) -> fluent_builders::GetAnalyzedResource<C, M, R> {
        fluent_builders::GetAnalyzedResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAnalyzer` operation.
    ///
    /// See [`GetAnalyzer`](crate::client::fluent_builders::GetAnalyzer) for more information about the
    /// operation and its arguments.
    pub fn get_analyzer(&self) -> fluent_builders::GetAnalyzer<C, M, R> {
        fluent_builders::GetAnalyzer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetArchiveRule` operation.
    ///
    /// See [`GetArchiveRule`](crate::client::fluent_builders::GetArchiveRule) for more information about the
    /// operation and its arguments.
    pub fn get_archive_rule(&self) -> fluent_builders::GetArchiveRule<C, M, R> {
        fluent_builders::GetArchiveRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFinding` operation.
    ///
    /// See [`GetFinding`](crate::client::fluent_builders::GetFinding) for more information about the
    /// operation and its arguments.
    pub fn get_finding(&self) -> fluent_builders::GetFinding<C, M, R> {
        fluent_builders::GetFinding::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGeneratedPolicy` operation.
    ///
    /// See [`GetGeneratedPolicy`](crate::client::fluent_builders::GetGeneratedPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_generated_policy(&self) -> fluent_builders::GetGeneratedPolicy<C, M, R> {
        fluent_builders::GetGeneratedPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccessPreviewFindings` operation.
    ///
    /// See [`ListAccessPreviewFindings`](crate::client::fluent_builders::ListAccessPreviewFindings) for more information about the
    /// operation and its arguments.
    pub fn list_access_preview_findings(
        &self,
    ) -> fluent_builders::ListAccessPreviewFindings<C, M, R> {
        fluent_builders::ListAccessPreviewFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccessPreviews` operation.
    ///
    /// See [`ListAccessPreviews`](crate::client::fluent_builders::ListAccessPreviews) for more information about the
    /// operation and its arguments.
    pub fn list_access_previews(&self) -> fluent_builders::ListAccessPreviews<C, M, R> {
        fluent_builders::ListAccessPreviews::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAnalyzedResources` operation.
    ///
    /// See [`ListAnalyzedResources`](crate::client::fluent_builders::ListAnalyzedResources) for more information about the
    /// operation and its arguments.
    pub fn list_analyzed_resources(&self) -> fluent_builders::ListAnalyzedResources<C, M, R> {
        fluent_builders::ListAnalyzedResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAnalyzers` operation.
    ///
    /// See [`ListAnalyzers`](crate::client::fluent_builders::ListAnalyzers) for more information about the
    /// operation and its arguments.
    pub fn list_analyzers(&self) -> fluent_builders::ListAnalyzers<C, M, R> {
        fluent_builders::ListAnalyzers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListArchiveRules` operation.
    ///
    /// See [`ListArchiveRules`](crate::client::fluent_builders::ListArchiveRules) for more information about the
    /// operation and its arguments.
    pub fn list_archive_rules(&self) -> fluent_builders::ListArchiveRules<C, M, R> {
        fluent_builders::ListArchiveRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFindings` operation.
    ///
    /// See [`ListFindings`](crate::client::fluent_builders::ListFindings) for more information about the
    /// operation and its arguments.
    pub fn list_findings(&self) -> fluent_builders::ListFindings<C, M, R> {
        fluent_builders::ListFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPolicyGenerations` operation.
    ///
    /// See [`ListPolicyGenerations`](crate::client::fluent_builders::ListPolicyGenerations) for more information about the
    /// operation and its arguments.
    pub fn list_policy_generations(&self) -> fluent_builders::ListPolicyGenerations<C, M, R> {
        fluent_builders::ListPolicyGenerations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartPolicyGeneration` operation.
    ///
    /// See [`StartPolicyGeneration`](crate::client::fluent_builders::StartPolicyGeneration) for more information about the
    /// operation and its arguments.
    pub fn start_policy_generation(&self) -> fluent_builders::StartPolicyGeneration<C, M, R> {
        fluent_builders::StartPolicyGeneration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartResourceScan` operation.
    ///
    /// See [`StartResourceScan`](crate::client::fluent_builders::StartResourceScan) for more information about the
    /// operation and its arguments.
    pub fn start_resource_scan(&self) -> fluent_builders::StartResourceScan<C, M, R> {
        fluent_builders::StartResourceScan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateArchiveRule` operation.
    ///
    /// See [`UpdateArchiveRule`](crate::client::fluent_builders::UpdateArchiveRule) for more information about the
    /// operation and its arguments.
    pub fn update_archive_rule(&self) -> fluent_builders::UpdateArchiveRule<C, M, R> {
        fluent_builders::UpdateArchiveRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFindings` operation.
    ///
    /// See [`UpdateFindings`](crate::client::fluent_builders::UpdateFindings) for more information about the
    /// operation and its arguments.
    pub fn update_findings(&self) -> fluent_builders::UpdateFindings<C, M, R> {
        fluent_builders::UpdateFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ValidatePolicy` operation.
    ///
    /// See [`ValidatePolicy`](crate::client::fluent_builders::ValidatePolicy) for more information about the
    /// operation and its arguments.
    pub fn validate_policy(&self) -> fluent_builders::ValidatePolicy<C, M, R> {
        fluent_builders::ValidatePolicy::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ApplyArchiveRule`.
    ///
    /// <p>Retroactively applies the archive rule to existing findings that meet the archive rule
    /// criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct ApplyArchiveRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::apply_archive_rule_input::Builder,
    }
    impl<C, M, R> ApplyArchiveRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ApplyArchiveRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplyArchiveRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplyArchiveRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ApplyArchiveRuleInputOperationOutputAlias,
                crate::output::ApplyArchiveRuleOutput,
                crate::error::ApplyArchiveRuleError,
                crate::input::ApplyArchiveRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon resource name (ARN) of the analyzer.</p>
        pub fn analyzer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(inp);
            self
        }
        /// <p>The Amazon resource name (ARN) of the analyzer.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>The name of the rule to apply.</p>
        pub fn rule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(inp);
            self
        }
        /// <p>The name of the rule to apply.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelPolicyGeneration`.
    ///
    /// <p>Cancels the requested policy generation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelPolicyGeneration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_policy_generation_input::Builder,
    }
    impl<C, M, R> CancelPolicyGeneration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelPolicyGeneration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelPolicyGenerationOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelPolicyGenerationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelPolicyGenerationInputOperationOutputAlias,
                crate::output::CancelPolicyGenerationOutput,
                crate::error::CancelPolicyGenerationError,
                crate::input::CancelPolicyGenerationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
        /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
        /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
        /// the policy generation request.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
        /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
        /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
        /// the policy generation request.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccessPreview`.
    ///
    /// <p>Creates an access preview that allows you to preview IAM Access Analyzer findings for your
    /// resource before deploying resource permissions.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAccessPreview<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_access_preview_input::Builder,
    }
    impl<C, M, R> CreateAccessPreview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccessPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccessPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccessPreviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccessPreviewInputOperationOutputAlias,
                crate::output::CreateAccessPreviewOutput,
                crate::error::CreateAccessPreviewError,
                crate::input::CreateAccessPreviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the account analyzer</a> used to generate the access preview. You can only create an
        /// access preview for analyzers with an <code>Account</code> type and <code>Active</code>
        /// status.</p>
        pub fn analyzer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the account analyzer</a> used to generate the access preview. You can only create an
        /// access preview for analyzers with an <code>Account</code> type and <code>Active</code>
        /// status.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// Adds a key-value pair to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>Access control configuration for your resource that is used to generate the access
        /// preview. The access preview includes findings for external access allowed to the resource
        /// with the proposed access control configuration. The configuration must contain exactly one
        /// element.</p>
        pub fn configurations(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Configuration>,
        ) -> Self {
            self.inner = self.inner.configurations(k, v);
            self
        }
        /// <p>Access control configuration for your resource that is used to generate the access
        /// preview. The access preview includes findings for external access allowed to the resource
        /// with the proposed access control configuration. The configuration must contain exactly one
        /// element.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Configuration>,
            >,
        ) -> Self {
            self.inner = self.inner.set_configurations(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAnalyzer`.
    ///
    /// <p>Creates an analyzer for your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAnalyzer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_analyzer_input::Builder,
    }
    impl<C, M, R> CreateAnalyzer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAnalyzer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAnalyzerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAnalyzerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAnalyzerInputOperationOutputAlias,
                crate::output::CreateAnalyzerOutput,
                crate::error::CreateAnalyzerError,
                crate::input::CreateAnalyzerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer to create.</p>
        pub fn analyzer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(inp);
            self
        }
        /// <p>The name of the analyzer to create.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported.
        /// You can create only one analyzer per account per Region. You can create up to 5 analyzers
        /// per organization per Region.</p>
        pub fn r#type(mut self, inp: crate::model::Type) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported.
        /// You can create only one analyzer per account per Region. You can create up to 5 analyzers
        /// per organization per Region.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `archiveRules`.
        ///
        /// To override the contents of this collection use [`set_archive_rules`](Self::set_archive_rules).
        ///
        /// <p>Specifies the archive rules to add for the analyzer. Archive rules automatically archive
        /// findings that meet the criteria you define for the rule.</p>
        pub fn archive_rules(mut self, inp: impl Into<crate::model::InlineArchiveRule>) -> Self {
            self.inner = self.inner.archive_rules(inp);
            self
        }
        /// <p>Specifies the archive rules to add for the analyzer. Archive rules automatically archive
        /// findings that meet the criteria you define for the rule.</p>
        pub fn set_archive_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InlineArchiveRule>>,
        ) -> Self {
            self.inner = self.inner.set_archive_rules(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the analyzer.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to apply to the analyzer.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateArchiveRule`.
    ///
    /// <p>Creates an archive rule for the specified analyzer. Archive rules automatically archive
    /// new findings that meet the criteria you define when you create the rule.</p>
    /// <p>To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateArchiveRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_archive_rule_input::Builder,
    }
    impl<C, M, R> CreateArchiveRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateArchiveRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateArchiveRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateArchiveRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateArchiveRuleInputOperationOutputAlias,
                crate::output::CreateArchiveRuleOutput,
                crate::error::CreateArchiveRuleError,
                crate::input::CreateArchiveRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the created analyzer.</p>
        pub fn analyzer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(inp);
            self
        }
        /// <p>The name of the created analyzer.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>The name of the rule to create.</p>
        pub fn rule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(inp);
            self
        }
        /// <p>The name of the rule to create.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>The criteria for the rule.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Criterion>,
        ) -> Self {
            self.inner = self.inner.filter(k, v);
            self
        }
        /// <p>The criteria for the rule.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAnalyzer`.
    ///
    /// <p>Deletes the specified analyzer. When you delete an analyzer, IAM Access Analyzer is disabled
    /// for the account or organization in the current or specific Region. All findings that were
    /// generated by the analyzer are deleted. You cannot undo this action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAnalyzer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_analyzer_input::Builder,
    }
    impl<C, M, R> DeleteAnalyzer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAnalyzer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAnalyzerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAnalyzerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAnalyzerInputOperationOutputAlias,
                crate::output::DeleteAnalyzerOutput,
                crate::error::DeleteAnalyzerError,
                crate::input::DeleteAnalyzerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer to delete.</p>
        pub fn analyzer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(inp);
            self
        }
        /// <p>The name of the analyzer to delete.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteArchiveRule`.
    ///
    /// <p>Deletes the specified archive rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteArchiveRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_archive_rule_input::Builder,
    }
    impl<C, M, R> DeleteArchiveRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteArchiveRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteArchiveRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteArchiveRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteArchiveRuleInputOperationOutputAlias,
                crate::output::DeleteArchiveRuleOutput,
                crate::error::DeleteArchiveRuleError,
                crate::input::DeleteArchiveRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer that associated with the archive rule to delete.</p>
        pub fn analyzer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(inp);
            self
        }
        /// <p>The name of the analyzer that associated with the archive rule to delete.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>The name of the rule to delete.</p>
        pub fn rule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(inp);
            self
        }
        /// <p>The name of the rule to delete.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPreview`.
    ///
    /// <p>Retrieves information about an access preview for the specified analyzer.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccessPreview<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_access_preview_input::Builder,
    }
    impl<C, M, R> GetAccessPreview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccessPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessPreviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccessPreviewInputOperationOutputAlias,
                crate::output::GetAccessPreviewOutput,
                crate::error::GetAccessPreviewError,
                crate::input::GetAccessPreviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn access_preview_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_preview_id(inp);
            self
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn set_access_preview_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_preview_id(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> used to generate the access preview.</p>
        pub fn analyzer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> used to generate the access preview.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAnalyzedResource`.
    ///
    /// <p>Retrieves information about a resource that was analyzed.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAnalyzedResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_analyzed_resource_input::Builder,
    }
    impl<C, M, R> GetAnalyzedResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAnalyzedResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAnalyzedResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAnalyzedResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAnalyzedResourceInputOperationOutputAlias,
                crate::output::GetAnalyzedResourceOutput,
                crate::error::GetAnalyzedResourceError,
                crate::input::GetAnalyzedResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> to retrieve information from.</p>
        pub fn analyzer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> to retrieve information from.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>The ARN of the resource to retrieve information about.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource to retrieve information about.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAnalyzer`.
    ///
    /// <p>Retrieves information about the specified analyzer.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAnalyzer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_analyzer_input::Builder,
    }
    impl<C, M, R> GetAnalyzer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAnalyzer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAnalyzerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAnalyzerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAnalyzerInputOperationOutputAlias,
                crate::output::GetAnalyzerOutput,
                crate::error::GetAnalyzerError,
                crate::input::GetAnalyzerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer retrieved.</p>
        pub fn analyzer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(inp);
            self
        }
        /// <p>The name of the analyzer retrieved.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetArchiveRule`.
    ///
    /// <p>Retrieves information about an archive rule.</p>
    /// <p>To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetArchiveRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_archive_rule_input::Builder,
    }
    impl<C, M, R> GetArchiveRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetArchiveRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetArchiveRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetArchiveRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetArchiveRuleInputOperationOutputAlias,
                crate::output::GetArchiveRuleOutput,
                crate::error::GetArchiveRuleError,
                crate::input::GetArchiveRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer to retrieve rules from.</p>
        pub fn analyzer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(inp);
            self
        }
        /// <p>The name of the analyzer to retrieve rules from.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>The name of the rule to retrieve.</p>
        pub fn rule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(inp);
            self
        }
        /// <p>The name of the rule to retrieve.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFinding`.
    ///
    /// <p>Retrieves information about the specified finding.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFinding<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_finding_input::Builder,
    }
    impl<C, M, R> GetFinding<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFinding`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingInputOperationOutputAlias,
                crate::output::GetFindingOutput,
                crate::error::GetFindingError,
                crate::input::GetFindingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> that generated the finding.</p>
        pub fn analyzer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> that generated the finding.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>The ID of the finding to retrieve.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the finding to retrieve.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGeneratedPolicy`.
    ///
    /// <p>Retrieves the policy that was generated using <code>StartPolicyGeneration</code>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetGeneratedPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_generated_policy_input::Builder,
    }
    impl<C, M, R> GetGeneratedPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGeneratedPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGeneratedPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGeneratedPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGeneratedPolicyInputOperationOutputAlias,
                crate::output::GetGeneratedPolicyOutput,
                crate::error::GetGeneratedPolicyError,
                crate::input::GetGeneratedPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
        /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
        /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
        /// the policy generation request.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
        /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
        /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
        /// the policy generation request.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether to generate
        /// policies with placeholders for resource ARNs for actions that support resource level
        /// granularity in policies.</p>
        /// <p>For example, in the resource section of a policy, you can receive a placeholder such as
        /// <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.</p>
        pub fn include_resource_placeholders(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_resource_placeholders(inp);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether to generate
        /// policies with placeholders for resource ARNs for actions that support resource level
        /// granularity in policies.</p>
        /// <p>For example, in the resource section of a policy, you can receive a placeholder such as
        /// <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.</p>
        pub fn set_include_resource_placeholders(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_include_resource_placeholders(input);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether to generate
        /// service-level policies. </p>
        /// <p>IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have
        /// been used recently to create this service-level template.</p>
        pub fn include_service_level_template(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_service_level_template(inp);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether to generate
        /// service-level policies. </p>
        /// <p>IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have
        /// been used recently to create this service-level template.</p>
        pub fn set_include_service_level_template(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_include_service_level_template(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessPreviewFindings`.
    ///
    /// <p>Retrieves a list of access preview findings generated by the specified access
    /// preview.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccessPreviewFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_access_preview_findings_input::Builder,
    }
    impl<C, M, R> ListAccessPreviewFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccessPreviewFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessPreviewFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessPreviewFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccessPreviewFindingsInputOperationOutputAlias,
                crate::output::ListAccessPreviewFindingsOutput,
                crate::error::ListAccessPreviewFindingsError,
                crate::input::ListAccessPreviewFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn access_preview_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_preview_id(inp);
            self
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn set_access_preview_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_preview_id(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> used to generate the access.</p>
        pub fn analyzer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> used to generate the access.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>Criteria to filter the returned findings.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Criterion>,
        ) -> Self {
            self.inner = self.inner.filter(k, v);
            self
        }
        /// <p>Criteria to filter the returned findings.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessPreviews`.
    ///
    /// <p>Retrieves a list of access previews for the specified analyzer.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccessPreviews<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_access_previews_input::Builder,
    }
    impl<C, M, R> ListAccessPreviews<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccessPreviews`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessPreviewsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessPreviewsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccessPreviewsInputOperationOutputAlias,
                crate::output::ListAccessPreviewsOutput,
                crate::error::ListAccessPreviewsError,
                crate::input::ListAccessPreviewsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> used to generate the access preview.</p>
        pub fn analyzer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> used to generate the access preview.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnalyzedResources`.
    ///
    /// <p>Retrieves a list of resources of the specified type that have been analyzed by the
    /// specified analyzer..</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAnalyzedResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_analyzed_resources_input::Builder,
    }
    impl<C, M, R> ListAnalyzedResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAnalyzedResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnalyzedResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnalyzedResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAnalyzedResourcesInputOperationOutputAlias,
                crate::output::ListAnalyzedResourcesOutput,
                crate::error::ListAnalyzedResourcesError,
                crate::input::ListAnalyzedResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> to retrieve a list of analyzed resources from.</p>
        pub fn analyzer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> to retrieve a list of analyzed resources from.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>The type of resource.</p>
        pub fn resource_type(mut self, inp: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnalyzers`.
    ///
    /// <p>Retrieves a list of analyzers.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAnalyzers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_analyzers_input::Builder,
    }
    impl<C, M, R> ListAnalyzers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAnalyzers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnalyzersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnalyzersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAnalyzersInputOperationOutputAlias,
                crate::output::ListAnalyzersOutput,
                crate::error::ListAnalyzersError,
                crate::input::ListAnalyzersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The type of analyzer.</p>
        pub fn r#type(mut self, inp: crate::model::Type) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of analyzer.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListArchiveRules`.
    ///
    /// <p>Retrieves a list of archive rules created for the specified analyzer.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListArchiveRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_archive_rules_input::Builder,
    }
    impl<C, M, R> ListArchiveRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListArchiveRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListArchiveRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListArchiveRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListArchiveRulesInputOperationOutputAlias,
                crate::output::ListArchiveRulesOutput,
                crate::error::ListArchiveRulesError,
                crate::input::ListArchiveRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer to retrieve rules from.</p>
        pub fn analyzer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(inp);
            self
        }
        /// <p>The name of the analyzer to retrieve rules from.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindings`.
    ///
    /// <p>Retrieves a list of findings generated by the specified analyzer.</p>
    /// <p>To learn about filter keys that you can use to retrieve a list of findings, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_findings_input::Builder,
    }
    impl<C, M, R> ListFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFindingsInputOperationOutputAlias,
                crate::output::ListFindingsOutput,
                crate::error::ListFindingsError,
                crate::input::ListFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> to retrieve findings from.</p>
        pub fn analyzer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> to retrieve findings from.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>A filter to match for the findings to return.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Criterion>,
        ) -> Self {
            self.inner = self.inner.filter(k, v);
            self
        }
        /// <p>A filter to match for the findings to return.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The sort order for the findings returned.</p>
        pub fn sort(mut self, inp: crate::model::SortCriteria) -> Self {
            self.inner = self.inner.sort(inp);
            self
        }
        /// <p>The sort order for the findings returned.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::SortCriteria>) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicyGenerations`.
    ///
    /// <p>Lists all of the policy generations requested in the last seven days.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPolicyGenerations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_policy_generations_input::Builder,
    }
    impl<C, M, R> ListPolicyGenerations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPolicyGenerations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPolicyGenerationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPolicyGenerationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPolicyGenerationsInputOperationOutputAlias,
                crate::output::ListPolicyGenerationsOutput,
                crate::error::ListPolicyGenerationsError,
                crate::input::ListPolicyGenerationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy. Use
        /// this with <code>ListGeneratedPolicies</code> to filter the results to only include results
        /// for a specific principal.</p>
        pub fn principal_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_arn(inp);
            self
        }
        /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy. Use
        /// this with <code>ListGeneratedPolicies</code> to filter the results to only include results
        /// for a specific principal.</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_principal_arn(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves a list of tags applied to the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to retrieve tags from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource to retrieve tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartPolicyGeneration`.
    ///
    /// <p>Starts the policy generation request.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartPolicyGeneration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_policy_generation_input::Builder,
    }
    impl<C, M, R> StartPolicyGeneration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartPolicyGeneration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartPolicyGenerationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartPolicyGenerationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartPolicyGenerationInputOperationOutputAlias,
                crate::output::StartPolicyGenerationOutput,
                crate::error::StartPolicyGenerationError,
                crate::input::StartPolicyGenerationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Contains the ARN of the IAM entity (user or role) for which you are generating a
        /// policy.</p>
        pub fn policy_generation_details(
            mut self,
            inp: crate::model::PolicyGenerationDetails,
        ) -> Self {
            self.inner = self.inner.policy_generation_details(inp);
            self
        }
        /// <p>Contains the ARN of the IAM entity (user or role) for which you are generating a
        /// policy.</p>
        pub fn set_policy_generation_details(
            mut self,
            input: std::option::Option<crate::model::PolicyGenerationDetails>,
        ) -> Self {
            self.inner = self.inner.set_policy_generation_details(input);
            self
        }
        /// <p>A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code>
        /// that you want to analyze to generate policies.</p>
        pub fn cloud_trail_details(mut self, inp: crate::model::CloudTrailDetails) -> Self {
            self.inner = self.inner.cloud_trail_details(inp);
            self
        }
        /// <p>A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code>
        /// that you want to analyze to generate policies.</p>
        pub fn set_cloud_trail_details(
            mut self,
            input: std::option::Option<crate::model::CloudTrailDetails>,
        ) -> Self {
            self.inner = self.inner.set_cloud_trail_details(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, the subsequent retries with the
        /// same client token return the result from the original successful request and they have no
        /// additional effect.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Idempotency ensures that an API request completes only once. With an idempotent
        /// request, if the original request completes successfully, the subsequent retries with the
        /// same client token return the result from the original successful request and they have no
        /// additional effect.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartResourceScan`.
    ///
    /// <p>Immediately starts a scan of the policies applied to the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartResourceScan<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_resource_scan_input::Builder,
    }
    impl<C, M, R> StartResourceScan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartResourceScan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartResourceScanOutput,
            aws_smithy_http::result::SdkError<crate::error::StartResourceScanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartResourceScanInputOperationOutputAlias,
                crate::output::StartResourceScanOutput,
                crate::error::StartResourceScanError,
                crate::input::StartResourceScanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> to use to scan the policies applied to the specified
        /// resource.</p>
        pub fn analyzer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> to use to scan the policies applied to the specified
        /// resource.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>The ARN of the resource to scan.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource to scan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds a tag to the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to add the tag to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource to add the tag to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to remove the tag from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource to remove the tag from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key for the tag to add.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The key for the tag to add.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateArchiveRule`.
    ///
    /// <p>Updates the criteria and values for the specified archive rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateArchiveRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_archive_rule_input::Builder,
    }
    impl<C, M, R> UpdateArchiveRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateArchiveRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateArchiveRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateArchiveRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateArchiveRuleInputOperationOutputAlias,
                crate::output::UpdateArchiveRuleOutput,
                crate::error::UpdateArchiveRuleError,
                crate::input::UpdateArchiveRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the analyzer to update the archive rules for.</p>
        pub fn analyzer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_name(inp);
            self
        }
        /// <p>The name of the analyzer to update the archive rules for.</p>
        pub fn set_analyzer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_analyzer_name(input);
            self
        }
        /// <p>The name of the rule to update.</p>
        pub fn rule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(inp);
            self
        }
        /// <p>The name of the rule to update.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>A filter to match for the rules to update. Only rules that match the filter are
        /// updated.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Criterion>,
        ) -> Self {
            self.inner = self.inner.filter(k, v);
            self
        }
        /// <p>A filter to match for the rules to update. Only rules that match the filter are
        /// updated.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFindings`.
    ///
    /// <p>Updates the status for the specified findings.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_findings_input::Builder,
    }
    impl<C, M, R> UpdateFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFindingsInputOperationOutputAlias,
                crate::output::UpdateFindingsOutput,
                crate::error::UpdateFindingsError,
                crate::input::UpdateFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> that generated the findings to update.</p>
        pub fn analyzer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analyzer_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
        /// the analyzer</a> that generated the findings to update.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analyzer_arn(input);
            self
        }
        /// <p>The state represents the action to take to update the finding Status. Use
        /// <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use
        /// <code>ACTIVE</code> to change an Archived finding to an Active finding.</p>
        pub fn status(mut self, inp: crate::model::FindingStatusUpdate) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The state represents the action to take to update the finding Status. Use
        /// <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use
        /// <code>ACTIVE</code> to change an Archived finding to an Active finding.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FindingStatusUpdate>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>The IDs of the findings to update.</p>
        pub fn ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(inp);
            self
        }
        /// <p>The IDs of the findings to update.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
        /// <p>The ARN of the resource identified in the finding.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource identified in the finding.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>A client token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A client token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ValidatePolicy`.
    ///
    /// <p>Requests the validation of a policy and returns a list of findings. The findings help
    /// you identify issues and provide actionable recommendations to resolve the issue and enable
    /// you to author functional policies that meet security best practices. </p>
    #[derive(std::fmt::Debug)]
    pub struct ValidatePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::validate_policy_input::Builder,
    }
    impl<C, M, R> ValidatePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ValidatePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ValidatePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::ValidatePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ValidatePolicyInputOperationOutputAlias,
                crate::output::ValidatePolicyOutput,
                crate::error::ValidatePolicyError,
                crate::input::ValidatePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The locale to use for localizing the findings.</p>
        pub fn locale(mut self, inp: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(inp);
            self
        }
        /// <p>The locale to use for localizing the findings.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The JSON policy document to use as the content for the policy.</p>
        pub fn policy_document(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(inp);
            self
        }
        /// <p>The JSON policy document to use as the content for the policy.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// <p>The type of policy to validate. Identity policies grant permissions to IAM principals.
        /// Identity policies include managed and inline policies for IAM roles, users, and groups.
        /// They also include service-control policies (SCPs) that are attached to an Amazon Web Services
        /// organization, organizational unit (OU), or an account.</p>
        /// <p>Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
        /// policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic
        /// input such as identity policy or resource policy or a specific input such as managed policy
        /// or Amazon S3 bucket policy. </p>
        pub fn policy_type(mut self, inp: crate::model::PolicyType) -> Self {
            self.inner = self.inner.policy_type(inp);
            self
        }
        /// <p>The type of policy to validate. Identity policies grant permissions to IAM principals.
        /// Identity policies include managed and inline policies for IAM roles, users, and groups.
        /// They also include service-control policies (SCPs) that are attached to an Amazon Web Services
        /// organization, organizational unit (OU), or an account.</p>
        /// <p>Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
        /// policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic
        /// input such as identity policy or resource policy or a specific input such as managed policy
        /// or Amazon S3 bucket policy. </p>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.inner = self.inner.set_policy_type(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
