// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `ApplyArchiveRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`apply_archive_rule`](crate::client::Client::apply_archive_rule).
///
/// See [`crate::client::fluent_builders::ApplyArchiveRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ApplyArchiveRule {
    _private: (),
}
impl ApplyArchiveRule {
    /// Creates a new builder-style object to manufacture [`ApplyArchiveRuleInput`](crate::input::ApplyArchiveRuleInput)
    pub fn builder() -> crate::input::apply_archive_rule_input::Builder {
        crate::input::apply_archive_rule_input::Builder::default()
    }
    /// Creates a new `ApplyArchiveRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ApplyArchiveRule {
    type Output = std::result::Result<
        crate::output::ApplyArchiveRuleOutput,
        crate::error::ApplyArchiveRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_apply_archive_rule_error(response)
        } else {
            crate::operation_deser::parse_apply_archive_rule_response(response)
        }
    }
}

/// Operation shape for `CancelPolicyGeneration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_policy_generation`](crate::client::Client::cancel_policy_generation).
///
/// See [`crate::client::fluent_builders::CancelPolicyGeneration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelPolicyGeneration {
    _private: (),
}
impl CancelPolicyGeneration {
    /// Creates a new builder-style object to manufacture [`CancelPolicyGenerationInput`](crate::input::CancelPolicyGenerationInput)
    pub fn builder() -> crate::input::cancel_policy_generation_input::Builder {
        crate::input::cancel_policy_generation_input::Builder::default()
    }
    /// Creates a new `CancelPolicyGeneration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelPolicyGeneration {
    type Output = std::result::Result<
        crate::output::CancelPolicyGenerationOutput,
        crate::error::CancelPolicyGenerationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_policy_generation_error(response)
        } else {
            crate::operation_deser::parse_cancel_policy_generation_response(response)
        }
    }
}

/// Operation shape for `CreateAccessPreview`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_access_preview`](crate::client::Client::create_access_preview).
///
/// See [`crate::client::fluent_builders::CreateAccessPreview`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAccessPreview {
    _private: (),
}
impl CreateAccessPreview {
    /// Creates a new builder-style object to manufacture [`CreateAccessPreviewInput`](crate::input::CreateAccessPreviewInput)
    pub fn builder() -> crate::input::create_access_preview_input::Builder {
        crate::input::create_access_preview_input::Builder::default()
    }
    /// Creates a new `CreateAccessPreview` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAccessPreview {
    type Output = std::result::Result<
        crate::output::CreateAccessPreviewOutput,
        crate::error::CreateAccessPreviewError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_access_preview_error(response)
        } else {
            crate::operation_deser::parse_create_access_preview_response(response)
        }
    }
}

/// Operation shape for `CreateAnalyzer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_analyzer`](crate::client::Client::create_analyzer).
///
/// See [`crate::client::fluent_builders::CreateAnalyzer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAnalyzer {
    _private: (),
}
impl CreateAnalyzer {
    /// Creates a new builder-style object to manufacture [`CreateAnalyzerInput`](crate::input::CreateAnalyzerInput)
    pub fn builder() -> crate::input::create_analyzer_input::Builder {
        crate::input::create_analyzer_input::Builder::default()
    }
    /// Creates a new `CreateAnalyzer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAnalyzer {
    type Output =
        std::result::Result<crate::output::CreateAnalyzerOutput, crate::error::CreateAnalyzerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_analyzer_error(response)
        } else {
            crate::operation_deser::parse_create_analyzer_response(response)
        }
    }
}

/// Operation shape for `CreateArchiveRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_archive_rule`](crate::client::Client::create_archive_rule).
///
/// See [`crate::client::fluent_builders::CreateArchiveRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateArchiveRule {
    _private: (),
}
impl CreateArchiveRule {
    /// Creates a new builder-style object to manufacture [`CreateArchiveRuleInput`](crate::input::CreateArchiveRuleInput)
    pub fn builder() -> crate::input::create_archive_rule_input::Builder {
        crate::input::create_archive_rule_input::Builder::default()
    }
    /// Creates a new `CreateArchiveRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateArchiveRule {
    type Output = std::result::Result<
        crate::output::CreateArchiveRuleOutput,
        crate::error::CreateArchiveRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_archive_rule_error(response)
        } else {
            crate::operation_deser::parse_create_archive_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteAnalyzer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_analyzer`](crate::client::Client::delete_analyzer).
///
/// See [`crate::client::fluent_builders::DeleteAnalyzer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAnalyzer {
    _private: (),
}
impl DeleteAnalyzer {
    /// Creates a new builder-style object to manufacture [`DeleteAnalyzerInput`](crate::input::DeleteAnalyzerInput)
    pub fn builder() -> crate::input::delete_analyzer_input::Builder {
        crate::input::delete_analyzer_input::Builder::default()
    }
    /// Creates a new `DeleteAnalyzer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAnalyzer {
    type Output =
        std::result::Result<crate::output::DeleteAnalyzerOutput, crate::error::DeleteAnalyzerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_analyzer_error(response)
        } else {
            crate::operation_deser::parse_delete_analyzer_response(response)
        }
    }
}

/// Operation shape for `DeleteArchiveRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_archive_rule`](crate::client::Client::delete_archive_rule).
///
/// See [`crate::client::fluent_builders::DeleteArchiveRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteArchiveRule {
    _private: (),
}
impl DeleteArchiveRule {
    /// Creates a new builder-style object to manufacture [`DeleteArchiveRuleInput`](crate::input::DeleteArchiveRuleInput)
    pub fn builder() -> crate::input::delete_archive_rule_input::Builder {
        crate::input::delete_archive_rule_input::Builder::default()
    }
    /// Creates a new `DeleteArchiveRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteArchiveRule {
    type Output = std::result::Result<
        crate::output::DeleteArchiveRuleOutput,
        crate::error::DeleteArchiveRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_archive_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_archive_rule_response(response)
        }
    }
}

/// Operation shape for `GetAccessPreview`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_access_preview`](crate::client::Client::get_access_preview).
///
/// See [`crate::client::fluent_builders::GetAccessPreview`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccessPreview {
    _private: (),
}
impl GetAccessPreview {
    /// Creates a new builder-style object to manufacture [`GetAccessPreviewInput`](crate::input::GetAccessPreviewInput)
    pub fn builder() -> crate::input::get_access_preview_input::Builder {
        crate::input::get_access_preview_input::Builder::default()
    }
    /// Creates a new `GetAccessPreview` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccessPreview {
    type Output = std::result::Result<
        crate::output::GetAccessPreviewOutput,
        crate::error::GetAccessPreviewError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_access_preview_error(response)
        } else {
            crate::operation_deser::parse_get_access_preview_response(response)
        }
    }
}

/// Operation shape for `GetAnalyzedResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_analyzed_resource`](crate::client::Client::get_analyzed_resource).
///
/// See [`crate::client::fluent_builders::GetAnalyzedResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAnalyzedResource {
    _private: (),
}
impl GetAnalyzedResource {
    /// Creates a new builder-style object to manufacture [`GetAnalyzedResourceInput`](crate::input::GetAnalyzedResourceInput)
    pub fn builder() -> crate::input::get_analyzed_resource_input::Builder {
        crate::input::get_analyzed_resource_input::Builder::default()
    }
    /// Creates a new `GetAnalyzedResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAnalyzedResource {
    type Output = std::result::Result<
        crate::output::GetAnalyzedResourceOutput,
        crate::error::GetAnalyzedResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_analyzed_resource_error(response)
        } else {
            crate::operation_deser::parse_get_analyzed_resource_response(response)
        }
    }
}

/// Operation shape for `GetAnalyzer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_analyzer`](crate::client::Client::get_analyzer).
///
/// See [`crate::client::fluent_builders::GetAnalyzer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAnalyzer {
    _private: (),
}
impl GetAnalyzer {
    /// Creates a new builder-style object to manufacture [`GetAnalyzerInput`](crate::input::GetAnalyzerInput)
    pub fn builder() -> crate::input::get_analyzer_input::Builder {
        crate::input::get_analyzer_input::Builder::default()
    }
    /// Creates a new `GetAnalyzer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAnalyzer {
    type Output =
        std::result::Result<crate::output::GetAnalyzerOutput, crate::error::GetAnalyzerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_analyzer_error(response)
        } else {
            crate::operation_deser::parse_get_analyzer_response(response)
        }
    }
}

/// Operation shape for `GetArchiveRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_archive_rule`](crate::client::Client::get_archive_rule).
///
/// See [`crate::client::fluent_builders::GetArchiveRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetArchiveRule {
    _private: (),
}
impl GetArchiveRule {
    /// Creates a new builder-style object to manufacture [`GetArchiveRuleInput`](crate::input::GetArchiveRuleInput)
    pub fn builder() -> crate::input::get_archive_rule_input::Builder {
        crate::input::get_archive_rule_input::Builder::default()
    }
    /// Creates a new `GetArchiveRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetArchiveRule {
    type Output =
        std::result::Result<crate::output::GetArchiveRuleOutput, crate::error::GetArchiveRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_archive_rule_error(response)
        } else {
            crate::operation_deser::parse_get_archive_rule_response(response)
        }
    }
}

/// Operation shape for `GetFinding`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_finding`](crate::client::Client::get_finding).
///
/// See [`crate::client::fluent_builders::GetFinding`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFinding {
    _private: (),
}
impl GetFinding {
    /// Creates a new builder-style object to manufacture [`GetFindingInput`](crate::input::GetFindingInput)
    pub fn builder() -> crate::input::get_finding_input::Builder {
        crate::input::get_finding_input::Builder::default()
    }
    /// Creates a new `GetFinding` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFinding {
    type Output =
        std::result::Result<crate::output::GetFindingOutput, crate::error::GetFindingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_finding_error(response)
        } else {
            crate::operation_deser::parse_get_finding_response(response)
        }
    }
}

/// Operation shape for `GetGeneratedPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_generated_policy`](crate::client::Client::get_generated_policy).
///
/// See [`crate::client::fluent_builders::GetGeneratedPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGeneratedPolicy {
    _private: (),
}
impl GetGeneratedPolicy {
    /// Creates a new builder-style object to manufacture [`GetGeneratedPolicyInput`](crate::input::GetGeneratedPolicyInput)
    pub fn builder() -> crate::input::get_generated_policy_input::Builder {
        crate::input::get_generated_policy_input::Builder::default()
    }
    /// Creates a new `GetGeneratedPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGeneratedPolicy {
    type Output = std::result::Result<
        crate::output::GetGeneratedPolicyOutput,
        crate::error::GetGeneratedPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_generated_policy_error(response)
        } else {
            crate::operation_deser::parse_get_generated_policy_response(response)
        }
    }
}

/// Operation shape for `ListAccessPreviewFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_access_preview_findings`](crate::client::Client::list_access_preview_findings).
///
/// See [`crate::client::fluent_builders::ListAccessPreviewFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccessPreviewFindings {
    _private: (),
}
impl ListAccessPreviewFindings {
    /// Creates a new builder-style object to manufacture [`ListAccessPreviewFindingsInput`](crate::input::ListAccessPreviewFindingsInput)
    pub fn builder() -> crate::input::list_access_preview_findings_input::Builder {
        crate::input::list_access_preview_findings_input::Builder::default()
    }
    /// Creates a new `ListAccessPreviewFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccessPreviewFindings {
    type Output = std::result::Result<
        crate::output::ListAccessPreviewFindingsOutput,
        crate::error::ListAccessPreviewFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_access_preview_findings_error(response)
        } else {
            crate::operation_deser::parse_list_access_preview_findings_response(response)
        }
    }
}

/// Operation shape for `ListAccessPreviews`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_access_previews`](crate::client::Client::list_access_previews).
///
/// See [`crate::client::fluent_builders::ListAccessPreviews`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccessPreviews {
    _private: (),
}
impl ListAccessPreviews {
    /// Creates a new builder-style object to manufacture [`ListAccessPreviewsInput`](crate::input::ListAccessPreviewsInput)
    pub fn builder() -> crate::input::list_access_previews_input::Builder {
        crate::input::list_access_previews_input::Builder::default()
    }
    /// Creates a new `ListAccessPreviews` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccessPreviews {
    type Output = std::result::Result<
        crate::output::ListAccessPreviewsOutput,
        crate::error::ListAccessPreviewsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_access_previews_error(response)
        } else {
            crate::operation_deser::parse_list_access_previews_response(response)
        }
    }
}

/// Operation shape for `ListAnalyzedResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_analyzed_resources`](crate::client::Client::list_analyzed_resources).
///
/// See [`crate::client::fluent_builders::ListAnalyzedResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAnalyzedResources {
    _private: (),
}
impl ListAnalyzedResources {
    /// Creates a new builder-style object to manufacture [`ListAnalyzedResourcesInput`](crate::input::ListAnalyzedResourcesInput)
    pub fn builder() -> crate::input::list_analyzed_resources_input::Builder {
        crate::input::list_analyzed_resources_input::Builder::default()
    }
    /// Creates a new `ListAnalyzedResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAnalyzedResources {
    type Output = std::result::Result<
        crate::output::ListAnalyzedResourcesOutput,
        crate::error::ListAnalyzedResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_analyzed_resources_error(response)
        } else {
            crate::operation_deser::parse_list_analyzed_resources_response(response)
        }
    }
}

/// Operation shape for `ListAnalyzers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_analyzers`](crate::client::Client::list_analyzers).
///
/// See [`crate::client::fluent_builders::ListAnalyzers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAnalyzers {
    _private: (),
}
impl ListAnalyzers {
    /// Creates a new builder-style object to manufacture [`ListAnalyzersInput`](crate::input::ListAnalyzersInput)
    pub fn builder() -> crate::input::list_analyzers_input::Builder {
        crate::input::list_analyzers_input::Builder::default()
    }
    /// Creates a new `ListAnalyzers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAnalyzers {
    type Output =
        std::result::Result<crate::output::ListAnalyzersOutput, crate::error::ListAnalyzersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_analyzers_error(response)
        } else {
            crate::operation_deser::parse_list_analyzers_response(response)
        }
    }
}

/// Operation shape for `ListArchiveRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_archive_rules`](crate::client::Client::list_archive_rules).
///
/// See [`crate::client::fluent_builders::ListArchiveRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListArchiveRules {
    _private: (),
}
impl ListArchiveRules {
    /// Creates a new builder-style object to manufacture [`ListArchiveRulesInput`](crate::input::ListArchiveRulesInput)
    pub fn builder() -> crate::input::list_archive_rules_input::Builder {
        crate::input::list_archive_rules_input::Builder::default()
    }
    /// Creates a new `ListArchiveRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListArchiveRules {
    type Output = std::result::Result<
        crate::output::ListArchiveRulesOutput,
        crate::error::ListArchiveRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_archive_rules_error(response)
        } else {
            crate::operation_deser::parse_list_archive_rules_response(response)
        }
    }
}

/// Operation shape for `ListFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_findings`](crate::client::Client::list_findings).
///
/// See [`crate::client::fluent_builders::ListFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFindings {
    _private: (),
}
impl ListFindings {
    /// Creates a new builder-style object to manufacture [`ListFindingsInput`](crate::input::ListFindingsInput)
    pub fn builder() -> crate::input::list_findings_input::Builder {
        crate::input::list_findings_input::Builder::default()
    }
    /// Creates a new `ListFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFindings {
    type Output =
        std::result::Result<crate::output::ListFindingsOutput, crate::error::ListFindingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_findings_error(response)
        } else {
            crate::operation_deser::parse_list_findings_response(response)
        }
    }
}

/// Operation shape for `ListPolicyGenerations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_policy_generations`](crate::client::Client::list_policy_generations).
///
/// See [`crate::client::fluent_builders::ListPolicyGenerations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPolicyGenerations {
    _private: (),
}
impl ListPolicyGenerations {
    /// Creates a new builder-style object to manufacture [`ListPolicyGenerationsInput`](crate::input::ListPolicyGenerationsInput)
    pub fn builder() -> crate::input::list_policy_generations_input::Builder {
        crate::input::list_policy_generations_input::Builder::default()
    }
    /// Creates a new `ListPolicyGenerations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPolicyGenerations {
    type Output = std::result::Result<
        crate::output::ListPolicyGenerationsOutput,
        crate::error::ListPolicyGenerationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_policy_generations_error(response)
        } else {
            crate::operation_deser::parse_list_policy_generations_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `StartPolicyGeneration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_policy_generation`](crate::client::Client::start_policy_generation).
///
/// See [`crate::client::fluent_builders::StartPolicyGeneration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartPolicyGeneration {
    _private: (),
}
impl StartPolicyGeneration {
    /// Creates a new builder-style object to manufacture [`StartPolicyGenerationInput`](crate::input::StartPolicyGenerationInput)
    pub fn builder() -> crate::input::start_policy_generation_input::Builder {
        crate::input::start_policy_generation_input::Builder::default()
    }
    /// Creates a new `StartPolicyGeneration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartPolicyGeneration {
    type Output = std::result::Result<
        crate::output::StartPolicyGenerationOutput,
        crate::error::StartPolicyGenerationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_policy_generation_error(response)
        } else {
            crate::operation_deser::parse_start_policy_generation_response(response)
        }
    }
}

/// Operation shape for `StartResourceScan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_resource_scan`](crate::client::Client::start_resource_scan).
///
/// See [`crate::client::fluent_builders::StartResourceScan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartResourceScan {
    _private: (),
}
impl StartResourceScan {
    /// Creates a new builder-style object to manufacture [`StartResourceScanInput`](crate::input::StartResourceScanInput)
    pub fn builder() -> crate::input::start_resource_scan_input::Builder {
        crate::input::start_resource_scan_input::Builder::default()
    }
    /// Creates a new `StartResourceScan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartResourceScan {
    type Output = std::result::Result<
        crate::output::StartResourceScanOutput,
        crate::error::StartResourceScanError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_resource_scan_error(response)
        } else {
            crate::operation_deser::parse_start_resource_scan_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateArchiveRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_archive_rule`](crate::client::Client::update_archive_rule).
///
/// See [`crate::client::fluent_builders::UpdateArchiveRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateArchiveRule {
    _private: (),
}
impl UpdateArchiveRule {
    /// Creates a new builder-style object to manufacture [`UpdateArchiveRuleInput`](crate::input::UpdateArchiveRuleInput)
    pub fn builder() -> crate::input::update_archive_rule_input::Builder {
        crate::input::update_archive_rule_input::Builder::default()
    }
    /// Creates a new `UpdateArchiveRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateArchiveRule {
    type Output = std::result::Result<
        crate::output::UpdateArchiveRuleOutput,
        crate::error::UpdateArchiveRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_archive_rule_error(response)
        } else {
            crate::operation_deser::parse_update_archive_rule_response(response)
        }
    }
}

/// Operation shape for `UpdateFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_findings`](crate::client::Client::update_findings).
///
/// See [`crate::client::fluent_builders::UpdateFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFindings {
    _private: (),
}
impl UpdateFindings {
    /// Creates a new builder-style object to manufacture [`UpdateFindingsInput`](crate::input::UpdateFindingsInput)
    pub fn builder() -> crate::input::update_findings_input::Builder {
        crate::input::update_findings_input::Builder::default()
    }
    /// Creates a new `UpdateFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFindings {
    type Output =
        std::result::Result<crate::output::UpdateFindingsOutput, crate::error::UpdateFindingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_findings_error(response)
        } else {
            crate::operation_deser::parse_update_findings_response(response)
        }
    }
}

/// Operation shape for `ValidatePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`validate_policy`](crate::client::Client::validate_policy).
///
/// See [`crate::client::fluent_builders::ValidatePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ValidatePolicy {
    _private: (),
}
impl ValidatePolicy {
    /// Creates a new builder-style object to manufacture [`ValidatePolicyInput`](crate::input::ValidatePolicyInput)
    pub fn builder() -> crate::input::validate_policy_input::Builder {
        crate::input::validate_policy_input::Builder::default()
    }
    /// Creates a new `ValidatePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ValidatePolicy {
    type Output =
        std::result::Result<crate::output::ValidatePolicyOutput, crate::error::ValidatePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_validate_policy_error(response)
        } else {
            crate::operation_deser::parse_validate_policy_response(response)
        }
    }
}
