// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains information about a validation exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The name of the validation exception.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A message about the validation exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the validation exception.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the validation exception.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A message about the validation exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the validation exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "cannotParse" => ValidationExceptionReason::CannotParse,
            "fieldValidationFailed" => ValidationExceptionReason::FieldValidationFailed,
            "other" => ValidationExceptionReason::Other,
            "unknownOperation" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "cannotParse",
            ValidationExceptionReason::FieldValidationFailed => "fieldValidationFailed",
            ValidationExceptionReason::Other => "other",
            ValidationExceptionReason::UnknownOperation => "unknownOperation",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "cannotParse",
            "fieldValidationFailed",
            "other",
            "unknownOperation",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the analyzer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyzerSummary {
    /// <p>The ARN of the analyzer.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the analyzer.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of analyzer, which corresponds to the zone of trust chosen for the
    /// analyzer.</p>
    pub r#type: std::option::Option<crate::model::Type>,
    /// <p>A timestamp for the time at which the analyzer was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The resource that was most recently analyzed by the analyzer.</p>
    pub last_resource_analyzed: std::option::Option<std::string::String>,
    /// <p>The time at which the most recently analyzed resource was analyzed.</p>
    pub last_resource_analyzed_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags added to the analyzer.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The status of the analyzer. An <code>Active</code> analyzer successfully monitors
    /// supported resources and generates new findings. The analyzer is <code>Disabled</code> when
    /// a user action, such as removing trusted access for Identity and Access Management Access Analyzer from Organizations, causes
    /// the analyzer to stop generating new findings. The status is <code>Creating</code> when the
    /// analyzer creation is in progress and <code>Failed</code> when the analyzer creation has
    /// failed. </p>
    pub status: std::option::Option<crate::model::AnalyzerStatus>,
    /// <p>The <code>statusReason</code> provides more details about the current status of the
    /// analyzer. For example, if the creation for the analyzer fails, a <code>Failed</code> status
    /// is returned. For an analyzer with organization as the type, this failure can be due to an
    /// issue with creating the service-linked roles required in the member accounts of the Amazon Web Services
    /// organization.</p>
    pub status_reason: std::option::Option<crate::model::StatusReason>,
}
impl std::fmt::Debug for AnalyzerSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyzerSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_resource_analyzed", &self.last_resource_analyzed);
        formatter.field("last_resource_analyzed_at", &self.last_resource_analyzed_at);
        formatter.field("tags", &self.tags);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.finish()
    }
}
/// See [`AnalyzerSummary`](crate::model::AnalyzerSummary)
pub mod analyzer_summary {
    /// A builder for [`AnalyzerSummary`](crate::model::AnalyzerSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_resource_analyzed: std::option::Option<std::string::String>,
        pub(crate) last_resource_analyzed_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status: std::option::Option<crate::model::AnalyzerStatus>,
        pub(crate) status_reason: std::option::Option<crate::model::StatusReason>,
    }
    impl Builder {
        /// <p>The ARN of the analyzer.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the analyzer.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the analyzer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the analyzer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of analyzer, which corresponds to the zone of trust chosen for the
        /// analyzer.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of analyzer, which corresponds to the zone of trust chosen for the
        /// analyzer.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A timestamp for the time at which the analyzer was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>A timestamp for the time at which the analyzer was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The resource that was most recently analyzed by the analyzer.</p>
        pub fn last_resource_analyzed(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_resource_analyzed = Some(input.into());
            self
        }
        /// <p>The resource that was most recently analyzed by the analyzer.</p>
        pub fn set_last_resource_analyzed(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_resource_analyzed = input;
            self
        }
        /// <p>The time at which the most recently analyzed resource was analyzed.</p>
        pub fn last_resource_analyzed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_resource_analyzed_at = Some(input);
            self
        }
        /// <p>The time at which the most recently analyzed resource was analyzed.</p>
        pub fn set_last_resource_analyzed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_resource_analyzed_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags added to the analyzer.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags added to the analyzer.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The status of the analyzer. An <code>Active</code> analyzer successfully monitors
        /// supported resources and generates new findings. The analyzer is <code>Disabled</code> when
        /// a user action, such as removing trusted access for Identity and Access Management Access Analyzer from Organizations, causes
        /// the analyzer to stop generating new findings. The status is <code>Creating</code> when the
        /// analyzer creation is in progress and <code>Failed</code> when the analyzer creation has
        /// failed. </p>
        pub fn status(mut self, input: crate::model::AnalyzerStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the analyzer. An <code>Active</code> analyzer successfully monitors
        /// supported resources and generates new findings. The analyzer is <code>Disabled</code> when
        /// a user action, such as removing trusted access for Identity and Access Management Access Analyzer from Organizations, causes
        /// the analyzer to stop generating new findings. The status is <code>Creating</code> when the
        /// analyzer creation is in progress and <code>Failed</code> when the analyzer creation has
        /// failed. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnalyzerStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The <code>statusReason</code> provides more details about the current status of the
        /// analyzer. For example, if the creation for the analyzer fails, a <code>Failed</code> status
        /// is returned. For an analyzer with organization as the type, this failure can be due to an
        /// issue with creating the service-linked roles required in the member accounts of the Amazon Web Services
        /// organization.</p>
        pub fn status_reason(mut self, input: crate::model::StatusReason) -> Self {
            self.status_reason = Some(input);
            self
        }
        /// <p>The <code>statusReason</code> provides more details about the current status of the
        /// analyzer. For example, if the creation for the analyzer fails, a <code>Failed</code> status
        /// is returned. For an analyzer with organization as the type, this failure can be due to an
        /// issue with creating the service-linked roles required in the member accounts of the Amazon Web Services
        /// organization.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<crate::model::StatusReason>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyzerSummary`](crate::model::AnalyzerSummary)
        pub fn build(self) -> crate::model::AnalyzerSummary {
            crate::model::AnalyzerSummary {
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                created_at: self.created_at,
                last_resource_analyzed: self.last_resource_analyzed,
                last_resource_analyzed_at: self.last_resource_analyzed_at,
                tags: self.tags,
                status: self.status,
                status_reason: self.status_reason,
            }
        }
    }
}
impl AnalyzerSummary {
    /// Creates a new builder-style object to manufacture [`AnalyzerSummary`](crate::model::AnalyzerSummary)
    pub fn builder() -> crate::model::analyzer_summary::Builder {
        crate::model::analyzer_summary::Builder::default()
    }
}

/// <p>Provides more details about the current status of the analyzer. For example, if the
/// creation for the analyzer fails, a <code>Failed</code> status is returned. For an analyzer
/// with organization as the type, this failure can be due to an issue with creating the
/// service-linked roles required in the member accounts of the Amazon Web Services organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatusReason {
    /// <p>The reason code for the current status of the analyzer.</p>
    pub code: std::option::Option<crate::model::ReasonCode>,
}
impl std::fmt::Debug for StatusReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatusReason");
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
/// See [`StatusReason`](crate::model::StatusReason)
pub mod status_reason {
    /// A builder for [`StatusReason`](crate::model::StatusReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ReasonCode>,
    }
    impl Builder {
        /// <p>The reason code for the current status of the analyzer.</p>
        pub fn code(mut self, input: crate::model::ReasonCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The reason code for the current status of the analyzer.</p>
        pub fn set_code(mut self, input: std::option::Option<crate::model::ReasonCode>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`StatusReason`](crate::model::StatusReason)
        pub fn build(self) -> crate::model::StatusReason {
            crate::model::StatusReason { code: self.code }
        }
    }
}
impl StatusReason {
    /// Creates a new builder-style object to manufacture [`StatusReason`](crate::model::StatusReason)
    pub fn builder() -> crate::model::status_reason::Builder {
        crate::model::status_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    AwsServiceAccessDisabled,
    #[allow(missing_docs)] // documentation missing in model
    DelegatedAdministratorDeregistered,
    #[allow(missing_docs)] // documentation missing in model
    OrganizationDeleted,
    #[allow(missing_docs)] // documentation missing in model
    ServiceLinkedRoleCreationFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "AWS_SERVICE_ACCESS_DISABLED" => ReasonCode::AwsServiceAccessDisabled,
            "DELEGATED_ADMINISTRATOR_DEREGISTERED" => {
                ReasonCode::DelegatedAdministratorDeregistered
            }
            "ORGANIZATION_DELETED" => ReasonCode::OrganizationDeleted,
            "SERVICE_LINKED_ROLE_CREATION_FAILED" => ReasonCode::ServiceLinkedRoleCreationFailed,
            other => ReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReasonCode::from(s))
    }
}
impl ReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReasonCode::AwsServiceAccessDisabled => "AWS_SERVICE_ACCESS_DISABLED",
            ReasonCode::DelegatedAdministratorDeregistered => {
                "DELEGATED_ADMINISTRATOR_DEREGISTERED"
            }
            ReasonCode::OrganizationDeleted => "ORGANIZATION_DELETED",
            ReasonCode::ServiceLinkedRoleCreationFailed => "SERVICE_LINKED_ROLE_CREATION_FAILED",
            ReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS_SERVICE_ACCESS_DISABLED",
            "DELEGATED_ADMINISTRATOR_DEREGISTERED",
            "ORGANIZATION_DELETED",
            "SERVICE_LINKED_ROLE_CREATION_FAILED",
        ]
    }
}
impl AsRef<str> for ReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnalyzerStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnalyzerStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AnalyzerStatus::Active,
            "CREATING" => AnalyzerStatus::Creating,
            "DISABLED" => AnalyzerStatus::Disabled,
            "FAILED" => AnalyzerStatus::Failed,
            other => AnalyzerStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnalyzerStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnalyzerStatus::from(s))
    }
}
impl AnalyzerStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnalyzerStatus::Active => "ACTIVE",
            AnalyzerStatus::Creating => "CREATING",
            AnalyzerStatus::Disabled => "DISABLED",
            AnalyzerStatus::Failed => "FAILED",
            AnalyzerStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DISABLED", "FAILED"]
    }
}
impl AsRef<str> for AnalyzerStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Type {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    Organization,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Type {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => Type::Account,
            "ORGANIZATION" => Type::Organization,
            other => Type::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Type {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Type::from(s))
    }
}
impl Type {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Type::Account => "ACCOUNT",
            Type::Organization => "ORGANIZATION",
            Type::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT", "ORGANIZATION"]
    }
}
impl AsRef<str> for Type {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An criterion statement in an archive rule. Each archive rule may have multiple
/// criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InlineArchiveRule {
    /// <p>The name of the rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The condition and values for a criterion.</p>
    pub filter: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Criterion>,
    >,
}
impl std::fmt::Debug for InlineArchiveRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InlineArchiveRule");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}
/// See [`InlineArchiveRule`](crate::model::InlineArchiveRule)
pub mod inline_archive_rule {
    /// A builder for [`InlineArchiveRule`](crate::model::InlineArchiveRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Criterion>,
        >,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>The condition and values for a criterion.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Criterion>,
        ) -> Self {
            let mut hash_map = self.filter.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.filter = Some(hash_map);
            self
        }
        /// <p>The condition and values for a criterion.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`InlineArchiveRule`](crate::model::InlineArchiveRule)
        pub fn build(self) -> crate::model::InlineArchiveRule {
            crate::model::InlineArchiveRule {
                rule_name: self.rule_name,
                filter: self.filter,
            }
        }
    }
}
impl InlineArchiveRule {
    /// Creates a new builder-style object to manufacture [`InlineArchiveRule`](crate::model::InlineArchiveRule)
    pub fn builder() -> crate::model::inline_archive_rule::Builder {
        crate::model::inline_archive_rule::Builder::default()
    }
}

/// <p>The criteria to use in the filter that defines the archive rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Criterion {
    /// <p>An "equals" operator to match for the filter used to create the rule.</p>
    pub eq: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A "not equals" operator to match for the filter used to create the rule.</p>
    pub neq: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A "contains" operator to match for the filter used to create the rule.</p>
    pub contains: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An "exists" operator to match for the filter used to create the rule. </p>
    pub exists: std::option::Option<bool>,
}
impl std::fmt::Debug for Criterion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Criterion");
        formatter.field("eq", &self.eq);
        formatter.field("neq", &self.neq);
        formatter.field("contains", &self.contains);
        formatter.field("exists", &self.exists);
        formatter.finish()
    }
}
/// See [`Criterion`](crate::model::Criterion)
pub mod criterion {
    /// A builder for [`Criterion`](crate::model::Criterion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) eq: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) neq: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) contains: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exists: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `eq`.
        ///
        /// To override the contents of this collection use [`set_eq`](Self::set_eq).
        ///
        /// <p>An "equals" operator to match for the filter used to create the rule.</p>
        pub fn eq(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.eq.unwrap_or_default();
            v.push(input.into());
            self.eq = Some(v);
            self
        }
        /// <p>An "equals" operator to match for the filter used to create the rule.</p>
        pub fn set_eq(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.eq = input;
            self
        }
        /// Appends an item to `neq`.
        ///
        /// To override the contents of this collection use [`set_neq`](Self::set_neq).
        ///
        /// <p>A "not equals" operator to match for the filter used to create the rule.</p>
        pub fn neq(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.neq.unwrap_or_default();
            v.push(input.into());
            self.neq = Some(v);
            self
        }
        /// <p>A "not equals" operator to match for the filter used to create the rule.</p>
        pub fn set_neq(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.neq = input;
            self
        }
        /// Appends an item to `contains`.
        ///
        /// To override the contents of this collection use [`set_contains`](Self::set_contains).
        ///
        /// <p>A "contains" operator to match for the filter used to create the rule.</p>
        pub fn contains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.contains.unwrap_or_default();
            v.push(input.into());
            self.contains = Some(v);
            self
        }
        /// <p>A "contains" operator to match for the filter used to create the rule.</p>
        pub fn set_contains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.contains = input;
            self
        }
        /// <p>An "exists" operator to match for the filter used to create the rule. </p>
        pub fn exists(mut self, input: bool) -> Self {
            self.exists = Some(input);
            self
        }
        /// <p>An "exists" operator to match for the filter used to create the rule. </p>
        pub fn set_exists(mut self, input: std::option::Option<bool>) -> Self {
            self.exists = input;
            self
        }
        /// Consumes the builder and constructs a [`Criterion`](crate::model::Criterion)
        pub fn build(self) -> crate::model::Criterion {
            crate::model::Criterion {
                eq: self.eq,
                neq: self.neq,
                contains: self.contains,
                exists: self.exists,
            }
        }
    }
}
impl Criterion {
    /// Creates a new builder-style object to manufacture [`Criterion`](crate::model::Criterion)
    pub fn builder() -> crate::model::criterion::Builder {
        crate::model::criterion::Builder::default()
    }
}

/// <p>Contains information about an archive rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArchiveRuleSummary {
    /// <p>The name of the archive rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>A filter used to define the archive rule.</p>
    pub filter: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Criterion>,
    >,
    /// <p>The time at which the archive rule was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the archive rule was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ArchiveRuleSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArchiveRuleSummary");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("filter", &self.filter);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`ArchiveRuleSummary`](crate::model::ArchiveRuleSummary)
pub mod archive_rule_summary {
    /// A builder for [`ArchiveRuleSummary`](crate::model::ArchiveRuleSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Criterion>,
        >,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the archive rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the archive rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// Adds a key-value pair to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>A filter used to define the archive rule.</p>
        pub fn filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Criterion>,
        ) -> Self {
            let mut hash_map = self.filter.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.filter = Some(hash_map);
            self
        }
        /// <p>A filter used to define the archive rule.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Criterion>,
            >,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>The time at which the archive rule was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the archive rule was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time at which the archive rule was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The time at which the archive rule was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ArchiveRuleSummary`](crate::model::ArchiveRuleSummary)
        pub fn build(self) -> crate::model::ArchiveRuleSummary {
            crate::model::ArchiveRuleSummary {
                rule_name: self.rule_name,
                filter: self.filter,
                created_at: self.created_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl ArchiveRuleSummary {
    /// Creates a new builder-style object to manufacture [`ArchiveRuleSummary`](crate::model::ArchiveRuleSummary)
    pub fn builder() -> crate::model::archive_rule_summary::Builder {
        crate::model::archive_rule_summary::Builder::default()
    }
}

/// <p>A finding in a policy. Each finding is an actionable recommendation that can be used to
/// improve the policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidatePolicyFinding {
    /// <p>A localized message that explains the finding and provides guidance on how to address
    /// it.</p>
    pub finding_details: std::option::Option<std::string::String>,
    /// <p>The impact of the finding.</p>
    /// <p>Security warnings report when the policy allows access that we consider overly
    /// permissive.</p>
    /// <p>Errors report when a part of the policy is not functional.</p>
    /// <p>Warnings report non-security issues when a policy does not conform to policy writing
    /// best practices.</p>
    /// <p>Suggestions recommend stylistic improvements in the policy that do not impact
    /// access.</p>
    pub finding_type: std::option::Option<crate::model::ValidatePolicyFindingType>,
    /// <p>The issue code provides an identifier of the issue associated with this finding.</p>
    pub issue_code: std::option::Option<std::string::String>,
    /// <p>A link to additional documentation about the type of finding.</p>
    pub learn_more_link: std::option::Option<std::string::String>,
    /// <p>The list of locations in the policy document that are related to the finding. The issue
    /// code provides a summary of an issue identified by the finding.</p>
    pub locations: std::option::Option<std::vec::Vec<crate::model::Location>>,
}
impl std::fmt::Debug for ValidatePolicyFinding {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidatePolicyFinding");
        formatter.field("finding_details", &self.finding_details);
        formatter.field("finding_type", &self.finding_type);
        formatter.field("issue_code", &self.issue_code);
        formatter.field("learn_more_link", &self.learn_more_link);
        formatter.field("locations", &self.locations);
        formatter.finish()
    }
}
/// See [`ValidatePolicyFinding`](crate::model::ValidatePolicyFinding)
pub mod validate_policy_finding {
    /// A builder for [`ValidatePolicyFinding`](crate::model::ValidatePolicyFinding)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_details: std::option::Option<std::string::String>,
        pub(crate) finding_type: std::option::Option<crate::model::ValidatePolicyFindingType>,
        pub(crate) issue_code: std::option::Option<std::string::String>,
        pub(crate) learn_more_link: std::option::Option<std::string::String>,
        pub(crate) locations: std::option::Option<std::vec::Vec<crate::model::Location>>,
    }
    impl Builder {
        /// <p>A localized message that explains the finding and provides guidance on how to address
        /// it.</p>
        pub fn finding_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.finding_details = Some(input.into());
            self
        }
        /// <p>A localized message that explains the finding and provides guidance on how to address
        /// it.</p>
        pub fn set_finding_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.finding_details = input;
            self
        }
        /// <p>The impact of the finding.</p>
        /// <p>Security warnings report when the policy allows access that we consider overly
        /// permissive.</p>
        /// <p>Errors report when a part of the policy is not functional.</p>
        /// <p>Warnings report non-security issues when a policy does not conform to policy writing
        /// best practices.</p>
        /// <p>Suggestions recommend stylistic improvements in the policy that do not impact
        /// access.</p>
        pub fn finding_type(mut self, input: crate::model::ValidatePolicyFindingType) -> Self {
            self.finding_type = Some(input);
            self
        }
        /// <p>The impact of the finding.</p>
        /// <p>Security warnings report when the policy allows access that we consider overly
        /// permissive.</p>
        /// <p>Errors report when a part of the policy is not functional.</p>
        /// <p>Warnings report non-security issues when a policy does not conform to policy writing
        /// best practices.</p>
        /// <p>Suggestions recommend stylistic improvements in the policy that do not impact
        /// access.</p>
        pub fn set_finding_type(
            mut self,
            input: std::option::Option<crate::model::ValidatePolicyFindingType>,
        ) -> Self {
            self.finding_type = input;
            self
        }
        /// <p>The issue code provides an identifier of the issue associated with this finding.</p>
        pub fn issue_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.issue_code = Some(input.into());
            self
        }
        /// <p>The issue code provides an identifier of the issue associated with this finding.</p>
        pub fn set_issue_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issue_code = input;
            self
        }
        /// <p>A link to additional documentation about the type of finding.</p>
        pub fn learn_more_link(mut self, input: impl Into<std::string::String>) -> Self {
            self.learn_more_link = Some(input.into());
            self
        }
        /// <p>A link to additional documentation about the type of finding.</p>
        pub fn set_learn_more_link(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.learn_more_link = input;
            self
        }
        /// Appends an item to `locations`.
        ///
        /// To override the contents of this collection use [`set_locations`](Self::set_locations).
        ///
        /// <p>The list of locations in the policy document that are related to the finding. The issue
        /// code provides a summary of an issue identified by the finding.</p>
        pub fn locations(mut self, input: impl Into<crate::model::Location>) -> Self {
            let mut v = self.locations.unwrap_or_default();
            v.push(input.into());
            self.locations = Some(v);
            self
        }
        /// <p>The list of locations in the policy document that are related to the finding. The issue
        /// code provides a summary of an issue identified by the finding.</p>
        pub fn set_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Location>>,
        ) -> Self {
            self.locations = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidatePolicyFinding`](crate::model::ValidatePolicyFinding)
        pub fn build(self) -> crate::model::ValidatePolicyFinding {
            crate::model::ValidatePolicyFinding {
                finding_details: self.finding_details,
                finding_type: self.finding_type,
                issue_code: self.issue_code,
                learn_more_link: self.learn_more_link,
                locations: self.locations,
            }
        }
    }
}
impl ValidatePolicyFinding {
    /// Creates a new builder-style object to manufacture [`ValidatePolicyFinding`](crate::model::ValidatePolicyFinding)
    pub fn builder() -> crate::model::validate_policy_finding::Builder {
        crate::model::validate_policy_finding::Builder::default()
    }
}

/// <p>A location in a policy that is represented as a path through the JSON representation and
/// a corresponding span.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Location {
    /// <p>A path in a policy, represented as a sequence of path elements.</p>
    pub path: std::option::Option<std::vec::Vec<crate::model::PathElement>>,
    /// <p>A span in a policy.</p>
    pub span: std::option::Option<crate::model::Span>,
}
impl std::fmt::Debug for Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Location");
        formatter.field("path", &self.path);
        formatter.field("span", &self.span);
        formatter.finish()
    }
}
/// See [`Location`](crate::model::Location)
pub mod location {
    /// A builder for [`Location`](crate::model::Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::vec::Vec<crate::model::PathElement>>,
        pub(crate) span: std::option::Option<crate::model::Span>,
    }
    impl Builder {
        /// Appends an item to `path`.
        ///
        /// To override the contents of this collection use [`set_path`](Self::set_path).
        ///
        /// <p>A path in a policy, represented as a sequence of path elements.</p>
        pub fn path(mut self, input: impl Into<crate::model::PathElement>) -> Self {
            let mut v = self.path.unwrap_or_default();
            v.push(input.into());
            self.path = Some(v);
            self
        }
        /// <p>A path in a policy, represented as a sequence of path elements.</p>
        pub fn set_path(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PathElement>>,
        ) -> Self {
            self.path = input;
            self
        }
        /// <p>A span in a policy.</p>
        pub fn span(mut self, input: crate::model::Span) -> Self {
            self.span = Some(input);
            self
        }
        /// <p>A span in a policy.</p>
        pub fn set_span(mut self, input: std::option::Option<crate::model::Span>) -> Self {
            self.span = input;
            self
        }
        /// Consumes the builder and constructs a [`Location`](crate::model::Location)
        pub fn build(self) -> crate::model::Location {
            crate::model::Location {
                path: self.path,
                span: self.span,
            }
        }
    }
}
impl Location {
    /// Creates a new builder-style object to manufacture [`Location`](crate::model::Location)
    pub fn builder() -> crate::model::location::Builder {
        crate::model::location::Builder::default()
    }
}

/// <p>A span in a policy. The span consists of a start position (inclusive) and end position
/// (exclusive).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Span {
    /// <p>The start position of the span (inclusive).</p>
    pub start: std::option::Option<crate::model::Position>,
    /// <p>The end position of the span (exclusive).</p>
    pub end: std::option::Option<crate::model::Position>,
}
impl std::fmt::Debug for Span {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Span");
        formatter.field("start", &self.start);
        formatter.field("end", &self.end);
        formatter.finish()
    }
}
/// See [`Span`](crate::model::Span)
pub mod span {
    /// A builder for [`Span`](crate::model::Span)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start: std::option::Option<crate::model::Position>,
        pub(crate) end: std::option::Option<crate::model::Position>,
    }
    impl Builder {
        /// <p>The start position of the span (inclusive).</p>
        pub fn start(mut self, input: crate::model::Position) -> Self {
            self.start = Some(input);
            self
        }
        /// <p>The start position of the span (inclusive).</p>
        pub fn set_start(mut self, input: std::option::Option<crate::model::Position>) -> Self {
            self.start = input;
            self
        }
        /// <p>The end position of the span (exclusive).</p>
        pub fn end(mut self, input: crate::model::Position) -> Self {
            self.end = Some(input);
            self
        }
        /// <p>The end position of the span (exclusive).</p>
        pub fn set_end(mut self, input: std::option::Option<crate::model::Position>) -> Self {
            self.end = input;
            self
        }
        /// Consumes the builder and constructs a [`Span`](crate::model::Span)
        pub fn build(self) -> crate::model::Span {
            crate::model::Span {
                start: self.start,
                end: self.end,
            }
        }
    }
}
impl Span {
    /// Creates a new builder-style object to manufacture [`Span`](crate::model::Span)
    pub fn builder() -> crate::model::span::Builder {
        crate::model::span::Builder::default()
    }
}

/// <p>A position in a policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Position {
    /// <p>The line of the position, starting from 1.</p>
    pub line: std::option::Option<i32>,
    /// <p>The column of the position, starting from 0.</p>
    pub column: std::option::Option<i32>,
    /// <p>The offset within the policy that corresponds to the position, starting from 0.</p>
    pub offset: std::option::Option<i32>,
}
impl std::fmt::Debug for Position {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Position");
        formatter.field("line", &self.line);
        formatter.field("column", &self.column);
        formatter.field("offset", &self.offset);
        formatter.finish()
    }
}
/// See [`Position`](crate::model::Position)
pub mod position {
    /// A builder for [`Position`](crate::model::Position)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) line: std::option::Option<i32>,
        pub(crate) column: std::option::Option<i32>,
        pub(crate) offset: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The line of the position, starting from 1.</p>
        pub fn line(mut self, input: i32) -> Self {
            self.line = Some(input);
            self
        }
        /// <p>The line of the position, starting from 1.</p>
        pub fn set_line(mut self, input: std::option::Option<i32>) -> Self {
            self.line = input;
            self
        }
        /// <p>The column of the position, starting from 0.</p>
        pub fn column(mut self, input: i32) -> Self {
            self.column = Some(input);
            self
        }
        /// <p>The column of the position, starting from 0.</p>
        pub fn set_column(mut self, input: std::option::Option<i32>) -> Self {
            self.column = input;
            self
        }
        /// <p>The offset within the policy that corresponds to the position, starting from 0.</p>
        pub fn offset(mut self, input: i32) -> Self {
            self.offset = Some(input);
            self
        }
        /// <p>The offset within the policy that corresponds to the position, starting from 0.</p>
        pub fn set_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.offset = input;
            self
        }
        /// Consumes the builder and constructs a [`Position`](crate::model::Position)
        pub fn build(self) -> crate::model::Position {
            crate::model::Position {
                line: self.line,
                column: self.column,
                offset: self.offset,
            }
        }
    }
}
impl Position {
    /// Creates a new builder-style object to manufacture [`Position`](crate::model::Position)
    pub fn builder() -> crate::model::position::Builder {
        crate::model::position::Builder::default()
    }
}

/// <p>A single element in a path through the JSON representation of a policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum PathElement {
    /// <p>Refers to an index in a JSON array.</p>
    Index(i32),
    /// <p>Refers to a key in a JSON object.</p>
    Key(std::string::String),
    /// <p>Refers to a substring of a literal string in a JSON object.</p>
    Substring(crate::model::Substring),
    /// <p>Refers to the value associated with a given key in a JSON object.</p>
    Value(std::string::String),
}
impl PathElement {
    /// Tries to convert the enum instance into [`Index`](crate::model::PathElement::Index), extracting the inner [`i32`](i32).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_index(&self) -> std::result::Result<&i32, &Self> {
        if let PathElement::Index(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Index`](crate::model::PathElement::Index).
    pub fn is_index(&self) -> bool {
        self.as_index().is_ok()
    }
    /// Tries to convert the enum instance into [`Key`](crate::model::PathElement::Key), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_key(&self) -> std::result::Result<&std::string::String, &Self> {
        if let PathElement::Key(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Key`](crate::model::PathElement::Key).
    pub fn is_key(&self) -> bool {
        self.as_key().is_ok()
    }
    /// Tries to convert the enum instance into [`Substring`](crate::model::PathElement::Substring), extracting the inner [`Substring`](crate::model::Substring).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_substring(&self) -> std::result::Result<&crate::model::Substring, &Self> {
        if let PathElement::Substring(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Substring`](crate::model::PathElement::Substring).
    pub fn is_substring(&self) -> bool {
        self.as_substring().is_ok()
    }
    /// Tries to convert the enum instance into [`Value`](crate::model::PathElement::Value), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let PathElement::Value(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Value`](crate::model::PathElement::Value).
    pub fn is_value(&self) -> bool {
        self.as_value().is_ok()
    }
}

/// <p>A reference to a substring of a literal string in a JSON document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Substring {
    /// <p>The start index of the substring, starting from 0.</p>
    pub start: std::option::Option<i32>,
    /// <p>The length of the substring.</p>
    pub length: std::option::Option<i32>,
}
impl std::fmt::Debug for Substring {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Substring");
        formatter.field("start", &self.start);
        formatter.field("length", &self.length);
        formatter.finish()
    }
}
/// See [`Substring`](crate::model::Substring)
pub mod substring {
    /// A builder for [`Substring`](crate::model::Substring)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start: std::option::Option<i32>,
        pub(crate) length: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The start index of the substring, starting from 0.</p>
        pub fn start(mut self, input: i32) -> Self {
            self.start = Some(input);
            self
        }
        /// <p>The start index of the substring, starting from 0.</p>
        pub fn set_start(mut self, input: std::option::Option<i32>) -> Self {
            self.start = input;
            self
        }
        /// <p>The length of the substring.</p>
        pub fn length(mut self, input: i32) -> Self {
            self.length = Some(input);
            self
        }
        /// <p>The length of the substring.</p>
        pub fn set_length(mut self, input: std::option::Option<i32>) -> Self {
            self.length = input;
            self
        }
        /// Consumes the builder and constructs a [`Substring`](crate::model::Substring)
        pub fn build(self) -> crate::model::Substring {
            crate::model::Substring {
                start: self.start,
                length: self.length,
            }
        }
    }
}
impl Substring {
    /// Creates a new builder-style object to manufacture [`Substring`](crate::model::Substring)
    pub fn builder() -> crate::model::substring::Builder {
        crate::model::substring::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidatePolicyFindingType {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    SecurityWarning,
    #[allow(missing_docs)] // documentation missing in model
    Suggestion,
    #[allow(missing_docs)] // documentation missing in model
    Warning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidatePolicyFindingType {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => ValidatePolicyFindingType::Error,
            "SECURITY_WARNING" => ValidatePolicyFindingType::SecurityWarning,
            "SUGGESTION" => ValidatePolicyFindingType::Suggestion,
            "WARNING" => ValidatePolicyFindingType::Warning,
            other => ValidatePolicyFindingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidatePolicyFindingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidatePolicyFindingType::from(s))
    }
}
impl ValidatePolicyFindingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidatePolicyFindingType::Error => "ERROR",
            ValidatePolicyFindingType::SecurityWarning => "SECURITY_WARNING",
            ValidatePolicyFindingType::Suggestion => "SUGGESTION",
            ValidatePolicyFindingType::Warning => "WARNING",
            ValidatePolicyFindingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "SECURITY_WARNING", "SUGGESTION", "WARNING"]
    }
}
impl AsRef<str> for ValidatePolicyFindingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyType {
    #[allow(missing_docs)] // documentation missing in model
    IdentityPolicy,
    #[allow(missing_docs)] // documentation missing in model
    ResourcePolicy,
    #[allow(missing_docs)] // documentation missing in model
    ServiceControlPolicy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyType {
    fn from(s: &str) -> Self {
        match s {
            "IDENTITY_POLICY" => PolicyType::IdentityPolicy,
            "RESOURCE_POLICY" => PolicyType::ResourcePolicy,
            "SERVICE_CONTROL_POLICY" => PolicyType::ServiceControlPolicy,
            other => PolicyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyType::from(s))
    }
}
impl PolicyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyType::IdentityPolicy => "IDENTITY_POLICY",
            PolicyType::ResourcePolicy => "RESOURCE_POLICY",
            PolicyType::ServiceControlPolicy => "SERVICE_CONTROL_POLICY",
            PolicyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "IDENTITY_POLICY",
            "RESOURCE_POLICY",
            "SERVICE_CONTROL_POLICY",
        ]
    }
}
impl AsRef<str> for PolicyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Locale {
    #[allow(missing_docs)] // documentation missing in model
    De,
    #[allow(missing_docs)] // documentation missing in model
    En,
    #[allow(missing_docs)] // documentation missing in model
    Es,
    #[allow(missing_docs)] // documentation missing in model
    Fr,
    #[allow(missing_docs)] // documentation missing in model
    It,
    #[allow(missing_docs)] // documentation missing in model
    Ja,
    #[allow(missing_docs)] // documentation missing in model
    Ko,
    #[allow(missing_docs)] // documentation missing in model
    PtBr,
    #[allow(missing_docs)] // documentation missing in model
    ZhCn,
    #[allow(missing_docs)] // documentation missing in model
    ZhTw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Locale {
    fn from(s: &str) -> Self {
        match s {
            "DE" => Locale::De,
            "EN" => Locale::En,
            "ES" => Locale::Es,
            "FR" => Locale::Fr,
            "IT" => Locale::It,
            "JA" => Locale::Ja,
            "KO" => Locale::Ko,
            "PT_BR" => Locale::PtBr,
            "ZH_CN" => Locale::ZhCn,
            "ZH_TW" => Locale::ZhTw,
            other => Locale::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Locale {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Locale::from(s))
    }
}
impl Locale {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Locale::De => "DE",
            Locale::En => "EN",
            Locale::Es => "ES",
            Locale::Fr => "FR",
            Locale::It => "IT",
            Locale::Ja => "JA",
            Locale::Ko => "KO",
            Locale::PtBr => "PT_BR",
            Locale::ZhCn => "ZH_CN",
            Locale::ZhTw => "ZH_TW",
            Locale::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DE", "EN", "ES", "FR", "IT", "JA", "KO", "PT_BR", "ZH_CN", "ZH_TW",
        ]
    }
}
impl AsRef<str> for Locale {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingStatusUpdate {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Archived,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingStatusUpdate {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => FindingStatusUpdate::Active,
            "ARCHIVED" => FindingStatusUpdate::Archived,
            other => FindingStatusUpdate::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingStatusUpdate {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingStatusUpdate::from(s))
    }
}
impl FindingStatusUpdate {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingStatusUpdate::Active => "ACTIVE",
            FindingStatusUpdate::Archived => "ARCHIVED",
            FindingStatusUpdate::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "ARCHIVED"]
    }
}
impl AsRef<str> for FindingStatusUpdate {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about CloudTrail access.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudTrailDetails {
    /// <p>A <code>Trail</code> object that contains settings for a trail.</p>
    pub trails: std::option::Option<std::vec::Vec<crate::model::Trail>>,
    /// <p>The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and
    /// service last accessed information.</p>
    pub access_role: std::option::Option<std::string::String>,
    /// <p>The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events
    /// with a timestamp before this time are not considered to generate a policy.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
    /// a timestamp after this time are not considered to generate a policy. If this is not
    /// included in the request, the default value is the current time.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for CloudTrailDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudTrailDetails");
        formatter.field("trails", &self.trails);
        formatter.field("access_role", &self.access_role);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`CloudTrailDetails`](crate::model::CloudTrailDetails)
pub mod cloud_trail_details {
    /// A builder for [`CloudTrailDetails`](crate::model::CloudTrailDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trails: std::option::Option<std::vec::Vec<crate::model::Trail>>,
        pub(crate) access_role: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// Appends an item to `trails`.
        ///
        /// To override the contents of this collection use [`set_trails`](Self::set_trails).
        ///
        /// <p>A <code>Trail</code> object that contains settings for a trail.</p>
        pub fn trails(mut self, input: impl Into<crate::model::Trail>) -> Self {
            let mut v = self.trails.unwrap_or_default();
            v.push(input.into());
            self.trails = Some(v);
            self
        }
        /// <p>A <code>Trail</code> object that contains settings for a trail.</p>
        pub fn set_trails(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Trail>>,
        ) -> Self {
            self.trails = input;
            self
        }
        /// <p>The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and
        /// service last accessed information.</p>
        pub fn access_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_role = Some(input.into());
            self
        }
        /// <p>The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and
        /// service last accessed information.</p>
        pub fn set_access_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_role = input;
            self
        }
        /// <p>The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events
        /// with a timestamp before this time are not considered to generate a policy.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events
        /// with a timestamp before this time are not considered to generate a policy.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
        /// a timestamp after this time are not considered to generate a policy. If this is not
        /// included in the request, the default value is the current time.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
        /// a timestamp after this time are not considered to generate a policy. If this is not
        /// included in the request, the default value is the current time.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudTrailDetails`](crate::model::CloudTrailDetails)
        pub fn build(self) -> crate::model::CloudTrailDetails {
            crate::model::CloudTrailDetails {
                trails: self.trails,
                access_role: self.access_role,
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl CloudTrailDetails {
    /// Creates a new builder-style object to manufacture [`CloudTrailDetails`](crate::model::CloudTrailDetails)
    pub fn builder() -> crate::model::cloud_trail_details::Builder {
        crate::model::cloud_trail_details::Builder::default()
    }
}

/// <p>Contains details about the CloudTrail trail being analyzed to generate a policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Trail {
    /// <p>Specifies the ARN of the trail. The format of a trail ARN is
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.</p>
    pub cloud_trail_arn: std::option::Option<std::string::String>,
    /// <p>A list of regions to get CloudTrail data from and analyze to generate a policy.</p>
    pub regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Possible values are <code>true</code> or <code>false</code>. If set to
    /// <code>true</code>, IAM Access Analyzer retrieves CloudTrail data from all regions to analyze and
    /// generate a policy.</p>
    pub all_regions: std::option::Option<bool>,
}
impl std::fmt::Debug for Trail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Trail");
        formatter.field("cloud_trail_arn", &self.cloud_trail_arn);
        formatter.field("regions", &self.regions);
        formatter.field("all_regions", &self.all_regions);
        formatter.finish()
    }
}
/// See [`Trail`](crate::model::Trail)
pub mod trail {
    /// A builder for [`Trail`](crate::model::Trail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_trail_arn: std::option::Option<std::string::String>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) all_regions: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies the ARN of the trail. The format of a trail ARN is
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.</p>
        pub fn cloud_trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_trail_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail. The format of a trail ARN is
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.</p>
        pub fn set_cloud_trail_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_trail_arn = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>A list of regions to get CloudTrail data from and analyze to generate a policy.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>A list of regions to get CloudTrail data from and analyze to generate a policy.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// <p>Possible values are <code>true</code> or <code>false</code>. If set to
        /// <code>true</code>, IAM Access Analyzer retrieves CloudTrail data from all regions to analyze and
        /// generate a policy.</p>
        pub fn all_regions(mut self, input: bool) -> Self {
            self.all_regions = Some(input);
            self
        }
        /// <p>Possible values are <code>true</code> or <code>false</code>. If set to
        /// <code>true</code>, IAM Access Analyzer retrieves CloudTrail data from all regions to analyze and
        /// generate a policy.</p>
        pub fn set_all_regions(mut self, input: std::option::Option<bool>) -> Self {
            self.all_regions = input;
            self
        }
        /// Consumes the builder and constructs a [`Trail`](crate::model::Trail)
        pub fn build(self) -> crate::model::Trail {
            crate::model::Trail {
                cloud_trail_arn: self.cloud_trail_arn,
                regions: self.regions,
                all_regions: self.all_regions,
            }
        }
    }
}
impl Trail {
    /// Creates a new builder-style object to manufacture [`Trail`](crate::model::Trail)
    pub fn builder() -> crate::model::trail::Builder {
        crate::model::trail::Builder::default()
    }
}

/// <p>Contains the ARN details about the IAM entity for which the policy is
/// generated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyGenerationDetails {
    /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>
    pub principal_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyGenerationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyGenerationDetails");
        formatter.field("principal_arn", &self.principal_arn);
        formatter.finish()
    }
}
/// See [`PolicyGenerationDetails`](crate::model::PolicyGenerationDetails)
pub mod policy_generation_details {
    /// A builder for [`PolicyGenerationDetails`](crate::model::PolicyGenerationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.principal_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyGenerationDetails`](crate::model::PolicyGenerationDetails)
        pub fn build(self) -> crate::model::PolicyGenerationDetails {
            crate::model::PolicyGenerationDetails {
                principal_arn: self.principal_arn,
            }
        }
    }
}
impl PolicyGenerationDetails {
    /// Creates a new builder-style object to manufacture [`PolicyGenerationDetails`](crate::model::PolicyGenerationDetails)
    pub fn builder() -> crate::model::policy_generation_details::Builder {
        crate::model::policy_generation_details::Builder::default()
    }
}

/// <p>Contains details about the policy generation status and properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyGeneration {
    /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
    /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
    /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
    /// the policy generation request.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>
    pub principal_arn: std::option::Option<std::string::String>,
    /// <p>The status of the policy generation request.</p>
    pub status: std::option::Option<crate::model::JobStatus>,
    /// <p>A timestamp of when the policy generation started.</p>
    pub started_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp of when the policy generation was completed.</p>
    pub completed_on: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for PolicyGeneration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyGeneration");
        formatter.field("job_id", &self.job_id);
        formatter.field("principal_arn", &self.principal_arn);
        formatter.field("status", &self.status);
        formatter.field("started_on", &self.started_on);
        formatter.field("completed_on", &self.completed_on);
        formatter.finish()
    }
}
/// See [`PolicyGeneration`](crate::model::PolicyGeneration)
pub mod policy_generation {
    /// A builder for [`PolicyGeneration`](crate::model::PolicyGeneration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) principal_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
        pub(crate) started_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_on: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
        /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
        /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
        /// the policy generation request.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
        /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
        /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
        /// the policy generation request.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.principal_arn = input;
            self
        }
        /// <p>The status of the policy generation request.</p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the policy generation request.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>A timestamp of when the policy generation started.</p>
        pub fn started_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_on = Some(input);
            self
        }
        /// <p>A timestamp of when the policy generation started.</p>
        pub fn set_started_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_on = input;
            self
        }
        /// <p>A timestamp of when the policy generation was completed.</p>
        pub fn completed_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_on = Some(input);
            self
        }
        /// <p>A timestamp of when the policy generation was completed.</p>
        pub fn set_completed_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_on = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyGeneration`](crate::model::PolicyGeneration)
        pub fn build(self) -> crate::model::PolicyGeneration {
            crate::model::PolicyGeneration {
                job_id: self.job_id,
                principal_arn: self.principal_arn,
                status: self.status,
                started_on: self.started_on,
                completed_on: self.completed_on,
            }
        }
    }
}
impl PolicyGeneration {
    /// Creates a new builder-style object to manufacture [`PolicyGeneration`](crate::model::PolicyGeneration)
    pub fn builder() -> crate::model::policy_generation::Builder {
        crate::model::policy_generation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => JobStatus::Canceled,
            "FAILED" => JobStatus::Failed,
            "IN_PROGRESS" => JobStatus::InProgress,
            "SUCCEEDED" => JobStatus::Succeeded,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Canceled => "CANCELED",
            JobStatus::Failed => "FAILED",
            JobStatus::InProgress => "IN_PROGRESS",
            JobStatus::Succeeded => "SUCCEEDED",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELED", "FAILED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingSummary {
    /// <p>The ID of the finding.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The external principal that has access to a resource within the zone of trust.</p>
    pub principal:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The action in the analyzed policy statement that an external principal has permission to
    /// use.</p>
    pub action: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The resource that the external principal has access to.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>Indicates whether the finding reports a resource that has a policy that allows public
    /// access.</p>
    pub is_public: std::option::Option<bool>,
    /// <p>The type of the resource that the external principal has access to.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The condition in the analyzed policy statement that resulted in a finding.</p>
    pub condition:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The time at which the finding was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the resource-based policy that generated the finding was
    /// analyzed.</p>
    pub analyzed_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the finding was most recently updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the finding.</p>
    pub status: std::option::Option<crate::model::FindingStatus>,
    /// <p>The Amazon Web Services account ID that owns the resource.</p>
    pub resource_owner_account: std::option::Option<std::string::String>,
    /// <p>The error that resulted in an Error finding.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The sources of the finding. This indicates how the access that generated the finding is
    /// granted. It is populated for Amazon S3 bucket findings.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::FindingSource>>,
}
impl std::fmt::Debug for FindingSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingSummary");
        formatter.field("id", &self.id);
        formatter.field("principal", &self.principal);
        formatter.field("action", &self.action);
        formatter.field("resource", &self.resource);
        formatter.field("is_public", &self.is_public);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("condition", &self.condition);
        formatter.field("created_at", &self.created_at);
        formatter.field("analyzed_at", &self.analyzed_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("status", &self.status);
        formatter.field("resource_owner_account", &self.resource_owner_account);
        formatter.field("error", &self.error);
        formatter.field("sources", &self.sources);
        formatter.finish()
    }
}
/// See [`FindingSummary`](crate::model::FindingSummary)
pub mod finding_summary {
    /// A builder for [`FindingSummary`](crate::model::FindingSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) action: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) is_public: std::option::Option<bool>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) condition: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) analyzed_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::FindingStatus>,
        pub(crate) resource_owner_account: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::FindingSource>>,
    }
    impl Builder {
        /// <p>The ID of the finding.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the finding.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `principal`.
        ///
        /// To override the contents of this collection use [`set_principal`](Self::set_principal).
        ///
        /// <p>The external principal that has access to a resource within the zone of trust.</p>
        pub fn principal(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.principal.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.principal = Some(hash_map);
            self
        }
        /// <p>The external principal that has access to a resource within the zone of trust.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.principal = input;
            self
        }
        /// Appends an item to `action`.
        ///
        /// To override the contents of this collection use [`set_action`](Self::set_action).
        ///
        /// <p>The action in the analyzed policy statement that an external principal has permission to
        /// use.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.action.unwrap_or_default();
            v.push(input.into());
            self.action = Some(v);
            self
        }
        /// <p>The action in the analyzed policy statement that an external principal has permission to
        /// use.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The resource that the external principal has access to.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The resource that the external principal has access to.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>Indicates whether the finding reports a resource that has a policy that allows public
        /// access.</p>
        pub fn is_public(mut self, input: bool) -> Self {
            self.is_public = Some(input);
            self
        }
        /// <p>Indicates whether the finding reports a resource that has a policy that allows public
        /// access.</p>
        pub fn set_is_public(mut self, input: std::option::Option<bool>) -> Self {
            self.is_public = input;
            self
        }
        /// <p>The type of the resource that the external principal has access to.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the resource that the external principal has access to.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Adds a key-value pair to `condition`.
        ///
        /// To override the contents of this collection use [`set_condition`](Self::set_condition).
        ///
        /// <p>The condition in the analyzed policy statement that resulted in a finding.</p>
        pub fn condition(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.condition.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.condition = Some(hash_map);
            self
        }
        /// <p>The condition in the analyzed policy statement that resulted in a finding.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.condition = input;
            self
        }
        /// <p>The time at which the finding was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the finding was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time at which the resource-based policy that generated the finding was
        /// analyzed.</p>
        pub fn analyzed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.analyzed_at = Some(input);
            self
        }
        /// <p>The time at which the resource-based policy that generated the finding was
        /// analyzed.</p>
        pub fn set_analyzed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.analyzed_at = input;
            self
        }
        /// <p>The time at which the finding was most recently updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The time at which the finding was most recently updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The status of the finding.</p>
        pub fn status(mut self, input: crate::model::FindingStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the finding.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FindingStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services account ID that owns the resource.</p>
        pub fn resource_owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner_account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the resource.</p>
        pub fn set_resource_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner_account = input;
            self
        }
        /// <p>The error that resulted in an Error finding.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error that resulted in an Error finding.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the finding. This indicates how the access that generated the finding is
        /// granted. It is populated for Amazon S3 bucket findings.</p>
        pub fn sources(mut self, input: impl Into<crate::model::FindingSource>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the finding. This indicates how the access that generated the finding is
        /// granted. It is populated for Amazon S3 bucket findings.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FindingSource>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingSummary`](crate::model::FindingSummary)
        pub fn build(self) -> crate::model::FindingSummary {
            crate::model::FindingSummary {
                id: self.id,
                principal: self.principal,
                action: self.action,
                resource: self.resource,
                is_public: self.is_public,
                resource_type: self.resource_type,
                condition: self.condition,
                created_at: self.created_at,
                analyzed_at: self.analyzed_at,
                updated_at: self.updated_at,
                status: self.status,
                resource_owner_account: self.resource_owner_account,
                error: self.error,
                sources: self.sources,
            }
        }
    }
}
impl FindingSummary {
    /// Creates a new builder-style object to manufacture [`FindingSummary`](crate::model::FindingSummary)
    pub fn builder() -> crate::model::finding_summary::Builder {
        crate::model::finding_summary::Builder::default()
    }
}

/// <p>The source of the finding. This indicates how the access that generated the finding is
/// granted. It is populated for Amazon S3 bucket findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingSource {
    /// <p>Indicates the type of access that generated the finding.</p>
    pub r#type: std::option::Option<crate::model::FindingSourceType>,
    /// <p>Includes details about how the access that generated the finding is granted. This is
    /// populated for Amazon S3 bucket findings.</p>
    pub detail: std::option::Option<crate::model::FindingSourceDetail>,
}
impl std::fmt::Debug for FindingSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingSource");
        formatter.field("r#type", &self.r#type);
        formatter.field("detail", &self.detail);
        formatter.finish()
    }
}
/// See [`FindingSource`](crate::model::FindingSource)
pub mod finding_source {
    /// A builder for [`FindingSource`](crate::model::FindingSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::FindingSourceType>,
        pub(crate) detail: std::option::Option<crate::model::FindingSourceDetail>,
    }
    impl Builder {
        /// <p>Indicates the type of access that generated the finding.</p>
        pub fn r#type(mut self, input: crate::model::FindingSourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Indicates the type of access that generated the finding.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::FindingSourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Includes details about how the access that generated the finding is granted. This is
        /// populated for Amazon S3 bucket findings.</p>
        pub fn detail(mut self, input: crate::model::FindingSourceDetail) -> Self {
            self.detail = Some(input);
            self
        }
        /// <p>Includes details about how the access that generated the finding is granted. This is
        /// populated for Amazon S3 bucket findings.</p>
        pub fn set_detail(
            mut self,
            input: std::option::Option<crate::model::FindingSourceDetail>,
        ) -> Self {
            self.detail = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingSource`](crate::model::FindingSource)
        pub fn build(self) -> crate::model::FindingSource {
            crate::model::FindingSource {
                r#type: self.r#type,
                detail: self.detail,
            }
        }
    }
}
impl FindingSource {
    /// Creates a new builder-style object to manufacture [`FindingSource`](crate::model::FindingSource)
    pub fn builder() -> crate::model::finding_source::Builder {
        crate::model::finding_source::Builder::default()
    }
}

/// <p>Includes details about how the access that generated the finding is granted. This is
/// populated for Amazon S3 bucket findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingSourceDetail {
    /// <p>The ARN of the access point that generated the finding. The ARN format depends on
    /// whether the ARN represents an access point or a multi-region access point.</p>
    pub access_point_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FindingSourceDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingSourceDetail");
        formatter.field("access_point_arn", &self.access_point_arn);
        formatter.finish()
    }
}
/// See [`FindingSourceDetail`](crate::model::FindingSourceDetail)
pub mod finding_source_detail {
    /// A builder for [`FindingSourceDetail`](crate::model::FindingSourceDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_point_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the access point that generated the finding. The ARN format depends on
        /// whether the ARN represents an access point or a multi-region access point.</p>
        pub fn access_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the access point that generated the finding. The ARN format depends on
        /// whether the ARN represents an access point or a multi-region access point.</p>
        pub fn set_access_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingSourceDetail`](crate::model::FindingSourceDetail)
        pub fn build(self) -> crate::model::FindingSourceDetail {
            crate::model::FindingSourceDetail {
                access_point_arn: self.access_point_arn,
            }
        }
    }
}
impl FindingSourceDetail {
    /// Creates a new builder-style object to manufacture [`FindingSourceDetail`](crate::model::FindingSourceDetail)
    pub fn builder() -> crate::model::finding_source_detail::Builder {
        crate::model::finding_source_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingSourceType {
    #[allow(missing_docs)] // documentation missing in model
    BucketAcl,
    #[allow(missing_docs)] // documentation missing in model
    Policy,
    #[allow(missing_docs)] // documentation missing in model
    S3AccessPoint,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingSourceType {
    fn from(s: &str) -> Self {
        match s {
            "BUCKET_ACL" => FindingSourceType::BucketAcl,
            "POLICY" => FindingSourceType::Policy,
            "S3_ACCESS_POINT" => FindingSourceType::S3AccessPoint,
            other => FindingSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingSourceType::from(s))
    }
}
impl FindingSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingSourceType::BucketAcl => "BUCKET_ACL",
            FindingSourceType::Policy => "POLICY",
            FindingSourceType::S3AccessPoint => "S3_ACCESS_POINT",
            FindingSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BUCKET_ACL", "POLICY", "S3_ACCESS_POINT"]
    }
}
impl AsRef<str> for FindingSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Archived,
    #[allow(missing_docs)] // documentation missing in model
    Resolved,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => FindingStatus::Active,
            "ARCHIVED" => FindingStatus::Archived,
            "RESOLVED" => FindingStatus::Resolved,
            other => FindingStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingStatus::from(s))
    }
}
impl FindingStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingStatus::Active => "ACTIVE",
            FindingStatus::Archived => "ARCHIVED",
            FindingStatus::Resolved => "RESOLVED",
            FindingStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "ARCHIVED", "RESOLVED"]
    }
}
impl AsRef<str> for FindingStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    AwsIamRole,
    #[allow(missing_docs)] // documentation missing in model
    AwsKmsKey,
    #[allow(missing_docs)] // documentation missing in model
    AwsLambdaFunction,
    #[allow(missing_docs)] // documentation missing in model
    AwsLambdaLayerversion,
    #[allow(missing_docs)] // documentation missing in model
    AwsS3Bucket,
    #[allow(missing_docs)] // documentation missing in model
    AwsSqsQueue,
    #[allow(missing_docs)] // documentation missing in model
    AwsSecretsmanagerSecret,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "AWS::IAM::Role" => ResourceType::AwsIamRole,
            "AWS::KMS::Key" => ResourceType::AwsKmsKey,
            "AWS::Lambda::Function" => ResourceType::AwsLambdaFunction,
            "AWS::Lambda::LayerVersion" => ResourceType::AwsLambdaLayerversion,
            "AWS::S3::Bucket" => ResourceType::AwsS3Bucket,
            "AWS::SQS::Queue" => ResourceType::AwsSqsQueue,
            "AWS::SecretsManager::Secret" => ResourceType::AwsSecretsmanagerSecret,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::AwsIamRole => "AWS::IAM::Role",
            ResourceType::AwsKmsKey => "AWS::KMS::Key",
            ResourceType::AwsLambdaFunction => "AWS::Lambda::Function",
            ResourceType::AwsLambdaLayerversion => "AWS::Lambda::LayerVersion",
            ResourceType::AwsS3Bucket => "AWS::S3::Bucket",
            ResourceType::AwsSqsQueue => "AWS::SQS::Queue",
            ResourceType::AwsSecretsmanagerSecret => "AWS::SecretsManager::Secret",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS::IAM::Role",
            "AWS::KMS::Key",
            "AWS::Lambda::Function",
            "AWS::Lambda::LayerVersion",
            "AWS::S3::Bucket",
            "AWS::SQS::Queue",
            "AWS::SecretsManager::Secret",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The criteria used to sort.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SortCriteria {
    /// <p>The name of the attribute to sort on.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The sort order, ascending or descending.</p>
    pub order_by: std::option::Option<crate::model::OrderBy>,
}
impl std::fmt::Debug for SortCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SortCriteria");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("order_by", &self.order_by);
        formatter.finish()
    }
}
/// See [`SortCriteria`](crate::model::SortCriteria)
pub mod sort_criteria {
    /// A builder for [`SortCriteria`](crate::model::SortCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) order_by: std::option::Option<crate::model::OrderBy>,
    }
    impl Builder {
        /// <p>The name of the attribute to sort on.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the attribute to sort on.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The sort order, ascending or descending.</p>
        pub fn order_by(mut self, input: crate::model::OrderBy) -> Self {
            self.order_by = Some(input);
            self
        }
        /// <p>The sort order, ascending or descending.</p>
        pub fn set_order_by(mut self, input: std::option::Option<crate::model::OrderBy>) -> Self {
            self.order_by = input;
            self
        }
        /// Consumes the builder and constructs a [`SortCriteria`](crate::model::SortCriteria)
        pub fn build(self) -> crate::model::SortCriteria {
            crate::model::SortCriteria {
                attribute_name: self.attribute_name,
                order_by: self.order_by,
            }
        }
    }
}
impl SortCriteria {
    /// Creates a new builder-style object to manufacture [`SortCriteria`](crate::model::SortCriteria)
    pub fn builder() -> crate::model::sort_criteria::Builder {
        crate::model::sort_criteria::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderBy {
    #[allow(missing_docs)] // documentation missing in model
    Asc,
    #[allow(missing_docs)] // documentation missing in model
    Desc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderBy {
    fn from(s: &str) -> Self {
        match s {
            "ASC" => OrderBy::Asc,
            "DESC" => OrderBy::Desc,
            other => OrderBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderBy::from(s))
    }
}
impl OrderBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderBy::Asc => "ASC",
            OrderBy::Desc => "DESC",
            OrderBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl AsRef<str> for OrderBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the ARN of the analyzed resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyzedResourceSummary {
    /// <p>The ARN of the analyzed resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID that owns the resource.</p>
    pub resource_owner_account: std::option::Option<std::string::String>,
    /// <p>The type of resource that was analyzed.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
}
impl std::fmt::Debug for AnalyzedResourceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyzedResourceSummary");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_owner_account", &self.resource_owner_account);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`AnalyzedResourceSummary`](crate::model::AnalyzedResourceSummary)
pub mod analyzed_resource_summary {
    /// A builder for [`AnalyzedResourceSummary`](crate::model::AnalyzedResourceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_owner_account: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        /// <p>The ARN of the analyzed resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the analyzed resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID that owns the resource.</p>
        pub fn resource_owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner_account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the resource.</p>
        pub fn set_resource_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner_account = input;
            self
        }
        /// <p>The type of resource that was analyzed.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource that was analyzed.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyzedResourceSummary`](crate::model::AnalyzedResourceSummary)
        pub fn build(self) -> crate::model::AnalyzedResourceSummary {
            crate::model::AnalyzedResourceSummary {
                resource_arn: self.resource_arn,
                resource_owner_account: self.resource_owner_account,
                resource_type: self.resource_type,
            }
        }
    }
}
impl AnalyzedResourceSummary {
    /// Creates a new builder-style object to manufacture [`AnalyzedResourceSummary`](crate::model::AnalyzedResourceSummary)
    pub fn builder() -> crate::model::analyzed_resource_summary::Builder {
        crate::model::analyzed_resource_summary::Builder::default()
    }
}

/// <p>Contains a summary of information about an access preview.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPreviewSummary {
    /// <p>The unique ID for the access preview.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN of the analyzer used to generate the access preview.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the access preview was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the access preview.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Creating</code> - The access preview creation is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Completed</code> - The access preview is complete and previews the findings
    /// for external access to the resource.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> - The access preview creation has failed.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::AccessPreviewStatus>,
    /// <p>Provides more details about the current status of the access preview. For example, if
    /// the creation of the access preview fails, a <code>Failed</code> status is returned. This
    /// failure can be due to an internal issue with the analysis or due to an invalid proposed
    /// resource configuration.</p>
    pub status_reason: std::option::Option<crate::model::AccessPreviewStatusReason>,
}
impl std::fmt::Debug for AccessPreviewSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPreviewSummary");
        formatter.field("id", &self.id);
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.finish()
    }
}
/// See [`AccessPreviewSummary`](crate::model::AccessPreviewSummary)
pub mod access_preview_summary {
    /// A builder for [`AccessPreviewSummary`](crate::model::AccessPreviewSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::AccessPreviewStatus>,
        pub(crate) status_reason: std::option::Option<crate::model::AccessPreviewStatusReason>,
    }
    impl Builder {
        /// <p>The unique ID for the access preview.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN of the analyzer used to generate the access preview.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the analyzer used to generate the access preview.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// <p>The time at which the access preview was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the access preview was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The status of the access preview.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Creating</code> - The access preview creation is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Completed</code> - The access preview is complete and previews the findings
        /// for external access to the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - The access preview creation has failed.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::AccessPreviewStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the access preview.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Creating</code> - The access preview creation is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Completed</code> - The access preview is complete and previews the findings
        /// for external access to the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - The access preview creation has failed.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AccessPreviewStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Provides more details about the current status of the access preview. For example, if
        /// the creation of the access preview fails, a <code>Failed</code> status is returned. This
        /// failure can be due to an internal issue with the analysis or due to an invalid proposed
        /// resource configuration.</p>
        pub fn status_reason(mut self, input: crate::model::AccessPreviewStatusReason) -> Self {
            self.status_reason = Some(input);
            self
        }
        /// <p>Provides more details about the current status of the access preview. For example, if
        /// the creation of the access preview fails, a <code>Failed</code> status is returned. This
        /// failure can be due to an internal issue with the analysis or due to an invalid proposed
        /// resource configuration.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<crate::model::AccessPreviewStatusReason>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPreviewSummary`](crate::model::AccessPreviewSummary)
        pub fn build(self) -> crate::model::AccessPreviewSummary {
            crate::model::AccessPreviewSummary {
                id: self.id,
                analyzer_arn: self.analyzer_arn,
                created_at: self.created_at,
                status: self.status,
                status_reason: self.status_reason,
            }
        }
    }
}
impl AccessPreviewSummary {
    /// Creates a new builder-style object to manufacture [`AccessPreviewSummary`](crate::model::AccessPreviewSummary)
    pub fn builder() -> crate::model::access_preview_summary::Builder {
        crate::model::access_preview_summary::Builder::default()
    }
}

/// <p>Provides more details about the current status of the access preview. For example, if
/// the creation of the access preview fails, a <code>Failed</code> status is returned. This
/// failure can be due to an internal issue with the analysis or due to an invalid proposed
/// resource configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPreviewStatusReason {
    /// <p>The reason code for the current status of the access preview.</p>
    pub code: std::option::Option<crate::model::AccessPreviewStatusReasonCode>,
}
impl std::fmt::Debug for AccessPreviewStatusReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPreviewStatusReason");
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
/// See [`AccessPreviewStatusReason`](crate::model::AccessPreviewStatusReason)
pub mod access_preview_status_reason {
    /// A builder for [`AccessPreviewStatusReason`](crate::model::AccessPreviewStatusReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::AccessPreviewStatusReasonCode>,
    }
    impl Builder {
        /// <p>The reason code for the current status of the access preview.</p>
        pub fn code(mut self, input: crate::model::AccessPreviewStatusReasonCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The reason code for the current status of the access preview.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::AccessPreviewStatusReasonCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPreviewStatusReason`](crate::model::AccessPreviewStatusReason)
        pub fn build(self) -> crate::model::AccessPreviewStatusReason {
            crate::model::AccessPreviewStatusReason { code: self.code }
        }
    }
}
impl AccessPreviewStatusReason {
    /// Creates a new builder-style object to manufacture [`AccessPreviewStatusReason`](crate::model::AccessPreviewStatusReason)
    pub fn builder() -> crate::model::access_preview_status_reason::Builder {
        crate::model::access_preview_status_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessPreviewStatusReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidConfiguration,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessPreviewStatusReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "INTERNAL_ERROR" => AccessPreviewStatusReasonCode::InternalError,
            "INVALID_CONFIGURATION" => AccessPreviewStatusReasonCode::InvalidConfiguration,
            other => AccessPreviewStatusReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessPreviewStatusReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessPreviewStatusReasonCode::from(s))
    }
}
impl AccessPreviewStatusReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessPreviewStatusReasonCode::InternalError => "INTERNAL_ERROR",
            AccessPreviewStatusReasonCode::InvalidConfiguration => "INVALID_CONFIGURATION",
            AccessPreviewStatusReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERNAL_ERROR", "INVALID_CONFIGURATION"]
    }
}
impl AsRef<str> for AccessPreviewStatusReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessPreviewStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessPreviewStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => AccessPreviewStatus::Completed,
            "CREATING" => AccessPreviewStatus::Creating,
            "FAILED" => AccessPreviewStatus::Failed,
            other => AccessPreviewStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessPreviewStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessPreviewStatus::from(s))
    }
}
impl AccessPreviewStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessPreviewStatus::Completed => "COMPLETED",
            AccessPreviewStatus::Creating => "CREATING",
            AccessPreviewStatus::Failed => "FAILED",
            AccessPreviewStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "CREATING", "FAILED"]
    }
}
impl AsRef<str> for AccessPreviewStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An access preview finding generated by the access preview.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPreviewFinding {
    /// <p>The ID of the access preview finding. This ID uniquely identifies the element in the
    /// list of access preview findings and is not related to the finding ID in Access
    /// Analyzer.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The existing ID of the finding in IAM Access Analyzer, provided only for existing
    /// findings.</p>
    pub existing_finding_id: std::option::Option<std::string::String>,
    /// <p>The existing status of the finding, provided only for existing findings.</p>
    pub existing_finding_status: std::option::Option<crate::model::FindingStatus>,
    /// <p>The external principal that has access to a resource within the zone of trust.</p>
    pub principal:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The action in the analyzed policy statement that an external principal has permission to
    /// perform.</p>
    pub action: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The condition in the analyzed policy statement that resulted in a finding.</p>
    pub condition:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The resource that an external principal has access to. This is the resource associated
    /// with the access preview.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>Indicates whether the policy that generated the finding allows public access to the
    /// resource.</p>
    pub is_public: std::option::Option<bool>,
    /// <p>The type of the resource that can be accessed in the finding.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The time at which the access preview finding was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Provides context on how the access preview finding compares to existing access
    /// identified in IAM Access Analyzer.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>New</code> - The finding is for newly-introduced access.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unchanged</code> - The preview finding is an existing finding that would
    /// remain unchanged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Changed</code> - The preview finding is an existing finding with a change in
    /// status.</p>
    /// </li>
    /// </ul>
    /// <p>For example, a <code>Changed</code> finding with preview status <code>Resolved</code>
    /// and existing status <code>Active</code> indicates the existing <code>Active</code> finding
    /// would become <code>Resolved</code> as a result of the proposed permissions change.</p>
    pub change_type: std::option::Option<crate::model::FindingChangeType>,
    /// <p>The preview status of the finding. This is what the status of the finding would be after
    /// permissions deployment. For example, a <code>Changed</code> finding with preview status
    /// <code>Resolved</code> and existing status <code>Active</code> indicates the existing
    /// <code>Active</code> finding would become <code>Resolved</code> as a result of the
    /// proposed permissions change.</p>
    pub status: std::option::Option<crate::model::FindingStatus>,
    /// <p>The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning
    /// account is the account in which the resource was created.</p>
    pub resource_owner_account: std::option::Option<std::string::String>,
    /// <p>An error.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The sources of the finding. This indicates how the access that generated the finding is
    /// granted. It is populated for Amazon S3 bucket findings.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::FindingSource>>,
}
impl std::fmt::Debug for AccessPreviewFinding {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPreviewFinding");
        formatter.field("id", &self.id);
        formatter.field("existing_finding_id", &self.existing_finding_id);
        formatter.field("existing_finding_status", &self.existing_finding_status);
        formatter.field("principal", &self.principal);
        formatter.field("action", &self.action);
        formatter.field("condition", &self.condition);
        formatter.field("resource", &self.resource);
        formatter.field("is_public", &self.is_public);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("change_type", &self.change_type);
        formatter.field("status", &self.status);
        formatter.field("resource_owner_account", &self.resource_owner_account);
        formatter.field("error", &self.error);
        formatter.field("sources", &self.sources);
        formatter.finish()
    }
}
/// See [`AccessPreviewFinding`](crate::model::AccessPreviewFinding)
pub mod access_preview_finding {
    /// A builder for [`AccessPreviewFinding`](crate::model::AccessPreviewFinding)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) existing_finding_id: std::option::Option<std::string::String>,
        pub(crate) existing_finding_status: std::option::Option<crate::model::FindingStatus>,
        pub(crate) principal: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) action: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) condition: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) is_public: std::option::Option<bool>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) change_type: std::option::Option<crate::model::FindingChangeType>,
        pub(crate) status: std::option::Option<crate::model::FindingStatus>,
        pub(crate) resource_owner_account: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::FindingSource>>,
    }
    impl Builder {
        /// <p>The ID of the access preview finding. This ID uniquely identifies the element in the
        /// list of access preview findings and is not related to the finding ID in Access
        /// Analyzer.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the access preview finding. This ID uniquely identifies the element in the
        /// list of access preview findings and is not related to the finding ID in Access
        /// Analyzer.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The existing ID of the finding in IAM Access Analyzer, provided only for existing
        /// findings.</p>
        pub fn existing_finding_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.existing_finding_id = Some(input.into());
            self
        }
        /// <p>The existing ID of the finding in IAM Access Analyzer, provided only for existing
        /// findings.</p>
        pub fn set_existing_finding_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.existing_finding_id = input;
            self
        }
        /// <p>The existing status of the finding, provided only for existing findings.</p>
        pub fn existing_finding_status(mut self, input: crate::model::FindingStatus) -> Self {
            self.existing_finding_status = Some(input);
            self
        }
        /// <p>The existing status of the finding, provided only for existing findings.</p>
        pub fn set_existing_finding_status(
            mut self,
            input: std::option::Option<crate::model::FindingStatus>,
        ) -> Self {
            self.existing_finding_status = input;
            self
        }
        /// Adds a key-value pair to `principal`.
        ///
        /// To override the contents of this collection use [`set_principal`](Self::set_principal).
        ///
        /// <p>The external principal that has access to a resource within the zone of trust.</p>
        pub fn principal(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.principal.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.principal = Some(hash_map);
            self
        }
        /// <p>The external principal that has access to a resource within the zone of trust.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.principal = input;
            self
        }
        /// Appends an item to `action`.
        ///
        /// To override the contents of this collection use [`set_action`](Self::set_action).
        ///
        /// <p>The action in the analyzed policy statement that an external principal has permission to
        /// perform.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.action.unwrap_or_default();
            v.push(input.into());
            self.action = Some(v);
            self
        }
        /// <p>The action in the analyzed policy statement that an external principal has permission to
        /// perform.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Adds a key-value pair to `condition`.
        ///
        /// To override the contents of this collection use [`set_condition`](Self::set_condition).
        ///
        /// <p>The condition in the analyzed policy statement that resulted in a finding.</p>
        pub fn condition(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.condition.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.condition = Some(hash_map);
            self
        }
        /// <p>The condition in the analyzed policy statement that resulted in a finding.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.condition = input;
            self
        }
        /// <p>The resource that an external principal has access to. This is the resource associated
        /// with the access preview.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The resource that an external principal has access to. This is the resource associated
        /// with the access preview.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>Indicates whether the policy that generated the finding allows public access to the
        /// resource.</p>
        pub fn is_public(mut self, input: bool) -> Self {
            self.is_public = Some(input);
            self
        }
        /// <p>Indicates whether the policy that generated the finding allows public access to the
        /// resource.</p>
        pub fn set_is_public(mut self, input: std::option::Option<bool>) -> Self {
            self.is_public = input;
            self
        }
        /// <p>The type of the resource that can be accessed in the finding.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the resource that can be accessed in the finding.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The time at which the access preview finding was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the access preview finding was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Provides context on how the access preview finding compares to existing access
        /// identified in IAM Access Analyzer.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>New</code> - The finding is for newly-introduced access.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unchanged</code> - The preview finding is an existing finding that would
        /// remain unchanged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Changed</code> - The preview finding is an existing finding with a change in
        /// status.</p>
        /// </li>
        /// </ul>
        /// <p>For example, a <code>Changed</code> finding with preview status <code>Resolved</code>
        /// and existing status <code>Active</code> indicates the existing <code>Active</code> finding
        /// would become <code>Resolved</code> as a result of the proposed permissions change.</p>
        pub fn change_type(mut self, input: crate::model::FindingChangeType) -> Self {
            self.change_type = Some(input);
            self
        }
        /// <p>Provides context on how the access preview finding compares to existing access
        /// identified in IAM Access Analyzer.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>New</code> - The finding is for newly-introduced access.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unchanged</code> - The preview finding is an existing finding that would
        /// remain unchanged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Changed</code> - The preview finding is an existing finding with a change in
        /// status.</p>
        /// </li>
        /// </ul>
        /// <p>For example, a <code>Changed</code> finding with preview status <code>Resolved</code>
        /// and existing status <code>Active</code> indicates the existing <code>Active</code> finding
        /// would become <code>Resolved</code> as a result of the proposed permissions change.</p>
        pub fn set_change_type(
            mut self,
            input: std::option::Option<crate::model::FindingChangeType>,
        ) -> Self {
            self.change_type = input;
            self
        }
        /// <p>The preview status of the finding. This is what the status of the finding would be after
        /// permissions deployment. For example, a <code>Changed</code> finding with preview status
        /// <code>Resolved</code> and existing status <code>Active</code> indicates the existing
        /// <code>Active</code> finding would become <code>Resolved</code> as a result of the
        /// proposed permissions change.</p>
        pub fn status(mut self, input: crate::model::FindingStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The preview status of the finding. This is what the status of the finding would be after
        /// permissions deployment. For example, a <code>Changed</code> finding with preview status
        /// <code>Resolved</code> and existing status <code>Active</code> indicates the existing
        /// <code>Active</code> finding would become <code>Resolved</code> as a result of the
        /// proposed permissions change.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FindingStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning
        /// account is the account in which the resource was created.</p>
        pub fn resource_owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner_account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning
        /// account is the account in which the resource was created.</p>
        pub fn set_resource_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner_account = input;
            self
        }
        /// <p>An error.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>An error.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the finding. This indicates how the access that generated the finding is
        /// granted. It is populated for Amazon S3 bucket findings.</p>
        pub fn sources(mut self, input: impl Into<crate::model::FindingSource>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the finding. This indicates how the access that generated the finding is
        /// granted. It is populated for Amazon S3 bucket findings.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FindingSource>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPreviewFinding`](crate::model::AccessPreviewFinding)
        pub fn build(self) -> crate::model::AccessPreviewFinding {
            crate::model::AccessPreviewFinding {
                id: self.id,
                existing_finding_id: self.existing_finding_id,
                existing_finding_status: self.existing_finding_status,
                principal: self.principal,
                action: self.action,
                condition: self.condition,
                resource: self.resource,
                is_public: self.is_public,
                resource_type: self.resource_type,
                created_at: self.created_at,
                change_type: self.change_type,
                status: self.status,
                resource_owner_account: self.resource_owner_account,
                error: self.error,
                sources: self.sources,
            }
        }
    }
}
impl AccessPreviewFinding {
    /// Creates a new builder-style object to manufacture [`AccessPreviewFinding`](crate::model::AccessPreviewFinding)
    pub fn builder() -> crate::model::access_preview_finding::Builder {
        crate::model::access_preview_finding::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingChangeType {
    #[allow(missing_docs)] // documentation missing in model
    Changed,
    #[allow(missing_docs)] // documentation missing in model
    New,
    #[allow(missing_docs)] // documentation missing in model
    Unchanged,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingChangeType {
    fn from(s: &str) -> Self {
        match s {
            "CHANGED" => FindingChangeType::Changed,
            "NEW" => FindingChangeType::New,
            "UNCHANGED" => FindingChangeType::Unchanged,
            other => FindingChangeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingChangeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingChangeType::from(s))
    }
}
impl FindingChangeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingChangeType::Changed => "CHANGED",
            FindingChangeType::New => "NEW",
            FindingChangeType::Unchanged => "UNCHANGED",
            FindingChangeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CHANGED", "NEW", "UNCHANGED"]
    }
}
impl AsRef<str> for FindingChangeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the text for the generated policy and its details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeneratedPolicyResult {
    /// <p>A <code>GeneratedPolicyProperties</code> object that contains properties of the
    /// generated policy.</p>
    pub properties: std::option::Option<crate::model::GeneratedPolicyProperties>,
    /// <p>The text to use as the content for the new policy. The policy is created using the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.</p>
    pub generated_policies: std::option::Option<std::vec::Vec<crate::model::GeneratedPolicy>>,
}
impl std::fmt::Debug for GeneratedPolicyResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeneratedPolicyResult");
        formatter.field("properties", &self.properties);
        formatter.field("generated_policies", &self.generated_policies);
        formatter.finish()
    }
}
/// See [`GeneratedPolicyResult`](crate::model::GeneratedPolicyResult)
pub mod generated_policy_result {
    /// A builder for [`GeneratedPolicyResult`](crate::model::GeneratedPolicyResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) properties: std::option::Option<crate::model::GeneratedPolicyProperties>,
        pub(crate) generated_policies:
            std::option::Option<std::vec::Vec<crate::model::GeneratedPolicy>>,
    }
    impl Builder {
        /// <p>A <code>GeneratedPolicyProperties</code> object that contains properties of the
        /// generated policy.</p>
        pub fn properties(mut self, input: crate::model::GeneratedPolicyProperties) -> Self {
            self.properties = Some(input);
            self
        }
        /// <p>A <code>GeneratedPolicyProperties</code> object that contains properties of the
        /// generated policy.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<crate::model::GeneratedPolicyProperties>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Appends an item to `generated_policies`.
        ///
        /// To override the contents of this collection use [`set_generated_policies`](Self::set_generated_policies).
        ///
        /// <p>The text to use as the content for the new policy. The policy is created using the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.</p>
        pub fn generated_policies(
            mut self,
            input: impl Into<crate::model::GeneratedPolicy>,
        ) -> Self {
            let mut v = self.generated_policies.unwrap_or_default();
            v.push(input.into());
            self.generated_policies = Some(v);
            self
        }
        /// <p>The text to use as the content for the new policy. The policy is created using the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.</p>
        pub fn set_generated_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GeneratedPolicy>>,
        ) -> Self {
            self.generated_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`GeneratedPolicyResult`](crate::model::GeneratedPolicyResult)
        pub fn build(self) -> crate::model::GeneratedPolicyResult {
            crate::model::GeneratedPolicyResult {
                properties: self.properties,
                generated_policies: self.generated_policies,
            }
        }
    }
}
impl GeneratedPolicyResult {
    /// Creates a new builder-style object to manufacture [`GeneratedPolicyResult`](crate::model::GeneratedPolicyResult)
    pub fn builder() -> crate::model::generated_policy_result::Builder {
        crate::model::generated_policy_result::Builder::default()
    }
}

/// <p>Contains the text for the generated policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeneratedPolicy {
    /// <p>The text to use as the content for the new policy. The policy is created using the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GeneratedPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeneratedPolicy");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GeneratedPolicy`](crate::model::GeneratedPolicy)
pub mod generated_policy {
    /// A builder for [`GeneratedPolicy`](crate::model::GeneratedPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The text to use as the content for the new policy. The policy is created using the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The text to use as the content for the new policy. The policy is created using the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GeneratedPolicy`](crate::model::GeneratedPolicy)
        pub fn build(self) -> crate::model::GeneratedPolicy {
            crate::model::GeneratedPolicy {
                policy: self.policy,
            }
        }
    }
}
impl GeneratedPolicy {
    /// Creates a new builder-style object to manufacture [`GeneratedPolicy`](crate::model::GeneratedPolicy)
    pub fn builder() -> crate::model::generated_policy::Builder {
        crate::model::generated_policy::Builder::default()
    }
}

/// <p>Contains the generated policy details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeneratedPolicyProperties {
    /// <p>This value is set to <code>true</code> if the generated policy contains all possible
    /// actions for a service that IAM Access Analyzer identified from the CloudTrail trail that you specified,
    /// and <code>false</code> otherwise.</p>
    pub is_complete: std::option::Option<bool>,
    /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>
    pub principal_arn: std::option::Option<std::string::String>,
    /// <p>Lists details about the <code>Trail</code> used to generated policy.</p>
    pub cloud_trail_properties: std::option::Option<crate::model::CloudTrailProperties>,
}
impl std::fmt::Debug for GeneratedPolicyProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeneratedPolicyProperties");
        formatter.field("is_complete", &self.is_complete);
        formatter.field("principal_arn", &self.principal_arn);
        formatter.field("cloud_trail_properties", &self.cloud_trail_properties);
        formatter.finish()
    }
}
/// See [`GeneratedPolicyProperties`](crate::model::GeneratedPolicyProperties)
pub mod generated_policy_properties {
    /// A builder for [`GeneratedPolicyProperties`](crate::model::GeneratedPolicyProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_complete: std::option::Option<bool>,
        pub(crate) principal_arn: std::option::Option<std::string::String>,
        pub(crate) cloud_trail_properties: std::option::Option<crate::model::CloudTrailProperties>,
    }
    impl Builder {
        /// <p>This value is set to <code>true</code> if the generated policy contains all possible
        /// actions for a service that IAM Access Analyzer identified from the CloudTrail trail that you specified,
        /// and <code>false</code> otherwise.</p>
        pub fn is_complete(mut self, input: bool) -> Self {
            self.is_complete = Some(input);
            self
        }
        /// <p>This value is set to <code>true</code> if the generated policy contains all possible
        /// actions for a service that IAM Access Analyzer identified from the CloudTrail trail that you specified,
        /// and <code>false</code> otherwise.</p>
        pub fn set_is_complete(mut self, input: std::option::Option<bool>) -> Self {
            self.is_complete = input;
            self
        }
        /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.principal_arn = input;
            self
        }
        /// <p>Lists details about the <code>Trail</code> used to generated policy.</p>
        pub fn cloud_trail_properties(mut self, input: crate::model::CloudTrailProperties) -> Self {
            self.cloud_trail_properties = Some(input);
            self
        }
        /// <p>Lists details about the <code>Trail</code> used to generated policy.</p>
        pub fn set_cloud_trail_properties(
            mut self,
            input: std::option::Option<crate::model::CloudTrailProperties>,
        ) -> Self {
            self.cloud_trail_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`GeneratedPolicyProperties`](crate::model::GeneratedPolicyProperties)
        pub fn build(self) -> crate::model::GeneratedPolicyProperties {
            crate::model::GeneratedPolicyProperties {
                is_complete: self.is_complete,
                principal_arn: self.principal_arn,
                cloud_trail_properties: self.cloud_trail_properties,
            }
        }
    }
}
impl GeneratedPolicyProperties {
    /// Creates a new builder-style object to manufacture [`GeneratedPolicyProperties`](crate::model::GeneratedPolicyProperties)
    pub fn builder() -> crate::model::generated_policy_properties::Builder {
        crate::model::generated_policy_properties::Builder::default()
    }
}

/// <p>Contains information about CloudTrail access.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudTrailProperties {
    /// <p>A <code>TrailProperties</code> object that contains settings for trail
    /// properties.</p>
    pub trail_properties: std::option::Option<std::vec::Vec<crate::model::TrailProperties>>,
    /// <p>The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events
    /// with a timestamp before this time are not considered to generate a policy.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
    /// a timestamp after this time are not considered to generate a policy. If this is not
    /// included in the request, the default value is the current time.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for CloudTrailProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudTrailProperties");
        formatter.field("trail_properties", &self.trail_properties);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`CloudTrailProperties`](crate::model::CloudTrailProperties)
pub mod cloud_trail_properties {
    /// A builder for [`CloudTrailProperties`](crate::model::CloudTrailProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_properties:
            std::option::Option<std::vec::Vec<crate::model::TrailProperties>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// Appends an item to `trail_properties`.
        ///
        /// To override the contents of this collection use [`set_trail_properties`](Self::set_trail_properties).
        ///
        /// <p>A <code>TrailProperties</code> object that contains settings for trail
        /// properties.</p>
        pub fn trail_properties(mut self, input: impl Into<crate::model::TrailProperties>) -> Self {
            let mut v = self.trail_properties.unwrap_or_default();
            v.push(input.into());
            self.trail_properties = Some(v);
            self
        }
        /// <p>A <code>TrailProperties</code> object that contains settings for trail
        /// properties.</p>
        pub fn set_trail_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrailProperties>>,
        ) -> Self {
            self.trail_properties = input;
            self
        }
        /// <p>The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events
        /// with a timestamp before this time are not considered to generate a policy.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events
        /// with a timestamp before this time are not considered to generate a policy.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
        /// a timestamp after this time are not considered to generate a policy. If this is not
        /// included in the request, the default value is the current time.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
        /// a timestamp after this time are not considered to generate a policy. If this is not
        /// included in the request, the default value is the current time.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudTrailProperties`](crate::model::CloudTrailProperties)
        pub fn build(self) -> crate::model::CloudTrailProperties {
            crate::model::CloudTrailProperties {
                trail_properties: self.trail_properties,
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl CloudTrailProperties {
    /// Creates a new builder-style object to manufacture [`CloudTrailProperties`](crate::model::CloudTrailProperties)
    pub fn builder() -> crate::model::cloud_trail_properties::Builder {
        crate::model::cloud_trail_properties::Builder::default()
    }
}

/// <p>Contains details about the CloudTrail trail being analyzed to generate a policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrailProperties {
    /// <p>Specifies the ARN of the trail. The format of a trail ARN is
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.</p>
    pub cloud_trail_arn: std::option::Option<std::string::String>,
    /// <p>A list of regions to get CloudTrail data from and analyze to generate a policy.</p>
    pub regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Possible values are <code>true</code> or <code>false</code>. If set to
    /// <code>true</code>, IAM Access Analyzer retrieves CloudTrail data from all regions to analyze and
    /// generate a policy.</p>
    pub all_regions: std::option::Option<bool>,
}
impl std::fmt::Debug for TrailProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrailProperties");
        formatter.field("cloud_trail_arn", &self.cloud_trail_arn);
        formatter.field("regions", &self.regions);
        formatter.field("all_regions", &self.all_regions);
        formatter.finish()
    }
}
/// See [`TrailProperties`](crate::model::TrailProperties)
pub mod trail_properties {
    /// A builder for [`TrailProperties`](crate::model::TrailProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_trail_arn: std::option::Option<std::string::String>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) all_regions: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies the ARN of the trail. The format of a trail ARN is
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.</p>
        pub fn cloud_trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_trail_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail. The format of a trail ARN is
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.</p>
        pub fn set_cloud_trail_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_trail_arn = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>A list of regions to get CloudTrail data from and analyze to generate a policy.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>A list of regions to get CloudTrail data from and analyze to generate a policy.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// <p>Possible values are <code>true</code> or <code>false</code>. If set to
        /// <code>true</code>, IAM Access Analyzer retrieves CloudTrail data from all regions to analyze and
        /// generate a policy.</p>
        pub fn all_regions(mut self, input: bool) -> Self {
            self.all_regions = Some(input);
            self
        }
        /// <p>Possible values are <code>true</code> or <code>false</code>. If set to
        /// <code>true</code>, IAM Access Analyzer retrieves CloudTrail data from all regions to analyze and
        /// generate a policy.</p>
        pub fn set_all_regions(mut self, input: std::option::Option<bool>) -> Self {
            self.all_regions = input;
            self
        }
        /// Consumes the builder and constructs a [`TrailProperties`](crate::model::TrailProperties)
        pub fn build(self) -> crate::model::TrailProperties {
            crate::model::TrailProperties {
                cloud_trail_arn: self.cloud_trail_arn,
                regions: self.regions,
                all_regions: self.all_regions,
            }
        }
    }
}
impl TrailProperties {
    /// Creates a new builder-style object to manufacture [`TrailProperties`](crate::model::TrailProperties)
    pub fn builder() -> crate::model::trail_properties::Builder {
        crate::model::trail_properties::Builder::default()
    }
}

/// <p>Contains details about the policy generation request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobDetails {
    /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
    /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
    /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
    /// the policy generation request.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The status of the job request.</p>
    pub status: std::option::Option<crate::model::JobStatus>,
    /// <p>A timestamp of when the job was started.</p>
    pub started_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp of when the job was completed.</p>
    pub completed_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The job error for the policy generation request.</p>
    pub job_error: std::option::Option<crate::model::JobError>,
}
impl std::fmt::Debug for JobDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobDetails");
        formatter.field("job_id", &self.job_id);
        formatter.field("status", &self.status);
        formatter.field("started_on", &self.started_on);
        formatter.field("completed_on", &self.completed_on);
        formatter.field("job_error", &self.job_error);
        formatter.finish()
    }
}
/// See [`JobDetails`](crate::model::JobDetails)
pub mod job_details {
    /// A builder for [`JobDetails`](crate::model::JobDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
        pub(crate) started_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) job_error: std::option::Option<crate::model::JobError>,
    }
    impl Builder {
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
        /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
        /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
        /// the policy generation request.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
        /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
        /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
        /// the policy generation request.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The status of the job request.</p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the job request.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>A timestamp of when the job was started.</p>
        pub fn started_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_on = Some(input);
            self
        }
        /// <p>A timestamp of when the job was started.</p>
        pub fn set_started_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_on = input;
            self
        }
        /// <p>A timestamp of when the job was completed.</p>
        pub fn completed_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_on = Some(input);
            self
        }
        /// <p>A timestamp of when the job was completed.</p>
        pub fn set_completed_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_on = input;
            self
        }
        /// <p>The job error for the policy generation request.</p>
        pub fn job_error(mut self, input: crate::model::JobError) -> Self {
            self.job_error = Some(input);
            self
        }
        /// <p>The job error for the policy generation request.</p>
        pub fn set_job_error(mut self, input: std::option::Option<crate::model::JobError>) -> Self {
            self.job_error = input;
            self
        }
        /// Consumes the builder and constructs a [`JobDetails`](crate::model::JobDetails)
        pub fn build(self) -> crate::model::JobDetails {
            crate::model::JobDetails {
                job_id: self.job_id,
                status: self.status,
                started_on: self.started_on,
                completed_on: self.completed_on,
                job_error: self.job_error,
            }
        }
    }
}
impl JobDetails {
    /// Creates a new builder-style object to manufacture [`JobDetails`](crate::model::JobDetails)
    pub fn builder() -> crate::model::job_details::Builder {
        crate::model::job_details::Builder::default()
    }
}

/// <p>Contains the details about the policy generation error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobError {
    /// <p>The job error code.</p>
    pub code: std::option::Option<crate::model::JobErrorCode>,
    /// <p>Specific information about the error. For example, which service quota was exceeded or
    /// which resource was not found.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for JobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobError");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`JobError`](crate::model::JobError)
pub mod job_error {
    /// A builder for [`JobError`](crate::model::JobError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::JobErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job error code.</p>
        pub fn code(mut self, input: crate::model::JobErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The job error code.</p>
        pub fn set_code(mut self, input: std::option::Option<crate::model::JobErrorCode>) -> Self {
            self.code = input;
            self
        }
        /// <p>Specific information about the error. For example, which service quota was exceeded or
        /// which resource was not found.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Specific information about the error. For example, which service quota was exceeded or
        /// which resource was not found.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`JobError`](crate::model::JobError)
        pub fn build(self) -> crate::model::JobError {
            crate::model::JobError {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl JobError {
    /// Creates a new builder-style object to manufacture [`JobError`](crate::model::JobError)
    pub fn builder() -> crate::model::job_error::Builder {
        crate::model::job_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AuthorizationError,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundError,
    #[allow(missing_docs)] // documentation missing in model
    ServiceError,
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaExceededError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AUTHORIZATION_ERROR" => JobErrorCode::AuthorizationError,
            "RESOURCE_NOT_FOUND_ERROR" => JobErrorCode::ResourceNotFoundError,
            "SERVICE_ERROR" => JobErrorCode::ServiceError,
            "SERVICE_QUOTA_EXCEEDED_ERROR" => JobErrorCode::ServiceQuotaExceededError,
            other => JobErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobErrorCode::from(s))
    }
}
impl JobErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobErrorCode::AuthorizationError => "AUTHORIZATION_ERROR",
            JobErrorCode::ResourceNotFoundError => "RESOURCE_NOT_FOUND_ERROR",
            JobErrorCode::ServiceError => "SERVICE_ERROR",
            JobErrorCode::ServiceQuotaExceededError => "SERVICE_QUOTA_EXCEEDED_ERROR",
            JobErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AUTHORIZATION_ERROR",
            "RESOURCE_NOT_FOUND_ERROR",
            "SERVICE_ERROR",
            "SERVICE_QUOTA_EXCEEDED_ERROR",
        ]
    }
}
impl AsRef<str> for JobErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Finding {
    /// <p>The ID of the finding.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The external principal that access to a resource within the zone of trust.</p>
    pub principal:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The action in the analyzed policy statement that an external principal has permission to
    /// use.</p>
    pub action: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The resource that an external principal has access to.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>Indicates whether the policy that generated the finding allows public access to the
    /// resource.</p>
    pub is_public: std::option::Option<bool>,
    /// <p>The type of the resource identified in the finding.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The condition in the analyzed policy statement that resulted in a finding.</p>
    pub condition:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The time at which the finding was generated.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the resource was analyzed.</p>
    pub analyzed_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the finding was updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current status of the finding.</p>
    pub status: std::option::Option<crate::model::FindingStatus>,
    /// <p>The Amazon Web Services account ID that owns the resource.</p>
    pub resource_owner_account: std::option::Option<std::string::String>,
    /// <p>An error.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The sources of the finding. This indicates how the access that generated the finding is
    /// granted. It is populated for Amazon S3 bucket findings.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::FindingSource>>,
}
impl std::fmt::Debug for Finding {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Finding");
        formatter.field("id", &self.id);
        formatter.field("principal", &self.principal);
        formatter.field("action", &self.action);
        formatter.field("resource", &self.resource);
        formatter.field("is_public", &self.is_public);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("condition", &self.condition);
        formatter.field("created_at", &self.created_at);
        formatter.field("analyzed_at", &self.analyzed_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("status", &self.status);
        formatter.field("resource_owner_account", &self.resource_owner_account);
        formatter.field("error", &self.error);
        formatter.field("sources", &self.sources);
        formatter.finish()
    }
}
/// See [`Finding`](crate::model::Finding)
pub mod finding {
    /// A builder for [`Finding`](crate::model::Finding)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) action: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) is_public: std::option::Option<bool>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) condition: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) analyzed_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::FindingStatus>,
        pub(crate) resource_owner_account: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::FindingSource>>,
    }
    impl Builder {
        /// <p>The ID of the finding.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the finding.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `principal`.
        ///
        /// To override the contents of this collection use [`set_principal`](Self::set_principal).
        ///
        /// <p>The external principal that access to a resource within the zone of trust.</p>
        pub fn principal(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.principal.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.principal = Some(hash_map);
            self
        }
        /// <p>The external principal that access to a resource within the zone of trust.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.principal = input;
            self
        }
        /// Appends an item to `action`.
        ///
        /// To override the contents of this collection use [`set_action`](Self::set_action).
        ///
        /// <p>The action in the analyzed policy statement that an external principal has permission to
        /// use.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.action.unwrap_or_default();
            v.push(input.into());
            self.action = Some(v);
            self
        }
        /// <p>The action in the analyzed policy statement that an external principal has permission to
        /// use.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The resource that an external principal has access to.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The resource that an external principal has access to.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>Indicates whether the policy that generated the finding allows public access to the
        /// resource.</p>
        pub fn is_public(mut self, input: bool) -> Self {
            self.is_public = Some(input);
            self
        }
        /// <p>Indicates whether the policy that generated the finding allows public access to the
        /// resource.</p>
        pub fn set_is_public(mut self, input: std::option::Option<bool>) -> Self {
            self.is_public = input;
            self
        }
        /// <p>The type of the resource identified in the finding.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the resource identified in the finding.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Adds a key-value pair to `condition`.
        ///
        /// To override the contents of this collection use [`set_condition`](Self::set_condition).
        ///
        /// <p>The condition in the analyzed policy statement that resulted in a finding.</p>
        pub fn condition(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.condition.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.condition = Some(hash_map);
            self
        }
        /// <p>The condition in the analyzed policy statement that resulted in a finding.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.condition = input;
            self
        }
        /// <p>The time at which the finding was generated.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the finding was generated.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time at which the resource was analyzed.</p>
        pub fn analyzed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.analyzed_at = Some(input);
            self
        }
        /// <p>The time at which the resource was analyzed.</p>
        pub fn set_analyzed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.analyzed_at = input;
            self
        }
        /// <p>The time at which the finding was updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The time at which the finding was updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The current status of the finding.</p>
        pub fn status(mut self, input: crate::model::FindingStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the finding.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FindingStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services account ID that owns the resource.</p>
        pub fn resource_owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner_account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the resource.</p>
        pub fn set_resource_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner_account = input;
            self
        }
        /// <p>An error.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>An error.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the finding. This indicates how the access that generated the finding is
        /// granted. It is populated for Amazon S3 bucket findings.</p>
        pub fn sources(mut self, input: impl Into<crate::model::FindingSource>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the finding. This indicates how the access that generated the finding is
        /// granted. It is populated for Amazon S3 bucket findings.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FindingSource>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Consumes the builder and constructs a [`Finding`](crate::model::Finding)
        pub fn build(self) -> crate::model::Finding {
            crate::model::Finding {
                id: self.id,
                principal: self.principal,
                action: self.action,
                resource: self.resource,
                is_public: self.is_public,
                resource_type: self.resource_type,
                condition: self.condition,
                created_at: self.created_at,
                analyzed_at: self.analyzed_at,
                updated_at: self.updated_at,
                status: self.status,
                resource_owner_account: self.resource_owner_account,
                error: self.error,
                sources: self.sources,
            }
        }
    }
}
impl Finding {
    /// Creates a new builder-style object to manufacture [`Finding`](crate::model::Finding)
    pub fn builder() -> crate::model::finding::Builder {
        crate::model::finding::Builder::default()
    }
}

/// <p>Contains details about the analyzed resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyzedResource {
    /// <p>The ARN of the resource that was analyzed.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The type of the resource that was analyzed.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The time at which the finding was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the resource was analyzed.</p>
    pub analyzed_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the finding was updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Indicates whether the policy that generated the finding grants public access to the
    /// resource.</p>
    pub is_public: std::option::Option<bool>,
    /// <p>The actions that an external principal is granted permission to use by the policy that
    /// generated the finding.</p>
    pub actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates how the access that generated the finding is granted. This is populated for
    /// Amazon S3 bucket findings.</p>
    pub shared_via: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The current status of the finding generated from the analyzed resource.</p>
    pub status: std::option::Option<crate::model::FindingStatus>,
    /// <p>The Amazon Web Services account ID that owns the resource.</p>
    pub resource_owner_account: std::option::Option<std::string::String>,
    /// <p>An error message.</p>
    pub error: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AnalyzedResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyzedResource");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("analyzed_at", &self.analyzed_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("is_public", &self.is_public);
        formatter.field("actions", &self.actions);
        formatter.field("shared_via", &self.shared_via);
        formatter.field("status", &self.status);
        formatter.field("resource_owner_account", &self.resource_owner_account);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`AnalyzedResource`](crate::model::AnalyzedResource)
pub mod analyzed_resource {
    /// A builder for [`AnalyzedResource`](crate::model::AnalyzedResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) analyzed_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) is_public: std::option::Option<bool>,
        pub(crate) actions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) shared_via: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<crate::model::FindingStatus>,
        pub(crate) resource_owner_account: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource that was analyzed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource that was analyzed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The type of the resource that was analyzed.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the resource that was analyzed.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The time at which the finding was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the finding was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time at which the resource was analyzed.</p>
        pub fn analyzed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.analyzed_at = Some(input);
            self
        }
        /// <p>The time at which the resource was analyzed.</p>
        pub fn set_analyzed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.analyzed_at = input;
            self
        }
        /// <p>The time at which the finding was updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The time at which the finding was updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>Indicates whether the policy that generated the finding grants public access to the
        /// resource.</p>
        pub fn is_public(mut self, input: bool) -> Self {
            self.is_public = Some(input);
            self
        }
        /// <p>Indicates whether the policy that generated the finding grants public access to the
        /// resource.</p>
        pub fn set_is_public(mut self, input: std::option::Option<bool>) -> Self {
            self.is_public = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions that an external principal is granted permission to use by the policy that
        /// generated the finding.</p>
        pub fn actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The actions that an external principal is granted permission to use by the policy that
        /// generated the finding.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Appends an item to `shared_via`.
        ///
        /// To override the contents of this collection use [`set_shared_via`](Self::set_shared_via).
        ///
        /// <p>Indicates how the access that generated the finding is granted. This is populated for
        /// Amazon S3 bucket findings.</p>
        pub fn shared_via(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.shared_via.unwrap_or_default();
            v.push(input.into());
            self.shared_via = Some(v);
            self
        }
        /// <p>Indicates how the access that generated the finding is granted. This is populated for
        /// Amazon S3 bucket findings.</p>
        pub fn set_shared_via(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.shared_via = input;
            self
        }
        /// <p>The current status of the finding generated from the analyzed resource.</p>
        pub fn status(mut self, input: crate::model::FindingStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the finding generated from the analyzed resource.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FindingStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services account ID that owns the resource.</p>
        pub fn resource_owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner_account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the resource.</p>
        pub fn set_resource_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner_account = input;
            self
        }
        /// <p>An error message.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>An error message.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyzedResource`](crate::model::AnalyzedResource)
        pub fn build(self) -> crate::model::AnalyzedResource {
            crate::model::AnalyzedResource {
                resource_arn: self.resource_arn,
                resource_type: self.resource_type,
                created_at: self.created_at,
                analyzed_at: self.analyzed_at,
                updated_at: self.updated_at,
                is_public: self.is_public,
                actions: self.actions,
                shared_via: self.shared_via,
                status: self.status,
                resource_owner_account: self.resource_owner_account,
                error: self.error,
            }
        }
    }
}
impl AnalyzedResource {
    /// Creates a new builder-style object to manufacture [`AnalyzedResource`](crate::model::AnalyzedResource)
    pub fn builder() -> crate::model::analyzed_resource::Builder {
        crate::model::analyzed_resource::Builder::default()
    }
}

/// <p>Contains information about an access preview.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPreview {
    /// <p>The unique ID for the access preview.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN of the analyzer used to generate the access preview.</p>
    pub analyzer_arn: std::option::Option<std::string::String>,
    /// <p>A map of resource ARNs for the proposed resource configuration.</p>
    pub configurations: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Configuration>,
    >,
    /// <p>The time at which the access preview was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the access preview.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Creating</code> - The access preview creation is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Completed</code> - The access preview is complete. You can preview findings
    /// for external access to the resource.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> - The access preview creation has failed.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::AccessPreviewStatus>,
    /// <p>Provides more details about the current status of the access preview.</p>
    /// <p>For example, if the creation of the access preview fails, a <code>Failed</code> status
    /// is returned. This failure can be due to an internal issue with the analysis or due to an
    /// invalid resource configuration.</p>
    pub status_reason: std::option::Option<crate::model::AccessPreviewStatusReason>,
}
impl std::fmt::Debug for AccessPreview {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPreview");
        formatter.field("id", &self.id);
        formatter.field("analyzer_arn", &self.analyzer_arn);
        formatter.field("configurations", &self.configurations);
        formatter.field("created_at", &self.created_at);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.finish()
    }
}
/// See [`AccessPreview`](crate::model::AccessPreview)
pub mod access_preview {
    /// A builder for [`AccessPreview`](crate::model::AccessPreview)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) analyzer_arn: std::option::Option<std::string::String>,
        pub(crate) configurations: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Configuration>,
        >,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::AccessPreviewStatus>,
        pub(crate) status_reason: std::option::Option<crate::model::AccessPreviewStatusReason>,
    }
    impl Builder {
        /// <p>The unique ID for the access preview.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN of the analyzer used to generate the access preview.</p>
        pub fn analyzer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analyzer_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the analyzer used to generate the access preview.</p>
        pub fn set_analyzer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analyzer_arn = input;
            self
        }
        /// Adds a key-value pair to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>A map of resource ARNs for the proposed resource configuration.</p>
        pub fn configurations(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Configuration>,
        ) -> Self {
            let mut hash_map = self.configurations.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.configurations = Some(hash_map);
            self
        }
        /// <p>A map of resource ARNs for the proposed resource configuration.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Configuration>,
            >,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// <p>The time at which the access preview was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the access preview was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The status of the access preview.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Creating</code> - The access preview creation is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Completed</code> - The access preview is complete. You can preview findings
        /// for external access to the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - The access preview creation has failed.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::AccessPreviewStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the access preview.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Creating</code> - The access preview creation is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Completed</code> - The access preview is complete. You can preview findings
        /// for external access to the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - The access preview creation has failed.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AccessPreviewStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Provides more details about the current status of the access preview.</p>
        /// <p>For example, if the creation of the access preview fails, a <code>Failed</code> status
        /// is returned. This failure can be due to an internal issue with the analysis or due to an
        /// invalid resource configuration.</p>
        pub fn status_reason(mut self, input: crate::model::AccessPreviewStatusReason) -> Self {
            self.status_reason = Some(input);
            self
        }
        /// <p>Provides more details about the current status of the access preview.</p>
        /// <p>For example, if the creation of the access preview fails, a <code>Failed</code> status
        /// is returned. This failure can be due to an internal issue with the analysis or due to an
        /// invalid resource configuration.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<crate::model::AccessPreviewStatusReason>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPreview`](crate::model::AccessPreview)
        pub fn build(self) -> crate::model::AccessPreview {
            crate::model::AccessPreview {
                id: self.id,
                analyzer_arn: self.analyzer_arn,
                configurations: self.configurations,
                created_at: self.created_at,
                status: self.status,
                status_reason: self.status_reason,
            }
        }
    }
}
impl AccessPreview {
    /// Creates a new builder-style object to manufacture [`AccessPreview`](crate::model::AccessPreview)
    pub fn builder() -> crate::model::access_preview::Builder {
        crate::model::access_preview::Builder::default()
    }
}

/// <p>Access control configuration structures for your resource. You specify the configuration
/// as a type-value pair. You can specify only one type of access control configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum Configuration {
    /// <p>The access control configuration is for an IAM role. </p>
    IamRole(crate::model::IamRoleConfiguration),
    /// <p>The access control configuration is for a KMS key. </p>
    KmsKey(crate::model::KmsKeyConfiguration),
    /// <p>The access control configuration is for an Amazon S3 Bucket. </p>
    S3Bucket(crate::model::S3BucketConfiguration),
    /// <p>The access control configuration is for a Secrets Manager secret.</p>
    SecretsManagerSecret(crate::model::SecretsManagerSecretConfiguration),
    /// <p>The access control configuration is for an Amazon SQS queue. </p>
    SqsQueue(crate::model::SqsQueueConfiguration),
}
impl Configuration {
    /// Tries to convert the enum instance into [`IamRole`](crate::model::Configuration::IamRole), extracting the inner [`IamRoleConfiguration`](crate::model::IamRoleConfiguration).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_iam_role(&self) -> std::result::Result<&crate::model::IamRoleConfiguration, &Self> {
        if let Configuration::IamRole(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`IamRole`](crate::model::Configuration::IamRole).
    pub fn is_iam_role(&self) -> bool {
        self.as_iam_role().is_ok()
    }
    /// Tries to convert the enum instance into [`KmsKey`](crate::model::Configuration::KmsKey), extracting the inner [`KmsKeyConfiguration`](crate::model::KmsKeyConfiguration).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_kms_key(&self) -> std::result::Result<&crate::model::KmsKeyConfiguration, &Self> {
        if let Configuration::KmsKey(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`KmsKey`](crate::model::Configuration::KmsKey).
    pub fn is_kms_key(&self) -> bool {
        self.as_kms_key().is_ok()
    }
    /// Tries to convert the enum instance into [`S3Bucket`](crate::model::Configuration::S3Bucket), extracting the inner [`S3BucketConfiguration`](crate::model::S3BucketConfiguration).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_s3_bucket(&self) -> std::result::Result<&crate::model::S3BucketConfiguration, &Self> {
        if let Configuration::S3Bucket(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`S3Bucket`](crate::model::Configuration::S3Bucket).
    pub fn is_s3_bucket(&self) -> bool {
        self.as_s3_bucket().is_ok()
    }
    /// Tries to convert the enum instance into [`SecretsManagerSecret`](crate::model::Configuration::SecretsManagerSecret), extracting the inner [`SecretsManagerSecretConfiguration`](crate::model::SecretsManagerSecretConfiguration).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_secrets_manager_secret(
        &self,
    ) -> std::result::Result<&crate::model::SecretsManagerSecretConfiguration, &Self> {
        if let Configuration::SecretsManagerSecret(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`SecretsManagerSecret`](crate::model::Configuration::SecretsManagerSecret).
    pub fn is_secrets_manager_secret(&self) -> bool {
        self.as_secrets_manager_secret().is_ok()
    }
    /// Tries to convert the enum instance into [`SqsQueue`](crate::model::Configuration::SqsQueue), extracting the inner [`SqsQueueConfiguration`](crate::model::SqsQueueConfiguration).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_sqs_queue(&self) -> std::result::Result<&crate::model::SqsQueueConfiguration, &Self> {
        if let Configuration::SqsQueue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`SqsQueue`](crate::model::Configuration::SqsQueue).
    pub fn is_sqs_queue(&self) -> bool {
        self.as_sqs_queue().is_ok()
    }
}

/// <p>The proposed access control configuration for an Amazon SQS queue. You can propose a
/// configuration for a new Amazon SQS queue or an existing Amazon SQS queue that you own by specifying
/// the Amazon SQS policy. If the configuration is for an existing Amazon SQS queue and you do not
/// specify the Amazon SQS policy, the access preview uses the existing Amazon SQS policy for the queue.
/// If the access preview is for a new resource and you do not specify the policy, the access
/// preview assumes an Amazon SQS queue without a policy. To propose deletion of an existing Amazon SQS
/// queue policy, you can specify an empty string for the Amazon SQS policy. For more information
/// about Amazon SQS policy limits, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-policies.html">Quotas related
/// to policies</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqsQueueConfiguration {
    /// <p> The proposed resource policy for the Amazon SQS queue. </p>
    pub queue_policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SqsQueueConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqsQueueConfiguration");
        formatter.field("queue_policy", &self.queue_policy);
        formatter.finish()
    }
}
/// See [`SqsQueueConfiguration`](crate::model::SqsQueueConfiguration)
pub mod sqs_queue_configuration {
    /// A builder for [`SqsQueueConfiguration`](crate::model::SqsQueueConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The proposed resource policy for the Amazon SQS queue. </p>
        pub fn queue_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_policy = Some(input.into());
            self
        }
        /// <p> The proposed resource policy for the Amazon SQS queue. </p>
        pub fn set_queue_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`SqsQueueConfiguration`](crate::model::SqsQueueConfiguration)
        pub fn build(self) -> crate::model::SqsQueueConfiguration {
            crate::model::SqsQueueConfiguration {
                queue_policy: self.queue_policy,
            }
        }
    }
}
impl SqsQueueConfiguration {
    /// Creates a new builder-style object to manufacture [`SqsQueueConfiguration`](crate::model::SqsQueueConfiguration)
    pub fn builder() -> crate::model::sqs_queue_configuration::Builder {
        crate::model::sqs_queue_configuration::Builder::default()
    }
}

/// <p>Proposed access control configuration for an Amazon S3 bucket. You can propose a
/// configuration for a new Amazon S3 bucket or an existing Amazon S3 bucket that you own by specifying
/// the Amazon S3 bucket policy, bucket ACLs, bucket BPA settings, Amazon S3 access points, and
/// multi-region access points attached to the bucket. If the configuration is for an existing
/// Amazon S3 bucket and you do not specify the Amazon S3 bucket policy, the access preview uses the
/// existing policy attached to the bucket. If the access preview is for a new resource and you
/// do not specify the Amazon S3 bucket policy, the access preview assumes a bucket without a
/// policy. To propose deletion of an existing bucket policy, you can specify an empty string.
/// For more information about bucket policy limits, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html">Bucket Policy
/// Examples</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3BucketConfiguration {
    /// <p>The proposed bucket policy for the Amazon S3 bucket.</p>
    pub bucket_policy: std::option::Option<std::string::String>,
    /// <p>The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to 100 ACL
    /// grants per bucket. If the proposed grant configuration is for an existing bucket, the
    /// access preview uses the proposed list of grant configurations in place of the existing
    /// grants. Otherwise, the access preview uses the existing grants for the bucket.</p>
    pub bucket_acl_grants:
        std::option::Option<std::vec::Vec<crate::model::S3BucketAclGrantConfiguration>>,
    /// <p>The proposed block public access configuration for the Amazon S3 bucket.</p>
    pub bucket_public_access_block:
        std::option::Option<crate::model::S3PublicAccessBlockConfiguration>,
    /// <p>The configuration of Amazon S3 access points or multi-region access points for the bucket.
    /// You can propose up to 10 new access points per bucket.</p>
    pub access_points: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::S3AccessPointConfiguration>,
    >,
}
impl std::fmt::Debug for S3BucketConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3BucketConfiguration");
        formatter.field("bucket_policy", &self.bucket_policy);
        formatter.field("bucket_acl_grants", &self.bucket_acl_grants);
        formatter.field(
            "bucket_public_access_block",
            &self.bucket_public_access_block,
        );
        formatter.field("access_points", &self.access_points);
        formatter.finish()
    }
}
/// See [`S3BucketConfiguration`](crate::model::S3BucketConfiguration)
pub mod s3_bucket_configuration {
    /// A builder for [`S3BucketConfiguration`](crate::model::S3BucketConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_policy: std::option::Option<std::string::String>,
        pub(crate) bucket_acl_grants:
            std::option::Option<std::vec::Vec<crate::model::S3BucketAclGrantConfiguration>>,
        pub(crate) bucket_public_access_block:
            std::option::Option<crate::model::S3PublicAccessBlockConfiguration>,
        pub(crate) access_points: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::S3AccessPointConfiguration,
            >,
        >,
    }
    impl Builder {
        /// <p>The proposed bucket policy for the Amazon S3 bucket.</p>
        pub fn bucket_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_policy = Some(input.into());
            self
        }
        /// <p>The proposed bucket policy for the Amazon S3 bucket.</p>
        pub fn set_bucket_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_policy = input;
            self
        }
        /// Appends an item to `bucket_acl_grants`.
        ///
        /// To override the contents of this collection use [`set_bucket_acl_grants`](Self::set_bucket_acl_grants).
        ///
        /// <p>The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to 100 ACL
        /// grants per bucket. If the proposed grant configuration is for an existing bucket, the
        /// access preview uses the proposed list of grant configurations in place of the existing
        /// grants. Otherwise, the access preview uses the existing grants for the bucket.</p>
        pub fn bucket_acl_grants(
            mut self,
            input: impl Into<crate::model::S3BucketAclGrantConfiguration>,
        ) -> Self {
            let mut v = self.bucket_acl_grants.unwrap_or_default();
            v.push(input.into());
            self.bucket_acl_grants = Some(v);
            self
        }
        /// <p>The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to 100 ACL
        /// grants per bucket. If the proposed grant configuration is for an existing bucket, the
        /// access preview uses the proposed list of grant configurations in place of the existing
        /// grants. Otherwise, the access preview uses the existing grants for the bucket.</p>
        pub fn set_bucket_acl_grants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3BucketAclGrantConfiguration>>,
        ) -> Self {
            self.bucket_acl_grants = input;
            self
        }
        /// <p>The proposed block public access configuration for the Amazon S3 bucket.</p>
        pub fn bucket_public_access_block(
            mut self,
            input: crate::model::S3PublicAccessBlockConfiguration,
        ) -> Self {
            self.bucket_public_access_block = Some(input);
            self
        }
        /// <p>The proposed block public access configuration for the Amazon S3 bucket.</p>
        pub fn set_bucket_public_access_block(
            mut self,
            input: std::option::Option<crate::model::S3PublicAccessBlockConfiguration>,
        ) -> Self {
            self.bucket_public_access_block = input;
            self
        }
        /// Adds a key-value pair to `access_points`.
        ///
        /// To override the contents of this collection use [`set_access_points`](Self::set_access_points).
        ///
        /// <p>The configuration of Amazon S3 access points or multi-region access points for the bucket.
        /// You can propose up to 10 new access points per bucket.</p>
        pub fn access_points(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::S3AccessPointConfiguration>,
        ) -> Self {
            let mut hash_map = self.access_points.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.access_points = Some(hash_map);
            self
        }
        /// <p>The configuration of Amazon S3 access points or multi-region access points for the bucket.
        /// You can propose up to 10 new access points per bucket.</p>
        pub fn set_access_points(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::S3AccessPointConfiguration,
                >,
            >,
        ) -> Self {
            self.access_points = input;
            self
        }
        /// Consumes the builder and constructs a [`S3BucketConfiguration`](crate::model::S3BucketConfiguration)
        pub fn build(self) -> crate::model::S3BucketConfiguration {
            crate::model::S3BucketConfiguration {
                bucket_policy: self.bucket_policy,
                bucket_acl_grants: self.bucket_acl_grants,
                bucket_public_access_block: self.bucket_public_access_block,
                access_points: self.access_points,
            }
        }
    }
}
impl S3BucketConfiguration {
    /// Creates a new builder-style object to manufacture [`S3BucketConfiguration`](crate::model::S3BucketConfiguration)
    pub fn builder() -> crate::model::s3_bucket_configuration::Builder {
        crate::model::s3_bucket_configuration::Builder::default()
    }
}

/// <p>The configuration for an Amazon S3 access point or multi-region access point for the bucket.
/// You can propose up to 10 access points or multi-region access points per bucket. If the
/// proposed Amazon S3 access point configuration is for an existing bucket, the access preview uses
/// the proposed access point configuration in place of the existing access points. To propose
/// an access point without a policy, you can provide an empty string as the access point
/// policy. For more information, see <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html">Creating access points</a>. For more information about access point policy limits,
/// see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points-restrictions-limitations.html">Access points
/// restrictions and limitations</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3AccessPointConfiguration {
    /// <p>The access point or multi-region access point policy.</p>
    pub access_point_policy: std::option::Option<std::string::String>,
    /// <p>The proposed <code>S3PublicAccessBlock</code> configuration to apply to this Amazon S3 access
    /// point or multi-region access point.</p>
    pub public_access_block: std::option::Option<crate::model::S3PublicAccessBlockConfiguration>,
    /// <p>The proposed <code>Internet</code> and <code>VpcConfiguration</code> to apply to this
    /// Amazon S3 access point. <code>VpcConfiguration</code> does not apply to multi-region access
    /// points. If the access preview is for a new resource and neither is specified, the access
    /// preview uses <code>Internet</code> for the network origin. If the access preview is for an
    /// existing resource and neither is specified, the access preview uses the exiting network
    /// origin.</p>
    pub network_origin: std::option::Option<crate::model::NetworkOriginConfiguration>,
}
impl std::fmt::Debug for S3AccessPointConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3AccessPointConfiguration");
        formatter.field("access_point_policy", &self.access_point_policy);
        formatter.field("public_access_block", &self.public_access_block);
        formatter.field("network_origin", &self.network_origin);
        formatter.finish()
    }
}
/// See [`S3AccessPointConfiguration`](crate::model::S3AccessPointConfiguration)
pub mod s3_access_point_configuration {
    /// A builder for [`S3AccessPointConfiguration`](crate::model::S3AccessPointConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_point_policy: std::option::Option<std::string::String>,
        pub(crate) public_access_block:
            std::option::Option<crate::model::S3PublicAccessBlockConfiguration>,
        pub(crate) network_origin: std::option::Option<crate::model::NetworkOriginConfiguration>,
    }
    impl Builder {
        /// <p>The access point or multi-region access point policy.</p>
        pub fn access_point_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_policy = Some(input.into());
            self
        }
        /// <p>The access point or multi-region access point policy.</p>
        pub fn set_access_point_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_policy = input;
            self
        }
        /// <p>The proposed <code>S3PublicAccessBlock</code> configuration to apply to this Amazon S3 access
        /// point or multi-region access point.</p>
        pub fn public_access_block(
            mut self,
            input: crate::model::S3PublicAccessBlockConfiguration,
        ) -> Self {
            self.public_access_block = Some(input);
            self
        }
        /// <p>The proposed <code>S3PublicAccessBlock</code> configuration to apply to this Amazon S3 access
        /// point or multi-region access point.</p>
        pub fn set_public_access_block(
            mut self,
            input: std::option::Option<crate::model::S3PublicAccessBlockConfiguration>,
        ) -> Self {
            self.public_access_block = input;
            self
        }
        /// <p>The proposed <code>Internet</code> and <code>VpcConfiguration</code> to apply to this
        /// Amazon S3 access point. <code>VpcConfiguration</code> does not apply to multi-region access
        /// points. If the access preview is for a new resource and neither is specified, the access
        /// preview uses <code>Internet</code> for the network origin. If the access preview is for an
        /// existing resource and neither is specified, the access preview uses the exiting network
        /// origin.</p>
        pub fn network_origin(mut self, input: crate::model::NetworkOriginConfiguration) -> Self {
            self.network_origin = Some(input);
            self
        }
        /// <p>The proposed <code>Internet</code> and <code>VpcConfiguration</code> to apply to this
        /// Amazon S3 access point. <code>VpcConfiguration</code> does not apply to multi-region access
        /// points. If the access preview is for a new resource and neither is specified, the access
        /// preview uses <code>Internet</code> for the network origin. If the access preview is for an
        /// existing resource and neither is specified, the access preview uses the exiting network
        /// origin.</p>
        pub fn set_network_origin(
            mut self,
            input: std::option::Option<crate::model::NetworkOriginConfiguration>,
        ) -> Self {
            self.network_origin = input;
            self
        }
        /// Consumes the builder and constructs a [`S3AccessPointConfiguration`](crate::model::S3AccessPointConfiguration)
        pub fn build(self) -> crate::model::S3AccessPointConfiguration {
            crate::model::S3AccessPointConfiguration {
                access_point_policy: self.access_point_policy,
                public_access_block: self.public_access_block,
                network_origin: self.network_origin,
            }
        }
    }
}
impl S3AccessPointConfiguration {
    /// Creates a new builder-style object to manufacture [`S3AccessPointConfiguration`](crate::model::S3AccessPointConfiguration)
    pub fn builder() -> crate::model::s3_access_point_configuration::Builder {
        crate::model::s3_access_point_configuration::Builder::default()
    }
}

/// <p>The proposed <code>InternetConfiguration</code> or <code>VpcConfiguration</code> to
/// apply to the Amazon S3 access point. <code>VpcConfiguration</code> does not apply to
/// multi-region access points. You can make the access point accessible from the internet, or
/// you can specify that all requests made through that access point must originate from a
/// specific virtual private cloud (VPC). You can specify only one type of network
/// configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html">Creating access
/// points</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum NetworkOriginConfiguration {
    /// <p>The configuration for the Amazon S3 access point or multi-region access point with an
    /// <code>Internet</code> origin.</p>
    InternetConfiguration(crate::model::InternetConfiguration),
    /// <p>The proposed virtual private cloud (VPC) configuration for the Amazon S3 access point. VPC
    /// configuration does not apply to multi-region access points. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_VpcConfiguration.html">VpcConfiguration</a>. </p>
    VpcConfiguration(crate::model::VpcConfiguration),
}
impl NetworkOriginConfiguration {
    /// Tries to convert the enum instance into [`InternetConfiguration`](crate::model::NetworkOriginConfiguration::InternetConfiguration), extracting the inner [`InternetConfiguration`](crate::model::InternetConfiguration).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_internet_configuration(
        &self,
    ) -> std::result::Result<&crate::model::InternetConfiguration, &Self> {
        if let NetworkOriginConfiguration::InternetConfiguration(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`InternetConfiguration`](crate::model::NetworkOriginConfiguration::InternetConfiguration).
    pub fn is_internet_configuration(&self) -> bool {
        self.as_internet_configuration().is_ok()
    }
    /// Tries to convert the enum instance into [`VpcConfiguration`](crate::model::NetworkOriginConfiguration::VpcConfiguration), extracting the inner [`VpcConfiguration`](crate::model::VpcConfiguration).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_vpc_configuration(
        &self,
    ) -> std::result::Result<&crate::model::VpcConfiguration, &Self> {
        if let NetworkOriginConfiguration::VpcConfiguration(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`VpcConfiguration`](crate::model::NetworkOriginConfiguration::VpcConfiguration).
    pub fn is_vpc_configuration(&self) -> bool {
        self.as_vpc_configuration().is_ok()
    }
}

/// <p>This configuration sets the network origin for the Amazon S3 access point or multi-region
/// access point to <code>Internet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternetConfiguration {}
impl std::fmt::Debug for InternetConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternetConfiguration");
        formatter.finish()
    }
}
/// See [`InternetConfiguration`](crate::model::InternetConfiguration)
pub mod internet_configuration {
    /// A builder for [`InternetConfiguration`](crate::model::InternetConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`InternetConfiguration`](crate::model::InternetConfiguration)
        pub fn build(self) -> crate::model::InternetConfiguration {
            crate::model::InternetConfiguration {}
        }
    }
}
impl InternetConfiguration {
    /// Creates a new builder-style object to manufacture [`InternetConfiguration`](crate::model::InternetConfiguration)
    pub fn builder() -> crate::model::internet_configuration::Builder {
        crate::model::internet_configuration::Builder::default()
    }
}

/// <p>The proposed virtual private cloud (VPC) configuration for the Amazon S3 access point. VPC
/// configuration does not apply to multi-region access points. For more information, see
/// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_VpcConfiguration.html">VpcConfiguration</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfiguration {
    /// <p> If this field is specified, this access point will only allow connections from the
    /// specified VPC ID. </p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VpcConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfiguration");
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`VpcConfiguration`](crate::model::VpcConfiguration)
pub mod vpc_configuration {
    /// A builder for [`VpcConfiguration`](crate::model::VpcConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> If this field is specified, this access point will only allow connections from the
        /// specified VPC ID. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p> If this field is specified, this access point will only allow connections from the
        /// specified VPC ID. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfiguration`](crate::model::VpcConfiguration)
        pub fn build(self) -> crate::model::VpcConfiguration {
            crate::model::VpcConfiguration {
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl VpcConfiguration {
    /// Creates a new builder-style object to manufacture [`VpcConfiguration`](crate::model::VpcConfiguration)
    pub fn builder() -> crate::model::vpc_configuration::Builder {
        crate::model::vpc_configuration::Builder::default()
    }
}

/// <p>The <code>PublicAccessBlock</code> configuration to apply to this Amazon S3 bucket. If the
/// proposed configuration is for an existing Amazon S3 bucket and the configuration is not
/// specified, the access preview uses the existing setting. If the proposed configuration is
/// for a new bucket and the configuration is not specified, the access preview uses
/// <code>false</code>. If the proposed configuration is for a new access point or
/// multi-region access point and the access point BPA configuration is not specified, the
/// access preview uses <code>true</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html">PublicAccessBlockConfiguration</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3PublicAccessBlockConfiguration {
    /// <p> Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this
    /// bucket. </p>
    pub ignore_public_acls: std::option::Option<bool>,
    /// <p> Specifies whether Amazon S3 should restrict public bucket policies for this bucket. </p>
    pub restrict_public_buckets: std::option::Option<bool>,
}
impl std::fmt::Debug for S3PublicAccessBlockConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3PublicAccessBlockConfiguration");
        formatter.field("ignore_public_acls", &self.ignore_public_acls);
        formatter.field("restrict_public_buckets", &self.restrict_public_buckets);
        formatter.finish()
    }
}
/// See [`S3PublicAccessBlockConfiguration`](crate::model::S3PublicAccessBlockConfiguration)
pub mod s3_public_access_block_configuration {
    /// A builder for [`S3PublicAccessBlockConfiguration`](crate::model::S3PublicAccessBlockConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ignore_public_acls: std::option::Option<bool>,
        pub(crate) restrict_public_buckets: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this
        /// bucket. </p>
        pub fn ignore_public_acls(mut self, input: bool) -> Self {
            self.ignore_public_acls = Some(input);
            self
        }
        /// <p> Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this
        /// bucket. </p>
        pub fn set_ignore_public_acls(mut self, input: std::option::Option<bool>) -> Self {
            self.ignore_public_acls = input;
            self
        }
        /// <p> Specifies whether Amazon S3 should restrict public bucket policies for this bucket. </p>
        pub fn restrict_public_buckets(mut self, input: bool) -> Self {
            self.restrict_public_buckets = Some(input);
            self
        }
        /// <p> Specifies whether Amazon S3 should restrict public bucket policies for this bucket. </p>
        pub fn set_restrict_public_buckets(mut self, input: std::option::Option<bool>) -> Self {
            self.restrict_public_buckets = input;
            self
        }
        /// Consumes the builder and constructs a [`S3PublicAccessBlockConfiguration`](crate::model::S3PublicAccessBlockConfiguration)
        pub fn build(self) -> crate::model::S3PublicAccessBlockConfiguration {
            crate::model::S3PublicAccessBlockConfiguration {
                ignore_public_acls: self.ignore_public_acls,
                restrict_public_buckets: self.restrict_public_buckets,
            }
        }
    }
}
impl S3PublicAccessBlockConfiguration {
    /// Creates a new builder-style object to manufacture [`S3PublicAccessBlockConfiguration`](crate::model::S3PublicAccessBlockConfiguration)
    pub fn builder() -> crate::model::s3_public_access_block_configuration::Builder {
        crate::model::s3_public_access_block_configuration::Builder::default()
    }
}

/// <p>A proposed access control list grant configuration for an Amazon S3 bucket. For more
/// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#setting-acls">How to Specify an
/// ACL</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3BucketAclGrantConfiguration {
    /// <p>The permissions being granted.</p>
    pub permission: std::option::Option<crate::model::AclPermission>,
    /// <p>The grantee to whom you’re assigning access rights.</p>
    pub grantee: std::option::Option<crate::model::AclGrantee>,
}
impl std::fmt::Debug for S3BucketAclGrantConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3BucketAclGrantConfiguration");
        formatter.field("permission", &self.permission);
        formatter.field("grantee", &self.grantee);
        formatter.finish()
    }
}
/// See [`S3BucketAclGrantConfiguration`](crate::model::S3BucketAclGrantConfiguration)
pub mod s3_bucket_acl_grant_configuration {
    /// A builder for [`S3BucketAclGrantConfiguration`](crate::model::S3BucketAclGrantConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission: std::option::Option<crate::model::AclPermission>,
        pub(crate) grantee: std::option::Option<crate::model::AclGrantee>,
    }
    impl Builder {
        /// <p>The permissions being granted.</p>
        pub fn permission(mut self, input: crate::model::AclPermission) -> Self {
            self.permission = Some(input);
            self
        }
        /// <p>The permissions being granted.</p>
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::AclPermission>,
        ) -> Self {
            self.permission = input;
            self
        }
        /// <p>The grantee to whom you’re assigning access rights.</p>
        pub fn grantee(mut self, input: crate::model::AclGrantee) -> Self {
            self.grantee = Some(input);
            self
        }
        /// <p>The grantee to whom you’re assigning access rights.</p>
        pub fn set_grantee(mut self, input: std::option::Option<crate::model::AclGrantee>) -> Self {
            self.grantee = input;
            self
        }
        /// Consumes the builder and constructs a [`S3BucketAclGrantConfiguration`](crate::model::S3BucketAclGrantConfiguration)
        pub fn build(self) -> crate::model::S3BucketAclGrantConfiguration {
            crate::model::S3BucketAclGrantConfiguration {
                permission: self.permission,
                grantee: self.grantee,
            }
        }
    }
}
impl S3BucketAclGrantConfiguration {
    /// Creates a new builder-style object to manufacture [`S3BucketAclGrantConfiguration`](crate::model::S3BucketAclGrantConfiguration)
    pub fn builder() -> crate::model::s3_bucket_acl_grant_configuration::Builder {
        crate::model::s3_bucket_acl_grant_configuration::Builder::default()
    }
}

/// <p>You specify each grantee as a type-value pair using one of these types. You can specify
/// only one type of grantee. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAcl.html">PutBucketAcl</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AclGrantee {
    /// <p>The value specified is the canonical user ID of an Amazon Web Services account.</p>
    Id(std::string::String),
    /// <p>Used for granting permissions to a predefined group.</p>
    Uri(std::string::String),
}
impl AclGrantee {
    /// Tries to convert the enum instance into [`Id`](crate::model::AclGrantee::Id), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_id(&self) -> std::result::Result<&std::string::String, &Self> {
        if let AclGrantee::Id(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Id`](crate::model::AclGrantee::Id).
    pub fn is_id(&self) -> bool {
        self.as_id().is_ok()
    }
    /// Tries to convert the enum instance into [`Uri`](crate::model::AclGrantee::Uri), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_uri(&self) -> std::result::Result<&std::string::String, &Self> {
        if let AclGrantee::Uri(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Uri`](crate::model::AclGrantee::Uri).
    pub fn is_uri(&self) -> bool {
        self.as_uri().is_ok()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AclPermission {
    #[allow(missing_docs)] // documentation missing in model
    FullControl,
    #[allow(missing_docs)] // documentation missing in model
    Read,
    #[allow(missing_docs)] // documentation missing in model
    ReadAcp,
    #[allow(missing_docs)] // documentation missing in model
    Write,
    #[allow(missing_docs)] // documentation missing in model
    WriteAcp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AclPermission {
    fn from(s: &str) -> Self {
        match s {
            "FULL_CONTROL" => AclPermission::FullControl,
            "READ" => AclPermission::Read,
            "READ_ACP" => AclPermission::ReadAcp,
            "WRITE" => AclPermission::Write,
            "WRITE_ACP" => AclPermission::WriteAcp,
            other => AclPermission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AclPermission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AclPermission::from(s))
    }
}
impl AclPermission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AclPermission::FullControl => "FULL_CONTROL",
            AclPermission::Read => "READ",
            AclPermission::ReadAcp => "READ_ACP",
            AclPermission::Write => "WRITE",
            AclPermission::WriteAcp => "WRITE_ACP",
            AclPermission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL_CONTROL", "READ", "READ_ACP", "WRITE", "WRITE_ACP"]
    }
}
impl AsRef<str> for AclPermission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration for a Secrets Manager secret. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html">CreateSecret</a>.</p>
/// <p>You can propose a configuration for a new secret or an existing secret that you own by
/// specifying the secret policy and optional KMS encryption key. If the configuration is for
/// an existing secret and you do not specify the secret policy, the access preview uses the
/// existing policy for the secret. If the access preview is for a new resource and you do not
/// specify the policy, the access preview assumes a secret without a policy. To propose
/// deletion of an existing policy, you can specify an empty string. If the proposed
/// configuration is for a new secret and you do not specify the KMS key ID, the access
/// preview uses the default CMK of the Amazon Web Services account. If you specify an empty string for the
/// KMS key ID, the access preview uses the default CMK of the Amazon Web Services account. For more
/// information about secret policy limits, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_limits.html">Quotas for
/// Secrets Manager.</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecretsManagerSecretConfiguration {
    /// <p>The proposed ARN, key ID, or alias of the KMS customer master key (CMK).</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The proposed resource policy defining who can access or manage the secret.</p>
    pub secret_policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SecretsManagerSecretConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecretsManagerSecretConfiguration");
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("secret_policy", &self.secret_policy);
        formatter.finish()
    }
}
/// See [`SecretsManagerSecretConfiguration`](crate::model::SecretsManagerSecretConfiguration)
pub mod secrets_manager_secret_configuration {
    /// A builder for [`SecretsManagerSecretConfiguration`](crate::model::SecretsManagerSecretConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) secret_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The proposed ARN, key ID, or alias of the KMS customer master key (CMK).</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The proposed ARN, key ID, or alias of the KMS customer master key (CMK).</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The proposed resource policy defining who can access or manage the secret.</p>
        pub fn secret_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_policy = Some(input.into());
            self
        }
        /// <p>The proposed resource policy defining who can access or manage the secret.</p>
        pub fn set_secret_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`SecretsManagerSecretConfiguration`](crate::model::SecretsManagerSecretConfiguration)
        pub fn build(self) -> crate::model::SecretsManagerSecretConfiguration {
            crate::model::SecretsManagerSecretConfiguration {
                kms_key_id: self.kms_key_id,
                secret_policy: self.secret_policy,
            }
        }
    }
}
impl SecretsManagerSecretConfiguration {
    /// Creates a new builder-style object to manufacture [`SecretsManagerSecretConfiguration`](crate::model::SecretsManagerSecretConfiguration)
    pub fn builder() -> crate::model::secrets_manager_secret_configuration::Builder {
        crate::model::secrets_manager_secret_configuration::Builder::default()
    }
}

/// <p>Proposed access control configuration for a KMS key. You can propose a configuration
/// for a new KMS key or an existing KMS key that you own by specifying the key policy and
/// KMS grant configuration. If the configuration is for an existing key and you do not
/// specify the key policy, the access preview uses the existing policy for the key. If the
/// access preview is for a new resource and you do not specify the key policy, then the access
/// preview uses the default key policy. The proposed key policy cannot be an empty string. For
/// more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key
/// policy</a>. For more information about key policy limits, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html">Resource
/// quotas</a>.</p>
/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsKeyConfiguration {
    /// <p>Resource policy configuration for the KMS key. The only valid value for the name of
    /// the key policy is <code>default</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key
    /// policy</a>.</p>
    pub key_policies:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of proposed grant configurations for the KMS key. If the proposed grant
    /// configuration is for an existing key, the access preview uses the proposed list of grant
    /// configurations in place of the existing grants. Otherwise, the access preview uses the
    /// existing grants for the key.</p>
    pub grants: std::option::Option<std::vec::Vec<crate::model::KmsGrantConfiguration>>,
}
impl std::fmt::Debug for KmsKeyConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsKeyConfiguration");
        formatter.field("key_policies", &self.key_policies);
        formatter.field("grants", &self.grants);
        formatter.finish()
    }
}
/// See [`KmsKeyConfiguration`](crate::model::KmsKeyConfiguration)
pub mod kms_key_configuration {
    /// A builder for [`KmsKeyConfiguration`](crate::model::KmsKeyConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_policies: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) grants: std::option::Option<std::vec::Vec<crate::model::KmsGrantConfiguration>>,
    }
    impl Builder {
        /// Adds a key-value pair to `key_policies`.
        ///
        /// To override the contents of this collection use [`set_key_policies`](Self::set_key_policies).
        ///
        /// <p>Resource policy configuration for the KMS key. The only valid value for the name of
        /// the key policy is <code>default</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key
        /// policy</a>.</p>
        pub fn key_policies(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.key_policies.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.key_policies = Some(hash_map);
            self
        }
        /// <p>Resource policy configuration for the KMS key. The only valid value for the name of
        /// the key policy is <code>default</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key
        /// policy</a>.</p>
        pub fn set_key_policies(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.key_policies = input;
            self
        }
        /// Appends an item to `grants`.
        ///
        /// To override the contents of this collection use [`set_grants`](Self::set_grants).
        ///
        /// <p>A list of proposed grant configurations for the KMS key. If the proposed grant
        /// configuration is for an existing key, the access preview uses the proposed list of grant
        /// configurations in place of the existing grants. Otherwise, the access preview uses the
        /// existing grants for the key.</p>
        pub fn grants(mut self, input: impl Into<crate::model::KmsGrantConfiguration>) -> Self {
            let mut v = self.grants.unwrap_or_default();
            v.push(input.into());
            self.grants = Some(v);
            self
        }
        /// <p>A list of proposed grant configurations for the KMS key. If the proposed grant
        /// configuration is for an existing key, the access preview uses the proposed list of grant
        /// configurations in place of the existing grants. Otherwise, the access preview uses the
        /// existing grants for the key.</p>
        pub fn set_grants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KmsGrantConfiguration>>,
        ) -> Self {
            self.grants = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsKeyConfiguration`](crate::model::KmsKeyConfiguration)
        pub fn build(self) -> crate::model::KmsKeyConfiguration {
            crate::model::KmsKeyConfiguration {
                key_policies: self.key_policies,
                grants: self.grants,
            }
        }
    }
}
impl KmsKeyConfiguration {
    /// Creates a new builder-style object to manufacture [`KmsKeyConfiguration`](crate::model::KmsKeyConfiguration)
    pub fn builder() -> crate::model::kms_key_configuration::Builder {
        crate::model::kms_key_configuration::Builder::default()
    }
}

/// <p>A proposed grant configuration for a KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsGrantConfiguration {
    /// <p>A list of operations that the grant permits.</p>
    pub operations: std::option::Option<std::vec::Vec<crate::model::KmsGrantOperation>>,
    /// <p>The principal that is given permission to perform the operations that the grant
    /// permits.</p>
    pub grantee_principal: std::option::Option<std::string::String>,
    /// <p>The principal that is given permission to retire the grant by using <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html">RetireGrant</a> operation.</p>
    pub retiring_principal: std::option::Option<std::string::String>,
    /// <p>Use this structure to propose allowing <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
    /// operations</a> in the grant only when the operation request includes the specified
    /// <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption
    /// context</a>.</p>
    pub constraints: std::option::Option<crate::model::KmsGrantConstraints>,
    /// <p> The Amazon Web Services account under which the grant was issued. The account is used to propose
    /// KMS grants issued by accounts other than the owner of the key.</p>
    pub issuing_account: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsGrantConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsGrantConfiguration");
        formatter.field("operations", &self.operations);
        formatter.field("grantee_principal", &self.grantee_principal);
        formatter.field("retiring_principal", &self.retiring_principal);
        formatter.field("constraints", &self.constraints);
        formatter.field("issuing_account", &self.issuing_account);
        formatter.finish()
    }
}
/// See [`KmsGrantConfiguration`](crate::model::KmsGrantConfiguration)
pub mod kms_grant_configuration {
    /// A builder for [`KmsGrantConfiguration`](crate::model::KmsGrantConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operations: std::option::Option<std::vec::Vec<crate::model::KmsGrantOperation>>,
        pub(crate) grantee_principal: std::option::Option<std::string::String>,
        pub(crate) retiring_principal: std::option::Option<std::string::String>,
        pub(crate) constraints: std::option::Option<crate::model::KmsGrantConstraints>,
        pub(crate) issuing_account: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>A list of operations that the grant permits.</p>
        pub fn operations(mut self, input: impl Into<crate::model::KmsGrantOperation>) -> Self {
            let mut v = self.operations.unwrap_or_default();
            v.push(input.into());
            self.operations = Some(v);
            self
        }
        /// <p>A list of operations that the grant permits.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KmsGrantOperation>>,
        ) -> Self {
            self.operations = input;
            self
        }
        /// <p>The principal that is given permission to perform the operations that the grant
        /// permits.</p>
        pub fn grantee_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantee_principal = Some(input.into());
            self
        }
        /// <p>The principal that is given permission to perform the operations that the grant
        /// permits.</p>
        pub fn set_grantee_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grantee_principal = input;
            self
        }
        /// <p>The principal that is given permission to retire the grant by using <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html">RetireGrant</a> operation.</p>
        pub fn retiring_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.retiring_principal = Some(input.into());
            self
        }
        /// <p>The principal that is given permission to retire the grant by using <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html">RetireGrant</a> operation.</p>
        pub fn set_retiring_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retiring_principal = input;
            self
        }
        /// <p>Use this structure to propose allowing <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
        /// operations</a> in the grant only when the operation request includes the specified
        /// <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption
        /// context</a>.</p>
        pub fn constraints(mut self, input: crate::model::KmsGrantConstraints) -> Self {
            self.constraints = Some(input);
            self
        }
        /// <p>Use this structure to propose allowing <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
        /// operations</a> in the grant only when the operation request includes the specified
        /// <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption
        /// context</a>.</p>
        pub fn set_constraints(
            mut self,
            input: std::option::Option<crate::model::KmsGrantConstraints>,
        ) -> Self {
            self.constraints = input;
            self
        }
        /// <p> The Amazon Web Services account under which the grant was issued. The account is used to propose
        /// KMS grants issued by accounts other than the owner of the key.</p>
        pub fn issuing_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuing_account = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services account under which the grant was issued. The account is used to propose
        /// KMS grants issued by accounts other than the owner of the key.</p>
        pub fn set_issuing_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.issuing_account = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsGrantConfiguration`](crate::model::KmsGrantConfiguration)
        pub fn build(self) -> crate::model::KmsGrantConfiguration {
            crate::model::KmsGrantConfiguration {
                operations: self.operations,
                grantee_principal: self.grantee_principal,
                retiring_principal: self.retiring_principal,
                constraints: self.constraints,
                issuing_account: self.issuing_account,
            }
        }
    }
}
impl KmsGrantConfiguration {
    /// Creates a new builder-style object to manufacture [`KmsGrantConfiguration`](crate::model::KmsGrantConfiguration)
    pub fn builder() -> crate::model::kms_grant_configuration::Builder {
        crate::model::kms_grant_configuration::Builder::default()
    }
}

/// <p>Use this structure to propose allowing <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
/// operations</a> in the grant only when the operation request includes the specified
/// <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption
/// context</a>. You can specify only one type of encryption context. An empty map is
/// treated as not specified. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_GrantConstraints.html">GrantConstraints</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsGrantConstraints {
    /// <p>A list of key-value pairs that must match the encryption context in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
    /// operation</a> request. The grant allows the operation only when the encryption
    /// context in the request is the same as the encryption context specified in this
    /// constraint.</p>
    pub encryption_context_equals:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of key-value pairs that must be included in the encryption context of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
    /// operation</a> request. The grant allows the cryptographic operation only when the
    /// encryption context in the request includes the key-value pairs specified in this
    /// constraint, although it can include additional key-value pairs.</p>
    pub encryption_context_subset:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for KmsGrantConstraints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsGrantConstraints");
        formatter.field("encryption_context_equals", &self.encryption_context_equals);
        formatter.field("encryption_context_subset", &self.encryption_context_subset);
        formatter.finish()
    }
}
/// See [`KmsGrantConstraints`](crate::model::KmsGrantConstraints)
pub mod kms_grant_constraints {
    /// A builder for [`KmsGrantConstraints`](crate::model::KmsGrantConstraints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_context_equals: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) encryption_context_subset: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `encryption_context_equals`.
        ///
        /// To override the contents of this collection use [`set_encryption_context_equals`](Self::set_encryption_context_equals).
        ///
        /// <p>A list of key-value pairs that must match the encryption context in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
        /// operation</a> request. The grant allows the operation only when the encryption
        /// context in the request is the same as the encryption context specified in this
        /// constraint.</p>
        pub fn encryption_context_equals(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.encryption_context_equals.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.encryption_context_equals = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that must match the encryption context in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
        /// operation</a> request. The grant allows the operation only when the encryption
        /// context in the request is the same as the encryption context specified in this
        /// constraint.</p>
        pub fn set_encryption_context_equals(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.encryption_context_equals = input;
            self
        }
        /// Adds a key-value pair to `encryption_context_subset`.
        ///
        /// To override the contents of this collection use [`set_encryption_context_subset`](Self::set_encryption_context_subset).
        ///
        /// <p>A list of key-value pairs that must be included in the encryption context of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
        /// operation</a> request. The grant allows the cryptographic operation only when the
        /// encryption context in the request includes the key-value pairs specified in this
        /// constraint, although it can include additional key-value pairs.</p>
        pub fn encryption_context_subset(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.encryption_context_subset.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.encryption_context_subset = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that must be included in the encryption context of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
        /// operation</a> request. The grant allows the cryptographic operation only when the
        /// encryption context in the request includes the key-value pairs specified in this
        /// constraint, although it can include additional key-value pairs.</p>
        pub fn set_encryption_context_subset(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.encryption_context_subset = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsGrantConstraints`](crate::model::KmsGrantConstraints)
        pub fn build(self) -> crate::model::KmsGrantConstraints {
            crate::model::KmsGrantConstraints {
                encryption_context_equals: self.encryption_context_equals,
                encryption_context_subset: self.encryption_context_subset,
            }
        }
    }
}
impl KmsGrantConstraints {
    /// Creates a new builder-style object to manufacture [`KmsGrantConstraints`](crate::model::KmsGrantConstraints)
    pub fn builder() -> crate::model::kms_grant_constraints::Builder {
        crate::model::kms_grant_constraints::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KmsGrantOperation {
    #[allow(missing_docs)] // documentation missing in model
    CreateGrant,
    #[allow(missing_docs)] // documentation missing in model
    Decrypt,
    #[allow(missing_docs)] // documentation missing in model
    DescribeKey,
    #[allow(missing_docs)] // documentation missing in model
    Encrypt,
    #[allow(missing_docs)] // documentation missing in model
    GenerateDataKey,
    #[allow(missing_docs)] // documentation missing in model
    GenerateDataKeyPair,
    #[allow(missing_docs)] // documentation missing in model
    GenerateDataKeyPairWithoutPlaintext,
    #[allow(missing_docs)] // documentation missing in model
    GenerateDataKeyWithoutPlaintext,
    #[allow(missing_docs)] // documentation missing in model
    GetPublicKey,
    #[allow(missing_docs)] // documentation missing in model
    ReencryptFrom,
    #[allow(missing_docs)] // documentation missing in model
    ReencryptTo,
    #[allow(missing_docs)] // documentation missing in model
    RetireGrant,
    #[allow(missing_docs)] // documentation missing in model
    Sign,
    #[allow(missing_docs)] // documentation missing in model
    Verify,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KmsGrantOperation {
    fn from(s: &str) -> Self {
        match s {
            "CreateGrant" => KmsGrantOperation::CreateGrant,
            "Decrypt" => KmsGrantOperation::Decrypt,
            "DescribeKey" => KmsGrantOperation::DescribeKey,
            "Encrypt" => KmsGrantOperation::Encrypt,
            "GenerateDataKey" => KmsGrantOperation::GenerateDataKey,
            "GenerateDataKeyPair" => KmsGrantOperation::GenerateDataKeyPair,
            "GenerateDataKeyPairWithoutPlaintext" => {
                KmsGrantOperation::GenerateDataKeyPairWithoutPlaintext
            }
            "GenerateDataKeyWithoutPlaintext" => KmsGrantOperation::GenerateDataKeyWithoutPlaintext,
            "GetPublicKey" => KmsGrantOperation::GetPublicKey,
            "ReEncryptFrom" => KmsGrantOperation::ReencryptFrom,
            "ReEncryptTo" => KmsGrantOperation::ReencryptTo,
            "RetireGrant" => KmsGrantOperation::RetireGrant,
            "Sign" => KmsGrantOperation::Sign,
            "Verify" => KmsGrantOperation::Verify,
            other => KmsGrantOperation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KmsGrantOperation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KmsGrantOperation::from(s))
    }
}
impl KmsGrantOperation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KmsGrantOperation::CreateGrant => "CreateGrant",
            KmsGrantOperation::Decrypt => "Decrypt",
            KmsGrantOperation::DescribeKey => "DescribeKey",
            KmsGrantOperation::Encrypt => "Encrypt",
            KmsGrantOperation::GenerateDataKey => "GenerateDataKey",
            KmsGrantOperation::GenerateDataKeyPair => "GenerateDataKeyPair",
            KmsGrantOperation::GenerateDataKeyPairWithoutPlaintext => {
                "GenerateDataKeyPairWithoutPlaintext"
            }
            KmsGrantOperation::GenerateDataKeyWithoutPlaintext => "GenerateDataKeyWithoutPlaintext",
            KmsGrantOperation::GetPublicKey => "GetPublicKey",
            KmsGrantOperation::ReencryptFrom => "ReEncryptFrom",
            KmsGrantOperation::ReencryptTo => "ReEncryptTo",
            KmsGrantOperation::RetireGrant => "RetireGrant",
            KmsGrantOperation::Sign => "Sign",
            KmsGrantOperation::Verify => "Verify",
            KmsGrantOperation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CreateGrant",
            "Decrypt",
            "DescribeKey",
            "Encrypt",
            "GenerateDataKey",
            "GenerateDataKeyPair",
            "GenerateDataKeyPairWithoutPlaintext",
            "GenerateDataKeyWithoutPlaintext",
            "GetPublicKey",
            "ReEncryptFrom",
            "ReEncryptTo",
            "RetireGrant",
            "Sign",
            "Verify",
        ]
    }
}
impl AsRef<str> for KmsGrantOperation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The proposed access control configuration for an IAM role. You can propose a
/// configuration for a new IAM role or an existing IAM role that you own by specifying the
/// trust policy. If the configuration is for a new IAM role, you must specify the trust
/// policy. If the configuration is for an existing IAM role that you own and you do not
/// propose the trust policy, the access preview uses the existing trust policy for the role.
/// The proposed trust policy cannot be an empty string. For more information about role trust
/// policy limits, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
/// quotas</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IamRoleConfiguration {
    /// <p>The proposed trust policy for the IAM role.</p>
    pub trust_policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IamRoleConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IamRoleConfiguration");
        formatter.field("trust_policy", &self.trust_policy);
        formatter.finish()
    }
}
/// See [`IamRoleConfiguration`](crate::model::IamRoleConfiguration)
pub mod iam_role_configuration {
    /// A builder for [`IamRoleConfiguration`](crate::model::IamRoleConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trust_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The proposed trust policy for the IAM role.</p>
        pub fn trust_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_policy = Some(input.into());
            self
        }
        /// <p>The proposed trust policy for the IAM role.</p>
        pub fn set_trust_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trust_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`IamRoleConfiguration`](crate::model::IamRoleConfiguration)
        pub fn build(self) -> crate::model::IamRoleConfiguration {
            crate::model::IamRoleConfiguration {
                trust_policy: self.trust_policy,
            }
        }
    }
}
impl IamRoleConfiguration {
    /// Creates a new builder-style object to manufacture [`IamRoleConfiguration`](crate::model::IamRoleConfiguration)
    pub fn builder() -> crate::model::iam_role_configuration::Builder {
        crate::model::iam_role_configuration::Builder::default()
    }
}
