// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The response to the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnalyzersOutput {
    /// <p>The analyzers retrieved.</p>
    pub analyzers: std::option::Option<std::vec::Vec<crate::model::AnalyzerSummary>>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListAnalyzersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnalyzersOutput");
        formatter.field("analyzers", &self.analyzers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAnalyzersOutput`](crate::output::ListAnalyzersOutput)
pub mod list_analyzers_output {
    /// A builder for [`ListAnalyzersOutput`](crate::output::ListAnalyzersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzers: std::option::Option<std::vec::Vec<crate::model::AnalyzerSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `analyzers`.
        ///
        /// To override the contents of this collection use [`set_analyzers`](Self::set_analyzers).
        ///
        /// <p>The analyzers retrieved.</p>
        pub fn analyzers(mut self, input: impl Into<crate::model::AnalyzerSummary>) -> Self {
            let mut v = self.analyzers.unwrap_or_default();
            v.push(input.into());
            self.analyzers = Some(v);
            self
        }
        /// <p>The analyzers retrieved.</p>
        pub fn set_analyzers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalyzerSummary>>,
        ) -> Self {
            self.analyzers = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnalyzersOutput`](crate::output::ListAnalyzersOutput)
        pub fn build(self) -> crate::output::ListAnalyzersOutput {
            crate::output::ListAnalyzersOutput {
                analyzers: self.analyzers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAnalyzersOutput {
    /// Creates a new builder-style object to manufacture [`ListAnalyzersOutput`](crate::output::ListAnalyzersOutput)
    pub fn builder() -> crate::output::list_analyzers_output::Builder {
        crate::output::list_analyzers_output::Builder::default()
    }
}

/// <p>The response to the request to create an analyzer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAnalyzerOutput {
    /// <p>The ARN of the analyzer that was created by the request.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateAnalyzerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAnalyzerOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CreateAnalyzerOutput`](crate::output::CreateAnalyzerOutput)
pub mod create_analyzer_output {
    /// A builder for [`CreateAnalyzerOutput`](crate::output::CreateAnalyzerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the analyzer that was created by the request.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the analyzer that was created by the request.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAnalyzerOutput`](crate::output::CreateAnalyzerOutput)
        pub fn build(self) -> crate::output::CreateAnalyzerOutput {
            crate::output::CreateAnalyzerOutput { arn: self.arn }
        }
    }
}
impl CreateAnalyzerOutput {
    /// Creates a new builder-style object to manufacture [`CreateAnalyzerOutput`](crate::output::CreateAnalyzerOutput)
    pub fn builder() -> crate::output::create_analyzer_output::Builder {
        crate::output::create_analyzer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAnalyzerOutput {}
impl std::fmt::Debug for DeleteAnalyzerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAnalyzerOutput");
        formatter.finish()
    }
}
/// See [`DeleteAnalyzerOutput`](crate::output::DeleteAnalyzerOutput)
pub mod delete_analyzer_output {
    /// A builder for [`DeleteAnalyzerOutput`](crate::output::DeleteAnalyzerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAnalyzerOutput`](crate::output::DeleteAnalyzerOutput)
        pub fn build(self) -> crate::output::DeleteAnalyzerOutput {
            crate::output::DeleteAnalyzerOutput {}
        }
    }
}
impl DeleteAnalyzerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAnalyzerOutput`](crate::output::DeleteAnalyzerOutput)
    pub fn builder() -> crate::output::delete_analyzer_output::Builder {
        crate::output::delete_analyzer_output::Builder::default()
    }
}

/// <p>The response to the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnalyzerOutput {
    /// <p>An <code>AnalyzerSummary</code> object that contains information about the
    /// analyzer.</p>
    pub analyzer: std::option::Option<crate::model::AnalyzerSummary>,
}
impl std::fmt::Debug for GetAnalyzerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnalyzerOutput");
        formatter.field("analyzer", &self.analyzer);
        formatter.finish()
    }
}
/// See [`GetAnalyzerOutput`](crate::output::GetAnalyzerOutput)
pub mod get_analyzer_output {
    /// A builder for [`GetAnalyzerOutput`](crate::output::GetAnalyzerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzer: std::option::Option<crate::model::AnalyzerSummary>,
    }
    impl Builder {
        /// <p>An <code>AnalyzerSummary</code> object that contains information about the
        /// analyzer.</p>
        pub fn analyzer(mut self, input: crate::model::AnalyzerSummary) -> Self {
            self.analyzer = Some(input);
            self
        }
        /// <p>An <code>AnalyzerSummary</code> object that contains information about the
        /// analyzer.</p>
        pub fn set_analyzer(
            mut self,
            input: std::option::Option<crate::model::AnalyzerSummary>,
        ) -> Self {
            self.analyzer = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnalyzerOutput`](crate::output::GetAnalyzerOutput)
        pub fn build(self) -> crate::output::GetAnalyzerOutput {
            crate::output::GetAnalyzerOutput {
                analyzer: self.analyzer,
            }
        }
    }
}
impl GetAnalyzerOutput {
    /// Creates a new builder-style object to manufacture [`GetAnalyzerOutput`](crate::output::GetAnalyzerOutput)
    pub fn builder() -> crate::output::get_analyzer_output::Builder {
        crate::output::get_analyzer_output::Builder::default()
    }
}

/// <p>The response to the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListArchiveRulesOutput {
    /// <p>A list of archive rules created for the specified analyzer.</p>
    pub archive_rules: std::option::Option<std::vec::Vec<crate::model::ArchiveRuleSummary>>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListArchiveRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListArchiveRulesOutput");
        formatter.field("archive_rules", &self.archive_rules);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListArchiveRulesOutput`](crate::output::ListArchiveRulesOutput)
pub mod list_archive_rules_output {
    /// A builder for [`ListArchiveRulesOutput`](crate::output::ListArchiveRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archive_rules:
            std::option::Option<std::vec::Vec<crate::model::ArchiveRuleSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `archive_rules`.
        ///
        /// To override the contents of this collection use [`set_archive_rules`](Self::set_archive_rules).
        ///
        /// <p>A list of archive rules created for the specified analyzer.</p>
        pub fn archive_rules(mut self, input: impl Into<crate::model::ArchiveRuleSummary>) -> Self {
            let mut v = self.archive_rules.unwrap_or_default();
            v.push(input.into());
            self.archive_rules = Some(v);
            self
        }
        /// <p>A list of archive rules created for the specified analyzer.</p>
        pub fn set_archive_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ArchiveRuleSummary>>,
        ) -> Self {
            self.archive_rules = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListArchiveRulesOutput`](crate::output::ListArchiveRulesOutput)
        pub fn build(self) -> crate::output::ListArchiveRulesOutput {
            crate::output::ListArchiveRulesOutput {
                archive_rules: self.archive_rules,
                next_token: self.next_token,
            }
        }
    }
}
impl ListArchiveRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListArchiveRulesOutput`](crate::output::ListArchiveRulesOutput)
    pub fn builder() -> crate::output::list_archive_rules_output::Builder {
        crate::output::list_archive_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateArchiveRuleOutput {}
impl std::fmt::Debug for CreateArchiveRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateArchiveRuleOutput");
        formatter.finish()
    }
}
/// See [`CreateArchiveRuleOutput`](crate::output::CreateArchiveRuleOutput)
pub mod create_archive_rule_output {
    /// A builder for [`CreateArchiveRuleOutput`](crate::output::CreateArchiveRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateArchiveRuleOutput`](crate::output::CreateArchiveRuleOutput)
        pub fn build(self) -> crate::output::CreateArchiveRuleOutput {
            crate::output::CreateArchiveRuleOutput {}
        }
    }
}
impl CreateArchiveRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateArchiveRuleOutput`](crate::output::CreateArchiveRuleOutput)
    pub fn builder() -> crate::output::create_archive_rule_output::Builder {
        crate::output::create_archive_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteArchiveRuleOutput {}
impl std::fmt::Debug for DeleteArchiveRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteArchiveRuleOutput");
        formatter.finish()
    }
}
/// See [`DeleteArchiveRuleOutput`](crate::output::DeleteArchiveRuleOutput)
pub mod delete_archive_rule_output {
    /// A builder for [`DeleteArchiveRuleOutput`](crate::output::DeleteArchiveRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteArchiveRuleOutput`](crate::output::DeleteArchiveRuleOutput)
        pub fn build(self) -> crate::output::DeleteArchiveRuleOutput {
            crate::output::DeleteArchiveRuleOutput {}
        }
    }
}
impl DeleteArchiveRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteArchiveRuleOutput`](crate::output::DeleteArchiveRuleOutput)
    pub fn builder() -> crate::output::delete_archive_rule_output::Builder {
        crate::output::delete_archive_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateArchiveRuleOutput {}
impl std::fmt::Debug for UpdateArchiveRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateArchiveRuleOutput");
        formatter.finish()
    }
}
/// See [`UpdateArchiveRuleOutput`](crate::output::UpdateArchiveRuleOutput)
pub mod update_archive_rule_output {
    /// A builder for [`UpdateArchiveRuleOutput`](crate::output::UpdateArchiveRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateArchiveRuleOutput`](crate::output::UpdateArchiveRuleOutput)
        pub fn build(self) -> crate::output::UpdateArchiveRuleOutput {
            crate::output::UpdateArchiveRuleOutput {}
        }
    }
}
impl UpdateArchiveRuleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateArchiveRuleOutput`](crate::output::UpdateArchiveRuleOutput)
    pub fn builder() -> crate::output::update_archive_rule_output::Builder {
        crate::output::update_archive_rule_output::Builder::default()
    }
}

/// <p>The response to the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetArchiveRuleOutput {
    /// <p>Contains information about an archive rule.</p>
    pub archive_rule: std::option::Option<crate::model::ArchiveRuleSummary>,
}
impl std::fmt::Debug for GetArchiveRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetArchiveRuleOutput");
        formatter.field("archive_rule", &self.archive_rule);
        formatter.finish()
    }
}
/// See [`GetArchiveRuleOutput`](crate::output::GetArchiveRuleOutput)
pub mod get_archive_rule_output {
    /// A builder for [`GetArchiveRuleOutput`](crate::output::GetArchiveRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archive_rule: std::option::Option<crate::model::ArchiveRuleSummary>,
    }
    impl Builder {
        /// <p>Contains information about an archive rule.</p>
        pub fn archive_rule(mut self, input: crate::model::ArchiveRuleSummary) -> Self {
            self.archive_rule = Some(input);
            self
        }
        /// <p>Contains information about an archive rule.</p>
        pub fn set_archive_rule(
            mut self,
            input: std::option::Option<crate::model::ArchiveRuleSummary>,
        ) -> Self {
            self.archive_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`GetArchiveRuleOutput`](crate::output::GetArchiveRuleOutput)
        pub fn build(self) -> crate::output::GetArchiveRuleOutput {
            crate::output::GetArchiveRuleOutput {
                archive_rule: self.archive_rule,
            }
        }
    }
}
impl GetArchiveRuleOutput {
    /// Creates a new builder-style object to manufacture [`GetArchiveRuleOutput`](crate::output::GetArchiveRuleOutput)
    pub fn builder() -> crate::output::get_archive_rule_output::Builder {
        crate::output::get_archive_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidatePolicyOutput {
    /// <p>The list of findings in a policy returned by IAM Access Analyzer based on its suite of policy
    /// checks.</p>
    pub findings: std::option::Option<std::vec::Vec<crate::model::ValidatePolicyFinding>>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidatePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidatePolicyOutput");
        formatter.field("findings", &self.findings);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ValidatePolicyOutput`](crate::output::ValidatePolicyOutput)
pub mod validate_policy_output {
    /// A builder for [`ValidatePolicyOutput`](crate::output::ValidatePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) findings:
            std::option::Option<std::vec::Vec<crate::model::ValidatePolicyFinding>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `findings`.
        ///
        /// To override the contents of this collection use [`set_findings`](Self::set_findings).
        ///
        /// <p>The list of findings in a policy returned by IAM Access Analyzer based on its suite of policy
        /// checks.</p>
        pub fn findings(mut self, input: impl Into<crate::model::ValidatePolicyFinding>) -> Self {
            let mut v = self.findings.unwrap_or_default();
            v.push(input.into());
            self.findings = Some(v);
            self
        }
        /// <p>The list of findings in a policy returned by IAM Access Analyzer based on its suite of policy
        /// checks.</p>
        pub fn set_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidatePolicyFinding>>,
        ) -> Self {
            self.findings = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidatePolicyOutput`](crate::output::ValidatePolicyOutput)
        pub fn build(self) -> crate::output::ValidatePolicyOutput {
            crate::output::ValidatePolicyOutput {
                findings: self.findings,
                next_token: self.next_token,
            }
        }
    }
}
impl ValidatePolicyOutput {
    /// Creates a new builder-style object to manufacture [`ValidatePolicyOutput`](crate::output::ValidatePolicyOutput)
    pub fn builder() -> crate::output::validate_policy_output::Builder {
        crate::output::validate_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFindingsOutput {}
impl std::fmt::Debug for UpdateFindingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFindingsOutput");
        formatter.finish()
    }
}
/// See [`UpdateFindingsOutput`](crate::output::UpdateFindingsOutput)
pub mod update_findings_output {
    /// A builder for [`UpdateFindingsOutput`](crate::output::UpdateFindingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateFindingsOutput`](crate::output::UpdateFindingsOutput)
        pub fn build(self) -> crate::output::UpdateFindingsOutput {
            crate::output::UpdateFindingsOutput {}
        }
    }
}
impl UpdateFindingsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFindingsOutput`](crate::output::UpdateFindingsOutput)
    pub fn builder() -> crate::output::update_findings_output::Builder {
        crate::output::update_findings_output::Builder::default()
    }
}

/// <p>The response to the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

/// <p>The response to the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartResourceScanOutput {}
impl std::fmt::Debug for StartResourceScanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartResourceScanOutput");
        formatter.finish()
    }
}
/// See [`StartResourceScanOutput`](crate::output::StartResourceScanOutput)
pub mod start_resource_scan_output {
    /// A builder for [`StartResourceScanOutput`](crate::output::StartResourceScanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartResourceScanOutput`](crate::output::StartResourceScanOutput)
        pub fn build(self) -> crate::output::StartResourceScanOutput {
            crate::output::StartResourceScanOutput {}
        }
    }
}
impl StartResourceScanOutput {
    /// Creates a new builder-style object to manufacture [`StartResourceScanOutput`](crate::output::StartResourceScanOutput)
    pub fn builder() -> crate::output::start_resource_scan_output::Builder {
        crate::output::start_resource_scan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartPolicyGenerationOutput {
    /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
    /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
    /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
    /// the policy generation request.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartPolicyGenerationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartPolicyGenerationOutput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
/// See [`StartPolicyGenerationOutput`](crate::output::StartPolicyGenerationOutput)
pub mod start_policy_generation_output {
    /// A builder for [`StartPolicyGenerationOutput`](crate::output::StartPolicyGenerationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
        /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
        /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
        /// the policy generation request.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code>
        /// operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to
        /// retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel
        /// the policy generation request.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartPolicyGenerationOutput`](crate::output::StartPolicyGenerationOutput)
        pub fn build(self) -> crate::output::StartPolicyGenerationOutput {
            crate::output::StartPolicyGenerationOutput {
                job_id: self.job_id,
            }
        }
    }
}
impl StartPolicyGenerationOutput {
    /// Creates a new builder-style object to manufacture [`StartPolicyGenerationOutput`](crate::output::StartPolicyGenerationOutput)
    pub fn builder() -> crate::output::start_policy_generation_output::Builder {
        crate::output::start_policy_generation_output::Builder::default()
    }
}

/// <p>The response to the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags that are applied to the specified resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that are applied to the specified resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags that are applied to the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPolicyGenerationsOutput {
    /// <p>A <code>PolicyGeneration</code> object that contains details about the generated
    /// policy.</p>
    pub policy_generations: std::option::Option<std::vec::Vec<crate::model::PolicyGeneration>>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListPolicyGenerationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPolicyGenerationsOutput");
        formatter.field("policy_generations", &self.policy_generations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPolicyGenerationsOutput`](crate::output::ListPolicyGenerationsOutput)
pub mod list_policy_generations_output {
    /// A builder for [`ListPolicyGenerationsOutput`](crate::output::ListPolicyGenerationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_generations:
            std::option::Option<std::vec::Vec<crate::model::PolicyGeneration>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policy_generations`.
        ///
        /// To override the contents of this collection use [`set_policy_generations`](Self::set_policy_generations).
        ///
        /// <p>A <code>PolicyGeneration</code> object that contains details about the generated
        /// policy.</p>
        pub fn policy_generations(
            mut self,
            input: impl Into<crate::model::PolicyGeneration>,
        ) -> Self {
            let mut v = self.policy_generations.unwrap_or_default();
            v.push(input.into());
            self.policy_generations = Some(v);
            self
        }
        /// <p>A <code>PolicyGeneration</code> object that contains details about the generated
        /// policy.</p>
        pub fn set_policy_generations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyGeneration>>,
        ) -> Self {
            self.policy_generations = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPolicyGenerationsOutput`](crate::output::ListPolicyGenerationsOutput)
        pub fn build(self) -> crate::output::ListPolicyGenerationsOutput {
            crate::output::ListPolicyGenerationsOutput {
                policy_generations: self.policy_generations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPolicyGenerationsOutput {
    /// Creates a new builder-style object to manufacture [`ListPolicyGenerationsOutput`](crate::output::ListPolicyGenerationsOutput)
    pub fn builder() -> crate::output::list_policy_generations_output::Builder {
        crate::output::list_policy_generations_output::Builder::default()
    }
}

/// <p>The response to the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFindingsOutput {
    /// <p>A list of findings retrieved from the analyzer that match the filter criteria specified,
    /// if any.</p>
    pub findings: std::option::Option<std::vec::Vec<crate::model::FindingSummary>>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListFindingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFindingsOutput");
        formatter.field("findings", &self.findings);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFindingsOutput`](crate::output::ListFindingsOutput)
pub mod list_findings_output {
    /// A builder for [`ListFindingsOutput`](crate::output::ListFindingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) findings: std::option::Option<std::vec::Vec<crate::model::FindingSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `findings`.
        ///
        /// To override the contents of this collection use [`set_findings`](Self::set_findings).
        ///
        /// <p>A list of findings retrieved from the analyzer that match the filter criteria specified,
        /// if any.</p>
        pub fn findings(mut self, input: impl Into<crate::model::FindingSummary>) -> Self {
            let mut v = self.findings.unwrap_or_default();
            v.push(input.into());
            self.findings = Some(v);
            self
        }
        /// <p>A list of findings retrieved from the analyzer that match the filter criteria specified,
        /// if any.</p>
        pub fn set_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FindingSummary>>,
        ) -> Self {
            self.findings = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFindingsOutput`](crate::output::ListFindingsOutput)
        pub fn build(self) -> crate::output::ListFindingsOutput {
            crate::output::ListFindingsOutput {
                findings: self.findings,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFindingsOutput {
    /// Creates a new builder-style object to manufacture [`ListFindingsOutput`](crate::output::ListFindingsOutput)
    pub fn builder() -> crate::output::list_findings_output::Builder {
        crate::output::list_findings_output::Builder::default()
    }
}

/// <p>The response to the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnalyzedResourcesOutput {
    /// <p>A list of resources that were analyzed.</p>
    pub analyzed_resources:
        std::option::Option<std::vec::Vec<crate::model::AnalyzedResourceSummary>>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListAnalyzedResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnalyzedResourcesOutput");
        formatter.field("analyzed_resources", &self.analyzed_resources);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAnalyzedResourcesOutput`](crate::output::ListAnalyzedResourcesOutput)
pub mod list_analyzed_resources_output {
    /// A builder for [`ListAnalyzedResourcesOutput`](crate::output::ListAnalyzedResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analyzed_resources:
            std::option::Option<std::vec::Vec<crate::model::AnalyzedResourceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `analyzed_resources`.
        ///
        /// To override the contents of this collection use [`set_analyzed_resources`](Self::set_analyzed_resources).
        ///
        /// <p>A list of resources that were analyzed.</p>
        pub fn analyzed_resources(
            mut self,
            input: impl Into<crate::model::AnalyzedResourceSummary>,
        ) -> Self {
            let mut v = self.analyzed_resources.unwrap_or_default();
            v.push(input.into());
            self.analyzed_resources = Some(v);
            self
        }
        /// <p>A list of resources that were analyzed.</p>
        pub fn set_analyzed_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalyzedResourceSummary>>,
        ) -> Self {
            self.analyzed_resources = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnalyzedResourcesOutput`](crate::output::ListAnalyzedResourcesOutput)
        pub fn build(self) -> crate::output::ListAnalyzedResourcesOutput {
            crate::output::ListAnalyzedResourcesOutput {
                analyzed_resources: self.analyzed_resources,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAnalyzedResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListAnalyzedResourcesOutput`](crate::output::ListAnalyzedResourcesOutput)
    pub fn builder() -> crate::output::list_analyzed_resources_output::Builder {
        crate::output::list_analyzed_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessPreviewsOutput {
    /// <p>A list of access previews retrieved for the analyzer.</p>
    pub access_previews: std::option::Option<std::vec::Vec<crate::model::AccessPreviewSummary>>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListAccessPreviewsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessPreviewsOutput");
        formatter.field("access_previews", &self.access_previews);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAccessPreviewsOutput`](crate::output::ListAccessPreviewsOutput)
pub mod list_access_previews_output {
    /// A builder for [`ListAccessPreviewsOutput`](crate::output::ListAccessPreviewsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_previews:
            std::option::Option<std::vec::Vec<crate::model::AccessPreviewSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `access_previews`.
        ///
        /// To override the contents of this collection use [`set_access_previews`](Self::set_access_previews).
        ///
        /// <p>A list of access previews retrieved for the analyzer.</p>
        pub fn access_previews(
            mut self,
            input: impl Into<crate::model::AccessPreviewSummary>,
        ) -> Self {
            let mut v = self.access_previews.unwrap_or_default();
            v.push(input.into());
            self.access_previews = Some(v);
            self
        }
        /// <p>A list of access previews retrieved for the analyzer.</p>
        pub fn set_access_previews(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessPreviewSummary>>,
        ) -> Self {
            self.access_previews = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessPreviewsOutput`](crate::output::ListAccessPreviewsOutput)
        pub fn build(self) -> crate::output::ListAccessPreviewsOutput {
            crate::output::ListAccessPreviewsOutput {
                access_previews: self.access_previews,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAccessPreviewsOutput {
    /// Creates a new builder-style object to manufacture [`ListAccessPreviewsOutput`](crate::output::ListAccessPreviewsOutput)
    pub fn builder() -> crate::output::list_access_previews_output::Builder {
        crate::output::list_access_previews_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessPreviewFindingsOutput {
    /// <p>A list of access preview findings that match the specified filter criteria.</p>
    pub findings: std::option::Option<std::vec::Vec<crate::model::AccessPreviewFinding>>,
    /// <p>A token used for pagination of results returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListAccessPreviewFindingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessPreviewFindingsOutput");
        formatter.field("findings", &self.findings);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAccessPreviewFindingsOutput`](crate::output::ListAccessPreviewFindingsOutput)
pub mod list_access_preview_findings_output {
    /// A builder for [`ListAccessPreviewFindingsOutput`](crate::output::ListAccessPreviewFindingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) findings: std::option::Option<std::vec::Vec<crate::model::AccessPreviewFinding>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `findings`.
        ///
        /// To override the contents of this collection use [`set_findings`](Self::set_findings).
        ///
        /// <p>A list of access preview findings that match the specified filter criteria.</p>
        pub fn findings(mut self, input: impl Into<crate::model::AccessPreviewFinding>) -> Self {
            let mut v = self.findings.unwrap_or_default();
            v.push(input.into());
            self.findings = Some(v);
            self
        }
        /// <p>A list of access preview findings that match the specified filter criteria.</p>
        pub fn set_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessPreviewFinding>>,
        ) -> Self {
            self.findings = input;
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used for pagination of results returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessPreviewFindingsOutput`](crate::output::ListAccessPreviewFindingsOutput)
        pub fn build(self) -> crate::output::ListAccessPreviewFindingsOutput {
            crate::output::ListAccessPreviewFindingsOutput {
                findings: self.findings,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAccessPreviewFindingsOutput {
    /// Creates a new builder-style object to manufacture [`ListAccessPreviewFindingsOutput`](crate::output::ListAccessPreviewFindingsOutput)
    pub fn builder() -> crate::output::list_access_preview_findings_output::Builder {
        crate::output::list_access_preview_findings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGeneratedPolicyOutput {
    /// <p>A <code>GeneratedPolicyDetails</code> object that contains details about the generated
    /// policy.</p>
    pub job_details: std::option::Option<crate::model::JobDetails>,
    /// <p>A <code>GeneratedPolicyResult</code> object that contains the generated policies and
    /// associated details.</p>
    pub generated_policy_result: std::option::Option<crate::model::GeneratedPolicyResult>,
}
impl std::fmt::Debug for GetGeneratedPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGeneratedPolicyOutput");
        formatter.field("job_details", &self.job_details);
        formatter.field("generated_policy_result", &self.generated_policy_result);
        formatter.finish()
    }
}
/// See [`GetGeneratedPolicyOutput`](crate::output::GetGeneratedPolicyOutput)
pub mod get_generated_policy_output {
    /// A builder for [`GetGeneratedPolicyOutput`](crate::output::GetGeneratedPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_details: std::option::Option<crate::model::JobDetails>,
        pub(crate) generated_policy_result:
            std::option::Option<crate::model::GeneratedPolicyResult>,
    }
    impl Builder {
        /// <p>A <code>GeneratedPolicyDetails</code> object that contains details about the generated
        /// policy.</p>
        pub fn job_details(mut self, input: crate::model::JobDetails) -> Self {
            self.job_details = Some(input);
            self
        }
        /// <p>A <code>GeneratedPolicyDetails</code> object that contains details about the generated
        /// policy.</p>
        pub fn set_job_details(
            mut self,
            input: std::option::Option<crate::model::JobDetails>,
        ) -> Self {
            self.job_details = input;
            self
        }
        /// <p>A <code>GeneratedPolicyResult</code> object that contains the generated policies and
        /// associated details.</p>
        pub fn generated_policy_result(
            mut self,
            input: crate::model::GeneratedPolicyResult,
        ) -> Self {
            self.generated_policy_result = Some(input);
            self
        }
        /// <p>A <code>GeneratedPolicyResult</code> object that contains the generated policies and
        /// associated details.</p>
        pub fn set_generated_policy_result(
            mut self,
            input: std::option::Option<crate::model::GeneratedPolicyResult>,
        ) -> Self {
            self.generated_policy_result = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGeneratedPolicyOutput`](crate::output::GetGeneratedPolicyOutput)
        pub fn build(self) -> crate::output::GetGeneratedPolicyOutput {
            crate::output::GetGeneratedPolicyOutput {
                job_details: self.job_details,
                generated_policy_result: self.generated_policy_result,
            }
        }
    }
}
impl GetGeneratedPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetGeneratedPolicyOutput`](crate::output::GetGeneratedPolicyOutput)
    pub fn builder() -> crate::output::get_generated_policy_output::Builder {
        crate::output::get_generated_policy_output::Builder::default()
    }
}

/// <p>The response to the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingOutput {
    /// <p>A <code>finding</code> object that contains finding details.</p>
    pub finding: std::option::Option<crate::model::Finding>,
}
impl std::fmt::Debug for GetFindingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingOutput");
        formatter.field("finding", &self.finding);
        formatter.finish()
    }
}
/// See [`GetFindingOutput`](crate::output::GetFindingOutput)
pub mod get_finding_output {
    /// A builder for [`GetFindingOutput`](crate::output::GetFindingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding: std::option::Option<crate::model::Finding>,
    }
    impl Builder {
        /// <p>A <code>finding</code> object that contains finding details.</p>
        pub fn finding(mut self, input: crate::model::Finding) -> Self {
            self.finding = Some(input);
            self
        }
        /// <p>A <code>finding</code> object that contains finding details.</p>
        pub fn set_finding(mut self, input: std::option::Option<crate::model::Finding>) -> Self {
            self.finding = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFindingOutput`](crate::output::GetFindingOutput)
        pub fn build(self) -> crate::output::GetFindingOutput {
            crate::output::GetFindingOutput {
                finding: self.finding,
            }
        }
    }
}
impl GetFindingOutput {
    /// Creates a new builder-style object to manufacture [`GetFindingOutput`](crate::output::GetFindingOutput)
    pub fn builder() -> crate::output::get_finding_output::Builder {
        crate::output::get_finding_output::Builder::default()
    }
}

/// <p>The response to the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnalyzedResourceOutput {
    /// <p>An <code>AnalyzedResource</code> object that contains information that IAM Access Analyzer
    /// found when it analyzed the resource.</p>
    pub resource: std::option::Option<crate::model::AnalyzedResource>,
}
impl std::fmt::Debug for GetAnalyzedResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnalyzedResourceOutput");
        formatter.field("resource", &self.resource);
        formatter.finish()
    }
}
/// See [`GetAnalyzedResourceOutput`](crate::output::GetAnalyzedResourceOutput)
pub mod get_analyzed_resource_output {
    /// A builder for [`GetAnalyzedResourceOutput`](crate::output::GetAnalyzedResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<crate::model::AnalyzedResource>,
    }
    impl Builder {
        /// <p>An <code>AnalyzedResource</code> object that contains information that IAM Access Analyzer
        /// found when it analyzed the resource.</p>
        pub fn resource(mut self, input: crate::model::AnalyzedResource) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>An <code>AnalyzedResource</code> object that contains information that IAM Access Analyzer
        /// found when it analyzed the resource.</p>
        pub fn set_resource(
            mut self,
            input: std::option::Option<crate::model::AnalyzedResource>,
        ) -> Self {
            self.resource = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnalyzedResourceOutput`](crate::output::GetAnalyzedResourceOutput)
        pub fn build(self) -> crate::output::GetAnalyzedResourceOutput {
            crate::output::GetAnalyzedResourceOutput {
                resource: self.resource,
            }
        }
    }
}
impl GetAnalyzedResourceOutput {
    /// Creates a new builder-style object to manufacture [`GetAnalyzedResourceOutput`](crate::output::GetAnalyzedResourceOutput)
    pub fn builder() -> crate::output::get_analyzed_resource_output::Builder {
        crate::output::get_analyzed_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPreviewOutput {
    /// <p>An object that contains information about the access preview.</p>
    pub access_preview: std::option::Option<crate::model::AccessPreview>,
}
impl std::fmt::Debug for GetAccessPreviewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPreviewOutput");
        formatter.field("access_preview", &self.access_preview);
        formatter.finish()
    }
}
/// See [`GetAccessPreviewOutput`](crate::output::GetAccessPreviewOutput)
pub mod get_access_preview_output {
    /// A builder for [`GetAccessPreviewOutput`](crate::output::GetAccessPreviewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_preview: std::option::Option<crate::model::AccessPreview>,
    }
    impl Builder {
        /// <p>An object that contains information about the access preview.</p>
        pub fn access_preview(mut self, input: crate::model::AccessPreview) -> Self {
            self.access_preview = Some(input);
            self
        }
        /// <p>An object that contains information about the access preview.</p>
        pub fn set_access_preview(
            mut self,
            input: std::option::Option<crate::model::AccessPreview>,
        ) -> Self {
            self.access_preview = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPreviewOutput`](crate::output::GetAccessPreviewOutput)
        pub fn build(self) -> crate::output::GetAccessPreviewOutput {
            crate::output::GetAccessPreviewOutput {
                access_preview: self.access_preview,
            }
        }
    }
}
impl GetAccessPreviewOutput {
    /// Creates a new builder-style object to manufacture [`GetAccessPreviewOutput`](crate::output::GetAccessPreviewOutput)
    pub fn builder() -> crate::output::get_access_preview_output::Builder {
        crate::output::get_access_preview_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessPreviewOutput {
    /// <p>The unique ID for the access preview.</p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateAccessPreviewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessPreviewOutput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`CreateAccessPreviewOutput`](crate::output::CreateAccessPreviewOutput)
pub mod create_access_preview_output {
    /// A builder for [`CreateAccessPreviewOutput`](crate::output::CreateAccessPreviewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID for the access preview.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID for the access preview.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessPreviewOutput`](crate::output::CreateAccessPreviewOutput)
        pub fn build(self) -> crate::output::CreateAccessPreviewOutput {
            crate::output::CreateAccessPreviewOutput { id: self.id }
        }
    }
}
impl CreateAccessPreviewOutput {
    /// Creates a new builder-style object to manufacture [`CreateAccessPreviewOutput`](crate::output::CreateAccessPreviewOutput)
    pub fn builder() -> crate::output::create_access_preview_output::Builder {
        crate::output::create_access_preview_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelPolicyGenerationOutput {}
impl std::fmt::Debug for CancelPolicyGenerationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelPolicyGenerationOutput");
        formatter.finish()
    }
}
/// See [`CancelPolicyGenerationOutput`](crate::output::CancelPolicyGenerationOutput)
pub mod cancel_policy_generation_output {
    /// A builder for [`CancelPolicyGenerationOutput`](crate::output::CancelPolicyGenerationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelPolicyGenerationOutput`](crate::output::CancelPolicyGenerationOutput)
        pub fn build(self) -> crate::output::CancelPolicyGenerationOutput {
            crate::output::CancelPolicyGenerationOutput {}
        }
    }
}
impl CancelPolicyGenerationOutput {
    /// Creates a new builder-style object to manufacture [`CancelPolicyGenerationOutput`](crate::output::CancelPolicyGenerationOutput)
    pub fn builder() -> crate::output::cancel_policy_generation_output::Builder {
        crate::output::cancel_policy_generation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplyArchiveRuleOutput {}
impl std::fmt::Debug for ApplyArchiveRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplyArchiveRuleOutput");
        formatter.finish()
    }
}
/// See [`ApplyArchiveRuleOutput`](crate::output::ApplyArchiveRuleOutput)
pub mod apply_archive_rule_output {
    /// A builder for [`ApplyArchiveRuleOutput`](crate::output::ApplyArchiveRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ApplyArchiveRuleOutput`](crate::output::ApplyArchiveRuleOutput)
        pub fn build(self) -> crate::output::ApplyArchiveRuleOutput {
            crate::output::ApplyArchiveRuleOutput {}
        }
    }
}
impl ApplyArchiveRuleOutput {
    /// Creates a new builder-style object to manufacture [`ApplyArchiveRuleOutput`](crate::output::ApplyArchiveRuleOutput)
    pub fn builder() -> crate::output::apply_archive_rule_output::Builder {
        crate::output::apply_archive_rule_output::Builder::default()
    }
}
