/// # aws-iot-device-client(unofficial)
use tokio::{task, time};

use rumqttc::{self, AsyncClient, Event, Incoming, Key, MqttOptions, QoS, Transport};
use std::error::Error;
use std::fs;
use std::time::Duration;

use aws_iot_device_client::config::*;

use clap::Parser;
/// Simple program to greet a person
#[derive(Parser, Debug)]
#[clap(author, version, about, long_about = None)]
struct Args {
    /// Name of the person to greet
    #[clap(short, long)]
    file: String,

    /// Number of times to greet
    #[clap(short, long, default_value_t = 1)]
    count: u8,
}

pub const HELLO_WORLD_TOPIC: &str = "hello/world";

#[tokio::main]
async fn main() -> Result<(), Box<dyn Error>> {
    let args = Args::parse();

    config_init(&args.file);
    let name = Config::global().thing_name.to_string();
    let endpoint = Config::global().endpoint.to_string();
    let ca = Config::global().root_ca.to_string();
    let cert = Config::global().cert.to_string();
    let key = Config::global().key.to_string();

    let mut mqtt_options = MqttOptions::new(name, endpoint, 8883);
    mqtt_options
        .set_keep_alive(std::time::Duration::from_secs(30))
        .set_transport(Transport::tls(
            fs::read(ca)?,
            Some((fs::read(cert)?, Key::RSA(fs::read(key)?))),
            None,
        ));

    let (client, mut eventloop) = AsyncClient::new(mqtt_options, 10);
    task::spawn(async move {
        requests(client).await;
        time::sleep(Duration::from_secs(3)).await;
    });

    loop {
        let event = eventloop.poll().await;
        println!("{:?}", event.unwrap());
    }
}

async fn requests(client: AsyncClient) {
    client
        .subscribe(HELLO_WORLD_TOPIC, QoS::AtMostOnce)
        .await
        .unwrap();

    // for i in 1..=10 {
    //     client
    //         .publish("hello/world", QoS::ExactlyOnce, false, vec![1; i])
    //         .await
    //         .unwrap();

    //     time::sleep(Duration::from_secs(1)).await;
    // }

    time::sleep(Duration::from_secs(120)).await;
}
