use std::{env, fs, io, path};

use once_cell::sync::OnceCell;
use serde::Deserialize;

// const CONFIG_FILE: &str = "configs/dc-testconn-config.toml";

#[derive(Deserialize, Debug)]
pub struct Config {
    pub endpoint: String,
    pub cert: String,
    pub key: String,
    pub root_ca: String,
    pub thing_name: String,
}
static CONFIG: OnceCell<Config> = OnceCell::new();

impl Config {
    pub fn global() -> &'static Config {
        CONFIG.get().expect("Config is not initialized")
    }

    fn from_file(p: &str) -> Result<Config, std::io::Error> {
        let config = fs::read_to_string(p).expect("Something went wrong reading the file");
        let config: Config = toml::from_str(&config).unwrap();
        print!("{:#?}", &config);
        Ok(config)
    }
}

pub fn config_init(file: &str) {
    let mut _config = Config::from_file(file).unwrap();

    CONFIG.set(_config).unwrap();
}
