use std::{env, fs, io};

use once_cell::sync::OnceCell;
use serde::Deserialize;

const CONFIG_FILE: &str = "configs/dc-testconn-config.toml";

#[derive(Deserialize, Debug)]
pub struct Config {
    pub endpoint: String,
    pub cert: String,
    pub key: String,
    pub root_ca: String,
    pub thing_name: String,
}
static CONFIG: OnceCell<Config> = OnceCell::new();

impl Config {
    pub fn global() -> &'static Config {
        CONFIG.get().expect("Config is not initialized")
    }

    fn from_file() -> Result<Config, std::io::Error> {
        let config =
            fs::read_to_string(CONFIG_FILE).expect("Something went wrong reading the file");
        let config: Config = toml::from_str(&config).unwrap();
        print!("{:#?}", &config);
        Ok(config)
    }
}

pub fn config_init() {
    let mut _config = Config::from_file().unwrap();

    CONFIG.set(_config).unwrap();
}
