use std::{env, fs, io};

use once_cell::sync::OnceCell;
use serde::Deserialize;

const CONFIG_FILE: &str = "configs/dc-testconn-config.toml";

#[derive(Deserialize, Debug)]
pub struct Config {
    pub filename: String,
}
static INSTANCE: OnceCell<Config> = OnceCell::new();

impl Config {
    pub fn global() -> &'static Config {
        INSTANCE.get().expect("Config is not initialized")
    }

    fn from_file(args: env::Args) -> Result<Config, std::io::Error> {
        let config =
            fs::read_to_string(CONFIG_FILE).expect("Something went wrong reading the file");
        let config: Config = toml::from_str(&config).unwrap();
        Ok(config)
    }
}

fn main() {
    let logger = Config::from_file(env::args()).unwrap();
    INSTANCE.set(logger).unwrap();
    // use `Config::global()` from now on
}
