# awred
A convenient derive macro for `actix_web::ResponseError` trait.

## Example
```rust
use awred::ResponseError;
use serde::Serialize;
use thiserror::Error;

#[derive(Debug, Error, ResponseError, Serialize)]
pub enum AnError {
    #[error("Requested resource was not found")]
    #[response(NOT_FOUND)]
    ResourceNotFound,

    #[error("Forbidden: {reason}")]
    #[response(FORBIDDEN)]
    Forbidden { reason: String },

    // Internal Server Error
    #[error(transparent)]
    #[serde(skip)]
    IoError(#[from] std::io::Error),
}
```

## Details
- Status codes (from `actix_web::http::StatusCode`) are specified in `#[response(...)]` attribute
- Variants without `#[response(...)]` attribute return Internal Server Error with empty body
- Response body consists of serialised error and message (`error.to_string()`)

## Error response body format
```json
{
    "error": "error",
    "message": "error.to_string()",
}
```
