/* port.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Implementation of the ports available on the ATmega4809

// Imports ===================================================================


// Declarations ==============================================================


// Code ======================================================================
pub mod porta {
  use avr_oxide::{atmel_port_tpl};

  atmel_port_tpl!(super::super::ADDR_PORTA, avr_oxide::hal::generic::port::PinIdentity::PortA,
    avr_oxide::hal::generic::port::base::AvrPortRegisterBlock, _ivr_porta_port);
}
pub mod portb {
  use avr_oxide::{atmel_port_tpl};

  atmel_port_tpl!(super::super::ADDR_PORTB, avr_oxide::hal::generic::port::PinIdentity::PortB,
    avr_oxide::hal::generic::port::base::AvrPortRegisterBlock, _ivr_portb_port);
}
pub mod portc {
  use avr_oxide::{atmel_port_tpl};

  atmel_port_tpl!(super::super::ADDR_PORTC, avr_oxide::hal::generic::port::PinIdentity::PortC,
    avr_oxide::hal::generic::port::base::AvrPortRegisterBlock, _ivr_portc_port);
}
pub mod portd {
  use avr_oxide::{atmel_port_tpl};

  atmel_port_tpl!(super::super::ADDR_PORTD, avr_oxide::hal::generic::port::PinIdentity::PortD,
    avr_oxide::hal::generic::port::base::AvrPortRegisterBlock, _ivr_portd_port);
}
pub mod porte {
  use avr_oxide::{atmel_port_tpl};

  atmel_port_tpl!(super::super::ADDR_PORTE, avr_oxide::hal::generic::port::PinIdentity::PortE,
    avr_oxide::hal::generic::port::base::AvrPortRegisterBlock, _ivr_porte_port);
}
pub mod portf {
  use avr_oxide::{atmel_port_tpl};

  atmel_port_tpl!(super::super::ADDR_PORTF, avr_oxide::hal::generic::port::PinIdentity::PortF,
    avr_oxide::hal::generic::port::base::AvrPortRegisterBlock, _ivr_portf_port);
}