/* port.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Implementation of the ports available on the ATmega328P

// Imports ===================================================================


// Declarations ==============================================================


// Code ======================================================================
pub mod portb {
  use avr_oxide::{atmel_port_tpl};

  use super::super::{ADDR_PORTB, ADDR_PCMSK0, ADDR_PCICR, ADDR_PCIFR};

  atmel_port_tpl!(ADDR_PORTB, avr_oxide::hal::generic::port::PinIdentity::PortB,
    avr_oxide::hal::generic::port::base::AvrSimplePortRegisterBlock<ADDR_PCMSK0,ADDR_PCICR,ADDR_PCIFR,0b001>, _ivr_pcint0);
}
pub mod portc {
  use avr_oxide::{atmel_port_tpl};

  use super::super::{ADDR_PORTC, ADDR_PCMSK1, ADDR_PCICR, ADDR_PCIFR};

  atmel_port_tpl!(ADDR_PORTC, avr_oxide::hal::generic::port::PinIdentity::PortC,
    avr_oxide::hal::generic::port::base::AvrSimplePortRegisterBlock<ADDR_PCMSK1,ADDR_PCICR,ADDR_PCIFR,0b010>, _ivr_pcint1);
}
pub mod portd {
  use avr_oxide::{atmel_port_tpl};

  use super::super::{ADDR_PORTD, ADDR_PCMSK2, ADDR_PCICR, ADDR_PCIFR};

  atmel_port_tpl!(ADDR_PORTD, avr_oxide::hal::generic::port::PinIdentity::PortD,
    avr_oxide::hal::generic::port::base::AvrSimplePortRegisterBlock<ADDR_PCMSK2,ADDR_PCICR,ADDR_PCIFR,0b100>, _ivr_pcint2);
}
