/* debugled.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! A debugging LED implementation.  The LED is assumed to be attached to
//! Port E, pin 2

// Imports ===================================================================

// Declarations ==============================================================
use avr_oxide::hal::generic::debugled::DebugLed;
use avr_oxide::hal::generic::port::base::AtmelPortControl;

// Code ======================================================================

pub struct PinB5DebugLed {}

impl DebugLed for PinB5DebugLed {
  #[inline(always)]
  fn on() {
    let portb = avr_oxide::hal::atmega328p::port::portb::instance();

    portb.enable_output(5);
    portb.set_high(5);
  }

  #[inline(always)]
  fn off() {
    let portb = avr_oxide::hal::atmega328p::port::portb::instance();

    portb.enable_output(5);
    portb.set_low(5);
  }

  #[inline(always)]
  fn toggle() {
    let portb = avr_oxide::hal::atmega328p::port::portb::instance();

    portb.enable_output(5);
    portb.toggle(5);
  }
}

// Tests =====================================================================
