/* cpu.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! ATmega4809-specific CPU control block implementation

// Imports ===================================================================
use avr_oxide::{atmel_cpu_tpl};

// Declarations ==============================================================
#[repr(C)]
pub struct PortmuxControl {
  pub(crate) evsysroutea: u8,
  pub(crate) cclroutea: u8,
  pub(crate) usartroutea: u8,
  pub(crate) twispiroutea: u8,
  pub(crate) tcaroutea: u8,
  pub(crate) tcbroutea: u8
}

// Code ======================================================================

atmel_cpu_tpl!(super::ADDR_CPU,super::ADDR_CLKCTRL);

/**
 * Obtain a reference to the CPU controller instance
 */
#[macro_export]
macro_rules! cpu {
  () => {
    avr_oxide::hal::atmega4809::cpu::instance()
  }
}

