/* timer.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! ATmega4809 specific implementation of the TimerControl traits for the
//! device TCBs.

// Imports ===================================================================


// Declarations ==============================================================


// Code ======================================================================
#[cfg(feature="tcb0")]
pub mod tcb0 {
  use crate::atmel_tcb;

  atmel_tcb!(super::super::ADDR_TCB0, crate::hal::generic::timer::TimerIdentity::Tcb0, _ivr_tcb0_int);
}
#[cfg(feature="tcb1")]
pub mod tcb1 {
  use crate::atmel_tcb;
  atmel_tcb!(super::super::ADDR_TCB1, crate::hal::generic::timer::TimerIdentity::Tcb1, _ivr_tcb1_int);
}
#[cfg(feature="tcb2")]
pub mod tcb2 {
  use crate::atmel_tcb;

  atmel_tcb!(super::super::ADDR_TCB2, crate::hal::generic::timer::TimerIdentity::Tcb2, _ivr_tcb2_int);
}
#[cfg(feature="tcb3")]
pub mod tcb3 {
  use crate::atmel_tcb;

  atmel_tcb!(super::super::ADDR_TCB3, crate::hal::generic::timer::TimerIdentity::Tcb3, _ivr_tcb3_int);
}
#[cfg(feature="rtc")]
pub mod rtc {
  use crate::atmel_rtc;

  atmel_rtc!(super::super::ADDR_RTC, crate::hal::generic::timer::TimerIdentity::Rtc, _ivr_rtc_pit);
}


// Tests =====================================================================
