/* mutstatic.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Mutable static singleton helper


#[macro_export]
macro_rules! mut_singleton {
  ($type:ty, $name:ident, $accessor:ident, $constructor:expr) => {

    static mut $name : Option<$type> = None;

    /**
     * Return a reference to a global singleton instance of $type.
     * Any necessary inititalisation/construction will be performed on the
     * first call to this method.
     */
    #[allow(dead_code)]
    #[inline(always)]
    pub fn $accessor() -> &'static mut $type {
      unsafe {

        crate::hal::concurrency::interrupt::isolated(||{
          if $name.is_none() {
            core::ptr::replace(&mut $name, Some($constructor));
          }

          match &mut $name {
            None => panic!(),
            Some(instance) => instance
          }
        })
      }
    }
  }
}