/* build.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Build script to shoehorn our assembly files into the build library
use std::env;
use std::path::Path;
use std::process::Command;

fn main() {
  let out_dir = env::var("OUT_DIR").unwrap();

  println!("cargo:rustc-link-search=native={}", out_dir);

  #[cfg(feature="bootable")]
  build_device_boot(&out_dir);
}

#[cfg(all(feature="atmega4809",feature="bootable"))]
fn build_device_boot(out_dir: &str) {

  let _result = Command::new("avr-as")
    .args(&["src/hal/atmega4809/boot.S",
      "-mmcu=avrxmega3", "-a",
      "-o"])
    .arg(&format!("{}/oxide-boot-atmega4809.o", out_dir))
    .output().expect("Boot Assembly failed");

  let _result = Command::new("avr-ar")
    .args(&["crus", "liboxide-boot-atmega4809.a", "oxide-boot-atmega4809.o"])
    .current_dir(&Path::new(out_dir))
    .output().expect("Packaging boot library failed");

  println!("cargo:rustc-link-lib=static=oxide-boot-atmega4809");
  println!("cargo:rerun-if-changed=src/hal/atmega4809/boot.S");
}