/* mod.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Simple IO traits (a very, very, very cutdown version of std::io)

// Imports ===================================================================


// Declarations ==============================================================
pub enum IoError {
}

pub type Result<T> = core::result::Result<T,IoError>;

pub trait Read {
  fn read(&mut self, _buf: &mut [u8]) -> crate::io::Result<usize>;
}

pub trait Write {
  fn write(&mut self, buf: &[u8]) -> crate::io::Result<usize>;
  fn flush(&mut self) -> crate::io::Result<()>;
}

// Code ======================================================================


// Tests =====================================================================
#[cfg(test)]
mod tests {
  #[allow(unused_imports)]
  use super::*;

  #[test]
  fn a_test() {}

  #[test]
  #[should_panic]
  fn a_failure_test() {
    panic!()
  }
}