/* port.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Implementation of the ports available on the ATmega4809

// Imports ===================================================================


// Declarations ==============================================================


// Code ======================================================================
pub mod porta {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(super::super::ADDR_PORTA, crate::hal::generic::port::PinIdentity::PortA, _ivr_porta_port);
}
pub mod portb {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(super::super::ADDR_PORTB, crate::hal::generic::port::PinIdentity::PortB, _ivr_portb_port);
}
pub mod portc {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(super::super::ADDR_PORTC, crate::hal::generic::port::PinIdentity::PortC, _ivr_portc_port);
}
pub mod portd {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(super::super::ADDR_PORTD, crate::hal::generic::port::PinIdentity::PortD, _ivr_portd_port);
}
pub mod porte {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(super::super::ADDR_PORTE, crate::hal::generic::port::PinIdentity::PortE, _ivr_porte_port);
}
pub mod portf {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(super::super::ADDR_PORTF, crate::hal::generic::port::PinIdentity::PortF, _ivr_portf_port);
}