/* deviceconsts.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Device-specific constants

// Imports ===================================================================
// Declarations ==============================================================
#[cfg(not(any(feature="20MHz", feature="16MHz")))]
compile_error!("A clockspeed feature (\"16MHz\", \"20MHz\") must be enabled for this crate");

#[cfg(not(any(feature="atmega4809")))]
compile_error!("A processor feature (\"atmega4809\") must be enabled for this crate");


#[cfg(feature = "atmega4809")]
pub mod memory {
  pub const FLASH_SIZE  : usize  = 49_152;
  pub const SRAM_SIZE   : usize  =  6_144;
  pub const EEPROM_SIZE : usize  =    256;
  pub const USER_SIZE   : usize  =     64;

  #[cfg(feature = "alloc_small")]
  pub mod alloc {
    pub        const HEAPSIZE : usize = 512;
    pub(crate) const SMAX     : usize = 8;
  }
  #[cfg(feature = "alloc_medium")]
  pub mod alloc {
    pub        const HEAPSIZE : usize = 1024;
    pub(crate) const SMAX     : usize = 16;
  }
  #[cfg(feature = "alloc_large")]
  pub mod alloc {
    pub        const HEAPSIZE : usize = 3072;
    pub(crate) const SMAX     : usize = 32;
  }
}

#[cfg(feature = "atmega4809")]
pub mod oxide {
  pub const MAX_THREADS : usize  = 1;
}

#[cfg(feature="20MHz")]
pub mod clock {
  pub const MASTER_CLOCK_HZ: u32         = 20_000_000; // Config'd in device fuses
  pub const MASTER_CLOCK_PRESCALER:  u8  = 10;         // We configure this on boot
  pub const MASTER_TICK_FREQ_HZ: u16     = 500;        // Desired frequency of master clock
}

#[cfg(feature="16MHz")]
pub mod clock {
  pub const MASTER_CLOCK_HZ: u32         = 16_000_000; // Config'd in device fuses
  pub const MASTER_CLOCK_PRESCALER:  u8  = 8;         // we configure this on boot
  pub const MASTER_TICK_FREQ_HZ: u16     = 500;        // Desired frequency of master clock
}


// Code ======================================================================

// Tests =====================================================================
