# Version 0.0.6
* Use custom build toolchain to work around LLVM bugs
* `[avr_oxide::main]` macro for declaring application entrypoint.
* Added source identities to the Oxide events.
* Codesize improvements, and ability to enable individual drivers with feature
  flags.
* Dynamic memory allocater (enabled with `alloc_` feature flags)
# Version 0.0.5
* Very basic mocks of devices adequate to at least allow client applications
  to run their own unit-tests using `cargo test`
* Removed all dependence on the `avr-device` HAL crates
* Serial (USART) support, with interrupt driven transmit/receive and buffering
* Watchdog timer support
* SerialPort abstraction that works with Oxide events and implements standard
  write methods (core::fmt::Write, io::Write)
* Optional global `stdout!()` macro for accessing one of the serial ports,
  enabled using the `stdout_usart0` ... `stdout_usart3` features.
* Panic handler can now print out something useful (file:line:col location)
  to the serial port, if you enabled the stdout feature.
# Version 0.0.4
* MasterClock timer tick rate now parameterised
* Support for all four Type B timers in the ATmega4809
* Main event queue supports coalescing similar events to avoid queue exhaustion
  when a series of similar events (e.g. clock ticks) arrives faster than can
  be processed.
  * Implemented for MasterClock timer events
# Version 0.0.3
* Interrupt handling for GPIO attached buttons
* Working event handling for timer and button interrupts, and a basic supervisor
# Version 0.0.2
* 'Working' CI/CD (for certain values of)
* Documentation build & avroxi.de site build
# Version 0.0.1
* Basic project skeleton in place