/* main.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! A very simple 'operating system' library for AVR devices
#![feature(llvm_asm)]
#![feature(abi_avr_interrupt)]
#![feature(naked_functions)]
#![feature(asm)]
#![feature(global_asm)]
#![feature(lang_items)]
#![feature(concat_idents)]
#![feature(const_maybe_uninit_assume_init)]
#![feature(maybe_uninit_uninit_array)]
#![feature(maybe_uninit_extra)]
#![feature(const_in_array_repeat_expressions)]

#![cfg_attr(target_arch="avr", no_std)]
pub use core_io as io;

pub mod devices;
pub mod hal;
pub mod event;
pub mod oxide;
pub mod deviceconsts;
pub(crate) mod private;
mod mutstatic;

#[cfg(feature="arduino")]
pub mod arduino;

#[cfg(feature="bootable")]
mod boot;



