/* timer.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! ATmega4809 specific implementation of the TimerControl traits for the
//! device TCBs.

// Imports ===================================================================


// Declarations ==============================================================


// Code ======================================================================
pub mod tcb0 {
  use crate::atmel_tcb;

  atmel_tcb!(super::super::ADDR_TCB0, _ivr_tcb0_int);
}

pub mod tcb1 {
  use crate::atmel_tcb;
  atmel_tcb!(super::super::ADDR_TCB1, _ivr_tcb1_int);
}

pub mod tcb2 {
  use crate::atmel_tcb;

  atmel_tcb!(super::super::ADDR_TCB2, _ivr_tcb2_int);
}

pub mod tcb3 {
  use crate::atmel_tcb;

  atmel_tcb!(super::super::ADDR_TCB3, _ivr_tcb3_int);
}


// Tests =====================================================================
