/* debugled.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! A debugging LED implementation.  The LED is assumed to be attached to
//! Port E, pin 2

// Imports ===================================================================

// Declarations ==============================================================
use crate::hal::generic::debugled::DebugLed;
use crate::hal::generic::port::base::AtmelPortControl;

// Code ======================================================================
pub struct PinE2DebugLed {}

impl DebugLed for PinE2DebugLed {
  #[inline(always)]
  fn on() {
    let porte = crate::hal::atmega4809::port::porte::instance();

    porte.enable_output(2);
    porte.set_high(2);
  }

  #[inline(always)]
  fn off() {
    let porte = crate::hal::atmega4809::port::porte::instance();

    porte.enable_output(2);
    porte.set_low(2);
  }

  #[inline(always)]
  fn toggle() {
    let porte = crate::hal::atmega4809::port::porte::instance();

    porte.enable_output(2);
    porte.toggle(2);
  }
}

pub struct PinB1DebugLed {}

impl DebugLed for PinB1DebugLed {
  #[inline(always)]
  fn on() {
    let portb = crate::hal::atmega4809::port::portb::instance();

    portb.enable_output(1);
    portb.set_high(1);
  }

  #[inline(always)]
  fn off() {
    let portb = crate::hal::atmega4809::port::portb::instance();

    portb.enable_output(1);
    portb.set_low(1);
  }

  #[inline(always)]
  fn toggle() {
    let portb = crate::hal::atmega4809::port::portb::instance();

    portb.enable_output(1);
    portb.toggle(1);
  }
}

// Tests =====================================================================
