/* boot.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Boot process for the Oxide operating system.  Initialises memory and
//! interrupt vectors, loads our hardware table, and then calls the
//! oxide_main() method provided by whoever is using our crate.

// Imports ===================================================================
use crate::hal::concurrency;
use crate::hal::concurrency::thread;
use crate::deviceconsts::clock;
use crate::hal::generic::cpu::ClockControl;

// Declarations ==============================================================
extern {
  #[cfg(feature="atmega4809")]
  fn oxide_main() -> u8;
}

// Code ======================================================================
#[no_mangle]
fn _oxide_boot() -> () {
  unsafe {
    concurrency::internal::initialise();

    #[cfg(feature="atmega4809")]
    crate::hal::atmega4809::cpu::clock().clk_per_prescaler(clock::MASTER_CLOCK_PRESCALER);

    let _jh = thread::spawn_threadunsafe(||{
      #[cfg(feature="atmega4809")]
      oxide_main()
    });

    concurrency::internal::run_scheduler();
  }
}
