/* timer.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! ATmega4809 specific implementation of the TimerControl traits for the
//! device TCBs.

// Imports ===================================================================


// Declarations ==============================================================


// Code ======================================================================
pub mod tcb0 {
  use crate::atmel_tcb;

  atmel_tcb!(avr_device::atmega4809::TCB0::PTR, _ivr_tcb0_int);
}

pub mod tcb1 {
  use crate::atmel_tcb;
  atmel_tcb!(avr_device::atmega4809::TCB1::PTR, _ivr_tcb1_int);
}

pub mod tcb2 {
  use crate::atmel_tcb;

  atmel_tcb!(avr_device::atmega4809::TCB2::PTR, _ivr_tcb2_int);
}

pub mod tcb3 {
  use crate::atmel_tcb;

  atmel_tcb!(avr_device::atmega4809::TCB3::PTR, _ivr_tcb3_int);
}


// Tests =====================================================================
