/* hardware.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */


// Imports ===================================================================
use crate::hal::atmega4809;
use crate::mut_singleton;

// Declarations ==============================================================
pub struct Hardware {
  pub timerb0: &'static mut atmega4809::timer::tcb0::TimerImpl,
  pub timerb1: &'static mut atmega4809::timer::tcb1::TimerImpl,
  pub timerb2: &'static mut atmega4809::timer::tcb2::TimerImpl,
  pub timerb3: &'static mut atmega4809::timer::tcb3::TimerImpl,

  pub porta: &'static atmega4809::port::porta::PortImpl,
  pub portb: &'static atmega4809::port::portb::PortImpl,
  pub portc: &'static atmega4809::port::portc::PortImpl,
  pub portd: &'static atmega4809::port::portd::PortImpl,
  pub porte: &'static atmega4809::port::porte::PortImpl,
  pub portf: &'static atmega4809::port::portf::PortImpl
}

// Code ======================================================================
mut_singleton!(Hardware, HARDWARE, instance,
  Hardware {
    timerb0: atmega4809::timer::tcb0::instance(),
    timerb1: atmega4809::timer::tcb1::instance(),
    timerb2: atmega4809::timer::tcb2::instance(),
    timerb3: atmega4809::timer::tcb3::instance(),
    porta: atmega4809::port::porta::instance(),
    portb: atmega4809::port::portb::instance(),
    portc: atmega4809::port::portc::instance(),
    portd: atmega4809::port::portd::instance(),
    porte: atmega4809::port::porte::instance(),
    portf: atmega4809::port::portf::instance(),
  }
);
