/* deviceconsts.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Device-specific constants

// Imports ===================================================================
use static_assertions::const_assert;

// Declarations ==============================================================
#[cfg(not(any(feature="20MHz", feature="16MHz")))]
compile_error!("A clockspeed feature (\"16MHz\", \"20MHz\") must be enabled for this crate");

#[cfg(all(feature="20MHz", feature="16MHz"))]
compile_error!("Only one clockspeed feature (\"16MHz\", \"20MHz\") may be enabled for this crate");

#[cfg(not(any(feature="atmega4809")))]
compile_error!("A processor feature (\"atmega4809\") must be enabled for this crate");


#[cfg(feature = "atmega4809")]
pub mod memory {
  pub const FLASH_SIZE  : usize  = 49_152;
  pub const SRAM_SIZE   : usize  =  6_144;
  pub const EEPROM_SIZE : usize  =    256;
  pub const USER_SIZE   : usize  =     64;
}

#[cfg(feature="20MHz")]
pub mod clock {
  pub const MASTER_CLOCK_HZ: u32         = 20_000_000; // Config'd in device fuses
  pub const MASTER_CLOCK_PRESCALER:  u8  = 6;          // Device default (per datasheet)
  pub const MASTER_TICK_FREQ_HZ: u32     = 954;        // Desired frequency of master clock
}

#[cfg(feature="16MHz")]
pub mod clock {
  pub const MASTER_CLOCK_HZ: u32         = 16_000_000; // Config'd in device fuses
  pub const MASTER_CLOCK_PRESCALER:  u8  = 6;          // Device default (per datasheet)
  pub const MASTER_TICK_FREQ_HZ: u32     = 924;        // Desired frequency of master clock
}


// Code ======================================================================
const_assert!(clock::MASTER_CLOCK_HZ > 0);
const_assert!(clock::MASTER_CLOCK_PRESCALER > 0);
const_assert!(clock::MASTER_TICK_FREQ_HZ > 0);




// Tests =====================================================================
