/* arduino.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! A helper module that maps standard ATmega pins into equivalent Arduino
//! names.


// Imports ===================================================================

// Declarations ==============================================================
#[cfg(feature="atmega4809")]
pub mod nanoevery {
  use crate::hal::atmega4809::hardware::Hardware;
  use crate::hal::atmega4809;

  pub struct Arduino {

    pub timer0: &'static mut atmega4809::timer::tcb0::TimerImpl,
    pub timer1: &'static mut atmega4809::timer::tcb1::TimerImpl,
    pub timer2: &'static mut atmega4809::timer::tcb2::TimerImpl,
    pub timer3: &'static mut atmega4809::timer::tcb3::TimerImpl,

    pub a0: &'static mut atmega4809::port::portd::PinImpl,
    pub a1: &'static mut atmega4809::port::portd::PinImpl,
    pub a2: &'static mut atmega4809::port::portd::PinImpl,
    pub a3: &'static mut atmega4809::port::portd::PinImpl,
    pub a4: &'static mut atmega4809::port::porta::PinImpl,
    pub a5: &'static mut atmega4809::port::porta::PinImpl,
    pub a6: &'static mut atmega4809::port::portd::PinImpl,
    pub a7: &'static mut atmega4809::port::portd::PinImpl,

    pub d0: &'static mut atmega4809::port::portc::PinImpl,
    pub d1: &'static mut atmega4809::port::portc::PinImpl,
    pub d2: &'static mut atmega4809::port::porta::PinImpl,
    pub d3: &'static mut atmega4809::port::portf::PinImpl,
    pub d4: &'static mut atmega4809::port::portc::PinImpl,
    pub d5: &'static mut atmega4809::port::portb::PinImpl,
    pub d6: &'static mut atmega4809::port::portf::PinImpl,
    pub d7: &'static mut atmega4809::port::porta::PinImpl,
    pub d8: &'static mut atmega4809::port::porte::PinImpl,
    pub d9: &'static mut atmega4809::port::portb::PinImpl,
    pub d10: &'static mut atmega4809::port::portb::PinImpl,
    pub d11: &'static mut atmega4809::port::porte::PinImpl,
    pub d12: &'static mut atmega4809::port::porte::PinImpl,
    pub d13: &'static mut atmega4809::port::porte::PinImpl,
  }


  impl From<&'static mut crate::hal::atmega4809::hardware::Hardware> for Arduino {
    fn from(avr: &'static mut Hardware) -> Self {
      Arduino {
        timer0: avr.timerb0,
        timer1: avr.timerb1,
        timer2: avr.timerb2,
        timer3: avr.timerb3,

        a0: atmega4809::port::portd::pin_instance(3),
        a1: atmega4809::port::portd::pin_instance(2),
        a2: atmega4809::port::portd::pin_instance(1),
        a3: atmega4809::port::portd::pin_instance(0),
        a4: atmega4809::port::porta::pin_instance(2),
        a5: atmega4809::port::porta::pin_instance(3),
        a6: atmega4809::port::portd::pin_instance(4),
        a7: atmega4809::port::portd::pin_instance(5),
        d0: atmega4809::port::portc::pin_instance(4),
        d1: atmega4809::port::portc::pin_instance(5),
        d2: atmega4809::port::porta::pin_instance(0),
        d3: atmega4809::port::portf::pin_instance(5),
        d4: atmega4809::port::portc::pin_instance(6),
        d5: atmega4809::port::portb::pin_instance(2),
        d6: atmega4809::port::portf::pin_instance(4),
        d7: atmega4809::port::porta::pin_instance(1),
        d8: atmega4809::port::porte::pin_instance(3),
        d9: atmega4809::port::portb::pin_instance(0),
        d10: atmega4809::port::portb::pin_instance(1),
        d11: atmega4809::port::porte::pin_instance(0),
        d12: atmega4809::port::porte::pin_instance(1),
        d13: atmega4809::port::porte::pin_instance(2)
      }
    }
  }
}
// Tests =====================================================================
