/* mod.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Generic traits for the various devices that can be attached to our AVR
//! device

pub mod timer;
pub mod port;
pub mod debugled;


#[allow(unused_assignments)]
#[cfg(target_arch="avr")]
pub(in crate) fn busy_loop(mut c: u16) {
  unsafe {
    llvm_asm!("1: sbiw $0,1\n\tbrne 1b"
                     : "=w"(c)
                     : "0"(c)
                     :
                     : "volatile"
                 );
  }
}

#[cfg(not(target_arch="avr"))]
pub(in crate) fn busy_loop(mut c: u16) {
  let mut count = 0u16;
  let mut volatile = &mut count as *mut u16;

  for _i in 0..c {
    unsafe {
      std::ptr::write_volatile(volatile, count+1);
    }
  }
}

#[lang = "eh_personality"]
#[no_mangle]
#[cfg(target_arch="avr")]
pub unsafe extern "C" fn rust_eh_personality() -> () {
}
