/* concurrency.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! @todo documentation for this module
//!
//!

// Imports ===================================================================
#[cfg(not(target_arch="avr"))]
pub mod imp {
  pub struct MutexRc<A> {
    inner: core::cell::RefCell<A>
  }

  pub struct CriticalSection {
  }

  pub fn atomic<F,R>(f: F) -> R
  where
    F: FnOnce(&CriticalSection) -> R
  {
    println!("ATOMIC SECTION");
    let res = f(&CriticalSection {});
    println!("END OF ATOMIC SECTION");
    res
  }

  pub unsafe fn enable_interrupts() {
    println!("ENABLED INTERRUPTS");
  }
  pub unsafe fn disable_interrupts() {
    println!("DISABLED INTERRUPTS");
  }

  pub fn wait_for_interrupt() {
    std::thread::sleep(std::time::Duration::from_millis(100));
  }

  impl<A> MutexRc<A> {
    pub const fn new(contains: A) -> Self {
      MutexRc {
        inner: core::cell::RefCell::new(contains)
      }
    }

    pub fn borrow<'cs>(&'cs self, cs: &'cs CriticalSection) -> core::cell::Ref<'cs,A> {
      self.inner.borrow()
    }

    pub fn borrow_mut<'cs>(&'cs self, cs: &'cs CriticalSection) -> core::cell::RefMut<'cs,A> {
      self.inner.borrow_mut()
    }
  }
}

#[cfg(target_arch="avr")]
pub mod imp {
  #[cfg(feature="atmega4809")]
  extern crate avr_device_snowgoons as avr_device;
  #[cfg(not(feature="atmega4809"))]
  extern crate avr_device_mainline as avr_device;

  pub struct MutexRc<A> {
    inner: avr_device::interrupt::Mutex<core::cell::RefCell<A>>
  }

  impl<A> MutexRc<A> {
    pub const fn new(contains: A) -> Self {
      MutexRc {
        inner: avr_device::interrupt::Mutex::new(core::cell::RefCell::new(contains))
      }
    }

    pub fn borrow<'cs>(&'cs self, cs: &'cs avr_device::interrupt::CriticalSection) -> core::cell::Ref<'cs,A> {
      self.inner.borrow(cs).borrow()
    }

    pub fn borrow_mut<'cs>(&'cs self, cs: &'cs avr_device::interrupt::CriticalSection) -> core::cell::RefMut<'cs,A> {
      self.inner.borrow(cs).borrow_mut()
    }
  }

  #[inline(always)]
  pub fn atomic<F,R>(f: F) -> R
  where
    F: FnOnce(&avr_device::interrupt::CriticalSection) -> R
  {
    avr_device::interrupt::free(f)
  }

  #[inline(always)]
  pub unsafe fn enable_interrupts(){
    llvm_asm!("sei" :::: "volatile")
  }

  #[inline(always)]
  pub unsafe fn disable_interrupts() {
    llvm_asm!("cli" :::: "volatile")
  }

  #[inline(always)]
  pub fn wait_for_interrupt() {
    unsafe {
      llvm_asm!("sleep");
    }
  }

}


// Declarations ==============================================================


// Code ======================================================================


// Tests =====================================================================
