/* port.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Implementation of the ports available on the ATmega4809

// Imports ===================================================================


// Declarations ==============================================================


// Code ======================================================================
pub mod porta {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(avr_device::atmega4809::PORTA::PTR, _ivr_porta_port);
}
pub mod portb {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(avr_device::atmega4809::PORTB::PTR, _ivr_portb_port);
}
pub mod portc {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(avr_device::atmega4809::PORTC::PTR, _ivr_portc_port);
}
pub mod portd {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(avr_device::atmega4809::PORTD::PTR, _ivr_portd_port);
}
pub mod porte {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(avr_device::atmega4809::PORTE::PTR, _ivr_porte_port);
}

pub mod portf {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(avr_device::atmega4809::PORTF::PTR, _ivr_portf_port);
}