/* mod.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! ATmega4809 implementations of the generic device traits
use crate::hal::generic::debugled::DebugLed;

pub mod timer;
pub mod port;
pub mod hardware;
pub mod debugled;


#[cfg(feature="panic_handler")]
#[panic_handler]
#[cfg(target_arch="avr")]
fn panic(_info: &core::panic::PanicInfo) -> ! {
  loop {
    crate::hal::atmega4809::debugled::PinE2DebugLed::toggle();
    for _i in 0..255 {
      crate::hal::generic::busy_loop(255);
    }
  }
}