/* led.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Simple abstraction of an LED attached to a GPIO pin.

// Imports ===================================================================
use crate::hal::generic::port::{Pin, PinMode, InterruptMode};

// Declarations ==============================================================
pub struct Led<P>
where
  P: 'static + Pin
{
  pin: &'static mut P
}

// Code ======================================================================
impl<P> Led<P>
where
  P: Pin
{
  pub fn using_pin(pin: &'static mut P) -> Self {
    pin.set_mode(PinMode::Output);
    pin.set_interrupt_mode(InterruptMode::Disabled);
    Led { pin }
  }

  pub fn set_on(&mut self) {
    self.pin.set_high();
  }

  pub fn set_off(&mut self) {
    self.pin.set_low();
  }

  pub fn set(&mut self, on: bool) {
    match on {
      true => self.set_on(),
      false => self.set_off()
    }
  }

  pub fn toggle(&mut self) {
    self.pin.toggle()
  }
}
