/* boot.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Boot process for the Oxide operating system.  Initialises memory and
//! interrupt vectors, loads our hardware table, and then calls the
//! oxide_main(&hardware) method provided by whoever is using our crate.

// Imports ===================================================================

// Declarations ==============================================================
extern {
  #[cfg(feature="atmega4809")]
  fn oxide_main() -> ();
}

// Code ======================================================================
#[no_mangle]
fn _oxide_boot() -> () {
  unsafe {
    #[cfg(feature="atmega4809")]
    oxide_main()
  }
}
