/* main.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! A very simple 'operating system' library for AVR devices
#![feature(llvm_asm)]
#![feature(abi_avr_interrupt)]
#![feature(naked_functions)]
#![feature(asm)]
#![feature(global_asm)]
#![feature(lang_items)]

#![cfg_attr(target_arch="avr", no_std)]

pub mod devices;
pub mod hal;
pub mod event;
pub mod supervisor;
pub mod deviceconsts;
mod mutstatic;
mod ringq;

#[cfg(feature="arduino")]
pub mod arduino;

#[cfg(feature="bootable")]
mod boot;



