/* port.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Implementation of the ports available on the ATmega4809

// Imports ===================================================================


// Declarations ==============================================================


// Code ======================================================================
pub mod porta {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(avr_device::atmega4809::porta::RegisterBlock, avr_device::atmega4809::PORTA::ptr(), ddra_set, ddra_clr, porta_set, porta_clr, porta_tgl);
}

pub mod portb {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(avr_device::atmega4809::portb::RegisterBlock, avr_device::atmega4809::PORTB::ptr(), ddrb_set, ddrb_clr, portb_set, portb_clr, portb_tgl);
}

pub mod portc {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(avr_device::atmega4809::portc::RegisterBlock, avr_device::atmega4809::PORTC::ptr(), ddrc_set, ddrc_clr, portc_set, portc_clr, portc_tgl);
}

pub mod portd {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(avr_device::atmega4809::portd::RegisterBlock, avr_device::atmega4809::PORTD::ptr(), ddrd_set, ddrd_clr, portd_set, portd_clr, portd_tgl);
}

pub mod porte {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(avr_device::atmega4809::porte::RegisterBlock, avr_device::atmega4809::PORTE::ptr(), ddre_set, ddre_clr, porte_set, porte_clr, porte_tgl);
}

pub mod portf {
  use crate::{atmel_port_tpl};

  atmel_port_tpl!(avr_device::atmega4809::portf::RegisterBlock, avr_device::atmega4809::PORTF::ptr(), ddrf_set, ddrf_clr, portf_set, portf_clr, portf_tgl);
}