/* debugled.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! A debugging LED implementation.  The LED is assumed to be attached to
//! Port E, pin 2

// Imports ===================================================================

// Declarations ==============================================================
extern crate avr_device_snowgoons as avr_device;
use crate::hal::generic::debugled::DebugLed;

// Code ======================================================================
pub struct PinE2DebugLed {}

impl DebugLed for PinE2DebugLed {
  #[inline(always)]
  fn on() {
    unsafe {
      let pcbe = &*avr_device::atmega4809::PORTE::ptr();

      pcbe.ddre_set.write(|w| w.bits(0b00000100));
      pcbe.porte_set.write(|w| w.bits(0b00000100));
    }
  }

  #[inline(always)]
  fn off() {
    unsafe {
      let pcbe = &*avr_device::atmega4809::PORTE::ptr();

      pcbe.ddre_set.write(|w| w.bits(0b00000100));
      pcbe.porte_clr.write(|w| w.bits(0b00000100));
    }
  }

  #[inline(always)]
  fn toggle() {
    unsafe {
      let pcbe = &*avr_device::atmega4809::PORTE::ptr();

      pcbe.ddre_set.write(|w| w.bits(0b00000100));
      pcbe.porte_tgl.write(|w| w.bits(0b00000100));
    }
  }
}

pub struct PinB1DebugLed {}

impl DebugLed for PinB1DebugLed {
  #[inline(always)]
  fn on() {
    unsafe {
      let pcbb = &*avr_device::atmega4809::PORTB::ptr();

      pcbb.ddrb_set.write(|w| w.bits(0b00000010));
      pcbb.portb_set.write(|w| w.bits(0b00000010));
    }
  }

  #[inline(always)]
  fn off() {
    unsafe {
      let pcbb = &*avr_device::atmega4809::PORTB::ptr();

      pcbb.ddrb_set.write(|w| w.bits(0b00000010));
      pcbb.portb_clr.write(|w| w.bits(0b00000010));
    }
  }

  #[inline(always)]
  fn toggle() {
    unsafe {
      let pcbb = &*avr_device::atmega4809::PORTB::ptr();

      pcbb.ddrb_set.write(|w| w.bits(0b00000010));
      pcbb.portb_tgl.write(|w| w.bits(0b00000010));
    }
  }
}

// Tests =====================================================================
